import{s as La,n as Na,o as Sa}from"../chunks/scheduler.1f027d5a.js";import{S as Pa,i as Da,e as i,s as n,c as r,h as Ka,a as o,d as l,b as a,f as qa,g as d,j as p,k as Ya,l as Oa,m as s,n as M,t as m,o as u,p as c}from"../chunks/index.5cb6ce42.js";import{D as ei,C as h}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as g,E as ti}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function li(Jn){let y,Et,Vt,Ft,T,zt,f,At,w,bn='<strong><em>Authored by: <a href="https://huggingface.co/zamal" rel="nofollow">Zamal Babar</a></em></strong>',Qt,j,Un="In this notebook, we walk through a complete <strong>end-to-end implementation</strong> of a lightweight, fast, and open-source <strong>GitHub tag generator</strong> using <strong>T5-small</strong> fine-tuned on a custom dataset with <strong>PEFT (LoRA)</strong>. This tool can automatically generate relevant tags from a GitHub repository description or summary — useful for improving discoverability and organizing repos more intelligently.",qt,Yt,Lt,J,Nt,b,In="Imagine you’re building a tool that helps users explore GitHub repositories more effectively. Instead of relying on manually written or sometimes missing tags, we train a model that <strong>automatically generates descriptive tags</strong> for any GitHub project. This could help:",St,U,Cn="<li>Improve search functionality</li> <li>Automatically tag new repos</li> <li>Build better filters for discovery</li>",Pt,Dt,Kt,I,Ot,C,vn="We use a dataset of GitHub project descriptions and their associated tags. Each training example contains:",el,v,$n="<li><code>&quot;input&quot;</code>: A natural language description of a GitHub repository</li> <li><code>&quot;target&quot;</code>: A comma-separated list of relevant tags</li>",tl,$,Gn=`The dataset was initially loaded from a local <code>.jsonl</code> file, but is now also available on the Hugging Face Hub here:<br/>
➡️ <a href="https://huggingface.co/datasets/zamal/github-meta-data" rel="nofollow"><code>zamal/github-meta-data</code></a>`,ll,sl,nl,G,al,Z,Zn=`We fine-tuned the <a href="https://huggingface.co/t5-small" rel="nofollow"><code>T5-small</code></a> model for this task — a lightweight encoder-decoder transformer that’s well-suited for text-to-text generation tasks.<br/>
To make fine-tuning faster and more efficient, we used the 🤗 <code>peft</code> library with <strong>LoRA (Low-Rank Adaptation)</strong> to update only a subset of model parameters.`,il,ol,pl,k,rl,W,kn="This notebook includes:",dl,R,Wn="<li>✅ Loading and preprocessing a custom dataset</li> <li>✅ Setting up a T5-small model with LoRA</li> <li>✅ Training the model using the Hugging Face <code>Trainer</code></li> <li>✅ Monitoring progress with <strong>Weights &amp; Biases</strong></li> <li>✅ Saving and pushing the model to the Hugging Face Hub</li> <li>✅ Performing inference and postprocessing for clean, deduplicated tags</li>",Ml,ml,ul,_,cl,B,Rn="By the end of this notebook, you’ll have:",gl,x,_n="<li>🚀 A fully trained and hosted GitHub tag generator</li> <li>🔁 A deployable and shareable model on Hugging Face Hub</li> <li>🧠 An inference function to use your model anywhere with just a few lines of code</li>",hl,H,Bn="Let’s dive in! 🎯",yl,V,xn="We begin by:",Tl,X,Hn="<li>Importing essential libraries for model training (<code>transformers</code>, <code>datasets</code>, <code>peft</code>)</li> <li>Loading the T5 tokenizer</li> <li>Setting the Hugging Face token (stored securely in Colab’s <code>userdata</code>)</li>",fl,E,Vn="Make sure you’ve stored your <code>HUGGINGFACE_TOKEN</code> in your Colab’s secrets before running this cell.",wl,F,jl,z,Jl,A,bl,Q,Ul,q,Xn="We now load our training data from a local JSONL file that contains repository descriptions and their corresponding tags.",Il,Y,En="Each line in the file is a JSON object with two fields:",Cl,L,Fn="<li><code>input</code>: a short repository description</li> <li><code>target</code>: the tags (comma-separated)</li>",vl,N,zn="We split this dataset into training and validation sets using a 90/10 ratio.",$l,S,An='🔁 <em>Note</em>: When this notebook was initially run, the dataset was loaded locally from a file. However, the same dataset is now also available on the Hugging Face Hub here: <a href="https://huggingface.co/datasets/zamal/github-meta-data" rel="nofollow">zamal/github-meta-data</a>. Feel free to load it directly using <code>load_dataset(&quot;zamal/github-meta-data&quot;)</code> in your workflow as shown below.',Gl,P,Zl,D,kl,K,Qn=`552
62
`,Wl,O,Rl,ee,qn="We load the tokenizer associated with the <code>t5-small</code> model. T5 expects input and output text to be tokenized in a specific way, and this tokenizer ensures compatibility during training and inference.",_l,te,Bl,le,xl,se,Yn="Next, we define a preprocessing function to tokenize both the inputs and the targets using the T5 tokenizer.",Hl,ne,Ln="<li>The inputs are padded and truncated to a maximum length of 128 tokens.</li> <li>The target labels (i.e., tags) are also tokenized with a shorter maximum length of 64 tokens.</li>",Vl,ae,Nn="We then map this preprocessing function across our training and validation datasets and format the output for PyTorch compatibility. This prepares the dataset for training.",Xl,ie,El,oe,Fl,pe,zl,re,Sn="We load the base T5 model (<code>t5-small</code>) for conditional generation. This model serves as the backbone for our tag generation task, where the goal is to generate relevant tags given a description of a GitHub repository.",Al,de,Ql,Me,ql,me,Pn="We configure LoRA (Low-Rank Adaptation) to fine-tune the T5 model efficiently. LoRA injects trainable low-rank matrices into attention layers, significantly reducing the number of trainable parameters while maintaining performance.",Yl,ue,Dn="In this setup:",Ll,ce,Kn="<li><code>r=16</code> defines the rank of the update matrices.</li> <li><code>lora_alpha=32</code> scales the updates.</li> <li>We apply LoRA to the <code>&quot;q&quot;</code> and <code>&quot;v&quot;</code> attention projection modules.</li> <li>The task type is set to <code>&quot;SEQ_2_SEQ_LM&quot;</code> since we’re working on a sequence-to-sequence task.</li>",Nl,ge,Sl,he,Pl,ye,On="Now that we’ve defined our LoRA configuration, we apply it to the base T5 model using <code>get_peft_model()</code>. This wraps the original model with the LoRA adapters, allowing us to fine-tune only a small number of parameters instead of the entire model—making training faster and more memory-efficient.",Dl,Te,Kl,fe,Ol,we,ea="We use the <code>TrainingArguments</code> class to define the hyperparameters and training behavior for our model. Here’s a breakdown of each parameter:",es,je,ta=`<li><p><strong><code>output_dir=&quot;./t5_tag_generator&quot;</code></strong><br/>
Directory to save model checkpoints and training logs.</p></li> <li><p><strong><code>per_device_train_batch_size=8</code></strong><br/>
Number of training samples per GPU/TPU core (or CPU) in each training step.</p></li> <li><p><strong><code>per_device_eval_batch_size=8</code></strong><br/>
Number of evaluation samples per GPU/TPU core (or CPU) in each evaluation step.</p></li> <li><p><strong><code>learning_rate=1e-4</code></strong><br/>
Initial learning rate. A good starting point for T5 models with LoRA.</p></li> <li><p><strong><code>num_train_epochs=25</code></strong><br/>
Total number of training epochs. This is relatively high to ensure convergence for our use case.</p></li> <li><p><strong><code>logging_steps=10</code></strong><br/>
How often (in steps) to log training metrics to the console and W&amp;B.</p></li> <li><p><strong><code>eval_strategy=&quot;steps&quot;</code></strong><br/>
Run evaluation every <code>eval_steps</code> instead of after every epoch.</p></li> <li><p><strong><code>eval_steps=50</code></strong><br/>
Evaluate the model every 50 steps to monitor progress during training.</p></li> <li><p><strong><code>save_steps=50</code></strong><br/>
Save model checkpoints every 50 steps for redundancy and safe restoration.</p></li> <li><p><strong><code>save_total_limit=2</code></strong><br/>
Keep only the 2 most recent model checkpoints to save disk space.</p></li> <li><p><strong><code>fp16=True</code></strong><br/>
Enable mixed precision training (faster and memory-efficient on supported GPUs).</p></li> <li><p><strong><code>push_to_hub=True</code></strong><br/>
Automatically push the trained model to the Hugging Face Hub.</p></li> <li><p><strong><code>hub_model_id=&quot;zamal/github-tag-generatorr&quot;</code></strong><br/>
The model repo name on Hugging Face under your username. This is where checkpoints and final model weights will be pushed.</p></li> <li><p><strong><code>hub_token=os.environ[&#39;HUGGINGFACE_TOKEN&#39;]</code></strong><br/>
Token to authenticate your Hugging Face account. We securely retrieve this from the environment.</p></li>`,ts,Je,la="This setup ensures a balance between training efficiency, frequent monitoring, and safe saving of model progress.",ls,be,ss,Ue,ns,Ie,sa="We now configure the <code>Trainer</code>, which abstracts away the training loop, evaluation steps, logging, and saving. It handles all of it for us using the parameters we’ve defined earlier.",as,Ce,na="We also pass in the <code>DataCollatorForSeq2Seq</code>, which ensures proper padding and batching during training and evaluation for sequence-to-sequence tasks like ours.",is,ve,os,$e,aa=`<li><p><strong><code>FutureWarning: &#39;tokenizer&#39; is deprecated...</code></strong><br/>
As of Transformers v5.0.0, the <code>tokenizer</code> argument in <code>Trainer</code> is deprecated. Instead, Hugging Face recommends using the <code>processing_class</code>, which refers to a processor that combines tokenization and potentially feature extraction. For now, it’s safe to ignore this, but it’s good practice to track deprecations for future compatibility.</p></li> <li><p><strong><code>No label_names provided for model class &#39;PeftModelForSeq2SeqLM&#39;</code></strong><br/>
This warning appears because we’re using a <a href="https://huggingface.co/docs/peft" rel="nofollow">PEFT (Parameter-Efficient Fine-Tuning)</a> wrapped model (<code>PeftModelForSeq2SeqLM</code>), and the <code>Trainer</code> cannot automatically determine the label field names in this case.<br/>
Since we’re already formatting our dataset correctly (by explicitly setting <code>labels</code> during preprocessing), this warning can be safely ignored as well — training will still proceed correctly.</p></li>`,ps,Ge,ia="Now, we can initialize our <code>Trainer</code>:",rs,Ze,ds,ke,Ms,We,oa="With everything set up — the model, tokenizer, dataset, LoRA configuration, training arguments, and the <code>Trainer</code> — we can now kick off the fine-tuning process by calling <code>trainer.train()</code>.",ms,Re,pa="This will:",us,_e,ra="<li>Fine-tune our <strong>T5 model</strong> using the <strong>parameter-efficient LoRA strategy</strong>.</li> <li>Save checkpoints at regular intervals (<code>save_steps=50</code>).</li> <li>Evaluate on the validation set every 50 steps (<code>eval_steps=50</code>).</li> <li>Log metrics like loss to <strong>Weights &amp; Biases</strong> or the Hugging Face Hub if integrated.</li>",cs,Be,da="Training will take some time depending on the size of your dataset and GPU, but you’ll start to see metrics printed out step-by-step, such as:",gs,xe,Ma="<li><code>Training Loss</code>: how well the model is fitting the training data.</li> <li><code>Validation Loss</code>: how well the model performs on unseen data.</li>",hs,He,ma="Let’s begin the fine-tuning! 👇",ys,Ve,Ts,Xe,ua=`··········
`,fs,Ee,ws,Fe,ca="The training process successfully completed over <strong>25 epochs</strong>, using a LoRA-fine-tuned <code>T5-small</code> model to generate tags for GitHub repository descriptions. Here’s a quick breakdown of what happened and how to interpret it:",js,ze,Js,Ae,ga=`We logged all training metrics and artifacts using <a href="https://wandb.ai/" rel="nofollow">Weights &amp; Biases</a>, which offers a convenient UI to monitor model performance in real time. You can view the run at:
👉 <a href="https://wandb.ai/zamalbabar9866-fau-erlangen-n-rnberg/huggingface/runs/3uv5wis6" rel="nofollow">W&amp;B Project Run</a>`,bs,Qe,Us,qe,ha="From the logs:",Is,Ye,ya="<li><strong>Training loss</strong> began at 8.9 (random init) and steadily declined to ~1.06.</li> <li><strong>Validation loss</strong> also dropped consistently from 7.9 to <strong>0.95</strong>, indicating good generalization and minimal overfitting.</li>",Cs,Le,Ta="The slight fluctuations (e.g., at steps 850, 1000, 1100) are normal and reflect natural variance in optimization, especially with small batch sizes.",vs,Ne,$s,Se,fa="<li>The warning about <code>past_key_values</code> being deprecated is safe to ignore for now and expected behavior with the current <code>transformers</code> version.</li> <li><code>UserWarning</code> about tensor creation can be optimized later, but doesn’t affect the result.</li> <li>The <code>run_name</code> warning suggests you can optionally decouple logging folder names from output directories.</li>",Gs,Pe,Zs,De,wa="The model completed:",ks,Ke,ja="<li><strong>1725 training steps</strong></li> <li>~<strong>1.9 samples/sec</strong> processing speed</li> <li>Total training time: <strong>~2 hours</strong></li>",Ws,Oe,Ja="This is solid performance given the setup and confirms that your LoRA fine-tuning pipeline is both stable and efficient.",Rs,_s,Bs,et,ba="Next, we’ll save and push this trained model to the Hugging Face Hub so you (or others!) can load and test it anytime. 🚀",xs,tt,Hs,lt,Ua="Now that the model is trained, we define a simple helper function <code>generate_tags</code> to run inference. It takes a natural language query describing a repository and generates relevant tags using our fine-tuned T5 model.",Vs,st,Ia="Below is an example for a query related to image augmentation and no-code tools.",Xs,nt,Es,at,Fs,it,zs,ot,Ca="Once the training is complete, we save the fine-tuned model and tokenizer to a local directory. This allows us to reuse or share the model later without needing to retrain it.",As,pt,Qs,rt,va=`✅ Model and tokenizer saved locally at: ./t5_tag_generator/final
`,qs,dt,Ys,Mt,$a="After saving the model locally, we now push it to the Hugging Face Hub so that others can easily access, test, and load it using <code>from_pretrained</code>.",Ls,mt,Ga='➡️ The model is publicly available at: <a href="https://huggingface.co/zamal/github-tag-generatorr" rel="nofollow">huggingface.co/zamal/github-tag-generatorr</a>',Ns,ut,Ss,ct,Za=`🚀 Model pushed to Hugging Face Hub: https://huggingface.co/zamal/github-tag-generatorr
`,Ps,gt,Ds,ht,ka="Now that we’ve pushed our fine-tuned model to the Hugging Face Hub, we can easily load it from anywhere using the <code>pipeline</code> utility. This allows us to instantly test or integrate the model into other applications without needing local files.",Ks,yt,Wa='The model is hosted at: <a href="https://huggingface.co/zamal/github-tag-generatorr" rel="nofollow">zamal/github-tag-generatorr</a>',Os,Tt,en,ft,tn,wt,Ra="This function wraps the model inference process to generate tags for a given GitHub project description. We prepend the prefix <code>&quot;generate tags: &quot;</code> (which the model was trained on) and tokenize the input appropriately before calling <code>model.generate()</code>.",ln,jt,_a="After decoding the generated output, we <strong>deduplicate the tags</strong> using a simple <code>dict.fromkeys()</code> trick. This ensures that tags like <code>&quot;pytorch, pytorch, pytorch&quot;</code> only appear once.",sn,Jt,Ba="We added this logic because the training data included some noisy samples with repeated or inconsistent tags. Since we did not perform extensive data cleaning or multiple training runs to refine the quality, this lightweight fix helps improve the final output. In a production-grade system, we’d recommend:",nn,bt,xa="<li>more rigorous data preprocessing,</li> <li>filtering weak labels,</li> <li>and performing iterative fine-tuning with evaluation and human-in-the-loop review.</li>",an,Ut,on,It,pn,Ct,Ha="Now that we’ve defined our inference function and loaded the model, let’s run it on a few example descriptions.",rn,vt,Va="Each input represents a short summary of a hypothetical GitHub repository. Our goal is to generate meaningful and concise tags using the fine-tuned T5 model.",dn,$t,Xa="These test cases demonstrate how well the model generalizes to realistic prompts — and thanks to our post-processing, any repetitive or noisy tags are cleaned up before display.",Mn,Gt,mn,Zt,Ea=`📥 Input: Need an AI tool to convert customer voice calls into structured CRM record
🏷️ Tags: voice-calls, crm-recording, voice-recording

📥 Input: How to train a text summarization model using Pegasus or BART
🏷️ Tags: text summarization, pegasus, bart, et al.

📥 Input: Fine-tuning BERT for spam detection in emails
🏷️ Tags: bert, spam-detecting, email-tuning
`,un,kt,cn,Wt,Fa="To follow the same format as our training data, we rephrase descriptive statements into query-style inputs — just like users would naturally search for repositories. This aligns with our fine-tuning data, which was based on natural language search queries mapped to relevant tags.",gn,Rt,za="Below are some meta and practical examples, including:",hn,_t,Aa="<li>Hugging Face’s own popular repositories (e.g., Transformers, Datasets, Diffusers)</li> <li>Styled as realistic queries for better inference consistency</li>",yn,Bt,Tn,xt,Qa=`📥 Input: Best GitHub repositories with practical notebooks demonstrating real-world AI applications from Hugging Face.
🏷️ Tags: github, repositories, practical, notebooks, demonstrating real-world, ai, hugging-face

📥 Input: Best libraries for accessing NLP datasets and evaluation tools in Python.
🏷️ Tags: nlp, datasets, evaluation, python

📥 Input: Searching for Hugging Face Diffusers repositories for generating images, audio, and other media with pre-trained diffusion models.
🏷️ Tags: images, audio, and other media, with pre-trained, diffusion-models.
`,fn,Ht,wn,Xt,jn;return T=new ei({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/finetune_t5_for_search_tag_generation.ipynb"}]}}),f=new g({props:{title:"🔖 GitHub Tag Generator with T5 + PEFT (LoRA)",local:"-github-tag-generator-with-t5--peft-lora",headingTag:"h3"}}),J=new g({props:{title:"💡 Use Case",local:"-use-case",headingTag:"h4"}}),I=new g({props:{title:"📦 Dataset",local:"-dataset",headingTag:"h4"}}),G=new g({props:{title:"🧠 Model Architecture",local:"-model-architecture",headingTag:"h4"}}),k=new g({props:{title:"✅ What This Notebook Covers",local:"-what-this-notebook-covers",headingTag:"h4"}}),_=new g({props:{title:"🔍 Final Outcome",local:"-final-outcome",headingTag:"h4"}}),F=new h({props:{code:"ZnJvbSUyMGdvb2dsZS5jb2xhYiUyMGltcG9ydCUyMHVzZXJkYXRhJTBBaW1wb3J0JTIwb3MlMEFvcy5lbnZpcm9uJTVCJ0hVR0dJTkdGQUNFX1RPS0VOJyU1RCUyMCUzRCUyMHVzZXJkYXRhLmdldCgnSFVHR0lOR0ZBQ0VfVE9LRU4nKQ==",highlighted:`<span class="hljs-keyword">from</span> google.colab <span class="hljs-keyword">import</span> userdata
<span class="hljs-keyword">import</span> os
os.environ[<span class="hljs-string">&#x27;HUGGINGFACE_TOKEN&#x27;</span>] = userdata.get(<span class="hljs-string">&#x27;HUGGINGFACE_TOKEN&#x27;</span>)`,wrap:!1}}),z=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1VG9rZW5pemVyJTJDJTIwVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBUcmFpbmVyJTJDJTIwVHJhaW5pbmdBcmd1bWVudHMlMEFpbXBvcnQlMjBvcyUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwTG9yYUNvbmZpZyUyQyUyMGdldF9wZWZ0X21vZGVsJTJDJTIwcHJlcGFyZV9tb2RlbF9mb3Jfa2JpdF90cmFpbmluZyUyQyUyMFBlZnRDb25maWc=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5Tokenizer, T5ForConditionalGeneration, Trainer, TrainingArguments
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model, prepare_model_for_kbit_training, PeftConfig`,wrap:!1}}),A=new h({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwVDVUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnQ1LXNtYWxsJTIyKQ==",highlighted:'tokenizer = T5Tokenizer.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)',wrap:!1}}),Q=new g({props:{title:"📦 Load and Prepare the Dataset",local:"-load-and-prepare-the-dataset",headingTag:"h4"}}),P=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwRGF0YXNldERpY3QlMEElMEElM0NDb3B5TExNVHh0TWVudSUyMGNvbnRhaW5lclN0eWxlJTNEJTIyZmxvYXQlM0ElMjByaWdodCUzQiUyMG1hcmdpbi1sZWZ0JTNBJTIwMTBweCUzQiUyMGRpc3BsYXklM0ElMjBpbmxpbmUtZmxleCUzQiUyMHBvc2l0aW9uJTNBJTIwcmVsYXRpdmUlM0IlMjB6LWluZGV4JTNBJTIwMTAlM0IlMjIlM0UlM0MlMkZDb3B5TExNVHh0TWVudSUzRSUwQSUwQSUyMyUyMExvYWQlMjBleGlzdGluZyUyMGRhdGFzZXQlMjB3aXRoJTIwb25seSUyMGElMjAlMjJ0cmFpbiUyMiUyMHNwbGl0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ6YW1hbCUyRmdpdGh1Yi1tZXRhLWRhdGElMjIpJTIwJTIwJTIzJTIwcmV0dXJucyUyMERhdGFzZXREaWN0JTBBJTBBJTIzJTIwU3BsaXQlMjB0aGUlMjB0cmFpbiUyMHNldCUyMGludG8lMjB0cmFpbiUyMGFuZCUyMHZhbGlkYXRpb24lMEFzcGxpdCUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RC50cmFpbl90ZXN0X3NwbGl0KHRlc3Rfc2l6ZSUzRDAuMSUyQyUyMHNlZWQlM0Q0MiklMEElMEElMjMlMjBXcmFwJTIwaW50byUyMGElMjBuZXclMjBEYXRhc2V0RGljdCUwQWRhdGFzZXRfZGljdCUyMCUzRCUyMERhdGFzZXREaWN0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMnRyYWluJTIyJTNBJTIwc3BsaXQlNUIlMjJ0cmFpbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnZhbGlkYXRpb24lMjIlM0ElMjBzcGxpdCU1QiUyMnRlc3QlMjIlNUQlMEElN0Qp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, DatasetDict

&lt;CopyLLMTxtMenu containerStyle=<span class="hljs-string">&quot;float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;&quot;</span>&gt;&lt;/CopyLLMTxtMenu&gt;

<span class="hljs-comment"># Load existing dataset with only a &quot;train&quot; split</span>
dataset = load_dataset(<span class="hljs-string">&quot;zamal/github-meta-data&quot;</span>)  <span class="hljs-comment"># returns DatasetDict</span>

<span class="hljs-comment"># Split the train set into train and validation</span>
split = dataset[<span class="hljs-string">&quot;train&quot;</span>].train_test_split(test_size=<span class="hljs-number">0.1</span>, seed=<span class="hljs-number">42</span>)

<span class="hljs-comment"># Wrap into a new DatasetDict</span>
dataset_dict = DatasetDict({
    <span class="hljs-string">&quot;train&quot;</span>: split[<span class="hljs-string">&quot;train&quot;</span>],
    <span class="hljs-string">&quot;validation&quot;</span>: split[<span class="hljs-string">&quot;test&quot;</span>]
})`,wrap:!1}}),D=new h({props:{code:"cHJpbnQobGVuKGRhdGFzZXRfZGljdCU1QiUyMnRyYWluJTIyJTVEKSklMEFwcmludChsZW4oZGF0YXNldF9kaWN0JTVCJTIydmFsaWRhdGlvbiUyMiU1RCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(dataset_dict[<span class="hljs-string">&quot;train&quot;</span>]))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(dataset_dict[<span class="hljs-string">&quot;validation&quot;</span>]))`,wrap:!1}}),O=new g({props:{title:"🔤 Load the Tokenizer",local:"-load-the-tokenizer",headingTag:"h4"}}),te=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFtb2RlbF9uYW1lJTIwJTNEJTIwJTIydDUtc21hbGwlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
model_name = <span class="hljs-string">&quot;t5-small&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_name)`,wrap:!1}}),le=new g({props:{title:"🧹 Preprocessing the Dataset",local:"-preprocessing-the-dataset",headingTag:"h4"}}),ie=new h({props:{code:"ZGVmJTIwcHJlcHJvY2VzcyhiYXRjaCklM0ElMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjBiYXRjaCU1QiUyMmlucHV0JTIyJTVEJTBBJTIwJTIwJTIwJTIwdGFyZ2V0cyUyMCUzRCUyMGJhdGNoJTVCJTIydGFyZ2V0JTIyJTVEJTBBJTIwJTIwJTIwJTIwbW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKGlucHV0cyUyQyUyMG1heF9sZW5ndGglM0QxMjglMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUyMHBhZGRpbmclM0QlMjJtYXhfbGVuZ3RoJTIyKSUwQSUyMCUyMCUyMCUyMGxhYmVscyUyMCUzRCUyMHRva2VuaXplcih0YXJnZXRzJTJDJTIwbWF4X2xlbmd0aCUzRDY0JTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMikuaW5wdXRfaWRzJTBBJTIwJTIwJTIwJTIwbW9kZWxfaW5wdXRzJTVCJTIybGFiZWxzJTIyJTVEJTIwJTNEJTIwbGFiZWxzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbW9kZWxfaW5wdXRz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">batch</span>):
    inputs = batch[<span class="hljs-string">&quot;input&quot;</span>]
    targets = batch[<span class="hljs-string">&quot;target&quot;</span>]
    model_inputs = tokenizer(inputs, max_length=<span class="hljs-number">128</span>, truncation=<span class="hljs-literal">True</span>, padding=<span class="hljs-string">&quot;max_length&quot;</span>)
    labels = tokenizer(targets, max_length=<span class="hljs-number">64</span>, truncation=<span class="hljs-literal">True</span>, padding=<span class="hljs-string">&quot;max_length&quot;</span>).input_ids
    model_inputs[<span class="hljs-string">&quot;labels&quot;</span>] = labels
    <span class="hljs-keyword">return</span> model_inputs`,wrap:!1}}),oe=new h({props:{code:"dG9rZW5pemVkJTIwJTNEJTIwZGF0YXNldF9kaWN0Lm1hcChwcmVwcm9jZXNzJTJDJTIwYmF0Y2hlZCUzRFRydWUlMkMlMjByZW1vdmVfY29sdW1ucyUzRGRhdGFzZXRfZGljdCU1QiUyMnRyYWluJTIyJTVELmNvbHVtbl9uYW1lcyklMEF0b2tlbml6ZWQuc2V0X2Zvcm1hdCh0eXBlJTNEJ3RvcmNoJyUyQyUyMGNvbHVtbnMlM0QlNUInaW5wdXRfaWRzJyUyQyUyMCdhdHRlbnRpb25fbWFzayclMkMlMjAnbGFiZWxzJyU1RCk=",highlighted:`tokenized = dataset_dict.<span class="hljs-built_in">map</span>(preprocess, batched=<span class="hljs-literal">True</span>, remove_columns=dataset_dict[<span class="hljs-string">&quot;train&quot;</span>].column_names)
tokenized.set_format(<span class="hljs-built_in">type</span>=<span class="hljs-string">&#x27;torch&#x27;</span>, columns=[<span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>])`,wrap:!1}}),pe=new g({props:{title:"Loading the Base T5 Model",local:"loading-the-base-t5-model",headingTag:"h4"}}),de=new h({props:{code:"bW9kZWwlMjAlM0QlMjBUNUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSk=",highlighted:"model = T5ForConditionalGeneration.from_pretrained(model_name)",wrap:!1}}),Me=new g({props:{title:"🔧 Preparing the LoRA Configuration",local:"-preparing-the-lora-configuration",headingTag:"h4"}}),ge=new h({props:{code:"bG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QzMiUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycSUyMiUyQyUyMCUyMnYlMjIlNUQlMkMlMjAlMjAlMjMlMjBBZGp1c3QlMjBiYXNlZCUyMG9uJTIwbW9kZWwlMjBhcmNoaXRlY3R1cmUlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJTRVFfMl9TRVFfTE0lMjIlMEEp",highlighted:`lora_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    target_modules=[<span class="hljs-string">&quot;q&quot;</span>, <span class="hljs-string">&quot;v&quot;</span>],  <span class="hljs-comment"># Adjust based on model architecture</span>
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;SEQ_2_SEQ_LM&quot;</span>
)`,wrap:!1}}),he=new g({props:{title:"🔌 Injecting LoRA into the Base T5 Model",local:"-injecting-lora-into-the-base-t5-model",headingTag:"h4"}}),Te=new h({props:{code:"bW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGxvcmFfY29uZmlnKQ==",highlighted:"model = get_peft_model(model, lora_config)",wrap:!1}}),fe=new g({props:{title:"🛠️ TrainingArguments Configuration",local:"-trainingarguments-configuration",headingTag:"h4"}}),be=new h({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjIuJTJGdDVfdGFnX2dlbmVyYXRvciUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDglMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX2V2YWxfYmF0Y2hfc2l6ZSUzRDglMkMlMEElMjAlMjAlMjAlMjBsZWFybmluZ19yYXRlJTNEMWUtNCUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0QyNSUyQyUwQSUyMCUyMCUyMCUyMGxvZ2dpbmdfc3RlcHMlM0QxMCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RyYXRlZ3klM0QlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfdG90YWxfbGltaXQlM0QyJTJDJTBBJTIwJTIwJTIwJTIwZnAxNiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBwdXNoX3RvX2h1YiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBodWJfbW9kZWxfaWQlM0QlMjJ6YW1hbCUyRmdpdGh1Yi10YWctZ2VuZXJhdG9yciUyMiUyQyUyMCUyMCUyMyUyMFJlcGxhY2UlMjB3aXRoJTIweW91ciUyMEh1Z2dpbmclMjBGYWNlJTIwdXNlcm5hbWUlMEElMjAlMjAlMjAlMjBodWJfdG9rZW4lM0Rvcy5lbnZpcm9uJTVCJ0hVR0dJTkdGQUNFX1RPS0VOJyU1RCUwQSk=",highlighted:`training_args = TrainingArguments(
    output_dir=<span class="hljs-string">&quot;./t5_tag_generator&quot;</span>,
    per_device_train_batch_size=<span class="hljs-number">8</span>,
    per_device_eval_batch_size=<span class="hljs-number">8</span>,
    learning_rate=<span class="hljs-number">1e-4</span>,
    num_train_epochs=<span class="hljs-number">25</span>,
    logging_steps=<span class="hljs-number">10</span>,
    eval_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    eval_steps=<span class="hljs-number">50</span>,
    save_steps=<span class="hljs-number">50</span>,
    save_total_limit=<span class="hljs-number">2</span>,
    fp16=<span class="hljs-literal">True</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
    hub_model_id=<span class="hljs-string">&quot;zamal/github-tag-generatorr&quot;</span>,  <span class="hljs-comment"># Replace with your Hugging Face username</span>
    hub_token=os.environ[<span class="hljs-string">&#x27;HUGGINGFACE_TOKEN&#x27;</span>]
)`,wrap:!1}}),Ue=new g({props:{title:"🧠 Initialize the Trainer",local:"-initialize-the-trainer",headingTag:"h4"}}),ve=new g({props:{title:"⚠️ Warnings Explained:",local:"-warnings-explained",headingTag:"h4"}}),Ze=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwRGF0YUNvbGxhdG9yRm9yU2VxMlNlcSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JGb3JTZXEyU2VxKHRva2VuaXplciUzRHRva2VuaXplciUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRva2VuaXplZCU1QiUyMnRyYWluJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEdG9rZW5pemVkJTVCJTIydmFsaWRhdGlvbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0RkYXRhX2NvbGxhdG9yJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DataCollatorForSeq2Seq
data_collator = DataCollatorForSeq2Seq(tokenizer=tokenizer, model=model)

trainer = Trainer(
    model=model,
    args=training_args,
    train_dataset=tokenized[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized[<span class="hljs-string">&quot;validation&quot;</span>],
    tokenizer=tokenizer,
    data_collator=data_collator
    )`,wrap:!1}}),ke=new g({props:{title:"🚀 Start Training the Tag Generator Model",local:"-start-training-the-tag-generator-model",headingTag:"h4"}}),Ve=new h({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()',wrap:!1}}),Ee=new g({props:{title:"✅ Training Summary and Observations",local:"-training-summary-and-observations",headingTag:"h4"}}),ze=new g({props:{title:"🔄 Logging with Weights & Biases (W&B)",local:"-logging-with-weights--biases-wb",headingTag:"h4"}}),Qe=new g({props:{title:"📉 Training & Validation Loss",local:"-training--validation-loss",headingTag:"h4"}}),Ne=new g({props:{title:"⚙️ Warnings and Notices",local:"-warnings-and-notices",headingTag:"h4"}}),Pe=new g({props:{title:"📊 Performance Metrics",local:"-performance-metrics",headingTag:"h4"}}),tt=new g({props:{title:"🔍 Inference: Generate Tags from Repository Descriptions",local:"-inference-generate-tags-from-repository-descriptions",headingTag:"h4"}}),nt=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEFkZWYlMjBnZW5lcmF0ZV90YWdzKHF1ZXJ5JTJDJTIwbW9kZWwlMkMlMjB0b2tlbml6ZXIlMkMlMjBtYXhfbGVuZ3RoJTNENjQlMkMlMjBudW1fYmVhbXMlM0Q1KSUzQSUwQSUyMCUyMCUyMCUyMG1vZGVsLmV2YWwoKSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMHRva2VuaXplcihxdWVyeSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUyMHBhZGRpbmclM0QlMjJtYXhfbGVuZ3RoJTIyJTJDJTIwbWF4X2xlbmd0aCUzRDEyOCkudG8obW9kZWwuZGV2aWNlKSUwQSUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dF9pZHMlM0RpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdHRlbnRpb25fbWFzayUzRGlucHV0cyU1QiUyMmF0dGVudGlvbl9tYXNrJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X2xlbmd0aCUzRG1heF9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fYmVhbXMlM0RudW1fYmVhbXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlYXJseV9zdG9wcGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZWNvZGVyX3N0YXJ0X3Rva2VuX2lkJTNEdG9rZW5pemVyLnBhZF90b2tlbl9pZCUyMCUyMCUyMyUyMCVGMCU5RiU5MSU4OCUyMHJlcXVpcmVkJTIwZm9yJTIwVDUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyLmRlY29kZShvdXRwdXQlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_tags</span>(<span class="hljs-params">query, model, tokenizer, max_length=<span class="hljs-number">64</span>, num_beams=<span class="hljs-number">5</span></span>):
    model.<span class="hljs-built_in">eval</span>()
    inputs = tokenizer(query, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, truncation=<span class="hljs-literal">True</span>, padding=<span class="hljs-string">&quot;max_length&quot;</span>, max_length=<span class="hljs-number">128</span>).to(model.device)

    <span class="hljs-keyword">with</span> torch.no_grad():
        output = model.generate(
            input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>],
            attention_mask=inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>],
            max_length=max_length,
            num_beams=num_beams,
            early_stopping=<span class="hljs-literal">True</span>,
            decoder_start_token_id=tokenizer.pad_token_id  <span class="hljs-comment"># 👈 required for T5</span>
        )
    <span class="hljs-keyword">return</span> tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),at=new h({props:{code:"Z2VuZXJhdGVfdGFncyglMjJsb29raW5nJTIwZm9yJTIwcmVwb3NpdG9yaWVzJTIwb24lMjBpbWFnZSUyMGF1Z21lbnRhdGlvbiUyMG5vJTIwY29kZSUyMGltcGxlbWVudGF0aW9ucyUyMiUyQyUyMG1vZGVsJTJDJTIwdG9rZW5pemVyKQ==",highlighted:'generate_tags(<span class="hljs-string">&quot;looking for repositories on image augmentation no code implementations&quot;</span>, model, tokenizer)',wrap:!1}}),it=new g({props:{title:"💾 Save Fine-Tuned Model Locally",local:"-save-fine-tuned-model-locally",headingTag:"h4"}}),pt=new h({props:{code:"JTIzJTIwU2F2ZSUyMG1vZGVsJTJDJTIwdG9rZW5pemVyJTJDJTIwYW5kJTIwY29uZmlnJTIwdG8lMjBsb2NhbCUyMG91dHB1dCUyMGRpcmVjdG9yeSUwQW1vZGVsX3BhdGglMjAlM0QlMjAlMjIuJTJGdDVfdGFnX2dlbmVyYXRvciUyRmZpbmFsJTIyJTBBJTBBbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKG1vZGVsX3BhdGgpJTBBdG9rZW5pemVyLnNhdmVfcHJldHJhaW5lZChtb2RlbF9wYXRoKSUwQSUwQXByaW50KCUyMiVFMiU5QyU4NSUyME1vZGVsJTIwYW5kJTIwdG9rZW5pemVyJTIwc2F2ZWQlMjBsb2NhbGx5JTIwYXQlM0ElMjIlMkMlMjBtb2RlbF9wYXRoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Save model, tokenizer, and config to local output directory</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_path = <span class="hljs-string">&quot;./t5_tag_generator/final&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(model_path)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.save_pretrained(model_path)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ Model and tokenizer saved locally at:&quot;</span>, model_path)`,wrap:!1}}),dt=new g({props:{title:"🚀 Push Model to Hugging Face Hub",local:"-push-model-to-hugging-face-hub",headingTag:"h4"}}),ut=new h({props:{code:"JTIzJTIwUHVzaCUyMHRvJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIlMjB1bmRlciUyMHlvdXIlMjByZXBvJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWFwaS51cGxvYWRfZm9sZGVyKCUwQSUyMCUyMCUyMCUyMGZvbGRlcl9wYXRoJTNEbW9kZWxfcGF0aCUyQyUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJ6YW1hbCUyRmdpdGh1Yi10YWctZ2VuZXJhdG9yciUyMiUyQyUyMCUyMCUyMyUyMFlvdXIlMjBtb2RlbCUyMElEJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIybW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjBwYXRoX2luX3JlcG8lM0QlMjIlMjIlMkMlMjAlMjAlMjMlMjBSb290JTIwb2YlMjB0aGUlMjByZXBvJTBBKSUwQSUwQXByaW50KCUyMiVGMCU5RiU5QSU4MCUyME1vZGVsJTIwcHVzaGVkJTIwdG8lMjBIdWdnaW5nJTIwRmFjZSUyMEh1YiUzQSUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZ6YW1hbCUyRmdpdGh1Yi10YWctZ2VuZXJhdG9yciUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Push to Hugging Face Hub under your repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_folder(
<span class="hljs-meta">... </span>    folder_path=model_path,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;zamal/github-tag-generatorr&quot;</span>,  <span class="hljs-comment"># Your model ID</span>
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;model&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;&quot;</span>,  <span class="hljs-comment"># Root of the repo</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🚀 Model pushed to Hugging Face Hub: https://huggingface.co/zamal/github-tag-generatorr&quot;</span>)`,wrap:!1}}),gt=new g({props:{title:"📦 Load Model Directly from Hugging Face Hub",local:"-load-model-directly-from-hugging-face-hub",headingTag:"h4"}}),Tt=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBJTIzJTIwTG9hZCUyMHRoZSUyMG1vZGVsJTIwYW5kJTIwdG9rZW5pemVyJTIwZnJvbSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTBBdGFnX2dlbmVyYXRvciUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQydGV4dC1nZW5lcmF0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJ6YW1hbCUyRmdpdGh1Yi10YWctZ2VuZXJhdG9yciUyMiUyQyUyMHRva2VuaXplciUzRCUyMnphbWFsJTJGZ2l0aHViLXRhZy1nZW5lcmF0b3JyJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-comment"># Load the model and tokenizer from Hugging Face Hub</span>
tag_generator = pipeline(<span class="hljs-string">&quot;text2text-generation&quot;</span>, model=<span class="hljs-string">&quot;zamal/github-tag-generatorr&quot;</span>, tokenizer=<span class="hljs-string">&quot;zamal/github-tag-generatorr&quot;</span>)`,wrap:!1}}),ft=new g({props:{title:"🧠 Inference Function with Post-Processing",local:"-inference-function-with-post-processing",headingTag:"h3"}}),Ut=new h({props:{code:"ZGVmJTIwZ2VuZXJhdGVfdGFncyh0ZXh0JTJDJTIwbW9kZWwlMkMlMjB0b2tlbml6ZXIlMkMlMjBtYXhfbGVuZ3RoJTNENjQlMkMlMjBudW1fYmVhbXMlM0Q1KSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0X3RleHQlMjAlM0QlMjB0ZXh0JTBBJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKGlucHV0X3RleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUyMG1heF9sZW5ndGglM0QxMjgpLnRvKG1vZGVsLmRldmljZSklMEElMEElMjAlMjAlMjAlMjB3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRfaWRzJTNEaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXR0ZW50aW9uX21hc2slM0RpbnB1dHMlNUIlMjJhdHRlbnRpb25fbWFzayUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1heF9sZW5ndGglM0RtYXhfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2JlYW1zJTNEbnVtX2JlYW1zJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZWFybHlfc3RvcHBpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGVjb2Rlcl9zdGFydF90b2tlbl9pZCUzRHRva2VuaXplci5wYWRfdG9rZW5faWQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwZGVjb2RlZCUyMCUzRCUyMHRva2VuaXplci5kZWNvZGUob3V0cHV0JTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMERlZHVwbGljYXRlJTIwYW5kJTIwY2xlYW4lMjB0YWdzJTBBJTIwJTIwJTIwJTIwdGFncyUyMCUzRCUyMCU1QnQuc3RyaXAoKS5sb3dlcigpJTIwZm9yJTIwdCUyMGluJTIwZGVjb2RlZC5zcGxpdCglMjIlMkMlMjIpJTVEJTBBJTIwJTIwJTIwJTIwdW5pcXVlX3RhZ3MlMjAlM0QlMjBsaXN0KGRpY3QuZnJvbWtleXModGFncykpJTIwJTIwJTIzJTIwcHJlc2VydmUlMjBvcmRlciUyMCUyQiUyMHJlbW92ZSUyMGR1cGxpY2F0ZXMlMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlMjIlMkMlMjAlMjIuam9pbih1bmlxdWVfdGFncyk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_tags</span>(<span class="hljs-params">text, model, tokenizer, max_length=<span class="hljs-number">64</span>, num_beams=<span class="hljs-number">5</span></span>):
    input_text = text
    inputs = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>, max_length=<span class="hljs-number">128</span>).to(model.device)

    <span class="hljs-keyword">with</span> torch.no_grad():
        output = model.generate(
            input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>],
            attention_mask=inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>],
            max_length=max_length,
            num_beams=num_beams,
            early_stopping=<span class="hljs-literal">True</span>,
            decoder_start_token_id=tokenizer.pad_token_id,
        )
    decoded = tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)

    <span class="hljs-comment"># Deduplicate and clean tags</span>
    tags = [t.strip().lower() <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> decoded.split(<span class="hljs-string">&quot;,&quot;</span>)]
    unique_tags = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">dict</span>.fromkeys(tags))  <span class="hljs-comment"># preserve order + remove duplicates</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;, &quot;</span>.join(unique_tags)`,wrap:!1}}),It=new g({props:{title:"🔍 Real-world Examples: Testing on Sample Inputs",local:"-real-world-examples-testing-on-sample-inputs",headingTag:"h5"}}),Gt=new h({props:{code:"aW5wdXRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyTmVlZCUyMGFuJTIwQUklMjB0b29sJTIwdG8lMjBjb252ZXJ0JTIwY3VzdG9tZXIlMjB2b2ljZSUyMGNhbGxzJTIwaW50byUyMHN0cnVjdHVyZWQlMjBDUk0lMjByZWNvcmQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJIb3clMjB0byUyMHRyYWluJTIwYSUyMHRleHQlMjBzdW1tYXJpemF0aW9uJTIwbW9kZWwlMjB1c2luZyUyMFBlZ2FzdXMlMjBvciUyMEJBUlQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJGaW5lLXR1bmluZyUyMEJFUlQlMjBmb3IlMjBzcGFtJTIwZGV0ZWN0aW9uJTIwaW4lMjBlbWFpbHMlMjIlMEElNUQlMEElMEFmb3IlMjB0ZXh0JTIwaW4lMjBpbnB1dHMlM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyJUYwJTlGJTkzJUE1JTIwSW5wdXQlM0ElMjAlN0J0ZXh0JTdEJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlRjAlOUYlOEYlQjclRUYlQjglOEYlMjBUYWdzJTNBJTIwJTdCZ2VuZXJhdGVfdGFncyh0ZXh0JTJDJTIwbW9kZWwlMkMlMjB0b2tlbml6ZXIpJTdEJTVDbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Need an AI tool to convert customer voice calls into structured CRM record&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;How to train a text summarization model using Pegasus or BART&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Fine-tuning BERT for spam detection in emails&quot;</span>
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> text <span class="hljs-keyword">in</span> inputs:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📥 Input: <span class="hljs-subst">{text}</span>&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🏷️ Tags: <span class="hljs-subst">{generate_tags(text, model, tokenizer)}</span>\\n&quot;</span>)`,wrap:!1}}),kt=new g({props:{title:"🔍 Inference Examples Using Real Hugging Face Projects",local:"-inference-examples-using-real-hugging-face-projects",headingTag:"h5"}}),Bt=new h({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the model and tokenizer from the Hugging Face Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tag_generator = pipeline(<span class="hljs-string">&quot;text2text-generation&quot;</span>, model=<span class="hljs-string">&quot;zamal/github-tag-generatorr&quot;</span>, tokenizer=<span class="hljs-string">&quot;zamal/github-tag-generatorr&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">clean_and_deduplicate_tags</span>(<span class="hljs-params">decoded</span>):
<span class="hljs-meta">... </span>    tags = [tag.strip().lower() <span class="hljs-keyword">for</span> tag <span class="hljs-keyword">in</span> decoded.split(<span class="hljs-string">&quot;,&quot;</span>)]

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Remove non-informative or overly generic tokens</span>
<span class="hljs-meta">... </span>    ignore_list = {<span class="hljs-string">&quot;a&quot;</span>, <span class="hljs-string">&quot;an&quot;</span>, <span class="hljs-string">&quot;the&quot;</span>, <span class="hljs-string">&quot;and&quot;</span>, <span class="hljs-string">&quot;or&quot;</span>, <span class="hljs-string">&quot;of&quot;</span>, <span class="hljs-string">&quot;to&quot;</span>, <span class="hljs-string">&quot;on&quot;</span>, <span class="hljs-string">&quot;in&quot;</span>, <span class="hljs-string">&quot;for&quot;</span>, <span class="hljs-string">&quot;with&quot;</span>, <span class="hljs-string">&quot;etc&quot;</span>, <span class="hljs-string">&quot;from&quot;</span>}
<span class="hljs-meta">... </span>    filtered = [tag <span class="hljs-keyword">for</span> tag <span class="hljs-keyword">in</span> tags <span class="hljs-keyword">if</span> tag <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> ignore_list <span class="hljs-keyword">and</span> <span class="hljs-built_in">len</span>(tag) &gt; <span class="hljs-number">1</span>]

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Deduplicate while preserving order</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;, &quot;</span>.join(<span class="hljs-built_in">dict</span>.fromkeys(filtered))

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_tags_with_pipeline</span>(<span class="hljs-params">text</span>):
<span class="hljs-meta">... </span>    output = tag_generator(text, max_length=<span class="hljs-number">64</span>, num_beams=<span class="hljs-number">5</span>, early_stopping=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>    decoded = output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> clean_and_deduplicate_tags(decoded)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 🤗 Realistic repo descriptions for inference (from Hugging Face &amp; this notebook)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_repos = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Best GitHub repositories with practical notebooks demonstrating real-world AI applications from Hugging Face.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Best libraries for accessing NLP datasets and evaluation tools in Python.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Searching for Hugging Face Diffusers repositories for generating images, audio, and other media with pre-trained diffusion models.&quot;</span>
<span class="hljs-meta">... </span>]


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> repo <span class="hljs-keyword">in</span> hf_repos:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📥 Input: <span class="hljs-subst">{repo}</span>&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🏷️ Tags: <span class="hljs-subst">{generate_tags_with_pipeline(repo)}</span>\\n&quot;</span>)`,wrap:!1}}),Ht=new ti({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/finetune_t5_for_search_tag_generation.md"}}),{c(){y=i("meta"),Et=n(),Vt=i("p"),Ft=n(),r(T.$$.fragment),zt=n(),r(f.$$.fragment),At=n(),w=i("p"),w.innerHTML=bn,Qt=n(),j=i("p"),j.innerHTML=Un,qt=n(),Yt=i("hr"),Lt=n(),r(J.$$.fragment),Nt=n(),b=i("p"),b.innerHTML=In,St=n(),U=i("ul"),U.innerHTML=Cn,Pt=n(),Dt=i("hr"),Kt=n(),r(I.$$.fragment),Ot=n(),C=i("p"),C.textContent=vn,el=n(),v=i("ul"),v.innerHTML=$n,tl=n(),$=i("p"),$.innerHTML=Gn,ll=n(),sl=i("hr"),nl=n(),r(G.$$.fragment),al=n(),Z=i("p"),Z.innerHTML=Zn,il=n(),ol=i("hr"),pl=n(),r(k.$$.fragment),rl=n(),W=i("p"),W.textContent=kn,dl=n(),R=i("ul"),R.innerHTML=Wn,Ml=n(),ml=i("hr"),ul=n(),r(_.$$.fragment),cl=n(),B=i("p"),B.textContent=Rn,gl=n(),x=i("ul"),x.innerHTML=_n,hl=n(),H=i("p"),H.textContent=Bn,yl=n(),V=i("p"),V.textContent=xn,Tl=n(),X=i("ul"),X.innerHTML=Hn,fl=n(),E=i("p"),E.innerHTML=Vn,wl=n(),r(F.$$.fragment),jl=n(),r(z.$$.fragment),Jl=n(),r(A.$$.fragment),bl=n(),r(Q.$$.fragment),Ul=n(),q=i("p"),q.textContent=Xn,Il=n(),Y=i("p"),Y.textContent=En,Cl=n(),L=i("ul"),L.innerHTML=Fn,vl=n(),N=i("p"),N.textContent=zn,$l=n(),S=i("p"),S.innerHTML=An,Gl=n(),r(P.$$.fragment),Zl=n(),r(D.$$.fragment),kl=n(),K=i("pre"),K.textContent=Qn,Wl=n(),r(O.$$.fragment),Rl=n(),ee=i("p"),ee.innerHTML=qn,_l=n(),r(te.$$.fragment),Bl=n(),r(le.$$.fragment),xl=n(),se=i("p"),se.textContent=Yn,Hl=n(),ne=i("ul"),ne.innerHTML=Ln,Vl=n(),ae=i("p"),ae.textContent=Nn,Xl=n(),r(ie.$$.fragment),El=n(),r(oe.$$.fragment),Fl=n(),r(pe.$$.fragment),zl=n(),re=i("p"),re.innerHTML=Sn,Al=n(),r(de.$$.fragment),Ql=n(),r(Me.$$.fragment),ql=n(),me=i("p"),me.textContent=Pn,Yl=n(),ue=i("p"),ue.textContent=Dn,Ll=n(),ce=i("ul"),ce.innerHTML=Kn,Nl=n(),r(ge.$$.fragment),Sl=n(),r(he.$$.fragment),Pl=n(),ye=i("p"),ye.innerHTML=On,Dl=n(),r(Te.$$.fragment),Kl=n(),r(fe.$$.fragment),Ol=n(),we=i("p"),we.innerHTML=ea,es=n(),je=i("ul"),je.innerHTML=ta,ts=n(),Je=i("p"),Je.textContent=la,ls=n(),r(be.$$.fragment),ss=n(),r(Ue.$$.fragment),ns=n(),Ie=i("p"),Ie.innerHTML=sa,as=n(),Ce=i("p"),Ce.innerHTML=na,is=n(),r(ve.$$.fragment),os=n(),$e=i("ul"),$e.innerHTML=aa,ps=n(),Ge=i("p"),Ge.innerHTML=ia,rs=n(),r(Ze.$$.fragment),ds=n(),r(ke.$$.fragment),Ms=n(),We=i("p"),We.innerHTML=oa,ms=n(),Re=i("p"),Re.textContent=pa,us=n(),_e=i("ul"),_e.innerHTML=ra,cs=n(),Be=i("p"),Be.textContent=da,gs=n(),xe=i("ul"),xe.innerHTML=Ma,hs=n(),He=i("p"),He.textContent=ma,ys=n(),r(Ve.$$.fragment),Ts=n(),Xe=i("pre"),Xe.textContent=ua,fs=n(),r(Ee.$$.fragment),ws=n(),Fe=i("p"),Fe.innerHTML=ca,js=n(),r(ze.$$.fragment),Js=n(),Ae=i("p"),Ae.innerHTML=ga,bs=n(),r(Qe.$$.fragment),Us=n(),qe=i("p"),qe.textContent=ha,Is=n(),Ye=i("ul"),Ye.innerHTML=ya,Cs=n(),Le=i("p"),Le.textContent=Ta,vs=n(),r(Ne.$$.fragment),$s=n(),Se=i("ul"),Se.innerHTML=fa,Gs=n(),r(Pe.$$.fragment),Zs=n(),De=i("p"),De.textContent=wa,ks=n(),Ke=i("ul"),Ke.innerHTML=ja,Ws=n(),Oe=i("p"),Oe.textContent=Ja,Rs=n(),_s=i("hr"),Bs=n(),et=i("p"),et.textContent=ba,xs=n(),r(tt.$$.fragment),Hs=n(),lt=i("p"),lt.innerHTML=Ua,Vs=n(),st=i("p"),st.textContent=Ia,Xs=n(),r(nt.$$.fragment),Es=n(),r(at.$$.fragment),Fs=n(),r(it.$$.fragment),zs=n(),ot=i("p"),ot.textContent=Ca,As=n(),r(pt.$$.fragment),Qs=n(),rt=i("pre"),rt.textContent=va,qs=n(),r(dt.$$.fragment),Ys=n(),Mt=i("p"),Mt.innerHTML=$a,Ls=n(),mt=i("p"),mt.innerHTML=Ga,Ns=n(),r(ut.$$.fragment),Ss=n(),ct=i("pre"),ct.textContent=Za,Ps=n(),r(gt.$$.fragment),Ds=n(),ht=i("p"),ht.innerHTML=ka,Ks=n(),yt=i("p"),yt.innerHTML=Wa,Os=n(),r(Tt.$$.fragment),en=n(),r(ft.$$.fragment),tn=n(),wt=i("p"),wt.innerHTML=Ra,ln=n(),jt=i("p"),jt.innerHTML=_a,sn=n(),Jt=i("p"),Jt.textContent=Ba,nn=n(),bt=i("ul"),bt.innerHTML=xa,an=n(),r(Ut.$$.fragment),on=n(),r(It.$$.fragment),pn=n(),Ct=i("p"),Ct.textContent=Ha,rn=n(),vt=i("p"),vt.textContent=Va,dn=n(),$t=i("p"),$t.textContent=Xa,Mn=n(),r(Gt.$$.fragment),mn=n(),Zt=i("pre"),Zt.textContent=Ea,un=n(),r(kt.$$.fragment),cn=n(),Wt=i("p"),Wt.textContent=Fa,gn=n(),Rt=i("p"),Rt.textContent=za,hn=n(),_t=i("ul"),_t.innerHTML=Aa,yn=n(),r(Bt.$$.fragment),Tn=n(),xt=i("pre"),xt.textContent=Qa,fn=n(),r(Ht.$$.fragment),wn=n(),Xt=i("p"),this.h()},l(e){const t=Ka("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(l),Et=a(e),Vt=o(e,"P",{}),qa(Vt).forEach(l),Ft=a(e),d(T.$$.fragment,e),zt=a(e),d(f.$$.fragment,e),At=a(e),w=o(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-1lfjwgo"&&(w.innerHTML=bn),Qt=a(e),j=o(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-6i8bk6"&&(j.innerHTML=Un),qt=a(e),Yt=o(e,"HR",{}),Lt=a(e),d(J.$$.fragment,e),Nt=a(e),b=o(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-kur3u3"&&(b.innerHTML=In),St=a(e),U=o(e,"UL",{"data-svelte-h":!0}),p(U)!=="svelte-t44y68"&&(U.innerHTML=Cn),Pt=a(e),Dt=o(e,"HR",{}),Kt=a(e),d(I.$$.fragment,e),Ot=a(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1r8fukq"&&(C.textContent=vn),el=a(e),v=o(e,"UL",{"data-svelte-h":!0}),p(v)!=="svelte-1jrfbn5"&&(v.innerHTML=$n),tl=a(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1exu0h7"&&($.innerHTML=Gn),ll=a(e),sl=o(e,"HR",{}),nl=a(e),d(G.$$.fragment,e),al=a(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-ru5b1e"&&(Z.innerHTML=Zn),il=a(e),ol=o(e,"HR",{}),pl=a(e),d(k.$$.fragment,e),rl=a(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-10o9ckw"&&(W.textContent=kn),dl=a(e),R=o(e,"UL",{"data-svelte-h":!0}),p(R)!=="svelte-pidhxt"&&(R.innerHTML=Wn),Ml=a(e),ml=o(e,"HR",{}),ul=a(e),d(_.$$.fragment,e),cl=a(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1et373b"&&(B.textContent=Rn),gl=a(e),x=o(e,"UL",{"data-svelte-h":!0}),p(x)!=="svelte-13we2s"&&(x.innerHTML=_n),hl=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-9vjau4"&&(H.textContent=Bn),yl=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1ry6d9o"&&(V.textContent=xn),Tl=a(e),X=o(e,"UL",{"data-svelte-h":!0}),p(X)!=="svelte-1j83d0i"&&(X.innerHTML=Hn),fl=a(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-kac877"&&(E.innerHTML=Vn),wl=a(e),d(F.$$.fragment,e),jl=a(e),d(z.$$.fragment,e),Jl=a(e),d(A.$$.fragment,e),bl=a(e),d(Q.$$.fragment,e),Ul=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-slpigq"&&(q.textContent=Xn),Il=a(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-2xcsoe"&&(Y.textContent=En),Cl=a(e),L=o(e,"UL",{"data-svelte-h":!0}),p(L)!=="svelte-xa442a"&&(L.innerHTML=Fn),vl=a(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-10r3qtc"&&(N.textContent=zn),$l=a(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-zgsxxm"&&(S.innerHTML=An),Gl=a(e),d(P.$$.fragment,e),Zl=a(e),d(D.$$.fragment,e),kl=a(e),K=o(e,"PRE",{"data-svelte-h":!0}),p(K)!=="svelte-163at5m"&&(K.textContent=Qn),Wl=a(e),d(O.$$.fragment,e),Rl=a(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1ggf3uw"&&(ee.innerHTML=qn),_l=a(e),d(te.$$.fragment,e),Bl=a(e),d(le.$$.fragment,e),xl=a(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-38jvct"&&(se.textContent=Yn),Hl=a(e),ne=o(e,"UL",{"data-svelte-h":!0}),p(ne)!=="svelte-13iu16h"&&(ne.innerHTML=Ln),Vl=a(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1024shj"&&(ae.textContent=Nn),Xl=a(e),d(ie.$$.fragment,e),El=a(e),d(oe.$$.fragment,e),Fl=a(e),d(pe.$$.fragment,e),zl=a(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-2hp9pl"&&(re.innerHTML=Sn),Al=a(e),d(de.$$.fragment,e),Ql=a(e),d(Me.$$.fragment,e),ql=a(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-14kfv35"&&(me.textContent=Pn),Yl=a(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-ib17ou"&&(ue.textContent=Dn),Ll=a(e),ce=o(e,"UL",{"data-svelte-h":!0}),p(ce)!=="svelte-ynrfys"&&(ce.innerHTML=Kn),Nl=a(e),d(ge.$$.fragment,e),Sl=a(e),d(he.$$.fragment,e),Pl=a(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-ypircv"&&(ye.innerHTML=On),Dl=a(e),d(Te.$$.fragment,e),Kl=a(e),d(fe.$$.fragment,e),Ol=a(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-42nmei"&&(we.innerHTML=ea),es=a(e),je=o(e,"UL",{"data-svelte-h":!0}),p(je)!=="svelte-wbs0n7"&&(je.innerHTML=ta),ts=a(e),Je=o(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-hzte0h"&&(Je.textContent=la),ls=a(e),d(be.$$.fragment,e),ss=a(e),d(Ue.$$.fragment,e),ns=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-x1wezx"&&(Ie.innerHTML=sa),as=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-h7vby"&&(Ce.innerHTML=na),is=a(e),d(ve.$$.fragment,e),os=a(e),$e=o(e,"UL",{"data-svelte-h":!0}),p($e)!=="svelte-c5nd7a"&&($e.innerHTML=aa),ps=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-101h0n0"&&(Ge.innerHTML=ia),rs=a(e),d(Ze.$$.fragment,e),ds=a(e),d(ke.$$.fragment,e),Ms=a(e),We=o(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-1oiep9o"&&(We.innerHTML=oa),ms=a(e),Re=o(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-1b4vj4e"&&(Re.textContent=pa),us=a(e),_e=o(e,"UL",{"data-svelte-h":!0}),p(_e)!=="svelte-12h59v3"&&(_e.innerHTML=ra),cs=a(e),Be=o(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-vhzxge"&&(Be.textContent=da),gs=a(e),xe=o(e,"UL",{"data-svelte-h":!0}),p(xe)!=="svelte-jwn8fe"&&(xe.innerHTML=Ma),hs=a(e),He=o(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-ejnwxo"&&(He.textContent=ma),ys=a(e),d(Ve.$$.fragment,e),Ts=a(e),Xe=o(e,"PRE",{"data-svelte-h":!0}),p(Xe)!=="svelte-hcda0i"&&(Xe.textContent=ua),fs=a(e),d(Ee.$$.fragment,e),ws=a(e),Fe=o(e,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-1wv9ws5"&&(Fe.innerHTML=ca),js=a(e),d(ze.$$.fragment,e),Js=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-4n4enr"&&(Ae.innerHTML=ga),bs=a(e),d(Qe.$$.fragment,e),Us=a(e),qe=o(e,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-1y2pbec"&&(qe.textContent=ha),Is=a(e),Ye=o(e,"UL",{"data-svelte-h":!0}),p(Ye)!=="svelte-v132w"&&(Ye.innerHTML=ya),Cs=a(e),Le=o(e,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-c2vvfb"&&(Le.textContent=Ta),vs=a(e),d(Ne.$$.fragment,e),$s=a(e),Se=o(e,"UL",{"data-svelte-h":!0}),p(Se)!=="svelte-15dugt5"&&(Se.innerHTML=fa),Gs=a(e),d(Pe.$$.fragment,e),Zs=a(e),De=o(e,"P",{"data-svelte-h":!0}),p(De)!=="svelte-1tiy911"&&(De.textContent=wa),ks=a(e),Ke=o(e,"UL",{"data-svelte-h":!0}),p(Ke)!=="svelte-80sign"&&(Ke.innerHTML=ja),Ws=a(e),Oe=o(e,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-1r2mydi"&&(Oe.textContent=Ja),Rs=a(e),_s=o(e,"HR",{}),Bs=a(e),et=o(e,"P",{"data-svelte-h":!0}),p(et)!=="svelte-1ixl158"&&(et.textContent=ba),xs=a(e),d(tt.$$.fragment,e),Hs=a(e),lt=o(e,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-1lusvpp"&&(lt.innerHTML=Ua),Vs=a(e),st=o(e,"P",{"data-svelte-h":!0}),p(st)!=="svelte-vrhbjc"&&(st.textContent=Ia),Xs=a(e),d(nt.$$.fragment,e),Es=a(e),d(at.$$.fragment,e),Fs=a(e),d(it.$$.fragment,e),zs=a(e),ot=o(e,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-1z0wg8v"&&(ot.textContent=Ca),As=a(e),d(pt.$$.fragment,e),Qs=a(e),rt=o(e,"PRE",{"data-svelte-h":!0}),p(rt)!=="svelte-1e35nx2"&&(rt.textContent=va),qs=a(e),d(dt.$$.fragment,e),Ys=a(e),Mt=o(e,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-1ry9479"&&(Mt.innerHTML=$a),Ls=a(e),mt=o(e,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-u7fuga"&&(mt.innerHTML=Ga),Ns=a(e),d(ut.$$.fragment,e),Ss=a(e),ct=o(e,"PRE",{"data-svelte-h":!0}),p(ct)!=="svelte-1hd0eo9"&&(ct.textContent=Za),Ps=a(e),d(gt.$$.fragment,e),Ds=a(e),ht=o(e,"P",{"data-svelte-h":!0}),p(ht)!=="svelte-aot8ka"&&(ht.innerHTML=ka),Ks=a(e),yt=o(e,"P",{"data-svelte-h":!0}),p(yt)!=="svelte-myc4ol"&&(yt.innerHTML=Wa),Os=a(e),d(Tt.$$.fragment,e),en=a(e),d(ft.$$.fragment,e),tn=a(e),wt=o(e,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-sexjla"&&(wt.innerHTML=Ra),ln=a(e),jt=o(e,"P",{"data-svelte-h":!0}),p(jt)!=="svelte-1gr5oaj"&&(jt.innerHTML=_a),sn=a(e),Jt=o(e,"P",{"data-svelte-h":!0}),p(Jt)!=="svelte-ywcjm5"&&(Jt.textContent=Ba),nn=a(e),bt=o(e,"UL",{"data-svelte-h":!0}),p(bt)!=="svelte-r8qpg1"&&(bt.innerHTML=xa),an=a(e),d(Ut.$$.fragment,e),on=a(e),d(It.$$.fragment,e),pn=a(e),Ct=o(e,"P",{"data-svelte-h":!0}),p(Ct)!=="svelte-clzicb"&&(Ct.textContent=Ha),rn=a(e),vt=o(e,"P",{"data-svelte-h":!0}),p(vt)!=="svelte-gquesn"&&(vt.textContent=Va),dn=a(e),$t=o(e,"P",{"data-svelte-h":!0}),p($t)!=="svelte-h8z8wr"&&($t.textContent=Xa),Mn=a(e),d(Gt.$$.fragment,e),mn=a(e),Zt=o(e,"PRE",{"data-svelte-h":!0}),p(Zt)!=="svelte-1w4z99r"&&(Zt.textContent=Ea),un=a(e),d(kt.$$.fragment,e),cn=a(e),Wt=o(e,"P",{"data-svelte-h":!0}),p(Wt)!=="svelte-3jq9rr"&&(Wt.textContent=Fa),gn=a(e),Rt=o(e,"P",{"data-svelte-h":!0}),p(Rt)!=="svelte-b9ub88"&&(Rt.textContent=za),hn=a(e),_t=o(e,"UL",{"data-svelte-h":!0}),p(_t)!=="svelte-1si4ywj"&&(_t.innerHTML=Aa),yn=a(e),d(Bt.$$.fragment,e),Tn=a(e),xt=o(e,"PRE",{"data-svelte-h":!0}),p(xt)!=="svelte-1ke53ve"&&(xt.textContent=Qa),fn=a(e),d(Ht.$$.fragment,e),wn=a(e),Xt=o(e,"P",{}),qa(Xt).forEach(l),this.h()},h(){Ya(y,"name","hf:doc:metadata"),Ya(y,"content",si)},m(e,t){Oa(document.head,y),s(e,Et,t),s(e,Vt,t),s(e,Ft,t),M(T,e,t),s(e,zt,t),M(f,e,t),s(e,At,t),s(e,w,t),s(e,Qt,t),s(e,j,t),s(e,qt,t),s(e,Yt,t),s(e,Lt,t),M(J,e,t),s(e,Nt,t),s(e,b,t),s(e,St,t),s(e,U,t),s(e,Pt,t),s(e,Dt,t),s(e,Kt,t),M(I,e,t),s(e,Ot,t),s(e,C,t),s(e,el,t),s(e,v,t),s(e,tl,t),s(e,$,t),s(e,ll,t),s(e,sl,t),s(e,nl,t),M(G,e,t),s(e,al,t),s(e,Z,t),s(e,il,t),s(e,ol,t),s(e,pl,t),M(k,e,t),s(e,rl,t),s(e,W,t),s(e,dl,t),s(e,R,t),s(e,Ml,t),s(e,ml,t),s(e,ul,t),M(_,e,t),s(e,cl,t),s(e,B,t),s(e,gl,t),s(e,x,t),s(e,hl,t),s(e,H,t),s(e,yl,t),s(e,V,t),s(e,Tl,t),s(e,X,t),s(e,fl,t),s(e,E,t),s(e,wl,t),M(F,e,t),s(e,jl,t),M(z,e,t),s(e,Jl,t),M(A,e,t),s(e,bl,t),M(Q,e,t),s(e,Ul,t),s(e,q,t),s(e,Il,t),s(e,Y,t),s(e,Cl,t),s(e,L,t),s(e,vl,t),s(e,N,t),s(e,$l,t),s(e,S,t),s(e,Gl,t),M(P,e,t),s(e,Zl,t),M(D,e,t),s(e,kl,t),s(e,K,t),s(e,Wl,t),M(O,e,t),s(e,Rl,t),s(e,ee,t),s(e,_l,t),M(te,e,t),s(e,Bl,t),M(le,e,t),s(e,xl,t),s(e,se,t),s(e,Hl,t),s(e,ne,t),s(e,Vl,t),s(e,ae,t),s(e,Xl,t),M(ie,e,t),s(e,El,t),M(oe,e,t),s(e,Fl,t),M(pe,e,t),s(e,zl,t),s(e,re,t),s(e,Al,t),M(de,e,t),s(e,Ql,t),M(Me,e,t),s(e,ql,t),s(e,me,t),s(e,Yl,t),s(e,ue,t),s(e,Ll,t),s(e,ce,t),s(e,Nl,t),M(ge,e,t),s(e,Sl,t),M(he,e,t),s(e,Pl,t),s(e,ye,t),s(e,Dl,t),M(Te,e,t),s(e,Kl,t),M(fe,e,t),s(e,Ol,t),s(e,we,t),s(e,es,t),s(e,je,t),s(e,ts,t),s(e,Je,t),s(e,ls,t),M(be,e,t),s(e,ss,t),M(Ue,e,t),s(e,ns,t),s(e,Ie,t),s(e,as,t),s(e,Ce,t),s(e,is,t),M(ve,e,t),s(e,os,t),s(e,$e,t),s(e,ps,t),s(e,Ge,t),s(e,rs,t),M(Ze,e,t),s(e,ds,t),M(ke,e,t),s(e,Ms,t),s(e,We,t),s(e,ms,t),s(e,Re,t),s(e,us,t),s(e,_e,t),s(e,cs,t),s(e,Be,t),s(e,gs,t),s(e,xe,t),s(e,hs,t),s(e,He,t),s(e,ys,t),M(Ve,e,t),s(e,Ts,t),s(e,Xe,t),s(e,fs,t),M(Ee,e,t),s(e,ws,t),s(e,Fe,t),s(e,js,t),M(ze,e,t),s(e,Js,t),s(e,Ae,t),s(e,bs,t),M(Qe,e,t),s(e,Us,t),s(e,qe,t),s(e,Is,t),s(e,Ye,t),s(e,Cs,t),s(e,Le,t),s(e,vs,t),M(Ne,e,t),s(e,$s,t),s(e,Se,t),s(e,Gs,t),M(Pe,e,t),s(e,Zs,t),s(e,De,t),s(e,ks,t),s(e,Ke,t),s(e,Ws,t),s(e,Oe,t),s(e,Rs,t),s(e,_s,t),s(e,Bs,t),s(e,et,t),s(e,xs,t),M(tt,e,t),s(e,Hs,t),s(e,lt,t),s(e,Vs,t),s(e,st,t),s(e,Xs,t),M(nt,e,t),s(e,Es,t),M(at,e,t),s(e,Fs,t),M(it,e,t),s(e,zs,t),s(e,ot,t),s(e,As,t),M(pt,e,t),s(e,Qs,t),s(e,rt,t),s(e,qs,t),M(dt,e,t),s(e,Ys,t),s(e,Mt,t),s(e,Ls,t),s(e,mt,t),s(e,Ns,t),M(ut,e,t),s(e,Ss,t),s(e,ct,t),s(e,Ps,t),M(gt,e,t),s(e,Ds,t),s(e,ht,t),s(e,Ks,t),s(e,yt,t),s(e,Os,t),M(Tt,e,t),s(e,en,t),M(ft,e,t),s(e,tn,t),s(e,wt,t),s(e,ln,t),s(e,jt,t),s(e,sn,t),s(e,Jt,t),s(e,nn,t),s(e,bt,t),s(e,an,t),M(Ut,e,t),s(e,on,t),M(It,e,t),s(e,pn,t),s(e,Ct,t),s(e,rn,t),s(e,vt,t),s(e,dn,t),s(e,$t,t),s(e,Mn,t),M(Gt,e,t),s(e,mn,t),s(e,Zt,t),s(e,un,t),M(kt,e,t),s(e,cn,t),s(e,Wt,t),s(e,gn,t),s(e,Rt,t),s(e,hn,t),s(e,_t,t),s(e,yn,t),M(Bt,e,t),s(e,Tn,t),s(e,xt,t),s(e,fn,t),M(Ht,e,t),s(e,wn,t),s(e,Xt,t),jn=!0},p:Na,i(e){jn||(m(T.$$.fragment,e),m(f.$$.fragment,e),m(J.$$.fragment,e),m(I.$$.fragment,e),m(G.$$.fragment,e),m(k.$$.fragment,e),m(_.$$.fragment,e),m(F.$$.fragment,e),m(z.$$.fragment,e),m(A.$$.fragment,e),m(Q.$$.fragment,e),m(P.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(te.$$.fragment,e),m(le.$$.fragment,e),m(ie.$$.fragment,e),m(oe.$$.fragment,e),m(pe.$$.fragment,e),m(de.$$.fragment,e),m(Me.$$.fragment,e),m(ge.$$.fragment,e),m(he.$$.fragment,e),m(Te.$$.fragment,e),m(fe.$$.fragment,e),m(be.$$.fragment,e),m(Ue.$$.fragment,e),m(ve.$$.fragment,e),m(Ze.$$.fragment,e),m(ke.$$.fragment,e),m(Ve.$$.fragment,e),m(Ee.$$.fragment,e),m(ze.$$.fragment,e),m(Qe.$$.fragment,e),m(Ne.$$.fragment,e),m(Pe.$$.fragment,e),m(tt.$$.fragment,e),m(nt.$$.fragment,e),m(at.$$.fragment,e),m(it.$$.fragment,e),m(pt.$$.fragment,e),m(dt.$$.fragment,e),m(ut.$$.fragment,e),m(gt.$$.fragment,e),m(Tt.$$.fragment,e),m(ft.$$.fragment,e),m(Ut.$$.fragment,e),m(It.$$.fragment,e),m(Gt.$$.fragment,e),m(kt.$$.fragment,e),m(Bt.$$.fragment,e),m(Ht.$$.fragment,e),jn=!0)},o(e){u(T.$$.fragment,e),u(f.$$.fragment,e),u(J.$$.fragment,e),u(I.$$.fragment,e),u(G.$$.fragment,e),u(k.$$.fragment,e),u(_.$$.fragment,e),u(F.$$.fragment,e),u(z.$$.fragment,e),u(A.$$.fragment,e),u(Q.$$.fragment,e),u(P.$$.fragment,e),u(D.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(le.$$.fragment,e),u(ie.$$.fragment,e),u(oe.$$.fragment,e),u(pe.$$.fragment,e),u(de.$$.fragment,e),u(Me.$$.fragment,e),u(ge.$$.fragment,e),u(he.$$.fragment,e),u(Te.$$.fragment,e),u(fe.$$.fragment,e),u(be.$$.fragment,e),u(Ue.$$.fragment,e),u(ve.$$.fragment,e),u(Ze.$$.fragment,e),u(ke.$$.fragment,e),u(Ve.$$.fragment,e),u(Ee.$$.fragment,e),u(ze.$$.fragment,e),u(Qe.$$.fragment,e),u(Ne.$$.fragment,e),u(Pe.$$.fragment,e),u(tt.$$.fragment,e),u(nt.$$.fragment,e),u(at.$$.fragment,e),u(it.$$.fragment,e),u(pt.$$.fragment,e),u(dt.$$.fragment,e),u(ut.$$.fragment,e),u(gt.$$.fragment,e),u(Tt.$$.fragment,e),u(ft.$$.fragment,e),u(Ut.$$.fragment,e),u(It.$$.fragment,e),u(Gt.$$.fragment,e),u(kt.$$.fragment,e),u(Bt.$$.fragment,e),u(Ht.$$.fragment,e),jn=!1},d(e){e&&(l(Et),l(Vt),l(Ft),l(zt),l(At),l(w),l(Qt),l(j),l(qt),l(Yt),l(Lt),l(Nt),l(b),l(St),l(U),l(Pt),l(Dt),l(Kt),l(Ot),l(C),l(el),l(v),l(tl),l($),l(ll),l(sl),l(nl),l(al),l(Z),l(il),l(ol),l(pl),l(rl),l(W),l(dl),l(R),l(Ml),l(ml),l(ul),l(cl),l(B),l(gl),l(x),l(hl),l(H),l(yl),l(V),l(Tl),l(X),l(fl),l(E),l(wl),l(jl),l(Jl),l(bl),l(Ul),l(q),l(Il),l(Y),l(Cl),l(L),l(vl),l(N),l($l),l(S),l(Gl),l(Zl),l(kl),l(K),l(Wl),l(Rl),l(ee),l(_l),l(Bl),l(xl),l(se),l(Hl),l(ne),l(Vl),l(ae),l(Xl),l(El),l(Fl),l(zl),l(re),l(Al),l(Ql),l(ql),l(me),l(Yl),l(ue),l(Ll),l(ce),l(Nl),l(Sl),l(Pl),l(ye),l(Dl),l(Kl),l(Ol),l(we),l(es),l(je),l(ts),l(Je),l(ls),l(ss),l(ns),l(Ie),l(as),l(Ce),l(is),l(os),l($e),l(ps),l(Ge),l(rs),l(ds),l(Ms),l(We),l(ms),l(Re),l(us),l(_e),l(cs),l(Be),l(gs),l(xe),l(hs),l(He),l(ys),l(Ts),l(Xe),l(fs),l(ws),l(Fe),l(js),l(Js),l(Ae),l(bs),l(Us),l(qe),l(Is),l(Ye),l(Cs),l(Le),l(vs),l($s),l(Se),l(Gs),l(Zs),l(De),l(ks),l(Ke),l(Ws),l(Oe),l(Rs),l(_s),l(Bs),l(et),l(xs),l(Hs),l(lt),l(Vs),l(st),l(Xs),l(Es),l(Fs),l(zs),l(ot),l(As),l(Qs),l(rt),l(qs),l(Ys),l(Mt),l(Ls),l(mt),l(Ns),l(Ss),l(ct),l(Ps),l(Ds),l(ht),l(Ks),l(yt),l(Os),l(en),l(tn),l(wt),l(ln),l(jt),l(sn),l(Jt),l(nn),l(bt),l(an),l(on),l(pn),l(Ct),l(rn),l(vt),l(dn),l($t),l(Mn),l(mn),l(Zt),l(un),l(cn),l(Wt),l(gn),l(Rt),l(hn),l(_t),l(yn),l(Tn),l(xt),l(fn),l(wn),l(Xt)),l(y),c(T,e),c(f,e),c(J,e),c(I,e),c(G,e),c(k,e),c(_,e),c(F,e),c(z,e),c(A,e),c(Q,e),c(P,e),c(D,e),c(O,e),c(te,e),c(le,e),c(ie,e),c(oe,e),c(pe,e),c(de,e),c(Me,e),c(ge,e),c(he,e),c(Te,e),c(fe,e),c(be,e),c(Ue,e),c(ve,e),c(Ze,e),c(ke,e),c(Ve,e),c(Ee,e),c(ze,e),c(Qe,e),c(Ne,e),c(Pe,e),c(tt,e),c(nt,e),c(at,e),c(it,e),c(pt,e),c(dt,e),c(ut,e),c(gt,e),c(Tt,e),c(ft,e),c(Ut,e),c(It,e),c(Gt,e),c(kt,e),c(Bt,e),c(Ht,e)}}}const si='{"title":"🔖 GitHub Tag Generator with T5 + PEFT (LoRA)","local":"-github-tag-generator-with-t5--peft-lora","sections":[{"title":"💡 Use Case","local":"-use-case","sections":[],"depth":4},{"title":"📦 Dataset","local":"-dataset","sections":[],"depth":4},{"title":"🧠 Model Architecture","local":"-model-architecture","sections":[],"depth":4},{"title":"✅ What This Notebook Covers","local":"-what-this-notebook-covers","sections":[],"depth":4},{"title":"🔍 Final Outcome","local":"-final-outcome","sections":[],"depth":4},{"title":"📦 Load and Prepare the Dataset","local":"-load-and-prepare-the-dataset","sections":[],"depth":4},{"title":"🔤 Load the Tokenizer","local":"-load-the-tokenizer","sections":[],"depth":4},{"title":"🧹 Preprocessing the Dataset","local":"-preprocessing-the-dataset","sections":[],"depth":4},{"title":"Loading the Base T5 Model","local":"loading-the-base-t5-model","sections":[],"depth":4},{"title":"🔧 Preparing the LoRA Configuration","local":"-preparing-the-lora-configuration","sections":[],"depth":4},{"title":"🔌 Injecting LoRA into the Base T5 Model","local":"-injecting-lora-into-the-base-t5-model","sections":[],"depth":4},{"title":"🛠️ TrainingArguments Configuration","local":"-trainingarguments-configuration","sections":[],"depth":4},{"title":"🧠 Initialize the Trainer","local":"-initialize-the-trainer","sections":[],"depth":4},{"title":"⚠️ Warnings Explained:","local":"-warnings-explained","sections":[],"depth":4},{"title":"🚀 Start Training the Tag Generator Model","local":"-start-training-the-tag-generator-model","sections":[],"depth":4},{"title":"✅ Training Summary and Observations","local":"-training-summary-and-observations","sections":[],"depth":4},{"title":"🔄 Logging with Weights & Biases (W&B)","local":"-logging-with-weights--biases-wb","sections":[],"depth":4},{"title":"📉 Training & Validation Loss","local":"-training--validation-loss","sections":[],"depth":4},{"title":"⚙️ Warnings and Notices","local":"-warnings-and-notices","sections":[],"depth":4},{"title":"📊 Performance Metrics","local":"-performance-metrics","sections":[],"depth":4},{"title":"🔍 Inference: Generate Tags from Repository Descriptions","local":"-inference-generate-tags-from-repository-descriptions","sections":[],"depth":4},{"title":"💾 Save Fine-Tuned Model Locally","local":"-save-fine-tuned-model-locally","sections":[],"depth":4},{"title":"🚀 Push Model to Hugging Face Hub","local":"-push-model-to-hugging-face-hub","sections":[],"depth":4},{"title":"📦 Load Model Directly from Hugging Face Hub","local":"-load-model-directly-from-hugging-face-hub","sections":[],"depth":4}],"depth":3}';function ni(Jn){return Sa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ri extends Pa{constructor(y){super(),Da(this,y,ni,li,La,{})}}export{ri as component};
