import{s as wl,a as jl,n as Tl,o as Jl}from"../chunks/scheduler.1f027d5a.js";import{S as fl,i as Cl,e as i,s,c as r,h as gl,a as o,d as l,b as n,f as xt,g as c,j as M,k as w,l as Il,m as a,n as p,t as u,o as y,p as d}from"../chunks/index.5cb6ce42.js";import{C as bl}from"../chunks/CopyLLMTxtMenu.f7108191.js";import{D as Al,C as h}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as m,E as Gl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function kl(qt){let T,Ge,be,ke,J,Be,f,$e,C,We,g,Rt='<em>Authored by: <a href="https://huggingface.co/davidberenstein1957" rel="nofollow">David Berenstein</a> and <a href="https://huggingface.co/sdiazlor" rel="nofollow">Sara Han Díaz</a></em>',ve,I,Vt='<li><strong>Libraries</strong>: <a href="https://github.com/argilla-io/argilla" rel="nofollow">argilla</a>, <a href="https://github.com/huggingface/huggingface_hub" rel="nofollow">hf-inference-endpoints</a></li> <li><strong>Components</strong>: <a href="https://distilabel.argilla.io/latest/components-gallery/steps/loaddatafromhub/" rel="nofollow">LoadDataFromHub</a>, <a href="https://distilabel.argilla.io/latest/components-gallery/tasks/textgeneration/" rel="nofollow">TextGeneration</a>, <a href="https://distilabel.argilla.io/latest/components-gallery/tasks/ultrafeedback/" rel="nofollow">UltraFeedback</a>, <a href="https://distilabel.argilla.io/latest/components-gallery/steps/groupcolumns/" rel="nofollow">GroupColumns</a>, <a href="https://distilabel.argilla.io/latest/components-gallery/steps/formattextgenerationdpo/" rel="nofollow">FormatTextGenerationDPO</a>, <a href="https://distilabel.argilla.io/latest/components-gallery/steps/textgenerationtoargilla/" rel="nofollow">PreferenceToArgilla</a>, <a href="https://distilabel.argilla.io/latest/components-gallery/llms/inferenceendpointsllm/" rel="nofollow">InferenceEndpointsLLM</a></li>',Ze,b,Qt='In this tutorial, we will use distilabel to generate a synthetic preference dataset for DPO, ORPO or RLHF. <a href="https://github.com/argilla-io/distilabel" rel="nofollow">distilabel</a> is a synthetic data and AI feedback framework for engineers who need fast, reliable and scalable pipelines based on verified research papers. Check the documentation <a href="https://distilabel.argilla.io/latest/" rel="nofollow">here</a>.',Ee,A,Lt='To generate the responses and evaluate them, we will use the <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">serverless HF Inference API</a> integrated with distilabel. This is free but rate-limited, allowing you to test and evaluate over 150,000 public models, or your own private models, via simple HTTP requests, with fast inference hosted on Hugging Face shared infrastructure. If you need more compute power, you can deploy your own inference endpoint with <a href="https://huggingface.co/docs/inference-endpoints/guides/create_endpoint" rel="nofollow">Hugging Face Inference Endpoints</a>.',Se,G,Ft='Finally, to further curate the data, we will use <a href="https://github.com/argilla-io/argilla" rel="nofollow">Argilla</a>, which allows us to provide human feedback on the data quality. Argilla is a collaboration tool for AI engineers and domain experts who need to build high-quality datasets for their projects. Check the documentation <a href="https://docs.argilla.io/latest/" rel="nofollow">here</a>.',_e,k,xe,B,qe,$,Xt="To complete this tutorial, you need to install the distilabel SDK and a few third-party libraries via pip. We will be using <strong>the free but rate-limited Hugging Face serverless Inference API</strong> for this tutorial, so we need to install this as an extra distilabel dependency. You can install them by running the following command:",Re,W,Ve,v,Qe,Z,Nt="Let’s make the required imports:",Le,E,Fe,S,Ht="You’ll need an <code>HF_TOKEN</code> to use the HF Inference Endpoints. Log in to use it directly within this notebook.",Xe,_,Ne,x,He,q,Yt='You can skip this step or replace it with any other data evaluation tool, but the quality of your model will suffer from a lack of data quality, so we do recommend looking at your data. If you already deployed Argilla, you can skip this step. Otherwise, you can quickly deploy Argilla following <a href="https://docs.argilla.io/latest/getting_started/quickstart/" rel="nofollow">this guide</a>.',Ye,R,zt="Along with that, you will need to install Argilla as a distilabel extra.",ze,V,Pe,Q,De,L,Pt="To generate our preference dataset, we will need to define a <code>Pipeline</code> with all the necessary steps. Below, we will go over each step in detail.",Ke,F,Oe,X,Dt='We will use as source data the <a href="https://huggingface.co/datasets/argilla/10Kprompts-mini" rel="nofollow"><code>argilla/10Kprompts-mini</code></a> dataset from the Hugging Face Hub.',et,U,Kt,tt,N,Ot="<li>Component: <code>LoadDataFromHub</code></li> <li>Input columns: <code>instruction</code> and <code>topic</code>, the same as in the loaded dataset</li> <li>Output columns: <code>instruction</code> and <code>topic</code></li>",lt,H,at,Y,st,z,el='We need to generate the responses for the given instructions. We will use two different models available on the Hugging Face Hub through the Serverless Inference API: <a href="https://huggingface.co/meta-llama/Meta-Llama-3-8B-Instruct" rel="nofollow"><code>meta-llama/Meta-Llama-3-8B-Instruct</code></a> and <a href="https://huggingface.co/mistralai/Mixtral-8x7B-Instruct-v0.1" rel="nofollow"><code>mistralai/Mixtral-8x7B-Instruct-v0.1</code></a>. We will also indicate the generation parameters for each model.',nt,P,tl="<li>Component: <code>TextGeneration</code> task with LLMs using <code>InferenceEndpointsLLM</code></li> <li>Input columns: <code>instruction</code></li> <li>Output columns: <code>generation</code>, <code>distilabel_metadata</code>, <code>model_name</code> for each model</li>",it,D,ll='For your use case and to improve the results, you can use any <a href="https://distilabel.argilla.io/latest/components-gallery/llms/" rel="nofollow">other LLM of your choice</a>.',ot,K,Mt,O,al=`[&#123;'instruction': 'Which are the top cities in Spain?', 'generation': 'Spain is a country with a rich culture, history, and architecture, and it has many great cities to visit. Here are some of the top cities in Spain:\\n\\n1. **Madrid**: The capital city of Spain, known for its vibrant nightlife, museums, and historic landmarks like the Royal Palace and Prado Museum.\\n2. **Barcelona**: The second-largest city in Spain, famous for its modernist architecture, beaches, and iconic landmarks like La Sagrada Família and Park Güell, designed by Antoni Gaudí.\\n3. **Valencia**: Located on the Mediterranean coast, Valencia is known for its beautiful beaches, City of Arts and Sciences, and delicious local cuisine, such as paella.\\n4. **Seville**: The capital of Andalusia, Seville is famous for its stunning cathedral, Royal Alcázar Palace, and lively flamenco music scene.\\n5. **Málaga**: A coastal city in southern Spain, Málaga is known for its rich history, beautiful beaches, and being the birthplace of Pablo Picasso.\\n6. **Zaragoza**: Located in the northeastern region of Aragon, Zaragoza is a city with a rich history, known for its Roman ruins, Gothic cathedral, and beautiful parks.\\n7. **Granada**: A city in the Andalusian region, Granada is famous for its stunning Alhambra palace and generalife gardens, a UNESCO World Heritage Site.\\n8. **Bilbao**: A city in the Basque Country, Bilbao is known for its modern architecture, including the Guggenheim Museum, and its rich cultural heritage.\\n9. **Alicante**: A coastal city in the Valencia region, Alicante is famous for its beautiful beaches, historic castle, and lively nightlife.\\n10. **San Sebastián**: A city in the Basque Country, San Sebastián is known for its stunning beaches, gastronomic scene, and cultural events like the San Sebastián International Film Festival.\\n\\nThese are just a few of the many great cities in Spain, each with its own unique character and attractions.', 'distilabel_metadata': &#123;'raw_output_text_generation_0': 'Spain is a country with a rich culture, history, and architecture, and it has many great cities to visit. Here are some of the top cities in Spain:\\n\\n1. **Madrid**: The capital city of Spain, known for its vibrant nightlife, museums, and historic landmarks like the Royal Palace and Prado Museum.\\n2. **Barcelona**: The second-largest city in Spain, famous for its modernist architecture, beaches, and iconic landmarks like La Sagrada Família and Park Güell, designed by Antoni Gaudí.\\n3. **Valencia**: Located on the Mediterranean coast, Valencia is known for its beautiful beaches, City of Arts and Sciences, and delicious local cuisine, such as paella.\\n4. **Seville**: The capital of Andalusia, Seville is famous for its stunning cathedral, Royal Alcázar Palace, and lively flamenco music scene.\\n5. **Málaga**: A coastal city in southern Spain, Málaga is known for its rich history, beautiful beaches, and being the birthplace of Pablo Picasso.\\n6. **Zaragoza**: Located in the northeastern region of Aragon, Zaragoza is a city with a rich history, known for its Roman ruins, Gothic cathedral, and beautiful parks.\\n7. **Granada**: A city in the Andalusian region, Granada is famous for its stunning Alhambra palace and generalife gardens, a UNESCO World Heritage Site.\\n8. **Bilbao**: A city in the Basque Country, Bilbao is known for its modern architecture, including the Guggenheim Museum, and its rich cultural heritage.\\n9. **Alicante**: A coastal city in the Valencia region, Alicante is famous for its beautiful beaches, historic castle, and lively nightlife.\\n10. **San Sebastián**: A city in the Basque Country, San Sebastián is known for its stunning beaches, gastronomic scene, and cultural events like the San Sebastián International Film Festival.\\n\\nThese are just a few of the many great cities in Spain, each with its own unique character and attractions.'}, 'model_name': 'meta-llama/Meta-Llama-3-8B-Instruct'}]
[&#123;'instruction': 'Which are the top cities in Spain?', 'generation': ' Here are some of the top cities in Spain based on various factors such as tourism, culture, history, and quality of life:\\n\\n1. Madrid: The capital and largest city in Spain, Madrid is known for its vibrant nightlife, world-class museums (such as the Prado Museum and Reina Sofia Museum), stunning parks (such as the Retiro Park), and delicious food.\\n\\n2. Barcelona: Famous for its unique architecture, Barcelona is home to several UNESCO World Heritage sites designed by Antoni Gaudí, including the Sagrada Familia and Park Güell. The city also boasts beautiful beaches, a lively arts scene, and delicious Catalan cuisine.\\n\\n3. Valencia: A coastal city located in the east of Spain, Valencia is known for its City of Arts and Sciences, a modern architectural complex that includes a planetarium, opera house, and museum of interactive science. The city is also famous for its paella, a traditional Spanish dish made with rice, vegetables, and seafood.\\n\\n4. Seville: The capital of Andalusia, Seville is famous for its flamenco dancing, stunning cathedral (the largest Gothic cathedral in the world), and the Alcázar, a beautiful palace made up of a series of rooms and courtyards.\\n\\n5. Granada: Located in the foothills of the Sierra Nevada mountains, Granada is known for its stunning Alhambra palace, a Moorish fortress that dates back to the 9th century. The city is also famous for its tapas, a traditional Spanish dish that is often served for free with drinks.\\n\\n6. Bilbao: A city in the Basque Country, Bilbao is famous for its modern architecture, including the Guggenheim Museum, a contemporary art museum designed by Frank Gehry. The city is also known for its pintxos, a type of Basque tapas that are served in bars and restaurants.\\n\\n7. Málaga: A coastal city in Andalusia, Málaga is known for its beautiful beaches, historic sites (including the Alcazaba and Gibralfaro castles), and the Picasso Museum, which is dedicated to the famous Spanish artist who was born in the city.\\n\\nThese are just a few of the many wonderful cities in Spain.', 'distilabel_metadata': &#123;'raw_output_text_generation_0': ' Here are some of the top cities in Spain based on various factors such as tourism, culture, history, and quality of life:\\n\\n1. Madrid: The capital and largest city in Spain, Madrid is known for its vibrant nightlife, world-class museums (such as the Prado Museum and Reina Sofia Museum), stunning parks (such as the Retiro Park), and delicious food.\\n\\n2. Barcelona: Famous for its unique architecture, Barcelona is home to several UNESCO World Heritage sites designed by Antoni Gaudí, including the Sagrada Familia and Park Güell. The city also boasts beautiful beaches, a lively arts scene, and delicious Catalan cuisine.\\n\\n3. Valencia: A coastal city located in the east of Spain, Valencia is known for its City of Arts and Sciences, a modern architectural complex that includes a planetarium, opera house, and museum of interactive science. The city is also famous for its paella, a traditional Spanish dish made with rice, vegetables, and seafood.\\n\\n4. Seville: The capital of Andalusia, Seville is famous for its flamenco dancing, stunning cathedral (the largest Gothic cathedral in the world), and the Alcázar, a beautiful palace made up of a series of rooms and courtyards.\\n\\n5. Granada: Located in the foothills of the Sierra Nevada mountains, Granada is known for its stunning Alhambra palace, a Moorish fortress that dates back to the 9th century. The city is also famous for its tapas, a traditional Spanish dish that is often served for free with drinks.\\n\\n6. Bilbao: A city in the Basque Country, Bilbao is famous for its modern architecture, including the Guggenheim Museum, a contemporary art museum designed by Frank Gehry. The city is also known for its pintxos, a type of Basque tapas that are served in bars and restaurants.\\n\\n7. Málaga: A coastal city in Andalusia, Málaga is known for its beautiful beaches, historic sites (including the Alcazaba and Gibralfaro castles), and the Picasso Museum, which is dedicated to the famous Spanish artist who was born in the city.\\n\\nThese are just a few of the many wonderful cities in Spain.'}, 'model_name': 'mistralai/Mixtral-8x7B-Instruct-v0.1'}]
`,rt,ee,ct,te,sl="The task to evaluate the responses needs as input a list of generations. However, each model response was saved in the generation column of the subsets <code>text_generation_0</code> and <code>text_generation_1</code>. We will combine these two columns into a single column and the <code>default</code> subset.",pt,le,nl="<li>Component: <code>GroupColumns</code></li> <li>Input columns: <code>generation</code> and <code>model_name</code>from <code>text_generation_0</code> and <code>text_generation_1</code></li> <li>Output columns: <code>generations</code> and <code>model_names</code></li>",ut,ae,yt,se,dt,ne,il='To build our preference dataset, we need to evaluate the responses generated by the models. We will use <a href="https://huggingface.co/meta-llama/Meta-Llama-3-70B-Instruct" rel="nofollow"><code>meta-llama/Meta-Llama-3-70B-Instruct</code></a> for this, applying the <code>UltraFeedback</code> task that judges the responses according to different dimensions (helpfulness, honesty, instruction-following, truthfulness).',ht,ie,ol="<li>Component: <code>UltraFeedback</code> task with LLMs using <code>InferenceEndpointsLLM</code></li> <li>Input columns: <code>instruction</code>, <code>generations</code></li> <li>Output columns: <code>ratings</code>, <code>rationales</code>, <code>distilabel_metadata</code>, <code>model_name</code></li>",mt,oe,Ml='For your use case and to improve the results, you can use any <a href="https://distilabel.argilla.io/latest/components-gallery/llms/" rel="nofollow">other LLM of your choice</a>.',Ut,Me,jt,re,wt,ce,rl="<li>You can automatically convert it to a preference dataset with the <code>chosen</code> and <code>rejected</code> columns.<ul><li>Component: <code>FormatTextGenerationDPO</code> step</li> <li>Input columns: <code>instruction</code>, <code>generations</code>, <code>generation_models</code>, <code>ratings</code></li> <li>Output columns: <code>prompt</code>, <code>prompt_id</code>, <code>chosen</code>, <code>chosen_model</code>, <code>chosen_rating</code>, <code>rejected</code>, <code>rejected_model</code>, <code>rejected_rating</code></li></ul></li>",Tt,pe,Jt,ue,cl="<li>Or you can use Argilla to manually label the data and convert it to a preference dataset.<ul><li>Component: <code>PreferenceToArgilla</code> step</li> <li>Input columns: <code>instruction</code>, <code>generations</code>, <code>generation_models</code>, <code>ratings</code></li> <li>Output columns: <code>instruction</code>, <code>generations</code>, <code>generation_models</code>, <code>ratings</code></li></ul></li>",ft,ye,Ct,de,gt,he,pl="Below, you can see the full pipeline definition:",It,me,bt,Ue,ul="Let’s now run the pipeline and generate the preference dataset.",At,je,Gt,we,yl='Let’s check the preference dataset! If you have loaded the data to Argilla, you can <a href="https://docs.argilla.io/latest/how_to_guides/annotate/" rel="nofollow">start annotating in the Argilla UI</a>.',kt,Te,dl='You can push the dataset to the Hub for sharing with the community and <a href="https://huggingface.co/docs/hub/datasets-viewer-embed" rel="nofollow">embed it to explore the data</a>.',Bt,Je,$t,j,hl,Wt,fe,vt,Ce,ml="In this tutorial, we showcased the detailed steps to build a pipeline for generating a preference dataset using distilabel. You can customize this pipeline for your own use cases and share your datasets with the community through the Hugging Face Hub, or use them to train a model for DPO or ORPO.",Zt,ge,Ul="We used a dataset containing prompts to generate responses using two different models through the serverless Hugging Face Inference API. Next, we evaluated the responses using a third model, following the UltraFeedback standards. Finally, we converted the data to a preference dataset and used Argilla for further curation.",Et,Ie,St,Ae,_t;return J=new Al({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/generate_preference_dataset_distilabel.ipynb"}]}}),f=new bl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),C=new m({props:{title:"Generate a Preference Dataset with distilabel",local:"generate-a-preference-dataset-with-distilabel",headingTag:"h1"}}),k=new m({props:{title:"Getting started",local:"getting-started",headingTag:"h2"}}),B=new m({props:{title:"Install the dependencies",local:"install-the-dependencies",headingTag:"h3"}}),W=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJkaXN0aWxhYmVsJTVCaGYtaW5mZXJlbmNlLWVuZHBvaW50cyU1RCUyMg==",highlighted:'!pip install <span class="hljs-string">&quot;distilabel[hf-inference-endpoints]&quot;</span>',wrap:!1}}),v=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJ0cmFuc2Zvcm1lcnN+JTNENC4wJTIyJTIwJTIydG9yY2h+JTNEMi4wJTIy",highlighted:'!pip install <span class="hljs-string">&quot;transformers~=4.0&quot;</span> <span class="hljs-string">&quot;torch~=2.0&quot;</span>',wrap:!1}}),E=new h({props:{code:"ZnJvbSUyMGRpc3RpbGFiZWwubGxtcyUyMGltcG9ydCUyMEluZmVyZW5jZUVuZHBvaW50c0xMTSUwQWZyb20lMjBkaXN0aWxhYmVsLnBpcGVsaW5lJTIwaW1wb3J0JTIwUGlwZWxpbmUlMEFmcm9tJTIwZGlzdGlsYWJlbC5zdGVwcyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBMb2FkRGF0YUZyb21IdWIlMkMlMEElMjAlMjAlMjAlMjBHcm91cENvbHVtbnMlMkMlMEElMjAlMjAlMjAlMjBGb3JtYXRUZXh0R2VuZXJhdGlvbkRQTyUyQyUwQSUyMCUyMCUyMCUyMFByZWZlcmVuY2VUb0FyZ2lsbGElMkMlMEEpJTBBZnJvbSUyMGRpc3RpbGFiZWwuc3RlcHMudGFza3MlMjBpbXBvcnQlMjBUZXh0R2VuZXJhdGlvbiUyQyUyMFVsdHJhRmVlZGJhY2s=",highlighted:`<span class="hljs-keyword">from</span> distilabel.llms <span class="hljs-keyword">import</span> InferenceEndpointsLLM
<span class="hljs-keyword">from</span> distilabel.pipeline <span class="hljs-keyword">import</span> Pipeline
<span class="hljs-keyword">from</span> distilabel.steps <span class="hljs-keyword">import</span> (
    LoadDataFromHub,
    GroupColumns,
    FormatTextGenerationDPO,
    PreferenceToArgilla,
)
<span class="hljs-keyword">from</span> distilabel.steps.tasks <span class="hljs-keyword">import</span> TextGeneration, UltraFeedback`,wrap:!1}}),_=new h({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbG9naW4lMEElMEFsb2dpbih0b2tlbiUzRG9zLmdldGVudiglMjJIRl9UT0tFTiUyMiklMkMlMjBhZGRfdG9fZ2l0X2NyZWRlbnRpYWwlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login

login(token=os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>), add_to_git_credential=<span class="hljs-literal">True</span>)`,wrap:!1}}),x=new m({props:{title:"(optional) Deploy Argilla",local:"optional-deploy-argilla",headingTag:"h3"}}),V=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJkaXN0aWxhYmVsJTVCYXJnaWxsYSUyQyUyMGhmLWluZmVyZW5jZS1lbmRwb2ludHMlNUQlMjI=",highlighted:'!pip install <span class="hljs-string">&quot;distilabel[argilla, hf-inference-endpoints]&quot;</span>',wrap:!1}}),Q=new m({props:{title:"Define the pipeline",local:"define-the-pipeline",headingTag:"h2"}}),F=new m({props:{title:"Load the dataset",local:"load-the-dataset",headingTag:"h3"}}),H=new h({props:{code:"bG9hZF9kYXRhc2V0JTIwJTNEJTIwTG9hZERhdGFGcm9tSHViKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjAlMjJhcmdpbGxhJTJGMTBLcHJvbXB0cy1taW5pJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2V4YW1wbGVzJTNEMSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBpcGVsaW5lJTNEUGlwZWxpbmUobmFtZSUzRCUyMnNob3djYXNlLXBpcGVsaW5lJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCklMEFsb2FkX2RhdGFzZXQubG9hZCgpJTBBbmV4dChsb2FkX2RhdGFzZXQucHJvY2VzcygpKQ==",highlighted:`load_dataset = LoadDataFromHub(
        repo_id= <span class="hljs-string">&quot;argilla/10Kprompts-mini&quot;</span>,
        num_examples=<span class="hljs-number">1</span>,
        pipeline=Pipeline(name=<span class="hljs-string">&quot;showcase-pipeline&quot;</span>),
    )
load_dataset.load()
<span class="hljs-built_in">next</span>(load_dataset.process())`,wrap:!1}}),Y=new m({props:{title:"Generate responses",local:"generate-responses",headingTag:"h3"}}),K=new h({props:{code:"Z2VuZXJhdGVfcmVzcG9uc2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwVGV4dEdlbmVyYXRpb24oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGxtJTNESW5mZXJlbmNlRW5kcG9pbnRzTExNKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsX2lkJTNEJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRva2VuaXplcl9pZCUzRCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnZW5lcmF0aW9uX2t3YXJncyUzRCU3QiUyMm1heF9uZXdfdG9rZW5zJTIyJTNBJTIwNTEyJTJDJTIwJTIydGVtcGVyYXR1cmUlMjIlM0ElMjAwLjclN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlwZWxpbmUlM0RQaXBlbGluZShuYW1lJTNEJTIyc2hvd2Nhc2UtcGlwZWxpbmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMFRleHRHZW5lcmF0aW9uKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxsbSUzREluZmVyZW5jZUVuZHBvaW50c0xMTSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCUyMm1pc3RyYWxhaSUyRk1peHRyYWwtOHg3Qi1JbnN0cnVjdC12MC4xJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9rZW5pemVyX2lkJTNEJTIybWlzdHJhbGFpJTJGTWl4dHJhbC04eDdCLUluc3RydWN0LXYwLjElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnZW5lcmF0aW9uX2t3YXJncyUzRCU3QiUyMm1heF9uZXdfdG9rZW5zJTIyJTNBJTIwNTEyJTJDJTIwJTIydGVtcGVyYXR1cmUlMjIlM0ElMjAwLjclN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlwZWxpbmUlM0RQaXBlbGluZShuYW1lJTNEJTIyc2hvd2Nhc2UtcGlwZWxpbmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKSUyQyUwQSU1RCUwQWZvciUyMHRhc2slMjBpbiUyMGdlbmVyYXRlX3Jlc3BvbnNlcyUzQSUwQSUyMCUyMCUyMCUyMHRhc2subG9hZCgpJTBBJTIwJTIwJTIwJTIwcHJpbnQobmV4dCh0YXNrLnByb2Nlc3MoJTVCJTdCJTIyaW5zdHJ1Y3Rpb24lMjIlM0ElMjAlMjJXaGljaCUyMGFyZSUyMHRoZSUyMHRvcCUyMGNpdGllcyUyMGluJTIwU3BhaW4lM0YlMjIlN0QlNUQpKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generate_responses = [
<span class="hljs-meta">... </span>    TextGeneration(
<span class="hljs-meta">... </span>        llm=InferenceEndpointsLLM(
<span class="hljs-meta">... </span>            model_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>            tokenizer_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>            generation_kwargs={<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>},
<span class="hljs-meta">... </span>        ),
<span class="hljs-meta">... </span>        pipeline=Pipeline(name=<span class="hljs-string">&quot;showcase-pipeline&quot;</span>),
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>    TextGeneration(
<span class="hljs-meta">... </span>        llm=InferenceEndpointsLLM(
<span class="hljs-meta">... </span>            model_id=<span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>,
<span class="hljs-meta">... </span>            tokenizer_id=<span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>,
<span class="hljs-meta">... </span>            generation_kwargs={<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>},
<span class="hljs-meta">... </span>        ),
<span class="hljs-meta">... </span>        pipeline=Pipeline(name=<span class="hljs-string">&quot;showcase-pipeline&quot;</span>),
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> task <span class="hljs-keyword">in</span> generate_responses:
<span class="hljs-meta">... </span>    task.load()
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-built_in">next</span>(task.process([{<span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;Which are the top cities in Spain?&quot;</span>}])))`,wrap:!1}}),ee=new m({props:{title:"Group the responses",local:"group-the-responses",headingTag:"h3"}}),ae=new h({props:{code:"Z3JvdXBfcmVzcG9uc2VzJTIwJTNEJTIwR3JvdXBDb2x1bW5zKCUwQSUyMCUyMCUyMCUyMGNvbHVtbnMlM0QlNUIlMjJnZW5lcmF0aW9uJTIyJTJDJTIwJTIybW9kZWxfbmFtZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dF9jb2x1bW5zJTNEJTVCJTIyZ2VuZXJhdGlvbnMlMjIlMkMlMjAlMjJtb2RlbF9uYW1lcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBpcGVsaW5lJTNEUGlwZWxpbmUobmFtZSUzRCUyMnNob3djYXNlLXBpcGVsaW5lJTIyKSUyQyUwQSklMEFuZXh0KCUwQSUyMCUyMCUyMCUyMGdyb3VwX3Jlc3BvbnNlcy5wcm9jZXNzKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmdlbmVyYXRpb24lMjIlM0ElMjAlMjJNYWRyaWQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtb2RlbF9uYW1lJTIyJTNBJTIwJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmdlbmVyYXRpb24lMjIlM0ElMjAlMjJCYXJjZWxvbmElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtb2RlbF9uYW1lJTIyJTNBJTIwJTIybWlzdHJhbGFpJTJGTWl4dHJhbC04eDdCLUluc3RydWN0LXYwLjElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjApJTBBKQ==",highlighted:`group_responses = GroupColumns(
    columns=[<span class="hljs-string">&quot;generation&quot;</span>, <span class="hljs-string">&quot;model_name&quot;</span>],
    output_columns=[<span class="hljs-string">&quot;generations&quot;</span>, <span class="hljs-string">&quot;model_names&quot;</span>],
    pipeline=Pipeline(name=<span class="hljs-string">&quot;showcase-pipeline&quot;</span>),
)
<span class="hljs-built_in">next</span>(
    group_responses.process(
        [
            {
                <span class="hljs-string">&quot;generation&quot;</span>: <span class="hljs-string">&quot;Madrid&quot;</span>,
                <span class="hljs-string">&quot;model_name&quot;</span>: <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
            },
        ],
        [
            {
                <span class="hljs-string">&quot;generation&quot;</span>: <span class="hljs-string">&quot;Barcelona&quot;</span>,
                <span class="hljs-string">&quot;model_name&quot;</span>: <span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>,
            }
        ],
    )
)`,wrap:!1}}),se=new m({props:{title:"Evaluate the responses",local:"evaluate-the-responses",headingTag:"h3"}}),Me=new h({props:{code:"ZXZhbHVhdGVfcmVzcG9uc2VzJTIwJTNEJTIwVWx0cmFGZWVkYmFjayglMEElMjAlMjAlMjAlMjBhc3BlY3QlM0QlMjJvdmVyYWxsLXJhdGluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMGxsbSUzREluZmVyZW5jZUVuZHBvaW50c0xMTSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtNzBCLUluc3RydWN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9rZW5pemVyX2lkJTNEJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy03MEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnZW5lcmF0aW9uX2t3YXJncyUzRCU3QiUyMm1heF9uZXdfdG9rZW5zJTIyJTNBJTIwNTEyJTJDJTIwJTIydGVtcGVyYXR1cmUlMjIlM0ElMjAwLjclN0QlMkMlMEElMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmUlM0RQaXBlbGluZShuYW1lJTNEJTIyc2hvd2Nhc2UtcGlwZWxpbmUlMjIpJTJDJTBBKSUwQWV2YWx1YXRlX3Jlc3BvbnNlcy5sb2FkKCklMEFuZXh0KCUwQSUyMCUyMCUyMCUyMGV2YWx1YXRlX3Jlc3BvbnNlcy5wcm9jZXNzKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmluc3RydWN0aW9uJTIyJTNBJTIwJTIyV2hhdCdzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwU3BhaW4lM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJnZW5lcmF0aW9ucyUyMiUzQSUyMCU1QiUyMk1hZHJpZCUyMiUyQyUyMCUyMkJhcmNlbG9uYSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCklMEEp",highlighted:`evaluate_responses = UltraFeedback(
    aspect=<span class="hljs-string">&quot;overall-rating&quot;</span>,
    llm=InferenceEndpointsLLM(
        model_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>,
        tokenizer_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>,
        generation_kwargs={<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>},
    ),
    pipeline=Pipeline(name=<span class="hljs-string">&quot;showcase-pipeline&quot;</span>),
)
evaluate_responses.load()
<span class="hljs-built_in">next</span>(
    evaluate_responses.process(
        [
            {
                <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the capital of Spain?&quot;</span>,
                <span class="hljs-string">&quot;generations&quot;</span>: [<span class="hljs-string">&quot;Madrid&quot;</span>, <span class="hljs-string">&quot;Barcelona&quot;</span>],
            }
        ]
    )
)`,wrap:!1}}),re=new m({props:{title:"Convert to a preference dataset",local:"convert-to-a-preference-dataset",headingTag:"h3"}}),pe=new h({props:{code:"Zm9ybWF0X2RwbyUyMCUzRCUyMEZvcm1hdFRleHRHZW5lcmF0aW9uRFBPKHBpcGVsaW5lJTNEUGlwZWxpbmUobmFtZSUzRCUyMnNob3djYXNlLXBpcGVsaW5lJTIyKSklMEFmb3JtYXRfZHBvLmxvYWQoKSUwQW5leHQoJTBBJTIwJTIwJTIwJTIwZm9ybWF0X2Rwby5wcm9jZXNzKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmluc3RydWN0aW9uJTIyJTNBJTIwJTIyV2hhdCdzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwU3BhaW4lM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJnZW5lcmF0aW9ucyUyMiUzQSUyMCU1QiUyMk1hZHJpZCUyMiUyQyUyMCUyMkJhcmNlbG9uYSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmdlbmVyYXRpb25fbW9kZWxzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTWV0YS1MbGFtYS0zLThCLUluc3RydWN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTWl4dHJhbC04eDdCLUluc3RydWN0LXYwLjElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyYXRpbmdzJTIyJTNBJTIwJTVCNSUyQyUyMDElNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjApJTBBKQ==",highlighted:`format_dpo = FormatTextGenerationDPO(pipeline=Pipeline(name=<span class="hljs-string">&quot;showcase-pipeline&quot;</span>))
format_dpo.load()
<span class="hljs-built_in">next</span>(
    format_dpo.process(
        [
            {
                <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the capital of Spain?&quot;</span>,
                <span class="hljs-string">&quot;generations&quot;</span>: [<span class="hljs-string">&quot;Madrid&quot;</span>, <span class="hljs-string">&quot;Barcelona&quot;</span>],
                <span class="hljs-string">&quot;generation_models&quot;</span>: [
                    <span class="hljs-string">&quot;Meta-Llama-3-8B-Instruct&quot;</span>,
                    <span class="hljs-string">&quot;Mixtral-8x7B-Instruct-v0.1&quot;</span>,
                ],
                <span class="hljs-string">&quot;ratings&quot;</span>: [<span class="hljs-number">5</span>, <span class="hljs-number">1</span>],
            }
        ]
    )
)`,wrap:!1}}),ye=new h({props:{code:"dG9fYXJnaWxsYSUyMCUzRCUyMFByZWZlcmVuY2VUb0FyZ2lsbGEoJTBBJTIwJTIwJTIwJTIwZGF0YXNldF9uYW1lJTNEJTIycHJlZmVyZW5jZS1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF93b3Jrc3BhY2UlM0QlMjJhcmdpbGxhJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX3VybCUzRCUyMmh0dHBzJTNBJTJGJTJGJTVCeW91ci1vd25lci1uYW1lJTVELSU1QnlvdXItc3BhY2UtbmFtZSU1RC5oZi5zcGFjZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0QlMjIlNUJ5b3VyLWFwaS1rZXklNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fZ2VuZXJhdGlvbnMlM0QyJTBBKQ==",highlighted:`to_argilla = PreferenceToArgilla(
    dataset_name=<span class="hljs-string">&quot;preference-dataset&quot;</span>,
    dataset_workspace=<span class="hljs-string">&quot;argilla&quot;</span>,
    api_url=<span class="hljs-string">&quot;https://[your-owner-name]-[your-space-name].hf.space&quot;</span>,
    api_key=<span class="hljs-string">&quot;[your-api-key]&quot;</span>,
    num_generations=<span class="hljs-number">2</span>
)`,wrap:!1}}),de=new m({props:{title:"Run the pipeline",local:"run-the-pipeline",headingTag:"h2"}}),me=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">with</span> Pipeline(name=<span class="hljs-string">&quot;generate-dataset&quot;</span>) <span class="hljs-keyword">as</span> pipeline:

    load_dataset = LoadDataFromHub(repo_id=<span class="hljs-string">&quot;argilla/10Kprompts-mini&quot;</span>)

    generate_responses = [
        TextGeneration(
            llm=InferenceEndpointsLLM(
                model_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
                tokenizer_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
                generation_kwargs={<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>},
            )
        ),
        TextGeneration(
            llm=InferenceEndpointsLLM(
                model_id=<span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>,
                tokenizer_id=<span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>,
                generation_kwargs={<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>},
            )
        ),
    ]

    group_responses = GroupColumns(
        columns=[<span class="hljs-string">&quot;generation&quot;</span>, <span class="hljs-string">&quot;model_name&quot;</span>],
        output_columns=[<span class="hljs-string">&quot;generations&quot;</span>, <span class="hljs-string">&quot;model_names&quot;</span>],
    )

    evaluate_responses = UltraFeedback(
        aspect=<span class="hljs-string">&quot;overall-rating&quot;</span>,
        llm=InferenceEndpointsLLM(
            model_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>,
            tokenizer_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>,
            generation_kwargs={<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>},
        )
    )

    format_dpo = FormatTextGenerationDPO()

    to_argilla = PreferenceToArgilla(
        dataset_name=<span class="hljs-string">&quot;preference-dataset&quot;</span>,
        dataset_workspace=<span class="hljs-string">&quot;argilla&quot;</span>,
        api_url=<span class="hljs-string">&quot;https://[your-owner-name]-[your-space-name].hf.space&quot;</span>,
        api_key=<span class="hljs-string">&quot;[your-api-key]&quot;</span>,
        num_generations=<span class="hljs-number">2</span>
    )

    <span class="hljs-keyword">for</span> task <span class="hljs-keyword">in</span> generate_responses:
        load_dataset.connect(task)
        task.connect(group_responses)
    group_responses.connect(evaluate_responses)
    evaluate_responses.connect(format_dpo, to_argilla)`,wrap:!1}}),je=new h({props:{code:"ZGlzdGlzZXQlMjAlM0QlMjBwaXBlbGluZS5ydW4oKQ==",highlighted:"distiset = pipeline.run()",wrap:!1}}),Je=new h({props:{code:"ZGlzdGlzZXQucHVzaF90b19odWIoJTIyJTVCeW91ci1vd25lci1uYW1lJTVEJTJGZXhhbXBsZS1wcmVmZXJlbmNlLWRhdGFzZXQlMjIp",highlighted:'distiset.push_to_hub(<span class="hljs-string">&quot;[your-owner-name]/example-preference-dataset&quot;</span>)',wrap:!1}}),fe=new m({props:{title:"Conclusions",local:"conclusions",headingTag:"h2"}}),Ie=new Gl({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/generate_preference_dataset_distilabel.md"}}),{c(){T=i("meta"),Ge=s(),be=i("p"),ke=s(),r(J.$$.fragment),Be=s(),r(f.$$.fragment),$e=s(),r(C.$$.fragment),We=s(),g=i("p"),g.innerHTML=Rt,ve=s(),I=i("ul"),I.innerHTML=Vt,Ze=s(),b=i("p"),b.innerHTML=Qt,Ee=s(),A=i("p"),A.innerHTML=Lt,Se=s(),G=i("p"),G.innerHTML=Ft,_e=s(),r(k.$$.fragment),xe=s(),r(B.$$.fragment),qe=s(),$=i("p"),$.innerHTML=Xt,Re=s(),r(W.$$.fragment),Ve=s(),r(v.$$.fragment),Qe=s(),Z=i("p"),Z.textContent=Nt,Le=s(),r(E.$$.fragment),Fe=s(),S=i("p"),S.innerHTML=Ht,Xe=s(),r(_.$$.fragment),Ne=s(),r(x.$$.fragment),He=s(),q=i("p"),q.innerHTML=Yt,Ye=s(),R=i("p"),R.textContent=zt,ze=s(),r(V.$$.fragment),Pe=s(),r(Q.$$.fragment),De=s(),L=i("p"),L.innerHTML=Pt,Ke=s(),r(F.$$.fragment),Oe=s(),X=i("p"),X.innerHTML=Dt,et=s(),U=i("iframe"),tt=s(),N=i("ul"),N.innerHTML=Ot,lt=s(),r(H.$$.fragment),at=s(),r(Y.$$.fragment),st=s(),z=i("p"),z.innerHTML=el,nt=s(),P=i("ul"),P.innerHTML=tl,it=s(),D=i("p"),D.innerHTML=ll,ot=s(),r(K.$$.fragment),Mt=s(),O=i("pre"),O.textContent=al,rt=s(),r(ee.$$.fragment),ct=s(),te=i("p"),te.innerHTML=sl,pt=s(),le=i("ul"),le.innerHTML=nl,ut=s(),r(ae.$$.fragment),yt=s(),r(se.$$.fragment),dt=s(),ne=i("p"),ne.innerHTML=il,ht=s(),ie=i("ul"),ie.innerHTML=ol,mt=s(),oe=i("p"),oe.innerHTML=Ml,Ut=s(),r(Me.$$.fragment),jt=s(),r(re.$$.fragment),wt=s(),ce=i("ul"),ce.innerHTML=rl,Tt=s(),r(pe.$$.fragment),Jt=s(),ue=i("ul"),ue.innerHTML=cl,ft=s(),r(ye.$$.fragment),Ct=s(),r(de.$$.fragment),gt=s(),he=i("p"),he.textContent=pl,It=s(),r(me.$$.fragment),bt=s(),Ue=i("p"),Ue.textContent=ul,At=s(),r(je.$$.fragment),Gt=s(),we=i("p"),we.innerHTML=yl,kt=s(),Te=i("p"),Te.innerHTML=dl,Bt=s(),r(Je.$$.fragment),$t=s(),j=i("iframe"),Wt=s(),r(fe.$$.fragment),vt=s(),Ce=i("p"),Ce.textContent=ml,Zt=s(),ge=i("p"),ge.textContent=Ul,Et=s(),r(Ie.$$.fragment),St=s(),Ae=i("p"),this.h()},l(e){const t=gl("svelte-u9bgzb",document.head);T=o(t,"META",{name:!0,content:!0}),t.forEach(l),Ge=n(e),be=o(e,"P",{}),xt(be).forEach(l),ke=n(e),c(J.$$.fragment,e),Be=n(e),c(f.$$.fragment,e),$e=n(e),c(C.$$.fragment,e),We=n(e),g=o(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-gisfdz"&&(g.innerHTML=Rt),ve=n(e),I=o(e,"UL",{"data-svelte-h":!0}),M(I)!=="svelte-1125nkr"&&(I.innerHTML=Vt),Ze=n(e),b=o(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-14ghd0x"&&(b.innerHTML=Qt),Ee=n(e),A=o(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-1l44s89"&&(A.innerHTML=Lt),Se=n(e),G=o(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1tx7tfk"&&(G.innerHTML=Ft),_e=n(e),c(k.$$.fragment,e),xe=n(e),c(B.$$.fragment,e),qe=n(e),$=o(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-48yyh0"&&($.innerHTML=Xt),Re=n(e),c(W.$$.fragment,e),Ve=n(e),c(v.$$.fragment,e),Qe=n(e),Z=o(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1efpmun"&&(Z.textContent=Nt),Le=n(e),c(E.$$.fragment,e),Fe=n(e),S=o(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-cc667m"&&(S.innerHTML=Ht),Xe=n(e),c(_.$$.fragment,e),Ne=n(e),c(x.$$.fragment,e),He=n(e),q=o(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-104zazh"&&(q.innerHTML=Yt),Ye=n(e),R=o(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-nd7qbb"&&(R.textContent=zt),ze=n(e),c(V.$$.fragment,e),Pe=n(e),c(Q.$$.fragment,e),De=n(e),L=o(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-phdqc7"&&(L.innerHTML=Pt),Ke=n(e),c(F.$$.fragment,e),Oe=n(e),X=o(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-mi4gjp"&&(X.innerHTML=Dt),et=n(e),U=o(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),xt(U).forEach(l),tt=n(e),N=o(e,"UL",{"data-svelte-h":!0}),M(N)!=="svelte-1orqye3"&&(N.innerHTML=Ot),lt=n(e),c(H.$$.fragment,e),at=n(e),c(Y.$$.fragment,e),st=n(e),z=o(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-1s34ial"&&(z.innerHTML=el),nt=n(e),P=o(e,"UL",{"data-svelte-h":!0}),M(P)!=="svelte-1u4djwu"&&(P.innerHTML=tl),it=n(e),D=o(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-wb9t0n"&&(D.innerHTML=ll),ot=n(e),c(K.$$.fragment,e),Mt=n(e),O=o(e,"PRE",{"data-svelte-h":!0}),M(O)!=="svelte-1yyf24g"&&(O.textContent=al),rt=n(e),c(ee.$$.fragment,e),ct=n(e),te=o(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-u7i2or"&&(te.innerHTML=sl),pt=n(e),le=o(e,"UL",{"data-svelte-h":!0}),M(le)!=="svelte-1l4lk1a"&&(le.innerHTML=nl),ut=n(e),c(ae.$$.fragment,e),yt=n(e),c(se.$$.fragment,e),dt=n(e),ne=o(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-1l4awig"&&(ne.innerHTML=il),ht=n(e),ie=o(e,"UL",{"data-svelte-h":!0}),M(ie)!=="svelte-1lich0g"&&(ie.innerHTML=ol),mt=n(e),oe=o(e,"P",{"data-svelte-h":!0}),M(oe)!=="svelte-wb9t0n"&&(oe.innerHTML=Ml),Ut=n(e),c(Me.$$.fragment,e),jt=n(e),c(re.$$.fragment,e),wt=n(e),ce=o(e,"UL",{"data-svelte-h":!0}),M(ce)!=="svelte-1ni35zr"&&(ce.innerHTML=rl),Tt=n(e),c(pe.$$.fragment,e),Jt=n(e),ue=o(e,"UL",{"data-svelte-h":!0}),M(ue)!=="svelte-x0h38s"&&(ue.innerHTML=cl),ft=n(e),c(ye.$$.fragment,e),Ct=n(e),c(de.$$.fragment,e),gt=n(e),he=o(e,"P",{"data-svelte-h":!0}),M(he)!=="svelte-z5tzhe"&&(he.textContent=pl),It=n(e),c(me.$$.fragment,e),bt=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),M(Ue)!=="svelte-13atkrj"&&(Ue.textContent=ul),At=n(e),c(je.$$.fragment,e),Gt=n(e),we=o(e,"P",{"data-svelte-h":!0}),M(we)!=="svelte-17uzlyb"&&(we.innerHTML=yl),kt=n(e),Te=o(e,"P",{"data-svelte-h":!0}),M(Te)!=="svelte-1cen2j5"&&(Te.innerHTML=dl),Bt=n(e),c(Je.$$.fragment,e),$t=n(e),j=o(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),xt(j).forEach(l),Wt=n(e),c(fe.$$.fragment,e),vt=n(e),Ce=o(e,"P",{"data-svelte-h":!0}),M(Ce)!=="svelte-1pikznd"&&(Ce.textContent=ml),Zt=n(e),ge=o(e,"P",{"data-svelte-h":!0}),M(ge)!=="svelte-spvgbj"&&(ge.textContent=Ul),Et=n(e),c(Ie.$$.fragment,e),St=n(e),Ae=o(e,"P",{}),xt(Ae).forEach(l),this.h()},h(){w(T,"name","hf:doc:metadata"),w(T,"content",Bl),jl(U.src,Kt="https://huggingface.co/datasets/argilla/10Kprompts-mini/embed/viewer/default/train")||w(U,"src",Kt),w(U,"frameborder","0"),w(U,"width","100%"),w(U,"height","560px"),jl(j.src,hl="https://huggingface.co/datasets/distilabel-internal-testing/example-generate-preference-dataset/embed/viewer/format_text_generation_d_p_o_0/train")||w(j,"src",hl),w(j,"frameborder","0"),w(j,"width","100%"),w(j,"height","560px")},m(e,t){Il(document.head,T),a(e,Ge,t),a(e,be,t),a(e,ke,t),p(J,e,t),a(e,Be,t),p(f,e,t),a(e,$e,t),p(C,e,t),a(e,We,t),a(e,g,t),a(e,ve,t),a(e,I,t),a(e,Ze,t),a(e,b,t),a(e,Ee,t),a(e,A,t),a(e,Se,t),a(e,G,t),a(e,_e,t),p(k,e,t),a(e,xe,t),p(B,e,t),a(e,qe,t),a(e,$,t),a(e,Re,t),p(W,e,t),a(e,Ve,t),p(v,e,t),a(e,Qe,t),a(e,Z,t),a(e,Le,t),p(E,e,t),a(e,Fe,t),a(e,S,t),a(e,Xe,t),p(_,e,t),a(e,Ne,t),p(x,e,t),a(e,He,t),a(e,q,t),a(e,Ye,t),a(e,R,t),a(e,ze,t),p(V,e,t),a(e,Pe,t),p(Q,e,t),a(e,De,t),a(e,L,t),a(e,Ke,t),p(F,e,t),a(e,Oe,t),a(e,X,t),a(e,et,t),a(e,U,t),a(e,tt,t),a(e,N,t),a(e,lt,t),p(H,e,t),a(e,at,t),p(Y,e,t),a(e,st,t),a(e,z,t),a(e,nt,t),a(e,P,t),a(e,it,t),a(e,D,t),a(e,ot,t),p(K,e,t),a(e,Mt,t),a(e,O,t),a(e,rt,t),p(ee,e,t),a(e,ct,t),a(e,te,t),a(e,pt,t),a(e,le,t),a(e,ut,t),p(ae,e,t),a(e,yt,t),p(se,e,t),a(e,dt,t),a(e,ne,t),a(e,ht,t),a(e,ie,t),a(e,mt,t),a(e,oe,t),a(e,Ut,t),p(Me,e,t),a(e,jt,t),p(re,e,t),a(e,wt,t),a(e,ce,t),a(e,Tt,t),p(pe,e,t),a(e,Jt,t),a(e,ue,t),a(e,ft,t),p(ye,e,t),a(e,Ct,t),p(de,e,t),a(e,gt,t),a(e,he,t),a(e,It,t),p(me,e,t),a(e,bt,t),a(e,Ue,t),a(e,At,t),p(je,e,t),a(e,Gt,t),a(e,we,t),a(e,kt,t),a(e,Te,t),a(e,Bt,t),p(Je,e,t),a(e,$t,t),a(e,j,t),a(e,Wt,t),p(fe,e,t),a(e,vt,t),a(e,Ce,t),a(e,Zt,t),a(e,ge,t),a(e,Et,t),p(Ie,e,t),a(e,St,t),a(e,Ae,t),_t=!0},p:Tl,i(e){_t||(u(J.$$.fragment,e),u(f.$$.fragment,e),u(C.$$.fragment,e),u(k.$$.fragment,e),u(B.$$.fragment,e),u(W.$$.fragment,e),u(v.$$.fragment,e),u(E.$$.fragment,e),u(_.$$.fragment,e),u(x.$$.fragment,e),u(V.$$.fragment,e),u(Q.$$.fragment,e),u(F.$$.fragment,e),u(H.$$.fragment,e),u(Y.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(ae.$$.fragment,e),u(se.$$.fragment,e),u(Me.$$.fragment,e),u(re.$$.fragment,e),u(pe.$$.fragment,e),u(ye.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(je.$$.fragment,e),u(Je.$$.fragment,e),u(fe.$$.fragment,e),u(Ie.$$.fragment,e),_t=!0)},o(e){y(J.$$.fragment,e),y(f.$$.fragment,e),y(C.$$.fragment,e),y(k.$$.fragment,e),y(B.$$.fragment,e),y(W.$$.fragment,e),y(v.$$.fragment,e),y(E.$$.fragment,e),y(_.$$.fragment,e),y(x.$$.fragment,e),y(V.$$.fragment,e),y(Q.$$.fragment,e),y(F.$$.fragment,e),y(H.$$.fragment,e),y(Y.$$.fragment,e),y(K.$$.fragment,e),y(ee.$$.fragment,e),y(ae.$$.fragment,e),y(se.$$.fragment,e),y(Me.$$.fragment,e),y(re.$$.fragment,e),y(pe.$$.fragment,e),y(ye.$$.fragment,e),y(de.$$.fragment,e),y(me.$$.fragment,e),y(je.$$.fragment,e),y(Je.$$.fragment,e),y(fe.$$.fragment,e),y(Ie.$$.fragment,e),_t=!1},d(e){e&&(l(Ge),l(be),l(ke),l(Be),l($e),l(We),l(g),l(ve),l(I),l(Ze),l(b),l(Ee),l(A),l(Se),l(G),l(_e),l(xe),l(qe),l($),l(Re),l(Ve),l(Qe),l(Z),l(Le),l(Fe),l(S),l(Xe),l(Ne),l(He),l(q),l(Ye),l(R),l(ze),l(Pe),l(De),l(L),l(Ke),l(Oe),l(X),l(et),l(U),l(tt),l(N),l(lt),l(at),l(st),l(z),l(nt),l(P),l(it),l(D),l(ot),l(Mt),l(O),l(rt),l(ct),l(te),l(pt),l(le),l(ut),l(yt),l(dt),l(ne),l(ht),l(ie),l(mt),l(oe),l(Ut),l(jt),l(wt),l(ce),l(Tt),l(Jt),l(ue),l(ft),l(Ct),l(gt),l(he),l(It),l(bt),l(Ue),l(At),l(Gt),l(we),l(kt),l(Te),l(Bt),l($t),l(j),l(Wt),l(vt),l(Ce),l(Zt),l(ge),l(Et),l(St),l(Ae)),l(T),d(J,e),d(f,e),d(C,e),d(k,e),d(B,e),d(W,e),d(v,e),d(E,e),d(_,e),d(x,e),d(V,e),d(Q,e),d(F,e),d(H,e),d(Y,e),d(K,e),d(ee,e),d(ae,e),d(se,e),d(Me,e),d(re,e),d(pe,e),d(ye,e),d(de,e),d(me,e),d(je,e),d(Je,e),d(fe,e),d(Ie,e)}}}const Bl='{"title":"Generate a Preference Dataset with distilabel","local":"generate-a-preference-dataset-with-distilabel","sections":[{"title":"Getting started","local":"getting-started","sections":[{"title":"Install the dependencies","local":"install-the-dependencies","sections":[],"depth":3},{"title":"(optional) Deploy Argilla","local":"optional-deploy-argilla","sections":[],"depth":3}],"depth":2},{"title":"Define the pipeline","local":"define-the-pipeline","sections":[{"title":"Load the dataset","local":"load-the-dataset","sections":[],"depth":3},{"title":"Generate responses","local":"generate-responses","sections":[],"depth":3},{"title":"Group the responses","local":"group-the-responses","sections":[],"depth":3},{"title":"Evaluate the responses","local":"evaluate-the-responses","sections":[],"depth":3},{"title":"Convert to a preference dataset","local":"convert-to-a-preference-dataset","sections":[],"depth":3}],"depth":2},{"title":"Run the pipeline","local":"run-the-pipeline","sections":[],"depth":2},{"title":"Conclusions","local":"conclusions","sections":[],"depth":2}],"depth":1}';function $l(qt){return Jl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _l extends fl{constructor(T){super(),Cl(this,T,$l,kl,wl,{})}}export{_l as component};
