import{s as ce,n as Te,o as re}from"../chunks/scheduler.1f027d5a.js";import{S as we,i as ue,e as M,s as a,c as p,h as Ue,a as J,d as e,b as n,f as pe,g as i,j as o,k as ie,l as de,m as t,n as y,t as c,o as T,p as r}from"../chunks/index.5cb6ce42.js";import{C as je}from"../chunks/CopyLLMTxtMenu.f7108191.js";import{D as me,C as w}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as ye,E as Ie}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function he(Zs){let u,Il,jl,hl,U,bl,d,gl,j,Bl,m,Cs='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',Zl,I,fs='<p>This tutorial is advanced. You should have notions from <a href="advanced_rag">this other cookbook</a> first!</p>',Cl,h,Gs="<p>Reminder: Retrieval-Augmented-Generation (RAG) is “using an LLM to answer a user query, but basing the answer on information retrieved from a knowledge base”. It has many advantages over using a vanilla or fine-tuned LLM: to name a few, it allows to ground the answer on true facts and reduce confabulations, it allows to provide the LLM with domain-specific knowledge, and it allows fine-grained control of access to information from the knowledge base.</p>",fl,b,Ns="But vanilla RAG has limitations, most importantly these two:",Gl,g,Vs="<li>It <strong>performs only one retrieval step</strong>: if the results are bad, the generation in turn will be bad.</li> <li><strong>Semantic similarity is computed with the <em>user query</em> as a reference</strong>, which might be suboptimal: for instance, the user query will often be a question and the document containing the true answer will be in affirmative voice, so its similarity score will be downgraded compared to other source documents in the interrogative form, leading to a risk of missing the relevant information.</li>",Nl,B,Ws="But we can alleviate these problems by making a <strong>RAG agent: very simply, an agent armed with a retriever tool!</strong>",Vl,Z,vs="This agent will: ✅ Formulate the query itself and ✅ Critique to re-retrieve if needed.",Wl,C,Rs="So it should naively recover some advanced RAG techniques!",vl,f,Qs='<li>Instead of directly using the user query as the reference in semantic search, the agent formulates itself a reference sentence that can be closer to the targeted documents, as in <a href="https://huggingface.co/papers/2212.10496" rel="nofollow">HyDE</a></li> <li>The agent can the generated snippets and re-retrieve if needed, as in <a href="https://docs.llamaindex.ai/en/stable/examples/evaluation/RetryQuery/" rel="nofollow">Self-Query</a></li>',Rl,G,Xs="Let’s build this system. 🛠️",Ql,N,ks="Run the line below to install required dependencies:",Xl,V,kl,W,Es="Let’s login in order to call the HF Inference API:",El,v,ql,R,qs="We first load a knowledge base on which we want to perform RAG: this dataset is a compilation of the documentation pages for many <code>huggingface</code> packages, stored as markdown.",Yl,Q,_l,X,Ys="Now we prepare the knowledge base by processing the dataset and storing it into a vector database to be used by the retriever.",Al,k,_s=`We use <a href="https://python.langchain.com/" rel="nofollow">LangChain</a> for its excellent vector database utilities.
For the embedding model, we use <a href="https://huggingface.co/thenlper/gte-small" rel="nofollow">thenlper/gte-small</a> since it performed well in our <code>RAG_evaluation</code> cookbook.`,Hl,E,Sl,q,As=`Splitting documents...
`,xl,Y,Hs="Now the database is ready: let’s build our agentic RAG system!",zl,_,Ss="👉 We only need a <code>RetrieverTool</code> that our agent can leverage to retrieve information from the knowledge base.",Fl,A,xs='Since we need to add a vectordb as an attribute of the tool, we cannot simply use the <a href="https://huggingface.co/docs/transformers/main/en/agents#create-a-new-tool" rel="nofollow">simple tool constructor</a> with a <code>@tool</code> decorator: so we will follow the advanced setup highlighted in the <a href="https://huggingface.co/docs/transformers/main/en/agents_advanced#directly-define-a-tool-by-subclassing-tool-and-share-it-to-the-hub" rel="nofollow">advanced agents documentation</a>.',$l,H,Ll,S,zs="Now it’s straightforward to create an agent that leverages this tool!",Dl,x,Fs="The agent will need these arguments upon initialization:",Pl,z,$s="<li><em><code>tools</code></em>: a list of tools that the agent will be able to call.</li> <li><em><code>model</code></em>: the LLM that powers the agent.</li>",Kl,F,Ls='Our <code>model</code> must be a callable that takes as input a list of <a href="https://huggingface.co/docs/transformers/main/chat_templating" rel="nofollow">messages</a> and returns text. It also needs to accept a <code>stop_sequences</code> argument that indicates when to stop its generation. For convenience, we directly use the <code>InferenceClientModel</code> class provided in the package to get a LLM engine that calls our <a href="https://huggingface.co/docs/api-inference/en/index" rel="nofollow">Inference API</a>.',Ol,$,Ds='And we use <a href="https://huggingface.co/meta-llama/Llama-3.1-70B-Instruct" rel="nofollow">meta-llama/Llama-3.1-70B-Instruct</a>, served for free on Hugging Face’s Inference API!',ls,L,Ps='<em>Note:</em> The Inference API hosts models based on various criteria, and deployed models may be updated or replaced without prior notice. Learn more about it <a href="https://huggingface.co/docs/api-inference/supported-models" rel="nofollow">here</a>.',ss,D,es,P,Ks="Since we initialized the agent as a <code>ReactJsonAgent</code>, it has been automatically given a default system prompt that tells the LLM engine to process step-by-step and generate tool calls as JSON blobs (you could replace this prompt template with your own as needed).",ts,K,Os="Then when its <code>.run()</code> method is launched, the agent takes care of calling the LLM engine, parsing the tool call JSON blobs and executing these tool calls, all in a loop that ends only when the final answer is provided.",as,O,ns,ll,le=`Final output:
To push a model to the Hub, you can use the push_to_hub() method after training. You can also use the PushToHubCallback to upload checkpoints regularly during a longer training run. Additionally, you can push the model up to the hub using the api.upload_folder() method.
`,Ms,sl,Js,el,se="Does the agent setup make a better RAG system? Well, let’s compare it to a standard RAG system using LLM Judge!",os,tl,ee='We will use <a href="https://huggingface.co/meta-llama/Meta-Llama-3-70B-Instruct" rel="nofollow">meta-llama/Meta-Llama-3-70B-Instruct</a> for evaluation since it’s one of the strongest OS models we tested for LLM judge use cases.',ps,al,is,nl,te="Before running the test let’s make the agent less verbose.",ys,Ml,cs,Jl,Ts,ol,rs,pl,ae='The evaluation prompt follows some of the best principles shown in <a href="llm_judge">our llm_judge cookbook</a>: it follows a small integer Likert scale, has clear criteria, and a description for each score.',ws,il,us,yl,Us,cl,ds,Tl,js,rl,ne=`Average score for agentic RAG: 86.9%
Average score for standard RAG: 73.1%
`,ms,wl,Me="<strong>Let us recap: the Agent setup improves scores by 14% compared to a standard RAG!</strong> (from 73.1% to 86.9%)",Is,ul,Je="This is a great improvement, with a very simple setup 🚀",hs,Ul,oe="(For a baseline, using Llama-3-70B without the knowledge base got 36%)",bs,dl,gs,ml,Bs;return U=new me({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/agent_rag.ipynb"}]}}),d=new je({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new ye({props:{title:"Agentic RAG: turbocharge your RAG with query reformulation and self-query! 🚀",local:"agentic-rag-turbocharge-your-rag-with-query-reformulation-and-self-query-",headingTag:"h1"}}),V=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjBwYW5kYXMlMjBsYW5nY2hhaW4lMjBsYW5nY2hhaW4tY29tbXVuaXR5JTIwc2VudGVuY2UtdHJhbnNmb3JtZXJzJTIwZmFpc3MtY3B1JTIwc21vbGFnZW50cyUyMC0tdXBncmFkZSUyMC1x",highlighted:"!pip install pandas langchain langchain-community sentence-transformers faiss-cpu smolagents --upgrade -q",wrap:!1}}),v=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),Q=new w({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEElMEFrbm93bGVkZ2VfYmFzZSUyMCUzRCUyMGRhdGFzZXRzLmxvYWRfZGF0YXNldCglMjJtLXJpYyUyRmh1Z2dpbmdmYWNlX2RvYyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">import</span> datasets

knowledge_base = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),E=new w({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain_community.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain_community.vectorstores.utils <span class="hljs-keyword">import</span> DistanceStrategy

<span class="hljs-meta">&gt;&gt;&gt; </span>source_docs = [
<span class="hljs-meta">... </span>    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]})
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>text_splitter = RecursiveCharacterTextSplitter.from_huggingface_tokenizer(
<span class="hljs-meta">... </span>    AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>),
<span class="hljs-meta">... </span>    chunk_size=<span class="hljs-number">200</span>,
<span class="hljs-meta">... </span>    chunk_overlap=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    add_start_index=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    strip_whitespace=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    separators=[<span class="hljs-string">&quot;\\n\\n&quot;</span>, <span class="hljs-string">&quot;\\n&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-string">&quot; &quot;</span>, <span class="hljs-string">&quot;&quot;</span>],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Split docs and keep only unique ones</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Splitting documents...&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>docs_processed = []
<span class="hljs-meta">&gt;&gt;&gt; </span>unique_texts = {}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> tqdm(source_docs):
<span class="hljs-meta">... </span>    new_docs = text_splitter.split_documents([doc])
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> new_doc <span class="hljs-keyword">in</span> new_docs:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> new_doc.page_content <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> unique_texts:
<span class="hljs-meta">... </span>            unique_texts[new_doc.page_content] = <span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>            docs_processed.append(new_doc)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Embedding documents... This should take a few minutes (5 minutes on MacBook with M1 Pro)&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>embedding_model = HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>vectordb = FAISS.from_documents(
<span class="hljs-meta">... </span>    documents=docs_processed,
<span class="hljs-meta">... </span>    embedding=embedding_model,
<span class="hljs-meta">... </span>    distance_strategy=DistanceStrategy.COSINE,
<span class="hljs-meta">... </span>)`,wrap:!1}}),H=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> langchain_core.vectorstores <span class="hljs-keyword">import</span> VectorStore


<span class="hljs-keyword">class</span> <span class="hljs-title class_">RetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;retriever&quot;</span>
    description = <span class="hljs-string">&quot;Using semantic similarity, retrieves some documents from the knowledge base that have the closest embeddings to the input query.&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be semantically close to your target documents. Use the affirmative form rather than a question.&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, vectordb: VectorStore, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        self.vectordb = vectordb

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>

        docs = self.vectordb.similarity_search(
            query,
            k=<span class="hljs-number">7</span>,
        )

        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\nRetrieved documents:\\n&quot;</span> + <span class="hljs-string">&quot;&quot;</span>.join(
            [
                <span class="hljs-string">f&quot;===== Document <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span> =====\\n&quot;</span> + doc.page_content
                <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(docs)
            ]
        )`,wrap:!1}}),D=new w({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMFRvb2xDYWxsaW5nQWdlbnQlMEElMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjEtNzBCLUluc3RydWN0JTIyKSUwQSUwQXJldHJpZXZlcl90b29sJTIwJTNEJTIwUmV0cmlldmVyVG9vbCh2ZWN0b3JkYiklMEFhZ2VudCUyMCUzRCUyMFRvb2xDYWxsaW5nQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJyZXRyaWV2ZXJfdG9vbCU1RCUyQyUyMG1vZGVsJTNEbW9kZWwlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, ToolCallingAgent

model = InferenceClientModel(<span class="hljs-string">&quot;meta-llama/Llama-3.1-70B-Instruct&quot;</span>)

retriever_tool = RetrieverTool(vectordb)
agent = ToolCallingAgent(
    tools=[retriever_tool], model=model
)`,wrap:!1}}),O=new w({props:{code:"YWdlbnRfb3V0cHV0JTIwJTNEJTIwYWdlbnQucnVuKCUyMkhvdyUyMGNhbiUyMEklMjBwdXNoJTIwYSUyMG1vZGVsJTIwdG8lMjB0aGUlMjBIdWIlM0YlMjIpJTBBJTBBcHJpbnQoJTIyRmluYWwlMjBvdXRwdXQlM0ElMjIpJTBBcHJpbnQoYWdlbnRfb3V0cHV0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>agent_output = agent.run(<span class="hljs-string">&quot;How can I push a model to the Hub?&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final output:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),sl=new ye({props:{title:"Agentic RAG vs. standard RAG",local:"agentic-rag-vs-standard-rag",headingTag:"h2"}}),al=new w({props:{code:"ZXZhbF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldHMubG9hZF9kYXRhc2V0KCUyMm0tcmljJTJGaHVnZ2luZ2ZhY2VfZG9jX3FhX2V2YWwlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKQ==",highlighted:'eval_dataset = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc_qa_eval&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)',wrap:!1}}),Ml=new w({props:{code:"aW1wb3J0JTIwbG9nZ2luZyUwQSUwQWFnZW50LmxvZ2dlci5zZXRMZXZlbChsb2dnaW5nLldBUk5JTkcpJTIwJTIzJTIwTGV0J3MlMjByZWR1Y2UlMjB0aGUlMjBhZ2VudCdzJTIwdmVyYm9zaXR5JTIwbGV2ZWwlMEElMEFldmFsX2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0cy5sb2FkX2RhdGFzZXQoJTIybS1yaWMlMkZodWdnaW5nZmFjZV9kb2NfcWFfZXZhbCUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">import</span> logging

agent.logger.setLevel(logging.WARNING) <span class="hljs-comment"># Let&#x27;s reduce the agent&#x27;s verbosity level</span>

eval_dataset = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc_qa_eval&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),Jl=new w({props:{code:"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",highlighted:`outputs_agentic_rag = []

<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> tqdm(eval_dataset):
    question = example[<span class="hljs-string">&quot;question&quot;</span>]

    enhanced_question = <span class="hljs-string">f&quot;&quot;&quot;Using the information contained in your knowledge base, which you can access with the &#x27;retriever&#x27; tool,
give a comprehensive answer to the question below.
Respond only to the question asked, response should be concise and relevant to the question.
If you cannot find information, do not give up and try calling your retriever again with different arguments!
Make sure to have covered the question completely by calling the retriever tool several times with semantically different queries.
Your queries should not be questions but affirmative form sentences: e.g. rather than &quot;How do I load a model from the Hub in bf16?&quot;, query should be &quot;load a model from the Hub bf16 weights&quot;.

Question:
<span class="hljs-subst">{question}</span>&quot;&quot;&quot;</span>
    answer = agent.run(enhanced_question)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=======================================================&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Question: <span class="hljs-subst">{question}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Answer: <span class="hljs-subst">{answer}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;True answer: <span class="hljs-subst">{example[<span class="hljs-string">&quot;answer&quot;</span>]}</span>&#x27;</span>)

    results_agentic = {
        <span class="hljs-string">&quot;question&quot;</span>: question,
        <span class="hljs-string">&quot;true_answer&quot;</span>: example[<span class="hljs-string">&quot;answer&quot;</span>],
        <span class="hljs-string">&quot;source_doc&quot;</span>: example[<span class="hljs-string">&quot;source_doc&quot;</span>],
        <span class="hljs-string">&quot;generated_answer&quot;</span>: answer,
    }
    outputs_agentic_rag.append(results_agentic)`,wrap:!1}}),ol=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

reader_llm = InferenceClient(<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>)

outputs_standard_rag = []

<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> tqdm(eval_dataset):
    question = example[<span class="hljs-string">&quot;question&quot;</span>]
    context = retriever_tool(question)

    prompt = <span class="hljs-string">f&quot;&quot;&quot;Given the question and supporting documents below, give a comprehensive answer to the question.
Respond only to the question asked, response should be concise and relevant to the question.
Provide the number of the source document when relevant.
If you cannot find information, do not give up and try calling your retriever again with different arguments!

Question:
<span class="hljs-subst">{question}</span>

<span class="hljs-subst">{context}</span>
&quot;&quot;&quot;</span>
    messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt}]
    answer = reader_llm.chat_completion(messages).choices[<span class="hljs-number">0</span>].message.content

    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=======================================================&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Question: <span class="hljs-subst">{question}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Answer: <span class="hljs-subst">{answer}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;True answer: <span class="hljs-subst">{example[<span class="hljs-string">&quot;answer&quot;</span>]}</span>&#x27;</span>)

    results_agentic = {
        <span class="hljs-string">&quot;question&quot;</span>: question,
        <span class="hljs-string">&quot;true_answer&quot;</span>: example[<span class="hljs-string">&quot;answer&quot;</span>],
        <span class="hljs-string">&quot;source_doc&quot;</span>: example[<span class="hljs-string">&quot;source_doc&quot;</span>],
        <span class="hljs-string">&quot;generated_answer&quot;</span>: answer,
    }
    outputs_standard_rag.append(results_agentic)`,wrap:!1}}),il=new w({props:{code:"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",highlighted:`EVALUATION_PROMPT = <span class="hljs-string">&quot;&quot;&quot;You are a fair evaluator language model.

You will be given an instruction, a response to evaluate, a reference answer that gets a score of 3, and a score rubric representing a evaluation criteria are given.
1. Write a detailed feedback that assess the quality of the response strictly based on the given score rubric, not evaluating in general.
2. After writing a feedback, write a score that is an integer between 1 and 3. You should refer to the score rubric.
3. The output format should look as follows: \\&quot;Feedback: {{write a feedback for criteria}} [RESULT] {{an integer number between 1 and 3}}\\&quot;
4. Please do not generate any other opening, closing, and explanations. Be sure to include [RESULT] in your output.
5. Do not score conciseness: a correct answer that covers the question should receive max score, even if it contains additional useless information.

The instruction to evaluate:
{instruction}

Response to evaluate:
{response}

Reference Answer (Score 3):
{reference_answer}

Score Rubrics:
[Is the response complete, accurate, and factual based on the reference answer?]
Score 1: The response is completely incomplete, inaccurate, and/or not factual.
Score 2: The response is somewhat complete, accurate, and/or factual.
Score 3: The response is completely complete, accurate, and/or factual.

Feedback:&quot;&quot;&quot;</span>`,wrap:!1}}),yl=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWV2YWx1YXRpb25fY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjEtNzBCLUluc3RydWN0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

evaluation_client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Llama-3.1-70B-Instruct&quot;</span>)`,wrap:!1}}),cl=new w({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQXJlc3VsdHMlMjAlM0QlMjAlN0IlN0QlMEFmb3IlMjBzeXN0ZW1fdHlwZSUyQyUyMG91dHB1dHMlMjBpbiUyMCU1QiUwQSUyMCUyMCUyMCUyMCglMjJhZ2VudGljJTIyJTJDJTIwb3V0cHV0c19hZ2VudGljX3JhZyklMkMlMEElMjAlMjAlMjAlMjAoJTIyc3RhbmRhcmQlMjIlMkMlMjBvdXRwdXRzX3N0YW5kYXJkX3JhZyklMkMlMEElNUQlM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBleHBlcmltZW50JTIwaW4lMjB0cWRtKG91dHB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXZhbF9wcm9tcHQlMjAlM0QlMjBFVkFMVUFUSU9OX1BST01QVC5mb3JtYXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5zdHJ1Y3Rpb24lM0RleHBlcmltZW50JTVCJTIycXVlc3Rpb24lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXNwb25zZSUzRGV4cGVyaW1lbnQlNUIlMjJnZW5lcmF0ZWRfYW5zd2VyJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVmZXJlbmNlX2Fuc3dlciUzRGV4cGVyaW1lbnQlNUIlMjJ0cnVlX2Fuc3dlciUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGZhaXIlMjBldmFsdWF0b3IlMjBsYW5ndWFnZSUyMG1vZGVsLiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMGV2YWxfcHJvbXB0JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXZhbF9yZXN1bHQlMjAlM0QlMjBldmFsdWF0aW9uX2NsaWVudC50ZXh0X2dlbmVyYXRpb24oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXZhbF9wcm9tcHQlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwMDAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZmVlZGJhY2slMkMlMjBzY29yZSUyMCUzRCUyMCU1Qml0ZW0uc3RyaXAoKSUyMGZvciUyMGl0ZW0lMjBpbiUyMGV2YWxfcmVzdWx0LnNwbGl0KCUyMiU1QlJFU1VMVCU1RCUyMiklNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBleHBlcmltZW50JTVCJTIyZXZhbF9zY29yZV9MTE1fanVkZ2UlMjIlNUQlMjAlM0QlMjBzY29yZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4cGVyaW1lbnQlNUIlMjJldmFsX2ZlZWRiYWNrX0xMTV9qdWRnZSUyMiU1RCUyMCUzRCUyMGZlZWRiYWNrJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXhjZXB0JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlBhcnNpbmclMjBmYWlsZWQlMjAtJTIwb3V0cHV0JTIwd2FzJTNBJTIwJTdCZXZhbF9yZXN1bHQlN0QlMjIpJTBBJTBBJTIwJTIwJTIwJTIwcmVzdWx0cyU1QnN5c3RlbV90eXBlJTVEJTIwJTNEJTIwcGQuRGF0YUZyYW1lLmZyb21fZGljdChvdXRwdXRzKSUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlNUJzeXN0ZW1fdHlwZSU1RCUyMCUzRCUyMHJlc3VsdHMlNUJzeXN0ZW1fdHlwZSU1RC5sb2MlNUJ+cmVzdWx0cyU1QnN5c3RlbV90eXBlJTVEJTVCJTIyZ2VuZXJhdGVkX2Fuc3dlciUyMiU1RC5zdHIuY29udGFpbnMoJTIyRXJyb3IlMjIpJTVE",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

results = {}
<span class="hljs-keyword">for</span> system_type, outputs <span class="hljs-keyword">in</span> [
    (<span class="hljs-string">&quot;agentic&quot;</span>, outputs_agentic_rag),
    (<span class="hljs-string">&quot;standard&quot;</span>, outputs_standard_rag),
]:
    <span class="hljs-keyword">for</span> experiment <span class="hljs-keyword">in</span> tqdm(outputs):
        eval_prompt = EVALUATION_PROMPT.<span class="hljs-built_in">format</span>(
            instruction=experiment[<span class="hljs-string">&quot;question&quot;</span>],
            response=experiment[<span class="hljs-string">&quot;generated_answer&quot;</span>],
            reference_answer=experiment[<span class="hljs-string">&quot;true_answer&quot;</span>],
        )
        messages = [
            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a fair evaluator language model.&quot;</span>},
            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: eval_prompt},
        ]

        eval_result = evaluation_client.text_generation(
            eval_prompt, max_new_tokens=<span class="hljs-number">1000</span>
        )
        <span class="hljs-keyword">try</span>:
            feedback, score = [item.strip() <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> eval_result.split(<span class="hljs-string">&quot;[RESULT]&quot;</span>)]
            experiment[<span class="hljs-string">&quot;eval_score_LLM_judge&quot;</span>] = score
            experiment[<span class="hljs-string">&quot;eval_feedback_LLM_judge&quot;</span>] = feedback
        <span class="hljs-keyword">except</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Parsing failed - output was: <span class="hljs-subst">{eval_result}</span>&quot;</span>)

    results[system_type] = pd.DataFrame.from_dict(outputs)
    results[system_type] = results[system_type].loc[~results[system_type][<span class="hljs-string">&quot;generated_answer&quot;</span>].<span class="hljs-built_in">str</span>.contains(<span class="hljs-string">&quot;Error&quot;</span>)]`,wrap:!1}}),Tl=new w({props:{code:"REVGQVVMVF9TQ09SRSUyMCUzRCUyMDIlMjAlMjMlMjBHaXZlJTIwYXZlcmFnZSUyMHNjb3JlJTIwd2hlbmV2ZXIlMjBzY29yaW5nJTIwZmFpbHMlMEFkZWYlMjBmaWxsX3Njb3JlKHgpJTNBJTBBJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW50KHgpJTBBJTIwJTIwJTIwJTIwZXhjZXB0JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwREVGQVVMVF9TQ09SRSUwQSUwQWZvciUyMHN5c3RlbV90eXBlJTJDJTIwb3V0cHV0cyUyMGluJTIwJTVCJTBBJTIwJTIwJTIwJTIwKCUyMmFnZW50aWMlMjIlMkMlMjBvdXRwdXRzX2FnZW50aWNfcmFnKSUyQyUwQSUyMCUyMCUyMCUyMCglMjJzdGFuZGFyZCUyMiUyQyUyMG91dHB1dHNfc3RhbmRhcmRfcmFnKSUyQyUwQSU1RCUzQSUwQSUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlNUJzeXN0ZW1fdHlwZSU1RCU1QiUyMmV2YWxfc2NvcmVfTExNX2p1ZGdlX2ludCUyMiU1RCUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXN1bHRzJTVCc3lzdGVtX3R5cGUlNUQlNUIlMjJldmFsX3Njb3JlX0xMTV9qdWRnZSUyMiU1RC5maWxsbmEoREVGQVVMVF9TQ09SRSkuYXBwbHkoZmlsbF9zY29yZSklMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwcmVzdWx0cyU1QnN5c3RlbV90eXBlJTVEJTVCJTIyZXZhbF9zY29yZV9MTE1fanVkZ2VfaW50JTIyJTVEJTIwJTNEJTIwKHJlc3VsdHMlNUJzeXN0ZW1fdHlwZSU1RCU1QiUyMmV2YWxfc2NvcmVfTExNX2p1ZGdlX2ludCUyMiU1RCUyMC0lMjAxKSUyMCUyRiUyMDIlMEElMEElMjAlMjAlMjAlMjBwcmludCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIyQXZlcmFnZSUyMHNjb3JlJTIwZm9yJTIwJTdCc3lzdGVtX3R5cGUlN0QlMjBSQUclM0ElMjAlN0JyZXN1bHRzJTVCc3lzdGVtX3R5cGUlNUQlNUInZXZhbF9zY29yZV9MTE1fanVkZ2VfaW50JyU1RC5tZWFuKCkqMTAwJTNBLjFmJTdEJTI1JTIyJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>DEFAULT_SCORE = <span class="hljs-number">2</span> <span class="hljs-comment"># Give average score whenever scoring fails</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">fill_score</span>(<span class="hljs-params">x</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> <span class="hljs-built_in">int</span>(x)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">except</span>:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> DEFAULT_SCORE

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> system_type, outputs <span class="hljs-keyword">in</span> [
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;agentic&quot;</span>, outputs_agentic_rag),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;standard&quot;</span>, outputs_standard_rag),
<span class="hljs-meta">... </span>]:

<span class="hljs-meta">... </span>    results[system_type][<span class="hljs-string">&quot;eval_score_LLM_judge_int&quot;</span>] = (
<span class="hljs-meta">... </span>        results[system_type][<span class="hljs-string">&quot;eval_score_LLM_judge&quot;</span>].fillna(DEFAULT_SCORE).apply(fill_score)
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>    results[system_type][<span class="hljs-string">&quot;eval_score_LLM_judge_int&quot;</span>] = (results[system_type][<span class="hljs-string">&quot;eval_score_LLM_judge_int&quot;</span>] - <span class="hljs-number">1</span>) / <span class="hljs-number">2</span>

<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;Average score for <span class="hljs-subst">{system_type}</span> RAG: <span class="hljs-subst">{results[system_type][<span class="hljs-string">&#x27;eval_score_LLM_judge_int&#x27;</span>].mean()*<span class="hljs-number">100</span>:<span class="hljs-number">.1</span>f}</span>%&quot;</span>
<span class="hljs-meta">... </span>    )`,wrap:!1}}),dl=new Ie({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/agent_rag.md"}}),{c(){u=M("meta"),Il=a(),jl=M("p"),hl=a(),p(U.$$.fragment),bl=a(),p(d.$$.fragment),gl=a(),p(j.$$.fragment),Bl=a(),m=M("p"),m.innerHTML=Cs,Zl=a(),I=M("blockquote"),I.innerHTML=fs,Cl=a(),h=M("blockquote"),h.innerHTML=Gs,fl=a(),b=M("p"),b.textContent=Ns,Gl=a(),g=M("ul"),g.innerHTML=Vs,Nl=a(),B=M("p"),B.innerHTML=Ws,Vl=a(),Z=M("p"),Z.textContent=vs,Wl=a(),C=M("p"),C.textContent=Rs,vl=a(),f=M("ul"),f.innerHTML=Qs,Rl=a(),G=M("p"),G.textContent=Xs,Ql=a(),N=M("p"),N.textContent=ks,Xl=a(),p(V.$$.fragment),kl=a(),W=M("p"),W.textContent=Es,El=a(),p(v.$$.fragment),ql=a(),R=M("p"),R.innerHTML=qs,Yl=a(),p(Q.$$.fragment),_l=a(),X=M("p"),X.textContent=Ys,Al=a(),k=M("p"),k.innerHTML=_s,Hl=a(),p(E.$$.fragment),Sl=a(),q=M("pre"),q.textContent=As,xl=a(),Y=M("p"),Y.textContent=Hs,zl=a(),_=M("p"),_.innerHTML=Ss,Fl=a(),A=M("p"),A.innerHTML=xs,$l=a(),p(H.$$.fragment),Ll=a(),S=M("p"),S.textContent=zs,Dl=a(),x=M("p"),x.textContent=Fs,Pl=a(),z=M("ul"),z.innerHTML=$s,Kl=a(),F=M("p"),F.innerHTML=Ls,Ol=a(),$=M("p"),$.innerHTML=Ds,ls=a(),L=M("p"),L.innerHTML=Ps,ss=a(),p(D.$$.fragment),es=a(),P=M("p"),P.innerHTML=Ks,ts=a(),K=M("p"),K.innerHTML=Os,as=a(),p(O.$$.fragment),ns=a(),ll=M("pre"),ll.textContent=le,Ms=a(),p(sl.$$.fragment),Js=a(),el=M("p"),el.textContent=se,os=a(),tl=M("p"),tl.innerHTML=ee,ps=a(),p(al.$$.fragment),is=a(),nl=M("p"),nl.textContent=te,ys=a(),p(Ml.$$.fragment),cs=a(),p(Jl.$$.fragment),Ts=a(),p(ol.$$.fragment),rs=a(),pl=M("p"),pl.innerHTML=ae,ws=a(),p(il.$$.fragment),us=a(),p(yl.$$.fragment),Us=a(),p(cl.$$.fragment),ds=a(),p(Tl.$$.fragment),js=a(),rl=M("pre"),rl.textContent=ne,ms=a(),wl=M("p"),wl.innerHTML=Me,Is=a(),ul=M("p"),ul.textContent=Je,hs=a(),Ul=M("p"),Ul.textContent=oe,bs=a(),p(dl.$$.fragment),gs=a(),ml=M("p"),this.h()},l(l){const s=Ue("svelte-u9bgzb",document.head);u=J(s,"META",{name:!0,content:!0}),s.forEach(e),Il=n(l),jl=J(l,"P",{}),pe(jl).forEach(e),hl=n(l),i(U.$$.fragment,l),bl=n(l),i(d.$$.fragment,l),gl=n(l),i(j.$$.fragment,l),Bl=n(l),m=J(l,"P",{"data-svelte-h":!0}),o(m)!=="svelte-1xlqnsv"&&(m.innerHTML=Cs),Zl=n(l),I=J(l,"BLOCKQUOTE",{"data-svelte-h":!0}),o(I)!=="svelte-ut7thx"&&(I.innerHTML=fs),Cl=n(l),h=J(l,"BLOCKQUOTE",{"data-svelte-h":!0}),o(h)!=="svelte-1uj6u2q"&&(h.innerHTML=Gs),fl=n(l),b=J(l,"P",{"data-svelte-h":!0}),o(b)!=="svelte-le6dse"&&(b.textContent=Ns),Gl=n(l),g=J(l,"UL",{"data-svelte-h":!0}),o(g)!=="svelte-1tet28w"&&(g.innerHTML=Vs),Nl=n(l),B=J(l,"P",{"data-svelte-h":!0}),o(B)!=="svelte-zgftoz"&&(B.innerHTML=Ws),Vl=n(l),Z=J(l,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1oxrjf8"&&(Z.textContent=vs),Wl=n(l),C=J(l,"P",{"data-svelte-h":!0}),o(C)!=="svelte-i3m4dm"&&(C.textContent=Rs),vl=n(l),f=J(l,"UL",{"data-svelte-h":!0}),o(f)!=="svelte-16julm3"&&(f.innerHTML=Qs),Rl=n(l),G=J(l,"P",{"data-svelte-h":!0}),o(G)!=="svelte-18mh92s"&&(G.textContent=Xs),Ql=n(l),N=J(l,"P",{"data-svelte-h":!0}),o(N)!=="svelte-16cuoal"&&(N.textContent=ks),Xl=n(l),i(V.$$.fragment,l),kl=n(l),W=J(l,"P",{"data-svelte-h":!0}),o(W)!=="svelte-64fox6"&&(W.textContent=Es),El=n(l),i(v.$$.fragment,l),ql=n(l),R=J(l,"P",{"data-svelte-h":!0}),o(R)!=="svelte-zy8yuo"&&(R.innerHTML=qs),Yl=n(l),i(Q.$$.fragment,l),_l=n(l),X=J(l,"P",{"data-svelte-h":!0}),o(X)!=="svelte-11htfoc"&&(X.textContent=Ys),Al=n(l),k=J(l,"P",{"data-svelte-h":!0}),o(k)!=="svelte-pr8fqf"&&(k.innerHTML=_s),Hl=n(l),i(E.$$.fragment,l),Sl=n(l),q=J(l,"PRE",{"data-svelte-h":!0}),o(q)!=="svelte-bkjqrc"&&(q.textContent=As),xl=n(l),Y=J(l,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1tpog71"&&(Y.textContent=Hs),zl=n(l),_=J(l,"P",{"data-svelte-h":!0}),o(_)!=="svelte-675szm"&&(_.innerHTML=Ss),Fl=n(l),A=J(l,"P",{"data-svelte-h":!0}),o(A)!=="svelte-yb70ev"&&(A.innerHTML=xs),$l=n(l),i(H.$$.fragment,l),Ll=n(l),S=J(l,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1ma3u1b"&&(S.textContent=zs),Dl=n(l),x=J(l,"P",{"data-svelte-h":!0}),o(x)!=="svelte-14g5yev"&&(x.textContent=Fs),Pl=n(l),z=J(l,"UL",{"data-svelte-h":!0}),o(z)!=="svelte-1plagnt"&&(z.innerHTML=$s),Kl=n(l),F=J(l,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1cigqe"&&(F.innerHTML=Ls),Ol=n(l),$=J(l,"P",{"data-svelte-h":!0}),o($)!=="svelte-1am6oti"&&($.innerHTML=Ds),ls=n(l),L=J(l,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1faawbb"&&(L.innerHTML=Ps),ss=n(l),i(D.$$.fragment,l),es=n(l),P=J(l,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1dmyh52"&&(P.innerHTML=Ks),ts=n(l),K=J(l,"P",{"data-svelte-h":!0}),o(K)!=="svelte-143bxk3"&&(K.innerHTML=Os),as=n(l),i(O.$$.fragment,l),ns=n(l),ll=J(l,"PRE",{"data-svelte-h":!0}),o(ll)!=="svelte-wsg97n"&&(ll.textContent=le),Ms=n(l),i(sl.$$.fragment,l),Js=n(l),el=J(l,"P",{"data-svelte-h":!0}),o(el)!=="svelte-to6drr"&&(el.textContent=se),os=n(l),tl=J(l,"P",{"data-svelte-h":!0}),o(tl)!=="svelte-yr66ap"&&(tl.innerHTML=ee),ps=n(l),i(al.$$.fragment,l),is=n(l),nl=J(l,"P",{"data-svelte-h":!0}),o(nl)!=="svelte-708yv1"&&(nl.textContent=te),ys=n(l),i(Ml.$$.fragment,l),cs=n(l),i(Jl.$$.fragment,l),Ts=n(l),i(ol.$$.fragment,l),rs=n(l),pl=J(l,"P",{"data-svelte-h":!0}),o(pl)!=="svelte-lt6qr6"&&(pl.innerHTML=ae),ws=n(l),i(il.$$.fragment,l),us=n(l),i(yl.$$.fragment,l),Us=n(l),i(cl.$$.fragment,l),ds=n(l),i(Tl.$$.fragment,l),js=n(l),rl=J(l,"PRE",{"data-svelte-h":!0}),o(rl)!=="svelte-1it3mki"&&(rl.textContent=ne),ms=n(l),wl=J(l,"P",{"data-svelte-h":!0}),o(wl)!=="svelte-en509u"&&(wl.innerHTML=Me),Is=n(l),ul=J(l,"P",{"data-svelte-h":!0}),o(ul)!=="svelte-1fi7cw9"&&(ul.textContent=Je),hs=n(l),Ul=J(l,"P",{"data-svelte-h":!0}),o(Ul)!=="svelte-1y4e8t1"&&(Ul.textContent=oe),bs=n(l),i(dl.$$.fragment,l),gs=n(l),ml=J(l,"P",{}),pe(ml).forEach(e),this.h()},h(){ie(u,"name","hf:doc:metadata"),ie(u,"content",be)},m(l,s){de(document.head,u),t(l,Il,s),t(l,jl,s),t(l,hl,s),y(U,l,s),t(l,bl,s),y(d,l,s),t(l,gl,s),y(j,l,s),t(l,Bl,s),t(l,m,s),t(l,Zl,s),t(l,I,s),t(l,Cl,s),t(l,h,s),t(l,fl,s),t(l,b,s),t(l,Gl,s),t(l,g,s),t(l,Nl,s),t(l,B,s),t(l,Vl,s),t(l,Z,s),t(l,Wl,s),t(l,C,s),t(l,vl,s),t(l,f,s),t(l,Rl,s),t(l,G,s),t(l,Ql,s),t(l,N,s),t(l,Xl,s),y(V,l,s),t(l,kl,s),t(l,W,s),t(l,El,s),y(v,l,s),t(l,ql,s),t(l,R,s),t(l,Yl,s),y(Q,l,s),t(l,_l,s),t(l,X,s),t(l,Al,s),t(l,k,s),t(l,Hl,s),y(E,l,s),t(l,Sl,s),t(l,q,s),t(l,xl,s),t(l,Y,s),t(l,zl,s),t(l,_,s),t(l,Fl,s),t(l,A,s),t(l,$l,s),y(H,l,s),t(l,Ll,s),t(l,S,s),t(l,Dl,s),t(l,x,s),t(l,Pl,s),t(l,z,s),t(l,Kl,s),t(l,F,s),t(l,Ol,s),t(l,$,s),t(l,ls,s),t(l,L,s),t(l,ss,s),y(D,l,s),t(l,es,s),t(l,P,s),t(l,ts,s),t(l,K,s),t(l,as,s),y(O,l,s),t(l,ns,s),t(l,ll,s),t(l,Ms,s),y(sl,l,s),t(l,Js,s),t(l,el,s),t(l,os,s),t(l,tl,s),t(l,ps,s),y(al,l,s),t(l,is,s),t(l,nl,s),t(l,ys,s),y(Ml,l,s),t(l,cs,s),y(Jl,l,s),t(l,Ts,s),y(ol,l,s),t(l,rs,s),t(l,pl,s),t(l,ws,s),y(il,l,s),t(l,us,s),y(yl,l,s),t(l,Us,s),y(cl,l,s),t(l,ds,s),y(Tl,l,s),t(l,js,s),t(l,rl,s),t(l,ms,s),t(l,wl,s),t(l,Is,s),t(l,ul,s),t(l,hs,s),t(l,Ul,s),t(l,bs,s),y(dl,l,s),t(l,gs,s),t(l,ml,s),Bs=!0},p:Te,i(l){Bs||(c(U.$$.fragment,l),c(d.$$.fragment,l),c(j.$$.fragment,l),c(V.$$.fragment,l),c(v.$$.fragment,l),c(Q.$$.fragment,l),c(E.$$.fragment,l),c(H.$$.fragment,l),c(D.$$.fragment,l),c(O.$$.fragment,l),c(sl.$$.fragment,l),c(al.$$.fragment,l),c(Ml.$$.fragment,l),c(Jl.$$.fragment,l),c(ol.$$.fragment,l),c(il.$$.fragment,l),c(yl.$$.fragment,l),c(cl.$$.fragment,l),c(Tl.$$.fragment,l),c(dl.$$.fragment,l),Bs=!0)},o(l){T(U.$$.fragment,l),T(d.$$.fragment,l),T(j.$$.fragment,l),T(V.$$.fragment,l),T(v.$$.fragment,l),T(Q.$$.fragment,l),T(E.$$.fragment,l),T(H.$$.fragment,l),T(D.$$.fragment,l),T(O.$$.fragment,l),T(sl.$$.fragment,l),T(al.$$.fragment,l),T(Ml.$$.fragment,l),T(Jl.$$.fragment,l),T(ol.$$.fragment,l),T(il.$$.fragment,l),T(yl.$$.fragment,l),T(cl.$$.fragment,l),T(Tl.$$.fragment,l),T(dl.$$.fragment,l),Bs=!1},d(l){l&&(e(Il),e(jl),e(hl),e(bl),e(gl),e(Bl),e(m),e(Zl),e(I),e(Cl),e(h),e(fl),e(b),e(Gl),e(g),e(Nl),e(B),e(Vl),e(Z),e(Wl),e(C),e(vl),e(f),e(Rl),e(G),e(Ql),e(N),e(Xl),e(kl),e(W),e(El),e(ql),e(R),e(Yl),e(_l),e(X),e(Al),e(k),e(Hl),e(Sl),e(q),e(xl),e(Y),e(zl),e(_),e(Fl),e(A),e($l),e(Ll),e(S),e(Dl),e(x),e(Pl),e(z),e(Kl),e(F),e(Ol),e($),e(ls),e(L),e(ss),e(es),e(P),e(ts),e(K),e(as),e(ns),e(ll),e(Ms),e(Js),e(el),e(os),e(tl),e(ps),e(is),e(nl),e(ys),e(cs),e(Ts),e(rs),e(pl),e(ws),e(us),e(Us),e(ds),e(js),e(rl),e(ms),e(wl),e(Is),e(ul),e(hs),e(Ul),e(bs),e(gs),e(ml)),e(u),r(U,l),r(d,l),r(j,l),r(V,l),r(v,l),r(Q,l),r(E,l),r(H,l),r(D,l),r(O,l),r(sl,l),r(al,l),r(Ml,l),r(Jl,l),r(ol,l),r(il,l),r(yl,l),r(cl,l),r(Tl,l),r(dl,l)}}}const be='{"title":"Agentic RAG: turbocharge your RAG with query reformulation and self-query! 🚀","local":"agentic-rag-turbocharge-your-rag-with-query-reformulation-and-self-query-","sections":[{"title":"Agentic RAG vs. standard RAG","local":"agentic-rag-vs-standard-rag","sections":[],"depth":2}],"depth":1}';function ge(Zs){return re(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ne extends we{constructor(u){super(),ue(this,u,ge,he,ce,{})}}export{Ne as component};
