import{s as Wi,a as Vi,n as Zi,o as zi}from"../chunks/scheduler.1f027d5a.js";import{S as Si,i as xi,e as f,s as i,c as n,h as Ni,a as m,d as a,b as l,f as Qi,g as o,j as u,k as Is,l as Xi,m as s,n as A,t as p,o as r,p as U}from"../chunks/index.5cb6ce42.js";import{C as Gi}from"../chunks/CopyLLMTxtMenu.f7108191.js";import{D as Di,C as g}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as y,E as Yi}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function Ei(qs){let h,vt,Mt,Ct,c,Kt,d,Tt,F,bt,R,Qs='<em>Authored by: <a href="https://github.com/ParagEkbote" rel="nofollow">Parag Ekbote</a></em>',Bt,j,Ht,w,Ws="Find the best hyperparameters to fine-tune a lightweight BERT model for text classification on a subset of the IMDB dataset.",kt,M,Pt,J,Vs="This recipe demonstrates how to systematically optimize hyperparameters for transformer-based text classification models using automated search techniques. You’ll learn to implement HPO using Optuna to find optimal learning rates and weight decay values for fine-tuning BERT on sentiment analysis tasks.",It,v,qt,C,Zs="<li><p>You need to fine-tune pre-trained language models for classification tasks.</p></li> <li><p>Your model performance is plateauing and requires parameter refinement.</p></li> <li><p>You want to implement systematic, reproducible hyperparameter optimization.</p></li>",Qt,K,Wt,T,zs='<li>For detailed guidance on hyperparameter search with Transformers, refer to the <a href="https://huggingface.co/docs/transformers/en/hpo_train" rel="nofollow">Hugging Face HPO documentation</a>.</li>',Vt,b,Zt,B,zt,H,Ss="Before you can train and evaluate a sentiment analysis model, you’ll need to prep the dataset. This section ensures that your data is structured and your model is primed for learning from scratch or fine-tuning in the case of BERT.",St,k,xt,P,xs="Begin by selecting a dataset focused on sentiment classification. IMDB is a well-known benchmark that features movie reviews labeled as either positive or negative.",Nt,I,Xt,q,Ns="Focus only on the essentials:",Gt,Q,Xs="<li><code>text</code> column serves as the input (review content)</li> <li><code>label</code> column serves as the target (0 for negative, 1 for positive sentiment)</li>",Dt,W,Yt,V,Gs="Choose a consistent sampling strategy by selecting:",Et,Z,Ds=`<li>2000 examples for training</li> <li>1000 examples for validation<br/>
Use a fixed random seed when shuffling to ensure reproducibility across sessions.</li>`,$t,z,Lt,S,Ys="Apply a tokenizer compatible with the model you’re planning to use. Tokenization converts raw text into numerical format so the model can ingest it effectively. Use batch processing to make this step efficient.",Ot,x,_t,N,Es="Choose “accuracy” as the primary evaluation metric—simple and effective for binary classification tasks like this. It will later help gauge how well your model is learning the difference between positive and negative sentiment.",ea,X,ta,G,$s="Select a pretrained BERT-based model tailored for sequence classification tasks. Set the number of output classes to 2 (positive and negative) to align with your sentiment labels. This model will serve as the learner throughout the training process.",aa,D,sa,Y,ia,E,Ls="To ensure your hyperparameter optimization experiments are trackable, reproducible, and easy to analyze over time, it’s essential to use a persistent storage backend. Optuna provides a robust solution for this through its <code>RDBStorage</code> mechanism, which allows saving trial data across multiple sessions using an SQLite database.",la,$,na,L,Os="Opt for an SQLite database as the storage medium. It’s lightweight, portable, and ideal for local experimentation, while still enabling structured access to all trial data.",oa,O,Aa,_,_s="RDBStorage (Relational Database Storage) is Optuna’s way of saving trial results in a consistent and queryable format. This bridges the gap between short-term experimentation and long-term analysis.",pa,ee,ra,te,ei="By setting up persistent storage, you ensure that every hyperparameter trial is recorded. You can pause and resume studies, add more trials later, or analyze outcomes long after training has ended.",Ua,ae,fa,se,ti="With trials stored centrally, you can revisit earlier results, regenerate visualizations, or compare different optimization runs. This makes your workflow transparent, collaborative, and scientifically rigorous.",ma,ie,ua,le,ai="Storing trials persistently lets you plug in visualization tools—like Optuna’s built-in plotting utilities or external dashboards—to inspect performance trends and refine your search space iteratively.",ya,ne,ha,oe,ga,Ae,si="Now that your hyperparameter search space is in place, the next step is to wire everything together for optimization and tracking. This setup ensures not only accuracy-driven tuning but also full visibility into the training process using Weight & Biases (W&B).",ca,pe,da,re,ii="Start by specifying how model performance will be measured. This metric function evaluates predictions after each validation step to calculate accuracy, F1-score, or loss. It becomes the feedback loop guiding each trial’s learning progress.",Fa,Ue,Ra,fe,li="This is the centerpiece of hyperparameter optimization. It wraps your training loop and returns a scalar score based on the chosen metric (like validation accuracy). Optuna will use this to compare trials and decide which settings yield the best outcomes.",ja,me,wa,ue,ni="Configure your environment to log experiment metrics and hyperparameter configurations to W&B. This platform offers dashboards, plots, and experiment comparisons to track progress and spot issues.",Ma,ye,Ja,he,oi="Log in to W&B using your personal API key. This step connects your training session to your online account so that all metrics and trial details are properly tracked and stored.",va,ge,Ca,ce,Ai="Prepare a configuration setup for your training manager (such as the Hugging Face <code>Trainer</code>). Include settings for:",Ka,de,pi="<li><p>Evaluation strategy (e.g. after every epoch)</p></li> <li><p>Checkpoint frequency and save conditions</p></li> <li><p>Logging intervals</p></li> <li><p>Hyperparameter search method and objectives</p> <p>This ensures that training is robust, reproducible, and easy to resume or analyze.</p></li>",Ta,Fe,ba,Re,Ba,je,ri="Before diving into model training, it’s essential to thoughtfully define the ingredients and the exploration strategy. This step sets the stage for hyperparameter optimization using Optuna, where you’ll systematically explore combinations of training parameters like learning rate, weight decay, and batch size.",Ha,we,ka,Me,Ui="Begin by outlining the hyperparameters you want to optimize. Choose reasonable lower and upper bounds for each:",Pa,Je,fi="<li><em>Learning rate</em>—controls the step size during optimization.</li> <li><em>Weight decay</em>—adds regularization to reduce overfitting.</li> <li><em>Batch size</em>—affects memory use and convergence stability.</li>",Ia,ve,qa,Ce,mi="Decide whether your goal is to minimize (e.g. loss) or maximize (e.g. accuracy, F1 score) the evaluation metric. This guides the search engine in the right direction.",Qa,Ke,Wa,Te,ui="Optuna will handle the search process—selecting, evaluating, and iterating through hyperparameter combinations intelligently.",Va,be,Za,Be,yi="Define how many individual runs (“trials”) you want Optuna to attempt. More trials can explore the space better but take more time.",za,He,Sa,ke,hi="This function calculates the metric to be optimized during each trial. It encapsulates how the model is trained and how performance is evaluated after each configuration is tested.",xa,Pe,Na,Ie,gi="Assign a name to your study so it can be resumed or referenced later. This is especially useful when running experiments over multiple sessions or machines.",Xa,qe,Ga,Qe,ci="Choose the storage backend that we previously setup to let you continue the study later, analyze results, or visualize metrics even after a system reboot.",Da,We,Ya,Ve,di=`BestRun(run_id='0', objective=0.764, hyperparameters=&#123;'learning_rate': 7.23655165533393e-05, 'per_device_train_batch_size': 16, 'weight_decay': 0.013798094328723032}, run_summary=None)
`,Ea,Ze,$a,ze,Fi="Once your Optuna study completes its trials, it’s time to peel back the layers and interpret what happened. Visualization brings clarity to how hyperparameters shaped the outcome and uncovers patterns that might otherwise stay buried in raw data.",La,Se,Oa,xe,Ri="Use the optimization history to see how objective scores evolved over trials. This helps you understand whether performance steadily improved, plateaued, or oscillated. It’s your window into the pace and trajectory of the search process.",_a,Ne,es,Xe,ji="If your model reports evaluation metrics during training (like per epoch), intermediate value plots let you monitor how each trial performed in real time. This is especially valuable for early-stopping decisions and assessing learning stability.",ts,Ge,as,De,wi="Parameter importance plots uncover which hyperparameters actually mattered—did tweaking the learning rate move the needle, or was batch size the star? Understanding this lets you simplify or refine your future search space.",ss,Ye,is,wt,Mi,ls,Ee,ns,$e,Ji="Once you’ve completed hyperparameter optimization with Optuna, it’s time to capitalize on your best findings and carry out the final round of training.",os,Le,As,Oe,vi="Access the best set of hyperparameters identified during the tuning process.",ps,_e,rs,et,Ci="Plug those hyperparameter values into your training setup. This might include adjustments to learning rate, batch size, number of epochs, dropout rate, and other model-specific knobs that influence training behavior.",Us,tt,fs,at,Ki="Apply the optimized values to initialize and configure your model. This ensures your final training run is guided by the most effective settings discovered through trial and error.",ms,st,us,it,Ti="Set up your optimizer, loss function, and data loaders using the best parameters. Everything from how fast your model learns to how much data it sees at once should reflect your refined configuration.",ys,lt,hs,nt,bi="Begin training your model using the entire training dataset (or at least the train/validation split you used during HPO). This pass should reflect your best shot at learning the patterns in the data without exploratory variation.",gs,ot,cs,At,ds,pt,Fs,rt,Bi="You’ve successfully trained a powerful and optimized model, it’s time to serve it up to the world. Sharing your model on the Hugging Face Hub not only makes it reusable and accessible for inference, but also contributes to the open-source community.",Rs,Ut,js,ft,Hi="After rigorous tuning and final training, your model now performs more efficiently and consistently. These improvements make it ideal for real-world tasks such as sentiment analysis, like classifying movie reviews to fine-tune content recommendations.",ws,mt,Ms,ut,ki="Before sharing, save the trained model—including the weights, configuration, tokenizer (if applicable), and training artifacts—on your local system. This step ensures that your model setup is reproducible and ready to be uploaded.",Js,yt,vs,ht,Pi="To upload your model, you’ll need to log in to the Hugging Face Hub. Whether through a terminal or notebook interface, authentication links your environment to your personal or organizational space on the platform, enabling push access.",Cs,gt,Ks,ct,Ii="Push your saved model to the Hugging Face Hub. This makes the model publicly accessible—or private and enables others to load, use, and fine-tune it. You’ll also create a model card to explain what the model does, its intended use cases, and performance benchmarks.",Ts,dt,bs,Ft,qi="<li>Centralized model storage encourages versioning, reproducibility, and transparency.</li> <li>The Hub simplifies integration for downstream tasks through <code>transformers</code>compatible APIs.</li> <li>Sharing models builds your profile and supports collaboration within the machine learning community.</li>",Bs,Rt,Hs,jt,ks,Jt,Ps;return c=new Di({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/optuna_hpo_with_transformers.ipynb"}]}}),d=new Gi({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),F=new y({props:{title:"Hyperparameter Optimization with Optuna and Transformers",local:"hyperparameter-optimization-with-optuna-and-transformers",headingTag:"h1"}}),j=new y({props:{title:"Problem:",local:"problem",headingTag:"h2"}}),M=new y({props:{title:"Overview:",local:"overview",headingTag:"h2"}}),v=new y({props:{title:"When to Use This Recipe:",local:"when-to-use-this-recipe",headingTag:"h2"}}),K=new y({props:{title:"Notes",local:"notes",headingTag:"h3"}}),b=new g({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGRhdGFzZXRzJTIwZXZhbHVhdGUlMjB0cmFuc2Zvcm1lcnMlMjBvcHR1bmElMjB3YW5kYiUyMHNjaWtpdC1sZWFybiUyMG5iZm9ybWF0JTIwbWF0cGxvdGxpYg==",highlighted:"!pip install -q datasets evaluate transformers optuna wandb scikit-learn nbformat matplotlib",wrap:!1}}),B=new y({props:{title:"Prepare Dataset and Set Model",local:"prepare-dataset-and-set-model",headingTag:"h2"}}),k=new y({props:{title:"1. Load the IMDB Dataset",local:"1-load-the-imdb-dataset",headingTag:"h3"}}),I=new y({props:{title:"2. Select Input and Output Columns",local:"2-select-input-and-output-columns",headingTag:"h3"}}),W=new y({props:{title:"3. Define the Train/Validation Split",local:"3-define-the-trainvalidation-split",headingTag:"h3"}}),z=new y({props:{title:"4. Tokenize the Dataset",local:"4-tokenize-the-dataset",headingTag:"h3"}}),x=new y({props:{title:"5. Load an Evaluation Metric",local:"5-load-an-evaluation-metric",headingTag:"h3"}}),X=new y({props:{title:"6. Initialize a Pretrained BERT Model",local:"6-initialize-a-pretrained-bert-model",headingTag:"h3"}}),D=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwZXZhbHVhdGUlMEElMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoNDIpJTBBJTBBJTBBdHJhaW5fZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJpbWRiJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMikuc2h1ZmZsZShzZWVkJTNENDIpLnNlbGVjdChyYW5nZSgyNTAwKSklMEF2YWxpZF9kYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRlc3QlMjIpLnNodWZmbGUoc2VlZCUzRDQyKS5zZWxlY3QocmFuZ2UoMTAwMCkpJTBBJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMnByYWpqd2FsMSUyRmJlcnQtdGlueSUyMiUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUpJTBBJTBBZGVmJTIwdG9rZW5pemUoYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGJhdGNoJTVCJTIydGV4dCUyMiU1RCUyQyUyMHBhZGRpbmclM0QlMjJtYXhfbGVuZ3RoJTIyJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUlMkMlMjBtYXhfbGVuZ3RoJTNENTEyKSUwQSUwQXRva2VuaXplZF90cmFpbiUyMCUzRCUyMHRyYWluX2RhdGFzZXQubWFwKHRva2VuaXplJTJDJTIwYmF0Y2hlZCUzRFRydWUpLnNlbGVjdF9jb2x1bW5zKCUwQSUyMCUyMCUyMCUyMCU1QiUyMmlucHV0X2lkcyUyMiUyQyUyMCUyMmF0dGVudGlvbl9tYXNrJTIyJTJDJTIwJTIybGFiZWwlMjIlNUQlMEEpJTBBdG9rZW5pemVkX3ZhbGlkJTIwJTNEJTIwdmFsaWRfZGF0YXNldC5tYXAodG9rZW5pemUlMkMlMjBiYXRjaGVkJTNEVHJ1ZSkuc2VsZWN0X2NvbHVtbnMoJTBBJTIwJTIwJTIwJTIwJTVCJTIyaW5wdXRfaWRzJTIyJTJDJTIwJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJsYWJlbCUyMiU1RCUwQSklMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmFjY3VyYWN5JTIyKSUwQSUwQSUwQWRlZiUyMG1vZGVsX2luaXQoKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> set_seed

set_seed(<span class="hljs-number">42</span>)


train_dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>).shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">2500</span>))
valid_dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;test&quot;</span>).shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))

model_name = <span class="hljs-string">&quot;prajjwal1/bert-tiny&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_name)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">batch</span>):
    <span class="hljs-keyword">return</span> tokenizer(batch[<span class="hljs-string">&quot;text&quot;</span>], padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>, max_length=<span class="hljs-number">512</span>)

tokenized_train = train_dataset.<span class="hljs-built_in">map</span>(tokenize, batched=<span class="hljs-literal">True</span>).select_columns(
    [<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>]
)
tokenized_valid = valid_dataset.<span class="hljs-built_in">map</span>(tokenize, batched=<span class="hljs-literal">True</span>).select_columns(
    [<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>]
)

metric = evaluate.load(<span class="hljs-string">&quot;accuracy&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">model_init</span>():
    <span class="hljs-keyword">return</span> AutoModelForSequenceClassification.from_pretrained(model_name, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),Y=new y({props:{title:"Define Storage with Optuna",local:"define-storage-with-optuna",headingTag:"h2"}}),$=new y({props:{title:"1. Choose a Persistent Storage Format",local:"1-choose-a-persistent-storage-format",headingTag:"h3"}}),O=new y({props:{title:"2. Enable Optuna’s RDBStorage",local:"2-enable-optunas-rdbstorage",headingTag:"h3"}}),ee=new y({props:{title:"3. Preserve Trial History Across Sessions",local:"3-preserve-trial-history-across-sessions",headingTag:"h3"}}),ae=new y({props:{title:"4. Facilitate Reproducible Analysis",local:"4-facilitate-reproducible-analysis",headingTag:"h3"}}),ie=new y({props:{title:"5. Support Visualization and Monitoring Tools",local:"5-support-visualization-and-monitoring-tools",headingTag:"h3"}}),ne=new g({props:{code:"aW1wb3J0JTIwb3B0dW5hJTBBZnJvbSUyMG9wdHVuYS5zdG9yYWdlcyUyMGltcG9ydCUyMFJEQlN0b3JhZ2UlMEElMEElMjMlMjBEZWZpbmUlMjBwZXJzaXN0ZW50JTIwc3RvcmFnZSUwQXN0b3JhZ2UlMjAlM0QlMjBSREJTdG9yYWdlKCUyMnNxbGl0ZSUzQSUyRiUyRiUyRm9wdHVuYV90cmlhbHMuZGIlMjIpJTBBJTBBc3R1ZHklMjAlM0QlMjBvcHR1bmEuY3JlYXRlX3N0dWR5KCUwQSUyMCUyMCUyMCUyMHN0dWR5X25hbWUlM0QlMjJ0cmFuc2Zvcm1lcnNfb3B0dW5hX3N0dWR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGlyZWN0aW9uJTNEJTIybWF4aW1pemUlMjIlMkMlMEElMjAlMjAlMjAlMjBzdG9yYWdlJTNEc3RvcmFnZSUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfaWZfZXhpc3RzJTNEVHJ1ZSUwQSk=",highlighted:`<span class="hljs-keyword">import</span> optuna
<span class="hljs-keyword">from</span> optuna.storages <span class="hljs-keyword">import</span> RDBStorage

<span class="hljs-comment"># Define persistent storage</span>
storage = RDBStorage(<span class="hljs-string">&quot;sqlite:///optuna_trials.db&quot;</span>)

study = optuna.create_study(
    study_name=<span class="hljs-string">&quot;transformers_optuna_study&quot;</span>,
    direction=<span class="hljs-string">&quot;maximize&quot;</span>,
    storage=storage,
    load_if_exists=<span class="hljs-literal">True</span>
)`,wrap:!1}}),oe=new y({props:{title:"Initialize Trainer and Set Up Observability",local:"initialize-trainer-and-set-up-observability",headingTag:"h2"}}),pe=new y({props:{title:"1. Define the Metric Function",local:"1-define-the-metric-function",headingTag:"h3"}}),Ue=new y({props:{title:"2. Construct the Objective Function",local:"2-construct-the-objective-function",headingTag:"h3"}}),me=new y({props:{title:"3. Set Up Weight & Biases for Observability",local:"3-set-up-weight--biases-for-observability",headingTag:"h3"}}),ye=new y({props:{title:"4. Authenticate for Logging Access",local:"4-authenticate-for-logging-access",headingTag:"h3"}}),ge=new y({props:{title:"5. Define Trainer Arguments",local:"5-define-trainer-arguments",headingTag:"h3"}}),Fe=new g({props:{code:"aW1wb3J0JTIwd2FuZGIlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVHJhaW5lciUyQyUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZCklM0ElMEElMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyMCUzRCUyMGV2YWxfcHJlZC5wcmVkaWN0aW9ucy5hcmdtYXgoYXhpcyUzRC0xKSUwQSUyMCUyMCUyMCUyMGxhYmVscyUyMCUzRCUyMGV2YWxfcHJlZC5sYWJlbF9pZHMlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBtZXRyaWMuY29tcHV0ZShwcmVkaWN0aW9ucyUzRHByZWRpY3Rpb25zJTJDJTIwcmVmZXJlbmNlcyUzRGxhYmVscyklMEElMEElMEFkZWYlMjBjb21wdXRlX29iamVjdGl2ZShtZXRyaWNzKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG1ldHJpY3MlNUIlMjJldmFsX2FjY3VyYWN5JTIyJTVEJTBBJTBBd2FuZGIuaW5pdChwcm9qZWN0JTNEJTIyaGYtb3B0dW5hJTIyJTJDJTIwbmFtZSUzRCUyMnRyYW5zZm9ybWVyc19vcHR1bmFfc3R1ZHklMjIpJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjIuJTJGcmVzdWx0cyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV2YWxfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhdmVfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvYWRfYmVzdF9tb2RlbF9hdF9lbmQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9nZ2luZ19zdHJhdGVneSUzRCUyMmVwb2NoJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3RyYWluX2Vwb2NocyUzRDMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvcnRfdG8lM0QlMjJ3YW5kYiUyMiUyQyUyMCUyMCUyMyUyMExvZ3MlMjB0byUyMFclMjZCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9nZ2luZ19kaXIlM0QlMjIuJTJGbG9ncyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJ1bl9uYW1lJTNEJTIydHJhbnNmb3JtZXJzX29wdHVuYV9zdHVkeSUyMiUyQyUwQSklMEElMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbF9pbml0JTNEbW9kZWxfaW5pdCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRva2VuaXplZF90cmFpbiUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRHRva2VuaXplZF92YWxpZCUyQyUwQSUyMCUyMCUyMCUyMHByb2Nlc3NpbmdfY2xhc3MlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> wandb
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer, TrainingArguments

<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions = eval_pred.predictions.argmax(axis=-<span class="hljs-number">1</span>)
    labels = eval_pred.label_ids
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_objective</span>(<span class="hljs-params">metrics</span>):
    <span class="hljs-keyword">return</span> metrics[<span class="hljs-string">&quot;eval_accuracy&quot;</span>]

wandb.init(project=<span class="hljs-string">&quot;hf-optuna&quot;</span>, name=<span class="hljs-string">&quot;transformers_optuna_study&quot;</span>)

training_args = TrainingArguments(
    output_dir=<span class="hljs-string">&quot;./results&quot;</span>,
        eval_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
        save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
        load_best_model_at_end=<span class="hljs-literal">True</span>,
        logging_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
        num_train_epochs=<span class="hljs-number">3</span>,
        report_to=<span class="hljs-string">&quot;wandb&quot;</span>,  <span class="hljs-comment"># Logs to W&amp;B</span>
        logging_dir=<span class="hljs-string">&quot;./logs&quot;</span>,
        run_name=<span class="hljs-string">&quot;transformers_optuna_study&quot;</span>,
)


trainer = Trainer(
    model_init=model_init,
    args=training_args,
    train_dataset=tokenized_train,
    eval_dataset=tokenized_valid,
    processing_class=tokenizer,
    compute_metrics=compute_metrics,
)`,wrap:!1}}),Re=new y({props:{title:"Define Search Space and Start Trials",local:"define-search-space-and-start-trials",headingTag:"h2"}}),we=new y({props:{title:"1. Design the Search Space",local:"1-design-the-search-space",headingTag:"h3"}}),ve=new y({props:{title:"2. Set the Optimization Direction",local:"2-set-the-optimization-direction",headingTag:"h3"}}),Ke=new y({props:{title:"3. Choose Optuna as the Backend",local:"3-choose-optuna-as-the-backend",headingTag:"h3"}}),be=new y({props:{title:"4. Specify the Number of Trials",local:"4-specify-the-number-of-trials",headingTag:"h3"}}),He=new y({props:{title:"5. Define the Objective Function",local:"5-define-the-objective-function",headingTag:"h3"}}),Pe=new y({props:{title:"6. Name the Study for Persistence",local:"6-name-the-study-for-persistence",headingTag:"h3"}}),qe=new y({props:{title:"7. Set Up Persistent Storage",local:"7-set-up-persistent-storage",headingTag:"h3"}}),We=new g({props:{code:"ZGVmJTIwb3B0dW5hX2hwX3NwYWNlKHRyaWFsKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxlYXJuaW5nX3JhdGUlMjIlM0ElMjB0cmlhbC5zdWdnZXN0X2Zsb2F0KCUyMmxlYXJuaW5nX3JhdGUlMjIlMkMlMjAxZS02JTJDJTIwMWUtNCUyQyUyMGxvZyUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIyJTNBJTIwdHJpYWwuc3VnZ2VzdF9jYXRlZ29yaWNhbCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjIlMkMlMjAlNUIxNiUyQyUyMDMyJTJDJTIwNjQlMkMlMjAxMjglNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyd2VpZ2h0X2RlY2F5JTIyJTNBJTIwdHJpYWwuc3VnZ2VzdF9mbG9hdCglMjJ3ZWlnaHRfZGVjYXklMjIlMkMlMjAwLjAlMkMlMjAwLjMpJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTBBJTBBYmVzdF9ydW4lMjAlM0QlMjB0cmFpbmVyLmh5cGVycGFyYW1ldGVyX3NlYXJjaCglMEElMjAlMjAlMjAlMjBkaXJlY3Rpb24lM0QlMjJtYXhpbWl6ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGJhY2tlbmQlM0QlMjJvcHR1bmElMjIlMkMlMEElMjAlMjAlMjAlMjBocF9zcGFjZSUzRG9wdHVuYV9ocF9zcGFjZSUyQyUwQSUyMCUyMCUyMCUyMG5fdHJpYWxzJTNENSUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfb2JqZWN0aXZlJTNEY29tcHV0ZV9vYmplY3RpdmUlMkMlMEElMjAlMjAlMjAlMjBzdHVkeV9uYW1lJTNEJTIydHJhbnNmb3JtZXJzX29wdHVuYV9zdHVkeSUyMiUyQyUwQSUyMCUyMCUyMCUyMHN0b3JhZ2UlM0QlMjJzcWxpdGUlM0ElMkYlMkYlMkZvcHR1bmFfdHJpYWxzLmRiJTIyJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9pZl9leGlzdHMlM0RUcnVlJTBBKSUwQSUwQXByaW50KGJlc3RfcnVuKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">optuna_hp_space</span>(<span class="hljs-params">trial</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;learning_rate&quot;</span>: trial.suggest_float(<span class="hljs-string">&quot;learning_rate&quot;</span>, <span class="hljs-number">1e-6</span>, <span class="hljs-number">1e-4</span>, log=<span class="hljs-literal">True</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>: trial.suggest_categorical(
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>, [<span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">128</span>]
<span class="hljs-meta">... </span>        ),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;weight_decay&quot;</span>: trial.suggest_float(<span class="hljs-string">&quot;weight_decay&quot;</span>, <span class="hljs-number">0.0</span>, <span class="hljs-number">0.3</span>),
<span class="hljs-meta">... </span>    }


<span class="hljs-meta">&gt;&gt;&gt; </span>best_run = trainer.hyperparameter_search(
<span class="hljs-meta">... </span>    direction=<span class="hljs-string">&quot;maximize&quot;</span>,
<span class="hljs-meta">... </span>    backend=<span class="hljs-string">&quot;optuna&quot;</span>,
<span class="hljs-meta">... </span>    hp_space=optuna_hp_space,
<span class="hljs-meta">... </span>    n_trials=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>    compute_objective=compute_objective,
<span class="hljs-meta">... </span>    study_name=<span class="hljs-string">&quot;transformers_optuna_study&quot;</span>,
<span class="hljs-meta">... </span>    storage=<span class="hljs-string">&quot;sqlite:///optuna_trials.db&quot;</span>,
<span class="hljs-meta">... </span>    load_if_exists=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(best_run)`,wrap:!1}}),Ze=new y({props:{title:"Visualize Results",local:"visualize-results",headingTag:"h2"}}),Se=new y({props:{title:"1. Track Optimization Progress",local:"1-track-optimization-progress",headingTag:"h3"}}),Ne=new y({props:{title:"2. Inspect Training Behavior via Intermediate Values",local:"2-inspect-training-behavior-via-intermediate-values",headingTag:"h3"}}),Ge=new y({props:{title:"3. Reveal Key Hyperparameters through Importance Rankings",local:"3-reveal-key-hyperparameters-through-importance-rankings",headingTag:"h3"}}),Ye=new g({props:{code:"aW1wb3J0JTIwb3B0dW5hJTBBZnJvbSUyMG9wdHVuYS52aXN1YWxpemF0aW9uLm1hdHBsb3RsaWIlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwcGxvdF9vcHRpbWl6YXRpb25faGlzdG9yeSUyQyUwQSUyMCUyMCUyMCUyMHBsb3RfaW50ZXJtZWRpYXRlX3ZhbHVlcyUyQyUwQSUyMCUyMCUyMCUyMHBsb3RfcGFyYW1faW1wb3J0YW5jZXMlMEEpJTBBaW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQSUyMyUyMExvYWQlMjB0aGUlMjBzdHVkeSUyMGZyb20lMjBSREIlMjBzdG9yYWdlJTBBc3RvcmFnZSUyMCUzRCUyMG9wdHVuYS5zdG9yYWdlcy5SREJTdG9yYWdlKCUyMnNxbGl0ZSUzQSUyRiUyRiUyRm9wdHVuYV90cmlhbHMuZGIlMjIpJTBBJTBBc3R1ZHklMjAlM0QlMjBvcHR1bmEubG9hZF9zdHVkeSglMEElMjAlMjAlMjAlMjBzdHVkeV9uYW1lJTNEJTIydHJhbnNmb3JtZXJzX29wdHVuYV9zdHVkeSUyMiUyQyUwQSUyMCUyMCUyMCUyMHN0b3JhZ2UlM0RzdG9yYWdlJTBBKSUwQSUwQSUyMyUyMFBsb3QlMjBvcHRpbWl6YXRpb24lMjBoaXN0b3J5JTBBYXgxJTIwJTNEJTIwcGxvdF9vcHRpbWl6YXRpb25faGlzdG9yeShzdHVkeSklMEFwbHQuc2hvdygpJTBBYXgxLmZpZ3VyZS5zYXZlZmlnKCUyMm9wdGltaXphdGlvbl9oaXN0b3J5LnBuZyUyMiklMEElMEElMjMlMjBQbG90JTIwaW50ZXJtZWRpYXRlJTIwdmFsdWVzJTIwKGlmJTIwdXNpbmclMjBwcnVuaW5nJTIwYW5kJTIwaW50ZXJtZWRpYXRlJTIwcmVwb3J0cyklMEFheDIlMjAlM0QlMjBwbG90X2ludGVybWVkaWF0ZV92YWx1ZXMoc3R1ZHkpJTBBcGx0LnNob3coKSUwQWF4Mi5maWd1cmUuc2F2ZWZpZyglMjJpbnRlcm1lZGlhdGVfdmFsdWVzLnBuZyUyMiklMEElMEElMjMlMjBQbG90JTIwcGFyYW1ldGVyJTIwaW1wb3J0YW5jZXMlMEFheDMlMjAlM0QlMjBwbG90X3BhcmFtX2ltcG9ydGFuY2VzKHN0dWR5KSUwQXBsdC5zaG93KCklMEFheDMuZmlndXJlLnNhdmVmaWcoJTIycGFyYW1faW1wb3J0YW5jZXMucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> optuna
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optuna.visualization.matplotlib <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    plot_optimization_history,
<span class="hljs-meta">... </span>    plot_intermediate_values,
<span class="hljs-meta">... </span>    plot_param_importances
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the study from RDB storage</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>storage = optuna.storages.RDBStorage(<span class="hljs-string">&quot;sqlite:///optuna_trials.db&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>study = optuna.load_study(
<span class="hljs-meta">... </span>    study_name=<span class="hljs-string">&quot;transformers_optuna_study&quot;</span>,
<span class="hljs-meta">... </span>    storage=storage
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Plot optimization history</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ax1 = plot_optimization_history(study)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()
<span class="hljs-meta">&gt;&gt;&gt; </span>ax1.figure.savefig(<span class="hljs-string">&quot;optimization_history.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Plot intermediate values (if using pruning and intermediate reports)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ax2 = plot_intermediate_values(study)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()
<span class="hljs-meta">&gt;&gt;&gt; </span>ax2.figure.savefig(<span class="hljs-string">&quot;intermediate_values.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Plot parameter importances</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ax3 = plot_param_importances(study)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()
<span class="hljs-meta">&gt;&gt;&gt; </span>ax3.figure.savefig(<span class="hljs-string">&quot;param_importances.png&quot;</span>)`,wrap:!1}}),Ee=new y({props:{title:"Perform Final Training",local:"perform-final-training",headingTag:"h2"}}),Le=new y({props:{title:"1. Retrieve Your Ingredients",local:"1-retrieve-your-ingredients",headingTag:"h3"}}),_e=new y({props:{title:"2. Configure Training Parameters",local:"2-configure-training-parameters",headingTag:"h3"}}),tt=new y({props:{title:"3. Incorporate into Model Setup",local:"3-incorporate-into-model-setup",headingTag:"h3"}}),st=new y({props:{title:"4. Fine-Tune Your Training Pipeline",local:"4-fine-tune-your-training-pipeline",headingTag:"h3"}}),lt=new y({props:{title:"5. Run Full Training",local:"5-run-full-training",headingTag:"h3"}}),ot=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEElMjMlMjBMb2FkJTIwSU1EYiUyMGRhdGFzZXQlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIpJTBBJTBBJTIzJTIwTG9hZCUyMHRva2VuaXplciUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSUwQSUwQSUyMyUyMFRva2VuaXplJTIwdGhlJTIwdGV4dCUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSklMEElMEElMjMlMjBBcHBseSUyMHRva2VuaXphdGlvbiUwQXRva2VuaXplZF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAodG9rZW5pemVfZnVuY3Rpb24lMkMlMjBiYXRjaGVkJTNEVHJ1ZSklMEElMEElMjMlMjBDbGVhbiUyMHVwJTIwY29sdW1ucyUwQXRva2VuaXplZF9kYXRhc2V0JTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXQucmVtb3ZlX2NvbHVtbnMoJTVCJTIydGV4dCUyMiU1RCklMEF0b2tlbml6ZWRfZGF0YXNldCUyMCUzRCUyMHRva2VuaXplZF9kYXRhc2V0LnJlbmFtZV9jb2x1bW4oJTIybGFiZWwlMjIlMkMlMjAlMjJsYWJlbHMlMjIpJTBBJTBBJTIzJTIwU2V0JTIwUHlUb3JjaCUyMGZvcm1hdCUwQXRva2VuaXplZF9kYXRhc2V0LnNldF9mb3JtYXQoJTIydG9yY2glMjIlMkMlMjBjb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTJDJTIwJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJsYWJlbHMlMjIlNUQpJTBBJTBBJTIzJTIwU3Vic2V0JTIwZm9yJTIwcXVpY2slMjB0ZXN0aW5nJTIwKG9wdGlvbmFsKSUwQXRyYWluX2RhdGFzZXQlMjAlM0QlMjB0b2tlbml6ZWRfZGF0YXNldCU1QiUyMnRyYWluJTIyJTVELnNodWZmbGUoc2VlZCUzRDQyKS5zZWxlY3QocmFuZ2UoMjAwMCkpJTBBdmFsaWRfZGF0YXNldCUyMCUzRCUyMHRva2VuaXplZF9kYXRhc2V0JTVCJTIydGVzdCUyMiU1RC5zaHVmZmxlKHNlZWQlM0Q0Mikuc2VsZWN0KHJhbmdlKDUwMCkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-comment"># Load IMDb dataset</span>
dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>)

<span class="hljs-comment"># Load tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)

<span class="hljs-comment"># Tokenize the text</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;text&quot;</span>], padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Apply tokenization</span>
tokenized_dataset = dataset.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Clean up columns</span>
tokenized_dataset = tokenized_dataset.remove_columns([<span class="hljs-string">&quot;text&quot;</span>])
tokenized_dataset = tokenized_dataset.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)

<span class="hljs-comment"># Set PyTorch format</span>
tokenized_dataset.set_format(<span class="hljs-string">&quot;torch&quot;</span>, columns=[<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>])

<span class="hljs-comment"># Subset for quick testing (optional)</span>
train_dataset = tokenized_dataset[<span class="hljs-string">&quot;train&quot;</span>].shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">2000</span>))
valid_dataset = tokenized_dataset[<span class="hljs-string">&quot;test&quot;</span>].shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">500</span>))`,wrap:!1}}),At=new g({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, TrainingArguments, Trainer

<span class="hljs-comment"># Define the model</span>
model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, num_labels=<span class="hljs-number">2</span>)

<span class="hljs-comment"># Load best hyperparameters (already defined earlier as best_hparams)</span>
training_args = TrainingArguments(
    output_dir=<span class="hljs-string">&quot;./final_model&quot;</span>,
    learning_rate=best_hparams[<span class="hljs-string">&quot;learning_rate&quot;</span>],
    per_device_train_batch_size=best_hparams[<span class="hljs-string">&quot;per_device_train_batch_size&quot;</span>],
    weight_decay=best_hparams[<span class="hljs-string">&quot;weight_decay&quot;</span>],    
    eval_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    logging_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    report_to=<span class="hljs-string">&quot;wandb&quot;</span>,
    run_name=<span class="hljs-string">&quot;final_run_with_best_hparams&quot;</span>
)

<span class="hljs-comment"># Create Trainer</span>
trainer = Trainer(
    model=model,
    args=training_args,
    train_dataset=train_dataset,
    eval_dataset=valid_dataset,
    processing_class=tokenizer,  
    compute_metrics=<span class="hljs-keyword">lambda</span> eval_pred: {
        <span class="hljs-string">&quot;accuracy&quot;</span>: (eval_pred.predictions.argmax(-<span class="hljs-number">1</span>) == eval_pred.label_ids).mean()
    }
)

<span class="hljs-comment"># Train</span>
trainer.train()

<span class="hljs-comment"># Save the model</span>
trainer.save_model(<span class="hljs-string">&quot;./final_model&quot;</span>)`,wrap:!1}}),pt=new y({props:{title:"Uploading to Hugging Face Hub",local:"uploading-to-hugging-face-hub",headingTag:"h2"}}),Ut=new y({props:{title:"1. Celebrate the Optimization Payoff",local:"1-celebrate-the-optimization-payoff",headingTag:"h3"}}),mt=new y({props:{title:"2. Save Your Work Locally",local:"2-save-your-work-locally",headingTag:"h3"}}),yt=new y({props:{title:"3. Authenticate with Hugging Face Hub",local:"3-authenticate-with-hugging-face-hub",headingTag:"h3"}}),gt=new y({props:{title:"4. Upload and Share",local:"4-upload-and-share",headingTag:"h3"}}),dt=new y({props:{title:"📌 Why It Matters:",local:"-why-it-matters",headingTag:"h4"}}),Rt=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwTG9hZCUyMHlvdXIlMjBzYXZlZCUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMHBhdGglMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZmaW5hbF9tb2RlbCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjIuJTJGZmluYWxfbW9kZWwlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRvJTIweW91ciUyMHJlcG9zaXRvcnklMjBvbiUyMHRoZSUyMGh1YiUwQW1vZGVsLnB1c2hfdG9faHViKCUyMkFJTm92aWNlMjAwNSUyRmJlcnQtaW1kYi1vcHR1bmEtaHBvJTIyKSUwQXRva2VuaXplci5wdXNoX3RvX2h1YiglMjJBSU5vdmljZTIwMDUlMkZiZXJ0LWltZGItb3B0dW5hLWhwbyUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSequenceClassification

<span class="hljs-comment"># Load your saved model from the path</span>
model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;./final_model&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;./final_model&quot;</span>)

<span class="hljs-comment"># Push to your repository on the hub</span>
model.push_to_hub(<span class="hljs-string">&quot;AINovice2005/bert-imdb-optuna-hpo&quot;</span>)
tokenizer.push_to_hub(<span class="hljs-string">&quot;AINovice2005/bert-imdb-optuna-hpo&quot;</span>)`,wrap:!1}}),jt=new Yi({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/optuna_hpo_with_transformers.md"}}),{c(){h=f("meta"),vt=i(),Mt=f("p"),Ct=i(),n(c.$$.fragment),Kt=i(),n(d.$$.fragment),Tt=i(),n(F.$$.fragment),bt=i(),R=f("p"),R.innerHTML=Qs,Bt=i(),n(j.$$.fragment),Ht=i(),w=f("p"),w.textContent=Ws,kt=i(),n(M.$$.fragment),Pt=i(),J=f("p"),J.textContent=Vs,It=i(),n(v.$$.fragment),qt=i(),C=f("ul"),C.innerHTML=Zs,Qt=i(),n(K.$$.fragment),Wt=i(),T=f("ul"),T.innerHTML=zs,Vt=i(),n(b.$$.fragment),Zt=i(),n(B.$$.fragment),zt=i(),H=f("p"),H.textContent=Ss,St=i(),n(k.$$.fragment),xt=i(),P=f("p"),P.textContent=xs,Nt=i(),n(I.$$.fragment),Xt=i(),q=f("p"),q.textContent=Ns,Gt=i(),Q=f("ul"),Q.innerHTML=Xs,Dt=i(),n(W.$$.fragment),Yt=i(),V=f("p"),V.textContent=Gs,Et=i(),Z=f("ul"),Z.innerHTML=Ds,$t=i(),n(z.$$.fragment),Lt=i(),S=f("p"),S.textContent=Ys,Ot=i(),n(x.$$.fragment),_t=i(),N=f("p"),N.textContent=Es,ea=i(),n(X.$$.fragment),ta=i(),G=f("p"),G.textContent=$s,aa=i(),n(D.$$.fragment),sa=i(),n(Y.$$.fragment),ia=i(),E=f("p"),E.innerHTML=Ls,la=i(),n($.$$.fragment),na=i(),L=f("p"),L.textContent=Os,oa=i(),n(O.$$.fragment),Aa=i(),_=f("p"),_.textContent=_s,pa=i(),n(ee.$$.fragment),ra=i(),te=f("p"),te.textContent=ei,Ua=i(),n(ae.$$.fragment),fa=i(),se=f("p"),se.textContent=ti,ma=i(),n(ie.$$.fragment),ua=i(),le=f("p"),le.textContent=ai,ya=i(),n(ne.$$.fragment),ha=i(),n(oe.$$.fragment),ga=i(),Ae=f("p"),Ae.textContent=si,ca=i(),n(pe.$$.fragment),da=i(),re=f("p"),re.textContent=ii,Fa=i(),n(Ue.$$.fragment),Ra=i(),fe=f("p"),fe.textContent=li,ja=i(),n(me.$$.fragment),wa=i(),ue=f("p"),ue.textContent=ni,Ma=i(),n(ye.$$.fragment),Ja=i(),he=f("p"),he.textContent=oi,va=i(),n(ge.$$.fragment),Ca=i(),ce=f("p"),ce.innerHTML=Ai,Ka=i(),de=f("ul"),de.innerHTML=pi,Ta=i(),n(Fe.$$.fragment),ba=i(),n(Re.$$.fragment),Ba=i(),je=f("p"),je.textContent=ri,Ha=i(),n(we.$$.fragment),ka=i(),Me=f("p"),Me.textContent=Ui,Pa=i(),Je=f("ul"),Je.innerHTML=fi,Ia=i(),n(ve.$$.fragment),qa=i(),Ce=f("p"),Ce.textContent=mi,Qa=i(),n(Ke.$$.fragment),Wa=i(),Te=f("p"),Te.textContent=ui,Va=i(),n(be.$$.fragment),Za=i(),Be=f("p"),Be.textContent=yi,za=i(),n(He.$$.fragment),Sa=i(),ke=f("p"),ke.textContent=hi,xa=i(),n(Pe.$$.fragment),Na=i(),Ie=f("p"),Ie.textContent=gi,Xa=i(),n(qe.$$.fragment),Ga=i(),Qe=f("p"),Qe.textContent=ci,Da=i(),n(We.$$.fragment),Ya=i(),Ve=f("pre"),Ve.textContent=di,Ea=i(),n(Ze.$$.fragment),$a=i(),ze=f("p"),ze.textContent=Fi,La=i(),n(Se.$$.fragment),Oa=i(),xe=f("p"),xe.textContent=Ri,_a=i(),n(Ne.$$.fragment),es=i(),Xe=f("p"),Xe.textContent=ji,ts=i(),n(Ge.$$.fragment),as=i(),De=f("p"),De.textContent=wi,ss=i(),n(Ye.$$.fragment),is=i(),wt=f("img"),ls=i(),n(Ee.$$.fragment),ns=i(),$e=f("p"),$e.textContent=Ji,os=i(),n(Le.$$.fragment),As=i(),Oe=f("p"),Oe.textContent=vi,ps=i(),n(_e.$$.fragment),rs=i(),et=f("p"),et.textContent=Ci,Us=i(),n(tt.$$.fragment),fs=i(),at=f("p"),at.textContent=Ki,ms=i(),n(st.$$.fragment),us=i(),it=f("p"),it.textContent=Ti,ys=i(),n(lt.$$.fragment),hs=i(),nt=f("p"),nt.textContent=bi,gs=i(),n(ot.$$.fragment),cs=i(),n(At.$$.fragment),ds=i(),n(pt.$$.fragment),Fs=i(),rt=f("p"),rt.textContent=Bi,Rs=i(),n(Ut.$$.fragment),js=i(),ft=f("p"),ft.textContent=Hi,ws=i(),n(mt.$$.fragment),Ms=i(),ut=f("p"),ut.textContent=ki,Js=i(),n(yt.$$.fragment),vs=i(),ht=f("p"),ht.textContent=Pi,Cs=i(),n(gt.$$.fragment),Ks=i(),ct=f("p"),ct.textContent=Ii,Ts=i(),n(dt.$$.fragment),bs=i(),Ft=f("ul"),Ft.innerHTML=qi,Bs=i(),n(Rt.$$.fragment),Hs=i(),n(jt.$$.fragment),ks=i(),Jt=f("p"),this.h()},l(e){const t=Ni("svelte-u9bgzb",document.head);h=m(t,"META",{name:!0,content:!0}),t.forEach(a),vt=l(e),Mt=m(e,"P",{}),Qi(Mt).forEach(a),Ct=l(e),o(c.$$.fragment,e),Kt=l(e),o(d.$$.fragment,e),Tt=l(e),o(F.$$.fragment,e),bt=l(e),R=m(e,"P",{"data-svelte-h":!0}),u(R)!=="svelte-1ldvsqh"&&(R.innerHTML=Qs),Bt=l(e),o(j.$$.fragment,e),Ht=l(e),w=m(e,"P",{"data-svelte-h":!0}),u(w)!=="svelte-kbhq3p"&&(w.textContent=Ws),kt=l(e),o(M.$$.fragment,e),Pt=l(e),J=m(e,"P",{"data-svelte-h":!0}),u(J)!=="svelte-1ejiwz1"&&(J.textContent=Vs),It=l(e),o(v.$$.fragment,e),qt=l(e),C=m(e,"UL",{"data-svelte-h":!0}),u(C)!=="svelte-vj9d8z"&&(C.innerHTML=Zs),Qt=l(e),o(K.$$.fragment,e),Wt=l(e),T=m(e,"UL",{"data-svelte-h":!0}),u(T)!=="svelte-1dq1krz"&&(T.innerHTML=zs),Vt=l(e),o(b.$$.fragment,e),Zt=l(e),o(B.$$.fragment,e),zt=l(e),H=m(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-1qm1969"&&(H.textContent=Ss),St=l(e),o(k.$$.fragment,e),xt=l(e),P=m(e,"P",{"data-svelte-h":!0}),u(P)!=="svelte-1h8e91i"&&(P.textContent=xs),Nt=l(e),o(I.$$.fragment,e),Xt=l(e),q=m(e,"P",{"data-svelte-h":!0}),u(q)!=="svelte-mukm6j"&&(q.textContent=Ns),Gt=l(e),Q=m(e,"UL",{"data-svelte-h":!0}),u(Q)!=="svelte-g50scj"&&(Q.innerHTML=Xs),Dt=l(e),o(W.$$.fragment,e),Yt=l(e),V=m(e,"P",{"data-svelte-h":!0}),u(V)!=="svelte-1kop5pz"&&(V.textContent=Gs),Et=l(e),Z=m(e,"UL",{"data-svelte-h":!0}),u(Z)!=="svelte-upp9ft"&&(Z.innerHTML=Ds),$t=l(e),o(z.$$.fragment,e),Lt=l(e),S=m(e,"P",{"data-svelte-h":!0}),u(S)!=="svelte-ywq32u"&&(S.textContent=Ys),Ot=l(e),o(x.$$.fragment,e),_t=l(e),N=m(e,"P",{"data-svelte-h":!0}),u(N)!=="svelte-1mwvdaw"&&(N.textContent=Es),ea=l(e),o(X.$$.fragment,e),ta=l(e),G=m(e,"P",{"data-svelte-h":!0}),u(G)!=="svelte-1qqypm8"&&(G.textContent=$s),aa=l(e),o(D.$$.fragment,e),sa=l(e),o(Y.$$.fragment,e),ia=l(e),E=m(e,"P",{"data-svelte-h":!0}),u(E)!=="svelte-wtxs7k"&&(E.innerHTML=Ls),la=l(e),o($.$$.fragment,e),na=l(e),L=m(e,"P",{"data-svelte-h":!0}),u(L)!=="svelte-mi6zw7"&&(L.textContent=Os),oa=l(e),o(O.$$.fragment,e),Aa=l(e),_=m(e,"P",{"data-svelte-h":!0}),u(_)!=="svelte-1h25q1e"&&(_.textContent=_s),pa=l(e),o(ee.$$.fragment,e),ra=l(e),te=m(e,"P",{"data-svelte-h":!0}),u(te)!=="svelte-i1a67z"&&(te.textContent=ei),Ua=l(e),o(ae.$$.fragment,e),fa=l(e),se=m(e,"P",{"data-svelte-h":!0}),u(se)!=="svelte-36ardw"&&(se.textContent=ti),ma=l(e),o(ie.$$.fragment,e),ua=l(e),le=m(e,"P",{"data-svelte-h":!0}),u(le)!=="svelte-nlfeg0"&&(le.textContent=ai),ya=l(e),o(ne.$$.fragment,e),ha=l(e),o(oe.$$.fragment,e),ga=l(e),Ae=m(e,"P",{"data-svelte-h":!0}),u(Ae)!=="svelte-18plh1q"&&(Ae.textContent=si),ca=l(e),o(pe.$$.fragment,e),da=l(e),re=m(e,"P",{"data-svelte-h":!0}),u(re)!=="svelte-1x6y3iu"&&(re.textContent=ii),Fa=l(e),o(Ue.$$.fragment,e),Ra=l(e),fe=m(e,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-zqn0nf"&&(fe.textContent=li),ja=l(e),o(me.$$.fragment,e),wa=l(e),ue=m(e,"P",{"data-svelte-h":!0}),u(ue)!=="svelte-1ydob01"&&(ue.textContent=ni),Ma=l(e),o(ye.$$.fragment,e),Ja=l(e),he=m(e,"P",{"data-svelte-h":!0}),u(he)!=="svelte-1s6w4fk"&&(he.textContent=oi),va=l(e),o(ge.$$.fragment,e),Ca=l(e),ce=m(e,"P",{"data-svelte-h":!0}),u(ce)!=="svelte-70nwk5"&&(ce.innerHTML=Ai),Ka=l(e),de=m(e,"UL",{"data-svelte-h":!0}),u(de)!=="svelte-uox994"&&(de.innerHTML=pi),Ta=l(e),o(Fe.$$.fragment,e),ba=l(e),o(Re.$$.fragment,e),Ba=l(e),je=m(e,"P",{"data-svelte-h":!0}),u(je)!=="svelte-1daqoq0"&&(je.textContent=ri),Ha=l(e),o(we.$$.fragment,e),ka=l(e),Me=m(e,"P",{"data-svelte-h":!0}),u(Me)!=="svelte-9dn1ib"&&(Me.textContent=Ui),Pa=l(e),Je=m(e,"UL",{"data-svelte-h":!0}),u(Je)!=="svelte-1iceiy0"&&(Je.innerHTML=fi),Ia=l(e),o(ve.$$.fragment,e),qa=l(e),Ce=m(e,"P",{"data-svelte-h":!0}),u(Ce)!=="svelte-1ubss3q"&&(Ce.textContent=mi),Qa=l(e),o(Ke.$$.fragment,e),Wa=l(e),Te=m(e,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-1n81i45"&&(Te.textContent=ui),Va=l(e),o(be.$$.fragment,e),Za=l(e),Be=m(e,"P",{"data-svelte-h":!0}),u(Be)!=="svelte-gwewoq"&&(Be.textContent=yi),za=l(e),o(He.$$.fragment,e),Sa=l(e),ke=m(e,"P",{"data-svelte-h":!0}),u(ke)!=="svelte-1pmllfv"&&(ke.textContent=hi),xa=l(e),o(Pe.$$.fragment,e),Na=l(e),Ie=m(e,"P",{"data-svelte-h":!0}),u(Ie)!=="svelte-b63dv"&&(Ie.textContent=gi),Xa=l(e),o(qe.$$.fragment,e),Ga=l(e),Qe=m(e,"P",{"data-svelte-h":!0}),u(Qe)!=="svelte-d53kha"&&(Qe.textContent=ci),Da=l(e),o(We.$$.fragment,e),Ya=l(e),Ve=m(e,"PRE",{"data-svelte-h":!0}),u(Ve)!=="svelte-1rts4ik"&&(Ve.textContent=di),Ea=l(e),o(Ze.$$.fragment,e),$a=l(e),ze=m(e,"P",{"data-svelte-h":!0}),u(ze)!=="svelte-157rknr"&&(ze.textContent=Fi),La=l(e),o(Se.$$.fragment,e),Oa=l(e),xe=m(e,"P",{"data-svelte-h":!0}),u(xe)!=="svelte-144q5eh"&&(xe.textContent=Ri),_a=l(e),o(Ne.$$.fragment,e),es=l(e),Xe=m(e,"P",{"data-svelte-h":!0}),u(Xe)!=="svelte-15g5nn2"&&(Xe.textContent=ji),ts=l(e),o(Ge.$$.fragment,e),as=l(e),De=m(e,"P",{"data-svelte-h":!0}),u(De)!=="svelte-1e0xvmz"&&(De.textContent=wi),ss=l(e),o(Ye.$$.fragment,e),is=l(e),wt=m(e,"IMG",{src:!0}),ls=l(e),o(Ee.$$.fragment,e),ns=l(e),$e=m(e,"P",{"data-svelte-h":!0}),u($e)!=="svelte-w72j2l"&&($e.textContent=Ji),os=l(e),o(Le.$$.fragment,e),As=l(e),Oe=m(e,"P",{"data-svelte-h":!0}),u(Oe)!=="svelte-gx0dur"&&(Oe.textContent=vi),ps=l(e),o(_e.$$.fragment,e),rs=l(e),et=m(e,"P",{"data-svelte-h":!0}),u(et)!=="svelte-7rg0s4"&&(et.textContent=Ci),Us=l(e),o(tt.$$.fragment,e),fs=l(e),at=m(e,"P",{"data-svelte-h":!0}),u(at)!=="svelte-102bhcs"&&(at.textContent=Ki),ms=l(e),o(st.$$.fragment,e),us=l(e),it=m(e,"P",{"data-svelte-h":!0}),u(it)!=="svelte-vmidk5"&&(it.textContent=Ti),ys=l(e),o(lt.$$.fragment,e),hs=l(e),nt=m(e,"P",{"data-svelte-h":!0}),u(nt)!=="svelte-matwi3"&&(nt.textContent=bi),gs=l(e),o(ot.$$.fragment,e),cs=l(e),o(At.$$.fragment,e),ds=l(e),o(pt.$$.fragment,e),Fs=l(e),rt=m(e,"P",{"data-svelte-h":!0}),u(rt)!=="svelte-p1qtas"&&(rt.textContent=Bi),Rs=l(e),o(Ut.$$.fragment,e),js=l(e),ft=m(e,"P",{"data-svelte-h":!0}),u(ft)!=="svelte-135mu2i"&&(ft.textContent=Hi),ws=l(e),o(mt.$$.fragment,e),Ms=l(e),ut=m(e,"P",{"data-svelte-h":!0}),u(ut)!=="svelte-18i7u2x"&&(ut.textContent=ki),Js=l(e),o(yt.$$.fragment,e),vs=l(e),ht=m(e,"P",{"data-svelte-h":!0}),u(ht)!=="svelte-103zpru"&&(ht.textContent=Pi),Cs=l(e),o(gt.$$.fragment,e),Ks=l(e),ct=m(e,"P",{"data-svelte-h":!0}),u(ct)!=="svelte-1w6ahkq"&&(ct.textContent=Ii),Ts=l(e),o(dt.$$.fragment,e),bs=l(e),Ft=m(e,"UL",{"data-svelte-h":!0}),u(Ft)!=="svelte-r0xdr"&&(Ft.innerHTML=qi),Bs=l(e),o(Rt.$$.fragment,e),Hs=l(e),o(jt.$$.fragment,e),ks=l(e),Jt=m(e,"P",{}),Qi(Jt).forEach(a),this.h()},h(){Is(h,"name","hf:doc:metadata"),Is(h,"content",$i),Vi(wt.src,Mi="data:image/jpeg;base64,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")||Is(wt,"src",Mi)},m(e,t){Xi(document.head,h),s(e,vt,t),s(e,Mt,t),s(e,Ct,t),A(c,e,t),s(e,Kt,t),A(d,e,t),s(e,Tt,t),A(F,e,t),s(e,bt,t),s(e,R,t),s(e,Bt,t),A(j,e,t),s(e,Ht,t),s(e,w,t),s(e,kt,t),A(M,e,t),s(e,Pt,t),s(e,J,t),s(e,It,t),A(v,e,t),s(e,qt,t),s(e,C,t),s(e,Qt,t),A(K,e,t),s(e,Wt,t),s(e,T,t),s(e,Vt,t),A(b,e,t),s(e,Zt,t),A(B,e,t),s(e,zt,t),s(e,H,t),s(e,St,t),A(k,e,t),s(e,xt,t),s(e,P,t),s(e,Nt,t),A(I,e,t),s(e,Xt,t),s(e,q,t),s(e,Gt,t),s(e,Q,t),s(e,Dt,t),A(W,e,t),s(e,Yt,t),s(e,V,t),s(e,Et,t),s(e,Z,t),s(e,$t,t),A(z,e,t),s(e,Lt,t),s(e,S,t),s(e,Ot,t),A(x,e,t),s(e,_t,t),s(e,N,t),s(e,ea,t),A(X,e,t),s(e,ta,t),s(e,G,t),s(e,aa,t),A(D,e,t),s(e,sa,t),A(Y,e,t),s(e,ia,t),s(e,E,t),s(e,la,t),A($,e,t),s(e,na,t),s(e,L,t),s(e,oa,t),A(O,e,t),s(e,Aa,t),s(e,_,t),s(e,pa,t),A(ee,e,t),s(e,ra,t),s(e,te,t),s(e,Ua,t),A(ae,e,t),s(e,fa,t),s(e,se,t),s(e,ma,t),A(ie,e,t),s(e,ua,t),s(e,le,t),s(e,ya,t),A(ne,e,t),s(e,ha,t),A(oe,e,t),s(e,ga,t),s(e,Ae,t),s(e,ca,t),A(pe,e,t),s(e,da,t),s(e,re,t),s(e,Fa,t),A(Ue,e,t),s(e,Ra,t),s(e,fe,t),s(e,ja,t),A(me,e,t),s(e,wa,t),s(e,ue,t),s(e,Ma,t),A(ye,e,t),s(e,Ja,t),s(e,he,t),s(e,va,t),A(ge,e,t),s(e,Ca,t),s(e,ce,t),s(e,Ka,t),s(e,de,t),s(e,Ta,t),A(Fe,e,t),s(e,ba,t),A(Re,e,t),s(e,Ba,t),s(e,je,t),s(e,Ha,t),A(we,e,t),s(e,ka,t),s(e,Me,t),s(e,Pa,t),s(e,Je,t),s(e,Ia,t),A(ve,e,t),s(e,qa,t),s(e,Ce,t),s(e,Qa,t),A(Ke,e,t),s(e,Wa,t),s(e,Te,t),s(e,Va,t),A(be,e,t),s(e,Za,t),s(e,Be,t),s(e,za,t),A(He,e,t),s(e,Sa,t),s(e,ke,t),s(e,xa,t),A(Pe,e,t),s(e,Na,t),s(e,Ie,t),s(e,Xa,t),A(qe,e,t),s(e,Ga,t),s(e,Qe,t),s(e,Da,t),A(We,e,t),s(e,Ya,t),s(e,Ve,t),s(e,Ea,t),A(Ze,e,t),s(e,$a,t),s(e,ze,t),s(e,La,t),A(Se,e,t),s(e,Oa,t),s(e,xe,t),s(e,_a,t),A(Ne,e,t),s(e,es,t),s(e,Xe,t),s(e,ts,t),A(Ge,e,t),s(e,as,t),s(e,De,t),s(e,ss,t),A(Ye,e,t),s(e,is,t),s(e,wt,t),s(e,ls,t),A(Ee,e,t),s(e,ns,t),s(e,$e,t),s(e,os,t),A(Le,e,t),s(e,As,t),s(e,Oe,t),s(e,ps,t),A(_e,e,t),s(e,rs,t),s(e,et,t),s(e,Us,t),A(tt,e,t),s(e,fs,t),s(e,at,t),s(e,ms,t),A(st,e,t),s(e,us,t),s(e,it,t),s(e,ys,t),A(lt,e,t),s(e,hs,t),s(e,nt,t),s(e,gs,t),A(ot,e,t),s(e,cs,t),A(At,e,t),s(e,ds,t),A(pt,e,t),s(e,Fs,t),s(e,rt,t),s(e,Rs,t),A(Ut,e,t),s(e,js,t),s(e,ft,t),s(e,ws,t),A(mt,e,t),s(e,Ms,t),s(e,ut,t),s(e,Js,t),A(yt,e,t),s(e,vs,t),s(e,ht,t),s(e,Cs,t),A(gt,e,t),s(e,Ks,t),s(e,ct,t),s(e,Ts,t),A(dt,e,t),s(e,bs,t),s(e,Ft,t),s(e,Bs,t),A(Rt,e,t),s(e,Hs,t),A(jt,e,t),s(e,ks,t),s(e,Jt,t),Ps=!0},p:Zi,i(e){Ps||(p(c.$$.fragment,e),p(d.$$.fragment,e),p(F.$$.fragment,e),p(j.$$.fragment,e),p(M.$$.fragment,e),p(v.$$.fragment,e),p(K.$$.fragment,e),p(b.$$.fragment,e),p(B.$$.fragment,e),p(k.$$.fragment,e),p(I.$$.fragment,e),p(W.$$.fragment,e),p(z.$$.fragment,e),p(x.$$.fragment,e),p(X.$$.fragment,e),p(D.$$.fragment,e),p(Y.$$.fragment,e),p($.$$.fragment,e),p(O.$$.fragment,e),p(ee.$$.fragment,e),p(ae.$$.fragment,e),p(ie.$$.fragment,e),p(ne.$$.fragment,e),p(oe.$$.fragment,e),p(pe.$$.fragment,e),p(Ue.$$.fragment,e),p(me.$$.fragment,e),p(ye.$$.fragment,e),p(ge.$$.fragment,e),p(Fe.$$.fragment,e),p(Re.$$.fragment,e),p(we.$$.fragment,e),p(ve.$$.fragment,e),p(Ke.$$.fragment,e),p(be.$$.fragment,e),p(He.$$.fragment,e),p(Pe.$$.fragment,e),p(qe.$$.fragment,e),p(We.$$.fragment,e),p(Ze.$$.fragment,e),p(Se.$$.fragment,e),p(Ne.$$.fragment,e),p(Ge.$$.fragment,e),p(Ye.$$.fragment,e),p(Ee.$$.fragment,e),p(Le.$$.fragment,e),p(_e.$$.fragment,e),p(tt.$$.fragment,e),p(st.$$.fragment,e),p(lt.$$.fragment,e),p(ot.$$.fragment,e),p(At.$$.fragment,e),p(pt.$$.fragment,e),p(Ut.$$.fragment,e),p(mt.$$.fragment,e),p(yt.$$.fragment,e),p(gt.$$.fragment,e),p(dt.$$.fragment,e),p(Rt.$$.fragment,e),p(jt.$$.fragment,e),Ps=!0)},o(e){r(c.$$.fragment,e),r(d.$$.fragment,e),r(F.$$.fragment,e),r(j.$$.fragment,e),r(M.$$.fragment,e),r(v.$$.fragment,e),r(K.$$.fragment,e),r(b.$$.fragment,e),r(B.$$.fragment,e),r(k.$$.fragment,e),r(I.$$.fragment,e),r(W.$$.fragment,e),r(z.$$.fragment,e),r(x.$$.fragment,e),r(X.$$.fragment,e),r(D.$$.fragment,e),r(Y.$$.fragment,e),r($.$$.fragment,e),r(O.$$.fragment,e),r(ee.$$.fragment,e),r(ae.$$.fragment,e),r(ie.$$.fragment,e),r(ne.$$.fragment,e),r(oe.$$.fragment,e),r(pe.$$.fragment,e),r(Ue.$$.fragment,e),r(me.$$.fragment,e),r(ye.$$.fragment,e),r(ge.$$.fragment,e),r(Fe.$$.fragment,e),r(Re.$$.fragment,e),r(we.$$.fragment,e),r(ve.$$.fragment,e),r(Ke.$$.fragment,e),r(be.$$.fragment,e),r(He.$$.fragment,e),r(Pe.$$.fragment,e),r(qe.$$.fragment,e),r(We.$$.fragment,e),r(Ze.$$.fragment,e),r(Se.$$.fragment,e),r(Ne.$$.fragment,e),r(Ge.$$.fragment,e),r(Ye.$$.fragment,e),r(Ee.$$.fragment,e),r(Le.$$.fragment,e),r(_e.$$.fragment,e),r(tt.$$.fragment,e),r(st.$$.fragment,e),r(lt.$$.fragment,e),r(ot.$$.fragment,e),r(At.$$.fragment,e),r(pt.$$.fragment,e),r(Ut.$$.fragment,e),r(mt.$$.fragment,e),r(yt.$$.fragment,e),r(gt.$$.fragment,e),r(dt.$$.fragment,e),r(Rt.$$.fragment,e),r(jt.$$.fragment,e),Ps=!1},d(e){e&&(a(vt),a(Mt),a(Ct),a(Kt),a(Tt),a(bt),a(R),a(Bt),a(Ht),a(w),a(kt),a(Pt),a(J),a(It),a(qt),a(C),a(Qt),a(Wt),a(T),a(Vt),a(Zt),a(zt),a(H),a(St),a(xt),a(P),a(Nt),a(Xt),a(q),a(Gt),a(Q),a(Dt),a(Yt),a(V),a(Et),a(Z),a($t),a(Lt),a(S),a(Ot),a(_t),a(N),a(ea),a(ta),a(G),a(aa),a(sa),a(ia),a(E),a(la),a(na),a(L),a(oa),a(Aa),a(_),a(pa),a(ra),a(te),a(Ua),a(fa),a(se),a(ma),a(ua),a(le),a(ya),a(ha),a(ga),a(Ae),a(ca),a(da),a(re),a(Fa),a(Ra),a(fe),a(ja),a(wa),a(ue),a(Ma),a(Ja),a(he),a(va),a(Ca),a(ce),a(Ka),a(de),a(Ta),a(ba),a(Ba),a(je),a(Ha),a(ka),a(Me),a(Pa),a(Je),a(Ia),a(qa),a(Ce),a(Qa),a(Wa),a(Te),a(Va),a(Za),a(Be),a(za),a(Sa),a(ke),a(xa),a(Na),a(Ie),a(Xa),a(Ga),a(Qe),a(Da),a(Ya),a(Ve),a(Ea),a($a),a(ze),a(La),a(Oa),a(xe),a(_a),a(es),a(Xe),a(ts),a(as),a(De),a(ss),a(is),a(wt),a(ls),a(ns),a($e),a(os),a(As),a(Oe),a(ps),a(rs),a(et),a(Us),a(fs),a(at),a(ms),a(us),a(it),a(ys),a(hs),a(nt),a(gs),a(cs),a(ds),a(Fs),a(rt),a(Rs),a(js),a(ft),a(ws),a(Ms),a(ut),a(Js),a(vs),a(ht),a(Cs),a(Ks),a(ct),a(Ts),a(bs),a(Ft),a(Bs),a(Hs),a(ks),a(Jt)),a(h),U(c,e),U(d,e),U(F,e),U(j,e),U(M,e),U(v,e),U(K,e),U(b,e),U(B,e),U(k,e),U(I,e),U(W,e),U(z,e),U(x,e),U(X,e),U(D,e),U(Y,e),U($,e),U(O,e),U(ee,e),U(ae,e),U(ie,e),U(ne,e),U(oe,e),U(pe,e),U(Ue,e),U(me,e),U(ye,e),U(ge,e),U(Fe,e),U(Re,e),U(we,e),U(ve,e),U(Ke,e),U(be,e),U(He,e),U(Pe,e),U(qe,e),U(We,e),U(Ze,e),U(Se,e),U(Ne,e),U(Ge,e),U(Ye,e),U(Ee,e),U(Le,e),U(_e,e),U(tt,e),U(st,e),U(lt,e),U(ot,e),U(At,e),U(pt,e),U(Ut,e),U(mt,e),U(yt,e),U(gt,e),U(dt,e),U(Rt,e),U(jt,e)}}}const $i='{"title":"Hyperparameter Optimization with Optuna and Transformers","local":"hyperparameter-optimization-with-optuna-and-transformers","sections":[{"title":"Problem:","local":"problem","sections":[],"depth":2},{"title":"Overview:","local":"overview","sections":[],"depth":2},{"title":"When to Use This Recipe:","local":"when-to-use-this-recipe","sections":[{"title":"Notes","local":"notes","sections":[],"depth":3}],"depth":2},{"title":"Prepare Dataset and Set Model","local":"prepare-dataset-and-set-model","sections":[{"title":"1. Load the IMDB Dataset","local":"1-load-the-imdb-dataset","sections":[],"depth":3},{"title":"2. Select Input and Output Columns","local":"2-select-input-and-output-columns","sections":[],"depth":3},{"title":"3. Define the Train/Validation Split","local":"3-define-the-trainvalidation-split","sections":[],"depth":3},{"title":"4. Tokenize the Dataset","local":"4-tokenize-the-dataset","sections":[],"depth":3},{"title":"5. Load an Evaluation Metric","local":"5-load-an-evaluation-metric","sections":[],"depth":3},{"title":"6. Initialize a Pretrained BERT Model","local":"6-initialize-a-pretrained-bert-model","sections":[],"depth":3}],"depth":2},{"title":"Define Storage with Optuna","local":"define-storage-with-optuna","sections":[{"title":"1. Choose a Persistent Storage Format","local":"1-choose-a-persistent-storage-format","sections":[],"depth":3},{"title":"2. Enable Optuna’s RDBStorage","local":"2-enable-optunas-rdbstorage","sections":[],"depth":3},{"title":"3. Preserve Trial History Across Sessions","local":"3-preserve-trial-history-across-sessions","sections":[],"depth":3},{"title":"4. Facilitate Reproducible Analysis","local":"4-facilitate-reproducible-analysis","sections":[],"depth":3},{"title":"5. Support Visualization and Monitoring Tools","local":"5-support-visualization-and-monitoring-tools","sections":[],"depth":3}],"depth":2},{"title":"Initialize Trainer and Set Up Observability","local":"initialize-trainer-and-set-up-observability","sections":[{"title":"1. Define the Metric Function","local":"1-define-the-metric-function","sections":[],"depth":3},{"title":"2. Construct the Objective Function","local":"2-construct-the-objective-function","sections":[],"depth":3},{"title":"3. Set Up Weight & Biases for Observability","local":"3-set-up-weight--biases-for-observability","sections":[],"depth":3},{"title":"4. Authenticate for Logging Access","local":"4-authenticate-for-logging-access","sections":[],"depth":3},{"title":"5. Define Trainer Arguments","local":"5-define-trainer-arguments","sections":[],"depth":3}],"depth":2},{"title":"Define Search Space and Start Trials","local":"define-search-space-and-start-trials","sections":[{"title":"1. Design the Search Space","local":"1-design-the-search-space","sections":[],"depth":3},{"title":"2. Set the Optimization Direction","local":"2-set-the-optimization-direction","sections":[],"depth":3},{"title":"3. Choose Optuna as the Backend","local":"3-choose-optuna-as-the-backend","sections":[],"depth":3},{"title":"4. Specify the Number of Trials","local":"4-specify-the-number-of-trials","sections":[],"depth":3},{"title":"5. Define the Objective Function","local":"5-define-the-objective-function","sections":[],"depth":3},{"title":"6. Name the Study for Persistence","local":"6-name-the-study-for-persistence","sections":[],"depth":3},{"title":"7. Set Up Persistent Storage","local":"7-set-up-persistent-storage","sections":[],"depth":3}],"depth":2},{"title":"Visualize Results","local":"visualize-results","sections":[{"title":"1. Track Optimization Progress","local":"1-track-optimization-progress","sections":[],"depth":3},{"title":"2. Inspect Training Behavior via Intermediate Values","local":"2-inspect-training-behavior-via-intermediate-values","sections":[],"depth":3},{"title":"3. Reveal Key Hyperparameters through Importance Rankings","local":"3-reveal-key-hyperparameters-through-importance-rankings","sections":[],"depth":3}],"depth":2},{"title":"Perform Final Training","local":"perform-final-training","sections":[{"title":"1. Retrieve Your Ingredients","local":"1-retrieve-your-ingredients","sections":[],"depth":3},{"title":"2. Configure Training Parameters","local":"2-configure-training-parameters","sections":[],"depth":3},{"title":"3. Incorporate into Model Setup","local":"3-incorporate-into-model-setup","sections":[],"depth":3},{"title":"4. Fine-Tune Your Training Pipeline","local":"4-fine-tune-your-training-pipeline","sections":[],"depth":3},{"title":"5. Run Full Training","local":"5-run-full-training","sections":[],"depth":3}],"depth":2},{"title":"Uploading to Hugging Face Hub","local":"uploading-to-hugging-face-hub","sections":[{"title":"1. Celebrate the Optimization Payoff","local":"1-celebrate-the-optimization-payoff","sections":[],"depth":3},{"title":"2. Save Your Work Locally","local":"2-save-your-work-locally","sections":[],"depth":3},{"title":"3. Authenticate with Hugging Face Hub","local":"3-authenticate-with-hugging-face-hub","sections":[],"depth":3},{"title":"4. Upload and Share","local":"4-upload-and-share","sections":[{"title":"📌 Why It Matters:","local":"-why-it-matters","sections":[],"depth":4}],"depth":3}],"depth":2}],"depth":1}';function Li(qs){return zi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sl extends Si{constructor(h){super(),xi(this,h,Li,Ei,Wi,{})}}export{sl as component};
