import{s as Ce,n as Ie,o as ge}from"../chunks/scheduler.1f027d5a.js";import{S as be,i as Ae,e as M,s as t,c as o,h as fe,a as i,d as e,b as n,f as we,g as j,j as p,k as vl,l as Ee,m as a,n as y,t as c,o as U,p as r}from"../chunks/index.5cb6ce42.js";import{C as Be}from"../chunks/CopyLLMTxtMenu.f7108191.js";import{D as Ze,C as h}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as J,E as Ve}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function Re(Xl){let T,Bs,fs,Zs,d,Vs,u,Rs,w,Gs,C,$l='Authored By: <a href="https://huggingface.co/lloydmeta" rel="nofollow">lloydmeta</a>',Ss,I,Fl="This notebook walks you through building a Retrieval-Augmented Generation (RAG) powered by Elasticsearch (ES) and Hugging Face models, letting you toggle between ES-vectorising (your ES cluster vectorises for you when ingesting and querying) vs self-vectorising (you vectorise all your data before sending it to ES).",ks,g,xl="What should you use for your use case? <em>It depends</em> 🤷‍♂️. ES-vectorising means your clients don’t have to implement it, so that’s the default here; however, if you don’t have any ML nodes, or your own embedding setup is better/faster, feel free to set <code>USE_ELASTICSEARCH_VECTORISATION</code> to <code>False</code> in the <code>Choose data and query vectorisation options</code> section below!",Qs,m,Hl="<p>This notebook has been tested with ES 8.13.x, and 8.14.x</p>",Ws,b,Ns,A,_s,f,qs,E,vs,B,Yl="This allows you to authenticate with Hugging Face to download models and datasets.",Xs,Z,$s,V,Fs,R,zl='Let’s make sure that you can access your Elasticsearch deployment. If you don’t have one, create one at <a href="https://www.elastic.co/search-labs/tutorials/install-elasticsearch/elastic-cloud#creating-a-cloud-deployment" rel="nofollow">Elastic Cloud</a>.',xs,G,Ll="Ensure you have <code>CLOUD_ID</code> and <code>ELASTIC_DEPL_API_KEY</code> saved as Colab secrets.",Hs,S,Dl='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/colab-secrets.jpeg" alt="Image of how to set up secrets using Google Colab"/>',Ys,k,zs,Q,Pl="Set up the client and make sure the credentials work.",Ls,W,Ds,N,Ps,_,Ol=`The data utilised in this tutorial is sourced from Hugging Face datasets, specifically the
<a href="https://huggingface.co/datasets/MongoDB/embedded_movies" rel="nofollow">MongoDB/embedded_movies dataset</a>.`,Os,q,Ks,v,Kl="The operations within the following code snippet below focus on enforcing data integrity and quality.",sl,X,se="<li>The first process ensures that each data point’s <code>fullplot</code> attribute is not empty, as this is the primary data we utilise in the embedding process.</li> <li>The second step also ensures we remove the <code>plot_embedding</code> attribute from all data points as this will be replaced by new embeddings created with a different embedding model, the <code>gte-large</code>.</li>",ll,$,el,F,al,x,tl,H,le="Here, you need to make a decision: do you want Elasticsearch to vectorise your data and queries, or do you want to do it yourself?",nl,Y,ee="Setting <code>USE_ELASTICSEARCH_VECTORISATION</code> to <code>True</code> will make the rest of this notebook set up and use ES-hosted-vectorisation for your data and your querying, but <strong>BE AWARE</strong> that this requires your ES deployment to have at least 1 ML node (I would recommend setting autoscaling to true on your Cloud deployment in case the model you choose is too big).",Ml,z,ae="If <code>USE_ELASTICSEARCH_VECTORISATION</code> is <code>False</code>, this notebook will set up and use the provided model “locally” for data and query vectorisation.",il,L,te='Here, I’ve picked the <a href="https://huggingface.co/thenlper/gte-small" rel="nofollow">thenlper/gte-small</a> model for really no other reason than it was used in another cookbook, and it worked well enough for me. Please feel free to try others if you’d like - the only important thing is that you update the <code>EMBEDDING_DIMENSIONS</code> according to the model.',pl,D,ne="<strong>Note</strong>: if you change these values, you’ll likely need to re-run the notebook from this step.",ol,P,jl,O,yl,K,Me='This step loads and deploys the Hugging Face model into Elasticsearch using <a href="https://eland.readthedocs.io/en/v8.12.1/" rel="nofollow">Eland</a>, if <code>USE_ELASTICSEARCH_VECTORISATION</code> is <code>True</code>. This allows Elasticsearch to vectorise your queries, and data in later steps.',cl,ss,Ul,ls,ie="This step adds functions for creating embeddings for text locally, and enriches the dataset with embeddings, so that the data can be ingested into Elasticsearch as vectors. Does not run if <code>USE_ELASTICSEARCH_VECTORISATION</code> is True.",rl,es,hl,as,Jl,ts,pe="At this point, we create an index in Elasticsearch with the right index mappings to handle vector searches.",Tl,ns,oe='Go here to read more about <a href="https://www.elastic.co/what-is/vector-search" rel="nofollow">Elasticsearch vector capabilities</a>.',ml,Ms,dl,is,je=`Creating index movies
`,ul,ps,ye="Ingesting data into a Elasticsearch is best done in batches. Luckily <code>helpers</code> offers an easy way to do this.",wl,os,Cl,js,ce=`batch: start [0], end [100]
batch: start [100], end [200]
batch: start [200], end [300]
batch: start [300], end [400]
batch: start [400], end [500]
batch: start [500], end [600]
batch: start [600], end [700]
batch: start [700], end [800]
batch: start [800], end [900]
batch: start [900], end [1000]
batch: start [1000], end [1100]
batch: start [1100], end [1200]
batch: start [1200], end [1300]
batch: start [1300], end [1400]
batch: start [1400], end [1452]
Data ingestion into Elasticsearch complete!
`,Il,ys,gl,cs,Ue="The following step implements a function that returns a vector search result.",bl,Us,re=`If <code>USE_ELASTICSEARCH_VECTORISATION</code> is true, the text query is sent directly to
ES where the uploaded model will be used to vectorise it first before doing a vector search. If <code>USE_ELASTICSEARCH_VECTORISATION</code> is false, then we do the
vectorising locally before sending a query with the vectorised form of the query.`,Al,rs,fl,hs,El,Js,Bl,Ts,he=`Query: What is the best romantic movie to watch and why?
Continue to answer the query by using these Search Results:
Title: Shut Up and Kiss Me!, Plot: Ryan and Pete are 27-year old best friends in Miami, born on the same day and each searching for the perfect woman. Ryan is a rookie stockbroker living with his psychic Mom. Pete is a slick surfer dude yet to find commitment. Each meets the women of their dreams on the same day. Ryan knocks heads in an elevator with the gorgeous Jessica, passing out before getting her number. Pete falls for the insatiable Tiara, but Tiara's uncle is mob boss Vincent Bublione, charged with her protection. This high-energy romantic comedy asks to what extent will you go for true love?
Title: Titanic, Plot: The plot focuses on the romances of two couples upon the doomed ship's maiden voyage. Isabella Paradine (Catherine Zeta-Jones) is a wealthy woman mourning the loss of her aunt, who reignites a romance with former flame Wynn Park (Peter Gallagher). Meanwhile, a charming ne'er-do-well named Jamie Perse (Mike Doyle) steals a ticket for the ship, and falls for a sweet innocent Irish girl on board. But their romance is threatened by the villainous Simon Doonan (Tim Curry), who has discovered about the ticket and makes Jamie his unwilling accomplice, as well as having sinister plans for the girl.
Title: Dark Blue World, Plot: March 15, 1939: Germany invades Czechoslovakia. Czech and Slovak pilots flee to England, joining the RAF. After the war, back home, they are put in labor camps, suspected of anti-Communist ideas. This film cuts between a post-war camp where Franta is a prisoner and England during the war, where Franta is like a big brother to Karel, a very young pilot. On maneuvers, Karel crash lands by the rural home of Susan, an English woman whose husband is MIA. She spends one night with Karel, and he thinks he's found the love of his life. It's complicated by Susan's attraction to Franta. How will the three handle innocence, Eros, friendship, and the heat of battle? When war ends, what then?
Title: Dark Blue World, Plot: March 15, 1939: Germany invades Czechoslovakia. Czech and Slovak pilots flee to England, joining the RAF. After the war, back home, they are put in labor camps, suspected of anti-Communist ideas. This film cuts between a post-war camp where Franta is a prisoner and England during the war, where Franta is like a big brother to Karel, a very young pilot. On maneuvers, Karel crash lands by the rural home of Susan, an English woman whose husband is MIA. She spends one night with Karel, and he thinks he's found the love of his life. It's complicated by Susan's attraction to Franta. How will the three handle innocence, Eros, friendship, and the heat of battle? When war ends, what then?
Title: No Good Deed, Plot: About a police detective, Jack, who, while doing a friend a favor and searching for a runaway teenager on Turk Street, stumbles upon a bizarre band of criminals about to pull off a bank robbery. Jack finds himself being held hostage while the criminals decide what to do with him, and the leader's beautiful girlfriend, Erin, is left alone to watch Jack. Erin, who we discover is a master manipulator of the men in the gang, reveals another side to Jack - a melancholy romantic who could have been a classical cellist. She finds Jack's captivity an irresistible turn-on and he can't figure out if she's for real, or manipulating him, too. Before the gang returns, Jack and Erin's connection intensifies and who ends up with the money is anyone's guess.
.
`,Zl,ms,Je='Load our LLM (here we use <a href="https://huggingface.co/google/gemma-2b-it" rel="nofollow">google/gemma-2b-lt</a>)',Vl,ds,Rl,us,Te="Define a method that fetches formatted results from a vectorised search in ES, then feed it to the LLM to get our results.",Gl,ws,Sl,Cs,me=`Query: What's a romantic movie that I can watch with my wife?
Continue to answer the query by using these Search Results:
Title: King Solomon's Mines, Plot: Guide Allan Quatermain helps a young lady (Beth) find her lost husband somewhere in Africa. It's a spectacular adventure story with romance, because while they fight with wild animals and cannibals, they fall in love. Will they find the lost husband and finish the nice connection?
Title: Shut Up and Kiss Me!, Plot: Ryan and Pete are 27-year old best friends in Miami, born on the same day and each searching for the perfect woman. Ryan is a rookie stockbroker living with his psychic Mom. Pete is a slick surfer dude yet to find commitment. Each meets the women of their dreams on the same day. Ryan knocks heads in an elevator with the gorgeous Jessica, passing out before getting her number. Pete falls for the insatiable Tiara, but Tiara's uncle is mob boss Vincent Bublione, charged with her protection. This high-energy romantic comedy asks to what extent will you go for true love?
Title: Titanic, Plot: The plot focuses on the romances of two couples upon the doomed ship's maiden voyage. Isabella Paradine (Catherine Zeta-Jones) is a wealthy woman mourning the loss of her aunt, who reignites a romance with former flame Wynn Park (Peter Gallagher). Meanwhile, a charming ne'er-do-well named Jamie Perse (Mike Doyle) steals a ticket for the ship, and falls for a sweet innocent Irish girl on board. But their romance is threatened by the villainous Simon Doonan (Tim Curry), who has discovered about the ticket and makes Jamie his unwilling accomplice, as well as having sinister plans for the girl.
Title: Fortress, Plot: A futuristic prison movie. Protagonist and wife are nabbed at a future US emigration point with an illegal baby during population control. The resulting prison experience is the subject of the movie. The prison is a futuristic one run by a private corporation bent on mind control in various ways.
Title: Varalaaru, Plot: Relationships become entangled in an emotional web.
.

Which movie would you recommend for a romantic evening with your wife?

From the provided titles, the movie that would be recommended for a romantic evening with your wife is **King Solomon's Mines**. It's a romantic adventure story with romance, and it's a great choice for a date night.
`,kl,Is,Ql,gs,de="This notebook was adapted from",Wl,bs,ue='<li><a href="https://huggingface.co/learn/cookbook/rag_with_hugging_face_gemma_mongodb" rel="nofollow">MongoDB’s RAG cookbook</a></li> <li>OpenAI’s <a href="https://github.com/openai/openai-cookbook/blob/main/examples/vector_databases/elasticsearch/elasticsearch-retrieval-augmented-generation.ipynb" rel="nofollow">ES RAG cookbok</a></li> <li>Elasticsearch-labs’ <a href="https://github.com/elastic/elasticsearch-labs/blob/main/notebooks/integrations/hugging-face/loading-model-from-hugging-face.ipynb" rel="nofollow">loading-model-fromhugging-face cookbook</a></li>',Nl,As,_l,Es,ql;return d=new Ze({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/rag_with_hugging_face_gemma_elasticsearch.ipynb"}]}}),u=new Be({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new J({props:{title:"Building A RAG System with Gemma, Elasticsearch and Hugging Face Models",local:"building-a-rag-system-with-gemma-elasticsearch-and-hugging-face-models",headingTag:"h1"}}),b=new J({props:{title:"Step 1: Installing Libraries",local:"step-1-installing-libraries",headingTag:"h2"}}),A=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjBlbGFzdGljc2VhcmNoJTIwc2VudGVuY2VfdHJhbnNmb3JtZXJzJTIwdHJhbnNmb3JtZXJzJTIwZWxhbmQlM0QlM0Q4LjEyLjElMjAlMjMlMjBhY2NlbGVyYXRlJTIwJTIzJTIwdW5jb21tZW50JTIwaWYlMjB1c2luZyUyMEdQVSUwQSFwaXAlMjBpbnN0YWxsJTIwZGF0YXNldHMlM0QlM0QyLjE5LjIlMjAlMjMlMjBSZW1vdmUlMjB2ZXJzaW9uJTIwbG9jayUyMGlmJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRnB1bGwlMkY2OTc4JTIwaGFzJTIwYmVlbiUyMHJlbGVhc2Vk",highlighted:`!pip install elasticsearch sentence_transformers transformers eland==<span class="hljs-number">8.12</span><span class="hljs-number">.1</span> <span class="hljs-comment"># accelerate # uncomment if using GPU</span>
!pip install datasets==<span class="hljs-number">2.19</span><span class="hljs-number">.2</span> <span class="hljs-comment"># Remove version lock if https://github.com/huggingface/datasets/pull/6978 has been released</span>`,wrap:!1}}),f=new J({props:{title:"Step 2: Set up",local:"step-2-set-up",headingTag:"h2"}}),E=new J({props:{title:"Hugging Face",local:"hugging-face",headingTag:"h3"}}),Z=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),V=new J({props:{title:"Elasticsearch deployment",local:"elasticsearch-deployment",headingTag:"h4"}}),k=new h({props:{code:"ZnJvbSUyMGdvb2dsZS5jb2xhYiUyMGltcG9ydCUyMHVzZXJkYXRhJTBBJTBBJTIzJTIwaHR0cHMlM0ElMkYlMkZ3d3cuZWxhc3RpYy5jbyUyRnNlYXJjaC1sYWJzJTJGdHV0b3JpYWxzJTJGaW5zdGFsbC1lbGFzdGljc2VhcmNoJTJGZWxhc3RpYy1jbG91ZCUyM2ZpbmRpbmcteW91ci1jbG91ZC1pZCUwQUNMT1VEX0lEJTIwJTNEJTIwdXNlcmRhdGEuZ2V0KCUyMkNMT1VEX0lEJTIyKSUyMCUyMyUyMG9yJTIwJTIyJTNDWU9VUiUyMENMT1VEX0lEJTNFJTIyJTBBJTBBJTIzJTIwaHR0cHMlM0ElMkYlMkZ3d3cuZWxhc3RpYy5jbyUyRnNlYXJjaC1sYWJzJTJGdHV0b3JpYWxzJTJGaW5zdGFsbC1lbGFzdGljc2VhcmNoJTJGZWxhc3RpYy1jbG91ZCUyM2NyZWF0aW5nLWFuLWFwaS1rZXklMEFFTEFTVElDX0FQSV9LRVklMjAlM0QlMjB1c2VyZGF0YS5nZXQoJTIyRUxBU1RJQ19ERVBMX0FQSV9LRVklMjIpJTIwJTIwJTIzJTIwb3IlMjAlMjIlM0NZT1VSJTIwQVBJJTIwS0VZJTNFJTIy",highlighted:`<span class="hljs-keyword">from</span> google.colab <span class="hljs-keyword">import</span> userdata

<span class="hljs-comment"># https://www.elastic.co/search-labs/tutorials/install-elasticsearch/elastic-cloud#finding-your-cloud-id</span>
CLOUD_ID = userdata.get(<span class="hljs-string">&quot;CLOUD_ID&quot;</span>) <span class="hljs-comment"># or &quot;&lt;YOUR CLOUD_ID&gt;&quot;</span>

<span class="hljs-comment"># https://www.elastic.co/search-labs/tutorials/install-elasticsearch/elastic-cloud#creating-an-api-key</span>
ELASTIC_API_KEY = userdata.get(<span class="hljs-string">&quot;ELASTIC_DEPL_API_KEY&quot;</span>)  <span class="hljs-comment"># or &quot;&lt;YOUR API KEY&gt;&quot;</span>`,wrap:!1}}),W=new h({props:{code:"ZnJvbSUyMGVsYXN0aWNzZWFyY2glMjBpbXBvcnQlMjBFbGFzdGljc2VhcmNoJTJDJTIwaGVscGVycyUwQSUwQSUyMyUyMENyZWF0ZSUyMHRoZSUyMGNsaWVudCUyMGluc3RhbmNlJTBBY2xpZW50JTIwJTNEJTIwRWxhc3RpY3NlYXJjaChjbG91ZF9pZCUzRENMT1VEX0lEJTJDJTIwYXBpX2tleSUzREVMQVNUSUNfQVBJX0tFWSklMEElMEElMjMlMjBTdWNjZXNzZnVsJTIwcmVzcG9uc2UhJTBBY2xpZW50LmluZm8oKQ==",highlighted:`<span class="hljs-keyword">from</span> elasticsearch <span class="hljs-keyword">import</span> Elasticsearch, helpers

<span class="hljs-comment"># Create the client instance</span>
client = Elasticsearch(cloud_id=CLOUD_ID, api_key=ELASTIC_API_KEY)

<span class="hljs-comment"># Successful response!</span>
client.info()`,wrap:!1}}),N=new J({props:{title:"Step 3: Data sourcing and preparation",local:"step-3-data-sourcing-and-preparation",headingTag:"h2"}}),q=new h({props:{code:"JTIzJTIwTG9hZCUyMERhdGFzZXQlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEElMjMlMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZNb25nb0RCJTJGZW1iZWRkZWRfbW92aWVzJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJNb25nb0RCJTJGZW1iZWRkZWRfbW92aWVzJTIyKSUwQSUwQWRhdGFzZXQ=",highlighted:`<span class="hljs-comment"># Load Dataset</span>
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># https://huggingface.co/datasets/MongoDB/embedded_movies</span>
dataset = load_dataset(<span class="hljs-string">&quot;MongoDB/embedded_movies&quot;</span>)

dataset`,wrap:!1}}),$=new h({props:{code:"JTIzJTIwRGF0YSUyMFByZXBhcmF0aW9uJTBBJTBBJTIzJTIwUmVtb3ZlJTIwZGF0YSUyMHBvaW50JTIwd2hlcmUlMjBwbG90JTIwY29sb3VtbiUyMGlzJTIwbWlzc2luZyUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmZpbHRlcihsYW1iZGElMjB4JTNBJTIweCU1QiUyMmZ1bGxwbG90JTIyJTVEJTIwaXMlMjBub3QlMjBOb25lKSUwQSUwQWlmJTIwJTIycGxvdF9lbWJlZGRpbmclMjIlMjBpbiUyMHN1bShkYXRhc2V0LmNvbHVtbl9uYW1lcy52YWx1ZXMoKSUyQyUyMCU1QiU1RCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBSZW1vdmUlMjB0aGUlMjBwbG90X2VtYmVkZGluZyUyMGZyb20lMjBlYWNoJTIwZGF0YSUyMHBvaW50JTIwaW4lMjB0aGUlMjBkYXRhc2V0JTIwYXMlMjB3ZSUyMGFyZSUyMGdvaW5nJTIwdG8lMjBjcmVhdGUlMjBuZXclMjBlbWJlZGRpbmdzJTIwd2l0aCUyMGFuJTIwb3BlbiUyMHNvdXJjZSUyMGVtYmVkZGluZyUyMG1vZGVsJTIwZnJvbSUyMEh1Z2dpbmclMjBGYWNlJTBBJTIwJTIwJTIwJTIwZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQucmVtb3ZlX2NvbHVtbnMoJTIycGxvdF9lbWJlZGRpbmclMjIpJTBBJTBBZGF0YXNldCU1QiUyMnRyYWluJTIyJTVE",highlighted:`<span class="hljs-comment"># Data Preparation</span>

<span class="hljs-comment"># Remove data point where plot coloumn is missing</span>
dataset = dataset.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;fullplot&quot;</span>] <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>)

<span class="hljs-keyword">if</span> <span class="hljs-string">&quot;plot_embedding&quot;</span> <span class="hljs-keyword">in</span> <span class="hljs-built_in">sum</span>(dataset.column_names.values(), []):
    <span class="hljs-comment"># Remove the plot_embedding from each data point in the dataset as we are going to create new embeddings with an open source embedding model from Hugging Face</span>
    dataset = dataset.remove_columns(<span class="hljs-string">&quot;plot_embedding&quot;</span>)

dataset[<span class="hljs-string">&quot;train&quot;</span>]`,wrap:!1}}),F=new J({props:{title:"Step 4: Load Elasticsearch with vectorised data",local:"step-4-load-elasticsearch-with-vectorised-data",headingTag:"h2"}}),x=new J({props:{title:"Choose data and query vectorisation options",local:"choose-data-and-query-vectorisation-options",headingTag:"h3"}}),P=new h({props:{code:"VVNFX0VMQVNUSUNTRUFSQ0hfVkVDVE9SSVNBVElPTiUyMCUzRCUyMFRydWUlMEElMEFFTUJFRERJTkdfTU9ERUxfSUQlMjAlM0QlMjAlMjJ0aGVubHBlciUyRmd0ZS1zbWFsbCUyMiUwQSUyMyUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZ0aGVubHBlciUyRmd0ZS1zbWFsbCdzJTIwcGFnZSUyMHNob3dzJTIwdGhlJTIwZGltZW5zaW9ucyUyMG9mJTIwdGhlJTIwbW9kZWwlMEElMjMlMjBJZiUyMHlvdSUyMHVzZSUyMHRoZSUyMCU2MGd0ZS1iYXNlJTYwJTIwb3IlMjAlNjBndGUtbGFyZ2UlNjAlMjBlbWJlZGRpbmclMjBtb2RlbHMlMkMlMjB0aGUlMjBudW1EaW1lbnNpb24lMEElMjMlMjB2YWx1ZSUyMGluJTIwdGhlJTIwdmVjdG9yJTIwc2VhcmNoJTIwaW5kZXglMjBtdXN0JTIwYmUlMjBzZXQlMjB0byUyMDc2OCUyMGFuZCUyMDEwMjQlMkMlMjByZXNwZWN0aXZlbHkuJTBBRU1CRURESU5HX0RJTUVOU0lPTlMlMjAlM0QlMjAzODQ=",highlighted:`USE_ELASTICSEARCH_VECTORISATION = <span class="hljs-literal">True</span>

EMBEDDING_MODEL_ID = <span class="hljs-string">&quot;thenlper/gte-small&quot;</span>
<span class="hljs-comment"># https://huggingface.co/thenlper/gte-small&#x27;s page shows the dimensions of the model</span>
<span class="hljs-comment"># If you use the \`gte-base\` or \`gte-large\` embedding models, the numDimension</span>
<span class="hljs-comment"># value in the vector search index must be set to 768 and 1024, respectively.</span>
EMBEDDING_DIMENSIONS = <span class="hljs-number">384</span>`,wrap:!1}}),O=new J({props:{title:"Load Hugging Face model into Elasticsearch if needed",local:"load-hugging-face-model-into-elasticsearch-if-needed",headingTag:"h3"}}),ss=new h({props:{code:"aW1wb3J0JTIwbG9jYWxlJTBBbG9jYWxlLmdldHByZWZlcnJlZGVuY29kaW5nJTIwJTNEJTIwbGFtYmRhJTNBJTIwJTIyVVRGLTglMjIlMEEhKGlmJTIwJTVCJTIwJTIyVHJ1ZSUyMiUyMCUzRCUzRCUyMCUyNFVTRV9FTEFTVElDU0VBUkNIX1ZFQ1RPUklTQVRJT04lMjAlNUQlM0IlMjB0aGVuJTIwJTVDJTBBJTIwJTIwZWxhbmRfaW1wb3J0X2h1Yl9tb2RlbCUyMC0tY2xvdWQtaWQlMjAlMjRDTE9VRF9JRCUyMC0taHViLW1vZGVsLWlkJTIwJTI0RU1CRURESU5HX01PREVMX0lEJTIwLS10YXNrLXR5cGUlMjB0ZXh0X2VtYmVkZGluZyUyMC0tZXMtYXBpLWtleSUyMCUyNEVMQVNUSUNfQVBJX0tFWSUyMC0tc3RhcnQlMjAtLWNsZWFyLXByZXZpb3VzJTNCJTIwJTVDJTBBZmkp",highlighted:`<span class="hljs-keyword">import</span> locale
locale.getpreferredencoding = <span class="hljs-keyword">lambda</span>: <span class="hljs-string">&quot;UTF-8&quot;</span>
!(<span class="hljs-keyword">if</span> [ <span class="hljs-string">&quot;True&quot;</span> == $USE_ELASTICSEARCH_VECTORISATION ]; then \\
  eland_import_hub_model --cloud-<span class="hljs-built_in">id</span> $CLOUD_ID --hub-model-<span class="hljs-built_in">id</span> $EMBEDDING_MODEL_ID --task-<span class="hljs-built_in">type</span> text_embedding --es-api-key $ELASTIC_API_KEY --start --clear-previous; \\
fi)`,wrap:!1}}),es=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> SentenceTransformer

<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> USE_ELASTICSEARCH_VECTORISATION:
    embedding_model = SentenceTransformer(EMBEDDING_MODEL_ID)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_embedding</span>(<span class="hljs-params">text: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">list</span>[<span class="hljs-built_in">float</span>]:
    <span class="hljs-keyword">if</span> USE_ELASTICSEARCH_VECTORISATION:
        <span class="hljs-keyword">raise</span> Exception(
            <span class="hljs-string">f&quot;Disabled when USE_ELASTICSEARCH_VECTORISATION is [<span class="hljs-subst">{USE_ELASTICSEARCH_VECTORISATION}</span>]&quot;</span>
        )
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> text.strip():
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Attempted to get embedding for empty text.&quot;</span>)
            <span class="hljs-keyword">return</span> []

        embedding = embedding_model.encode(text)
        <span class="hljs-keyword">return</span> embedding.tolist()


<span class="hljs-keyword">def</span> <span class="hljs-title function_">add_fullplot_embedding</span>(<span class="hljs-params">x</span>):
    <span class="hljs-keyword">if</span> USE_ELASTICSEARCH_VECTORISATION:
        <span class="hljs-keyword">raise</span> Exception(
            <span class="hljs-string">f&quot;Disabled when USE_ELASTICSEARCH_VECTORISATION is [<span class="hljs-subst">{USE_ELASTICSEARCH_VECTORISATION}</span>]&quot;</span>
        )
    <span class="hljs-keyword">else</span>:
        full_plots = x[<span class="hljs-string">&quot;fullplot&quot;</span>]
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;embedding&quot;</span>: [get_embedding(full_plot) <span class="hljs-keyword">for</span> full_plot <span class="hljs-keyword">in</span> full_plots]}


<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> USE_ELASTICSEARCH_VECTORISATION:
    dataset = dataset.<span class="hljs-built_in">map</span>(add_fullplot_embedding, batched=<span class="hljs-literal">True</span>)
    dataset[<span class="hljs-string">&quot;train&quot;</span>]`,wrap:!1}}),as=new J({props:{title:"Step 5: Create a Search Index with vector search mappings.",local:"step-5-create-a-search-index-with-vector-search-mappings",headingTag:"h2"}}),Ms=new h({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Needs to match the id returned from Eland</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># in general for Hugging Face models, you just replace the forward slash with</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># double underscore</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = EMBEDDING_MODEL_ID.replace(<span class="hljs-string">&quot;/&quot;</span>, <span class="hljs-string">&quot;__&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>index_name = <span class="hljs-string">&quot;movies&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>index_mapping = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;fullplot&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>},
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;plot&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>},
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;title&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>},
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define index mapping</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> USE_ELASTICSEARCH_VECTORISATION:
<span class="hljs-meta">... </span>    index_mapping[<span class="hljs-string">&quot;properties&quot;</span>][<span class="hljs-string">&quot;embedding&quot;</span>] = {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;is_truncated&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;boolean&quot;</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;model_id&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;fields&quot;</span>: {<span class="hljs-string">&quot;keyword&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;keyword&quot;</span>, <span class="hljs-string">&quot;ignore_above&quot;</span>: <span class="hljs-number">256</span>}},
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;predicted_value&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;dense_vector&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;dims&quot;</span>: EMBEDDING_DIMENSIONS,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;index&quot;</span>: <span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;similarity&quot;</span>: <span class="hljs-string">&quot;cosine&quot;</span>,
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        }
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>    index_mapping[<span class="hljs-string">&quot;properties&quot;</span>][<span class="hljs-string">&quot;embedding&quot;</span>] = {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;dense_vector&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;dims&quot;</span>: EMBEDDING_DIMENSIONS,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;index&quot;</span>: <span class="hljs-string">&quot;true&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;similarity&quot;</span>: <span class="hljs-string">&quot;cosine&quot;</span>,
<span class="hljs-meta">... </span>    }

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># flag to check if index has to be deleted before creating</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>should_delete_index = <span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># check if we want to delete index before creating the index</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> should_delete_index:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> client.indices.exists(index=index_name):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Deleting existing %s&quot;</span> % index_name)
<span class="hljs-meta">... </span>        client.indices.delete(index=index_name, ignore=[<span class="hljs-number">400</span>, <span class="hljs-number">404</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Creating index %s&quot;</span> % index_name)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># ingest pipeline definition</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> USE_ELASTICSEARCH_VECTORISATION:
<span class="hljs-meta">... </span>    pipeline_id = <span class="hljs-string">&quot;vectorize_fullplots&quot;</span>

<span class="hljs-meta">... </span>    client.ingest.put_pipeline(
<span class="hljs-meta">... </span>        <span class="hljs-built_in">id</span>=pipeline_id,
<span class="hljs-meta">... </span>        processors=[
<span class="hljs-meta">... </span>            {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;inference&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;model_id&quot;</span>: model_id,
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;target_field&quot;</span>: <span class="hljs-string">&quot;embedding&quot;</span>,
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;field_map&quot;</span>: {<span class="hljs-string">&quot;fullplot&quot;</span>: <span class="hljs-string">&quot;text_field&quot;</span>},
<span class="hljs-meta">... </span>                }
<span class="hljs-meta">... </span>            }
<span class="hljs-meta">... </span>        ],
<span class="hljs-meta">... </span>    )

<span class="hljs-meta">... </span>    index_settings = {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;index&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;default_pipeline&quot;</span>: pipeline_id,
<span class="hljs-meta">... </span>        }
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>    index_settings = {}

<span class="hljs-meta">&gt;&gt;&gt; </span>client.options(ignore_status=[<span class="hljs-number">400</span>, <span class="hljs-number">404</span>]).indices.create(
<span class="hljs-meta">... </span>    index=index_name, mappings=index_mapping, settings=index_settings
<span class="hljs-meta">... </span>)`,wrap:!1}}),os=new h({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> elasticsearch.helpers <span class="hljs-keyword">import</span> BulkIndexError

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">batch_to_bulk_actions</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> record <span class="hljs-keyword">in</span> batch:
<span class="hljs-meta">... </span>        action = {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;_index&quot;</span>: <span class="hljs-string">&quot;movies&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;_source&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;title&quot;</span>: record[<span class="hljs-string">&quot;title&quot;</span>],
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;fullplot&quot;</span>: record[<span class="hljs-string">&quot;fullplot&quot;</span>],
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;plot&quot;</span>: record[<span class="hljs-string">&quot;plot&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        }
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> USE_ELASTICSEARCH_VECTORISATION:
<span class="hljs-meta">... </span>            action[<span class="hljs-string">&quot;_source&quot;</span>][<span class="hljs-string">&quot;embedding&quot;</span>] = record[<span class="hljs-string">&quot;embedding&quot;</span>]
<span class="hljs-meta">... </span>        <span class="hljs-keyword">yield</span> action


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">bulk_index</span>(<span class="hljs-params">ds</span>):
<span class="hljs-meta">... </span>    start = <span class="hljs-number">0</span>
<span class="hljs-meta">... </span>    end = <span class="hljs-built_in">len</span>(ds)
<span class="hljs-meta">... </span>    batch_size = <span class="hljs-number">100</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> USE_ELASTICSEARCH_VECTORISATION:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># If using auto-embedding, bulk requests can take a lot longer,</span>
<span class="hljs-meta">... </span>        <span class="hljs-comment"># so pass a longer request_timeout here (defaults to 10s), otherwise</span>
<span class="hljs-meta">... </span>        <span class="hljs-comment"># we could get Connection timeouts</span>
<span class="hljs-meta">... </span>        batch_client = client.options(request_timeout=<span class="hljs-number">600</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>        batch_client = client
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> batch_start <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(start, end, batch_size):
<span class="hljs-meta">... </span>        batch_end = <span class="hljs-built_in">min</span>(batch_start + batch_size, end)
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;batch: start [<span class="hljs-subst">{batch_start}</span>], end [<span class="hljs-subst">{batch_end}</span>]&quot;</span>)
<span class="hljs-meta">... </span>        batch = ds.select(<span class="hljs-built_in">range</span>(batch_start, batch_end))
<span class="hljs-meta">... </span>        actions = batch_to_bulk_actions(batch)
<span class="hljs-meta">... </span>        helpers.bulk(batch_client, actions)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>    bulk_index(dataset[<span class="hljs-string">&quot;train&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">except</span> BulkIndexError <span class="hljs-keyword">as</span> e:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{e.errors}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Data ingestion into Elasticsearch complete!&quot;</span>)`,wrap:!1}}),ys=new J({props:{title:"Step 6: Perform Vector Search on User Queries",local:"step-6-perform-vector-search-on-user-queries",headingTag:"h2"}}),rs=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">vector_search</span>(<span class="hljs-params">plot_query</span>):
    <span class="hljs-keyword">if</span> USE_ELASTICSEARCH_VECTORISATION:
        knn = {
            <span class="hljs-string">&quot;field&quot;</span>: <span class="hljs-string">&quot;embedding.predicted_value&quot;</span>,
            <span class="hljs-string">&quot;k&quot;</span>: <span class="hljs-number">10</span>,
            <span class="hljs-string">&quot;query_vector_builder&quot;</span>: {
                <span class="hljs-string">&quot;text_embedding&quot;</span>: {
                    <span class="hljs-string">&quot;model_id&quot;</span>: model_id,
                    <span class="hljs-string">&quot;model_text&quot;</span>: plot_query,
                }
            },
            <span class="hljs-string">&quot;num_candidates&quot;</span>: <span class="hljs-number">150</span>,
        }
    <span class="hljs-keyword">else</span>:
        question_embedding = get_embedding(plot_query)
        knn = {
            <span class="hljs-string">&quot;field&quot;</span>: <span class="hljs-string">&quot;embedding&quot;</span>,
            <span class="hljs-string">&quot;query_vector&quot;</span>: question_embedding,
            <span class="hljs-string">&quot;k&quot;</span>: <span class="hljs-number">10</span>,
            <span class="hljs-string">&quot;num_candidates&quot;</span>: <span class="hljs-number">150</span>,
        }

    response = client.search(index=<span class="hljs-string">&quot;movies&quot;</span>, knn=knn, size=<span class="hljs-number">5</span>)
    results = []
    <span class="hljs-keyword">for</span> hit <span class="hljs-keyword">in</span> response[<span class="hljs-string">&quot;hits&quot;</span>][<span class="hljs-string">&quot;hits&quot;</span>]:
        <span class="hljs-built_in">id</span> = hit[<span class="hljs-string">&quot;_id&quot;</span>]
        score = hit[<span class="hljs-string">&quot;_score&quot;</span>]
        title = hit[<span class="hljs-string">&quot;_source&quot;</span>][<span class="hljs-string">&quot;title&quot;</span>]
        plot = hit[<span class="hljs-string">&quot;_source&quot;</span>][<span class="hljs-string">&quot;plot&quot;</span>]
        fullplot = hit[<span class="hljs-string">&quot;_source&quot;</span>][<span class="hljs-string">&quot;fullplot&quot;</span>]
        result = {
            <span class="hljs-string">&quot;id&quot;</span>: <span class="hljs-built_in">id</span>,
            <span class="hljs-string">&quot;_score&quot;</span>: score,
            <span class="hljs-string">&quot;title&quot;</span>: title,
            <span class="hljs-string">&quot;plot&quot;</span>: plot,
            <span class="hljs-string">&quot;fullplot&quot;</span>: fullplot,
        }
        results.append(result)
    <span class="hljs-keyword">return</span> results

<span class="hljs-keyword">def</span> <span class="hljs-title function_">pretty_search</span>(<span class="hljs-params">query</span>):

    get_knowledge = vector_search(query)

    search_result = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">for</span> result <span class="hljs-keyword">in</span> get_knowledge:
        search_result += <span class="hljs-string">f&quot;Title: <span class="hljs-subst">{result.get(<span class="hljs-string">&#x27;title&#x27;</span>, <span class="hljs-string">&#x27;N/A&#x27;</span>)}</span>, Plot: <span class="hljs-subst">{result.get(<span class="hljs-string">&#x27;fullplot&#x27;</span>, <span class="hljs-string">&#x27;N/A&#x27;</span>)}</span>\\n&quot;</span>

    <span class="hljs-keyword">return</span> search_result`,wrap:!1}}),hs=new J({props:{title:"Step 7: Handling user queries and loading Gemma",local:"step-7-handling-user-queries-and-loading-gemma",headingTag:"h2"}}),Js=new h({props:{code:"JTIzJTIwQ29uZHVjdCUyMHF1ZXJ5JTIwd2l0aCUyMHJldHJpdmFsJTIwb2YlMjBzb3VyY2VzJTJDJTIwY29tYmluaW5nJTIwcmVzdWx0cyUyMGludG8lMjBzb21ldGhpbmclMjB0aGF0JTBBJTIzJTIwd2UlMjBjYW4lMjBmZWVkJTIwdG8lMjBHZW1tYSUwQWRlZiUyMGNvbWJpbmVkX3F1ZXJ5KHF1ZXJ5KSUzQSUwQSUyMCUyMCUyMCUyMHNvdXJjZV9pbmZvcm1hdGlvbiUyMCUzRCUyMHByZXR0eV9zZWFyY2gocXVlcnkpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZiUyMlF1ZXJ5JTNBJTIwJTdCcXVlcnklN0QlNUNuQ29udGludWUlMjB0byUyMGFuc3dlciUyMHRoZSUyMHF1ZXJ5JTIwYnklMjB1c2luZyUyMHRoZXNlJTIwU2VhcmNoJTIwUmVzdWx0cyUzQSU1Q24lN0Jzb3VyY2VfaW5mb3JtYXRpb24lN0QuJTIyJTBBJTBBJTBBcXVlcnklMjAlM0QlMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBiZXN0JTIwcm9tYW50aWMlMjBtb3ZpZSUyMHRvJTIwd2F0Y2glMjBhbmQlMjB3aHklM0YlMjIlMEFjb21iaW5lZF9yZXN1bHRzJTIwJTNEJTIwY29tYmluZWRfcXVlcnkocXVlcnkpJTBBJTBBcHJpbnQoY29tYmluZWRfcmVzdWx0cyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Conduct query with retrival of sources, combining results into something that</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># we can feed to Gemma</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">combined_query</span>(<span class="hljs-params">query</span>):
<span class="hljs-meta">... </span>    source_information = pretty_search(query)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Query: <span class="hljs-subst">{query}</span>\\nContinue to answer the query by using these Search Results:\\n<span class="hljs-subst">{source_information}</span>.&quot;</span>


<span class="hljs-meta">&gt;&gt;&gt; </span>query = <span class="hljs-string">&quot;What is the best romantic movie to watch and why?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>combined_results = combined_query(query)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(combined_results)`,wrap:!1}}),ds=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiLWl0JTIyKSUwQSUyMyUyMENQVSUyMEVuYWJsZWQlMjB1bmNvbW1lbnQlMjBiZWxvdyUyMCVGMCU5RiU5MSU4NyVGMCU5RiU4RiVCRCUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiLWl0JTIyKSUwQSUyMyUyMEdQVSUyMEVuYWJsZWQlMjB1c2UlMjBiZWxvdyUyMCVGMCU5RiU5MSU4NyVGMCU5RiU4RiVCRCUwQSUyMyUyMG1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiLWl0JTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b-it&quot;</span>)
<span class="hljs-comment"># CPU Enabled uncomment below 👇🏽</span>
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b-it&quot;</span>)
<span class="hljs-comment"># GPU Enabled use below 👇🏽</span>
<span class="hljs-comment"># model = AutoModelForCausalLM.from_pretrained(&quot;google/gemma-2b-it&quot;, device_map=&quot;auto&quot;)</span>`,wrap:!1}}),ws=new h({props:{code:"ZGVmJTIwcmFnX3F1ZXJ5KHF1ZXJ5KSUzQSUwQSUyMCUyMCUyMCUyMGNvbWJpbmVkX2luZm9ybWF0aW9uJTIwJTNEJTIwY29tYmluZWRfcXVlcnkocXVlcnkpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwTW92aW5nJTIwdGVuc29ycyUyMHRvJTIwR1BVJTBBJTIwJTIwJTIwJTIwaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKGNvbWJpbmVkX2luZm9ybWF0aW9uJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMjAlMjMlMjAudG8oJTIyY3VkYSUyMiklMjAlMjMlMjBBZGQlMjBpZiUyMHVzaW5nJTIwR1BVJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0X2lkcyUyQyUyMG1heF9uZXdfdG9rZW5zJTNENzAwKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRva2VuaXplci5kZWNvZGUocmVzcG9uc2UlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBJTBBJTBBcHJpbnQocmFnX3F1ZXJ5KCUyMldoYXQncyUyMGElMjByb21hbnRpYyUyMG1vdmllJTIwdGhhdCUyMEklMjBjYW4lMjB3YXRjaCUyMHdpdGglMjBteSUyMHdpZmUlM0YlMjIpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">rag_query</span>(<span class="hljs-params">query</span>):
<span class="hljs-meta">... </span>    combined_information = combined_query(query)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Moving tensors to GPU</span>
<span class="hljs-meta">... </span>    input_ids = tokenizer(combined_information, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>) <span class="hljs-comment"># .to(&quot;cuda&quot;) # Add if using GPU</span>
<span class="hljs-meta">... </span>    response = model.generate(**input_ids, max_new_tokens=<span class="hljs-number">700</span>)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokenizer.decode(response[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(rag_query(<span class="hljs-string">&quot;What&#x27;s a romantic movie that I can watch with my wife?&quot;</span>))`,wrap:!1}}),Is=new J({props:{title:"Credits",local:"credits",headingTag:"h2"}}),As=new Ve({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/rag_with_hugging_face_gemma_elasticsearch.md"}}),{c(){T=M("meta"),Bs=t(),fs=M("p"),Zs=t(),o(d.$$.fragment),Vs=t(),o(u.$$.fragment),Rs=t(),o(w.$$.fragment),Gs=t(),C=M("p"),C.innerHTML=$l,Ss=t(),I=M("p"),I.textContent=Fl,ks=t(),g=M("p"),g.innerHTML=xl,Qs=t(),m=M("blockquote"),m.innerHTML=Hl,Ws=t(),o(b.$$.fragment),Ns=t(),o(A.$$.fragment),_s=t(),o(f.$$.fragment),qs=t(),o(E.$$.fragment),vs=t(),B=M("p"),B.textContent=Yl,Xs=t(),o(Z.$$.fragment),$s=t(),o(V.$$.fragment),Fs=t(),R=M("p"),R.innerHTML=zl,xs=t(),G=M("p"),G.innerHTML=Ll,Hs=t(),S=M("p"),S.innerHTML=Dl,Ys=t(),o(k.$$.fragment),zs=t(),Q=M("p"),Q.textContent=Pl,Ls=t(),o(W.$$.fragment),Ds=t(),o(N.$$.fragment),Ps=t(),_=M("p"),_.innerHTML=Ol,Os=t(),o(q.$$.fragment),Ks=t(),v=M("p"),v.textContent=Kl,sl=t(),X=M("ol"),X.innerHTML=se,ll=t(),o($.$$.fragment),el=t(),o(F.$$.fragment),al=t(),o(x.$$.fragment),tl=t(),H=M("p"),H.textContent=le,nl=t(),Y=M("p"),Y.innerHTML=ee,Ml=t(),z=M("p"),z.innerHTML=ae,il=t(),L=M("p"),L.innerHTML=te,pl=t(),D=M("p"),D.innerHTML=ne,ol=t(),o(P.$$.fragment),jl=t(),o(O.$$.fragment),yl=t(),K=M("p"),K.innerHTML=Me,cl=t(),o(ss.$$.fragment),Ul=t(),ls=M("p"),ls.innerHTML=ie,rl=t(),o(es.$$.fragment),hl=t(),o(as.$$.fragment),Jl=t(),ts=M("p"),ts.textContent=pe,Tl=t(),ns=M("p"),ns.innerHTML=oe,ml=t(),o(Ms.$$.fragment),dl=t(),is=M("pre"),is.textContent=je,ul=t(),ps=M("p"),ps.innerHTML=ye,wl=t(),o(os.$$.fragment),Cl=t(),js=M("pre"),js.textContent=ce,Il=t(),o(ys.$$.fragment),gl=t(),cs=M("p"),cs.textContent=Ue,bl=t(),Us=M("p"),Us.innerHTML=re,Al=t(),o(rs.$$.fragment),fl=t(),o(hs.$$.fragment),El=t(),o(Js.$$.fragment),Bl=t(),Ts=M("pre"),Ts.textContent=he,Zl=t(),ms=M("p"),ms.innerHTML=Je,Vl=t(),o(ds.$$.fragment),Rl=t(),us=M("p"),us.textContent=Te,Gl=t(),o(ws.$$.fragment),Sl=t(),Cs=M("pre"),Cs.textContent=me,kl=t(),o(Is.$$.fragment),Ql=t(),gs=M("p"),gs.textContent=de,Wl=t(),bs=M("ul"),bs.innerHTML=ue,Nl=t(),o(As.$$.fragment),_l=t(),Es=M("p"),this.h()},l(s){const l=fe("svelte-u9bgzb",document.head);T=i(l,"META",{name:!0,content:!0}),l.forEach(e),Bs=n(s),fs=i(s,"P",{}),we(fs).forEach(e),Zs=n(s),j(d.$$.fragment,s),Vs=n(s),j(u.$$.fragment,s),Rs=n(s),j(w.$$.fragment,s),Gs=n(s),C=i(s,"P",{"data-svelte-h":!0}),p(C)!=="svelte-u85jis"&&(C.innerHTML=$l),Ss=n(s),I=i(s,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1gzfghe"&&(I.textContent=Fl),ks=n(s),g=i(s,"P",{"data-svelte-h":!0}),p(g)!=="svelte-19dgrn4"&&(g.innerHTML=xl),Qs=n(s),m=i(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(m)!=="svelte-vh0o6l"&&(m.innerHTML=Hl),Ws=n(s),j(b.$$.fragment,s),Ns=n(s),j(A.$$.fragment,s),_s=n(s),j(f.$$.fragment,s),qs=n(s),j(E.$$.fragment,s),vs=n(s),B=i(s,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1oc48ie"&&(B.textContent=Yl),Xs=n(s),j(Z.$$.fragment,s),$s=n(s),j(V.$$.fragment,s),Fs=n(s),R=i(s,"P",{"data-svelte-h":!0}),p(R)!=="svelte-90yfqq"&&(R.innerHTML=zl),xs=n(s),G=i(s,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1wxepjk"&&(G.innerHTML=Ll),Hs=n(s),S=i(s,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1ixe20f"&&(S.innerHTML=Dl),Ys=n(s),j(k.$$.fragment,s),zs=n(s),Q=i(s,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1tero47"&&(Q.textContent=Pl),Ls=n(s),j(W.$$.fragment,s),Ds=n(s),j(N.$$.fragment,s),Ps=n(s),_=i(s,"P",{"data-svelte-h":!0}),p(_)!=="svelte-nhsnwd"&&(_.innerHTML=Ol),Os=n(s),j(q.$$.fragment,s),Ks=n(s),v=i(s,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1c0ejge"&&(v.textContent=Kl),sl=n(s),X=i(s,"OL",{"data-svelte-h":!0}),p(X)!=="svelte-zu3w9u"&&(X.innerHTML=se),ll=n(s),j($.$$.fragment,s),el=n(s),j(F.$$.fragment,s),al=n(s),j(x.$$.fragment,s),tl=n(s),H=i(s,"P",{"data-svelte-h":!0}),p(H)!=="svelte-18mg2q3"&&(H.textContent=le),nl=n(s),Y=i(s,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-v671s0"&&(Y.innerHTML=ee),Ml=n(s),z=i(s,"P",{"data-svelte-h":!0}),p(z)!=="svelte-2l59xo"&&(z.innerHTML=ae),il=n(s),L=i(s,"P",{"data-svelte-h":!0}),p(L)!=="svelte-ukp447"&&(L.innerHTML=te),pl=n(s),D=i(s,"P",{"data-svelte-h":!0}),p(D)!=="svelte-cmmakk"&&(D.innerHTML=ne),ol=n(s),j(P.$$.fragment,s),jl=n(s),j(O.$$.fragment,s),yl=n(s),K=i(s,"P",{"data-svelte-h":!0}),p(K)!=="svelte-ggbryw"&&(K.innerHTML=Me),cl=n(s),j(ss.$$.fragment,s),Ul=n(s),ls=i(s,"P",{"data-svelte-h":!0}),p(ls)!=="svelte-nj7dnk"&&(ls.innerHTML=ie),rl=n(s),j(es.$$.fragment,s),hl=n(s),j(as.$$.fragment,s),Jl=n(s),ts=i(s,"P",{"data-svelte-h":!0}),p(ts)!=="svelte-1eiizls"&&(ts.textContent=pe),Tl=n(s),ns=i(s,"P",{"data-svelte-h":!0}),p(ns)!=="svelte-x5ec9q"&&(ns.innerHTML=oe),ml=n(s),j(Ms.$$.fragment,s),dl=n(s),is=i(s,"PRE",{"data-svelte-h":!0}),p(is)!=="svelte-dtnw1a"&&(is.textContent=je),ul=n(s),ps=i(s,"P",{"data-svelte-h":!0}),p(ps)!=="svelte-16lq0w1"&&(ps.innerHTML=ye),wl=n(s),j(os.$$.fragment,s),Cl=n(s),js=i(s,"PRE",{"data-svelte-h":!0}),p(js)!=="svelte-rnckh4"&&(js.textContent=ce),Il=n(s),j(ys.$$.fragment,s),gl=n(s),cs=i(s,"P",{"data-svelte-h":!0}),p(cs)!=="svelte-mn3hdu"&&(cs.textContent=Ue),bl=n(s),Us=i(s,"P",{"data-svelte-h":!0}),p(Us)!=="svelte-1x79kzs"&&(Us.innerHTML=re),Al=n(s),j(rs.$$.fragment,s),fl=n(s),j(hs.$$.fragment,s),El=n(s),j(Js.$$.fragment,s),Bl=n(s),Ts=i(s,"PRE",{"data-svelte-h":!0}),p(Ts)!=="svelte-rtrdii"&&(Ts.textContent=he),Zl=n(s),ms=i(s,"P",{"data-svelte-h":!0}),p(ms)!=="svelte-rrls6r"&&(ms.innerHTML=Je),Vl=n(s),j(ds.$$.fragment,s),Rl=n(s),us=i(s,"P",{"data-svelte-h":!0}),p(us)!=="svelte-mfigla"&&(us.textContent=Te),Gl=n(s),j(ws.$$.fragment,s),Sl=n(s),Cs=i(s,"PRE",{"data-svelte-h":!0}),p(Cs)!=="svelte-1d2dt07"&&(Cs.textContent=me),kl=n(s),j(Is.$$.fragment,s),Ql=n(s),gs=i(s,"P",{"data-svelte-h":!0}),p(gs)!=="svelte-rwjj8d"&&(gs.textContent=de),Wl=n(s),bs=i(s,"UL",{"data-svelte-h":!0}),p(bs)!=="svelte-1fh1ozm"&&(bs.innerHTML=ue),Nl=n(s),j(As.$$.fragment,s),_l=n(s),Es=i(s,"P",{}),we(Es).forEach(e),this.h()},h(){vl(T,"name","hf:doc:metadata"),vl(T,"content",Ge),vl(m,"class","tip")},m(s,l){Ee(document.head,T),a(s,Bs,l),a(s,fs,l),a(s,Zs,l),y(d,s,l),a(s,Vs,l),y(u,s,l),a(s,Rs,l),y(w,s,l),a(s,Gs,l),a(s,C,l),a(s,Ss,l),a(s,I,l),a(s,ks,l),a(s,g,l),a(s,Qs,l),a(s,m,l),a(s,Ws,l),y(b,s,l),a(s,Ns,l),y(A,s,l),a(s,_s,l),y(f,s,l),a(s,qs,l),y(E,s,l),a(s,vs,l),a(s,B,l),a(s,Xs,l),y(Z,s,l),a(s,$s,l),y(V,s,l),a(s,Fs,l),a(s,R,l),a(s,xs,l),a(s,G,l),a(s,Hs,l),a(s,S,l),a(s,Ys,l),y(k,s,l),a(s,zs,l),a(s,Q,l),a(s,Ls,l),y(W,s,l),a(s,Ds,l),y(N,s,l),a(s,Ps,l),a(s,_,l),a(s,Os,l),y(q,s,l),a(s,Ks,l),a(s,v,l),a(s,sl,l),a(s,X,l),a(s,ll,l),y($,s,l),a(s,el,l),y(F,s,l),a(s,al,l),y(x,s,l),a(s,tl,l),a(s,H,l),a(s,nl,l),a(s,Y,l),a(s,Ml,l),a(s,z,l),a(s,il,l),a(s,L,l),a(s,pl,l),a(s,D,l),a(s,ol,l),y(P,s,l),a(s,jl,l),y(O,s,l),a(s,yl,l),a(s,K,l),a(s,cl,l),y(ss,s,l),a(s,Ul,l),a(s,ls,l),a(s,rl,l),y(es,s,l),a(s,hl,l),y(as,s,l),a(s,Jl,l),a(s,ts,l),a(s,Tl,l),a(s,ns,l),a(s,ml,l),y(Ms,s,l),a(s,dl,l),a(s,is,l),a(s,ul,l),a(s,ps,l),a(s,wl,l),y(os,s,l),a(s,Cl,l),a(s,js,l),a(s,Il,l),y(ys,s,l),a(s,gl,l),a(s,cs,l),a(s,bl,l),a(s,Us,l),a(s,Al,l),y(rs,s,l),a(s,fl,l),y(hs,s,l),a(s,El,l),y(Js,s,l),a(s,Bl,l),a(s,Ts,l),a(s,Zl,l),a(s,ms,l),a(s,Vl,l),y(ds,s,l),a(s,Rl,l),a(s,us,l),a(s,Gl,l),y(ws,s,l),a(s,Sl,l),a(s,Cs,l),a(s,kl,l),y(Is,s,l),a(s,Ql,l),a(s,gs,l),a(s,Wl,l),a(s,bs,l),a(s,Nl,l),y(As,s,l),a(s,_l,l),a(s,Es,l),ql=!0},p:Ie,i(s){ql||(c(d.$$.fragment,s),c(u.$$.fragment,s),c(w.$$.fragment,s),c(b.$$.fragment,s),c(A.$$.fragment,s),c(f.$$.fragment,s),c(E.$$.fragment,s),c(Z.$$.fragment,s),c(V.$$.fragment,s),c(k.$$.fragment,s),c(W.$$.fragment,s),c(N.$$.fragment,s),c(q.$$.fragment,s),c($.$$.fragment,s),c(F.$$.fragment,s),c(x.$$.fragment,s),c(P.$$.fragment,s),c(O.$$.fragment,s),c(ss.$$.fragment,s),c(es.$$.fragment,s),c(as.$$.fragment,s),c(Ms.$$.fragment,s),c(os.$$.fragment,s),c(ys.$$.fragment,s),c(rs.$$.fragment,s),c(hs.$$.fragment,s),c(Js.$$.fragment,s),c(ds.$$.fragment,s),c(ws.$$.fragment,s),c(Is.$$.fragment,s),c(As.$$.fragment,s),ql=!0)},o(s){U(d.$$.fragment,s),U(u.$$.fragment,s),U(w.$$.fragment,s),U(b.$$.fragment,s),U(A.$$.fragment,s),U(f.$$.fragment,s),U(E.$$.fragment,s),U(Z.$$.fragment,s),U(V.$$.fragment,s),U(k.$$.fragment,s),U(W.$$.fragment,s),U(N.$$.fragment,s),U(q.$$.fragment,s),U($.$$.fragment,s),U(F.$$.fragment,s),U(x.$$.fragment,s),U(P.$$.fragment,s),U(O.$$.fragment,s),U(ss.$$.fragment,s),U(es.$$.fragment,s),U(as.$$.fragment,s),U(Ms.$$.fragment,s),U(os.$$.fragment,s),U(ys.$$.fragment,s),U(rs.$$.fragment,s),U(hs.$$.fragment,s),U(Js.$$.fragment,s),U(ds.$$.fragment,s),U(ws.$$.fragment,s),U(Is.$$.fragment,s),U(As.$$.fragment,s),ql=!1},d(s){s&&(e(Bs),e(fs),e(Zs),e(Vs),e(Rs),e(Gs),e(C),e(Ss),e(I),e(ks),e(g),e(Qs),e(m),e(Ws),e(Ns),e(_s),e(qs),e(vs),e(B),e(Xs),e($s),e(Fs),e(R),e(xs),e(G),e(Hs),e(S),e(Ys),e(zs),e(Q),e(Ls),e(Ds),e(Ps),e(_),e(Os),e(Ks),e(v),e(sl),e(X),e(ll),e(el),e(al),e(tl),e(H),e(nl),e(Y),e(Ml),e(z),e(il),e(L),e(pl),e(D),e(ol),e(jl),e(yl),e(K),e(cl),e(Ul),e(ls),e(rl),e(hl),e(Jl),e(ts),e(Tl),e(ns),e(ml),e(dl),e(is),e(ul),e(ps),e(wl),e(Cl),e(js),e(Il),e(gl),e(cs),e(bl),e(Us),e(Al),e(fl),e(El),e(Bl),e(Ts),e(Zl),e(ms),e(Vl),e(Rl),e(us),e(Gl),e(Sl),e(Cs),e(kl),e(Ql),e(gs),e(Wl),e(bs),e(Nl),e(_l),e(Es)),e(T),r(d,s),r(u,s),r(w,s),r(b,s),r(A,s),r(f,s),r(E,s),r(Z,s),r(V,s),r(k,s),r(W,s),r(N,s),r(q,s),r($,s),r(F,s),r(x,s),r(P,s),r(O,s),r(ss,s),r(es,s),r(as,s),r(Ms,s),r(os,s),r(ys,s),r(rs,s),r(hs,s),r(Js,s),r(ds,s),r(ws,s),r(Is,s),r(As,s)}}}const Ge='{"title":"Building A RAG System with Gemma, Elasticsearch and Hugging Face Models","local":"building-a-rag-system-with-gemma-elasticsearch-and-hugging-face-models","sections":[{"title":"Step 1: Installing Libraries","local":"step-1-installing-libraries","sections":[],"depth":2},{"title":"Step 2: Set up","local":"step-2-set-up","sections":[{"title":"Hugging Face","local":"hugging-face","sections":[{"title":"Elasticsearch deployment","local":"elasticsearch-deployment","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Step 3: Data sourcing and preparation","local":"step-3-data-sourcing-and-preparation","sections":[],"depth":2},{"title":"Step 4: Load Elasticsearch with vectorised data","local":"step-4-load-elasticsearch-with-vectorised-data","sections":[{"title":"Choose data and query vectorisation options","local":"choose-data-and-query-vectorisation-options","sections":[],"depth":3},{"title":"Load Hugging Face model into Elasticsearch if needed","local":"load-hugging-face-model-into-elasticsearch-if-needed","sections":[],"depth":3}],"depth":2},{"title":"Step 5: Create a Search Index with vector search mappings.","local":"step-5-create-a-search-index-with-vector-search-mappings","sections":[],"depth":2},{"title":"Step 6: Perform Vector Search on User Queries","local":"step-6-perform-vector-search-on-user-queries","sections":[],"depth":2},{"title":"Step 7: Handling user queries and loading Gemma","local":"step-7-handling-user-queries-and-loading-gemma","sections":[],"depth":2},{"title":"Credits","local":"credits","sections":[],"depth":2}],"depth":1}';function Se(Xl){return ge(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qe extends be{constructor(T){super(),Ae(this,T,Se,Re,Ce,{})}}export{qe as component};
