import{s as Jl,n as gl,o as vl}from"../chunks/scheduler.1f027d5a.js";import{S as $l,i as jl,e as i,s,c as p,h as Ul,a as o,d as l,b as a,f as wl,g as m,j as r,k as Tl,l as xl,m as n,n as d,t as u,o as h,p as c}from"../chunks/index.5cb6ce42.js";import{C as Bl}from"../chunks/CopyLLMTxtMenu.f7108191.js";import{D as Cl,C as b}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as ve,E as Gl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function Il(Ht){let f,Ue,$e,xe,y,Be,M,Ce,w,Ge,T,Rt='<em>Authored by: <a href="https://github.com/MKhalusova" rel="nofollow">Maria Khalusova</a></em>',Ie,J,Wt='This notebook demonstrates how you can quickly build a RAG (Retrieval Augmented Generation) for a project’s GitHub issues using <a href="https://huggingface.co/HuggingFaceH4/zephyr-7b-beta" rel="nofollow"><code>HuggingFaceH4/zephyr-7b-beta</code></a> model, and LangChain.',ke,g,Xt="<strong>What is RAG?</strong>",Ze,v,Vt="RAG is a popular approach to address the issue of a powerful LLM not being aware of specific content due to said content not being in its training data, or hallucinating even when it has seen it before. Such specific content may be proprietary, sensitive, or, as in this example, recent and updated often.",_e,$,Ft="If your data is static and doesn’t change regularly, you may consider fine-tuning a large model. In many cases, however, fine-tuning can be costly, and, when done repeatedly (e.g. to address data drift), leads to “model shift”. This is when the model’s behavior changes in ways that are not desirable.",He,j,Nt="<strong>RAG (Retrieval Augmented Generation)</strong> does not require model fine-tuning. Instead, RAG works by providing an LLM with additional context that is retrieved from relevant data so that it can generate a better-informed response.",Re,U,Lt="Here’s a quick illustration:",We,x,Et='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/rag-diagram.png" alt="RAG diagram"/>',Xe,B,St="<li><p>The external data is converted into embedding vectors with a separate embeddings model, and the vectors are kept in a database. Embeddings models are typically small, so updating the embedding vectors on a regular basis is faster, cheaper, and easier than fine-tuning a model.</p></li> <li><p>At the same time, the fact that fine-tuning is not required gives you the freedom to swap your LLM for a more powerful one when it becomes available, or switch to a smaller distilled version, should you need faster inference.</p></li>",Ve,C,zt="Let’s illustrate building a RAG using an open-source LLM, embeddings model, and LangChain.",Fe,G,At="First, install the required dependencies:",Ne,I,Le,k,Ee,Z,Se,_,ze,H,qt='In this example, we’ll load all of the issues (both open and closed) from <a href="https://github.com/huggingface/peft" rel="nofollow">PEFT library’s repo</a>.',Ae,R,Qt='First, you need to acquire a <a href="https://github.com/settings/tokens?type=beta" rel="nofollow">GitHub personal access token</a> to access the GitHub API.',qe,W,Qe,X,Yt='Next, we’ll load all of the issues in the <a href="https://github.com/huggingface/peft" rel="nofollow">huggingface/peft</a> repo:',Ye,V,Pt="<li>By default, pull requests are considered issues as well, here we chose to exclude them from data with by setting <code>include_prs=False</code></li> <li>Setting <code>state = &quot;all&quot;</code> means we will load both open and closed issues.</li>",Pe,F,De,N,Dt="The content of individual GitHub issues may be longer than what an embedding model can take as input. If we want to embed all of the available content, we need to chunk the documents into appropriately sized pieces.",Ke,L,Kt='The most common and straightforward approach to chunking is to define a fixed size of chunks and whether there should be any overlap between them. Keeping some overlap between chunks allows us to preserve some semantic context between the chunks. The recommended splitter for generic text is the <a href="https://python.langchain.com/docs/modules/data_connection/document_transformers/recursive_text_splitter" rel="nofollow">RecursiveCharacterTextSplitter</a>, and that’s what we’ll use here.',Oe,E,et,S,tt,z,Ot="Now that the docs are all of the appropriate size, we can create a database with their embeddings.",lt,A,el='To create document chunk embeddings we’ll use the <code>HuggingFaceEmbeddings</code> and the <a href="https://huggingface.co/BAAI/bge-base-en-v1.5" rel="nofollow"><code>BAAI/bge-base-en-v1.5</code></a> embeddings model. There are many other embeddings models available on the Hub, and you can keep an eye on the best performing ones by checking the <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">Massive Text Embedding Benchmark (MTEB) Leaderboard</a>.',nt,q,tl="To create the vector database, we’ll use <code>FAISS</code>, a library developed by Facebook AI. This library offers efficient similarity search and clustering of dense vectors, which is what we need here. FAISS is currently one of the most used libraries for NN search in massive datasets.",st,Q,ll="We’ll access both the embeddings model and FAISS via LangChain API.",at,Y,it,P,nl="We need a way to return(retrieve) the documents given an unstructured query. For that, we’ll use the <code>as_retriever</code> method using the <code>db</code> as a backbone:",ot,D,sl="<li><code>search_type=&quot;similarity&quot;</code> means we want to perform similarity search between the query and documents</li> <li><code>search_kwargs={&#39;k&#39;: 4}</code> instructs the retriever to return top 4 results.</li>",rt,K,pt,O,al="The vector database and retriever are now set up, next we need to set up the next piece of the chain - the model.",mt,ee,dt,te,il='For this example, we chose <a href="https://huggingface.co/HuggingFaceH4/zephyr-7b-beta" rel="nofollow"><code>HuggingFaceH4/zephyr-7b-beta</code></a>, a small but powerful model.',ut,le,ol='With many models being released every week, you may want to substitute this model to the latest and greatest. The best way to keep track of open source LLMs is to check the <a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">Open-source LLM leaderboard</a>.',ht,ne,rl="To make inference faster, we will load the quantized version of the model:",ct,se,bt,ae,ft,ie,pl="Finally, we have all the pieces we need to set up the LLM chain.",yt,oe,ml="First, create a text_generation pipeline using the loaded model and its tokenizer.",Mt,re,dl="Next, create a prompt template - this should follow the format of the model, so if you substitute the model checkpoint, make sure to use the appropriate formatting.",wt,pe,Tt,me,ul="Note: <em>You can also use <code>tokenizer.apply_chat_template</code> to convert a list of messages (as dicts: <code>{&#39;role&#39;: &#39;user&#39;, &#39;content&#39;: &#39;(...)&#39;}</code>) into a string with the appropriate chat format.</em>",Jt,de,hl="Finally, we need to combine the <code>llm_chain</code> with the retriever to create a RAG chain. We pass the original question through to the final generation step, as well as the retrieved context docs:",gt,ue,vt,he,$t,ce,cl="Let’s see the difference RAG makes in generating answers to the library-specific questions.",jt,be,Ut,fe,bl="First, let’s see what kind of answer we can get with just the model itself, no context added:",xt,ye,Bt,Me,fl=`As you can see, the model interpreted the question as one about physical computer adapters, while in the context of PEFT, “adapters” refer to LoRA adapters.
Let’s see if adding context from GitHub issues helps the model give a more relevant answer:`,Ct,we,Gt,Te,yl="As we can see, the added context, really helps the exact same model, provide a much more relevant and informed answer to the library-specific question.",It,Je,Ml="Notably, combining multiple adapters for inference has been added to the library, and one can find this information in the documentation, so for the next iteration of this RAG it may be worth including documentation embeddings.",kt,ge,Zt,je,_t;return y=new Cl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/rag_zephyr_langchain.ipynb"}]}}),M=new Bl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new ve({props:{title:"Simple RAG for GitHub issues using Hugging Face Zephyr and LangChain",local:"simple-rag-for-github-issues-using-hugging-face-zephyr-and-langchain",headingTag:"h1"}}),I=new b({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHRvcmNoJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUyMGJpdHNhbmRieXRlcyUyMHRyYW5zZm9ybWVycyUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGZhaXNzLWdwdQ==",highlighted:"!pip install -q torch transformers accelerate bitsandbytes transformers sentence-transformers faiss-gpu",wrap:!1}}),k=new b({props:{code:"JTIzJTIwSWYlMjBydW5uaW5nJTIwaW4lMjBHb29nbGUlMjBDb2xhYiUyQyUyMHlvdSUyMG1heSUyMG5lZWQlMjB0byUyMHJ1biUyMHRoaXMlMjBjZWxsJTIwdG8lMjBtYWtlJTIwc3VyZSUyMHlvdSdyZSUyMHVzaW5nJTIwVVRGLTglMjBsb2NhbGUlMjB0byUyMGluc3RhbGwlMjBMYW5nQ2hhaW4lMEFpbXBvcnQlMjBsb2NhbGUlMEFsb2NhbGUuZ2V0cHJlZmVycmVkZW5jb2RpbmclMjAlM0QlMjBsYW1iZGElM0ElMjAlMjJVVEYtOCUyMg==",highlighted:`<span class="hljs-comment"># If running in Google Colab, you may need to run this cell to make sure you&#x27;re using UTF-8 locale to install LangChain</span>
<span class="hljs-keyword">import</span> locale
locale.getpreferredencoding = <span class="hljs-keyword">lambda</span>: <span class="hljs-string">&quot;UTF-8&quot;</span>`,wrap:!1}}),Z=new b({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGxhbmdjaGFpbiUyMGxhbmdjaGFpbi1jb21tdW5pdHk=",highlighted:"!pip install -q langchain langchain-community",wrap:!1}}),_=new ve({props:{title:"Prepare the data",local:"prepare-the-data",headingTag:"h2"}}),W=new b({props:{code:"ZnJvbSUyMGdldHBhc3MlMjBpbXBvcnQlMjBnZXRwYXNzJTBBQUNDRVNTX1RPS0VOJTIwJTNEJTIwZ2V0cGFzcyglMjJZT1VSX0dJVEhVQl9QRVJTT05BTF9UT0tFTiUyMik=",highlighted:`<span class="hljs-keyword">from</span> getpass <span class="hljs-keyword">import</span> getpass
ACCESS_TOKEN = getpass(<span class="hljs-string">&quot;YOUR_GITHUB_PERSONAL_TOKEN&quot;</span>)`,wrap:!1}}),F=new b({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5kb2N1bWVudF9sb2FkZXJzJTIwaW1wb3J0JTIwR2l0SHViSXNzdWVzTG9hZGVyJTBBJTBBbG9hZGVyJTIwJTNEJTIwR2l0SHViSXNzdWVzTG9hZGVyKCUwQSUyMCUyMCUyMCUyMHJlcG8lM0QlMjJodWdnaW5nZmFjZSUyRnBlZnQlMjIlMkMlMEElMjAlMjAlMjAlMjBhY2Nlc3NfdG9rZW4lM0RBQ0NFU1NfVE9LRU4lMkMlMEElMjAlMjAlMjAlMjBpbmNsdWRlX3BycyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwc3RhdGUlM0QlMjJhbGwlMjIlMEEpJTBBJTBBZG9jcyUyMCUzRCUyMGxvYWRlci5sb2FkKCk=",highlighted:`<span class="hljs-keyword">from</span> langchain.document_loaders <span class="hljs-keyword">import</span> GitHubIssuesLoader

loader = GitHubIssuesLoader(
    repo=<span class="hljs-string">&quot;huggingface/peft&quot;</span>,
    access_token=ACCESS_TOKEN,
    include_prs=<span class="hljs-literal">False</span>,
    state=<span class="hljs-string">&quot;all&quot;</span>
)

docs = loader.load()`,wrap:!1}}),E=new b({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi50ZXh0X3NwbGl0dGVyJTIwaW1wb3J0JTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyJTBBJTBBc3BsaXR0ZXIlMjAlM0QlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoY2h1bmtfc2l6ZSUzRDUxMiUyQyUyMGNodW5rX292ZXJsYXAlM0QzMCklMEElMEFjaHVua2VkX2RvY3MlMjAlM0QlMjBzcGxpdHRlci5zcGxpdF9kb2N1bWVudHMoZG9jcyk=",highlighted:`<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter

splitter = RecursiveCharacterTextSplitter(chunk_size=<span class="hljs-number">512</span>, chunk_overlap=<span class="hljs-number">30</span>)

chunked_docs = splitter.split_documents(docs)`,wrap:!1}}),S=new ve({props:{title:"Create the embeddings + retriever",local:"create-the-embeddings--retriever",headingTag:"h2"}}),Y=new b({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi52ZWN0b3JzdG9yZXMlMjBpbXBvcnQlMjBGQUlTUyUwQWZyb20lMjBsYW5nY2hhaW4uZW1iZWRkaW5ncyUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlRW1iZWRkaW5ncyUwQSUwQWRiJTIwJTNEJTIwRkFJU1MuZnJvbV9kb2N1bWVudHMoY2h1bmtlZF9kb2NzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmdzKG1vZGVsX25hbWUlM0QnQkFBSSUyRmJnZS1iYXNlLWVuLXYxLjUnKSk=",highlighted:`<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-keyword">from</span> langchain.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings

db = FAISS.from_documents(chunked_docs,
                          HuggingFaceEmbeddings(model_name=<span class="hljs-string">&#x27;BAAI/bge-base-en-v1.5&#x27;</span>))`,wrap:!1}}),K=new b({props:{code:"cmV0cmlldmVyJTIwJTNEJTIwZGIuYXNfcmV0cmlldmVyKCUwQSUyMCUyMCUyMCUyMHNlYXJjaF90eXBlJTNEJTIyc2ltaWxhcml0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMHNlYXJjaF9rd2FyZ3MlM0QlN0InayclM0ElMjA0JTdEJTBBKQ==",highlighted:`retriever = db.as_retriever(
    search_type=<span class="hljs-string">&quot;similarity&quot;</span>,
    search_kwargs={<span class="hljs-string">&#x27;k&#x27;</span>: <span class="hljs-number">4</span>}
)`,wrap:!1}}),ee=new ve({props:{title:"Load quantized model",local:"load-quantized-model",headingTag:"h2"}}),se=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCdIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGEnJTBBJTBBYm5iX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig

model_name = <span class="hljs-string">&#x27;HuggingFaceH4/zephyr-7b-beta&#x27;</span>

bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.bfloat16
)

model = AutoModelForCausalLM.from_pretrained(model_name, quantization_config=bnb_config)
tokenizer = AutoTokenizer.from_pretrained(model_name)`,wrap:!1}}),ae=new ve({props:{title:"Setup the LLM chain",local:"setup-the-llm-chain",headingTag:"h2"}}),pe=new b({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5sbG1zJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VQaXBlbGluZSUwQWZyb20lMjBsYW5nY2hhaW4ucHJvbXB0cyUyMGltcG9ydCUyMFByb21wdFRlbXBsYXRlJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMGxhbmdjaGFpbl9jb3JlLm91dHB1dF9wYXJzZXJzJTIwaW1wb3J0JTIwU3RyT3V0cHV0UGFyc2VyJTBBJTBBdGV4dF9nZW5lcmF0aW9uX3BpcGVsaW5lJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuMiUyQyUwQSUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXBldGl0aW9uX3BlbmFsdHklM0QxLjElMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fZnVsbF90ZXh0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNENDAwJTJDJTBBKSUwQSUwQWxsbSUyMCUzRCUyMEh1Z2dpbmdGYWNlUGlwZWxpbmUocGlwZWxpbmUlM0R0ZXh0X2dlbmVyYXRpb25fcGlwZWxpbmUpJTBBJTBBcHJvbXB0X3RlbXBsYXRlJTIwJTNEJTIwJTIyJTIyJTIyJTBBJTNDJTdDc3lzdGVtJTdDJTNFJTBBQW5zd2VyJTIwdGhlJTIwcXVlc3Rpb24lMjBiYXNlZCUyMG9uJTIweW91ciUyMGtub3dsZWRnZS4lMjBVc2UlMjB0aGUlMjBmb2xsb3dpbmclMjBjb250ZXh0JTIwdG8lMjBoZWxwJTNBJTBBJTBBJTdCY29udGV4dCU3RCUwQSUwQSUzQyUyRnMlM0UlMEElM0MlN0N1c2VyJTdDJTNFJTBBJTdCcXVlc3Rpb24lN0QlMEElM0MlMkZzJTNFJTBBJTNDJTdDYXNzaXN0YW50JTdDJTNFJTBBJTBBJTIwJTIyJTIyJTIyJTBBJTBBcHJvbXB0JTIwJTNEJTIwUHJvbXB0VGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwaW5wdXRfdmFyaWFibGVzJTNEJTVCJTIyY29udGV4dCUyMiUyQyUyMCUyMnF1ZXN0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdGVtcGxhdGUlM0Rwcm9tcHRfdGVtcGxhdGUlMkMlMEEpJTBBJTBBbGxtX2NoYWluJTIwJTNEJTIwcHJvbXB0JTIwJTdDJTIwbGxtJTIwJTdDJTIwU3RyT3V0cHV0UGFyc2VyKCk=",highlighted:`<span class="hljs-keyword">from</span> langchain.llms <span class="hljs-keyword">import</span> HuggingFacePipeline
<span class="hljs-keyword">from</span> langchain.prompts <span class="hljs-keyword">import</span> PromptTemplate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> langchain_core.output_parsers <span class="hljs-keyword">import</span> StrOutputParser

text_generation_pipeline = pipeline(
    model=model,
    tokenizer=tokenizer,
    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
    temperature=<span class="hljs-number">0.2</span>,
    do_sample=<span class="hljs-literal">True</span>,
    repetition_penalty=<span class="hljs-number">1.1</span>,
    return_full_text=<span class="hljs-literal">True</span>,
    max_new_tokens=<span class="hljs-number">400</span>,
)

llm = HuggingFacePipeline(pipeline=text_generation_pipeline)

prompt_template = <span class="hljs-string">&quot;&quot;&quot;
&lt;|system|&gt;
Answer the question based on your knowledge. Use the following context to help:

{context}

&lt;/s&gt;
&lt;|user|&gt;
{question}
&lt;/s&gt;
&lt;|assistant|&gt;

 &quot;&quot;&quot;</span>

prompt = PromptTemplate(
    input_variables=[<span class="hljs-string">&quot;context&quot;</span>, <span class="hljs-string">&quot;question&quot;</span>],
    template=prompt_template,
)

llm_chain = prompt | llm | StrOutputParser()`,wrap:!1}}),ue=new b({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb3JlLnJ1bm5hYmxlcyUyMGltcG9ydCUyMFJ1bm5hYmxlUGFzc3Rocm91Z2glMEElMEFyZXRyaWV2ZXIlMjAlM0QlMjBkYi5hc19yZXRyaWV2ZXIoKSUwQSUwQXJhZ19jaGFpbiUyMCUzRCUyMCglMEElMjAlN0IlMjJjb250ZXh0JTIyJTNBJTIwcmV0cmlldmVyJTJDJTIwJTIycXVlc3Rpb24lMjIlM0ElMjBSdW5uYWJsZVBhc3N0aHJvdWdoKCklN0QlMEElMjAlMjAlMjAlMjAlN0MlMjBsbG1fY2hhaW4lMEEp",highlighted:`<span class="hljs-keyword">from</span> langchain_core.runnables <span class="hljs-keyword">import</span> RunnablePassthrough

retriever = db.as_retriever()

rag_chain = (
 {<span class="hljs-string">&quot;context&quot;</span>: retriever, <span class="hljs-string">&quot;question&quot;</span>: RunnablePassthrough()}
    | llm_chain
)`,wrap:!1}}),he=new ve({props:{title:"Compare the results",local:"compare-the-results",headingTag:"h2"}}),be=new b({props:{code:"cXVlc3Rpb24lMjAlM0QlMjAlMjJIb3clMjBkbyUyMHlvdSUyMGNvbWJpbmUlMjBtdWx0aXBsZSUyMGFkYXB0ZXJzJTNGJTIy",highlighted:'question = <span class="hljs-string">&quot;How do you combine multiple adapters?&quot;</span>',wrap:!1}}),ye=new b({props:{code:"bGxtX2NoYWluLmludm9rZSglN0IlMjJjb250ZXh0JTIyJTNBJTIyJTIyJTJDJTIwJTIycXVlc3Rpb24lMjIlM0ElMjBxdWVzdGlvbiU3RCk=",highlighted:'llm_chain.invoke({<span class="hljs-string">&quot;context&quot;</span>:<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;question&quot;</span>: question})',wrap:!1}}),we=new b({props:{code:"cmFnX2NoYWluLmludm9rZShxdWVzdGlvbik=",highlighted:"rag_chain.invoke(question)",wrap:!1}}),ge=new Gl({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/rag_zephyr_langchain.md"}}),{c(){f=i("meta"),Ue=s(),$e=i("p"),xe=s(),p(y.$$.fragment),Be=s(),p(M.$$.fragment),Ce=s(),p(w.$$.fragment),Ge=s(),T=i("p"),T.innerHTML=Rt,Ie=s(),J=i("p"),J.innerHTML=Wt,ke=s(),g=i("p"),g.innerHTML=Xt,Ze=s(),v=i("p"),v.textContent=Vt,_e=s(),$=i("p"),$.textContent=Ft,He=s(),j=i("p"),j.innerHTML=Nt,Re=s(),U=i("p"),U.textContent=Lt,We=s(),x=i("p"),x.innerHTML=Et,Xe=s(),B=i("ul"),B.innerHTML=St,Ve=s(),C=i("p"),C.textContent=zt,Fe=s(),G=i("p"),G.textContent=At,Ne=s(),p(I.$$.fragment),Le=s(),p(k.$$.fragment),Ee=s(),p(Z.$$.fragment),Se=s(),p(_.$$.fragment),ze=s(),H=i("p"),H.innerHTML=qt,Ae=s(),R=i("p"),R.innerHTML=Qt,qe=s(),p(W.$$.fragment),Qe=s(),X=i("p"),X.innerHTML=Yt,Ye=s(),V=i("ul"),V.innerHTML=Pt,Pe=s(),p(F.$$.fragment),De=s(),N=i("p"),N.textContent=Dt,Ke=s(),L=i("p"),L.innerHTML=Kt,Oe=s(),p(E.$$.fragment),et=s(),p(S.$$.fragment),tt=s(),z=i("p"),z.textContent=Ot,lt=s(),A=i("p"),A.innerHTML=el,nt=s(),q=i("p"),q.innerHTML=tl,st=s(),Q=i("p"),Q.textContent=ll,at=s(),p(Y.$$.fragment),it=s(),P=i("p"),P.innerHTML=nl,ot=s(),D=i("ul"),D.innerHTML=sl,rt=s(),p(K.$$.fragment),pt=s(),O=i("p"),O.textContent=al,mt=s(),p(ee.$$.fragment),dt=s(),te=i("p"),te.innerHTML=il,ut=s(),le=i("p"),le.innerHTML=ol,ht=s(),ne=i("p"),ne.textContent=rl,ct=s(),p(se.$$.fragment),bt=s(),p(ae.$$.fragment),ft=s(),ie=i("p"),ie.textContent=pl,yt=s(),oe=i("p"),oe.textContent=ml,Mt=s(),re=i("p"),re.textContent=dl,wt=s(),p(pe.$$.fragment),Tt=s(),me=i("p"),me.innerHTML=ul,Jt=s(),de=i("p"),de.innerHTML=hl,gt=s(),p(ue.$$.fragment),vt=s(),p(he.$$.fragment),$t=s(),ce=i("p"),ce.textContent=cl,jt=s(),p(be.$$.fragment),Ut=s(),fe=i("p"),fe.textContent=bl,xt=s(),p(ye.$$.fragment),Bt=s(),Me=i("p"),Me.textContent=fl,Ct=s(),p(we.$$.fragment),Gt=s(),Te=i("p"),Te.textContent=yl,It=s(),Je=i("p"),Je.textContent=Ml,kt=s(),p(ge.$$.fragment),Zt=s(),je=i("p"),this.h()},l(e){const t=Ul("svelte-u9bgzb",document.head);f=o(t,"META",{name:!0,content:!0}),t.forEach(l),Ue=a(e),$e=o(e,"P",{}),wl($e).forEach(l),xe=a(e),m(y.$$.fragment,e),Be=a(e),m(M.$$.fragment,e),Ce=a(e),m(w.$$.fragment,e),Ge=a(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-26mfp8"&&(T.innerHTML=Rt),Ie=a(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1ef5fle"&&(J.innerHTML=Wt),ke=a(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1ty8bu"&&(g.innerHTML=Xt),Ze=a(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-7wteio"&&(v.textContent=Vt),_e=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1x9vu2c"&&($.textContent=Ft),He=a(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-14i5lt5"&&(j.innerHTML=Nt),Re=a(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-5qqm02"&&(U.textContent=Lt),We=a(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1c1z86r"&&(x.innerHTML=Et),Xe=a(e),B=o(e,"UL",{"data-svelte-h":!0}),r(B)!=="svelte-8anxeq"&&(B.innerHTML=St),Ve=a(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-r4q734"&&(C.textContent=zt),Fe=a(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1f3oki6"&&(G.textContent=At),Ne=a(e),m(I.$$.fragment,e),Le=a(e),m(k.$$.fragment,e),Ee=a(e),m(Z.$$.fragment,e),Se=a(e),m(_.$$.fragment,e),ze=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1htvfcb"&&(H.innerHTML=qt),Ae=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1y7zwpt"&&(R.innerHTML=Qt),qe=a(e),m(W.$$.fragment,e),Qe=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1sitgme"&&(X.innerHTML=Yt),Ye=a(e),V=o(e,"UL",{"data-svelte-h":!0}),r(V)!=="svelte-ktvuvk"&&(V.innerHTML=Pt),Pe=a(e),m(F.$$.fragment,e),De=a(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-oungvg"&&(N.textContent=Dt),Ke=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-jsadt6"&&(L.innerHTML=Kt),Oe=a(e),m(E.$$.fragment,e),et=a(e),m(S.$$.fragment,e),tt=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1ng4z3s"&&(z.textContent=Ot),lt=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-z63x34"&&(A.innerHTML=el),nt=a(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1hq28ne"&&(q.innerHTML=tl),st=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1n2sms8"&&(Q.textContent=ll),at=a(e),m(Y.$$.fragment,e),it=a(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-140j4it"&&(P.innerHTML=nl),ot=a(e),D=o(e,"UL",{"data-svelte-h":!0}),r(D)!=="svelte-hejw60"&&(D.innerHTML=sl),rt=a(e),m(K.$$.fragment,e),pt=a(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-4c9ypi"&&(O.textContent=al),mt=a(e),m(ee.$$.fragment,e),dt=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1fynfov"&&(te.innerHTML=il),ut=a(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-gklra8"&&(le.innerHTML=ol),ht=a(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1bs26eu"&&(ne.textContent=rl),ct=a(e),m(se.$$.fragment,e),bt=a(e),m(ae.$$.fragment,e),ft=a(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-dvcewb"&&(ie.textContent=pl),yt=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-8iwm5k"&&(oe.textContent=ml),Mt=a(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-qz9rvk"&&(re.textContent=dl),wt=a(e),m(pe.$$.fragment,e),Tt=a(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-15zr00j"&&(me.innerHTML=ul),Jt=a(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1plvon"&&(de.innerHTML=hl),gt=a(e),m(ue.$$.fragment,e),vt=a(e),m(he.$$.fragment,e),$t=a(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1m90it0"&&(ce.textContent=cl),jt=a(e),m(be.$$.fragment,e),Ut=a(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1m8rs90"&&(fe.textContent=bl),xt=a(e),m(ye.$$.fragment,e),Bt=a(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-10i2mx0"&&(Me.textContent=fl),Ct=a(e),m(we.$$.fragment,e),Gt=a(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1gvzgod"&&(Te.textContent=yl),It=a(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-rlk7jz"&&(Je.textContent=Ml),kt=a(e),m(ge.$$.fragment,e),Zt=a(e),je=o(e,"P",{}),wl(je).forEach(l),this.h()},h(){Tl(f,"name","hf:doc:metadata"),Tl(f,"content",kl)},m(e,t){xl(document.head,f),n(e,Ue,t),n(e,$e,t),n(e,xe,t),d(y,e,t),n(e,Be,t),d(M,e,t),n(e,Ce,t),d(w,e,t),n(e,Ge,t),n(e,T,t),n(e,Ie,t),n(e,J,t),n(e,ke,t),n(e,g,t),n(e,Ze,t),n(e,v,t),n(e,_e,t),n(e,$,t),n(e,He,t),n(e,j,t),n(e,Re,t),n(e,U,t),n(e,We,t),n(e,x,t),n(e,Xe,t),n(e,B,t),n(e,Ve,t),n(e,C,t),n(e,Fe,t),n(e,G,t),n(e,Ne,t),d(I,e,t),n(e,Le,t),d(k,e,t),n(e,Ee,t),d(Z,e,t),n(e,Se,t),d(_,e,t),n(e,ze,t),n(e,H,t),n(e,Ae,t),n(e,R,t),n(e,qe,t),d(W,e,t),n(e,Qe,t),n(e,X,t),n(e,Ye,t),n(e,V,t),n(e,Pe,t),d(F,e,t),n(e,De,t),n(e,N,t),n(e,Ke,t),n(e,L,t),n(e,Oe,t),d(E,e,t),n(e,et,t),d(S,e,t),n(e,tt,t),n(e,z,t),n(e,lt,t),n(e,A,t),n(e,nt,t),n(e,q,t),n(e,st,t),n(e,Q,t),n(e,at,t),d(Y,e,t),n(e,it,t),n(e,P,t),n(e,ot,t),n(e,D,t),n(e,rt,t),d(K,e,t),n(e,pt,t),n(e,O,t),n(e,mt,t),d(ee,e,t),n(e,dt,t),n(e,te,t),n(e,ut,t),n(e,le,t),n(e,ht,t),n(e,ne,t),n(e,ct,t),d(se,e,t),n(e,bt,t),d(ae,e,t),n(e,ft,t),n(e,ie,t),n(e,yt,t),n(e,oe,t),n(e,Mt,t),n(e,re,t),n(e,wt,t),d(pe,e,t),n(e,Tt,t),n(e,me,t),n(e,Jt,t),n(e,de,t),n(e,gt,t),d(ue,e,t),n(e,vt,t),d(he,e,t),n(e,$t,t),n(e,ce,t),n(e,jt,t),d(be,e,t),n(e,Ut,t),n(e,fe,t),n(e,xt,t),d(ye,e,t),n(e,Bt,t),n(e,Me,t),n(e,Ct,t),d(we,e,t),n(e,Gt,t),n(e,Te,t),n(e,It,t),n(e,Je,t),n(e,kt,t),d(ge,e,t),n(e,Zt,t),n(e,je,t),_t=!0},p:gl,i(e){_t||(u(y.$$.fragment,e),u(M.$$.fragment,e),u(w.$$.fragment,e),u(I.$$.fragment,e),u(k.$$.fragment,e),u(Z.$$.fragment,e),u(_.$$.fragment,e),u(W.$$.fragment,e),u(F.$$.fragment,e),u(E.$$.fragment,e),u(S.$$.fragment,e),u(Y.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(se.$$.fragment,e),u(ae.$$.fragment,e),u(pe.$$.fragment,e),u(ue.$$.fragment,e),u(he.$$.fragment,e),u(be.$$.fragment,e),u(ye.$$.fragment,e),u(we.$$.fragment,e),u(ge.$$.fragment,e),_t=!0)},o(e){h(y.$$.fragment,e),h(M.$$.fragment,e),h(w.$$.fragment,e),h(I.$$.fragment,e),h(k.$$.fragment,e),h(Z.$$.fragment,e),h(_.$$.fragment,e),h(W.$$.fragment,e),h(F.$$.fragment,e),h(E.$$.fragment,e),h(S.$$.fragment,e),h(Y.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(se.$$.fragment,e),h(ae.$$.fragment,e),h(pe.$$.fragment,e),h(ue.$$.fragment,e),h(he.$$.fragment,e),h(be.$$.fragment,e),h(ye.$$.fragment,e),h(we.$$.fragment,e),h(ge.$$.fragment,e),_t=!1},d(e){e&&(l(Ue),l($e),l(xe),l(Be),l(Ce),l(Ge),l(T),l(Ie),l(J),l(ke),l(g),l(Ze),l(v),l(_e),l($),l(He),l(j),l(Re),l(U),l(We),l(x),l(Xe),l(B),l(Ve),l(C),l(Fe),l(G),l(Ne),l(Le),l(Ee),l(Se),l(ze),l(H),l(Ae),l(R),l(qe),l(Qe),l(X),l(Ye),l(V),l(Pe),l(De),l(N),l(Ke),l(L),l(Oe),l(et),l(tt),l(z),l(lt),l(A),l(nt),l(q),l(st),l(Q),l(at),l(it),l(P),l(ot),l(D),l(rt),l(pt),l(O),l(mt),l(dt),l(te),l(ut),l(le),l(ht),l(ne),l(ct),l(bt),l(ft),l(ie),l(yt),l(oe),l(Mt),l(re),l(wt),l(Tt),l(me),l(Jt),l(de),l(gt),l(vt),l($t),l(ce),l(jt),l(Ut),l(fe),l(xt),l(Bt),l(Me),l(Ct),l(Gt),l(Te),l(It),l(Je),l(kt),l(Zt),l(je)),l(f),c(y,e),c(M,e),c(w,e),c(I,e),c(k,e),c(Z,e),c(_,e),c(W,e),c(F,e),c(E,e),c(S,e),c(Y,e),c(K,e),c(ee,e),c(se,e),c(ae,e),c(pe,e),c(ue,e),c(he,e),c(be,e),c(ye,e),c(we,e),c(ge,e)}}}const kl='{"title":"Simple RAG for GitHub issues using Hugging Face Zephyr and LangChain","local":"simple-rag-for-github-issues-using-hugging-face-zephyr-and-langchain","sections":[{"title":"Prepare the data","local":"prepare-the-data","sections":[],"depth":2},{"title":"Create the embeddings + retriever","local":"create-the-embeddings--retriever","sections":[],"depth":2},{"title":"Load quantized model","local":"load-quantized-model","sections":[],"depth":2},{"title":"Setup the LLM chain","local":"setup-the-llm-chain","sections":[],"depth":2},{"title":"Compare the results","local":"compare-the-results","sections":[],"depth":2}],"depth":1}';function Zl(Ht){return vl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vl extends $l{constructor(f){super(),jl(this,f,Zl,Il,Jl,{})}}export{Vl as component};
