import{s as rs,n as os,o as ps}from"../chunks/scheduler.1f027d5a.js";import{S as ms,i as hs,e as i,s as n,c as p,h as Ms,a as r,d as l,b as a,f as as,g as m,j as o,k as is,l as cs,m as s,n as h,t as M,o as c,p as d}from"../chunks/index.5cb6ce42.js";import{C as ds}from"../chunks/CopyLLMTxtMenu.f7108191.js";import{D as gs,C as g}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as u,E as us}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function fs(gl){let f,Ae,Ve,Qe,y,Se,w,Ee,b,ze,T,ul='<em>Authored by: <a href="https://github.com/sergiopaniego" rel="nofollow">Sergio Paniego</a></em>',Ye,J,fl="🚨 <strong>WARNING</strong>: This notebook is <strong>resource-intensive</strong> and requires substantial computational power. If you’re running this in <strong>Colab</strong>, it will utilize an <strong>A100 GPU</strong>.",Fe,qe,Pe,j,yl='In this recipe, we’ll guide you through extending the inference time for an <strong>Instruct LLM system</strong> using <strong>test-time compute</strong> to solve more challenging problems, such as <strong>complex math problems</strong>. This approach, inspired by <a href="https://openai.com/index/learning-to-reason-with-llms/" rel="nofollow"><strong>OpenAI o1-o3 models</strong></a>, demonstrates that <strong>longer reasoning time</strong> during inference can enhance model performance.',De,U,wl='This technique builds on experiments shared in <a href="https://huggingface.co/spaces/HuggingFaceH4/blogpost-scaling-test-time-compute" rel="nofollow">this <strong>blog post</strong></a>, which show that smaller models, like the <strong>1B</strong> and <strong>3B Llama Instruct models</strong>, can outperform much larger ones on the <strong>MATH-500 benchmark</strong> when given enough <strong>“time to think”</strong>. Recent research from <a href="https://arxiv.org/abs/2408.03314" rel="nofollow">DeepMind</a> suggests that <strong>test-time compute</strong> can be scaled optimally through strategies like iterative self-refinement or using a reward model.',Ke,$,bl='The blog introduces a <a href="https://github.com/huggingface/search-and-learn" rel="nofollow"><strong>new repository</strong></a> for running these experiments. In this recipe, we’ll focus on building a <strong>small chatbot</strong> that engages in <strong>longer reasoning</strong> to tackle <strong>harder problems</strong> using small open models.',Oe,C,Tl='<img src="https://huggingface.co/datasets/HuggingFaceH4/blogpost-images/resolve/main/methods-thumbnail.png" alt="Instruct LLM Methodology"/>',et,I,tt,x,Jl=`Let’s start by installing the <a href="https://github.com/huggingface/search-and-learn" rel="nofollow">search-and-learn</a> repository! 🚀<br/>
This repo is designed to replicate the experimental results and is not a Python pip package. However, we can still use it to generate our system. To do so, we’ll need to install it from source with the following steps:`,lt,v,st,Z,nt,G,jl=`Log in to Hugging Face to access <a href="https://huggingface.co/meta-llama/Llama-3.2-1B-Instruct" rel="nofollow">meta-llama/Llama-3.2-1B-Instruct</a>, as it is a gated model! 🗝️<br/>
If you haven’t previously requested access, you’ll need to submit a request before proceeding.`,at,B,it,k,rt,_,Ul='As illustrated in the diagram, the system consists of an LLM that generates intermediate answers based on user input, a <a href="https://huggingface.co/papers/2211.14275" rel="nofollow">PRM model</a> that evaluates and scores these answers, and a search strategy that uses the PRM feedback to guide the subsequent steps in the search process until reaching the final answer.',ot,R,$l='Let’s begin by initializing each model. For the LLM, we’ll use the <a href="https://huggingface.co/meta-llama/Llama-3.2-1B-Instruct" rel="nofollow">meta-llama/Llama-3.2-1B-Instruct</a> model, and for the PRM, we’ll use the <a href="https://huggingface.co/RLHFlow/Llama3.1-8B-PRM-Deepseek-Data" rel="nofollow">RLHFlow/Llama3.1-8B-PRM-Deepseek-Data</a> model.',pt,H,Cl='<img src="https://huggingface.co/datasets/HuggingFaceH4/blogpost-images/resolve/main/system.png" alt="system"/>',mt,W,ht,N,Mt,X,Il="Now that we’ve set up the LLM and PRM, let’s proceed by defining the question, selecting a search strategy to retrieve relevant information, and calling the pipeline to process the question through the models.",ct,V,xl='<li><p><strong>Instantiate the Question</strong>: In this step, we define the input question that the system will answer, considering the given context.</p></li> <li><p><strong>Search Strategy</strong>: The system currently supports the following search strategies: <code>best_of_n</code>, <code>beam_search</code>, and <code>dvts</code> (see diagram). For this example, we’ll use <code>best_of_n</code>, but you can easily switch to any of the other strategies based on your needs. We need to define some configuration parameters for the configuration of the search strategy. You can check the full list <a href="https://github.com/huggingface/search-and-learn/blob/main/src/sal/config.py" rel="nofollow">here</a>.</p></li> <li><p><strong>Call the Pipeline</strong>: With the question and search strategy in place, we’ll call the inference pipeline, processing the inputs through both the LLM and PRM to generate the final answer.</p></li>',dt,L,vl='<img src="https://huggingface.co/datasets/HuggingFaceH4/blogpost-images/resolve/main/search-strategies.png"/>',gt,A,Zl="The first step is to clearly define the question that the system will answer. This ensures that we have a precise task for the model to tackle.",ut,Q,ft,S,Gl="Next, we define the configuration, including parameters like the number of candidate answers <code>(N)</code>, and choose the search strategy that will be used. The search strategy dictates how we explore the potential answers. In this case, we’ll use <code>best_of_n</code>.",yt,E,Bl="With the question and configuration in place, we use the selected search strategy to generate multiple candidate answers. These candidates are evaluated based on their relevance and quality and the final answer is returned.",wt,z,bt,Y,Tt,F,kl="Once the pipeline has processed the question through the LLM and PRM, we can display the final result. This result will be the model’s output after considering the intermediate answers and scoring them using the PRM.",Jt,q,_l="Here’s how to display the final answer:",jt,P,Ut,D,Rl="The model’s output might include special tokens, such as <code>&lt;|start_header_id|&gt;</code> or <code>&lt;|end_header_id|&gt;</code>. To make the answer more readable, we can safely remove them before displaying it to the end user.",$t,K,Ct,O,Hl="After removing any special tokens, we can display the final answer to the user. Since the answer is based on markdown, it can be rendered properly by displaying it as markdown.",It,ee,xt,te,vt,le,Wl="Now, let’s create a method that encapsulates the entire pipeline. This will allow us to easily reuse the process in future applications, making it efficient and modular.",Zt,se,Nl="By combining the LLM, PRM, search strategy, and result display, we can simplify the workflow and ensure that it’s reusable for other tasks or questions.",Gt,ne,Xl="We simplify the workflow, ensuring that it’s reusable for different tasks or questions. Additionally, we’ll track the time spent on each method so that we can <strong>understand the practical implications</strong> of using each strategy and configuration.",Bt,ae,Vl="Here’s how we can structure the method:",kt,ie,_t,re,Rt,oe,Ll="Let’s compare the <strong>thinking time</strong> of three methods: <code>best_of_n</code>, <code>beam_search</code>, and <code>dvts</code>. Each method is evaluated using the same number of answers during the search process, measuring the time spent thinking in seconds and the number of generated tokens.",Ht,pe,Al="In the results below, the <code>best_of_n</code> method shows the least thinking time, while the <code>dvts</code> method takes the most time. However, <code>best_of_n</code> generates more tokens due to its simpler search strategy.",Wt,me,Ql="<thead><tr><th><strong>Method</strong></th> <th><strong>Number of Answers During Search</strong></th> <th><strong>Thinking Time (Seconds)</strong></th> <th><strong>Generated Tokens</strong></th></tr></thead> <tbody><tr><td><strong>best_of_n</strong></td> <td>8</td> <td>3.54</td> <td>3087</td></tr> <tr><td><strong>beam_search</strong></td> <td>8</td> <td>10.06</td> <td>2049</td></tr> <tr><td><strong>dvts</strong></td> <td>8</td> <td>8.46</td> <td>2544</td></tr></tbody>",Nt,he,Sl="This comparison illustrates the trade-offs between the strategies, balancing time spent thinking and the complexity of the search process.",Xt,Me,Vt,ce,El="We’ll begin by using the <code>best_of_n</code> strategy. Here’s how to track the thinking time for this method:",Lt,de,At,ge,zl=`Finished in 3.54 seconds

Total tokens in all completions: 3087
`,Qt,ue,St,fe,Et,ye,Yl="Now, let’s try using the <code>beam_search</code> strategy.",zt,we,Yt,be,Fl=`Finished in 10.06 seconds

Total tokens in all completions: 2049
`,Ft,Te,qt,Je,Pt,je,ql="Finally, let’s try the <code>dvts</code> strategy.",Dt,Ue,Kt,$e,Pl=`Finished in 8.46 seconds

Total tokens in all completions: 2544
`,Ot,Ce,el,Ie,tl,xe,Dl="In this final example, we’ll test the system using a straightforward question to observe how it performs in simpler cases. This allows us to verify that the system works as expected even for basic queries.",ll,ve,Kl="Let’s try the following question:",sl,Ze,nl,Ge,Ol=`Finished in 1.03 seconds

Total tokens in all completions: 544
`,al,Be,il,ke,es="Even though we set a larger number of candidate answers (<code>N</code>), the time spent thinking remains relatively small (1.03 seconds and 544 generated tokens). This demonstrates the system’s ability to efficiently handle easier problems, spending less time on them, while leveraging its enhanced capabilities for more complex questions.",rl,_e,ts="🏆 <strong>We now have a fully operational pipeline</strong> that leverages test-time compute, enabling the system to “think longer” for more complicated queries, while also maintaining fast response times for straightforward questions.",ol,Re,ls="This approach ensures the system can scale its thinking time based on the task’s complexity, offering an efficient and responsive solution for both simple and challenging problems.",pl,He,ml,We,ss='If you’re eager to continue exploring, be sure to check out the original experimental <a href="https://huggingface.co/spaces/HuggingFaceH4/blogpost-scaling-test-time-compute" rel="nofollow">blog</a> and all the references mentioned within it. These resources will deepen your understanding of test-time compute, its benefits, and its applications in LLMs.',hl,Ne,ns="Happy learning and experimenting! 🚀",Ml,Xe,cl,Le,dl;return y=new gs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/search_and_learn.ipynb"}]}}),w=new ds({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),b=new u({props:{title:"Scaling Test-Time Compute for Longer Thinking in LLMs",local:"scaling-test-time-compute-for-longer-thinking-in-llms",headingTag:"h1"}}),I=new u({props:{title:"1. Install Dependencies",local:"1-install-dependencies",headingTag:"h2"}}),v=new g({props:{code:"IWdpdCUyMGNsb25lJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZzZWFyY2gtYW5kLWxlYXJu",highlighted:'!git clone https://github.com/huggingface/search-<span class="hljs-keyword">and</span>-learn',wrap:!1}}),Z=new g({props:{code:"JTI1Y2QlMjBzZWFyY2gtYW5kLWxlYXJuJTBBIXBpcCUyMGluc3RhbGwlMjAtZSUyMCcuJTVCZGV2JTVEJw==",highlighted:`%cd search-<span class="hljs-keyword">and</span>-learn
!pip install -e <span class="hljs-string">&#x27;.[dev]&#x27;</span>`,wrap:!1}}),B=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),k=new u({props:{title:"2. Setup the Large Language Model (LLM) and the Process Reward Model (PRM) 💬",local:"2-setup-the-large-language-model-llm-and-the-process-reward-model-prm-",headingTag:"h2"}}),W=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdmxsbSUyMGltcG9ydCUyMExMTSUwQWZyb20lMjBzYWwubW9kZWxzLnJld2FyZF9tb2RlbHMlMjBpbXBvcnQlMjBSTEhGRmxvdyUwQSUwQW1vZGVsX3BhdGglM0QlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4yLTFCLUluc3RydWN0JTIyJTBBcHJtX3BhdGglM0QlMjJSTEhGbG93JTJGTGxhbWEzLjEtOEItUFJNLURlZXBzZWVrLURhdGElMjIlMEElMEFsbG0lMjAlM0QlMjBMTE0oJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbF9wYXRoJTJDJTBBJTIwJTIwJTIwJTIwZ3B1X21lbW9yeV91dGlsaXphdGlvbiUzRDAuNSUyQyUyMCUyMCUyMyUyMFV0aWxpemUlMjA1MCUyNSUyMG9mJTIwR1BVJTIwbWVtb3J5JTBBJTIwJTIwJTIwJTIwZW5hYmxlX3ByZWZpeF9jYWNoaW5nJTNEVHJ1ZSUyQyUyMCUyMCUyMyUyME9wdGltaXplJTIwcmVwZWF0ZWQlMjBwcmVmaXglMjBjb21wdXRhdGlvbnMlMEElMjAlMjAlMjAlMjBzZWVkJTNENDIlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBTZXQlMjBzZWVkJTIwZm9yJTIwcmVwcm9kdWNpYmlsaXR5JTBBKSUwQSUwQXBybSUyMCUzRCUyMFJMSEZGbG93KHBybV9wYXRoKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> vllm <span class="hljs-keyword">import</span> LLM
<span class="hljs-keyword">from</span> sal.models.reward_models <span class="hljs-keyword">import</span> RLHFFlow

model_path=<span class="hljs-string">&quot;meta-llama/Llama-3.2-1B-Instruct&quot;</span>
prm_path=<span class="hljs-string">&quot;RLHFlow/Llama3.1-8B-PRM-Deepseek-Data&quot;</span>

llm = LLM(
    model=model_path,
    gpu_memory_utilization=<span class="hljs-number">0.5</span>,  <span class="hljs-comment"># Utilize 50% of GPU memory</span>
    enable_prefix_caching=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Optimize repeated prefix computations</span>
    seed=<span class="hljs-number">42</span>,                     <span class="hljs-comment"># Set seed for reproducibility</span>
)

prm = RLHFFlow(prm_path)`,wrap:!1}}),N=new u({props:{title:"2.1 Instantiate the Question, Search Strategy, and Call the Pipeline",local:"21-instantiate-the-question-search-strategy-and-call-the-pipeline",headingTag:"h3"}}),Q=new g({props:{code:"cXVlc3Rpb25fdGV4dCUyMCUzRCUyMCdDb252ZXJ0JTIwdGhlJTIwcG9pbnQlMjAlMjQoMCUyQzMpJTI0JTIwaW4lMjByZWN0YW5ndWxhciUyMGNvb3JkaW5hdGVzJTIwdG8lMjBwb2xhciUyMGNvb3JkaW5hdGVzLiUyMCUyMEVudGVyJTIweW91ciUyMGFuc3dlciUyMGluJTIwdGhlJTIwZm9ybSUyMCUyNChyJTJDJTVDdGhldGEpJTJDJTI0JTIwd2hlcmUlMjAlMjRyJTIwJTNFJTIwMCUyNCUyMGFuZCUyMCUyNDAlMjAlNUNsZSUyMCU1Q3RoZXRhJTIwJTNDJTIwMiUyMCU1Q3BpLiUyNCclMEFpbnB1dF9iYXRjaCUyMCUzRCUyMCU3QiUyMnByb2JsZW0lMjIlM0ElMjAlNUJxdWVzdGlvbl90ZXh0JTVEJTdE",highlighted:`question_text = <span class="hljs-string">&#x27;Convert the point $(0,3)$ in rectangular coordinates to polar coordinates.  Enter your answer in the form $(r,\\theta),$ where $r &gt; 0$ and $0 \\le \\theta &lt; 2 \\pi.$&#x27;</span>
input_batch = {<span class="hljs-string">&quot;problem&quot;</span>: [question_text]}`,wrap:!1}}),z=new g({props:{code:"ZnJvbSUyMHNhbC5jb25maWclMjBpbXBvcnQlMjBDb25maWclMEFmcm9tJTIwc2FsLnNlYXJjaCUyMGltcG9ydCUyMGJlYW1fc2VhcmNoJTJDJTIwYmVzdF9vZl9uJTJDJTIwZHZ0cyUwQSUwQWNvbmZpZyUyMCUzRCUyMENvbmZpZygpJTBBY29uZmlnLm4lM0QzMiUyMCUyMyUyME51bWJlciUyMG9mJTIwYW5zd2VycyUyMHRvJTIwZ2VuZXJhdGUlMjBkdXJpbmclMjB0aGUlMjBzZWFyY2glMEElMEFzZWFyY2hfcmVzdWx0JTIwJTNEJTIwYmVzdF9vZl9uKHglM0RpbnB1dF9iYXRjaCUyQyUyMGNvbmZpZyUzRGNvbmZpZyUyQyUyMGxsbSUzRGxsbSUyQyUyMHBybSUzRHBybSk=",highlighted:`<span class="hljs-keyword">from</span> sal.config <span class="hljs-keyword">import</span> Config
<span class="hljs-keyword">from</span> sal.search <span class="hljs-keyword">import</span> beam_search, best_of_n, dvts

config = Config()
config.n=<span class="hljs-number">32</span> <span class="hljs-comment"># Number of answers to generate during the search</span>

search_result = best_of_n(x=input_batch, config=config, llm=llm, prm=prm)`,wrap:!1}}),Y=new u({props:{title:"2.2 Display the Final Result",local:"22-display-the-final-result",headingTag:"h3"}}),P=new g({props:{code:"c2VhcmNoX3Jlc3VsdCU1QidwcmVkJyU1RCU1QjAlNUQ=",highlighted:'search_result[<span class="hljs-string">&#x27;pred&#x27;</span>][<span class="hljs-number">0</span>]',wrap:!1}}),K=new g({props:{code:"Zm9ybWF0dGVkX291dHB1dCUyMCUzRCUyMHNlYXJjaF9yZXN1bHQlNUIncHJlZCclNUQlNUIwJTVELnJlcGxhY2UoJTIyJTNDJTdDc3RhcnRfaGVhZGVyX2lkJTdDJTNFYXNzaXN0YW50JTNDJTdDZW5kX2hlYWRlcl9pZCU3QyUzRSU1Q24lNUNuJTIyJTJDJTIwJTIyJTIyKS5zdHJpcCgpJTBBZm9ybWF0dGVkX291dHB1dA==",highlighted:`formatted_output = search_result[<span class="hljs-string">&#x27;pred&#x27;</span>][<span class="hljs-number">0</span>].replace(<span class="hljs-string">&quot;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;\\n\\n&quot;</span>, <span class="hljs-string">&quot;&quot;</span>).strip()
formatted_output`,wrap:!1}}),ee=new g({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMGRpc3BsYXklMkMlMjBNYXJrZG93biUwQSUwQWRpc3BsYXkoTWFya2Rvd24oZm9ybWF0dGVkX291dHB1dCkp",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> display, Markdown

display(Markdown(formatted_output))`,wrap:!1}}),te=new u({props:{title:"3. Assembling It All! 🧑‍🏭️",local:"3-assembling-it-all-",headingTag:"h2"}}),ie=new g({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> time

<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_with_search_and_learn</span>(<span class="hljs-params">question, config, llm, prm, method=<span class="hljs-string">&#x27;best_of_n&#x27;</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Generate an answer for a given question using the search-and-learn pipeline.

    Args:
    - question (str): The input question to generate an answer for.
    - config (Config): Configuration object containing parameters for search strategy.
    - llm (LLM): Pretrained large language model used for generating answers.
    - prm (RLHFFlow): Process reward model used for evaluating answers.
    - method (str): Search strategy to use. Options are &#x27;best_of_n&#x27;, &#x27;beam_search&#x27;, &#x27;dvts&#x27;. Default is &#x27;best_of_n&#x27;.

    Returns:
    - str: The formatted output after processing the question.
    &quot;&quot;&quot;</span>
    batch = {<span class="hljs-string">&quot;problem&quot;</span>: [question]}

    start_time = time.time()
    <span class="hljs-keyword">if</span> method == <span class="hljs-string">&#x27;best_of_n&#x27;</span>:
      result = best_of_n(x=batch, config=config, llm=llm, prm=prm)
    <span class="hljs-keyword">elif</span> method == <span class="hljs-string">&#x27;beam_search&#x27;</span>:
      result = beam_search(examples=batch, config=config, llm=llm, prm=prm)
    <span class="hljs-keyword">elif</span> method == <span class="hljs-string">&#x27;dvts&#x27;</span>:
      result = dvts(examples=batch, config=config, llm=llm, prm=prm)

    elapsed_time = time.time() - start_time
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\nFinished in <span class="hljs-subst">{elapsed_time:<span class="hljs-number">.2</span>f}</span> seconds\\n&quot;</span>)

    tokenizer = llm.get_tokenizer()
    total_tokens = <span class="hljs-number">0</span>
    <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> result[<span class="hljs-string">&#x27;completions&#x27;</span>]:
        <span class="hljs-keyword">for</span> comp <span class="hljs-keyword">in</span>  completion:
            output_tokens = tokenizer.encode(comp)
            total_tokens += <span class="hljs-built_in">len</span>(output_tokens)

    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Total tokens in all completions: <span class="hljs-subst">{total_tokens}</span>&quot;</span>)

    formatted_output = result[<span class="hljs-string">&#x27;pred&#x27;</span>][<span class="hljs-number">0</span>].replace(<span class="hljs-string">&quot;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;\\n\\n&quot;</span>, <span class="hljs-string">&quot;&quot;</span>).strip()
    <span class="hljs-keyword">return</span> formatted_output`,wrap:!1}}),re=new u({props:{title:"⏳  3.1 Comparing Thinking Time for Each Strategy",local:"-31-comparing-thinking-time-for-each-strategy",headingTag:"h3"}}),Me=new u({props:{title:"1. Best of n",local:"1-best-of-n",headingTag:"h4"}}),de=new g({props:{code:"cXVlc3Rpb24lMjAlM0QlMjAnQ29udmVydCUyMHRoZSUyMHBvaW50JTIwJTI0KDAlMkMzKSUyNCUyMGluJTIwcmVjdGFuZ3VsYXIlMjBjb29yZGluYXRlcyUyMHRvJTIwcG9sYXIlMjBjb29yZGluYXRlcy4lMjAlMjBFbnRlciUyMHlvdXIlMjBhbnN3ZXIlMjBpbiUyMHRoZSUyMGZvcm0lMjAlMjQociUyQyU1Q3RoZXRhKSUyQyUyNCUyMHdoZXJlJTIwJTI0ciUyMCUzRSUyMDAlMjQlMjBhbmQlMjAlMjQwJTIwJTVDbGUlMjAlNUN0aGV0YSUyMCUzQyUyMDIlMjAlNUNwaS4lMjQnJTBBJTBBY29uZmlnLm4lM0Q4JTBBJTBBZm9ybWF0dGVkX291dHB1dCUyMCUzRCUyMGdlbmVyYXRlX3dpdGhfc2VhcmNoX2FuZF9sZWFybihxdWVzdGlvbiUzRHF1ZXN0aW9uJTJDJTIwY29uZmlnJTNEY29uZmlnJTJDJTIwbGxtJTNEbGxtJTJDJTIwcHJtJTNEcHJtJTJDJTIwbWV0aG9kJTNEJ2Jlc3Rfb2Zfbicp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&#x27;Convert the point $(0,3)$ in rectangular coordinates to polar coordinates.  Enter your answer in the form $(r,\\theta),$ where $r &gt; 0$ and $0 \\le \\theta &lt; 2 \\pi.$&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>config.n=<span class="hljs-number">8</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>formatted_output = generate_with_search_and_learn(question=question, config=config, llm=llm, prm=prm, method=<span class="hljs-string">&#x27;best_of_n&#x27;</span>)`,wrap:!1}}),ue=new g({props:{code:"ZGlzcGxheShNYXJrZG93bihmb3JtYXR0ZWRfb3V0cHV0KSk=",highlighted:"display(Markdown(formatted_output))",wrap:!1}}),fe=new u({props:{title:"2. Beam Search",local:"2-beam-search",headingTag:"h4"}}),we=new g({props:{code:"Y29uZmlnLm4lM0Q4JTBBJTIzJTIwYmVhbSUyMHNlYXJjaCUyMHNwZWNpZmljJTBBY29uZmlnLnNvcnRfY29tcGxldGVkJTNEVHJ1ZSUwQWNvbmZpZy5maWx0ZXJfZHVwbGljYXRlcyUzRFRydWUlMEElMEFmb3JtYXR0ZWRfb3V0cHV0JTIwJTNEJTIwZ2VuZXJhdGVfd2l0aF9zZWFyY2hfYW5kX2xlYXJuKHF1ZXN0aW9uJTNEcXVlc3Rpb24lMkMlMjBjb25maWclM0Rjb25maWclMkMlMjBsbG0lM0RsbG0lMkMlMjBwcm0lM0Rwcm0lMkMlMjBtZXRob2QlM0QnYmVhbV9zZWFyY2gnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>config.n=<span class="hljs-number">8</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># beam search specific</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config.sort_completed=<span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config.filter_duplicates=<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>formatted_output = generate_with_search_and_learn(question=question, config=config, llm=llm, prm=prm, method=<span class="hljs-string">&#x27;beam_search&#x27;</span>)`,wrap:!1}}),Te=new g({props:{code:"ZGlzcGxheShNYXJrZG93bihmb3JtYXR0ZWRfb3V0cHV0KSk=",highlighted:"display(Markdown(formatted_output))",wrap:!1}}),Je=new u({props:{title:"3. Diverse Verifier Tree Search (DVTS)",local:"3-diverse-verifier-tree-search-dvts",headingTag:"h4"}}),Ue=new g({props:{code:"Y29uZmlnLm4lM0Q4JTBBJTIzJTIwZHZ0cyUyMHNwZWNpZmljJTBBY29uZmlnLm5fYmVhbXMlMjAlM0QlMjBjb25maWcubiUyMCUyRiUyRiUyMGNvbmZpZy5iZWFtX3dpZHRoJTBBJTBBZm9ybWF0dGVkX291dHB1dCUyMCUzRCUyMGdlbmVyYXRlX3dpdGhfc2VhcmNoX2FuZF9sZWFybihxdWVzdGlvbiUzRHF1ZXN0aW9uJTJDJTIwY29uZmlnJTNEY29uZmlnJTJDJTIwbGxtJTNEbGxtJTJDJTIwcHJtJTNEcHJtJTJDJTIwbWV0aG9kJTNEJ2R2dHMnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>config.n=<span class="hljs-number">8</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># dvts specific</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config.n_beams = config.n // config.beam_width

<span class="hljs-meta">&gt;&gt;&gt; </span>formatted_output = generate_with_search_and_learn(question=question, config=config, llm=llm, prm=prm, method=<span class="hljs-string">&#x27;dvts&#x27;</span>)`,wrap:!1}}),Ce=new g({props:{code:"ZGlzcGxheShNYXJrZG93bihmb3JtYXR0ZWRfb3V0cHV0KSk=",highlighted:"display(Markdown(formatted_output))",wrap:!1}}),Ie=new u({props:{title:"🙋 3.2 Testing the System with a Simple Question",local:"-32-testing-the-system-with-a-simple-question",headingTag:"h3"}}),Ze=new g({props:{code:"cXVlc3Rpb24lMjAlM0QlMjAnV2hhdCU1QydzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwU3BhaW4lM0YnJTBBJTBBY29uZmlnLm4lM0QzMiUwQSUwQWZvcm1hdHRlZF9vdXRwdXQlMjAlM0QlMjBnZW5lcmF0ZV93aXRoX3NlYXJjaF9hbmRfbGVhcm4ocXVlc3Rpb24lM0RxdWVzdGlvbiUyQyUyMGNvbmZpZyUzRGNvbmZpZyUyQyUyMGxsbSUzRGxsbSUyQyUyMHBybSUzRHBybSUyQyUyMG1ldGhvZCUzRCdiZXN0X29mX24nKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&#x27;What\\&#x27;s the capital of Spain?&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>config.n=<span class="hljs-number">32</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>formatted_output = generate_with_search_and_learn(question=question, config=config, llm=llm, prm=prm, method=<span class="hljs-string">&#x27;best_of_n&#x27;</span>)`,wrap:!1}}),Be=new g({props:{code:"ZGlzcGxheShNYXJrZG93bihmb3JtYXR0ZWRfb3V0cHV0KSk=",highlighted:"display(Markdown(formatted_output))",wrap:!1}}),He=new u({props:{title:"4. Continuing the Journey and Resources 🧑‍🎓️",local:"4-continuing-the-journey-and-resources-",headingTag:"h2"}}),Xe=new us({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/search_and_learn.md"}}),{c(){f=i("meta"),Ae=n(),Ve=i("p"),Qe=n(),p(y.$$.fragment),Se=n(),p(w.$$.fragment),Ee=n(),p(b.$$.fragment),ze=n(),T=i("p"),T.innerHTML=ul,Ye=n(),J=i("p"),J.innerHTML=fl,Fe=n(),qe=i("hr"),Pe=n(),j=i("p"),j.innerHTML=yl,De=n(),U=i("p"),U.innerHTML=wl,Ke=n(),$=i("p"),$.innerHTML=bl,Oe=n(),C=i("p"),C.innerHTML=Tl,et=n(),p(I.$$.fragment),tt=n(),x=i("p"),x.innerHTML=Jl,lt=n(),p(v.$$.fragment),st=n(),p(Z.$$.fragment),nt=n(),G=i("p"),G.innerHTML=jl,at=n(),p(B.$$.fragment),it=n(),p(k.$$.fragment),rt=n(),_=i("p"),_.innerHTML=Ul,ot=n(),R=i("p"),R.innerHTML=$l,pt=n(),H=i("p"),H.innerHTML=Cl,mt=n(),p(W.$$.fragment),ht=n(),p(N.$$.fragment),Mt=n(),X=i("p"),X.textContent=Il,ct=n(),V=i("ol"),V.innerHTML=xl,dt=n(),L=i("p"),L.innerHTML=vl,gt=n(),A=i("p"),A.textContent=Zl,ut=n(),p(Q.$$.fragment),ft=n(),S=i("p"),S.innerHTML=Gl,yt=n(),E=i("p"),E.textContent=Bl,wt=n(),p(z.$$.fragment),bt=n(),p(Y.$$.fragment),Tt=n(),F=i("p"),F.textContent=kl,Jt=n(),q=i("p"),q.textContent=_l,jt=n(),p(P.$$.fragment),Ut=n(),D=i("p"),D.innerHTML=Rl,$t=n(),p(K.$$.fragment),Ct=n(),O=i("p"),O.textContent=Hl,It=n(),p(ee.$$.fragment),xt=n(),p(te.$$.fragment),vt=n(),le=i("p"),le.textContent=Wl,Zt=n(),se=i("p"),se.textContent=Nl,Gt=n(),ne=i("p"),ne.innerHTML=Xl,Bt=n(),ae=i("p"),ae.textContent=Vl,kt=n(),p(ie.$$.fragment),_t=n(),p(re.$$.fragment),Rt=n(),oe=i("p"),oe.innerHTML=Ll,Ht=n(),pe=i("p"),pe.innerHTML=Al,Wt=n(),me=i("table"),me.innerHTML=Ql,Nt=n(),he=i("p"),he.textContent=Sl,Xt=n(),p(Me.$$.fragment),Vt=n(),ce=i("p"),ce.innerHTML=El,Lt=n(),p(de.$$.fragment),At=n(),ge=i("pre"),ge.textContent=zl,Qt=n(),p(ue.$$.fragment),St=n(),p(fe.$$.fragment),Et=n(),ye=i("p"),ye.innerHTML=Yl,zt=n(),p(we.$$.fragment),Yt=n(),be=i("pre"),be.textContent=Fl,Ft=n(),p(Te.$$.fragment),qt=n(),p(Je.$$.fragment),Pt=n(),je=i("p"),je.innerHTML=ql,Dt=n(),p(Ue.$$.fragment),Kt=n(),$e=i("pre"),$e.textContent=Pl,Ot=n(),p(Ce.$$.fragment),el=n(),p(Ie.$$.fragment),tl=n(),xe=i("p"),xe.textContent=Dl,ll=n(),ve=i("p"),ve.textContent=Kl,sl=n(),p(Ze.$$.fragment),nl=n(),Ge=i("pre"),Ge.textContent=Ol,al=n(),p(Be.$$.fragment),il=n(),ke=i("p"),ke.innerHTML=es,rl=n(),_e=i("p"),_e.innerHTML=ts,ol=n(),Re=i("p"),Re.textContent=ls,pl=n(),p(He.$$.fragment),ml=n(),We=i("p"),We.innerHTML=ss,hl=n(),Ne=i("p"),Ne.textContent=ns,Ml=n(),p(Xe.$$.fragment),cl=n(),Le=i("p"),this.h()},l(e){const t=Ms("svelte-u9bgzb",document.head);f=r(t,"META",{name:!0,content:!0}),t.forEach(l),Ae=a(e),Ve=r(e,"P",{}),as(Ve).forEach(l),Qe=a(e),m(y.$$.fragment,e),Se=a(e),m(w.$$.fragment,e),Ee=a(e),m(b.$$.fragment,e),ze=a(e),T=r(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-1i2zwz9"&&(T.innerHTML=ul),Ye=a(e),J=r(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-10f9vjj"&&(J.innerHTML=fl),Fe=a(e),qe=r(e,"HR",{}),Pe=a(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-8852nd"&&(j.innerHTML=yl),De=a(e),U=r(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-15rkks5"&&(U.innerHTML=wl),Ke=a(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-17mjvl5"&&($.innerHTML=bl),Oe=a(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-7mv5ve"&&(C.innerHTML=Tl),et=a(e),m(I.$$.fragment,e),tt=a(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-16fxmex"&&(x.innerHTML=Jl),lt=a(e),m(v.$$.fragment,e),st=a(e),m(Z.$$.fragment,e),nt=a(e),G=r(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-10vy8e5"&&(G.innerHTML=jl),at=a(e),m(B.$$.fragment,e),it=a(e),m(k.$$.fragment,e),rt=a(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1ses3rd"&&(_.innerHTML=Ul),ot=a(e),R=r(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-bxlnst"&&(R.innerHTML=$l),pt=a(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1pkwevp"&&(H.innerHTML=Cl),mt=a(e),m(W.$$.fragment,e),ht=a(e),m(N.$$.fragment,e),Mt=a(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1ea8tja"&&(X.textContent=Il),ct=a(e),V=r(e,"OL",{"data-svelte-h":!0}),o(V)!=="svelte-b938qh"&&(V.innerHTML=xl),dt=a(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-o7doj"&&(L.innerHTML=vl),gt=a(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-jy1gvy"&&(A.textContent=Zl),ut=a(e),m(Q.$$.fragment,e),ft=a(e),S=r(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-16kxf0u"&&(S.innerHTML=Gl),yt=a(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-exqjjq"&&(E.textContent=Bl),wt=a(e),m(z.$$.fragment,e),bt=a(e),m(Y.$$.fragment,e),Tt=a(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-qgh1h"&&(F.textContent=kl),Jt=a(e),q=r(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-9g6ac8"&&(q.textContent=_l),jt=a(e),m(P.$$.fragment,e),Ut=a(e),D=r(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1uk9mxl"&&(D.innerHTML=Rl),$t=a(e),m(K.$$.fragment,e),Ct=a(e),O=r(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-2etbr"&&(O.textContent=Hl),It=a(e),m(ee.$$.fragment,e),xt=a(e),m(te.$$.fragment,e),vt=a(e),le=r(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-yq317k"&&(le.textContent=Wl),Zt=a(e),se=r(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-g8sp1x"&&(se.textContent=Nl),Gt=a(e),ne=r(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-19p4ebm"&&(ne.innerHTML=Xl),Bt=a(e),ae=r(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1l8se6d"&&(ae.textContent=Vl),kt=a(e),m(ie.$$.fragment,e),_t=a(e),m(re.$$.fragment,e),Rt=a(e),oe=r(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1o1o7qu"&&(oe.innerHTML=Ll),Ht=a(e),pe=r(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-14olwev"&&(pe.innerHTML=Al),Wt=a(e),me=r(e,"TABLE",{"data-svelte-h":!0}),o(me)!=="svelte-12x8exj"&&(me.innerHTML=Ql),Nt=a(e),he=r(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-3cgoag"&&(he.textContent=Sl),Xt=a(e),m(Me.$$.fragment,e),Vt=a(e),ce=r(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-13krho7"&&(ce.innerHTML=El),Lt=a(e),m(de.$$.fragment,e),At=a(e),ge=r(e,"PRE",{"data-svelte-h":!0}),o(ge)!=="svelte-xgcx5j"&&(ge.textContent=zl),Qt=a(e),m(ue.$$.fragment,e),St=a(e),m(fe.$$.fragment,e),Et=a(e),ye=r(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-t74ywb"&&(ye.innerHTML=Yl),zt=a(e),m(we.$$.fragment,e),Yt=a(e),be=r(e,"PRE",{"data-svelte-h":!0}),o(be)!=="svelte-1g4g5lj"&&(be.textContent=Fl),Ft=a(e),m(Te.$$.fragment,e),qt=a(e),m(Je.$$.fragment,e),Pt=a(e),je=r(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-9uwez9"&&(je.innerHTML=ql),Dt=a(e),m(Ue.$$.fragment,e),Kt=a(e),$e=r(e,"PRE",{"data-svelte-h":!0}),o($e)!=="svelte-h9bqbg"&&($e.textContent=Pl),Ot=a(e),m(Ce.$$.fragment,e),el=a(e),m(Ie.$$.fragment,e),tl=a(e),xe=r(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-1i0kfzo"&&(xe.textContent=Dl),ll=a(e),ve=r(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-rdscea"&&(ve.textContent=Kl),sl=a(e),m(Ze.$$.fragment,e),nl=a(e),Ge=r(e,"PRE",{"data-svelte-h":!0}),o(Ge)!=="svelte-1fs64q8"&&(Ge.textContent=Ol),al=a(e),m(Be.$$.fragment,e),il=a(e),ke=r(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-q2ito7"&&(ke.innerHTML=es),rl=a(e),_e=r(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-q4zxvl"&&(_e.innerHTML=ts),ol=a(e),Re=r(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-1wyyft7"&&(Re.textContent=ls),pl=a(e),m(He.$$.fragment,e),ml=a(e),We=r(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-1yzuydh"&&(We.innerHTML=ss),hl=a(e),Ne=r(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-uzbr78"&&(Ne.textContent=ns),Ml=a(e),m(Xe.$$.fragment,e),cl=a(e),Le=r(e,"P",{}),as(Le).forEach(l),this.h()},h(){is(f,"name","hf:doc:metadata"),is(f,"content",ys)},m(e,t){cs(document.head,f),s(e,Ae,t),s(e,Ve,t),s(e,Qe,t),h(y,e,t),s(e,Se,t),h(w,e,t),s(e,Ee,t),h(b,e,t),s(e,ze,t),s(e,T,t),s(e,Ye,t),s(e,J,t),s(e,Fe,t),s(e,qe,t),s(e,Pe,t),s(e,j,t),s(e,De,t),s(e,U,t),s(e,Ke,t),s(e,$,t),s(e,Oe,t),s(e,C,t),s(e,et,t),h(I,e,t),s(e,tt,t),s(e,x,t),s(e,lt,t),h(v,e,t),s(e,st,t),h(Z,e,t),s(e,nt,t),s(e,G,t),s(e,at,t),h(B,e,t),s(e,it,t),h(k,e,t),s(e,rt,t),s(e,_,t),s(e,ot,t),s(e,R,t),s(e,pt,t),s(e,H,t),s(e,mt,t),h(W,e,t),s(e,ht,t),h(N,e,t),s(e,Mt,t),s(e,X,t),s(e,ct,t),s(e,V,t),s(e,dt,t),s(e,L,t),s(e,gt,t),s(e,A,t),s(e,ut,t),h(Q,e,t),s(e,ft,t),s(e,S,t),s(e,yt,t),s(e,E,t),s(e,wt,t),h(z,e,t),s(e,bt,t),h(Y,e,t),s(e,Tt,t),s(e,F,t),s(e,Jt,t),s(e,q,t),s(e,jt,t),h(P,e,t),s(e,Ut,t),s(e,D,t),s(e,$t,t),h(K,e,t),s(e,Ct,t),s(e,O,t),s(e,It,t),h(ee,e,t),s(e,xt,t),h(te,e,t),s(e,vt,t),s(e,le,t),s(e,Zt,t),s(e,se,t),s(e,Gt,t),s(e,ne,t),s(e,Bt,t),s(e,ae,t),s(e,kt,t),h(ie,e,t),s(e,_t,t),h(re,e,t),s(e,Rt,t),s(e,oe,t),s(e,Ht,t),s(e,pe,t),s(e,Wt,t),s(e,me,t),s(e,Nt,t),s(e,he,t),s(e,Xt,t),h(Me,e,t),s(e,Vt,t),s(e,ce,t),s(e,Lt,t),h(de,e,t),s(e,At,t),s(e,ge,t),s(e,Qt,t),h(ue,e,t),s(e,St,t),h(fe,e,t),s(e,Et,t),s(e,ye,t),s(e,zt,t),h(we,e,t),s(e,Yt,t),s(e,be,t),s(e,Ft,t),h(Te,e,t),s(e,qt,t),h(Je,e,t),s(e,Pt,t),s(e,je,t),s(e,Dt,t),h(Ue,e,t),s(e,Kt,t),s(e,$e,t),s(e,Ot,t),h(Ce,e,t),s(e,el,t),h(Ie,e,t),s(e,tl,t),s(e,xe,t),s(e,ll,t),s(e,ve,t),s(e,sl,t),h(Ze,e,t),s(e,nl,t),s(e,Ge,t),s(e,al,t),h(Be,e,t),s(e,il,t),s(e,ke,t),s(e,rl,t),s(e,_e,t),s(e,ol,t),s(e,Re,t),s(e,pl,t),h(He,e,t),s(e,ml,t),s(e,We,t),s(e,hl,t),s(e,Ne,t),s(e,Ml,t),h(Xe,e,t),s(e,cl,t),s(e,Le,t),dl=!0},p:os,i(e){dl||(M(y.$$.fragment,e),M(w.$$.fragment,e),M(b.$$.fragment,e),M(I.$$.fragment,e),M(v.$$.fragment,e),M(Z.$$.fragment,e),M(B.$$.fragment,e),M(k.$$.fragment,e),M(W.$$.fragment,e),M(N.$$.fragment,e),M(Q.$$.fragment,e),M(z.$$.fragment,e),M(Y.$$.fragment,e),M(P.$$.fragment,e),M(K.$$.fragment,e),M(ee.$$.fragment,e),M(te.$$.fragment,e),M(ie.$$.fragment,e),M(re.$$.fragment,e),M(Me.$$.fragment,e),M(de.$$.fragment,e),M(ue.$$.fragment,e),M(fe.$$.fragment,e),M(we.$$.fragment,e),M(Te.$$.fragment,e),M(Je.$$.fragment,e),M(Ue.$$.fragment,e),M(Ce.$$.fragment,e),M(Ie.$$.fragment,e),M(Ze.$$.fragment,e),M(Be.$$.fragment,e),M(He.$$.fragment,e),M(Xe.$$.fragment,e),dl=!0)},o(e){c(y.$$.fragment,e),c(w.$$.fragment,e),c(b.$$.fragment,e),c(I.$$.fragment,e),c(v.$$.fragment,e),c(Z.$$.fragment,e),c(B.$$.fragment,e),c(k.$$.fragment,e),c(W.$$.fragment,e),c(N.$$.fragment,e),c(Q.$$.fragment,e),c(z.$$.fragment,e),c(Y.$$.fragment,e),c(P.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),c(ie.$$.fragment,e),c(re.$$.fragment,e),c(Me.$$.fragment,e),c(de.$$.fragment,e),c(ue.$$.fragment,e),c(fe.$$.fragment,e),c(we.$$.fragment,e),c(Te.$$.fragment,e),c(Je.$$.fragment,e),c(Ue.$$.fragment,e),c(Ce.$$.fragment,e),c(Ie.$$.fragment,e),c(Ze.$$.fragment,e),c(Be.$$.fragment,e),c(He.$$.fragment,e),c(Xe.$$.fragment,e),dl=!1},d(e){e&&(l(Ae),l(Ve),l(Qe),l(Se),l(Ee),l(ze),l(T),l(Ye),l(J),l(Fe),l(qe),l(Pe),l(j),l(De),l(U),l(Ke),l($),l(Oe),l(C),l(et),l(tt),l(x),l(lt),l(st),l(nt),l(G),l(at),l(it),l(rt),l(_),l(ot),l(R),l(pt),l(H),l(mt),l(ht),l(Mt),l(X),l(ct),l(V),l(dt),l(L),l(gt),l(A),l(ut),l(ft),l(S),l(yt),l(E),l(wt),l(bt),l(Tt),l(F),l(Jt),l(q),l(jt),l(Ut),l(D),l($t),l(Ct),l(O),l(It),l(xt),l(vt),l(le),l(Zt),l(se),l(Gt),l(ne),l(Bt),l(ae),l(kt),l(_t),l(Rt),l(oe),l(Ht),l(pe),l(Wt),l(me),l(Nt),l(he),l(Xt),l(Vt),l(ce),l(Lt),l(At),l(ge),l(Qt),l(St),l(Et),l(ye),l(zt),l(Yt),l(be),l(Ft),l(qt),l(Pt),l(je),l(Dt),l(Kt),l($e),l(Ot),l(el),l(tl),l(xe),l(ll),l(ve),l(sl),l(nl),l(Ge),l(al),l(il),l(ke),l(rl),l(_e),l(ol),l(Re),l(pl),l(ml),l(We),l(hl),l(Ne),l(Ml),l(cl),l(Le)),l(f),d(y,e),d(w,e),d(b,e),d(I,e),d(v,e),d(Z,e),d(B,e),d(k,e),d(W,e),d(N,e),d(Q,e),d(z,e),d(Y,e),d(P,e),d(K,e),d(ee,e),d(te,e),d(ie,e),d(re,e),d(Me,e),d(de,e),d(ue,e),d(fe,e),d(we,e),d(Te,e),d(Je,e),d(Ue,e),d(Ce,e),d(Ie,e),d(Ze,e),d(Be,e),d(He,e),d(Xe,e)}}}const ys='{"title":"Scaling Test-Time Compute for Longer Thinking in LLMs","local":"scaling-test-time-compute-for-longer-thinking-in-llms","sections":[{"title":"1. Install Dependencies","local":"1-install-dependencies","sections":[],"depth":2},{"title":"2. Setup the Large Language Model (LLM) and the Process Reward Model (PRM) 💬","local":"2-setup-the-large-language-model-llm-and-the-process-reward-model-prm-","sections":[{"title":"2.1 Instantiate the Question, Search Strategy, and Call the Pipeline","local":"21-instantiate-the-question-search-strategy-and-call-the-pipeline","sections":[],"depth":3},{"title":"2.2 Display the Final Result","local":"22-display-the-final-result","sections":[],"depth":3}],"depth":2},{"title":"3. Assembling It All! 🧑‍🏭️","local":"3-assembling-it-all-","sections":[{"title":"⏳  3.1 Comparing Thinking Time for Each Strategy","local":"-31-comparing-thinking-time-for-each-strategy","sections":[{"title":"1. Best of n","local":"1-best-of-n","sections":[],"depth":4},{"title":"2. Beam Search","local":"2-beam-search","sections":[],"depth":4},{"title":"3. Diverse Verifier Tree Search (DVTS)","local":"3-diverse-verifier-tree-search-dvts","sections":[],"depth":4}],"depth":3},{"title":"🙋 3.2 Testing the System with a Simple Question","local":"-32-testing-the-system-with-a-simple-question","sections":[],"depth":3}],"depth":2},{"title":"4. Continuing the Journey and Resources 🧑‍🎓️","local":"4-continuing-the-journey-and-resources-","sections":[],"depth":2}],"depth":1}';function ws(gl){return ps(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $s extends ms{constructor(f){super(),hs(this,f,ws,fs,rs,{})}}export{$s as component};
