import{s as ma,a as Ma,n as wa,o as ya}from"../chunks/scheduler.1f027d5a.js";import{S as da,i as ua,e as i,s as n,c,h as fa,a as o,d as s,b as a,f as ha,g as p,j as r,k as Yl,l as ja,m as l,n as h,t as m,o as M,p as w}from"../chunks/index.5cb6ce42.js";import{C as Ta}from"../chunks/CopyLLMTxtMenu.f7108191.js";import{D as Ja,C as y}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as d,E as ba}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function Ua(El){let u,At,vt,Bt,f,Zt,j,Gt,T,$t,J,zl='<em>Authored by:<a href="https://github.com/peremartra" rel="nofollow">Pere Martra</a></em>',kt,b,Xl="In this notebook, we will explore a typical RAG solution where we will utilize an open-source model and the vector database Chroma DB. <strong>However, we will integrate a semantic cache system that will store various user queries and decide whether to generate the prompt enriched with information from the vector database or the cache.</strong>",Wt,U,Ql="A semantic caching system aims to identify similar or identical user requests. When a matching request is found, the system retrieves the corresponding information from the cache, reducing the need to fetch it from the original source.",Nt,I,Hl="As the comparison takes into account the semantic meaning of the requests, they don’t have to be identical for the system to recognize them as the same question.  They can be formulated differently or contain inaccuracies, be they typographical or in the sentence structure, and we can identify that the user is actually requesting the same information.",_t,C,Fl="For instance, queries like <strong>What is the capital of France?</strong>, <strong>Tell me the name of the capital of France?</strong>, and <strong>What The capital of France is?</strong> all convey the same intent and should be identified as the same question.",Rt,g,ql="While the model’s response may differ based on the request for a concise answer in the second example, the information retrieved from the vector database should be the same. This is why I’m placing the cache system between the user and the vector database, not between the user and the Large Language Model.",St,gt,Ll,Vt,v,Pl="Most tutorials that guide you through creating a RAG system are designed for single-user use, meant to operate in a testing environment. In other words, within a notebook, interacting with a local vector database and making API calls or using a locally stored model.",Yt,x,Dl="This architecture quickly becomes insufficient when attempting to transition one of these models to production, where they might encounter from tens to thousands of recurrent requests.",Et,A,Kl="One way to enhance performance is through one or multiple semantic caches. This cache retains the results of previous requests, and before resolving a new request, it checks if a similar one has been received before. If so, instead of re-executing the process, it retrieves the information from the cache.",zt,B,Ol="In a RAG system, there are two points that are time consuming:",Xt,Z,en="<li>Retrieve the information used to construct the enriched prompt:</li> <li>Call the Large Language Model to obtain the response.</li>",Qt,G,tn="In both points, a semantic cache system can be implemented, and we could even have two caches, one for each point.",Ht,$,sn="Placing it at the model’s response point may lead to a loss of influence over the obtained response. Our cache system could consider “Explain the French Revolution in 10 words” and “Explain the French Revolution in a hundred words” as the same query. If our cache system stores model responses, users might think that their instructions are not being followed accurately.",Ft,k,ln="But both requests will require the same information to enrich the prompt. This is the main reason why I chose to place the semantic cache system between the user’s request and the retrieval of information from the vector database.",qt,W,nn="However, this is a design decision. Depending on the type of responses and system requests, it can be placed at one point or another. It’s evident that caching model responses would yield the most time savings, but as I’ve already explained, it comes at the cost of losing user influence over the response.",Lt,N,Pt,_,an="To start we need to install the necesary Python packages.",Dt,R,on='<li><strong><a href="https://www.sbert.net/" rel="nofollow">sentence transformers</a></strong>. This library is necessary to transform the sentences into fixed-length vectors, also know as embeddings.</li> <li><strong><a href="https://github.com/facebookresearch/xformers" rel="nofollow">xformers</a></strong>. it’s a package that provides libraries an utilities to facilitate the work with transformers models. We need to install in order to avoid an error when we work with the model and embeddings.</li> <li><strong><a href="https://www.trychroma.com/" rel="nofollow">chromadb</a></strong>. This is our vector Database. ChromaDB is easy to use and open source, maybe the most used Vector Database used to store embeddings.</li> <li><strong><a href="https://github.com/huggingface/accelerate" rel="nofollow">accelerate</a></strong> Necesary to run the Model in a GPU.</li>',Kt,S,Ot,V,es,Y,ts,E,rn="As we are working in a free and limited space, and we can use just a few GB of memory I limited the number of rows to use from the Dataset with the variable <code>MAX_ROWS</code>.",ss,z,ls,X,ns,Q,cn="ChromaDB requires that the data has a unique identifier. We can make it with this statement, which will create a new column called <strong>Id</strong>.",as,H,is,F,os,q,rs,L,cs,P,pn="To store the information, I’ve chosen to use ChromaDB, one of the most well-known and widely used open-source vector databases.",ps,D,hn="First we need to import ChromaDB.",hs,K,ms,O,mn="Now we only need to indicate the path where the vector database will be stored.",Ms,ee,ws,te,ys,se,Mn="The Data in ChromaDB is stored in collections. If the collection exist we need to delete it.",ds,le,wn="In the next lines, we are creating the collection by calling the <code>create_collection</code> function in the <code>chroma_client</code> created above.",us,ne,fs,ae,yn="We are now ready to add the data to the collection using the <code>add</code> function. This function requires three key pieces of information:",js,ie,dn="<li>In the <strong>document</strong> we store the content of the <code>Answer</code> column in the Dataset.</li> <li>In <strong>metadatas</strong>, we can inform a list of topics. I used the value in the column <code>qtype</code>.</li> <li>In <strong>id</strong> we need to inform an unique identificator for each row. I’m creating the ID using the range of <code>MAX_ROWS</code>.</li>",Ts,oe,Js,re,un="Once we have the information in the Database we can query it, and ask for data that matches our needs. The search is done inside the content of the document, and it dosn’t look for the exact word, or phrase. The results will be based on the similarity between the search terms and the content of documents.",bs,ce,fn="Metadata isn’t directly involved in the initial search process, it can be used to filter or refine the results after retrieval, enabling further customization and precision.",Us,pe,jn="Let’s define a function to query the ChromaDB Database.",Is,he,Cs,me,gs,Me,Tn="To implement the cache system, we will use Faiss, a library that allows storing embeddings in memory. It’s quite similar to what Chroma does, but without its persistence.",vs,we,Jn="For this purpose, we will create a class called <code>semantic_cache</code> that will work with its own encoder and provide the necessary functions for the user to perform queries.",xs,ye,bn="In this class, we first query the cache implemented with Faiss, that contains the previous petitions, and if the returned results are above a specified threshold, it will return the content of the cache. Otherwise, it will fetch the result from the Chroma database.",As,de,Un="The cache is stored in a .json file.",Bs,ue,Zs,fe,Gs,je,In="The <code>init_cache()</code> function below initializes the semantic cache.",$s,Te,Cn="It employs the FlatLS index, which might not be the fastest but is ideal for small datasets. Depending on the characteristics of the data intended for the cache and the expected dataset size, another index such as HNSW or IVF could be utilized.",ks,Je,gn="I chose this index because it aligns well with the example. It can be used with vectors of high dimensions, consumes minimal memory, and performs well with small datasets.",Ws,be,vn="I outline the key features of the various indices available with Faiss.",Ns,Ue,xn="<li>FlatL2 or FlatIP. Well-suited for small datasets, it may not be the fastest, but its memory consumption is not excessive.</li> <li>LSH. It works effectively with small datasets and is recommended for use with vectors of up to 128 dimensions.</li> <li>HNSW. Very fast but demands a substantial amount of RAM.</li> <li>IVF. Works well with large datasets without consuming much memory or compromising performance.</li>",_s,Ie,An='More information about the different indices available with Faiss can be found at this link: <a href="https://github.com/facebookresearch/faiss/wiki/Guidelines-to-choose-an-index" rel="nofollow">https://github.com/facebookresearch/faiss/wiki/Guidelines-to-choose-an-index</a>',Rs,Ce,Ss,ge,Bn="In the <code>retrieve_cache</code> function, the .json file is retrieved from disk in case there is a need to reuse the cache across sessions.",Vs,ve,Ys,xe,Zn="The <code>store_cache</code> function saves the file containing the cache data to disk.",Es,Ae,zs,Be,Gn="These functions will be used within the <code>SemanticCache</code> class, which includes the search function and its initialization function.",Xs,Ze,$n="Even though the <code>ask</code> function has a substantial amount of code, its purpose is quite straightforward. It looks in the cache for the closest question to the one just made by the user.",Qs,Ge,kn="Afterward, checks if it is within the specified threshold. If positive, it directly returns the response from the cache; otherwise, it calls the <code>query_database</code> function to retrieve the data from ChromaDB.",Hs,$e,Wn="I’ve used Euclidean distance instead of Cosine, which is widely employed in vector comparisons. This choice is based on the fact that Euclidean distance is the default metric used by Faiss. Although Cosine distance can also be calculated, doing so adds complexity that may not significantly contribute to the final result.",Fs,ke,Nn="I have included FIFO eviction policy in the semantic_cache class, which aims to improve its efficiency and flexibility. By introducing eviction policies, we provide users with the ability to control how the cache behaves when it reaches its maximum capacity. This is crucial for maintaining optimal cache performance and for handling situations where the available memory is constrained.",qs,We,_n="Looking at the structure of the cache, the implementation of FIFO seemed straightforward. Whenever a new question-answer pair is added to the cache, it’s appended to the end of the lists. Thus, the oldest (first-in) items are at the front of the lists. When the cache reaches its maximum size and you need to evict an item, you remove (pop) the first item from each list. This is the FIFO eviction policy.",Ls,Ne,Rn="Another eviction policy is the Least Recently Used (LRU) policy, which is more complex because it requires knowledge of when each item in the cache was last accessed. However, this policy is not yet available and will be implemented later.",Ps,_e,Ds,Re,Ks,Se,Os,Ve,Sn=`Index trained
`,el,Ye,tl,Ee,Vn=`Answer recovered from ChromaDB. 
response_text: Summary : Shots may hurt a little, but the diseases they can prevent are a lot worse. Some are even life-threatening. Immunization shots, or vaccinations, are essential. They protect against things like measles, mumps, rubella, hepatitis B, polio, tetanus, diphtheria, and pertussis (whooping cough). Immunizations are important for adults as well as children.    Your immune system helps your body fight germs by producing substances to combat them. Once it does, the immune system "remembers" the germ and can fight it again. Vaccines contain germs that have been killed or weakened. When given to a healthy person, the vaccine triggers the immune system to respond and thus build immunity.     Before vaccines, people became immune only by actually getting a disease and surviving it. Immunizations are an easier and less risky way to become immune.     NIH: National Institute of Allergy and Infectious Diseases
Time taken: 0.057 seconds
`,sl,ze,Yn="As expected, this response has been obtained from ChromaDB. The class then stores it in the cache.",ll,Xe,En="Now, if we send a second question that is quite different, the response should also be retrieved from ChromaDB. This is because the question stored previously is so dissimilar that it would surpass the specified threshold in terms of Euclidean distance.",nl,Qe,al,He,zn=`Answer recovered from ChromaDB. 
response_text: Sydenham chorea (SD) is a neurological disorder of childhood resulting from infection via Group A beta-hemolytic streptococcus (GABHS), the bacterium that causes rheumatic fever. SD is characterized by rapid, irregular, and aimless involuntary movements of the arms and legs, trunk, and facial muscles. It affects girls more often than boys and typically occurs between 5 and 15 years of age. Some children will have a sore throat several weeks before the symptoms begin, but the disorder can also strike up to 6 months after the fever or infection has cleared. Symptoms can appear gradually or all at once, and also may include uncoordinated movements, muscular weakness, stumbling and falling, slurred speech, difficulty concentrating and writing, and emotional instability. The symptoms of SD can vary from a halting gait and slight grimacing to involuntary movements that are frequent and severe enough to be incapacitating. The random, writhing movements of chorea are caused by an auto-immune reaction to the bacterium that interferes with the normal function of a part of the brain (the basal ganglia) that controls motor movements. Due to better sanitary conditions and the use of antibiotics to treat streptococcal infections, rheumatic fever, and consequently SD, are rare in North America and Europe. The disease can still be found in developing nations.
Time taken: 0.082 seconds
`,il,Fe,Xn="Perfect, the semantic cache system is behaving as expected.",ol,qe,Qn="Let’s proceed to test it with a question very similar to the one we just asked.",rl,Le,Hn="In this case, the response should come directly from the cache without the need to access the ChromaDB database.",cl,Pe,pl,De,Fn=`Answer recovered from Cache. 
0.028 smaller than 0.35
Found cache in row: 1 with score 0.028
response_text: Sydenham chorea (SD) is a neurological disorder of childhood resulting from infection via Group A beta-hemolytic streptococcus (GABHS), the bacterium that causes rheumatic fever. SD is characterized by rapid, irregular, and aimless involuntary movements of the arms and legs, trunk, and facial muscles. It affects girls more often than boys and typically occurs between 5 and 15 years of age. Some children will have a sore throat several weeks before the symptoms begin, but the disorder can also strike up to 6 months after the fever or infection has cleared. Symptoms can appear gradually or all at once, and also may include uncoordinated movements, muscular weakness, stumbling and falling, slurred speech, difficulty concentrating and writing, and emotional instability. The symptoms of SD can vary from a halting gait and slight grimacing to involuntary movements that are frequent and severe enough to be incapacitating. The random, writhing movements of chorea are caused by an auto-immune reaction to the bacterium that interferes with the normal function of a part of the brain (the basal ganglia) that controls motor movements. Due to better sanitary conditions and the use of antibiotics to treat streptococcal infections, rheumatic fever, and consequently SD, are rare in North America and Europe. The disease can still be found in developing nations.
Time taken: 0.019 seconds
`,hl,Ke,qn="The two questions are so similar that their Euclidean distance is truly minimal, almost as if they were identical.",ml,Oe,Ln="Now, let’s try another question, this time a bit more distinct, and observe how the system behaves.",Ml,et,wl,tt,Pn=`Answer recovered from Cache. 
0.228 smaller than 0.35
Found cache in row: 1 with score 0.228
response_text: Sydenham chorea (SD) is a neurological disorder of childhood resulting from infection via Group A beta-hemolytic streptococcus (GABHS), the bacterium that causes rheumatic fever. SD is characterized by rapid, irregular, and aimless involuntary movements of the arms and legs, trunk, and facial muscles. It affects girls more often than boys and typically occurs between 5 and 15 years of age. Some children will have a sore throat several weeks before the symptoms begin, but the disorder can also strike up to 6 months after the fever or infection has cleared. Symptoms can appear gradually or all at once, and also may include uncoordinated movements, muscular weakness, stumbling and falling, slurred speech, difficulty concentrating and writing, and emotional instability. The symptoms of SD can vary from a halting gait and slight grimacing to involuntary movements that are frequent and severe enough to be incapacitating. The random, writhing movements of chorea are caused by an auto-immune reaction to the bacterium that interferes with the normal function of a part of the brain (the basal ganglia) that controls motor movements. Due to better sanitary conditions and the use of antibiotics to treat streptococcal infections, rheumatic fever, and consequently SD, are rare in North America and Europe. The disease can still be found in developing nations.
Time taken: 0.016 seconds
`,yl,st,Dn="We observe that the Euclidean distance has increased, but it still remains within the specified threshold. Therefore, it continues to return the response directly from the cache.",dl,lt,ul,nt,Kn='Time to use the library <strong>transformers</strong>, the most famous library from <a href="https://huggingface.co/" rel="nofollow">hugging face</a> for working with language models.',fl,at,On="We are importing:",jl,it,ea='<li><strong>Autotokenizer</strong>: It is a utility class for tokenizing text inputs that are compatible with various pre-trained language models.</li> <li><strong>AutoModelForCausalLM</strong>: it provides an interface to pre-trained language models specifically designed for language generation tasks using causal language modeling (e.g., GPT models), or the model used in this notebook <a href="https://huggingface.co/google/gemma-2b-it" rel="nofollow">Gemma-2b-it</a>.</li>',Tl,ot,ta='Please, feel free to test <a href="https://huggingface.co/models?pipeline_tag=text-generation&amp;sort=trending" rel="nofollow">different Models</a>, you need to search for NLP models trained for text-generation.',Jl,rt,bl,ct,Ul,pt,Il,ht,Cl,mt,sa="To create the prompt we use the result from query the ‘semantic_cache’ class  and the question introduced by the user.",gl,Mt,la="The prompt have two parts, the <strong>relevant context</strong> that is the information recovered from the database and the <strong>user’s question</strong>.",vl,wt,na="We only need to put the two parts together to create the prompt then send it to the model.",xl,yt,Al,dt,Bl,ut,aa="Now all that remains is to send the prompt to the model and wait for its response!",Zl,ft,Gl,jt,ia=`<bos>Relevant context: Sydenham chorea (SD) is a neurological disorder of childhood resulting from infection via Group A beta-hemolytic streptococcus (GABHS), the bacterium that causes rheumatic fever. SD is characterized by rapid, irregular, and aimless involuntary movements of the arms and legs, trunk, and facial muscles. It affects girls more often than boys and typically occurs between 5 and 15 years of age. Some children will have a sore throat several weeks before the symptoms begin, but the disorder can also strike up to 6 months after the fever or infection has cleared. Symptoms can appear gradually or all at once, and also may include uncoordinated movements, muscular weakness, stumbling and falling, slurred speech, difficulty concentrating and writing, and emotional instability. The symptoms of SD can vary from a halting gait and slight grimacing to involuntary movements that are frequent and severe enough to be incapacitating. The random, writhing movements of chorea are caused by an auto-immune reaction to the bacterium that interferes with the normal function of a part of the brain (the basal ganglia) that controls motor movements. Due to better sanitary conditions and the use of antibiotics to treat streptococcal infections, rheumatic fever, and consequently SD, are rare in North America and Europe. The disease can still be found in developing nations.

 The user&#39;s question: Write in 20 words what is a Sydenham chorea.

Sure, here is a 20-word answer:

Sydenham chorea is a neurological disorder of childhood resulting from infection via Group A beta-hemolytic streptococcus (GABHS).<eos>
</eos></bos>`,$l,Tt,kl,Jt,oa="There’s a 50% reduction in data retrieval time between accessing ChromaDB and going directly to the cache. However, in larger projects, this difference increases, leading to enhancements of 90-95%.",Wl,bt,ra="We have very few data in Chroma, and only a single instance of the cache class. Typically, the data behind the cache system is much larger, possibly involving more than just a query to a vector database but sourced from various places.",Nl,Ut,ca="It’s common to have multiple instances of the cache class, usually based on user typology, as questions tend to repeat more among users who share common traits.",_l,It,pa="In summary, we have created a very simple RAG (Retrieval-Augmented Generation) system and enhanced it with a semantic cache layer between the user’s question and obtaining the information necessary to create the enriched prompt.",Rl,Ct,Sl,xt,Vl;return f=new Ja({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/semantic_cache_chroma_vector_database.ipynb"}]}}),j=new Ta({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new d({props:{title:"Implementing semantic cache to improve a RAG system with FAISS.",local:"implementing-semantic-cache-to-improve-a-rag-system-with-faiss",headingTag:"h1"}}),N=new d({props:{title:"Import and load the libraries.",local:"import-and-load-the-libraries",headingTag:"h1"}}),S=new y({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHRyYW5zZm9ybWVycyUzRCUzRDQuMzguMSUwQSFwaXAlMjBpbnN0YWxsJTIwLXElMjBhY2NlbGVyYXRlJTNEJTNEMC4yNy4yJTBBIXBpcCUyMGluc3RhbGwlMjAtcSUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUzRCUzRDIuNS4xJTBBIXBpcCUyMGluc3RhbGwlMjAtcSUyMHhmb3JtZXJzJTNEJTNEMC4wLjI0JTBBIXBpcCUyMGluc3RhbGwlMjAtcSUyMGNocm9tYWRiJTNEJTNEMC40LjI0JTBBIXBpcCUyMGluc3RhbGwlMjAtcSUyMGRhdGFzZXRzJTNEJTNEMi4xNy4x",highlighted:`!pip install -q transformers==<span class="hljs-number">4.38</span><span class="hljs-number">.1</span>
!pip install -q accelerate==<span class="hljs-number">0.27</span><span class="hljs-number">.2</span>
!pip install -q sentence-transformers==<span class="hljs-number">2.5</span><span class="hljs-number">.1</span>
!pip install -q xformers==<span class="hljs-number">0.0</span><span class="hljs-number">.24</span>
!pip install -q chromadb==<span class="hljs-number">0.4</span><span class="hljs-number">.24</span>
!pip install -q datasets==<span class="hljs-number">2.17</span><span class="hljs-number">.1</span>`,wrap:!1}}),V=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZA==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd`,wrap:!1}}),Y=new d({props:{title:"Load the Dataset",local:"load-the-dataset",headingTag:"h1"}}),z=new y({props:{code:"JTIzTG9naW4lMjB0byUyMEh1Z2dpbmclMjBGYWNlLiUyMEl0JTIwaXMlMjBtYW5kYXRvcnklMjB0byUyMHVzZSUyMHRoZSUyMEdlbW1hJTIwTW9kZWwlMkMlMEElMjNhbmQlMjByZWNvbW1lbmRlZCUyMHRvJTIwYWNjZXMlMjBwdWJsaWMlMjBtb2RlbHMlMjBhbmQlMjBEYXRhc2V0cy4lMEFmcm9tJTIwZ2V0cGFzcyUyMGltcG9ydCUyMGdldHBhc3MlMEFpZiUyMCdoZl9rZXknJTIwbm90JTIwaW4lMjBsb2NhbHMoKSUzQSUwQSUyMCUyMGhmX2tleSUyMCUzRCUyMGdldHBhc3MoJTIyWW91ciUyMEh1Z2dpbmclMjBGYWNlJTIwQVBJJTIwS2V5JTNBJTIwJTIyKSUwQSFodWdnaW5nZmFjZS1jbGklMjBsb2dpbiUyMC0tdG9rZW4lMjAlMjRoZl9rZXk=",highlighted:`<span class="hljs-comment">#Login to Hugging Face. It is mandatory to use the Gemma Model,</span>
<span class="hljs-comment">#and recommended to acces public models and Datasets.</span>
<span class="hljs-keyword">from</span> getpass <span class="hljs-keyword">import</span> getpass
<span class="hljs-keyword">if</span> <span class="hljs-string">&#x27;hf_key&#x27;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> <span class="hljs-built_in">locals</span>():
  hf_key = getpass(<span class="hljs-string">&quot;Your Hugging Face API Key: &quot;</span>)
!huggingface-cli login --token $hf_key`,wrap:!1}}),X=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YSUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJrZWl2YWx5YSUyRk1lZFF1YWQtTWVkaWNhbFFuQURhdGFzZXQlMjIlMkMlMjBzcGxpdCUzRCd0cmFpbicp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

data = load_dataset(<span class="hljs-string">&quot;keivalya/MedQuad-MedicalQnADataset&quot;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>)`,wrap:!1}}),H=new y({props:{code:"ZGF0YSUyMCUzRCUyMGRhdGEudG9fcGFuZGFzKCklMEFkYXRhJTVCJTIyaWQlMjIlNUQlM0RkYXRhLmluZGV4JTBBZGF0YS5oZWFkKDEwKQ==",highlighted:`data = data.to_pandas()
data[<span class="hljs-string">&quot;id&quot;</span>]=data.index
data.head(<span class="hljs-number">10</span>)`,wrap:!1}}),F=new y({props:{code:"TUFYX1JPV1MlMjAlM0QlMjAxNTAwMCUwQURPQ1VNRU5UJTNEJTIyQW5zd2VyJTIyJTBBVE9QSUMlM0QlMjJxdHlwZSUyMg==",highlighted:`MAX_ROWS = <span class="hljs-number">15000</span>
DOCUMENT=<span class="hljs-string">&quot;Answer&quot;</span>
TOPIC=<span class="hljs-string">&quot;qtype&quot;</span>`,wrap:!1}}),q=new y({props:{code:"JTIzQmVjYXVzZSUyMGl0JTIwaXMlMjBqdXN0JTIwYSUyMHNhbXBsZSUyMHdlJTIwc2VsZWN0JTIwYSUyMHNtYWxsJTIwcG9ydGlvbiUyMG9mJTIwTmV3cy4lMEFzdWJzZXRfZGF0YSUyMCUzRCUyMGRhdGEuaGVhZChNQVhfUk9XUyk=",highlighted:`<span class="hljs-comment">#Because it is just a sample we select a small portion of News.</span>
subset_data = data.head(MAX_ROWS)`,wrap:!1}}),L=new d({props:{title:"Import and configure the Vector Database",local:"import-and-configure-the-vector-database",headingTag:"h1"}}),K=new y({props:{code:"aW1wb3J0JTIwY2hyb21hZGI=",highlighted:'<span class="hljs-keyword">import</span> chromadb',wrap:!1}}),ee=new y({props:{code:"Y2hyb21hX2NsaWVudCUyMCUzRCUyMGNocm9tYWRiLlBlcnNpc3RlbnRDbGllbnQocGF0aCUzRCUyMiUyRnBhdGglMkZ0byUyRnBlcnNpc3QlMkZkaXJlY3RvcnklMjIp",highlighted:'chroma_client = chromadb.PersistentClient(path=<span class="hljs-string">&quot;/path/to/persist/directory&quot;</span>)',wrap:!1}}),te=new d({props:{title:"Filling and Querying the ChromaDB Database",local:"filling-and-querying-the-chromadb-database",headingTag:"h1"}}),ne=new y({props:{code:"Y29sbGVjdGlvbl9uYW1lJTIwJTNEJTIwJTIybmV3c19jb2xsZWN0aW9uJTIyJTBBaWYlMjBsZW4oY2hyb21hX2NsaWVudC5saXN0X2NvbGxlY3Rpb25zKCkpJTIwJTNFJTIwMCUyMGFuZCUyMGNvbGxlY3Rpb25fbmFtZSUyMGluJTIwJTVCY2hyb21hX2NsaWVudC5saXN0X2NvbGxlY3Rpb25zKCklNUIwJTVELm5hbWUlNUQlM0ElMEElMjAlMjAlMjAlMjBjaHJvbWFfY2xpZW50LmRlbGV0ZV9jb2xsZWN0aW9uKG5hbWUlM0Rjb2xsZWN0aW9uX25hbWUpJTBBJTBBY29sbGVjdGlvbiUyMCUzRCUyMGNocm9tYV9jbGllbnQuY3JlYXRlX2NvbGxlY3Rpb24obmFtZSUzRGNvbGxlY3Rpb25fbmFtZSk=",highlighted:`collection_name = <span class="hljs-string">&quot;news_collection&quot;</span>
<span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(chroma_client.list_collections()) &gt; <span class="hljs-number">0</span> <span class="hljs-keyword">and</span> collection_name <span class="hljs-keyword">in</span> [chroma_client.list_collections()[<span class="hljs-number">0</span>].name]:
    chroma_client.delete_collection(name=collection_name)

collection = chroma_client.create_collection(name=collection_name)`,wrap:!1}}),oe=new y({props:{code:"Y29sbGVjdGlvbi5hZGQoJTBBJTIwJTIwJTIwJTIwZG9jdW1lbnRzJTNEc3Vic2V0X2RhdGElNUJET0NVTUVOVCU1RC50b2xpc3QoKSUyQyUwQSUyMCUyMCUyMCUyMG1ldGFkYXRhcyUzRCU1QiU3QlRPUElDJTNBJTIwdG9waWMlN0QlMjBmb3IlMjB0b3BpYyUyMGluJTIwc3Vic2V0X2RhdGElNUJUT1BJQyU1RC50b2xpc3QoKSU1RCUyQyUwQSUyMCUyMCUyMCUyMGlkcyUzRCU1QmYlMjJpZCU3QnglN0QlMjIlMjBmb3IlMjB4JTIwaW4lMjByYW5nZShNQVhfUk9XUyklNUQlMkMlMEEp",highlighted:`collection.add(
    documents=subset_data[DOCUMENT].tolist(),
    metadatas=[{TOPIC: topic} <span class="hljs-keyword">for</span> topic <span class="hljs-keyword">in</span> subset_data[TOPIC].tolist()],
    ids=[<span class="hljs-string">f&quot;id<span class="hljs-subst">{x}</span>&quot;</span> <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(MAX_ROWS)],
)`,wrap:!1}}),he=new y({props:{code:"ZGVmJTIwcXVlcnlfZGF0YWJhc2UocXVlcnlfdGV4dCUyQyUyMG5fcmVzdWx0cyUzRDEwKSUzQSUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjBjb2xsZWN0aW9uLnF1ZXJ5KHF1ZXJ5X3RleHRzJTNEcXVlcnlfdGV4dCUyQyUyMG5fcmVzdWx0cyUzRG5fcmVzdWx0cyUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXN1bHRz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">query_database</span>(<span class="hljs-params">query_text, n_results=<span class="hljs-number">10</span></span>):
    results = collection.query(query_texts=query_text, n_results=n_results )
    <span class="hljs-keyword">return</span> results`,wrap:!1}}),me=new d({props:{title:"Creating the semantic cache system",local:"creating-the-semantic-cache-system",headingTag:"h2"}}),ue=new y({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGZhaXNzLWNwdSUzRCUzRDEuOC4w",highlighted:'!pip install -q faiss-cpu==<span class="hljs-number">1.8</span><span class="hljs-number">.0</span>',wrap:!1}}),fe=new y({props:{code:"aW1wb3J0JTIwZmFpc3MlMEFmcm9tJTIwc2VudGVuY2VfdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwU2VudGVuY2VUcmFuc2Zvcm1lciUwQWltcG9ydCUyMHRpbWUlMEFpbXBvcnQlMjBqc29u",highlighted:`<span class="hljs-keyword">import</span> faiss
<span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> SentenceTransformer
<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> json`,wrap:!1}}),Ce=new y({props:{code:"ZGVmJTIwaW5pdF9jYWNoZSgpJTNBJTBBJTIwJTIwaW5kZXglMjAlM0QlMjBmYWlzcy5JbmRleEZsYXRMMig3NjgpJTBBJTIwJTIwaWYlMjBpbmRleC5pc190cmFpbmVkJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJ0luZGV4JTIwdHJhaW5lZCcpJTBBJTBBJTIwJTIwJTIzJTIwSW5pdGlhbGl6ZSUyMFNlbnRlbmNlJTIwVHJhbnNmb3JtZXIlMjBtb2RlbCUwQSUyMCUyMGVuY29kZXIlMjAlM0QlMjBTZW50ZW5jZVRyYW5zZm9ybWVyKCdhbGwtbXBuZXQtYmFzZS12MicpJTBBJTBBJTIwJTIwcmV0dXJuJTIwaW5kZXglMkMlMjBlbmNvZGVy",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">init_cache</span>():
  index = faiss.IndexFlatL2(<span class="hljs-number">768</span>)
  <span class="hljs-keyword">if</span> index.is_trained:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;Index trained&#x27;</span>)

  <span class="hljs-comment"># Initialize Sentence Transformer model</span>
  encoder = SentenceTransformer(<span class="hljs-string">&#x27;all-mpnet-base-v2&#x27;</span>)

  <span class="hljs-keyword">return</span> index, encoder`,wrap:!1}}),ve=new y({props:{code:"ZGVmJTIwcmV0cmlldmVfY2FjaGUoanNvbl9maWxlKSUzQSUwQSUyMCUyMHRyeSUzQSUwQSUyMCUyMCUyMCUyMHdpdGglMjBvcGVuKGpzb25fZmlsZSUyQyUyMCdyJyklMjBhcyUyMGZpbGUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjBjYWNoZSUyMCUzRCUyMGpzb24ubG9hZChmaWxlKSUwQSUyMCUyMGV4Y2VwdCUyMEZpbGVOb3RGb3VuZEVycm9yJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwY2FjaGUlMjAlM0QlMjAlN0IncXVlc3Rpb25zJyUzQSUyMCU1QiU1RCUyQyUyMCdlbWJlZGRpbmdzJyUzQSUyMCU1QiU1RCUyQyUyMCdhbnN3ZXJzJyUzQSUyMCU1QiU1RCUyQyUyMCdyZXNwb25zZV90ZXh0JyUzQSUyMCU1QiU1RCU3RCUwQSUwQSUyMCUyMHJldHVybiUyMGNhY2hl",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">retrieve_cache</span>(<span class="hljs-params">json_file</span>):
  <span class="hljs-keyword">try</span>:
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(json_file, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> file:
      cache = json.load(file)
  <span class="hljs-keyword">except</span> FileNotFoundError:
      cache = {<span class="hljs-string">&#x27;questions&#x27;</span>: [], <span class="hljs-string">&#x27;embeddings&#x27;</span>: [], <span class="hljs-string">&#x27;answers&#x27;</span>: [], <span class="hljs-string">&#x27;response_text&#x27;</span>: []}

  <span class="hljs-keyword">return</span> cache`,wrap:!1}}),Ae=new y({props:{code:"ZGVmJTIwc3RvcmVfY2FjaGUoanNvbl9maWxlJTJDJTIwY2FjaGUpJTNBJTBBJTIwJTIwd2l0aCUyMG9wZW4oanNvbl9maWxlJTJDJTIwJ3cnKSUyMGFzJTIwZmlsZSUzQSUwQSUyMCUyMCUyMCUyMGpzb24uZHVtcChjYWNoZSUyQyUyMGZpbGUp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">store_cache</span>(<span class="hljs-params">json_file, cache</span>):
  <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(json_file, <span class="hljs-string">&#x27;w&#x27;</span>) <span class="hljs-keyword">as</span> file:
    json.dump(cache, file)`,wrap:!1}}),_e=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">semantic_cache</span>:
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, json_file=<span class="hljs-string">&quot;cache_file.json&quot;</span>, thresold=<span class="hljs-number">0.35</span>, max_response=<span class="hljs-number">100</span>, eviction_policy=<span class="hljs-literal">None</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;Initializes the semantic cache.

    Args:
    json_file (str): The name of the JSON file where the cache is stored.
    thresold (float): The threshold for the Euclidean distance to determine if a question is similar.
    max_response (int): The maximum number of responses the cache can store.
    eviction_policy (str): The policy for evicting items from the cache. 
                            This can be any policy, but &#x27;FIFO&#x27; (First In First Out) has been implemented for now.
                            If None, no eviction policy will be applied.
    &quot;&quot;&quot;</span>
       
    <span class="hljs-comment"># Initialize Faiss index with Euclidean distance</span>
    self.index, self.encoder = init_cache()

    <span class="hljs-comment"># Set Euclidean distance threshold</span>
    <span class="hljs-comment"># a distance of 0 means identicals sentences</span>
    <span class="hljs-comment"># We only return from cache sentences under this thresold</span>
    self.euclidean_threshold = thresold

    self.json_file = json_file
    self.cache = retrieve_cache(self.json_file)
    self.max_response = max_response
    self.eviction_policy = eviction_policy

  <span class="hljs-keyword">def</span> <span class="hljs-title function_">evict</span>(<span class="hljs-params">self</span>):

    <span class="hljs-string">&quot;&quot;&quot;Evicts an item from the cache based on the eviction policy.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> self.eviction_policy <span class="hljs-keyword">and</span> <span class="hljs-built_in">len</span>(self.cache[<span class="hljs-string">&quot;questions&quot;</span>]) &gt; self.max_size:
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>((<span class="hljs-built_in">len</span>(self.cache[<span class="hljs-string">&quot;questions&quot;</span>]) - self.max_response)):
            <span class="hljs-keyword">if</span> self.eviction_policy == <span class="hljs-string">&#x27;FIFO&#x27;</span>:
                self.cache[<span class="hljs-string">&quot;questions&quot;</span>].pop(<span class="hljs-number">0</span>)
                self.cache[<span class="hljs-string">&quot;embeddings&quot;</span>].pop(<span class="hljs-number">0</span>)
                self.cache[<span class="hljs-string">&quot;answers&quot;</span>].pop(<span class="hljs-number">0</span>)
                self.cache[<span class="hljs-string">&quot;response_text&quot;</span>].pop(<span class="hljs-number">0</span>)

  <span class="hljs-keyword">def</span> <span class="hljs-title function_">ask</span>(<span class="hljs-params">self, question: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
      <span class="hljs-comment"># Method to retrieve an answer from the cache or generate a new one</span>
      start_time = time.time()
      <span class="hljs-keyword">try</span>:
          <span class="hljs-comment">#First we obtain the embeddings corresponding to the user question</span>
          embedding = self.encoder.encode([question])

          <span class="hljs-comment"># Search for the nearest neighbor in the index</span>
          self.index.nprobe = <span class="hljs-number">8</span>
          D, I = self.index.search(embedding, <span class="hljs-number">1</span>)

          <span class="hljs-keyword">if</span> D[<span class="hljs-number">0</span>] &gt;= <span class="hljs-number">0</span>:
              <span class="hljs-keyword">if</span> I[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>] &gt;= <span class="hljs-number">0</span> <span class="hljs-keyword">and</span> D[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>] &lt;= self.euclidean_threshold:
                  row_id = <span class="hljs-built_in">int</span>(I[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>])

                  <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;Answer recovered from Cache. &#x27;</span>)
                  <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;<span class="hljs-subst">{D[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>]:<span class="hljs-number">.3</span>f}</span> smaller than <span class="hljs-subst">{self.euclidean_threshold}</span>&#x27;</span>)
                  <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Found cache in row: <span class="hljs-subst">{row_id}</span> with score <span class="hljs-subst">{D[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>]:<span class="hljs-number">.3</span>f}</span>&#x27;</span>)
                  <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;response_text: &#x27;</span> + self.cache[<span class="hljs-string">&#x27;response_text&#x27;</span>][row_id])

                  end_time = time.time()
                  elapsed_time = end_time - start_time
                  <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Time taken: <span class="hljs-subst">{elapsed_time:<span class="hljs-number">.3</span>f}</span> seconds&quot;</span>)
                  <span class="hljs-keyword">return</span> self.cache[<span class="hljs-string">&#x27;response_text&#x27;</span>][row_id]

          <span class="hljs-comment"># Handle the case when there are not enough results</span>
          <span class="hljs-comment"># or Euclidean distance is not met, asking to chromaDB.</span>
          answer  = query_database([question], <span class="hljs-number">1</span>)
          response_text = answer[<span class="hljs-string">&#x27;documents&#x27;</span>][<span class="hljs-number">0</span>][<span class="hljs-number">0</span>]

          self.cache[<span class="hljs-string">&#x27;questions&#x27;</span>].append(question)
          self.cache[<span class="hljs-string">&#x27;embeddings&#x27;</span>].append(embedding[<span class="hljs-number">0</span>].tolist())
          self.cache[<span class="hljs-string">&#x27;answers&#x27;</span>].append(answer)
          self.cache[<span class="hljs-string">&#x27;response_text&#x27;</span>].append(response_text)

          <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;Answer recovered from ChromaDB. &#x27;</span>)
          <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;response_text: <span class="hljs-subst">{response_text}</span>&#x27;</span>)

          self.index.add(embedding)

          self.evict()

          store_cache(self.json_file, self.cache)
          
          end_time = time.time()
          elapsed_time = end_time - start_time
          <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Time taken: <span class="hljs-subst">{elapsed_time:<span class="hljs-number">.3</span>f}</span> seconds&quot;</span>)

          <span class="hljs-keyword">return</span> response_text
      <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
          <span class="hljs-keyword">raise</span> RuntimeError(<span class="hljs-string">f&quot;Error during &#x27;ask&#x27; method: <span class="hljs-subst">{e}</span>&quot;</span>)`,wrap:!1}}),Re=new d({props:{title:"Testing the semantic_cache class.",local:"testing-the-semanticcache-class",headingTag:"h3"}}),Se=new y({props:{code:"JTIzJTIwSW5pdGlhbGl6ZSUyMHRoZSUyMGNhY2hlLiUwQWNhY2hlJTIwJTNEJTIwc2VtYW50aWNfY2FjaGUoJzRjYWNoZS5qc29uJyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize the cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cache = semantic_cache(<span class="hljs-string">&#x27;4cache.json&#x27;</span>)`,wrap:!1}}),Ye=new y({props:{code:"cmVzdWx0cyUyMCUzRCUyMGNhY2hlLmFzayglMjJIb3clMjBkbyUyMHZhY2NpbmVzJTIwd29yayUzRiUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>results = cache.ask(<span class="hljs-string">&quot;How do vaccines work?&quot;</span>)',wrap:!1}}),Qe=new y({props:{code:"cmVzdWx0cyUyMCUzRCUyMGNhY2hlLmFzayglMjJFeHBsYWluJTIwYnJpZWZseSUyMHdoYXQlMjBpcyUyMGElMjBTeWRlbmhhbSUyMGNob3JlYSUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>results = cache.ask(<span class="hljs-string">&quot;Explain briefly what is a Sydenham chorea&quot;</span>)',wrap:!1}}),Pe=new y({props:{code:"cmVzdWx0cyUyMCUzRCUyMGNhY2hlLmFzayglMjJCcmllZmx5JTIwZXhwbGFpbiUyMG1lJTIwd2hhdCUyMGlzJTIwYSUyMFN5ZGVuaGFtJTIwY2hvcmVhLiUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>results = cache.ask(<span class="hljs-string">&quot;Briefly explain me what is a Sydenham chorea.&quot;</span>)',wrap:!1}}),et=new y({props:{code:"cXVlc3Rpb25fZGVmJTIwJTNEJTIwJTIyV3JpdGUlMjBpbiUyMDIwJTIwd29yZHMlMjB3aGF0JTIwaXMlMjBhJTIwU3lkZW5oYW0lMjBjaG9yZWEuJTIyJTBBcmVzdWx0cyUyMCUzRCUyMGNhY2hlLmFzayhxdWVzdGlvbl9kZWYp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>question_def = <span class="hljs-string">&quot;Write in 20 words what is a Sydenham chorea.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>results = cache.ask(question_def)`,wrap:!1}}),lt=new d({props:{title:"Loading the model and creating the prompt",local:"loading-the-model-and-creating-the-prompt",headingTag:"h1"}}),rt=new y({props:{code:"IXBpcCUyMGluc3RhbGwlMjB0b3JjaA==",highlighted:"!pip install torch",wrap:!1}}),ct=new y({props:{code:"ZnJvbSUyMHRvcmNoJTIwaW1wb3J0JTIwY3VkYSUyQyUyMHRvcmNoJTBBJTIzSW4lMjBhJTIwTUFDJTIwU2lsaWNvbiUyMHRoZSUyMGRldmljZSUyMG11c3QlMjBiZSUyMCdtcHMnJTBBJTIzJTIwZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCdtcHMnKSUyMCUyM3RvJTIwdXNlJTIwd2l0aCUyME1BQyUyMFNpbGljb24lMEFkZXZpY2UlMjAlM0QlMjBmJ2N1ZGElM0ElN0JjdWRhLmN1cnJlbnRfZGV2aWNlKCklN0QnJTIwaWYlMjBjdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCdjcHUn",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> cuda, torch
<span class="hljs-comment">#In a MAC Silicon the device must be &#x27;mps&#x27;</span>
<span class="hljs-comment"># device = torch.device(&#x27;mps&#x27;) #to use with MAC Silicon</span>
device = <span class="hljs-string">f&#x27;cuda:<span class="hljs-subst">{cuda.current_device()}</span>&#x27;</span> <span class="hljs-keyword">if</span> cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;cpu&#x27;</span>`,wrap:!1}}),pt=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyZ29vZ2xlJTJGZ2VtbWEtMmItaXQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJjdWRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

model_id = <span class="hljs-string">&quot;google/gemma-2b-it&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
model = AutoModelForCausalLM.from_pretrained(model_id,
                                             device_map=<span class="hljs-string">&quot;cuda&quot;</span>,
                                            torch_dtype=torch.bfloat16)`,wrap:!1}}),ht=new d({props:{title:"Creating the extended prompt",local:"creating-the-extended-prompt",headingTag:"h2"}}),yt=new y({props:{code:"cHJvbXB0X3RlbXBsYXRlJTIwJTNEJTIwZiUyMlJlbGV2YW50JTIwY29udGV4dCUzQSUyMCU3QnJlc3VsdHMlN0QlNUNuJTVDbiUyMFRoZSUyMHVzZXIncyUyMHF1ZXN0aW9uJTNBJTIwJTdCcXVlc3Rpb25fZGVmJTdEJTIyJTBBcHJvbXB0X3RlbXBsYXRl",highlighted:`prompt_template = <span class="hljs-string">f&quot;Relevant context: <span class="hljs-subst">{results}</span>\\n\\n The user&#x27;s question: <span class="hljs-subst">{question_def}</span>&quot;</span>
prompt_template`,wrap:!1}}),dt=new y({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdF90ZW1wbGF0ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIp",highlighted:'input_ids = tokenizer(prompt_template, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)',wrap:!1}}),ft=new y({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRfaWRzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXRzJTVCMCU1RCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**input_ids,
<span class="hljs-meta">... </span>                         max_new_tokens=<span class="hljs-number">256</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>]))`,wrap:!1}}),Tt=new d({props:{title:"Conclusion.",local:"conclusion",headingTag:"h1"}}),Ct=new ba({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/semantic_cache_chroma_vector_database.md"}}),{c(){u=i("meta"),At=n(),vt=i("p"),Bt=n(),c(f.$$.fragment),Zt=n(),c(j.$$.fragment),Gt=n(),c(T.$$.fragment),$t=n(),J=i("p"),J.innerHTML=zl,kt=n(),b=i("p"),b.innerHTML=Xl,Wt=n(),U=i("p"),U.textContent=Ql,Nt=n(),I=i("p"),I.textContent=Hl,_t=n(),C=i("p"),C.innerHTML=Fl,Rt=n(),g=i("p"),g.textContent=ql,St=n(),gt=i("img"),Vt=n(),v=i("p"),v.textContent=Pl,Yt=n(),x=i("p"),x.textContent=Dl,Et=n(),A=i("p"),A.textContent=Kl,zt=n(),B=i("p"),B.textContent=Ol,Xt=n(),Z=i("ul"),Z.innerHTML=en,Qt=n(),G=i("p"),G.textContent=tn,Ht=n(),$=i("p"),$.textContent=sn,Ft=n(),k=i("p"),k.textContent=ln,qt=n(),W=i("p"),W.textContent=nn,Lt=n(),c(N.$$.fragment),Pt=n(),_=i("p"),_.textContent=an,Dt=n(),R=i("ul"),R.innerHTML=on,Kt=n(),c(S.$$.fragment),Ot=n(),c(V.$$.fragment),es=n(),c(Y.$$.fragment),ts=n(),E=i("p"),E.innerHTML=rn,ss=n(),c(z.$$.fragment),ls=n(),c(X.$$.fragment),ns=n(),Q=i("p"),Q.innerHTML=cn,as=n(),c(H.$$.fragment),is=n(),c(F.$$.fragment),os=n(),c(q.$$.fragment),rs=n(),c(L.$$.fragment),cs=n(),P=i("p"),P.textContent=pn,ps=n(),D=i("p"),D.textContent=hn,hs=n(),c(K.$$.fragment),ms=n(),O=i("p"),O.textContent=mn,Ms=n(),c(ee.$$.fragment),ws=n(),c(te.$$.fragment),ys=n(),se=i("p"),se.textContent=Mn,ds=n(),le=i("p"),le.innerHTML=wn,us=n(),c(ne.$$.fragment),fs=n(),ae=i("p"),ae.innerHTML=yn,js=n(),ie=i("ul"),ie.innerHTML=dn,Ts=n(),c(oe.$$.fragment),Js=n(),re=i("p"),re.textContent=un,bs=n(),ce=i("p"),ce.textContent=fn,Us=n(),pe=i("p"),pe.textContent=jn,Is=n(),c(he.$$.fragment),Cs=n(),c(me.$$.fragment),gs=n(),Me=i("p"),Me.textContent=Tn,vs=n(),we=i("p"),we.innerHTML=Jn,xs=n(),ye=i("p"),ye.textContent=bn,As=n(),de=i("p"),de.textContent=Un,Bs=n(),c(ue.$$.fragment),Zs=n(),c(fe.$$.fragment),Gs=n(),je=i("p"),je.innerHTML=In,$s=n(),Te=i("p"),Te.textContent=Cn,ks=n(),Je=i("p"),Je.textContent=gn,Ws=n(),be=i("p"),be.textContent=vn,Ns=n(),Ue=i("ul"),Ue.innerHTML=xn,_s=n(),Ie=i("p"),Ie.innerHTML=An,Rs=n(),c(Ce.$$.fragment),Ss=n(),ge=i("p"),ge.innerHTML=Bn,Vs=n(),c(ve.$$.fragment),Ys=n(),xe=i("p"),xe.innerHTML=Zn,Es=n(),c(Ae.$$.fragment),zs=n(),Be=i("p"),Be.innerHTML=Gn,Xs=n(),Ze=i("p"),Ze.innerHTML=$n,Qs=n(),Ge=i("p"),Ge.innerHTML=kn,Hs=n(),$e=i("p"),$e.textContent=Wn,Fs=n(),ke=i("p"),ke.textContent=Nn,qs=n(),We=i("p"),We.textContent=_n,Ls=n(),Ne=i("p"),Ne.textContent=Rn,Ps=n(),c(_e.$$.fragment),Ds=n(),c(Re.$$.fragment),Ks=n(),c(Se.$$.fragment),Os=n(),Ve=i("pre"),Ve.textContent=Sn,el=n(),c(Ye.$$.fragment),tl=n(),Ee=i("pre"),Ee.textContent=Vn,sl=n(),ze=i("p"),ze.textContent=Yn,ll=n(),Xe=i("p"),Xe.textContent=En,nl=n(),c(Qe.$$.fragment),al=n(),He=i("pre"),He.textContent=zn,il=n(),Fe=i("p"),Fe.textContent=Xn,ol=n(),qe=i("p"),qe.textContent=Qn,rl=n(),Le=i("p"),Le.textContent=Hn,cl=n(),c(Pe.$$.fragment),pl=n(),De=i("pre"),De.textContent=Fn,hl=n(),Ke=i("p"),Ke.textContent=qn,ml=n(),Oe=i("p"),Oe.textContent=Ln,Ml=n(),c(et.$$.fragment),wl=n(),tt=i("pre"),tt.textContent=Pn,yl=n(),st=i("p"),st.textContent=Dn,dl=n(),c(lt.$$.fragment),ul=n(),nt=i("p"),nt.innerHTML=Kn,fl=n(),at=i("p"),at.textContent=On,jl=n(),it=i("ul"),it.innerHTML=ea,Tl=n(),ot=i("p"),ot.innerHTML=ta,Jl=n(),c(rt.$$.fragment),bl=n(),c(ct.$$.fragment),Ul=n(),c(pt.$$.fragment),Il=n(),c(ht.$$.fragment),Cl=n(),mt=i("p"),mt.textContent=sa,gl=n(),Mt=i("p"),Mt.innerHTML=la,vl=n(),wt=i("p"),wt.textContent=na,xl=n(),c(yt.$$.fragment),Al=n(),c(dt.$$.fragment),Bl=n(),ut=i("p"),ut.textContent=aa,Zl=n(),c(ft.$$.fragment),Gl=n(),jt=i("pre"),jt.innerHTML=ia,$l=n(),c(Tt.$$.fragment),kl=n(),Jt=i("p"),Jt.textContent=oa,Wl=n(),bt=i("p"),bt.textContent=ra,Nl=n(),Ut=i("p"),Ut.textContent=ca,_l=n(),It=i("p"),It.textContent=pa,Rl=n(),c(Ct.$$.fragment),Sl=n(),xt=i("p"),this.h()},l(e){const t=fa("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(s),At=a(e),vt=o(e,"P",{}),ha(vt).forEach(s),Bt=a(e),p(f.$$.fragment,e),Zt=a(e),p(j.$$.fragment,e),Gt=a(e),p(T.$$.fragment,e),$t=a(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-ighhqz"&&(J.innerHTML=zl),kt=a(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-ydrdum"&&(b.innerHTML=Xl),Wt=a(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1ci1eds"&&(U.textContent=Ql),Nt=a(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-5pgs5c"&&(I.textContent=Hl),_t=a(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1dk0w68"&&(C.innerHTML=Fl),Rt=a(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-cppufu"&&(g.textContent=ql),St=a(e),gt=o(e,"IMG",{src:!0}),Vt=a(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1uya4d0"&&(v.textContent=Pl),Yt=a(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1y3an9l"&&(x.textContent=Dl),Et=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-17nn2tu"&&(A.textContent=Kl),zt=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1g6n4rl"&&(B.textContent=Ol),Xt=a(e),Z=o(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-4taq2a"&&(Z.innerHTML=en),Qt=a(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-hn5gp7"&&(G.textContent=tn),Ht=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-j8wl7v"&&($.textContent=sn),Ft=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1ssmgpb"&&(k.textContent=ln),qt=a(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-h63eiv"&&(W.textContent=nn),Lt=a(e),p(N.$$.fragment,e),Pt=a(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1ejfgk5"&&(_.textContent=an),Dt=a(e),R=o(e,"UL",{"data-svelte-h":!0}),r(R)!=="svelte-1xvwiei"&&(R.innerHTML=on),Kt=a(e),p(S.$$.fragment,e),Ot=a(e),p(V.$$.fragment,e),es=a(e),p(Y.$$.fragment,e),ts=a(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-mfr2mw"&&(E.innerHTML=rn),ss=a(e),p(z.$$.fragment,e),ls=a(e),p(X.$$.fragment,e),ns=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1sfl7nk"&&(Q.innerHTML=cn),as=a(e),p(H.$$.fragment,e),is=a(e),p(F.$$.fragment,e),os=a(e),p(q.$$.fragment,e),rs=a(e),p(L.$$.fragment,e),cs=a(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-185gao8"&&(P.textContent=pn),ps=a(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-e6nnzy"&&(D.textContent=hn),hs=a(e),p(K.$$.fragment,e),ms=a(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-18dzsym"&&(O.textContent=mn),Ms=a(e),p(ee.$$.fragment,e),ws=a(e),p(te.$$.fragment,e),ys=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1t01wav"&&(se.textContent=Mn),ds=a(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-j98tvi"&&(le.innerHTML=wn),us=a(e),p(ne.$$.fragment,e),fs=a(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1r056o8"&&(ae.innerHTML=yn),js=a(e),ie=o(e,"UL",{"data-svelte-h":!0}),r(ie)!=="svelte-1tnbgvc"&&(ie.innerHTML=dn),Ts=a(e),p(oe.$$.fragment,e),Js=a(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-im901f"&&(re.textContent=un),bs=a(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1jamuql"&&(ce.textContent=fn),Us=a(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-18zgdsy"&&(pe.textContent=jn),Is=a(e),p(he.$$.fragment,e),Cs=a(e),p(me.$$.fragment,e),gs=a(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-xnkl8w"&&(Me.textContent=Tn),vs=a(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1aurt77"&&(we.innerHTML=Jn),xs=a(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1yzpy08"&&(ye.textContent=bn),As=a(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-o1h7a"&&(de.textContent=Un),Bs=a(e),p(ue.$$.fragment,e),Zs=a(e),p(fe.$$.fragment,e),Gs=a(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-185bjpp"&&(je.innerHTML=In),$s=a(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-6ni6w3"&&(Te.textContent=Cn),ks=a(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1suwwfe"&&(Je.textContent=gn),Ws=a(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-a1a2e1"&&(be.textContent=vn),Ns=a(e),Ue=o(e,"UL",{"data-svelte-h":!0}),r(Ue)!=="svelte-1sr1vnc"&&(Ue.innerHTML=xn),_s=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-dbx09b"&&(Ie.innerHTML=An),Rs=a(e),p(Ce.$$.fragment,e),Ss=a(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1x7rcj0"&&(ge.innerHTML=Bn),Vs=a(e),p(ve.$$.fragment,e),Ys=a(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1tajk60"&&(xe.innerHTML=Zn),Es=a(e),p(Ae.$$.fragment,e),zs=a(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-p9izsn"&&(Be.innerHTML=Gn),Xs=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-ist138"&&(Ze.innerHTML=$n),Qs=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-11wavvk"&&(Ge.innerHTML=kn),Hs=a(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-113m94f"&&($e.textContent=Wn),Fs=a(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1tsvmsw"&&(ke.textContent=Nn),qs=a(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1vb1g40"&&(We.textContent=_n),Ls=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-d4ocy7"&&(Ne.textContent=Rn),Ps=a(e),p(_e.$$.fragment,e),Ds=a(e),p(Re.$$.fragment,e),Ks=a(e),p(Se.$$.fragment,e),Os=a(e),Ve=o(e,"PRE",{"data-svelte-h":!0}),r(Ve)!=="svelte-mqrnyt"&&(Ve.textContent=Sn),el=a(e),p(Ye.$$.fragment,e),tl=a(e),Ee=o(e,"PRE",{"data-svelte-h":!0}),r(Ee)!=="svelte-ick26y"&&(Ee.textContent=Vn),sl=a(e),ze=o(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-wmkk7m"&&(ze.textContent=Yn),ll=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1t94ag6"&&(Xe.textContent=En),nl=a(e),p(Qe.$$.fragment,e),al=a(e),He=o(e,"PRE",{"data-svelte-h":!0}),r(He)!=="svelte-we3tc3"&&(He.textContent=zn),il=a(e),Fe=o(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-fu67dr"&&(Fe.textContent=Xn),ol=a(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-11he3hz"&&(qe.textContent=Qn),rl=a(e),Le=o(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-wkh4v1"&&(Le.textContent=Hn),cl=a(e),p(Pe.$$.fragment,e),pl=a(e),De=o(e,"PRE",{"data-svelte-h":!0}),r(De)!=="svelte-zuw07a"&&(De.textContent=Fn),hl=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-9995rt"&&(Ke.textContent=qn),ml=a(e),Oe=o(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-1u7ud9q"&&(Oe.textContent=Ln),Ml=a(e),p(et.$$.fragment,e),wl=a(e),tt=o(e,"PRE",{"data-svelte-h":!0}),r(tt)!=="svelte-158wm6z"&&(tt.textContent=Pn),yl=a(e),st=o(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-qcml34"&&(st.textContent=Dn),dl=a(e),p(lt.$$.fragment,e),ul=a(e),nt=o(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1fxal5n"&&(nt.innerHTML=Kn),fl=a(e),at=o(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-165ddml"&&(at.textContent=On),jl=a(e),it=o(e,"UL",{"data-svelte-h":!0}),r(it)!=="svelte-mhvp7d"&&(it.innerHTML=ea),Tl=a(e),ot=o(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-i89iqv"&&(ot.innerHTML=ta),Jl=a(e),p(rt.$$.fragment,e),bl=a(e),p(ct.$$.fragment,e),Ul=a(e),p(pt.$$.fragment,e),Il=a(e),p(ht.$$.fragment,e),Cl=a(e),mt=o(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-15c3jn4"&&(mt.textContent=sa),gl=a(e),Mt=o(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-3bfxya"&&(Mt.innerHTML=la),vl=a(e),wt=o(e,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-nl1n48"&&(wt.textContent=na),xl=a(e),p(yt.$$.fragment,e),Al=a(e),p(dt.$$.fragment,e),Bl=a(e),ut=o(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-1qfx2ub"&&(ut.textContent=aa),Zl=a(e),p(ft.$$.fragment,e),Gl=a(e),jt=o(e,"PRE",{"data-svelte-h":!0}),r(jt)!=="svelte-1uv406t"&&(jt.innerHTML=ia),$l=a(e),p(Tt.$$.fragment,e),kl=a(e),Jt=o(e,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-8m24ut"&&(Jt.textContent=oa),Wl=a(e),bt=o(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-rknvvb"&&(bt.textContent=ra),Nl=a(e),Ut=o(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-wq8jse"&&(Ut.textContent=ca),_l=a(e),It=o(e,"P",{"data-svelte-h":!0}),r(It)!=="svelte-11y4pel"&&(It.textContent=pa),Rl=a(e),p(Ct.$$.fragment,e),Sl=a(e),xt=o(e,"P",{}),ha(xt).forEach(s),this.h()},h(){Yl(u,"name","hf:doc:metadata"),Yl(u,"content",Ia),Ma(gt.src,Ll="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/semantic_cache.jpg")||Yl(gt,"src",Ll)},m(e,t){ja(document.head,u),l(e,At,t),l(e,vt,t),l(e,Bt,t),h(f,e,t),l(e,Zt,t),h(j,e,t),l(e,Gt,t),h(T,e,t),l(e,$t,t),l(e,J,t),l(e,kt,t),l(e,b,t),l(e,Wt,t),l(e,U,t),l(e,Nt,t),l(e,I,t),l(e,_t,t),l(e,C,t),l(e,Rt,t),l(e,g,t),l(e,St,t),l(e,gt,t),l(e,Vt,t),l(e,v,t),l(e,Yt,t),l(e,x,t),l(e,Et,t),l(e,A,t),l(e,zt,t),l(e,B,t),l(e,Xt,t),l(e,Z,t),l(e,Qt,t),l(e,G,t),l(e,Ht,t),l(e,$,t),l(e,Ft,t),l(e,k,t),l(e,qt,t),l(e,W,t),l(e,Lt,t),h(N,e,t),l(e,Pt,t),l(e,_,t),l(e,Dt,t),l(e,R,t),l(e,Kt,t),h(S,e,t),l(e,Ot,t),h(V,e,t),l(e,es,t),h(Y,e,t),l(e,ts,t),l(e,E,t),l(e,ss,t),h(z,e,t),l(e,ls,t),h(X,e,t),l(e,ns,t),l(e,Q,t),l(e,as,t),h(H,e,t),l(e,is,t),h(F,e,t),l(e,os,t),h(q,e,t),l(e,rs,t),h(L,e,t),l(e,cs,t),l(e,P,t),l(e,ps,t),l(e,D,t),l(e,hs,t),h(K,e,t),l(e,ms,t),l(e,O,t),l(e,Ms,t),h(ee,e,t),l(e,ws,t),h(te,e,t),l(e,ys,t),l(e,se,t),l(e,ds,t),l(e,le,t),l(e,us,t),h(ne,e,t),l(e,fs,t),l(e,ae,t),l(e,js,t),l(e,ie,t),l(e,Ts,t),h(oe,e,t),l(e,Js,t),l(e,re,t),l(e,bs,t),l(e,ce,t),l(e,Us,t),l(e,pe,t),l(e,Is,t),h(he,e,t),l(e,Cs,t),h(me,e,t),l(e,gs,t),l(e,Me,t),l(e,vs,t),l(e,we,t),l(e,xs,t),l(e,ye,t),l(e,As,t),l(e,de,t),l(e,Bs,t),h(ue,e,t),l(e,Zs,t),h(fe,e,t),l(e,Gs,t),l(e,je,t),l(e,$s,t),l(e,Te,t),l(e,ks,t),l(e,Je,t),l(e,Ws,t),l(e,be,t),l(e,Ns,t),l(e,Ue,t),l(e,_s,t),l(e,Ie,t),l(e,Rs,t),h(Ce,e,t),l(e,Ss,t),l(e,ge,t),l(e,Vs,t),h(ve,e,t),l(e,Ys,t),l(e,xe,t),l(e,Es,t),h(Ae,e,t),l(e,zs,t),l(e,Be,t),l(e,Xs,t),l(e,Ze,t),l(e,Qs,t),l(e,Ge,t),l(e,Hs,t),l(e,$e,t),l(e,Fs,t),l(e,ke,t),l(e,qs,t),l(e,We,t),l(e,Ls,t),l(e,Ne,t),l(e,Ps,t),h(_e,e,t),l(e,Ds,t),h(Re,e,t),l(e,Ks,t),h(Se,e,t),l(e,Os,t),l(e,Ve,t),l(e,el,t),h(Ye,e,t),l(e,tl,t),l(e,Ee,t),l(e,sl,t),l(e,ze,t),l(e,ll,t),l(e,Xe,t),l(e,nl,t),h(Qe,e,t),l(e,al,t),l(e,He,t),l(e,il,t),l(e,Fe,t),l(e,ol,t),l(e,qe,t),l(e,rl,t),l(e,Le,t),l(e,cl,t),h(Pe,e,t),l(e,pl,t),l(e,De,t),l(e,hl,t),l(e,Ke,t),l(e,ml,t),l(e,Oe,t),l(e,Ml,t),h(et,e,t),l(e,wl,t),l(e,tt,t),l(e,yl,t),l(e,st,t),l(e,dl,t),h(lt,e,t),l(e,ul,t),l(e,nt,t),l(e,fl,t),l(e,at,t),l(e,jl,t),l(e,it,t),l(e,Tl,t),l(e,ot,t),l(e,Jl,t),h(rt,e,t),l(e,bl,t),h(ct,e,t),l(e,Ul,t),h(pt,e,t),l(e,Il,t),h(ht,e,t),l(e,Cl,t),l(e,mt,t),l(e,gl,t),l(e,Mt,t),l(e,vl,t),l(e,wt,t),l(e,xl,t),h(yt,e,t),l(e,Al,t),h(dt,e,t),l(e,Bl,t),l(e,ut,t),l(e,Zl,t),h(ft,e,t),l(e,Gl,t),l(e,jt,t),l(e,$l,t),h(Tt,e,t),l(e,kl,t),l(e,Jt,t),l(e,Wl,t),l(e,bt,t),l(e,Nl,t),l(e,Ut,t),l(e,_l,t),l(e,It,t),l(e,Rl,t),h(Ct,e,t),l(e,Sl,t),l(e,xt,t),Vl=!0},p:wa,i(e){Vl||(m(f.$$.fragment,e),m(j.$$.fragment,e),m(T.$$.fragment,e),m(N.$$.fragment,e),m(S.$$.fragment,e),m(V.$$.fragment,e),m(Y.$$.fragment,e),m(z.$$.fragment,e),m(X.$$.fragment,e),m(H.$$.fragment,e),m(F.$$.fragment,e),m(q.$$.fragment,e),m(L.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(te.$$.fragment,e),m(ne.$$.fragment,e),m(oe.$$.fragment,e),m(he.$$.fragment,e),m(me.$$.fragment,e),m(ue.$$.fragment,e),m(fe.$$.fragment,e),m(Ce.$$.fragment,e),m(ve.$$.fragment,e),m(Ae.$$.fragment,e),m(_e.$$.fragment,e),m(Re.$$.fragment,e),m(Se.$$.fragment,e),m(Ye.$$.fragment,e),m(Qe.$$.fragment,e),m(Pe.$$.fragment,e),m(et.$$.fragment,e),m(lt.$$.fragment,e),m(rt.$$.fragment,e),m(ct.$$.fragment,e),m(pt.$$.fragment,e),m(ht.$$.fragment,e),m(yt.$$.fragment,e),m(dt.$$.fragment,e),m(ft.$$.fragment,e),m(Tt.$$.fragment,e),m(Ct.$$.fragment,e),Vl=!0)},o(e){M(f.$$.fragment,e),M(j.$$.fragment,e),M(T.$$.fragment,e),M(N.$$.fragment,e),M(S.$$.fragment,e),M(V.$$.fragment,e),M(Y.$$.fragment,e),M(z.$$.fragment,e),M(X.$$.fragment,e),M(H.$$.fragment,e),M(F.$$.fragment,e),M(q.$$.fragment,e),M(L.$$.fragment,e),M(K.$$.fragment,e),M(ee.$$.fragment,e),M(te.$$.fragment,e),M(ne.$$.fragment,e),M(oe.$$.fragment,e),M(he.$$.fragment,e),M(me.$$.fragment,e),M(ue.$$.fragment,e),M(fe.$$.fragment,e),M(Ce.$$.fragment,e),M(ve.$$.fragment,e),M(Ae.$$.fragment,e),M(_e.$$.fragment,e),M(Re.$$.fragment,e),M(Se.$$.fragment,e),M(Ye.$$.fragment,e),M(Qe.$$.fragment,e),M(Pe.$$.fragment,e),M(et.$$.fragment,e),M(lt.$$.fragment,e),M(rt.$$.fragment,e),M(ct.$$.fragment,e),M(pt.$$.fragment,e),M(ht.$$.fragment,e),M(yt.$$.fragment,e),M(dt.$$.fragment,e),M(ft.$$.fragment,e),M(Tt.$$.fragment,e),M(Ct.$$.fragment,e),Vl=!1},d(e){e&&(s(At),s(vt),s(Bt),s(Zt),s(Gt),s($t),s(J),s(kt),s(b),s(Wt),s(U),s(Nt),s(I),s(_t),s(C),s(Rt),s(g),s(St),s(gt),s(Vt),s(v),s(Yt),s(x),s(Et),s(A),s(zt),s(B),s(Xt),s(Z),s(Qt),s(G),s(Ht),s($),s(Ft),s(k),s(qt),s(W),s(Lt),s(Pt),s(_),s(Dt),s(R),s(Kt),s(Ot),s(es),s(ts),s(E),s(ss),s(ls),s(ns),s(Q),s(as),s(is),s(os),s(rs),s(cs),s(P),s(ps),s(D),s(hs),s(ms),s(O),s(Ms),s(ws),s(ys),s(se),s(ds),s(le),s(us),s(fs),s(ae),s(js),s(ie),s(Ts),s(Js),s(re),s(bs),s(ce),s(Us),s(pe),s(Is),s(Cs),s(gs),s(Me),s(vs),s(we),s(xs),s(ye),s(As),s(de),s(Bs),s(Zs),s(Gs),s(je),s($s),s(Te),s(ks),s(Je),s(Ws),s(be),s(Ns),s(Ue),s(_s),s(Ie),s(Rs),s(Ss),s(ge),s(Vs),s(Ys),s(xe),s(Es),s(zs),s(Be),s(Xs),s(Ze),s(Qs),s(Ge),s(Hs),s($e),s(Fs),s(ke),s(qs),s(We),s(Ls),s(Ne),s(Ps),s(Ds),s(Ks),s(Os),s(Ve),s(el),s(tl),s(Ee),s(sl),s(ze),s(ll),s(Xe),s(nl),s(al),s(He),s(il),s(Fe),s(ol),s(qe),s(rl),s(Le),s(cl),s(pl),s(De),s(hl),s(Ke),s(ml),s(Oe),s(Ml),s(wl),s(tt),s(yl),s(st),s(dl),s(ul),s(nt),s(fl),s(at),s(jl),s(it),s(Tl),s(ot),s(Jl),s(bl),s(Ul),s(Il),s(Cl),s(mt),s(gl),s(Mt),s(vl),s(wt),s(xl),s(Al),s(Bl),s(ut),s(Zl),s(Gl),s(jt),s($l),s(kl),s(Jt),s(Wl),s(bt),s(Nl),s(Ut),s(_l),s(It),s(Rl),s(Sl),s(xt)),s(u),w(f,e),w(j,e),w(T,e),w(N,e),w(S,e),w(V,e),w(Y,e),w(z,e),w(X,e),w(H,e),w(F,e),w(q,e),w(L,e),w(K,e),w(ee,e),w(te,e),w(ne,e),w(oe,e),w(he,e),w(me,e),w(ue,e),w(fe,e),w(Ce,e),w(ve,e),w(Ae,e),w(_e,e),w(Re,e),w(Se,e),w(Ye,e),w(Qe,e),w(Pe,e),w(et,e),w(lt,e),w(rt,e),w(ct,e),w(pt,e),w(ht,e),w(yt,e),w(dt,e),w(ft,e),w(Tt,e),w(Ct,e)}}}const Ia='{"title":"Implementing semantic cache to improve a RAG system with FAISS.","local":"implementing-semantic-cache-to-improve-a-rag-system-with-faiss","sections":[],"depth":1}';function Ca(El){return ya(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Za extends da{constructor(u){super(),ua(this,u,Ca,Ua,ma,{})}}export{Za as component};
