import{s as ws,a as rs,n as Rs,o as Cs}from"../chunks/scheduler.e0212c12.js";import{S as ms,i as ys,e as n,s,c as o,h as js,a as U,d as l,b as a,f as Ks,g as p,j as i,k as Fe,l as Ts,m as e,n as F,t as f,o as J,p as r}from"../chunks/index.a585a37c.js";import{C as Ms,H as w,E as Vs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b1037f60.js";import{D as cs,C as K}from"../chunks/DocNotebookDropdown.5283ff25.js";function gs(fe){let R,rt,ft,Kt,C,wt,m,Rt,y,Ct,j,Je='<em>작성자 : <a href="https://github.com/emre570" rel="nofollow">Emre Albayrak</a></em>',mt,T,re='<em>번역자: <a href="https://github.com/HyunZ118" rel="nofollow">Hyun Ji Jeon</a></em>',yt,M,Ke=" ",jt,V,we="이 가이드는 Vision Transformer(ViT) 모델을 Custom Biomedical Dataset 에 Fine-tuning하는 과정을 설명합니다. 이 과정에서 데이터셋 로딩 및 전처리, 데이터 분할에 따른 이미지 변환 설정, ViT 모델 구성 및 초기화, 평가 및 시각화 도구를 포함한 학습 과정 정의 단계가 포함됩니다.",Tt,c,Re=" ",Mt,g,Vt,B,Ce="Custom Dataset은 수작업으로 제작되었으며, 총 780장의 이미지와 benign(양성), malignant(악성), normal(정상) 총 3개의 클래스를 포함합니다.",ct,b,me='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/102d6c23e6cc24db857fbc60186461ded6cdfb75/datasetinfo.png" alt="attachment:datasetinfo.png"/>',gt,u,Bt,Q,ye='우리가 Fine-tuning 할 모델은 Google의 <a href="https://huggingface.co/google/vit-large-patch16-224" rel="nofollow"><code>&quot;vit-large-patch16-224&quot;</code></a>입니다. 이 모델은 ImageNet-21k(1,400만 장의 이미지, 21,843개의 클래스)으로 사전학습 되었으며, ImageNet 2012(100만 장의 이미지, 1,000개 클래스)로 해상도 224x224에서 Fine-tuning 되었습니다. Google은 이외에도 다양한 이미지 크기와 패치 크기를 가진 여러 ViT 모델을 보유하고 있습니다.',bt,h,je="그럼 이제 시작해보겠습니다! 🤗",ut,P,Qt,d,Te="먼저 필요한 라이브러리들을 설치해야합니다.",ht,I,Pt,x,dt,k,Me="(선택 사항) 모델을 Hugging Face Hub에 업로드할 예정이므로 먼저 로그인해야 합니다.",It,X,xt,H,kt,v,Ve='<code>datasets</code> 라이브러리는 데이터셋에서 이미지와 클래스를 자동으로 불러옵니다. 자세한 내용은 <a href="https://huggingface.co/docs/datasets/image_load" rel="nofollow">이 링크</a>를 참고하세요.',Xt,Z,Ht,W,ce="데이터셋을 불러왔지만, 해당 데이터셋에는 검증 세트가 분할되어 있지 않은 상황입니다.",vt,N,ge="검증 세트를 만들기 위해 테스트 세트의 크기를 기준으로 훈련 세트의 일부를 나누어 검증 세트를 생성하려고 합니다.",Zt,D,Be="그 후 기존 훈련 세트를 새로운 훈련 세트와 검증 세트로 분할합니다.",Wt,G,Nt,z,be="분할된 훈련 세트를 준비했습니다. 이제 이를 테스트 세트와 함께 병합해보겠습니다.",Dt,q,Gt,Y,ue="좋습니다! 이제 데이터셋 준비가 완료되었네요 👍🏻",zt,S,Qe="나중에 쉽게 참조할 수 있도록 각 하위 집합을 변수에 할당해 둡시다.",qt,O,Yt,E,he="이미지를 확인해보면 <code>PIL.Image</code> 형식이며 이에 연결된 레이블이 함께 존재하는 것을 확인할 수 있습니다.",St,L,Ot,$,Pe="훈련 세트의 특성도 확인할 수 있습니다.",Et,_,Lt,AA,de="데이터셋에서 각 클래스별로 하나씩 이미지를 출력해봅시다.",$t,tA,_t,pt,Ie,Al,lA,tl,eA,xe="데이터셋은 준비되었지만 파인튜닝을 위한 준비는 아직 완료되지 않았습니다. 아래와 같은 절차를 순차적으로 따라가보겠습니다!",ll,sA,ke="<li><p><strong>레이블 매핑 (Label Mapping)</strong> : 레이블 ID와 해당 클래스 이름 간의 매핑을 수행합니다. 이는 모델 학습과 평가 시 유용하게 사용됩니다.</p></li> <li><p><strong>이미지 전처리 (Image Processing)</strong> : <code>ViTImageProcessor</code>를 사용해 입력 이미지의 크기를 표준화하고, 사전 학습된 모델에 맞는 정규화를 적용합니다. 또한, <code>torchvision</code>을 활용해 훈련, 검증, 테스트용으로 서로 다른 변환을 정의하여 모델의 일반화를 향상시킵니다.</p></li> <li><p><strong>변환 함수 정의 (Transform Functions)</strong> : ViT 모델에 맞는 형식과 크기로 이미지를 변환하기 위한 함수를 구현합니다.</p></li> <li><p><strong>데이터 로딩 (Data Loading)</strong> : 이미지와 라벨을 올바르게 배치할 수 있도록 사용자 정의 collate 함수를 설정하고, 학습 과정에서 효율적인 데이터 로딩과 배치를 위해 DataLoader를 구성합니다.</p></li> <li><p><strong>배치 준비 (Batch Preparation)</strong> : 샘플 배치의 데이터 형태(shape)를 확인하여 변환이 제대로 되었는지, 그리고 모델 입력으로 사용할 준비가 되었는지 검증합니다.</p></li>",el,aA,sl,nA,al,UA,nl,iA,Ul,oA,il,pA,ol,FA,pl,fA,Fl,JA,fl,rA,Jl,KA,rl,wA,Xe="픽셀 값이 텐서로 잘 변환되었네요 👍🏻",Kl,RA,wl,CA,Rl,mA,Cl,yA,ml,jA,He=`pixel_values torch.Size([4, 3, 224, 224])
labels torch.Size([4])
`,yl,TA,ve="완벽합니다👏🏻 이제 파인튜닝 진행을 위한 모든 준비가 되었습니다.",jl,MA,Ze="이어서 모델을 설정하고 파인튜닝하는 과정을 진행하겠습니다.",Tl,VA,Ml,cA,We="우선, 특정 레이블 매핑과 사전 학습 설정(pre-trained settings)을 사용해 모델을 초기화하고, 크기 불일치를 조정해줍니다. 그 다음, 학습 과정을 정의하기 위해 저장 전략, 배치 크기, 학습 epoch 등의 학습 파라미터를 설정하고, Weights & Biases를 통해 학습 결과를 로깅합니다.",Vl,gA,Ne="이후 Hugging Face의 Trainer가 인스턴스화되어 학습과 평가를 관리하며, 커스텀 데이터 collator와 모델에 내장된 Processor를 함께 사용합니다. 마지막으로 학습이 완료된 모델을 테스트 데이터셋으로 평가하고, 정확도를 확인하기 위한 지표(metrics)를 출력합니다.",cl,BA,De="첫번째로, 모델을 먼저 호출해보겠습니다.",gl,bA,Bl,uA,Ge="이 부분에서 언급하고 싶은 디테일이 있습니다.<code>ignore_mismatched_sizes</code> 파라미터에 주목해주세요 👀",bl,QA,ze="사전 학습된(pre-trained) 모델을 새로운 데이터셋에 파인튜닝할 때, 종종 이미지의 입력 크기나 모델 구조(예: 분류 레이어의 클래스 수 등)가 원래 모델이 학습된 환경과 완전히 일치하지 않을 수 있습니다. 이러한 상황은 다양한 이유로 발생할 수 있습니다. 예를 들어 ImageNet처럼 자연 이미지로 학습된 모델을 의료 영상이나 특수 카메라 이미지처럼 전혀 다른 유형의 이미지에 적용하려고 할 때 발생하는데요.",ul,hA,qe="이때, <code>ignore_mismatched_sizes</code> 를 <code>True</code> 로 설정하면, 사이즈가 일치하지 않더라도 오류 없이 레이어를 자동으로 조정해 사용할 수 있게 해줍니다.",Ql,PA,Ye="예를 들어, 해당 모델은 1000개의 클래스로 학습되어 있어서 출력 크기가 <code>torch.Size([1000])</code> 이고 입력 또한 <code>torch.Size([1000])</code> 클래스를 기대합니다. 그런데 우리가 사용하는 데이터셋은 클래스가 3개 <code>torch.Size([3])</code>이고, 이 경우 모델에 직접 입력하면 클래스 수가 맞지 않기 때문에 오류가 발생하게 됩니다.",hl,dA,Se="그다음 Google에서 제공하는 학습 인자(arguments)를 정의해봅시다.",Pl,IA,Oe="(선택 사항) <code>report_to</code> 파라미터를 <code>wandb</code>로 설정했기 때문에, 평가 지표는 Weights &amp; Biases(W&amp;B)에 저장됩니다. W&amp;B는 API 키를 요구하므로 계정과 API 키를 미리 생성해두어야 합니다. 만약 W&amp;B를 사용하고 싶지 않다면, <code>report_to</code> 파라미터를 제거하면 됩니다.",dl,xA,Il,kA,Ee="이제 Trainer을 사용해 파인튜닝을 시작할 수 있습니다.",xl,XA,kl,HA,Le="<thead><tr><th>Epoch</th> <th>Training Loss</th> <th>Validation Loss</th> <th>Accuracy</th></tr></thead> <tbody><tr><td>40</td> <td>0.174700</td> <td>0.596288</td> <td>0.903846</td></tr></tbody>",Xl,vA,$e="파인튜닝이 완료되었습니다. 이제 테스트 세트를 사용해 모델을 평가해보겠습니다.",Hl,ZA,vl,WA,_e="<code>{&#39;test_loss&#39;: 0.3219967782497406, &#39;test_accuracy&#39;: 0.9102564102564102, &#39;test_runtime&#39;: 4.0543, &#39;test_samples_per_second&#39;: 38.478, &#39;test_steps_per_second&#39;: 9.619}</code>",Zl,NA,Wl,DA,As="<code>push_to_hub</code>을 사용하면 Hugging Face Hub에 모델을 업로드할 수 있습니다.",Nl,GA,Dl,zA,ts="좋습니다! 이제 결과를 시각화해볼까요?",Gl,qA,zl,YA,ls="파인튜닝을 마쳤으니, 이제 모델이 각 클래스를 어떻게 예측했는지 확인해보겠습니다.",ql,SA,es="이를 위해 scikit-learn의 Confusion Matrix Display를 사용하고, Recall 점수도 함께 확인해보겠습니다.",Yl,OA,Sl,EA,ss=`Confusion Matrix(혼동 행렬)는 알고리즘, 특히 지도 학습 모델이 실제 정답을 알고 있는 테스트 데이터에 대해 얼마나 잘 작동하는지를 시각적으로 보여주는 표 형식입니다.
예측된 라벨과 실제 라벨의 빈도를 나타내므로 분류 모델의 성능을 평가할 때 특히 유용합니다.`,Ol,LA,as="우리 모델의 Confusion Matrix를 시각화해봅시다.",El,$A,Ll,Ft,ns,$l,_A,_l,At,Us=`Recall Score(재현율)는 분류 작업에서 모델이 실제로 긍정 클래스(Positive Class)인 샘플을 얼마나 잘 찾아냈는지를 측정하는 성능 지표입니다.
즉, 실제 정답 중에서 모델이 올바르게 예측한 비율을 나타냅니다.`,Ae,tt,is="이제 scikit-learn을 사용해 재현율 점수를 출력해봅시다.",te,lt,le,et,os=`Recall for benign: 0.89
Recall for malignant: 0.90
Recall for normal: 0.81
`,ee,st,ps="<code>Recall for benign: 0.90, Recall for malignant: 0.86, Recall for normal: 0.78</code>",se,at,ae,nt,Fs="이 cookbook에서는 의료 데이터셋을 활용해 ViT 모델을 학습하는 과정을 다루었습니다.",ne,Ut,fs="데이터셋 준비, 이미지 전처리, 모델 구성, 학습, 평가, 그리고 결과 시각화까지의 핵심 단계들을 모두 포함하고 있습니다.",Ue,it,Js="Hugging Face의 <code>transformers</code> 라이브러리와 <code>scikit-learn</code>, PyTorch의 <code>torchvision</code>을 활용하여 효율적인 모델 학습과 평가가 가능하며, 이를 통해 바이오 메디컬 이미지를 얼마나 정확하게 분류할 수 있는지에 대한 유용한 인사이트를 제공합니다.",ie,ot,oe,Jt,pe;return C=new cs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/ko/fine_tuning_vit_custom_dataset_ko.ipynb"}]}}),m=new Ms({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),y=new w({props:{title:"Custom Biomedical Dataset으로 Vision Transformer 모델 Fine-tuning 하기",local:"custom-biomedical-dataset으로-vision-transformer-모델-fine-tuning-하기",headingTag:"h1"}}),g=new w({props:{title:"데이터셋 정보",local:"데이터셋-정보",headingTag:"h2"}}),u=new w({props:{title:"모델 정보",local:"모델-정보",headingTag:"h2"}}),P=new w({props:{title:"시작",local:"시작",headingTag:"h2"}}),I=new K({props:{code:"JTIzJTIwIXBpcCUyMGluc3RhbGwlMjBkYXRhc2V0cyUyMHRyYW5zZm9ybWVycyUyMGFjY2VsZXJhdGUlMjB0b3JjaCUyMHRvcmNodmlzaW9uJTIwc2Npa2l0LWxlYXJuJTIwbWF0cGxvdGxpYiUyMHdhbmRi",highlighted:'<span class="hljs-comment"># !pip install datasets transformers accelerate torch torchvision scikit-learn matplotlib wandb</span>',wrap:!1}}),x=new K({props:{code:"JTIzJTIwIXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjBkYXRhc2V0cyUyMCUyMyUyMFVwZGF0ZWQlMjBieSUyMEhKJTIwKGNvbGFiJTIwJUVEJTk5JTk4JUVBJUIyJUJEJUVDJTk3JTkwJUVDJTg0JTlDJTIwJUVDJThCJUE0JUVEJTk3JTk4JTIwJUVDJUE0JTkxJUVDJTlEJUJDJTIwJUVBJUIyJUJEJUVDJTlBJUIwJTIwJUVDJUI1JTlDJUVDJThCJUEwJTIwJUVCJUIyJTg0JUVDJUEwJTg0JTIwJUVDJTgyJUFDJUVDJTlBJUE5JUVDJTlEJTg0JTIwJUVDJTlDJTg0JUVEJTk1JUI0JTIwJUVDJTk3JTg1JUVBJUI3JUI4JUVCJUEwJTg4JUVDJTlEJUI0JUVCJTkzJTlDJTIwJUVEJTk1JTg0JUVDJTlBJTk0KQ==",highlighted:'<span class="hljs-comment"># !pip install --upgrade datasets # Updated by HJ (colab 환경에서 실험 중일 경우 최신 버전 사용을 위해 업그레이드 필요)</span>',wrap:!1}}),X=new K({props:{code:"JTIzZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTIzbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-comment">#from huggingface_hub import notebook_login</span>
<span class="hljs-comment">#notebook_login()</span>`,wrap:!1}}),H=new w({props:{title:"데이터셋 준비",local:"데이터셋-준비",headingTag:"h2"}}),Z=new K({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJlbXJlNTcwJTJGYnJlYXN0Y2FuY2VyLXVsdHJhc291bmQtaW1hZ2VzJTIyKSUwQWRhdGFzZXQ=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;emre570/breastcancer-ultrasound-images&quot;</span>)
dataset`,wrap:!1}}),G=new K({props:{code:"JTIzJTIwJUVBJUIwJTgxJTIwJUVDJTg0JUI4JUVEJThBJUI4JUVDJTlEJTk4JTIwJUVCJThEJUIwJUVDJTlEJUI0JUVEJTg0JUIwJTIwJUVDJTg4JTk4JUVCJUE1JUJDJTIwJUVBJUI1JUFDJUVEJTk1JUI0JUVCJUI0JTg1JUVCJThCJTg4JUVCJThCJUE0JTBBdGVzdF9udW0lMjAlM0QlMjBsZW4oZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQpJTBBdHJhaW5fbnVtJTIwJTNEJTIwbGVuKGRhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RCklMEElMEF2YWxfc2l6ZSUyMCUzRCUyMHRlc3RfbnVtJTIwJTJGJTIwdHJhaW5fbnVtJTBBJTBBdHJhaW5fdmFsX3NwbGl0JTIwJTNEJTIwZGF0YXNldCU1QiUyMnRyYWluJTIyJTVELnRyYWluX3Rlc3Rfc3BsaXQodGVzdF9zaXplJTNEdmFsX3NpemUpJTBBdHJhaW5fdmFsX3NwbGl0",highlighted:`<span class="hljs-comment"># 각 세트의 데이터 수를 구해봅니다</span>
test_num = <span class="hljs-built_in">len</span>(dataset[<span class="hljs-string">&quot;test&quot;</span>])
train_num = <span class="hljs-built_in">len</span>(dataset[<span class="hljs-string">&quot;train&quot;</span>])

val_size = test_num / train_num

train_val_split = dataset[<span class="hljs-string">&quot;train&quot;</span>].train_test_split(test_size=val_size)
train_val_split`,wrap:!1}}),q=new K({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldERpY3QlMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldERpY3QoJTdCJTBBJTIwJTIwJTIwJTIwJTIydHJhaW4lMjIlM0ElMjB0cmFpbl92YWxfc3BsaXQlNUIlMjJ0cmFpbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnZhbGlkYXRpb24lMjIlM0ElMjB0cmFpbl92YWxfc3BsaXQlNUIlMjJ0ZXN0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIydGVzdCUyMiUzQSUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTBBJTdEKSUwQWRhdGFzZXQ=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> DatasetDict

dataset = DatasetDict({
    <span class="hljs-string">&quot;train&quot;</span>: train_val_split[<span class="hljs-string">&quot;train&quot;</span>],
    <span class="hljs-string">&quot;validation&quot;</span>: train_val_split[<span class="hljs-string">&quot;test&quot;</span>],
    <span class="hljs-string">&quot;test&quot;</span>: dataset[<span class="hljs-string">&quot;test&quot;</span>]
})
dataset`,wrap:!1}}),O=new K({props:{code:"dHJhaW5fZHMlMjAlM0QlMjBkYXRhc2V0JTVCJ3RyYWluJyU1RCUwQXZhbF9kcyUyMCUzRCUyMGRhdGFzZXQlNUIndmFsaWRhdGlvbiclNUQlMEF0ZXN0X2RzJTIwJTNEJTIwZGF0YXNldCU1Qid0ZXN0JyU1RA==",highlighted:`train_ds = dataset[<span class="hljs-string">&#x27;train&#x27;</span>]
val_ds = dataset[<span class="hljs-string">&#x27;validation&#x27;</span>]
test_ds = dataset[<span class="hljs-string">&#x27;test&#x27;</span>]`,wrap:!1}}),L=new K({props:{code:"dHJhaW5fZHMlNUIwJTVE",highlighted:'train_ds[<span class="hljs-number">0</span>]',wrap:!1}}),_=new K({props:{code:"dHJhaW5fZHMuZmVhdHVyZXM=",highlighted:"train_ds.features",wrap:!1}}),tA=new K({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQSUyMyUyMCVFRCU5MSU5QyVFQyU4QiU5QyVFQiU5MCU5QyUyMCVFQiVBMCU4OCVFQyU5RCVCNCVFQiVCOCU5NCVFQyU5RCU4NCUyMCVFQyVCNiU5NCVFQyVBMCU4MSVFRCU5NSVBMCUyMCVFQyU4OCU5OCUyMCVFQyU5RSU4OCVFQSVCMiU4QyUyMHNldCVFQiVBNSVCQyUyMCVFQyVCNCU4OCVFQSVCOCVCMCVFRCU5OSU5NCVFRCU5NSVCNCVFQyVBNCU4RCVFQiU4QiU4OCVFQiU4QiVBNCUwQXNob3duX2xhYmVscyUyMCUzRCUyMHNldCgpJTBBJTBBJTIzJTIwJUVBJUI3JUI4JUVCJTlFJTk4JUVEJTk0JTg0JUVCJUE1JUJDJTIwJUVBJUI3JUI4JUVCJUE2JUFDJUVBJUI4JUIwJTIwJUVDJTlDJTg0JUVEJTk1JUI0JTIwZmlndXJlJUVCJUE1JUJDJTIwJUVDJUI0JTg4JUVBJUI4JUIwJUVEJTk5JTk0JUVEJTk1JUI0JUVDJUE0JThEJUVCJThCJTg4JUVCJThCJUE0JTBBcGx0LmZpZ3VyZShmaWdzaXplJTNEKDEwJTJDJTIwMTApKSUwQSUwQSUyMyUyMCVFQiU4RCVCMCVFQyU5RCVCNCVFRCU4NCVCMCVFQyU4NSU4QiVFQyU5RCU4NCUyMCVFRCU5NSU5OCVFQiU4MiU5OCVFQyU5NCVBOSUyMCVFQyU4MiVCNCVFRCU4RSVCNCVFQiVCMyVCNCVFQiVBOSVCNCVFQyU4NCU5QyUyMCVFQSVCMCU4MSUyMCVFQiU5RCVCQyVFQiVCMiVBOCVFQiVBNyU4OCVFQiU4QiVBNCUyMCVFQyVCMiVBQiUyMCVFQiVCMiU4OCVFQyVBNyVCOCUyMCVFQyU5RCVCNCVFQiVBRiVCOCVFQyVBNyU4MCVFQiVBNSVCQyUyMCVFQSVCNyVCOCVFQiVBMCVBNCVFQyVBNCU4RCVFQiU4QiU4OCVFQiU4QiVBNCUwQWZvciUyMGklMkMlMjBzYW1wbGUlMjBpbiUyMGVudW1lcmF0ZSh0cmFpbl9kcyklM0ElMEElMjAlMjAlMjAlMjBsYWJlbCUyMCUzRCUyMHRyYWluX2RzLmZlYXR1cmVzJTVCJ2xhYmVsJyU1RC5uYW1lcyU1QnNhbXBsZSU1QidsYWJlbCclNUQlNUQlMEElMjAlMjAlMjAlMjBpZiUyMGxhYmVsJTIwbm90JTIwaW4lMjBzaG93bl9sYWJlbHMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwbHQuc3VicGxvdCgxJTJDJTIwbGVuKHRyYWluX2RzLmZlYXR1cmVzJTVCJ2xhYmVsJyU1RC5uYW1lcyklMkMlMjBsZW4oc2hvd25fbGFiZWxzKSUyMCUyQiUyMDEpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGx0Lmltc2hvdyhzYW1wbGUlNUInaW1hZ2UnJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBsdC50aXRsZShsYWJlbCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwbHQuYXhpcygnb2ZmJyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzaG93bl9sYWJlbHMuYWRkKGxhYmVsKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGVuKHNob3duX2xhYmVscyklMjAlM0QlM0QlMjBsZW4odHJhaW5fZHMuZmVhdHVyZXMlNUInbGFiZWwnJTVELm5hbWVzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBcGx0LnNob3coKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 표시된 레이블을 추적할 수 있게 set를 초기화해줍니다</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>shown_labels = <span class="hljs-built_in">set</span>()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 그래프를 그리기 위해 figure를 초기화해줍니다</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.figure(figsize=(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 데이터셋을 하나씩 살펴보면서 각 라벨마다 첫 번째 이미지를 그려줍니다</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, sample <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(train_ds):
<span class="hljs-meta">... </span>    label = train_ds.features[<span class="hljs-string">&#x27;label&#x27;</span>].names[sample[<span class="hljs-string">&#x27;label&#x27;</span>]]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> label <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> shown_labels:
<span class="hljs-meta">... </span>        plt.subplot(<span class="hljs-number">1</span>, <span class="hljs-built_in">len</span>(train_ds.features[<span class="hljs-string">&#x27;label&#x27;</span>].names), <span class="hljs-built_in">len</span>(shown_labels) + <span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>        plt.imshow(sample[<span class="hljs-string">&#x27;image&#x27;</span>])
<span class="hljs-meta">... </span>        plt.title(label)
<span class="hljs-meta">... </span>        plt.axis(<span class="hljs-string">&#x27;off&#x27;</span>)
<span class="hljs-meta">... </span>        shown_labels.add(label)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(shown_labels) == <span class="hljs-built_in">len</span>(train_ds.features[<span class="hljs-string">&#x27;label&#x27;</span>].names):
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`,wrap:!1}}),lA=new w({props:{title:"데이터 전처리",local:"데이터-전처리",headingTag:"h2"}}),aA=new w({props:{title:"레이블 매핑 (Label Mapping)",local:"레이블-매핑-label-mapping",headingTag:"h3"}}),nA=new K({props:{code:"aWQybGFiZWwlMjAlM0QlMjAlN0JpZCUzQWxhYmVsJTIwZm9yJTIwaWQlMkMlMjBsYWJlbCUyMGluJTIwZW51bWVyYXRlKHRyYWluX2RzLmZlYXR1cmVzJTVCJ2xhYmVsJyU1RC5uYW1lcyklN0QlMEFsYWJlbDJpZCUyMCUzRCUyMCU3QmxhYmVsJTNBaWQlMjBmb3IlMjBpZCUyQ2xhYmVsJTIwaW4lMjBpZDJsYWJlbC5pdGVtcygpJTdEJTBBaWQybGFiZWwlMkMlMjBpZDJsYWJlbCU1QnRyYWluX2RzJTVCMCU1RCU1QidsYWJlbCclNUQlNUQ=",highlighted:`id2label = {<span class="hljs-built_in">id</span>:label <span class="hljs-keyword">for</span> <span class="hljs-built_in">id</span>, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(train_ds.features[<span class="hljs-string">&#x27;label&#x27;</span>].names)}
label2id = {label:<span class="hljs-built_in">id</span> <span class="hljs-keyword">for</span> <span class="hljs-built_in">id</span>,label <span class="hljs-keyword">in</span> id2label.items()}
id2label, id2label[train_ds[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;label&#x27;</span>]]`,wrap:!1}}),UA=new w({props:{title:"이미지 전처리 (Image Processing)",local:"이미지-전처리-image-processing",headingTag:"h3"}}),iA=new K({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpVEltYWdlUHJvY2Vzc29yJTBBJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMmdvb2dsZSUyRnZpdC1sYXJnZS1wYXRjaDE2LTIyNCUyMiUwQXByb2Nlc3NvciUyMCUzRCUyMFZpVEltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ViTImageProcessor

model_name = <span class="hljs-string">&quot;google/vit-large-patch16-224&quot;</span>
processor = ViTImageProcessor.from_pretrained(model_name)`,wrap:!1}}),oA=new K({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjBDZW50ZXJDcm9wJTJDJTIwQ29tcG9zZSUyQyUyME5vcm1hbGl6ZSUyQyUyMFJhbmRvbUhvcml6b250YWxGbGlwJTJDJTIwUmFuZG9tUmVzaXplZENyb3AlMkMlMjBUb1RlbnNvciUyQyUyMFJlc2l6ZSUwQSUwQWltYWdlX21lYW4lMkMlMjBpbWFnZV9zdGQlMjAlM0QlMjBwcm9jZXNzb3IuaW1hZ2VfbWVhbiUyQyUyMHByb2Nlc3Nvci5pbWFnZV9zdGQlMEFzaXplJTIwJTNEJTIwcHJvY2Vzc29yLnNpemUlNUIlMjJoZWlnaHQlMjIlNUQlMEElMEFub3JtYWxpemUlMjAlM0QlMjBOb3JtYWxpemUobWVhbiUzRGltYWdlX21lYW4lMkMlMjBzdGQlM0RpbWFnZV9zdGQpJTBBJTBBdHJhaW5fdHJhbnNmb3JtcyUyMCUzRCUyMENvbXBvc2UoJTVCJTBBJTIwJTIwJTIwJTIwUmFuZG9tUmVzaXplZENyb3Aoc2l6ZSklMkMlMEElMjAlMjAlMjAlMjBSYW5kb21Ib3Jpem9udGFsRmxpcCgpJTJDJTBBJTIwJTIwJTIwJTIwVG9UZW5zb3IoKSUyQyUwQSUyMCUyMCUyMCUyMG5vcm1hbGl6ZSUyQyUwQSU1RCklMEF2YWxfdHJhbnNmb3JtcyUyMCUzRCUyMENvbXBvc2UoJTVCJTBBJTIwJTIwJTIwJTIwUmVzaXplKHNpemUpJTJDJTBBJTIwJTIwJTIwJTIwQ2VudGVyQ3JvcChzaXplKSUyQyUwQSUyMCUyMCUyMCUyMFRvVGVuc29yKCklMkMlMEElMjAlMjAlMjAlMjBub3JtYWxpemUlMkMlMEElNUQpJTBBdGVzdF90cmFuc2Zvcm1zJTIwJTNEJTIwQ29tcG9zZSglNUIlMEElMjAlMjAlMjAlMjBSZXNpemUoc2l6ZSklMkMlMEElMjAlMjAlMjAlMjBDZW50ZXJDcm9wKHNpemUpJTJDJTBBJTIwJTIwJTIwJTIwVG9UZW5zb3IoKSUyQyUwQSUyMCUyMCUyMCUyMG5vcm1hbGl6ZSUyQyUwQSU1RCk=",highlighted:`<span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> CenterCrop, Compose, Normalize, RandomHorizontalFlip, RandomResizedCrop, ToTensor, Resize

image_mean, image_std = processor.image_mean, processor.image_std
size = processor.size[<span class="hljs-string">&quot;height&quot;</span>]

normalize = Normalize(mean=image_mean, std=image_std)

train_transforms = Compose([
    RandomResizedCrop(size),
    RandomHorizontalFlip(),
    ToTensor(),
    normalize,
])
val_transforms = Compose([
    Resize(size),
    CenterCrop(size),
    ToTensor(),
    normalize,
])
test_transforms = Compose([
    Resize(size),
    CenterCrop(size),
    ToTensor(),
    normalize,
])`,wrap:!1}}),pA=new w({props:{title:"변환 함수 생성 (Transform Functions)",local:"변환-함수-생성-transform-functions",headingTag:"h3"}}),FA=new K({props:{code:"ZGVmJTIwYXBwbHlfdHJhaW5fdHJhbnNmb3JtcyhleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjBleGFtcGxlcyU1QidwaXhlbF92YWx1ZXMnJTVEJTIwJTNEJTIwJTVCdHJhaW5fdHJhbnNmb3JtcyhpbWFnZS5jb252ZXJ0KCUyMlJHQiUyMikpJTIwZm9yJTIwaW1hZ2UlMjBpbiUyMGV4YW1wbGVzJTVCJ2ltYWdlJyU1RCU1RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGV4YW1wbGVzJTBBJTBBZGVmJTIwYXBwbHlfdmFsX3RyYW5zZm9ybXMoZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlNUIncGl4ZWxfdmFsdWVzJyU1RCUyMCUzRCUyMCU1QnZhbF90cmFuc2Zvcm1zKGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSklMjBmb3IlMjBpbWFnZSUyMGluJTIwZXhhbXBsZXMlNUInaW1hZ2UnJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZXMlMEElMEFkZWYlMjBhcHBseV90ZXN0X3RyYW5zZm9ybXMoZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlNUIncGl4ZWxfdmFsdWVzJyU1RCUyMCUzRCUyMCU1QnZhbF90cmFuc2Zvcm1zKGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSklMjBmb3IlMjBpbWFnZSUyMGluJTIwZXhhbXBsZXMlNUInaW1hZ2UnJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">apply_train_transforms</span>(<span class="hljs-params">examples</span>):
    examples[<span class="hljs-string">&#x27;pixel_values&#x27;</span>] = [train_transforms(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&#x27;image&#x27;</span>]]
    <span class="hljs-keyword">return</span> examples

<span class="hljs-keyword">def</span> <span class="hljs-title function_">apply_val_transforms</span>(<span class="hljs-params">examples</span>):
    examples[<span class="hljs-string">&#x27;pixel_values&#x27;</span>] = [val_transforms(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&#x27;image&#x27;</span>]]
    <span class="hljs-keyword">return</span> examples

<span class="hljs-keyword">def</span> <span class="hljs-title function_">apply_test_transforms</span>(<span class="hljs-params">examples</span>):
    examples[<span class="hljs-string">&#x27;pixel_values&#x27;</span>] = [val_transforms(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&#x27;image&#x27;</span>]]
    <span class="hljs-keyword">return</span> examples`,wrap:!1}}),fA=new w({props:{title:"각 데이터셋에 변환 함수 적용",local:"각-데이터셋에-변환-함수-적용",headingTag:"h3"}}),JA=new K({props:{code:"dHJhaW5fZHMuc2V0X3RyYW5zZm9ybShhcHBseV90cmFpbl90cmFuc2Zvcm1zKSUwQXZhbF9kcy5zZXRfdHJhbnNmb3JtKGFwcGx5X3ZhbF90cmFuc2Zvcm1zKSUwQXRlc3RfZHMuc2V0X3RyYW5zZm9ybShhcHBseV90ZXN0X3RyYW5zZm9ybXMp",highlighted:`train_ds.set_transform(apply_train_transforms)
val_ds.set_transform(apply_val_transforms)
test_ds.set_transform(apply_test_transforms)`,wrap:!1}}),rA=new K({props:{code:"dHJhaW5fZHMuZmVhdHVyZXM=",highlighted:"train_ds.features",wrap:!1}}),KA=new K({props:{code:"dHJhaW5fZHMlNUIwJTVE",highlighted:'train_ds[<span class="hljs-number">0</span>]',wrap:!1}}),RA=new w({props:{title:"데이터 로딩",local:"데이터-로딩",headingTag:"h3"}}),CA=new K({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdG9yY2gudXRpbHMuZGF0YSUyMGltcG9ydCUyMERhdGFMb2FkZXIlMEElMEFkZWYlMjBjb2xsYXRlX2ZuKGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMHBpeGVsX3ZhbHVlcyUyMCUzRCUyMHRvcmNoLnN0YWNrKCU1QmV4YW1wbGUlNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMjBmb3IlMjBleGFtcGxlJTIwaW4lMjBleGFtcGxlcyU1RCklMEElMjAlMjAlMjAlMjBsYWJlbHMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCZXhhbXBsZSU1QiUyMmxhYmVsJTIyJTVEJTIwZm9yJTIwZXhhbXBsZSUyMGluJTIwZXhhbXBsZXMlNUQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIycGl4ZWxfdmFsdWVzJTIyJTNBJTIwcGl4ZWxfdmFsdWVzJTJDJTIwJTIybGFiZWxzJTIyJTNBJTIwbGFiZWxzJTdEJTBBJTBBdHJhaW5fZGwlMjAlM0QlMjBEYXRhTG9hZGVyKHRyYWluX2RzJTJDJTIwY29sbGF0ZV9mbiUzRGNvbGxhdGVfZm4lMkMlMjBiYXRjaF9zaXplJTNENCk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader

<span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">examples</span>):
    pixel_values = torch.stack([example[<span class="hljs-string">&quot;pixel_values&quot;</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples])
    labels = torch.tensor([example[<span class="hljs-string">&quot;label&quot;</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples])
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;pixel_values&quot;</span>: pixel_values, <span class="hljs-string">&quot;labels&quot;</span>: labels}

train_dl = DataLoader(train_ds, collate_fn=collate_fn, batch_size=<span class="hljs-number">4</span>)`,wrap:!1}}),mA=new w({props:{title:"배치 준비",local:"배치-준비",headingTag:"h3"}}),yA=new K({props:{code:"YmF0Y2glMjAlM0QlMjBuZXh0KGl0ZXIodHJhaW5fZGwpKSUwQWZvciUyMGslMkN2JTIwaW4lMjBiYXRjaC5pdGVtcygpJTNBJTBBJTIwJTIwaWYlMjBpc2luc3RhbmNlKHYlMkMlMjB0b3JjaC5UZW5zb3IpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoayUyQyUyMHYuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>batch = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(train_dl))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> k,v <span class="hljs-keyword">in</span> batch.items():
<span class="hljs-meta">... </span>  <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(v, torch.Tensor):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(k, v.shape)`,wrap:!1}}),VA=new w({props:{title:"모델 파인튜닝",local:"모델-파인튜닝",headingTag:"h2"}}),bA=new K({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpVEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMFZpVEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUlMkMlMjBpZDJsYWJlbCUzRGlkMmxhYmVsJTJDJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCUyQyUyMGlnbm9yZV9taXNtYXRjaGVkX3NpemVzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ViTForImageClassification

model = ViTForImageClassification.from_pretrained(model_name, id2label=id2label, label2id=label2id, ignore_mismatched_sizes=<span class="hljs-literal">True</span>)`,wrap:!1}}),xA=new K({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

train_args = TrainingArguments(
    output_dir = <span class="hljs-string">&quot;output-models&quot;</span>,
    <span class="hljs-comment">#save_total_limit=2,</span>
    <span class="hljs-comment">#report_to=&quot;wandb&quot;,</span>
    <span class="hljs-comment">#save_strategy=&quot;epoch&quot;,</span>
    <span class="hljs-comment">#evaluation_strategy=&quot;epoch&quot;,</span>
    learning_rate=<span class="hljs-number">2e-5</span>,
    per_device_train_batch_size=<span class="hljs-number">10</span>,
    per_device_eval_batch_size=<span class="hljs-number">4</span>,
    num_train_epochs=<span class="hljs-number">40</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
    <span class="hljs-comment">#load_best_model_at_end=True,</span>
    logging_dir=<span class="hljs-string">&#x27;logs&#x27;</span>,
    remove_unused_columns=<span class="hljs-literal">False</span>,
    report_to=<span class="hljs-string">&quot;none&quot;</span>
)

<span class="hljs-string">&quot;&quot;&quot;
# Updated by HJ
(현재 환경에서 TrainingArguments가 해당 인자들을 인식하지 못하는 오류(TypeError)가 발생하여
최소한의 설정만으로 Trainer가 동작하도록 수정한 버전임. 
중간값 저장이나 자동 평가 없이 단순 학습만 수행됨.)
&quot;&quot;&quot;</span>`,wrap:!1}}),XA=new K({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RzJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEdmFsX2RzJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGNvbGxhdGVfZm4lMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0Rwcm9jZXNzb3IlMkMlMEEpJTBBdHJhaW5lci50cmFpbigp",highlighted:`trainer = Trainer(
    model,
    train_args,
    train_dataset=train_ds,
    eval_dataset=val_ds,
    data_collator=collate_fn,
    tokenizer=processor,
)
trainer.train()`,wrap:!1}}),ZA=new K({props:{code:"b3V0cHV0cyUyMCUzRCUyMHRyYWluZXIucHJlZGljdCh0ZXN0X2RzKSUwQXByaW50KG91dHB1dHMubWV0cmljcyk=",highlighted:`outputs = trainer.predict(test_ds)
<span class="hljs-built_in">print</span>(outputs.metrics)`,wrap:!1}}),NA=new w({props:{title:"(선택 사항) 모델을 Hugging Face Hub에 업로드하기",local:"선택-사항-모델을-hugging-face-hub에-업로드하기",headingTag:"h3"}}),GA=new K({props:{code:"bW9kZWwucHVzaF90b19odWIoJTIyeW91cl9tb2RlbF9uYW1lJTIyKQ==",highlighted:'model.push_to_hub(<span class="hljs-string">&quot;your_model_name&quot;</span>)',wrap:!1}}),qA=new w({props:{title:"결과",local:"결과",headingTag:"h2"}}),OA=new w({props:{title:"Confusion Matrix 란?",local:"confusion-matrix-란",headingTag:"h3"}}),$A=new K({props:{code:"ZnJvbSUyMHNrbGVhcm4ubWV0cmljcyUyMGltcG9ydCUyMGNvbmZ1c2lvbl9tYXRyaXglMkMlMjBDb25mdXNpb25NYXRyaXhEaXNwbGF5JTBBJTBBeV90cnVlJTIwJTNEJTIwb3V0cHV0cy5sYWJlbF9pZHMlMEF5X3ByZWQlMjAlM0QlMjBvdXRwdXRzLnByZWRpY3Rpb25zLmFyZ21heCgxKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRyYWluX2RzLmZlYXR1cmVzJTVCJ2xhYmVsJyU1RC5uYW1lcyUwQWNtJTIwJTNEJTIwY29uZnVzaW9uX21hdHJpeCh5X3RydWUlMkMlMjB5X3ByZWQpJTBBZGlzcCUyMCUzRCUyMENvbmZ1c2lvbk1hdHJpeERpc3BsYXkoY29uZnVzaW9uX21hdHJpeCUzRGNtJTJDJTIwZGlzcGxheV9sYWJlbHMlM0RsYWJlbHMpJTBBZGlzcC5wbG90KHh0aWNrc19yb3RhdGlvbiUzRDQ1KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> sklearn.metrics <span class="hljs-keyword">import</span> confusion_matrix, ConfusionMatrixDisplay

<span class="hljs-meta">&gt;&gt;&gt; </span>y_true = outputs.label_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>y_pred = outputs.predictions.argmax(<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = train_ds.features[<span class="hljs-string">&#x27;label&#x27;</span>].names
<span class="hljs-meta">&gt;&gt;&gt; </span>cm = confusion_matrix(y_true, y_pred)
<span class="hljs-meta">&gt;&gt;&gt; </span>disp = ConfusionMatrixDisplay(confusion_matrix=cm, display_labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>disp.plot(xticks_rotation=<span class="hljs-number">45</span>)`,wrap:!1}}),_A=new w({props:{title:"Recall Score 란?",local:"recall-score-란",headingTag:"h3"}}),lt=new K({props:{code:"ZnJvbSUyMHNrbGVhcm4ubWV0cmljcyUyMGltcG9ydCUyMHJlY2FsbF9zY29yZSUwQSUwQSUyMyUyMFJlY2FsbCUyMHNjb3JlJTIwJUVBJUIzJTg0JUVDJTgyJUIwJTBBJTIzJTIwJUUyJTgwJTk4Tm9uZSVFMiU4MCU5OSVFQyU5QyVCQyVFQiVBMSU5QyUyMCVFQyU4NCVBNCVFQyVBMCU5NSVFRCU5NSU5OCVFQiVBOSVCNCUyMCVFQSVCMCU4MSUyMCVFRCU4MSVCNCVFQiU5RSU5OCVFQyU4QSVBNCVFQiVCMyU4NCVFQiVBMSU5QyUyMCVFQSVCMCU5QyVFQiVCMyU4NCVFQyVBMCU4MSVFQyU5QyVCQyVFQiVBMSU5QyUyMHJlY2FsbCVFQyU5RCU4NCUyMCVFQSVCMyU4NCVFQyU4MiVCMCVFRCU5NSVBOSVFQiU4QiU4OCVFQiU4QiVBNC4lMEFyZWNhbGwlMjAlM0QlMjByZWNhbGxfc2NvcmUoeV90cnVlJTJDJTIweV9wcmVkJTJDJTIwYXZlcmFnZSUzRE5vbmUpJTBBJTBBJTIzJTIwJUVBJUIwJTgxJTIwJUVEJTgxJUI0JUVCJTlFJTk4JUVDJThBJUE0JUVCJUIzJTg0JUVCJUExJTlDJTIwcmVjYWxsJTIwc2NvcmUlRUIlQTUlQkMlMjAlRUMlQjYlOUMlRUIlQTAlQTUlRUQlOTUlQTklRUIlOEIlODglRUIlOEIlQTQuJTBBZm9yJTIwbGFiZWwlMkMlMjBzY29yZSUyMGluJTIwemlwKGxhYmVscyUyQyUyMHJlY2FsbCklM0ElMEElMjAlMjAlMjAlMjBwcmludChmJ1JlY2FsbCUyMGZvciUyMCU3QmxhYmVsJTdEJTNBJTIwJTdCc2NvcmUlM0EuMmYlN0QnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> sklearn.metrics <span class="hljs-keyword">import</span> recall_score

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Recall score 계산</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># ‘None’으로 설정하면 각 클래스별로 개별적으로 recall을 계산합니다.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>recall = recall_score(y_true, y_pred, average=<span class="hljs-literal">None</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 각 클래스별로 recall score를 출력합니다.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> label, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(labels, recall):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Recall for <span class="hljs-subst">{label}</span>: <span class="hljs-subst">{score:<span class="hljs-number">.2</span>f}</span>&#x27;</span>)`,wrap:!1}}),at=new w({props:{title:"결론",local:"결론",headingTag:"h2"}}),ot=new Vs({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/ko/fine_tuning_vit_custom_dataset_ko.md"}}),{c(){R=n("meta"),rt=s(),ft=n("p"),Kt=s(),o(C.$$.fragment),wt=s(),o(m.$$.fragment),Rt=s(),o(y.$$.fragment),Ct=s(),j=n("p"),j.innerHTML=Je,mt=s(),T=n("p"),T.innerHTML=re,yt=s(),M=n("p"),M.textContent=Ke,jt=s(),V=n("p"),V.textContent=we,Tt=s(),c=n("p"),c.textContent=Re,Mt=s(),o(g.$$.fragment),Vt=s(),B=n("p"),B.textContent=Ce,ct=s(),b=n("p"),b.innerHTML=me,gt=s(),o(u.$$.fragment),Bt=s(),Q=n("p"),Q.innerHTML=ye,bt=s(),h=n("p"),h.textContent=je,ut=s(),o(P.$$.fragment),Qt=s(),d=n("p"),d.textContent=Te,ht=s(),o(I.$$.fragment),Pt=s(),o(x.$$.fragment),dt=s(),k=n("p"),k.textContent=Me,It=s(),o(X.$$.fragment),xt=s(),o(H.$$.fragment),kt=s(),v=n("p"),v.innerHTML=Ve,Xt=s(),o(Z.$$.fragment),Ht=s(),W=n("p"),W.textContent=ce,vt=s(),N=n("p"),N.textContent=ge,Zt=s(),D=n("p"),D.textContent=Be,Wt=s(),o(G.$$.fragment),Nt=s(),z=n("p"),z.textContent=be,Dt=s(),o(q.$$.fragment),Gt=s(),Y=n("p"),Y.textContent=ue,zt=s(),S=n("p"),S.textContent=Qe,qt=s(),o(O.$$.fragment),Yt=s(),E=n("p"),E.innerHTML=he,St=s(),o(L.$$.fragment),Ot=s(),$=n("p"),$.textContent=Pe,Et=s(),o(_.$$.fragment),Lt=s(),AA=n("p"),AA.textContent=de,$t=s(),o(tA.$$.fragment),_t=s(),pt=n("img"),Al=s(),o(lA.$$.fragment),tl=s(),eA=n("p"),eA.textContent=xe,ll=s(),sA=n("ul"),sA.innerHTML=ke,el=s(),o(aA.$$.fragment),sl=s(),o(nA.$$.fragment),al=s(),o(UA.$$.fragment),nl=s(),o(iA.$$.fragment),Ul=s(),o(oA.$$.fragment),il=s(),o(pA.$$.fragment),ol=s(),o(FA.$$.fragment),pl=s(),o(fA.$$.fragment),Fl=s(),o(JA.$$.fragment),fl=s(),o(rA.$$.fragment),Jl=s(),o(KA.$$.fragment),rl=s(),wA=n("p"),wA.textContent=Xe,Kl=s(),o(RA.$$.fragment),wl=s(),o(CA.$$.fragment),Rl=s(),o(mA.$$.fragment),Cl=s(),o(yA.$$.fragment),ml=s(),jA=n("pre"),jA.textContent=He,yl=s(),TA=n("p"),TA.textContent=ve,jl=s(),MA=n("p"),MA.textContent=Ze,Tl=s(),o(VA.$$.fragment),Ml=s(),cA=n("p"),cA.textContent=We,Vl=s(),gA=n("p"),gA.textContent=Ne,cl=s(),BA=n("p"),BA.textContent=De,gl=s(),o(bA.$$.fragment),Bl=s(),uA=n("p"),uA.innerHTML=Ge,bl=s(),QA=n("p"),QA.textContent=ze,ul=s(),hA=n("p"),hA.innerHTML=qe,Ql=s(),PA=n("p"),PA.innerHTML=Ye,hl=s(),dA=n("p"),dA.textContent=Se,Pl=s(),IA=n("p"),IA.innerHTML=Oe,dl=s(),o(xA.$$.fragment),Il=s(),kA=n("p"),kA.textContent=Ee,xl=s(),o(XA.$$.fragment),kl=s(),HA=n("table"),HA.innerHTML=Le,Xl=s(),vA=n("p"),vA.textContent=$e,Hl=s(),o(ZA.$$.fragment),vl=s(),WA=n("p"),WA.innerHTML=_e,Zl=s(),o(NA.$$.fragment),Wl=s(),DA=n("p"),DA.innerHTML=As,Nl=s(),o(GA.$$.fragment),Dl=s(),zA=n("p"),zA.textContent=ts,Gl=s(),o(qA.$$.fragment),zl=s(),YA=n("p"),YA.textContent=ls,ql=s(),SA=n("p"),SA.textContent=es,Yl=s(),o(OA.$$.fragment),Sl=s(),EA=n("p"),EA.textContent=ss,Ol=s(),LA=n("p"),LA.textContent=as,El=s(),o($A.$$.fragment),Ll=s(),Ft=n("img"),$l=s(),o(_A.$$.fragment),_l=s(),At=n("p"),At.textContent=Us,Ae=s(),tt=n("p"),tt.textContent=is,te=s(),o(lt.$$.fragment),le=s(),et=n("pre"),et.textContent=os,ee=s(),st=n("p"),st.innerHTML=ps,se=s(),o(at.$$.fragment),ae=s(),nt=n("p"),nt.textContent=Fs,ne=s(),Ut=n("p"),Ut.textContent=fs,Ue=s(),it=n("p"),it.innerHTML=Js,ie=s(),o(ot.$$.fragment),oe=s(),Jt=n("p"),this.h()},l(A){const t=js("svelte-u9bgzb",document.head);R=U(t,"META",{name:!0,content:!0}),t.forEach(l),rt=a(A),ft=U(A,"P",{}),Ks(ft).forEach(l),Kt=a(A),p(C.$$.fragment,A),wt=a(A),p(m.$$.fragment,A),Rt=a(A),p(y.$$.fragment,A),Ct=a(A),j=U(A,"P",{"data-svelte-h":!0}),i(j)!=="svelte-1u44ov"&&(j.innerHTML=Je),mt=a(A),T=U(A,"P",{"data-svelte-h":!0}),i(T)!=="svelte-a9spbe"&&(T.innerHTML=re),yt=a(A),M=U(A,"P",{"data-svelte-h":!0}),i(M)!=="svelte-1cdgjs8"&&(M.textContent=Ke),jt=a(A),V=U(A,"P",{"data-svelte-h":!0}),i(V)!=="svelte-mwrpqi"&&(V.textContent=we),Tt=a(A),c=U(A,"P",{"data-svelte-h":!0}),i(c)!=="svelte-1cdgjs8"&&(c.textContent=Re),Mt=a(A),p(g.$$.fragment,A),Vt=a(A),B=U(A,"P",{"data-svelte-h":!0}),i(B)!=="svelte-y21h14"&&(B.textContent=Ce),ct=a(A),b=U(A,"P",{"data-svelte-h":!0}),i(b)!=="svelte-6ujxmm"&&(b.innerHTML=me),gt=a(A),p(u.$$.fragment,A),Bt=a(A),Q=U(A,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-10smyb1"&&(Q.innerHTML=ye),bt=a(A),h=U(A,"P",{"data-svelte-h":!0}),i(h)!=="svelte-1607a7e"&&(h.textContent=je),ut=a(A),p(P.$$.fragment,A),Qt=a(A),d=U(A,"P",{"data-svelte-h":!0}),i(d)!=="svelte-fn7f73"&&(d.textContent=Te),ht=a(A),p(I.$$.fragment,A),Pt=a(A),p(x.$$.fragment,A),dt=a(A),k=U(A,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1srlqax"&&(k.textContent=Me),It=a(A),p(X.$$.fragment,A),xt=a(A),p(H.$$.fragment,A),kt=a(A),v=U(A,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1wujuzk"&&(v.innerHTML=Ve),Xt=a(A),p(Z.$$.fragment,A),Ht=a(A),W=U(A,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1fgk42r"&&(W.textContent=ce),vt=a(A),N=U(A,"P",{"data-svelte-h":!0}),i(N)!=="svelte-8efgbh"&&(N.textContent=ge),Zt=a(A),D=U(A,"P",{"data-svelte-h":!0}),i(D)!=="svelte-4s3y2u"&&(D.textContent=Be),Wt=a(A),p(G.$$.fragment,A),Nt=a(A),z=U(A,"P",{"data-svelte-h":!0}),i(z)!=="svelte-134ukwo"&&(z.textContent=be),Dt=a(A),p(q.$$.fragment,A),Gt=a(A),Y=U(A,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-y88go9"&&(Y.textContent=ue),zt=a(A),S=U(A,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1j11drs"&&(S.textContent=Qe),qt=a(A),p(O.$$.fragment,A),Yt=a(A),E=U(A,"P",{"data-svelte-h":!0}),i(E)!=="svelte-gm880p"&&(E.innerHTML=he),St=a(A),p(L.$$.fragment,A),Ot=a(A),$=U(A,"P",{"data-svelte-h":!0}),i($)!=="svelte-2ngq86"&&($.textContent=Pe),Et=a(A),p(_.$$.fragment,A),Lt=a(A),AA=U(A,"P",{"data-svelte-h":!0}),i(AA)!=="svelte-1gwuceh"&&(AA.textContent=de),$t=a(A),p(tA.$$.fragment,A),_t=a(A),pt=U(A,"IMG",{src:!0}),Al=a(A),p(lA.$$.fragment,A),tl=a(A),eA=U(A,"P",{"data-svelte-h":!0}),i(eA)!=="svelte-9vtyum"&&(eA.textContent=xe),ll=a(A),sA=U(A,"UL",{"data-svelte-h":!0}),i(sA)!=="svelte-785e71"&&(sA.innerHTML=ke),el=a(A),p(aA.$$.fragment,A),sl=a(A),p(nA.$$.fragment,A),al=a(A),p(UA.$$.fragment,A),nl=a(A),p(iA.$$.fragment,A),Ul=a(A),p(oA.$$.fragment,A),il=a(A),p(pA.$$.fragment,A),ol=a(A),p(FA.$$.fragment,A),pl=a(A),p(fA.$$.fragment,A),Fl=a(A),p(JA.$$.fragment,A),fl=a(A),p(rA.$$.fragment,A),Jl=a(A),p(KA.$$.fragment,A),rl=a(A),wA=U(A,"P",{"data-svelte-h":!0}),i(wA)!=="svelte-10gbrx2"&&(wA.textContent=Xe),Kl=a(A),p(RA.$$.fragment,A),wl=a(A),p(CA.$$.fragment,A),Rl=a(A),p(mA.$$.fragment,A),Cl=a(A),p(yA.$$.fragment,A),ml=a(A),jA=U(A,"PRE",{"data-svelte-h":!0}),i(jA)!=="svelte-1er930r"&&(jA.textContent=He),yl=a(A),TA=U(A,"P",{"data-svelte-h":!0}),i(TA)!=="svelte-klhtkw"&&(TA.textContent=ve),jl=a(A),MA=U(A,"P",{"data-svelte-h":!0}),i(MA)!=="svelte-16on9hv"&&(MA.textContent=Ze),Tl=a(A),p(VA.$$.fragment,A),Ml=a(A),cA=U(A,"P",{"data-svelte-h":!0}),i(cA)!=="svelte-1l71i8y"&&(cA.textContent=We),Vl=a(A),gA=U(A,"P",{"data-svelte-h":!0}),i(gA)!=="svelte-rj9h7j"&&(gA.textContent=Ne),cl=a(A),BA=U(A,"P",{"data-svelte-h":!0}),i(BA)!=="svelte-1ew92ug"&&(BA.textContent=De),gl=a(A),p(bA.$$.fragment,A),Bl=a(A),uA=U(A,"P",{"data-svelte-h":!0}),i(uA)!=="svelte-q5dkpk"&&(uA.innerHTML=Ge),bl=a(A),QA=U(A,"P",{"data-svelte-h":!0}),i(QA)!=="svelte-pt0zi2"&&(QA.textContent=ze),ul=a(A),hA=U(A,"P",{"data-svelte-h":!0}),i(hA)!=="svelte-1mib3ig"&&(hA.innerHTML=qe),Ql=a(A),PA=U(A,"P",{"data-svelte-h":!0}),i(PA)!=="svelte-s55go2"&&(PA.innerHTML=Ye),hl=a(A),dA=U(A,"P",{"data-svelte-h":!0}),i(dA)!=="svelte-3huroh"&&(dA.textContent=Se),Pl=a(A),IA=U(A,"P",{"data-svelte-h":!0}),i(IA)!=="svelte-1yjq3tf"&&(IA.innerHTML=Oe),dl=a(A),p(xA.$$.fragment,A),Il=a(A),kA=U(A,"P",{"data-svelte-h":!0}),i(kA)!=="svelte-cljt69"&&(kA.textContent=Ee),xl=a(A),p(XA.$$.fragment,A),kl=a(A),HA=U(A,"TABLE",{"data-svelte-h":!0}),i(HA)!=="svelte-p43m3o"&&(HA.innerHTML=Le),Xl=a(A),vA=U(A,"P",{"data-svelte-h":!0}),i(vA)!=="svelte-106j3qt"&&(vA.textContent=$e),Hl=a(A),p(ZA.$$.fragment,A),vl=a(A),WA=U(A,"P",{"data-svelte-h":!0}),i(WA)!=="svelte-189m2kt"&&(WA.innerHTML=_e),Zl=a(A),p(NA.$$.fragment,A),Wl=a(A),DA=U(A,"P",{"data-svelte-h":!0}),i(DA)!=="svelte-q1n4h1"&&(DA.innerHTML=As),Nl=a(A),p(GA.$$.fragment,A),Dl=a(A),zA=U(A,"P",{"data-svelte-h":!0}),i(zA)!=="svelte-1vvjod9"&&(zA.textContent=ts),Gl=a(A),p(qA.$$.fragment,A),zl=a(A),YA=U(A,"P",{"data-svelte-h":!0}),i(YA)!=="svelte-1wo0h4m"&&(YA.textContent=ls),ql=a(A),SA=U(A,"P",{"data-svelte-h":!0}),i(SA)!=="svelte-1b5wiyn"&&(SA.textContent=es),Yl=a(A),p(OA.$$.fragment,A),Sl=a(A),EA=U(A,"P",{"data-svelte-h":!0}),i(EA)!=="svelte-1bjlei1"&&(EA.textContent=ss),Ol=a(A),LA=U(A,"P",{"data-svelte-h":!0}),i(LA)!=="svelte-btctnh"&&(LA.textContent=as),El=a(A),p($A.$$.fragment,A),Ll=a(A),Ft=U(A,"IMG",{src:!0}),$l=a(A),p(_A.$$.fragment,A),_l=a(A),At=U(A,"P",{"data-svelte-h":!0}),i(At)!=="svelte-ckllml"&&(At.textContent=Us),Ae=a(A),tt=U(A,"P",{"data-svelte-h":!0}),i(tt)!=="svelte-1ltxpqd"&&(tt.textContent=is),te=a(A),p(lt.$$.fragment,A),le=a(A),et=U(A,"PRE",{"data-svelte-h":!0}),i(et)!=="svelte-haskcw"&&(et.textContent=os),ee=a(A),st=U(A,"P",{"data-svelte-h":!0}),i(st)!=="svelte-1yin7k0"&&(st.innerHTML=ps),se=a(A),p(at.$$.fragment,A),ae=a(A),nt=U(A,"P",{"data-svelte-h":!0}),i(nt)!=="svelte-10oerag"&&(nt.textContent=Fs),ne=a(A),Ut=U(A,"P",{"data-svelte-h":!0}),i(Ut)!=="svelte-10ho7b2"&&(Ut.textContent=fs),Ue=a(A),it=U(A,"P",{"data-svelte-h":!0}),i(it)!=="svelte-gay6kq"&&(it.innerHTML=Js),ie=a(A),p(ot.$$.fragment,A),oe=a(A),Jt=U(A,"P",{}),Ks(Jt).forEach(l),this.h()},h(){Fe(R,"name","hf:doc:metadata"),Fe(R,"content",Bs),rs(pt.src,Ie="data:image/jpeg;base64,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")||Fe(pt,"src",Ie),rs(Ft.src,ns="data:image/jpeg;base64,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")||Fe(Ft,"src",ns)},m(A,t){Ts(document.head,R),e(A,rt,t),e(A,ft,t),e(A,Kt,t),F(C,A,t),e(A,wt,t),F(m,A,t),e(A,Rt,t),F(y,A,t),e(A,Ct,t),e(A,j,t),e(A,mt,t),e(A,T,t),e(A,yt,t),e(A,M,t),e(A,jt,t),e(A,V,t),e(A,Tt,t),e(A,c,t),e(A,Mt,t),F(g,A,t),e(A,Vt,t),e(A,B,t),e(A,ct,t),e(A,b,t),e(A,gt,t),F(u,A,t),e(A,Bt,t),e(A,Q,t),e(A,bt,t),e(A,h,t),e(A,ut,t),F(P,A,t),e(A,Qt,t),e(A,d,t),e(A,ht,t),F(I,A,t),e(A,Pt,t),F(x,A,t),e(A,dt,t),e(A,k,t),e(A,It,t),F(X,A,t),e(A,xt,t),F(H,A,t),e(A,kt,t),e(A,v,t),e(A,Xt,t),F(Z,A,t),e(A,Ht,t),e(A,W,t),e(A,vt,t),e(A,N,t),e(A,Zt,t),e(A,D,t),e(A,Wt,t),F(G,A,t),e(A,Nt,t),e(A,z,t),e(A,Dt,t),F(q,A,t),e(A,Gt,t),e(A,Y,t),e(A,zt,t),e(A,S,t),e(A,qt,t),F(O,A,t),e(A,Yt,t),e(A,E,t),e(A,St,t),F(L,A,t),e(A,Ot,t),e(A,$,t),e(A,Et,t),F(_,A,t),e(A,Lt,t),e(A,AA,t),e(A,$t,t),F(tA,A,t),e(A,_t,t),e(A,pt,t),e(A,Al,t),F(lA,A,t),e(A,tl,t),e(A,eA,t),e(A,ll,t),e(A,sA,t),e(A,el,t),F(aA,A,t),e(A,sl,t),F(nA,A,t),e(A,al,t),F(UA,A,t),e(A,nl,t),F(iA,A,t),e(A,Ul,t),F(oA,A,t),e(A,il,t),F(pA,A,t),e(A,ol,t),F(FA,A,t),e(A,pl,t),F(fA,A,t),e(A,Fl,t),F(JA,A,t),e(A,fl,t),F(rA,A,t),e(A,Jl,t),F(KA,A,t),e(A,rl,t),e(A,wA,t),e(A,Kl,t),F(RA,A,t),e(A,wl,t),F(CA,A,t),e(A,Rl,t),F(mA,A,t),e(A,Cl,t),F(yA,A,t),e(A,ml,t),e(A,jA,t),e(A,yl,t),e(A,TA,t),e(A,jl,t),e(A,MA,t),e(A,Tl,t),F(VA,A,t),e(A,Ml,t),e(A,cA,t),e(A,Vl,t),e(A,gA,t),e(A,cl,t),e(A,BA,t),e(A,gl,t),F(bA,A,t),e(A,Bl,t),e(A,uA,t),e(A,bl,t),e(A,QA,t),e(A,ul,t),e(A,hA,t),e(A,Ql,t),e(A,PA,t),e(A,hl,t),e(A,dA,t),e(A,Pl,t),e(A,IA,t),e(A,dl,t),F(xA,A,t),e(A,Il,t),e(A,kA,t),e(A,xl,t),F(XA,A,t),e(A,kl,t),e(A,HA,t),e(A,Xl,t),e(A,vA,t),e(A,Hl,t),F(ZA,A,t),e(A,vl,t),e(A,WA,t),e(A,Zl,t),F(NA,A,t),e(A,Wl,t),e(A,DA,t),e(A,Nl,t),F(GA,A,t),e(A,Dl,t),e(A,zA,t),e(A,Gl,t),F(qA,A,t),e(A,zl,t),e(A,YA,t),e(A,ql,t),e(A,SA,t),e(A,Yl,t),F(OA,A,t),e(A,Sl,t),e(A,EA,t),e(A,Ol,t),e(A,LA,t),e(A,El,t),F($A,A,t),e(A,Ll,t),e(A,Ft,t),e(A,$l,t),F(_A,A,t),e(A,_l,t),e(A,At,t),e(A,Ae,t),e(A,tt,t),e(A,te,t),F(lt,A,t),e(A,le,t),e(A,et,t),e(A,ee,t),e(A,st,t),e(A,se,t),F(at,A,t),e(A,ae,t),e(A,nt,t),e(A,ne,t),e(A,Ut,t),e(A,Ue,t),e(A,it,t),e(A,ie,t),F(ot,A,t),e(A,oe,t),e(A,Jt,t),pe=!0},p:Rs,i(A){pe||(f(C.$$.fragment,A),f(m.$$.fragment,A),f(y.$$.fragment,A),f(g.$$.fragment,A),f(u.$$.fragment,A),f(P.$$.fragment,A),f(I.$$.fragment,A),f(x.$$.fragment,A),f(X.$$.fragment,A),f(H.$$.fragment,A),f(Z.$$.fragment,A),f(G.$$.fragment,A),f(q.$$.fragment,A),f(O.$$.fragment,A),f(L.$$.fragment,A),f(_.$$.fragment,A),f(tA.$$.fragment,A),f(lA.$$.fragment,A),f(aA.$$.fragment,A),f(nA.$$.fragment,A),f(UA.$$.fragment,A),f(iA.$$.fragment,A),f(oA.$$.fragment,A),f(pA.$$.fragment,A),f(FA.$$.fragment,A),f(fA.$$.fragment,A),f(JA.$$.fragment,A),f(rA.$$.fragment,A),f(KA.$$.fragment,A),f(RA.$$.fragment,A),f(CA.$$.fragment,A),f(mA.$$.fragment,A),f(yA.$$.fragment,A),f(VA.$$.fragment,A),f(bA.$$.fragment,A),f(xA.$$.fragment,A),f(XA.$$.fragment,A),f(ZA.$$.fragment,A),f(NA.$$.fragment,A),f(GA.$$.fragment,A),f(qA.$$.fragment,A),f(OA.$$.fragment,A),f($A.$$.fragment,A),f(_A.$$.fragment,A),f(lt.$$.fragment,A),f(at.$$.fragment,A),f(ot.$$.fragment,A),pe=!0)},o(A){J(C.$$.fragment,A),J(m.$$.fragment,A),J(y.$$.fragment,A),J(g.$$.fragment,A),J(u.$$.fragment,A),J(P.$$.fragment,A),J(I.$$.fragment,A),J(x.$$.fragment,A),J(X.$$.fragment,A),J(H.$$.fragment,A),J(Z.$$.fragment,A),J(G.$$.fragment,A),J(q.$$.fragment,A),J(O.$$.fragment,A),J(L.$$.fragment,A),J(_.$$.fragment,A),J(tA.$$.fragment,A),J(lA.$$.fragment,A),J(aA.$$.fragment,A),J(nA.$$.fragment,A),J(UA.$$.fragment,A),J(iA.$$.fragment,A),J(oA.$$.fragment,A),J(pA.$$.fragment,A),J(FA.$$.fragment,A),J(fA.$$.fragment,A),J(JA.$$.fragment,A),J(rA.$$.fragment,A),J(KA.$$.fragment,A),J(RA.$$.fragment,A),J(CA.$$.fragment,A),J(mA.$$.fragment,A),J(yA.$$.fragment,A),J(VA.$$.fragment,A),J(bA.$$.fragment,A),J(xA.$$.fragment,A),J(XA.$$.fragment,A),J(ZA.$$.fragment,A),J(NA.$$.fragment,A),J(GA.$$.fragment,A),J(qA.$$.fragment,A),J(OA.$$.fragment,A),J($A.$$.fragment,A),J(_A.$$.fragment,A),J(lt.$$.fragment,A),J(at.$$.fragment,A),J(ot.$$.fragment,A),pe=!1},d(A){A&&(l(rt),l(ft),l(Kt),l(wt),l(Rt),l(Ct),l(j),l(mt),l(T),l(yt),l(M),l(jt),l(V),l(Tt),l(c),l(Mt),l(Vt),l(B),l(ct),l(b),l(gt),l(Bt),l(Q),l(bt),l(h),l(ut),l(Qt),l(d),l(ht),l(Pt),l(dt),l(k),l(It),l(xt),l(kt),l(v),l(Xt),l(Ht),l(W),l(vt),l(N),l(Zt),l(D),l(Wt),l(Nt),l(z),l(Dt),l(Gt),l(Y),l(zt),l(S),l(qt),l(Yt),l(E),l(St),l(Ot),l($),l(Et),l(Lt),l(AA),l($t),l(_t),l(pt),l(Al),l(tl),l(eA),l(ll),l(sA),l(el),l(sl),l(al),l(nl),l(Ul),l(il),l(ol),l(pl),l(Fl),l(fl),l(Jl),l(rl),l(wA),l(Kl),l(wl),l(Rl),l(Cl),l(ml),l(jA),l(yl),l(TA),l(jl),l(MA),l(Tl),l(Ml),l(cA),l(Vl),l(gA),l(cl),l(BA),l(gl),l(Bl),l(uA),l(bl),l(QA),l(ul),l(hA),l(Ql),l(PA),l(hl),l(dA),l(Pl),l(IA),l(dl),l(Il),l(kA),l(xl),l(kl),l(HA),l(Xl),l(vA),l(Hl),l(vl),l(WA),l(Zl),l(Wl),l(DA),l(Nl),l(Dl),l(zA),l(Gl),l(zl),l(YA),l(ql),l(SA),l(Yl),l(Sl),l(EA),l(Ol),l(LA),l(El),l(Ll),l(Ft),l($l),l(_l),l(At),l(Ae),l(tt),l(te),l(le),l(et),l(ee),l(st),l(se),l(ae),l(nt),l(ne),l(Ut),l(Ue),l(it),l(ie),l(oe),l(Jt)),l(R),r(C,A),r(m,A),r(y,A),r(g,A),r(u,A),r(P,A),r(I,A),r(x,A),r(X,A),r(H,A),r(Z,A),r(G,A),r(q,A),r(O,A),r(L,A),r(_,A),r(tA,A),r(lA,A),r(aA,A),r(nA,A),r(UA,A),r(iA,A),r(oA,A),r(pA,A),r(FA,A),r(fA,A),r(JA,A),r(rA,A),r(KA,A),r(RA,A),r(CA,A),r(mA,A),r(yA,A),r(VA,A),r(bA,A),r(xA,A),r(XA,A),r(ZA,A),r(NA,A),r(GA,A),r(qA,A),r(OA,A),r($A,A),r(_A,A),r(lt,A),r(at,A),r(ot,A)}}}const Bs='{"title":"Custom Biomedical Dataset으로 Vision Transformer 모델 Fine-tuning 하기","local":"custom-biomedical-dataset으로-vision-transformer-모델-fine-tuning-하기","sections":[{"title":"데이터셋 정보","local":"데이터셋-정보","sections":[],"depth":2},{"title":"모델 정보","local":"모델-정보","sections":[],"depth":2},{"title":"시작","local":"시작","sections":[],"depth":2},{"title":"데이터셋 준비","local":"데이터셋-준비","sections":[],"depth":2},{"title":"데이터 전처리","local":"데이터-전처리","sections":[{"title":"레이블 매핑 (Label Mapping)","local":"레이블-매핑-label-mapping","sections":[],"depth":3},{"title":"이미지 전처리 (Image Processing)","local":"이미지-전처리-image-processing","sections":[],"depth":3},{"title":"변환 함수 생성 (Transform Functions)","local":"변환-함수-생성-transform-functions","sections":[],"depth":3},{"title":"각 데이터셋에 변환 함수 적용","local":"각-데이터셋에-변환-함수-적용","sections":[],"depth":3},{"title":"데이터 로딩","local":"데이터-로딩","sections":[],"depth":3},{"title":"배치 준비","local":"배치-준비","sections":[],"depth":3}],"depth":2},{"title":"모델 파인튜닝","local":"모델-파인튜닝","sections":[{"title":"(선택 사항) 모델을 Hugging Face Hub에 업로드하기","local":"선택-사항-모델을-hugging-face-hub에-업로드하기","sections":[],"depth":3}],"depth":2},{"title":"결과","local":"결과","sections":[{"title":"Confusion Matrix 란?","local":"confusion-matrix-란","sections":[],"depth":3},{"title":"Recall Score 란?","local":"recall-score-란","sections":[],"depth":3}],"depth":2},{"title":"결론","local":"결론","sections":[],"depth":2}],"depth":1}';function bs(fe){return Cs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ds extends ms{constructor(R){super(),ys(this,R,bs,gs,ws,{})}}export{ds as component};
