import{s as Ln,a as qn,n as Pn,o as Dn}from"../chunks/scheduler.1f027d5a.js";import{S as Kn,i as On,e as i,s as n,c as m,h as ea,a as p,d as l,b as a,f as Fn,g as r,j as M,k as vs,l as ta,m as s,n as o,t as c,o as y,p as h}from"../chunks/index.6117a65d.js";import{C as la}from"../chunks/CopyLLMTxtMenu.93325501.js";import{D as sa,C as w}from"../chunks/DocNotebookDropdown.316c3715.js";import{H as U,E as na}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.0eecd2bb.js";function aa(Gs){let J,dt,jt,bt,u,It,C,xt,T,gt,j,Zs='<em>作者:<a href="https://github.com/peremartra" rel="nofollow">Pere Martra</a></em>',$t,f,Bs="在这个 notebook 中，我们将使用一个现成的模型和 Chroma 数据库来搭建一个常见的 RAG 系统。<strong>但我们会加入一个新功能，就是一个语义缓存系统，它会保存用户的各种问题，并决定是直接用数据库的信息来回答问题，还是用之前保存的问题答案。</strong>",vt,d,ks="这个语义缓存系统的目的是找出用户提出的问题中哪些是相似的或者是一样的。如果找到了一个之前问过的问题，系统就会直接用缓存里的答案来回答，这样就不用再去数据库里找了。",Gt,b,Ws="因为这个系统会考虑问题的实际意思，所以即使问题表达的方式不同，或者有些小错误，比如拼写或句子结构不对，系统也能识别出用户其实是在问同一个问题。",Zt,I,_s="比如，像 <strong>法国的首都是什么？</strong>、<strong>告诉我法国的首都叫什么？</strong> 和 <strong>法国的首都是什么？</strong> 这样的问题，虽然问法不一样，但都是在问同一个事情。",Bt,x,Ns="虽然根据问题的不同，模型的回答可能会有点不一样，但基本上从数据库里拿到的信息应该是相同的。这就是为什么我们把缓存系统放在用户和数据库之间，而不是用户和语言模型之间。",kt,Tt,As,Wt,g,Rs="大多数教程指导你创建一个 RAG 系统，这些教程都是为单个用户设计的，用于在测试环境中运行。换句话说，就是在笔记本中与本地向量数据库交互，以及进行 API 调用或使用本地存储的模型。",_t,$,Ss="当尝试将其中一种模型过渡到生产环境时，这种架构很快就显得不够用了，在生产环境中，它们可能会遇到从几十到成千上万次的重复请求。",Nt,v,Vs="提高性能的一种方法是通过一个或多个语义缓存。这个缓存保留了以前请求的结果，并且在解决新请求之前，它会检查是否之前收到过类似的请求。如果是这样，它就不会重新执行过程，而是从缓存中检索信息。",At,G,zs="在 RAG 系统中，有两个耗时的点：",Rt,Z,Es="<li>检索用于构建丰富提示的信息：</li> <li>调用大型语言模型以获得响应。</li>",St,B,Ys="在这两点上，都可以实现语义缓存系统，我们甚至可以有两个缓存，每个点一个。",Vt,k,Qs="将缓存系统放在模型的响应点可能会导致对获得响应的影响减少。我们的缓存系统可能会将”用 10 个词解释法国大革命”和”用 100 个词解释法国大革命”视为相同的查询。如果我们的缓存系统存储模型响应，用户可能会认为他们的指令没有被准确地遵循。",zt,W,Hs="但是，两个请求都需要相同的信息来丰富提示。这就是我选择将语义缓存系统放置在用户请求和从向量数据库检索信息之间的主要原因。",Et,_,Xs="然而，这是一个设计决策。根据响应类型和系统请求的不同，它可以被放置在一个点或另一个点。很明显，缓存模型响应会节省最多的时间，但正如我已经解释过的，这样做会牺牲用户对响应的影响。",Yt,N,Qt,A,Fs="首先，我们需要安装必要的 Python 包。",Ht,R,Ls='<li><strong><a href="http:/www.sbert.net/" rel="nofollow">sentence transformers</a></strong>。这个库用于将句子转换为固定长度的向量，也称为嵌入。</li> <li><strong><a href="https://github.com/facebookresearch/xformers" rel="nofollow">xformers</a></strong>。这是一个提供库和工具的包，以便与 transformers 模型一起使用。我们需要安装它，以避免在处理模型和嵌入时出现错误。</li> <li><strong><a href="https://www.trychroma.com/" rel="nofollow">chromadb</a></strong>。这是我们的向量数据库。ChromaDB 易于使用且开源，可能是用于存储嵌入的最常用的向量数据库。</li> <li><strong><a href="https://github.com/huggingface/accelerate" rel="nofollow">accelerate</a></strong>。在 GPU 上运行模型的必要条件。</li>',Xt,S,Ft,V,Lt,z,qt,E,qs="由于我们在一个免费且有限的空间中工作，并且只能使用几 GB 的内存，我通过变量 <code>MAX_ROWS</code> 限制了从数据集中使用的行数。",Pt,Y,Dt,Q,Kt,H,Ps="ChromaDB 要求数据具有唯一的标识符。我们可以使用这个语句来创建一个名为<strong>Id</strong>的新列。",Ot,X,el,F,tl,L,ll,q,sl,P,Ds="为了存储信息，我选择使用 ChromaDB，这是最知名且广泛使用的开源向量数据库之一。",nl,D,Ks="首先我们需要导入 ChromaDB。",al,K,il,O,Os="现在我们只需要指定存储向量数据库的路径。",pl,ee,Ml,te,ml,le,en=`ChromaDB 中的数据存储在集合中。如果集合已存在，我们需要删除它。
在接下来的行中，我们通过调用上面创建的 <code>chroma_client</code> 中的 <code>create_collection</code> 函数来创建集合。`,rl,se,ol,ne,tn="现在我们准备好使用 <code>add</code> 函数将数据添加到集合中。这个函数需要三个关键信息：",cl,ae,ln="<li>在 <strong>文档</strong> 中，我们存储数据集中 <code>Answer</code> 列的内容。</li> <li>在 <strong>元数据</strong> 中，我们可以提供一个主题列表。我使用了 <code>qtype</code> 列中的值。</li> <li>在 <strong>id</strong> 中，我们需要为每一行提供一个唯一的标识符。我使用 <code>MAX_ROWS</code> 的范围来创建ID。</li>",yl,ie,hl,pe,sn="一旦我们在数据库中有了信息，我们就可以查询它，并请求符合我们需求的数据。搜索是在文档内容内部进行的，它不会查找确切的单词或短语。结果将基于搜索词与文档内容之间的相似性。",wl,Me,nn="元数据在初始搜索过程中并不直接参与，它可以在检索后用于过滤或细化结果，从而实现进一步的定制和精确性。",Ul,me,an="让我们定义一个函数来查询 ChromaDB 数据库。",Jl,re,ul,oe,Cl,ce,pn="为了实现缓存系统，我们将使用 Faiss 库，该库允许在内存中存储嵌入。这和 Chroma 做的事情很相似，但没有其持久性。",Tl,ye,Mn="为此，我们将创建一个名为 <code>semantic_cache</code> 的类，它将使用自己的编码器，并为用户提供执行查询所需的函数。",jl,he,mn=`在这个类中，我们首先查询使用 Faiss 实现的缓存，其中包含以前的请求，如果返回的结果超过了一个指定的阈值，它将返回缓存的内容。否则，它将从 Chroma 数据库获取结果。
缓存存储在一个 .json 文件中。`,fl,we,dl,Ue,bl,Je,rn="下面的 <code>init_cache()</code> 函数初始化了语义缓存。",Il,ue,on="它使用了 FlatLS 索引，这可能不是最快的，但对于小数据集来说是理想的。如果我们需要根据数据的具体内容和大小来选择缓存（临时存储）数据的方式，我们还可以考虑使用其他的索引方法，比如 HNSW 或 IVF。",xl,Ce,cn="我选择这个索引是因为它与示例非常契合。它可以用于高维向量，消耗的内存最少，并且在小数据集上表现良好。",gl,Te,yn="下面概述了 Faiss 可用的各种索引的关键特性。",$l,je,hn="<li>FlatL2 或 FlatIP。非常适合小数据集，可能不是最快的，但其内存消耗并不过分。</li> <li>LSH。它在小数据集上工作效果很好，并且推荐用于最多 128 维的向量。</li> <li>HNSW。非常快，但需要大量的 RAM。</li> <li>IVF。在大数据集上工作良好，而且不会消耗太多内存或影响性能。</li>",vl,fe,wn='关于 Faiss 可用的不同索引的更多信息可以在以下链接中找到：<a href="https://github.com/facebookresearch/faiss/wiki/Guidelines-to-choose-an-index" rel="nofollow">https://github.com/facebookresearch/faiss/wiki/Guidelines-to-choose-an-index</a>',Gl,de,Zl,be,Un="在 <code>retrieve_cache</code> 函数中，.json 文件从磁盘中被检索出来，以便在需要跨会话重用缓存时使用。",Bl,Ie,kl,xe,Jn="<code>store_cache</code> 函数将包含缓存数据的文件保存到磁盘上。",Wl,ge,_l,$e,un="这些函数将在 <code>SemanticCache</code> 类中使用，该类包括搜索函数及其初始化函数。",Nl,ve,Cn="尽管 <code>ask</code> 函数的代码量相当大，但它的目的非常直接。它在缓存中查找与用户刚刚提出的问题最接近的问题。",Al,Ge,Tn="然后，检查它是否在指定的阈值内。如果是肯定的，它直接从缓存中返回响应；否则，它调用 <code>query_database</code> 函数从 ChromaDB 检索数据。",Rl,Ze,jn="我使用了欧几里得距离而不是广泛应用于向量比较的余弦距离。这个选择是基于欧几里得距离是 Faiss 默认使用的度量标准。尽管也可以计算余弦距离，但这样做会增加复杂性，可能不会显著有助于最终结果。",Sl,Be,Vl,ke,zl,We,El,_e,fn=`Index trained
`,Yl,Ne,Ql,Ae,dn=`Answer recovered from ChromaDB. 
response_text: Summary : Shots may hurt a little, but the diseases they can prevent are a lot worse. Some are even life-threatening. Immunization shots, or vaccinations, are essential. They protect against things like measles, mumps, rubella, hepatitis B, polio, tetanus, diphtheria, and pertussis (whooping cough). Immunizations are important for adults as well as children.    Your immune system helps your body fight germs by producing substances to combat them. Once it does, the immune system "remembers" the germ and can fight it again. Vaccines contain germs that have been killed or weakened. When given to a healthy person, the vaccine triggers the immune system to respond and thus build immunity.     Before vaccines, people became immune only by actually getting a disease and surviving it. Immunizations are an easier and less risky way to become immune.     NIH: National Institute of Allergy and Infectious Diseases
Time taken: 0.057 seconds
`,Hl,Re,bn="正如预期的那样，这个响应是从 ChromaDB 获取的。然后，该类将其存储在缓存中。",Xl,Se,In="现在，如果我们发送一个完全不同的问题，响应也应该从 ChromaDB 中检索。这是因为先前存储的问题与当前问题如此不同，以至于它在欧几里得距离方面会超过指定的阈值。",Fl,Ve,Ll,ze,xn=`Answer recovered from ChromaDB. 
response_text: Sydenham chorea (SD) is a neurological disorder of childhood resulting from infection via Group A beta-hemolytic streptococcus (GABHS), the bacterium that causes rheumatic fever. SD is characterized by rapid, irregular, and aimless involuntary movements of the arms and legs, trunk, and facial muscles. It affects girls more often than boys and typically occurs between 5 and 15 years of age. Some children will have a sore throat several weeks before the symptoms begin, but the disorder can also strike up to 6 months after the fever or infection has cleared. Symptoms can appear gradually or all at once, and also may include uncoordinated movements, muscular weakness, stumbling and falling, slurred speech, difficulty concentrating and writing, and emotional instability. The symptoms of SD can vary from a halting gait and slight grimacing to involuntary movements that are frequent and severe enough to be incapacitating. The random, writhing movements of chorea are caused by an auto-immune reaction to the bacterium that interferes with the normal function of a part of the brain (the basal ganglia) that controls motor movements. Due to better sanitary conditions and the use of antibiotics to treat streptococcal infections, rheumatic fever, and consequently SD, are rare in North America and Europe. The disease can still be found in developing nations.
Time taken: 0.082 seconds
`,ql,Ee,gn="完美，语义缓存系统正如预期那样运行。",Pl,Ye,$n="让我们继续用一个非常类似于我们刚才问的问题来测试它。",Dl,Qe,vn="在这种情况下，响应应该直接来自缓存，而不需要访问 ChromaDB 数据库。",Kl,He,Ol,Xe,Gn=`Answer recovered from Cache. 
0.028 smaller than 0.35
Found cache in row: 1 with score 0.028
response_text: Sydenham chorea (SD) is a neurological disorder of childhood resulting from infection via Group A beta-hemolytic streptococcus (GABHS), the bacterium that causes rheumatic fever. SD is characterized by rapid, irregular, and aimless involuntary movements of the arms and legs, trunk, and facial muscles. It affects girls more often than boys and typically occurs between 5 and 15 years of age. Some children will have a sore throat several weeks before the symptoms begin, but the disorder can also strike up to 6 months after the fever or infection has cleared. Symptoms can appear gradually or all at once, and also may include uncoordinated movements, muscular weakness, stumbling and falling, slurred speech, difficulty concentrating and writing, and emotional instability. The symptoms of SD can vary from a halting gait and slight grimacing to involuntary movements that are frequent and severe enough to be incapacitating. The random, writhing movements of chorea are caused by an auto-immune reaction to the bacterium that interferes with the normal function of a part of the brain (the basal ganglia) that controls motor movements. Due to better sanitary conditions and the use of antibiotics to treat streptococcal infections, rheumatic fever, and consequently SD, are rare in North America and Europe. The disease can still be found in developing nations.
Time taken: 0.019 seconds
`,es,Fe,Zn="这两个问题非常相似，它们的欧几里得距离非常小，几乎就像它们是相同的。",ts,Le,Bn="现在，让我们尝试另一个问题，这次稍微有些不同，观察系统的表现。",ls,qe,ss,Pe,kn=`Answer recovered from Cache. 
0.228 smaller than 0.35
Found cache in row: 1 with score 0.228
response_text: Sydenham chorea (SD) is a neurological disorder of childhood resulting from infection via Group A beta-hemolytic streptococcus (GABHS), the bacterium that causes rheumatic fever. SD is characterized by rapid, irregular, and aimless involuntary movements of the arms and legs, trunk, and facial muscles. It affects girls more often than boys and typically occurs between 5 and 15 years of age. Some children will have a sore throat several weeks before the symptoms begin, but the disorder can also strike up to 6 months after the fever or infection has cleared. Symptoms can appear gradually or all at once, and also may include uncoordinated movements, muscular weakness, stumbling and falling, slurred speech, difficulty concentrating and writing, and emotional instability. The symptoms of SD can vary from a halting gait and slight grimacing to involuntary movements that are frequent and severe enough to be incapacitating. The random, writhing movements of chorea are caused by an auto-immune reaction to the bacterium that interferes with the normal function of a part of the brain (the basal ganglia) that controls motor movements. Due to better sanitary conditions and the use of antibiotics to treat streptococcal infections, rheumatic fever, and consequently SD, are rare in North America and Europe. The disease can still be found in developing nations.
Time taken: 0.016 seconds
`,ns,De,Wn="我们观察到欧几里得距离已经增加，但它仍然在指定的阈值范围内。因此，它继续直接从缓存中返回响应。",as,Ke,is,Oe,_n='是时候使用 <strong>transformers</strong> 库了，这是<a href="https://huggingface.co/" rel="nofollow">hugging face </a>最著名的库，用于处理语言模型。',ps,et,Nn="我们将导入：",Ms,tt,An=`<li><strong>Autotokenizer</strong>：这是一个实用程序类，用于标记化与各种预训练语言模型兼容的文本输入。</li> <li><strong>AutoModelForCausalLM</strong>：它提供了一个接口，用于预训练的语言模型，特别适用于使用因果语言建模（例如，GPT 模型）的语言生成任务，或者是这个 Notebook 中使用的模型 <a href="https://huggingface.co/google/gemma-2b-it" rel="nofollow">Gemma-2b-it</a>。
请随意测试 <a href="https://huggingface.co/models?pipeline_tag=text-generation&amp;sort=trending" rel="nofollow">不同的模型</a>，你需要搜索训练用于文本生成的 NLP 模型。</li>`,ms,lt,rs,st,os,nt,cs,at,ys,it,Rn="为了创建提示，我们使用从查询 ‘semantic_cache’ 类得到的结果以及用户提出的问题。",hs,pt,Sn="提示有两部分，<strong>相关上下文</strong>是从数据库中恢复的信息，以及<strong>用户的问题</strong>。",ws,Mt,Vn="我们只需要将这两部分放在一起来创建提示，然后将其发送给模型。",Us,mt,Js,rt,us,ot,zn="现在剩下的就是将提示发送给模型，等待它的响应！",Cs,ct,Ts,yt,En=`<bos>Relevant context: Sydenham chorea (SD) is a neurological disorder of childhood resulting from infection via Group A beta-hemolytic streptococcus (GABHS), the bacterium that causes rheumatic fever. SD is characterized by rapid, irregular, and aimless involuntary movements of the arms and legs, trunk, and facial muscles. It affects girls more often than boys and typically occurs between 5 and 15 years of age. Some children will have a sore throat several weeks before the symptoms begin, but the disorder can also strike up to 6 months after the fever or infection has cleared. Symptoms can appear gradually or all at once, and also may include uncoordinated movements, muscular weakness, stumbling and falling, slurred speech, difficulty concentrating and writing, and emotional instability. The symptoms of SD can vary from a halting gait and slight grimacing to involuntary movements that are frequent and severe enough to be incapacitating. The random, writhing movements of chorea are caused by an auto-immune reaction to the bacterium that interferes with the normal function of a part of the brain (the basal ganglia) that controls motor movements. Due to better sanitary conditions and the use of antibiotics to treat streptococcal infections, rheumatic fever, and consequently SD, are rare in North America and Europe. The disease can still be found in developing nations.

 The user&#39;s question: Write in 20 words what is a Sydenham chorea.

Sure, here is a 20-word answer:

Sydenham chorea is a neurological disorder of childhood resulting from infection via Group A beta-hemolytic streptococcus (GABHS).<eos>
</eos></bos>`,js,ht,fs,wt,Yn="在访问 ChromaDB 和直接访问缓存之间，数据检索时间减少了 50%。然而，在更大的项目中，这种差异会增加，导致性能提升达到 90-95%。",ds,Ut,Qn="我们在 Chroma 中的数据非常少，只有一个缓存类的实例。通常，缓存系统背后的数据要大得多，可能不仅仅是对向量数据库的查询，而是来自各种来源。",bs,Jt,Hn="通常会有多个缓存类的实例，通常基于用户类型，因为共享共同特征的用户之间的问题往往更容易重复。",Is,ut,Xn="总之，我们创建了一个非常简单的 RAG 系统，并通过在用户的问题和获取创建丰富提示所需信息之间增加一个语义缓存层来增强它。",xs,Ct,gs,ft,$s;return u=new sa({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/semantic_cache_chroma_vector_database.ipynb"}]}}),C=new la({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new U({props:{title:"通过引入语义缓存到 FAISS 中以增强 RAG 系统的性能",local:"通过引入语义缓存到-faiss-中以增强-rag-系统的性能",headingTag:"h1"}}),N=new U({props:{title:"导入并加载库。",local:"导入并加载库",headingTag:"h1"}}),S=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHRyYW5zZm9ybWVycyUzRCUzRDQuMzguMSUwQSFwaXAlMjBpbnN0YWxsJTIwLXElMjBhY2NlbGVyYXRlJTNEJTNEMC4yNy4yJTBBIXBpcCUyMGluc3RhbGwlMjAtcSUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUzRCUzRDIuNS4xJTBBIXBpcCUyMGluc3RhbGwlMjAtcSUyMHhmb3JtZXJzJTNEJTNEMC4wLjI0JTBBIXBpcCUyMGluc3RhbGwlMjAtcSUyMGNocm9tYWRiJTNEJTNEMC40LjI0JTBBIXBpcCUyMGluc3RhbGwlMjAtcSUyMGRhdGFzZXRzJTNEJTNEMi4xNy4x",highlighted:`!pip install -q transformers==<span class="hljs-number">4.38</span><span class="hljs-number">.1</span>
!pip install -q accelerate==<span class="hljs-number">0.27</span><span class="hljs-number">.2</span>
!pip install -q sentence-transformers==<span class="hljs-number">2.5</span><span class="hljs-number">.1</span>
!pip install -q xformers==<span class="hljs-number">0.0</span><span class="hljs-number">.24</span>
!pip install -q chromadb==<span class="hljs-number">0.4</span><span class="hljs-number">.24</span>
!pip install -q datasets==<span class="hljs-number">2.17</span><span class="hljs-number">.1</span>`,wrap:!1}}),V=new w({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZA==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd`,wrap:!1}}),z=new U({props:{title:"加载数据集",local:"加载数据集",headingTag:"h1"}}),Y=new w({props:{code:"JTIzTG9naW4lMjB0byUyMEh1Z2dpbmclMjBGYWNlLiUyMEl0JTIwaXMlMjBtYW5kYXRvcnklMjB0byUyMHVzZSUyMHRoZSUyMEdlbW1hJTIwTW9kZWwlMkMlMEElMjNhbmQlMjByZWNvbW1lbmRlZCUyMHRvJTIwYWNjZXMlMjBwdWJsaWMlMjBtb2RlbHMlMjBhbmQlMjBEYXRhc2V0cy4lMEFmcm9tJTIwZ2V0cGFzcyUyMGltcG9ydCUyMGdldHBhc3MlMEFpZiUyMCdoZl9rZXknJTIwbm90JTIwaW4lMjBsb2NhbHMoKSUzQSUwQSUyMCUyMGhmX2tleSUyMCUzRCUyMGdldHBhc3MoJTIyWW91ciUyMEh1Z2dpbmclMjBGYWNlJTIwQVBJJTIwS2V5JTNBJTIwJTIyKSUwQSFodWdnaW5nZmFjZS1jbGklMjBsb2dpbiUyMC0tdG9rZW4lMjAlMjRoZl9rZXk=",highlighted:`<span class="hljs-comment">#Login to Hugging Face. It is mandatory to use the Gemma Model,</span>
<span class="hljs-comment">#and recommended to acces public models and Datasets.</span>
<span class="hljs-keyword">from</span> getpass <span class="hljs-keyword">import</span> getpass
<span class="hljs-keyword">if</span> <span class="hljs-string">&#x27;hf_key&#x27;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> <span class="hljs-built_in">locals</span>():
  hf_key = getpass(<span class="hljs-string">&quot;Your Hugging Face API Key: &quot;</span>)
!huggingface-cli login --token $hf_key`,wrap:!1}}),Q=new w({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YSUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJrZWl2YWx5YSUyRk1lZFF1YWQtTWVkaWNhbFFuQURhdGFzZXQlMjIlMkMlMjBzcGxpdCUzRCd0cmFpbicp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

data = load_dataset(<span class="hljs-string">&quot;keivalya/MedQuad-MedicalQnADataset&quot;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>)`,wrap:!1}}),X=new w({props:{code:"ZGF0YSUyMCUzRCUyMGRhdGEudG9fcGFuZGFzKCklMEFkYXRhJTVCJTIyaWQlMjIlNUQlM0RkYXRhLmluZGV4JTBBZGF0YS5oZWFkKDEwKQ==",highlighted:`data = data.to_pandas()
data[<span class="hljs-string">&quot;id&quot;</span>]=data.index
data.head(<span class="hljs-number">10</span>)`,wrap:!1}}),F=new w({props:{code:"TUFYX1JPV1MlMjAlM0QlMjAxNTAwMCUwQURPQ1VNRU5UJTNEJTIyQW5zd2VyJTIyJTBBVE9QSUMlM0QlMjJxdHlwZSUyMg==",highlighted:`MAX_ROWS = <span class="hljs-number">15000</span>
DOCUMENT=<span class="hljs-string">&quot;Answer&quot;</span>
TOPIC=<span class="hljs-string">&quot;qtype&quot;</span>`,wrap:!1}}),L=new w({props:{code:"JTIzQmVjYXVzZSUyMGl0JTIwaXMlMjBqdXN0JTIwYSUyMHNhbXBsZSUyMHdlJTIwc2VsZWN0JTIwYSUyMHNtYWxsJTIwcG9ydGlvbiUyMG9mJTIwTmV3cy4lMEFzdWJzZXRfZGF0YSUyMCUzRCUyMGRhdGEuaGVhZChNQVhfUk9XUyk=",highlighted:`<span class="hljs-comment">#Because it is just a sample we select a small portion of News.</span>
subset_data = data.head(MAX_ROWS)`,wrap:!1}}),q=new U({props:{title:"导入并配置向量数据库",local:"导入并配置向量数据库",headingTag:"h1"}}),K=new w({props:{code:"aW1wb3J0JTIwY2hyb21hZGI=",highlighted:'<span class="hljs-keyword">import</span> chromadb',wrap:!1}}),ee=new w({props:{code:"Y2hyb21hX2NsaWVudCUyMCUzRCUyMGNocm9tYWRiLlBlcnNpc3RlbnRDbGllbnQocGF0aCUzRCUyMiUyRnBhdGglMkZ0byUyRnBlcnNpc3QlMkZkaXJlY3RvcnklMjIp",highlighted:'chroma_client = chromadb.PersistentClient(path=<span class="hljs-string">&quot;/path/to/persist/directory&quot;</span>)',wrap:!1}}),te=new U({props:{title:"填充和查询 ChromaDB 数据库",local:"填充和查询-chromadb-数据库",headingTag:"h1"}}),se=new w({props:{code:"Y29sbGVjdGlvbl9uYW1lJTIwJTNEJTIwJTIybmV3c19jb2xsZWN0aW9uJTIyJTBBaWYlMjBsZW4oY2hyb21hX2NsaWVudC5saXN0X2NvbGxlY3Rpb25zKCkpJTIwJTNFJTIwMCUyMGFuZCUyMGNvbGxlY3Rpb25fbmFtZSUyMGluJTIwJTVCY2hyb21hX2NsaWVudC5saXN0X2NvbGxlY3Rpb25zKCklNUIwJTVELm5hbWUlNUQlM0ElMEElMjAlMjAlMjAlMjBjaHJvbWFfY2xpZW50LmRlbGV0ZV9jb2xsZWN0aW9uKG5hbWUlM0Rjb2xsZWN0aW9uX25hbWUpJTBBJTBBY29sbGVjdGlvbiUyMCUzRCUyMGNocm9tYV9jbGllbnQuY3JlYXRlX2NvbGxlY3Rpb24obmFtZSUzRGNvbGxlY3Rpb25fbmFtZSk=",highlighted:`collection_name = <span class="hljs-string">&quot;news_collection&quot;</span>
<span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(chroma_client.list_collections()) &gt; <span class="hljs-number">0</span> <span class="hljs-keyword">and</span> collection_name <span class="hljs-keyword">in</span> [chroma_client.list_collections()[<span class="hljs-number">0</span>].name]:
    chroma_client.delete_collection(name=collection_name)

collection = chroma_client.create_collection(name=collection_name)`,wrap:!1}}),ie=new w({props:{code:"Y29sbGVjdGlvbi5hZGQoJTBBJTIwJTIwJTIwJTIwZG9jdW1lbnRzJTNEc3Vic2V0X2RhdGElNUJET0NVTUVOVCU1RC50b2xpc3QoKSUyQyUwQSUyMCUyMCUyMCUyMG1ldGFkYXRhcyUzRCU1QiU3QlRPUElDJTNBJTIwdG9waWMlN0QlMjBmb3IlMjB0b3BpYyUyMGluJTIwc3Vic2V0X2RhdGElNUJUT1BJQyU1RC50b2xpc3QoKSU1RCUyQyUwQSUyMCUyMCUyMCUyMGlkcyUzRCU1QmYlMjJpZCU3QnglN0QlMjIlMjBmb3IlMjB4JTIwaW4lMjByYW5nZShNQVhfUk9XUyklNUQlMkMlMEEp",highlighted:`collection.add(
    documents=subset_data[DOCUMENT].tolist(),
    metadatas=[{TOPIC: topic} <span class="hljs-keyword">for</span> topic <span class="hljs-keyword">in</span> subset_data[TOPIC].tolist()],
    ids=[<span class="hljs-string">f&quot;id<span class="hljs-subst">{x}</span>&quot;</span> <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(MAX_ROWS)],
)`,wrap:!1}}),re=new w({props:{code:"ZGVmJTIwcXVlcnlfZGF0YWJhc2UocXVlcnlfdGV4dCUyQyUyMG5fcmVzdWx0cyUzRDEwKSUzQSUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjBjb2xsZWN0aW9uLnF1ZXJ5KHF1ZXJ5X3RleHRzJTNEcXVlcnlfdGV4dCUyQyUyMG5fcmVzdWx0cyUzRG5fcmVzdWx0cyUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXN1bHRz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">query_database</span>(<span class="hljs-params">query_text, n_results=<span class="hljs-number">10</span></span>):
    results = collection.query(query_texts=query_text, n_results=n_results )
    <span class="hljs-keyword">return</span> results`,wrap:!1}}),oe=new U({props:{title:"创建语义缓存系统",local:"创建语义缓存系统",headingTag:"h2"}}),we=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGZhaXNzLWNwdSUzRCUzRDEuOC4w",highlighted:'!pip install -q faiss-cpu==<span class="hljs-number">1.8</span><span class="hljs-number">.0</span>',wrap:!1}}),Ue=new w({props:{code:"aW1wb3J0JTIwZmFpc3MlMEFmcm9tJTIwc2VudGVuY2VfdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwU2VudGVuY2VUcmFuc2Zvcm1lciUwQWltcG9ydCUyMHRpbWUlMEFpbXBvcnQlMjBqc29u",highlighted:`<span class="hljs-keyword">import</span> faiss
<span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> SentenceTransformer
<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> json`,wrap:!1}}),de=new w({props:{code:"ZGVmJTIwaW5pdF9jYWNoZSgpJTNBJTBBJTIwJTIwaW5kZXglMjAlM0QlMjBmYWlzcy5JbmRleEZsYXRMMig3NjgpJTBBJTIwJTIwaWYlMjBpbmRleC5pc190cmFpbmVkJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJ0luZGV4JTIwdHJhaW5lZCcpJTBBJTBBJTIwJTIwJTIzJTIwSW5pdGlhbGl6ZSUyMFNlbnRlbmNlJTIwVHJhbnNmb3JtZXIlMjBtb2RlbCUwQSUyMCUyMGVuY29kZXIlMjAlM0QlMjBTZW50ZW5jZVRyYW5zZm9ybWVyKCdhbGwtbXBuZXQtYmFzZS12MicpJTBBJTBBJTIwJTIwcmV0dXJuJTIwaW5kZXglMkMlMjBlbmNvZGVy",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">init_cache</span>():
  index = faiss.IndexFlatL2(<span class="hljs-number">768</span>)
  <span class="hljs-keyword">if</span> index.is_trained:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;Index trained&#x27;</span>)

  <span class="hljs-comment"># Initialize Sentence Transformer model</span>
  encoder = SentenceTransformer(<span class="hljs-string">&#x27;all-mpnet-base-v2&#x27;</span>)

  <span class="hljs-keyword">return</span> index, encoder`,wrap:!1}}),Ie=new w({props:{code:"ZGVmJTIwcmV0cmlldmVfY2FjaGUoanNvbl9maWxlKSUzQSUwQSUyMCUyMHRyeSUzQSUwQSUyMCUyMCUyMCUyMHdpdGglMjBvcGVuKGpzb25fZmlsZSUyQyUyMCdyJyklMjBhcyUyMGZpbGUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjBjYWNoZSUyMCUzRCUyMGpzb24ubG9hZChmaWxlKSUwQSUyMCUyMGV4Y2VwdCUyMEZpbGVOb3RGb3VuZEVycm9yJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwY2FjaGUlMjAlM0QlMjAlN0IncXVlc3Rpb25zJyUzQSUyMCU1QiU1RCUyQyUyMCdlbWJlZGRpbmdzJyUzQSUyMCU1QiU1RCUyQyUyMCdhbnN3ZXJzJyUzQSUyMCU1QiU1RCUyQyUyMCdyZXNwb25zZV90ZXh0JyUzQSUyMCU1QiU1RCU3RCUwQSUwQSUyMCUyMHJldHVybiUyMGNhY2hl",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">retrieve_cache</span>(<span class="hljs-params">json_file</span>):
  <span class="hljs-keyword">try</span>:
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(json_file, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> file:
      cache = json.load(file)
  <span class="hljs-keyword">except</span> FileNotFoundError:
      cache = {<span class="hljs-string">&#x27;questions&#x27;</span>: [], <span class="hljs-string">&#x27;embeddings&#x27;</span>: [], <span class="hljs-string">&#x27;answers&#x27;</span>: [], <span class="hljs-string">&#x27;response_text&#x27;</span>: []}

  <span class="hljs-keyword">return</span> cache`,wrap:!1}}),ge=new w({props:{code:"ZGVmJTIwc3RvcmVfY2FjaGUoanNvbl9maWxlJTJDJTIwY2FjaGUpJTNBJTBBJTIwJTIwd2l0aCUyMG9wZW4oanNvbl9maWxlJTJDJTIwJ3cnKSUyMGFzJTIwZmlsZSUzQSUwQSUyMCUyMCUyMCUyMGpzb24uZHVtcChjYWNoZSUyQyUyMGZpbGUp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">store_cache</span>(<span class="hljs-params">json_file, cache</span>):
  <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(json_file, <span class="hljs-string">&#x27;w&#x27;</span>) <span class="hljs-keyword">as</span> file:
    json.dump(cache, file)`,wrap:!1}}),Be=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">semantic_cache</span>:
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, json_file=<span class="hljs-string">&quot;cache_file.json&quot;</span>, thresold=<span class="hljs-number">0.35</span></span>):
      <span class="hljs-comment"># Initialize Faiss index with Euclidean distance</span>
      self.index, self.encoder = init_cache()

      <span class="hljs-comment"># Set Euclidean distance threshold</span>
      <span class="hljs-comment"># a distance of 0 means identicals sentences</span>
      <span class="hljs-comment"># We only return from cache sentences under this thresold</span>
      self.euclidean_threshold = thresold

      self.json_file = json_file
      self.cache = retrieve_cache(self.json_file)

  <span class="hljs-keyword">def</span> <span class="hljs-title function_">ask</span>(<span class="hljs-params">self, question: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
      <span class="hljs-comment"># Method to retrieve an answer from the cache or generate a new one</span>
      start_time = time.time()
      <span class="hljs-keyword">try</span>:
          <span class="hljs-comment">#First we obtain the embeddings corresponding to the user question</span>
          embedding = self.encoder.encode([question])

          <span class="hljs-comment"># Search for the nearest neighbor in the index</span>
          self.index.nprobe = <span class="hljs-number">8</span>
          D, I = self.index.search(embedding, <span class="hljs-number">1</span>)

          <span class="hljs-keyword">if</span> D[<span class="hljs-number">0</span>] &gt;= <span class="hljs-number">0</span>:
              <span class="hljs-keyword">if</span> I[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>] &gt;= <span class="hljs-number">0</span> <span class="hljs-keyword">and</span> D[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>] &lt;= self.euclidean_threshold:
                  row_id = <span class="hljs-built_in">int</span>(I[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>])

                  <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;Answer recovered from Cache. &#x27;</span>)
                  <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;<span class="hljs-subst">{D[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>]:<span class="hljs-number">.3</span>f}</span> smaller than <span class="hljs-subst">{self.euclidean_threshold}</span>&#x27;</span>)
                  <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Found cache in row: <span class="hljs-subst">{row_id}</span> with score <span class="hljs-subst">{D[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>]:<span class="hljs-number">.3</span>f}</span>&#x27;</span>)
                  <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;response_text: &#x27;</span> + self.cache[<span class="hljs-string">&#x27;response_text&#x27;</span>][row_id])

                  end_time = time.time()
                  elapsed_time = end_time - start_time
                  <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Time taken: <span class="hljs-subst">{elapsed_time:<span class="hljs-number">.3</span>f}</span> seconds&quot;</span>)
                  <span class="hljs-keyword">return</span> self.cache[<span class="hljs-string">&#x27;response_text&#x27;</span>][row_id]

          <span class="hljs-comment"># Handle the case when there are not enough results</span>
          <span class="hljs-comment"># or Euclidean distance is not met, asking to chromaDB.</span>
          answer  = query_database([question], <span class="hljs-number">1</span>)
          response_text = answer[<span class="hljs-string">&#x27;documents&#x27;</span>][<span class="hljs-number">0</span>][<span class="hljs-number">0</span>]

          self.cache[<span class="hljs-string">&#x27;questions&#x27;</span>].append(question)
          self.cache[<span class="hljs-string">&#x27;embeddings&#x27;</span>].append(embedding[<span class="hljs-number">0</span>].tolist())
          self.cache[<span class="hljs-string">&#x27;answers&#x27;</span>].append(answer)
          self.cache[<span class="hljs-string">&#x27;response_text&#x27;</span>].append(response_text)

          <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;Answer recovered from ChromaDB. &#x27;</span>)
          <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;response_text: <span class="hljs-subst">{response_text}</span>&#x27;</span>)

          self.index.add(embedding)
          store_cache(self.json_file, self.cache)
          end_time = time.time()
          elapsed_time = end_time - start_time
          <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Time taken: <span class="hljs-subst">{elapsed_time:<span class="hljs-number">.3</span>f}</span> seconds&quot;</span>)

          <span class="hljs-keyword">return</span> response_text
      <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
          <span class="hljs-keyword">raise</span> RuntimeError(<span class="hljs-string">f&quot;Error during &#x27;ask&#x27; method: <span class="hljs-subst">{e}</span>&quot;</span>)`,wrap:!1}}),ke=new U({props:{title:"测试 semantic_cache 类。",local:"测试-semanticcache-类",headingTag:"h3"}}),We=new w({props:{code:"JTIzJTIwSW5pdGlhbGl6ZSUyMHRoZSUyMGNhY2hlLiUwQWNhY2hlJTIwJTNEJTIwc2VtYW50aWNfY2FjaGUoJzRjYWNoZS5qc29uJyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize the cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cache = semantic_cache(<span class="hljs-string">&#x27;4cache.json&#x27;</span>)`,wrap:!1}}),Ne=new w({props:{code:"cmVzdWx0cyUyMCUzRCUyMGNhY2hlLmFzayglMjJIb3clMjBkbyUyMHZhY2NpbmVzJTIwd29yayUzRiUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>results = cache.ask(<span class="hljs-string">&quot;How do vaccines work?&quot;</span>)',wrap:!1}}),Ve=new w({props:{code:"cmVzdWx0cyUyMCUzRCUyMGNhY2hlLmFzayglMjJFeHBsYWluJTIwYnJpZWZseSUyMHdoYXQlMjBpcyUyMGElMjBTeWRlbmhhbSUyMGNob3JlYSUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>results = cache.ask(<span class="hljs-string">&quot;Explain briefly what is a Sydenham chorea&quot;</span>)',wrap:!1}}),He=new w({props:{code:"cmVzdWx0cyUyMCUzRCUyMGNhY2hlLmFzayglMjJCcmllZmx5JTIwZXhwbGFpbiUyMG1lJTIwd2hhdCUyMGlzJTIwYSUyMFN5ZGVuaGFtJTIwY2hvcmVhLiUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>results = cache.ask(<span class="hljs-string">&quot;Briefly explain me what is a Sydenham chorea.&quot;</span>)',wrap:!1}}),qe=new w({props:{code:"cXVlc3Rpb25fZGVmJTIwJTNEJTIwJTIyV3JpdGUlMjBpbiUyMDIwJTIwd29yZHMlMjB3aGF0JTIwaXMlMjBhJTIwU3lkZW5oYW0lMjBjaG9yZWEuJTIyJTBBcmVzdWx0cyUyMCUzRCUyMGNhY2hlLmFzayhxdWVzdGlvbl9kZWYp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>question_def = <span class="hljs-string">&quot;Write in 20 words what is a Sydenham chorea.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>results = cache.ask(question_def)`,wrap:!1}}),Ke=new U({props:{title:"加载模型并创建提示",local:"加载模型并创建提示",headingTag:"h1"}}),lt=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjB0b3JjaA==",highlighted:"!pip install torch",wrap:!1}}),st=new w({props:{code:"ZnJvbSUyMHRvcmNoJTIwaW1wb3J0JTIwY3VkYSUyQyUyMHRvcmNoJTBBJTIzSW4lMjBhJTIwTUFDJTIwU2lsaWNvbiUyMHRoZSUyMGRldmljZSUyMG11c3QlMjBiZSUyMCdtcHMnJTBBJTIzJTIwZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCdtcHMnKSUyMCUyM3RvJTIwdXNlJTIwd2l0aCUyME1BQyUyMFNpbGljb24lMEFkZXZpY2UlMjAlM0QlMjBmJ2N1ZGElM0ElN0JjdWRhLmN1cnJlbnRfZGV2aWNlKCklN0QnJTIwaWYlMjBjdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCdjcHUn",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> cuda, torch
<span class="hljs-comment">#In a MAC Silicon the device must be &#x27;mps&#x27;</span>
<span class="hljs-comment"># device = torch.device(&#x27;mps&#x27;) #to use with MAC Silicon</span>
device = <span class="hljs-string">f&#x27;cuda:<span class="hljs-subst">{cuda.current_device()}</span>&#x27;</span> <span class="hljs-keyword">if</span> cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;cpu&#x27;</span>`,wrap:!1}}),nt=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyZ29vZ2xlJTJGZ2VtbWEtMmItaXQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJjdWRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

model_id = <span class="hljs-string">&quot;google/gemma-2b-it&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
model = AutoModelForCausalLM.from_pretrained(model_id,
                                             device_map=<span class="hljs-string">&quot;cuda&quot;</span>,
                                            torch_dtype=torch.bfloat16)`,wrap:!1}}),at=new U({props:{title:"创建扩展提示",local:"创建扩展提示",headingTag:"h2"}}),mt=new w({props:{code:"cHJvbXB0X3RlbXBsYXRlJTIwJTNEJTIwZiUyMlJlbGV2YW50JTIwY29udGV4dCUzQSUyMCU3QnJlc3VsdHMlN0QlNUNuJTVDbiUyMFRoZSUyMHVzZXIncyUyMHF1ZXN0aW9uJTNBJTIwJTdCcXVlc3Rpb25fZGVmJTdEJTIyJTBBcHJvbXB0X3RlbXBsYXRl",highlighted:`prompt_template = <span class="hljs-string">f&quot;Relevant context: <span class="hljs-subst">{results}</span>\\n\\n The user&#x27;s question: <span class="hljs-subst">{question_def}</span>&quot;</span>
prompt_template`,wrap:!1}}),rt=new w({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdF90ZW1wbGF0ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIp",highlighted:'input_ids = tokenizer(prompt_template, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)',wrap:!1}}),ct=new w({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRfaWRzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXRzJTVCMCU1RCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**input_ids,
<span class="hljs-meta">... </span>                         max_new_tokens=<span class="hljs-number">256</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>]))`,wrap:!1}}),ht=new U({props:{title:"结论",local:"结论",headingTag:"h1"}}),Ct=new na({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/semantic_cache_chroma_vector_database.md"}}),{c(){J=i("meta"),dt=n(),jt=i("p"),bt=n(),m(u.$$.fragment),It=n(),m(C.$$.fragment),xt=n(),m(T.$$.fragment),gt=n(),j=i("p"),j.innerHTML=Zs,$t=n(),f=i("p"),f.innerHTML=Bs,vt=n(),d=i("p"),d.textContent=ks,Gt=n(),b=i("p"),b.textContent=Ws,Zt=n(),I=i("p"),I.innerHTML=_s,Bt=n(),x=i("p"),x.textContent=Ns,kt=n(),Tt=i("img"),Wt=n(),g=i("p"),g.textContent=Rs,_t=n(),$=i("p"),$.textContent=Ss,Nt=n(),v=i("p"),v.textContent=Vs,At=n(),G=i("p"),G.textContent=zs,Rt=n(),Z=i("ul"),Z.innerHTML=Es,St=n(),B=i("p"),B.textContent=Ys,Vt=n(),k=i("p"),k.textContent=Qs,zt=n(),W=i("p"),W.textContent=Hs,Et=n(),_=i("p"),_.textContent=Xs,Yt=n(),m(N.$$.fragment),Qt=n(),A=i("p"),A.textContent=Fs,Ht=n(),R=i("ul"),R.innerHTML=Ls,Xt=n(),m(S.$$.fragment),Ft=n(),m(V.$$.fragment),Lt=n(),m(z.$$.fragment),qt=n(),E=i("p"),E.innerHTML=qs,Pt=n(),m(Y.$$.fragment),Dt=n(),m(Q.$$.fragment),Kt=n(),H=i("p"),H.innerHTML=Ps,Ot=n(),m(X.$$.fragment),el=n(),m(F.$$.fragment),tl=n(),m(L.$$.fragment),ll=n(),m(q.$$.fragment),sl=n(),P=i("p"),P.textContent=Ds,nl=n(),D=i("p"),D.textContent=Ks,al=n(),m(K.$$.fragment),il=n(),O=i("p"),O.textContent=Os,pl=n(),m(ee.$$.fragment),Ml=n(),m(te.$$.fragment),ml=n(),le=i("p"),le.innerHTML=en,rl=n(),m(se.$$.fragment),ol=n(),ne=i("p"),ne.innerHTML=tn,cl=n(),ae=i("ul"),ae.innerHTML=ln,yl=n(),m(ie.$$.fragment),hl=n(),pe=i("p"),pe.textContent=sn,wl=n(),Me=i("p"),Me.textContent=nn,Ul=n(),me=i("p"),me.textContent=an,Jl=n(),m(re.$$.fragment),ul=n(),m(oe.$$.fragment),Cl=n(),ce=i("p"),ce.textContent=pn,Tl=n(),ye=i("p"),ye.innerHTML=Mn,jl=n(),he=i("p"),he.textContent=mn,fl=n(),m(we.$$.fragment),dl=n(),m(Ue.$$.fragment),bl=n(),Je=i("p"),Je.innerHTML=rn,Il=n(),ue=i("p"),ue.textContent=on,xl=n(),Ce=i("p"),Ce.textContent=cn,gl=n(),Te=i("p"),Te.textContent=yn,$l=n(),je=i("ul"),je.innerHTML=hn,vl=n(),fe=i("p"),fe.innerHTML=wn,Gl=n(),m(de.$$.fragment),Zl=n(),be=i("p"),be.innerHTML=Un,Bl=n(),m(Ie.$$.fragment),kl=n(),xe=i("p"),xe.innerHTML=Jn,Wl=n(),m(ge.$$.fragment),_l=n(),$e=i("p"),$e.innerHTML=un,Nl=n(),ve=i("p"),ve.innerHTML=Cn,Al=n(),Ge=i("p"),Ge.innerHTML=Tn,Rl=n(),Ze=i("p"),Ze.textContent=jn,Sl=n(),m(Be.$$.fragment),Vl=n(),m(ke.$$.fragment),zl=n(),m(We.$$.fragment),El=n(),_e=i("pre"),_e.textContent=fn,Yl=n(),m(Ne.$$.fragment),Ql=n(),Ae=i("pre"),Ae.textContent=dn,Hl=n(),Re=i("p"),Re.textContent=bn,Xl=n(),Se=i("p"),Se.textContent=In,Fl=n(),m(Ve.$$.fragment),Ll=n(),ze=i("pre"),ze.textContent=xn,ql=n(),Ee=i("p"),Ee.textContent=gn,Pl=n(),Ye=i("p"),Ye.textContent=$n,Dl=n(),Qe=i("p"),Qe.textContent=vn,Kl=n(),m(He.$$.fragment),Ol=n(),Xe=i("pre"),Xe.textContent=Gn,es=n(),Fe=i("p"),Fe.textContent=Zn,ts=n(),Le=i("p"),Le.textContent=Bn,ls=n(),m(qe.$$.fragment),ss=n(),Pe=i("pre"),Pe.textContent=kn,ns=n(),De=i("p"),De.textContent=Wn,as=n(),m(Ke.$$.fragment),is=n(),Oe=i("p"),Oe.innerHTML=_n,ps=n(),et=i("p"),et.textContent=Nn,Ms=n(),tt=i("ul"),tt.innerHTML=An,ms=n(),m(lt.$$.fragment),rs=n(),m(st.$$.fragment),os=n(),m(nt.$$.fragment),cs=n(),m(at.$$.fragment),ys=n(),it=i("p"),it.textContent=Rn,hs=n(),pt=i("p"),pt.innerHTML=Sn,ws=n(),Mt=i("p"),Mt.textContent=Vn,Us=n(),m(mt.$$.fragment),Js=n(),m(rt.$$.fragment),us=n(),ot=i("p"),ot.textContent=zn,Cs=n(),m(ct.$$.fragment),Ts=n(),yt=i("pre"),yt.innerHTML=En,js=n(),m(ht.$$.fragment),fs=n(),wt=i("p"),wt.textContent=Yn,ds=n(),Ut=i("p"),Ut.textContent=Qn,bs=n(),Jt=i("p"),Jt.textContent=Hn,Is=n(),ut=i("p"),ut.textContent=Xn,xs=n(),m(Ct.$$.fragment),gs=n(),ft=i("p"),this.h()},l(e){const t=ea("svelte-u9bgzb",document.head);J=p(t,"META",{name:!0,content:!0}),t.forEach(l),dt=a(e),jt=p(e,"P",{}),Fn(jt).forEach(l),bt=a(e),r(u.$$.fragment,e),It=a(e),r(C.$$.fragment,e),xt=a(e),r(T.$$.fragment,e),gt=a(e),j=p(e,"P",{"data-svelte-h":!0}),M(j)!=="svelte-1n7exb5"&&(j.innerHTML=Zs),$t=a(e),f=p(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-15k4z8c"&&(f.innerHTML=Bs),vt=a(e),d=p(e,"P",{"data-svelte-h":!0}),M(d)!=="svelte-11ylz4o"&&(d.textContent=ks),Gt=a(e),b=p(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1vn5l8g"&&(b.textContent=Ws),Zt=a(e),I=p(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-8hnfwk"&&(I.innerHTML=_s),Bt=a(e),x=p(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-4u23b6"&&(x.textContent=Ns),kt=a(e),Tt=p(e,"IMG",{src:!0}),Wt=a(e),g=p(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-1wky8l7"&&(g.textContent=Rs),_t=a(e),$=p(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-ksvfjs"&&($.textContent=Ss),Nt=a(e),v=p(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-1bvpahe"&&(v.textContent=Vs),At=a(e),G=p(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-cnzi62"&&(G.textContent=zs),Rt=a(e),Z=p(e,"UL",{"data-svelte-h":!0}),M(Z)!=="svelte-1q79ppw"&&(Z.innerHTML=Es),St=a(e),B=p(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-qhu07g"&&(B.textContent=Ys),Vt=a(e),k=p(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1s0b30d"&&(k.textContent=Qs),zt=a(e),W=p(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1a7f729"&&(W.textContent=Hs),Et=a(e),_=p(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-63npyl"&&(_.textContent=Xs),Yt=a(e),r(N.$$.fragment,e),Qt=a(e),A=p(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-18s02xb"&&(A.textContent=Fs),Ht=a(e),R=p(e,"UL",{"data-svelte-h":!0}),M(R)!=="svelte-34uoq3"&&(R.innerHTML=Ls),Xt=a(e),r(S.$$.fragment,e),Ft=a(e),r(V.$$.fragment,e),Lt=a(e),r(z.$$.fragment,e),qt=a(e),E=p(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1c1opdv"&&(E.innerHTML=qs),Pt=a(e),r(Y.$$.fragment,e),Dt=a(e),r(Q.$$.fragment,e),Kt=a(e),H=p(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-b0o92q"&&(H.innerHTML=Ps),Ot=a(e),r(X.$$.fragment,e),el=a(e),r(F.$$.fragment,e),tl=a(e),r(L.$$.fragment,e),ll=a(e),r(q.$$.fragment,e),sl=a(e),P=p(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-6lfamd"&&(P.textContent=Ds),nl=a(e),D=p(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-2qjbun"&&(D.textContent=Ks),al=a(e),r(K.$$.fragment,e),il=a(e),O=p(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-pc5ggj"&&(O.textContent=Os),pl=a(e),r(ee.$$.fragment,e),Ml=a(e),r(te.$$.fragment,e),ml=a(e),le=p(e,"P",{"data-svelte-h":!0}),M(le)!=="svelte-1pqmzje"&&(le.innerHTML=en),rl=a(e),r(se.$$.fragment,e),ol=a(e),ne=p(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-n6pyi0"&&(ne.innerHTML=tn),cl=a(e),ae=p(e,"UL",{"data-svelte-h":!0}),M(ae)!=="svelte-f476s0"&&(ae.innerHTML=ln),yl=a(e),r(ie.$$.fragment,e),hl=a(e),pe=p(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-f5w6vv"&&(pe.textContent=sn),wl=a(e),Me=p(e,"P",{"data-svelte-h":!0}),M(Me)!=="svelte-6hegus"&&(Me.textContent=nn),Ul=a(e),me=p(e,"P",{"data-svelte-h":!0}),M(me)!=="svelte-1xxeku5"&&(me.textContent=an),Jl=a(e),r(re.$$.fragment,e),ul=a(e),r(oe.$$.fragment,e),Cl=a(e),ce=p(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-vyp9pe"&&(ce.textContent=pn),Tl=a(e),ye=p(e,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-133mpmn"&&(ye.innerHTML=Mn),jl=a(e),he=p(e,"P",{"data-svelte-h":!0}),M(he)!=="svelte-vjkekr"&&(he.textContent=mn),fl=a(e),r(we.$$.fragment,e),dl=a(e),r(Ue.$$.fragment,e),bl=a(e),Je=p(e,"P",{"data-svelte-h":!0}),M(Je)!=="svelte-88z3a4"&&(Je.innerHTML=rn),Il=a(e),ue=p(e,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-66g8xe"&&(ue.textContent=on),xl=a(e),Ce=p(e,"P",{"data-svelte-h":!0}),M(Ce)!=="svelte-2rbogm"&&(Ce.textContent=cn),gl=a(e),Te=p(e,"P",{"data-svelte-h":!0}),M(Te)!=="svelte-1gan433"&&(Te.textContent=yn),$l=a(e),je=p(e,"UL",{"data-svelte-h":!0}),M(je)!=="svelte-232whh"&&(je.innerHTML=hn),vl=a(e),fe=p(e,"P",{"data-svelte-h":!0}),M(fe)!=="svelte-xlte47"&&(fe.innerHTML=wn),Gl=a(e),r(de.$$.fragment,e),Zl=a(e),be=p(e,"P",{"data-svelte-h":!0}),M(be)!=="svelte-1qns4ys"&&(be.innerHTML=Un),Bl=a(e),r(Ie.$$.fragment,e),kl=a(e),xe=p(e,"P",{"data-svelte-h":!0}),M(xe)!=="svelte-ii3wze"&&(xe.innerHTML=Jn),Wl=a(e),r(ge.$$.fragment,e),_l=a(e),$e=p(e,"P",{"data-svelte-h":!0}),M($e)!=="svelte-6zu4rg"&&($e.innerHTML=un),Nl=a(e),ve=p(e,"P",{"data-svelte-h":!0}),M(ve)!=="svelte-yy8io3"&&(ve.innerHTML=Cn),Al=a(e),Ge=p(e,"P",{"data-svelte-h":!0}),M(Ge)!=="svelte-y34k66"&&(Ge.innerHTML=Tn),Rl=a(e),Ze=p(e,"P",{"data-svelte-h":!0}),M(Ze)!=="svelte-1k2r2gp"&&(Ze.textContent=jn),Sl=a(e),r(Be.$$.fragment,e),Vl=a(e),r(ke.$$.fragment,e),zl=a(e),r(We.$$.fragment,e),El=a(e),_e=p(e,"PRE",{"data-svelte-h":!0}),M(_e)!=="svelte-mqrnyt"&&(_e.textContent=fn),Yl=a(e),r(Ne.$$.fragment,e),Ql=a(e),Ae=p(e,"PRE",{"data-svelte-h":!0}),M(Ae)!=="svelte-ick26y"&&(Ae.textContent=dn),Hl=a(e),Re=p(e,"P",{"data-svelte-h":!0}),M(Re)!=="svelte-a70hjy"&&(Re.textContent=bn),Xl=a(e),Se=p(e,"P",{"data-svelte-h":!0}),M(Se)!=="svelte-1emk5jb"&&(Se.textContent=In),Fl=a(e),r(Ve.$$.fragment,e),Ll=a(e),ze=p(e,"PRE",{"data-svelte-h":!0}),M(ze)!=="svelte-we3tc3"&&(ze.textContent=xn),ql=a(e),Ee=p(e,"P",{"data-svelte-h":!0}),M(Ee)!=="svelte-1mgix7t"&&(Ee.textContent=gn),Pl=a(e),Ye=p(e,"P",{"data-svelte-h":!0}),M(Ye)!=="svelte-1nkae7r"&&(Ye.textContent=$n),Dl=a(e),Qe=p(e,"P",{"data-svelte-h":!0}),M(Qe)!=="svelte-nyaibc"&&(Qe.textContent=vn),Kl=a(e),r(He.$$.fragment,e),Ol=a(e),Xe=p(e,"PRE",{"data-svelte-h":!0}),M(Xe)!=="svelte-zuw07a"&&(Xe.textContent=Gn),es=a(e),Fe=p(e,"P",{"data-svelte-h":!0}),M(Fe)!=="svelte-thqcpr"&&(Fe.textContent=Zn),ts=a(e),Le=p(e,"P",{"data-svelte-h":!0}),M(Le)!=="svelte-bcpyax"&&(Le.textContent=Bn),ls=a(e),r(qe.$$.fragment,e),ss=a(e),Pe=p(e,"PRE",{"data-svelte-h":!0}),M(Pe)!=="svelte-158wm6z"&&(Pe.textContent=kn),ns=a(e),De=p(e,"P",{"data-svelte-h":!0}),M(De)!=="svelte-1jotmqd"&&(De.textContent=Wn),as=a(e),r(Ke.$$.fragment,e),is=a(e),Oe=p(e,"P",{"data-svelte-h":!0}),M(Oe)!=="svelte-q2oo54"&&(Oe.innerHTML=_n),ps=a(e),et=p(e,"P",{"data-svelte-h":!0}),M(et)!=="svelte-1px6e14"&&(et.textContent=Nn),Ms=a(e),tt=p(e,"UL",{"data-svelte-h":!0}),M(tt)!=="svelte-14usp90"&&(tt.innerHTML=An),ms=a(e),r(lt.$$.fragment,e),rs=a(e),r(st.$$.fragment,e),os=a(e),r(nt.$$.fragment,e),cs=a(e),r(at.$$.fragment,e),ys=a(e),it=p(e,"P",{"data-svelte-h":!0}),M(it)!=="svelte-slfzj7"&&(it.textContent=Rn),hs=a(e),pt=p(e,"P",{"data-svelte-h":!0}),M(pt)!=="svelte-s2tyom"&&(pt.innerHTML=Sn),ws=a(e),Mt=p(e,"P",{"data-svelte-h":!0}),M(Mt)!=="svelte-sbz1iz"&&(Mt.textContent=Vn),Us=a(e),r(mt.$$.fragment,e),Js=a(e),r(rt.$$.fragment,e),us=a(e),ot=p(e,"P",{"data-svelte-h":!0}),M(ot)!=="svelte-11xe0uy"&&(ot.textContent=zn),Cs=a(e),r(ct.$$.fragment,e),Ts=a(e),yt=p(e,"PRE",{"data-svelte-h":!0}),M(yt)!=="svelte-1uv406t"&&(yt.innerHTML=En),js=a(e),r(ht.$$.fragment,e),fs=a(e),wt=p(e,"P",{"data-svelte-h":!0}),M(wt)!=="svelte-1vnm5v0"&&(wt.textContent=Yn),ds=a(e),Ut=p(e,"P",{"data-svelte-h":!0}),M(Ut)!=="svelte-1hncnz4"&&(Ut.textContent=Qn),bs=a(e),Jt=p(e,"P",{"data-svelte-h":!0}),M(Jt)!=="svelte-13sbx3i"&&(Jt.textContent=Hn),Is=a(e),ut=p(e,"P",{"data-svelte-h":!0}),M(ut)!=="svelte-1qp3wc5"&&(ut.textContent=Xn),xs=a(e),r(Ct.$$.fragment,e),gs=a(e),ft=p(e,"P",{}),Fn(ft).forEach(l),this.h()},h(){vs(J,"name","hf:doc:metadata"),vs(J,"content",ia),qn(Tt.src,As="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/semantic_cache.jpg")||vs(Tt,"src",As)},m(e,t){ta(document.head,J),s(e,dt,t),s(e,jt,t),s(e,bt,t),o(u,e,t),s(e,It,t),o(C,e,t),s(e,xt,t),o(T,e,t),s(e,gt,t),s(e,j,t),s(e,$t,t),s(e,f,t),s(e,vt,t),s(e,d,t),s(e,Gt,t),s(e,b,t),s(e,Zt,t),s(e,I,t),s(e,Bt,t),s(e,x,t),s(e,kt,t),s(e,Tt,t),s(e,Wt,t),s(e,g,t),s(e,_t,t),s(e,$,t),s(e,Nt,t),s(e,v,t),s(e,At,t),s(e,G,t),s(e,Rt,t),s(e,Z,t),s(e,St,t),s(e,B,t),s(e,Vt,t),s(e,k,t),s(e,zt,t),s(e,W,t),s(e,Et,t),s(e,_,t),s(e,Yt,t),o(N,e,t),s(e,Qt,t),s(e,A,t),s(e,Ht,t),s(e,R,t),s(e,Xt,t),o(S,e,t),s(e,Ft,t),o(V,e,t),s(e,Lt,t),o(z,e,t),s(e,qt,t),s(e,E,t),s(e,Pt,t),o(Y,e,t),s(e,Dt,t),o(Q,e,t),s(e,Kt,t),s(e,H,t),s(e,Ot,t),o(X,e,t),s(e,el,t),o(F,e,t),s(e,tl,t),o(L,e,t),s(e,ll,t),o(q,e,t),s(e,sl,t),s(e,P,t),s(e,nl,t),s(e,D,t),s(e,al,t),o(K,e,t),s(e,il,t),s(e,O,t),s(e,pl,t),o(ee,e,t),s(e,Ml,t),o(te,e,t),s(e,ml,t),s(e,le,t),s(e,rl,t),o(se,e,t),s(e,ol,t),s(e,ne,t),s(e,cl,t),s(e,ae,t),s(e,yl,t),o(ie,e,t),s(e,hl,t),s(e,pe,t),s(e,wl,t),s(e,Me,t),s(e,Ul,t),s(e,me,t),s(e,Jl,t),o(re,e,t),s(e,ul,t),o(oe,e,t),s(e,Cl,t),s(e,ce,t),s(e,Tl,t),s(e,ye,t),s(e,jl,t),s(e,he,t),s(e,fl,t),o(we,e,t),s(e,dl,t),o(Ue,e,t),s(e,bl,t),s(e,Je,t),s(e,Il,t),s(e,ue,t),s(e,xl,t),s(e,Ce,t),s(e,gl,t),s(e,Te,t),s(e,$l,t),s(e,je,t),s(e,vl,t),s(e,fe,t),s(e,Gl,t),o(de,e,t),s(e,Zl,t),s(e,be,t),s(e,Bl,t),o(Ie,e,t),s(e,kl,t),s(e,xe,t),s(e,Wl,t),o(ge,e,t),s(e,_l,t),s(e,$e,t),s(e,Nl,t),s(e,ve,t),s(e,Al,t),s(e,Ge,t),s(e,Rl,t),s(e,Ze,t),s(e,Sl,t),o(Be,e,t),s(e,Vl,t),o(ke,e,t),s(e,zl,t),o(We,e,t),s(e,El,t),s(e,_e,t),s(e,Yl,t),o(Ne,e,t),s(e,Ql,t),s(e,Ae,t),s(e,Hl,t),s(e,Re,t),s(e,Xl,t),s(e,Se,t),s(e,Fl,t),o(Ve,e,t),s(e,Ll,t),s(e,ze,t),s(e,ql,t),s(e,Ee,t),s(e,Pl,t),s(e,Ye,t),s(e,Dl,t),s(e,Qe,t),s(e,Kl,t),o(He,e,t),s(e,Ol,t),s(e,Xe,t),s(e,es,t),s(e,Fe,t),s(e,ts,t),s(e,Le,t),s(e,ls,t),o(qe,e,t),s(e,ss,t),s(e,Pe,t),s(e,ns,t),s(e,De,t),s(e,as,t),o(Ke,e,t),s(e,is,t),s(e,Oe,t),s(e,ps,t),s(e,et,t),s(e,Ms,t),s(e,tt,t),s(e,ms,t),o(lt,e,t),s(e,rs,t),o(st,e,t),s(e,os,t),o(nt,e,t),s(e,cs,t),o(at,e,t),s(e,ys,t),s(e,it,t),s(e,hs,t),s(e,pt,t),s(e,ws,t),s(e,Mt,t),s(e,Us,t),o(mt,e,t),s(e,Js,t),o(rt,e,t),s(e,us,t),s(e,ot,t),s(e,Cs,t),o(ct,e,t),s(e,Ts,t),s(e,yt,t),s(e,js,t),o(ht,e,t),s(e,fs,t),s(e,wt,t),s(e,ds,t),s(e,Ut,t),s(e,bs,t),s(e,Jt,t),s(e,Is,t),s(e,ut,t),s(e,xs,t),o(Ct,e,t),s(e,gs,t),s(e,ft,t),$s=!0},p:Pn,i(e){$s||(c(u.$$.fragment,e),c(C.$$.fragment,e),c(T.$$.fragment,e),c(N.$$.fragment,e),c(S.$$.fragment,e),c(V.$$.fragment,e),c(z.$$.fragment,e),c(Y.$$.fragment,e),c(Q.$$.fragment,e),c(X.$$.fragment,e),c(F.$$.fragment,e),c(L.$$.fragment,e),c(q.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),c(se.$$.fragment,e),c(ie.$$.fragment,e),c(re.$$.fragment,e),c(oe.$$.fragment,e),c(we.$$.fragment,e),c(Ue.$$.fragment,e),c(de.$$.fragment,e),c(Ie.$$.fragment,e),c(ge.$$.fragment,e),c(Be.$$.fragment,e),c(ke.$$.fragment,e),c(We.$$.fragment,e),c(Ne.$$.fragment,e),c(Ve.$$.fragment,e),c(He.$$.fragment,e),c(qe.$$.fragment,e),c(Ke.$$.fragment,e),c(lt.$$.fragment,e),c(st.$$.fragment,e),c(nt.$$.fragment,e),c(at.$$.fragment,e),c(mt.$$.fragment,e),c(rt.$$.fragment,e),c(ct.$$.fragment,e),c(ht.$$.fragment,e),c(Ct.$$.fragment,e),$s=!0)},o(e){y(u.$$.fragment,e),y(C.$$.fragment,e),y(T.$$.fragment,e),y(N.$$.fragment,e),y(S.$$.fragment,e),y(V.$$.fragment,e),y(z.$$.fragment,e),y(Y.$$.fragment,e),y(Q.$$.fragment,e),y(X.$$.fragment,e),y(F.$$.fragment,e),y(L.$$.fragment,e),y(q.$$.fragment,e),y(K.$$.fragment,e),y(ee.$$.fragment,e),y(te.$$.fragment,e),y(se.$$.fragment,e),y(ie.$$.fragment,e),y(re.$$.fragment,e),y(oe.$$.fragment,e),y(we.$$.fragment,e),y(Ue.$$.fragment,e),y(de.$$.fragment,e),y(Ie.$$.fragment,e),y(ge.$$.fragment,e),y(Be.$$.fragment,e),y(ke.$$.fragment,e),y(We.$$.fragment,e),y(Ne.$$.fragment,e),y(Ve.$$.fragment,e),y(He.$$.fragment,e),y(qe.$$.fragment,e),y(Ke.$$.fragment,e),y(lt.$$.fragment,e),y(st.$$.fragment,e),y(nt.$$.fragment,e),y(at.$$.fragment,e),y(mt.$$.fragment,e),y(rt.$$.fragment,e),y(ct.$$.fragment,e),y(ht.$$.fragment,e),y(Ct.$$.fragment,e),$s=!1},d(e){e&&(l(dt),l(jt),l(bt),l(It),l(xt),l(gt),l(j),l($t),l(f),l(vt),l(d),l(Gt),l(b),l(Zt),l(I),l(Bt),l(x),l(kt),l(Tt),l(Wt),l(g),l(_t),l($),l(Nt),l(v),l(At),l(G),l(Rt),l(Z),l(St),l(B),l(Vt),l(k),l(zt),l(W),l(Et),l(_),l(Yt),l(Qt),l(A),l(Ht),l(R),l(Xt),l(Ft),l(Lt),l(qt),l(E),l(Pt),l(Dt),l(Kt),l(H),l(Ot),l(el),l(tl),l(ll),l(sl),l(P),l(nl),l(D),l(al),l(il),l(O),l(pl),l(Ml),l(ml),l(le),l(rl),l(ol),l(ne),l(cl),l(ae),l(yl),l(hl),l(pe),l(wl),l(Me),l(Ul),l(me),l(Jl),l(ul),l(Cl),l(ce),l(Tl),l(ye),l(jl),l(he),l(fl),l(dl),l(bl),l(Je),l(Il),l(ue),l(xl),l(Ce),l(gl),l(Te),l($l),l(je),l(vl),l(fe),l(Gl),l(Zl),l(be),l(Bl),l(kl),l(xe),l(Wl),l(_l),l($e),l(Nl),l(ve),l(Al),l(Ge),l(Rl),l(Ze),l(Sl),l(Vl),l(zl),l(El),l(_e),l(Yl),l(Ql),l(Ae),l(Hl),l(Re),l(Xl),l(Se),l(Fl),l(Ll),l(ze),l(ql),l(Ee),l(Pl),l(Ye),l(Dl),l(Qe),l(Kl),l(Ol),l(Xe),l(es),l(Fe),l(ts),l(Le),l(ls),l(ss),l(Pe),l(ns),l(De),l(as),l(is),l(Oe),l(ps),l(et),l(Ms),l(tt),l(ms),l(rs),l(os),l(cs),l(ys),l(it),l(hs),l(pt),l(ws),l(Mt),l(Us),l(Js),l(us),l(ot),l(Cs),l(Ts),l(yt),l(js),l(fs),l(wt),l(ds),l(Ut),l(bs),l(Jt),l(Is),l(ut),l(xs),l(gs),l(ft)),l(J),h(u,e),h(C,e),h(T,e),h(N,e),h(S,e),h(V,e),h(z,e),h(Y,e),h(Q,e),h(X,e),h(F,e),h(L,e),h(q,e),h(K,e),h(ee,e),h(te,e),h(se,e),h(ie,e),h(re,e),h(oe,e),h(we,e),h(Ue,e),h(de,e),h(Ie,e),h(ge,e),h(Be,e),h(ke,e),h(We,e),h(Ne,e),h(Ve,e),h(He,e),h(qe,e),h(Ke,e),h(lt,e),h(st,e),h(nt,e),h(at,e),h(mt,e),h(rt,e),h(ct,e),h(ht,e),h(Ct,e)}}}const ia='{"title":"通过引入语义缓存到 FAISS 中以增强 RAG 系统的性能","local":"通过引入语义缓存到-faiss-中以增强-rag-系统的性能","sections":[],"depth":1}';function pa(Gs){return Dn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ya extends Kn{constructor(J){super(),On(this,J,pa,aa,Ln,{})}}export{ya as component};
