import{s as kt,f as Gt,n as St,o as xt}from"../chunks/scheduler.f6319a2a.js";import{S as _t,i as Qt,g as i,s,r,A as Ht,h as o,f as l,c as a,j as Vt,u,x as p,k as me,y as Lt,a as n,v as m,d as g,t as c,w as M}from"../chunks/index.85aa684c.js";import{C as b}from"../chunks/CodeBlock.3400fc53.js";import{D as Ft}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as w,E as Et}from"../chunks/getInferenceSnippets.0233181f.js";function Nt(it){let T,ge,re,ce,y,Me,f,Te,d,ot='<p>If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.</p>',be,J,we,U,pt="Agent runs are complicated to debug.",de,I,rt='Validating that a run went properly is hard, since agent workflows are <a href="../conceptual_guides/intro_agents">unpredictable by design</a> (if they were predictable, you’d just be using good old code).',he,j,ut="And inspecting a run is hard as well: multi-step agents tend to quickly fill a console with logs, and most of the errors are just “LLM dumb” kind of errors, from which the LLM auto-corrects in the next step by writing better code or tool calls.",ye,$,mt="So using instrumentation to record agent runs is necessary in production for later inspection and monitoring!",fe,v,gt='We’ve adopted the <a href="https://opentelemetry.io/" rel="nofollow">OpenTelemetry</a> standard for instrumenting agent runs.',Je,W,ct="This means that you can just run some instrumentation code, then run your agents normally, and everything gets logged into your platform. Below are some examples of how to do this with different OpenTelemetry backends.",Ue,Z,Mt="Here’s how it then looks like on the platform:",Ie,h,Tt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/inspect_run_phoenix.gif"/>',je,C,$e,B,bt='First install the required packages. Here we install <a href="https://github.com/Arize-ai/phoenix" rel="nofollow">Phoenix by Arize AI</a> because that’s a good solution to collect and inspect the logs, but there are other OpenTelemetry-compatible platforms that you could use for this collection &amp; inspection part.',ve,V,We,k,wt="Then run the collector in the background.",Ze,G,Ce,S,dt="Finally, set up <code>SmolagentsInstrumentor</code> to trace your agents and send the traces to Phoenix default endpoint.",Be,x,Ve,_,ht="Then you can run your agents!",ke,Q,Ge,H,yt=`Voilà!
You can then navigate to <code>http://0.0.0.0:6006/projects/</code> to inspect your run!`,Se,pe,ft,xe,L,Jt="You can see that the CodeAgent called its managed ToolCallingAgent (by the way, the managed agent could have been a CodeAgent as well) to ask it to run the web search for the U.S. 2024 growth rate. Then the managed agent returned its report and the manager agent acted upon it to calculate the economy doubling time! Sweet, isn’t it?",_e,F,Qe,E,Ut="This part shows how to monitor and debug your Hugging Face <strong>smolagents</strong> with <strong>Langfuse</strong> using the <code>SmolagentsInstrumentor</code>.",He,N,It='<p><strong>What is Langfuse?</strong> <a href="https://langfuse.com" rel="nofollow">Langfuse</a> is an open-source platform for LLM engineering. It provides tracing and monitoring capabilities for AI agents, helping developers debug, analyze, and optimize their products. Langfuse integrates with various tools and frameworks via native integrations, OpenTelemetry, and SDKs.</p>',Le,R,Fe,A,Ee,z,Ne,Y,jt='Set your Langfuse API keys and configure the OpenTelemetry endpoint to send traces to Langfuse. Get your Langfuse API keys by signing up for <a href="https://cloud.langfuse.com" rel="nofollow">Langfuse Cloud</a> or <a href="https://langfuse.com/self-hosting" rel="nofollow">self-hosting Langfuse</a>.',Re,q,$t='Also, add your <a href="https://huggingface.co/settings/tokens" rel="nofollow">Hugging Face token</a> (<code>HF_TOKEN</code>) as an environment variable.',Ae,X,ze,P,vt="With the environment variables set, we can now initialize the Langfuse client. <code>get_client()</code> initializes the Langfuse client using the credentials provided in the environment variables.",Ye,D,qe,O,Xe,K,Wt="Initialize the <code>SmolagentsInstrumentor</code> before your application code.",Pe,ee,De,te,Oe,le,Ke,ne,et,se,Zt='After running the agent, you can view the traces generated by your smolagents application in <a href="https://cloud.langfuse.com" rel="nofollow">Langfuse</a>. You should see detailed steps of the LLM interactions, which can help you debug and optimize your AI agent.',tt,ae,Ct='<img src="https://langfuse.com/images/cookbook/integration-smolagents/smolagent_example_trace.png" alt="smolagents example trace"/>',lt,ie,Bt='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/ce5160f9bfd5a6cd63b07d2bfcec6f54?timestamp=2025-02-11T09%3A25%3A45.163Z&amp;display=details" rel="nofollow">Public example trace in Langfuse</a></em>',nt,oe,st,ue,at;return y=new w({props:{title:"Inspecting runs with OpenTelemetry",local:"inspecting-runs-with-opentelemetry",headingTag:"h1"}}),f=new Ft({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/inspect_runs.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/inspect_runs.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/inspect_runs.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/inspect_runs.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/inspect_runs.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/inspect_runs.ipynb"}]}}),J=new w({props:{title:"Why log your agent runs?",local:"why-log-your-agent-runs",headingTag:"h2"}}),C=new w({props:{title:"Setting up telemetry with Arize AI Phoenix",local:"setting-up-telemetry-with-arize-ai-phoenix",headingTag:"h2"}}),V=new b({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCdGVsZW1ldHJ5JTJDdG9vbGtpdCU1RCc=",highlighted:"pip install &#x27;smolagents[telemetry,toolkit]&#x27;",wrap:!1}}),G=new b({props:{code:"cHl0aG9uJTIwLW0lMjBwaG9lbml4LnNlcnZlci5tYWluJTIwc2VydmU=",highlighted:"python -m phoenix.server.main serve",wrap:!1}}),x=new b({props:{code:"ZnJvbSUyMHBob2VuaXgub3RlbCUyMGltcG9ydCUyMHJlZ2lzdGVyJTBBZnJvbSUyMG9wZW5pbmZlcmVuY2UuaW5zdHJ1bWVudGF0aW9uLnNtb2xhZ2VudHMlMjBpbXBvcnQlMjBTbW9sYWdlbnRzSW5zdHJ1bWVudG9yJTBBJTBBcmVnaXN0ZXIoKSUwQVNtb2xhZ2VudHNJbnN0cnVtZW50b3IoKS5pbnN0cnVtZW50KCk=",highlighted:`<span class="hljs-keyword">from</span> phoenix.otel <span class="hljs-keyword">import</span> register
<span class="hljs-keyword">from</span> openinference.instrumentation.smolagents <span class="hljs-keyword">import</span> SmolagentsInstrumentor

register()
SmolagentsInstrumentor().instrument()`,wrap:!1}}),Q=new b({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQ29kZUFnZW50JTJDJTBBJTIwJTIwJTIwJTIwVG9vbENhbGxpbmdBZ2VudCUyQyUwQSUyMCUyMCUyMCUyMFdlYlNlYXJjaFRvb2wlMkMlMEElMjAlMjAlMjAlMjBWaXNpdFdlYnBhZ2VUb29sJTJDJTBBJTIwJTIwJTIwJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwlMkMlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTBBJTBBc2VhcmNoX2FnZW50JTIwJTNEJTIwVG9vbENhbGxpbmdBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QldlYlNlYXJjaFRvb2woKSUyQyUyMFZpc2l0V2VicGFnZVRvb2woKSU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyc2VhcmNoX2FnZW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJUaGlzJTIwaXMlMjBhbiUyMGFnZW50JTIwdGhhdCUyMGNhbiUyMGRvJTIwd2ViJTIwc2VhcmNoLiUyMiUyQyUwQSklMEElMEFtYW5hZ2VyX2FnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG1hbmFnZWRfYWdlbnRzJTNEJTVCc2VhcmNoX2FnZW50JTVEJTJDJTBBKSUwQW1hbmFnZXJfYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMklmJTIwdGhlJTIwVVMlMjBrZWVwcyUyMGl0cyUyMDIwMjQlMjBncm93dGglMjByYXRlJTJDJTIwaG93JTIwbWFueSUyMHllYXJzJTIwd2lsbCUyMGl0JTIwdGFrZSUyMGZvciUyMHRoZSUyMEdEUCUyMHRvJTIwZG91YmxlJTNGJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (
    CodeAgent,
    ToolCallingAgent,
    WebSearchTool,
    VisitWebpageTool,
    InferenceClientModel,
)

model = InferenceClientModel()

search_agent = ToolCallingAgent(
    tools=[WebSearchTool(), VisitWebpageTool()],
    model=model,
    name=<span class="hljs-string">&quot;search_agent&quot;</span>,
    description=<span class="hljs-string">&quot;This is an agent that can do web search.&quot;</span>,
)

manager_agent = CodeAgent(
    tools=[],
    model=model,
    managed_agents=[search_agent],
)
manager_agent.run(
    <span class="hljs-string">&quot;If the US keeps its 2024 growth rate, how many years will it take for the GDP to double?&quot;</span>
)`,wrap:!1}}),F=new w({props:{title:"Setting up telemetry with 🪢 Langfuse",local:"setting-up-telemetry-with--langfuse",headingTag:"h2"}}),R=new w({props:{title:"Step 1: Install Dependencies",local:"step-1-install-dependencies",headingTag:"h3"}}),A=new b({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdmdXNlJTIwJ3Ntb2xhZ2VudHMlNUJ0ZWxlbWV0cnklNUQnJTIwb3BlbmluZmVyZW5jZS1pbnN0cnVtZW50YXRpb24tc21vbGFnZW50cw==",highlighted:'%pip install langfuse <span class="hljs-string">&#x27;smolagents[telemetry]&#x27;</span> openinference-instrumentation-smolagents',wrap:!1}}),z=new w({props:{title:"Step 2: Set Up Environment Variables",local:"step-2-set-up-environment-variables",headingTag:"h3"}}),X=new b({props:{code:"aW1wb3J0JTIwb3MlMEElMjMlMjBHZXQlMjBrZXlzJTIwZm9yJTIweW91ciUyMHByb2plY3QlMjBmcm9tJTIwdGhlJTIwcHJvamVjdCUyMHNldHRpbmdzJTIwcGFnZSUzQSUyMGh0dHBzJTNBJTJGJTJGY2xvdWQubGFuZ2Z1c2UuY29tJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX1BVQkxJQ19LRVklMjIlNUQlMjAlM0QlMjAlMjJway1sZi0uLi4lMjIlMjAlMEFvcy5lbnZpcm9uJTVCJTIyTEFOR0ZVU0VfU0VDUkVUX0tFWSUyMiU1RCUyMCUzRCUyMCUyMnNrLWxmLS4uLiUyMiUyMCUwQW9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZjbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjMlMjAlRjAlOUYlODclQUElRjAlOUYlODclQkElMjBFVSUyMHJlZ2lvbiUwQSUyMyUyMG9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ1cy5jbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjMlMjAlRjAlOUYlODclQkElRjAlOUYlODclQjglMjBVUyUyMHJlZ2lvbiUwQSUyMCUwQSUyMyUyMHlvdXIlMjBIdWdnaW5nJTIwRmFjZSUyMHRva2VuJTBBb3MuZW52aXJvbiU1QiUyMkhGX1RPS0VOJTIyJTVEJTIwJTNEJTIwJTIyaGZfLi4uJTIy",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-comment"># Get keys for your project from the project settings page: https://cloud.langfuse.com</span>
os.environ[<span class="hljs-string">&quot;LANGFUSE_PUBLIC_KEY&quot;</span>] = <span class="hljs-string">&quot;pk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_SECRET_KEY&quot;</span>] = <span class="hljs-string">&quot;sk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>] = <span class="hljs-string">&quot;https://cloud.langfuse.com&quot;</span> <span class="hljs-comment"># 🇪🇺 EU region</span>
<span class="hljs-comment"># os.environ[&quot;LANGFUSE_HOST&quot;] = &quot;https://us.cloud.langfuse.com&quot; # 🇺🇸 US region</span>
 
<span class="hljs-comment"># your Hugging Face token</span>
os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>] = <span class="hljs-string">&quot;hf_...&quot;</span>`,wrap:!1}}),D=new b({props:{code:"ZnJvbSUyMGxhbmdmdXNlJTIwaW1wb3J0JTIwZ2V0X2NsaWVudCUwQSUyMCUwQWxhbmdmdXNlJTIwJTNEJTIwZ2V0X2NsaWVudCgpJTBBJTIwJTBBJTIzJTIwVmVyaWZ5JTIwY29ubmVjdGlvbiUwQWlmJTIwbGFuZ2Z1c2UuYXV0aF9jaGVjaygpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyTGFuZ2Z1c2UlMjBjbGllbnQlMjBpcyUyMGF1dGhlbnRpY2F0ZWQlMjBhbmQlMjByZWFkeSElMjIpJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkF1dGhlbnRpY2F0aW9uJTIwZmFpbGVkLiUyMFBsZWFzZSUyMGNoZWNrJTIweW91ciUyMGNyZWRlbnRpYWxzJTIwYW5kJTIwaG9zdC4lMjIp",highlighted:`<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> get_client
 
langfuse = get_client()
 
<span class="hljs-comment"># Verify connection</span>
<span class="hljs-keyword">if</span> langfuse.auth_check():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Langfuse client is authenticated and ready!&quot;</span>)
<span class="hljs-keyword">else</span>:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Authentication failed. Please check your credentials and host.&quot;</span>)`,wrap:!1}}),O=new w({props:{title:"Step 3: Initialize the SmolagentsInstrumentor",local:"step-3-initialize-the-smolagentsinstrumentor",headingTag:"h3"}}),ee=new b({props:{code:"ZnJvbSUyMG9wZW5pbmZlcmVuY2UuaW5zdHJ1bWVudGF0aW9uLnNtb2xhZ2VudHMlMjBpbXBvcnQlMjBTbW9sYWdlbnRzSW5zdHJ1bWVudG9yJTBBJTIwJTBBU21vbGFnZW50c0luc3RydW1lbnRvcigpLmluc3RydW1lbnQoKQ==",highlighted:`<span class="hljs-keyword">from</span> openinference.instrumentation.smolagents <span class="hljs-keyword">import</span> SmolagentsInstrumentor
 
SmolagentsInstrumentor().instrument()`,wrap:!1}}),te=new w({props:{title:"Step 4: Run your smolagent",local:"step-4-run-your-smolagent",headingTag:"h3"}}),le=new b({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQ29kZUFnZW50JTJDJTBBJTIwJTIwJTIwJTIwVG9vbENhbGxpbmdBZ2VudCUyQyUwQSUyMCUyMCUyMCUyMFdlYlNlYXJjaFRvb2wlMkMlMEElMjAlMjAlMjAlMjBWaXNpdFdlYnBhZ2VUb29sJTJDJTBBJTIwJTIwJTIwJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwlMkMlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCUyMmRlZXBzZWVrLWFpJTJGRGVlcFNlZWstUjEtRGlzdGlsbC1Rd2VuLTMyQiUyMiUwQSklMEElMEFzZWFyY2hfYWdlbnQlMjAlM0QlMjBUb29sQ2FsbGluZ0FnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCV2ViU2VhcmNoVG9vbCgpJTJDJTIwVmlzaXRXZWJwYWdlVG9vbCgpJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG5hbWUlM0QlMjJzZWFyY2hfYWdlbnQlMjIlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMlRoaXMlMjBpcyUyMGFuJTIwYWdlbnQlMjB0aGF0JTIwY2FuJTIwZG8lMjB3ZWIlMjBzZWFyY2guJTIyJTJDJTBBKSUwQSUwQW1hbmFnZXJfYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUIlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwbWFuYWdlZF9hZ2VudHMlM0QlNUJzZWFyY2hfYWdlbnQlNUQlMkMlMEEpJTBBbWFuYWdlcl9hZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIySG93JTIwY2FuJTIwTGFuZ2Z1c2UlMjBiZSUyMHVzZWQlMjB0byUyMG1vbml0b3IlMjBhbmQlMjBpbXByb3ZlJTIwdGhlJTIwcmVhc29uaW5nJTIwYW5kJTIwZGVjaXNpb24tbWFraW5nJTIwb2YlMjBzbW9sYWdlbnRzJTIwd2hlbiUyMHRoZXklMjBleGVjdXRlJTIwbXVsdGktc3RlcCUyMHRhc2tzJTJDJTIwbGlrZSUyMGR5bmFtaWNhbGx5JTIwYWRqdXN0aW5nJTIwYSUyMHJlY2lwZSUyMGJhc2VkJTIwb24lMjB1c2VyJTIwZmVlZGJhY2slMjBvciUyMGF2YWlsYWJsZSUyMGluZ3JlZGllbnRzJTNGJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (
    CodeAgent,
    ToolCallingAgent,
    WebSearchTool,
    VisitWebpageTool,
    InferenceClientModel,
)

model = InferenceClientModel(
    model_id=<span class="hljs-string">&quot;deepseek-ai/DeepSeek-R1-Distill-Qwen-32B&quot;</span>
)

search_agent = ToolCallingAgent(
    tools=[WebSearchTool(), VisitWebpageTool()],
    model=model,
    name=<span class="hljs-string">&quot;search_agent&quot;</span>,
    description=<span class="hljs-string">&quot;This is an agent that can do web search.&quot;</span>,
)

manager_agent = CodeAgent(
    tools=[],
    model=model,
    managed_agents=[search_agent],
)
manager_agent.run(
    <span class="hljs-string">&quot;How can Langfuse be used to monitor and improve the reasoning and decision-making of smolagents when they execute multi-step tasks, like dynamically adjusting a recipe based on user feedback or available ingredients?&quot;</span>
)`,wrap:!1}}),ne=new w({props:{title:"Step 5: View Traces in Langfuse",local:"step-5-view-traces-in-langfuse",headingTag:"h3"}}),oe=new Et({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/inspect_runs.md"}}),{c(){T=i("meta"),ge=s(),re=i("p"),ce=s(),r(y.$$.fragment),Me=s(),r(f.$$.fragment),Te=s(),d=i("blockquote"),d.innerHTML=ot,be=s(),r(J.$$.fragment),we=s(),U=i("p"),U.textContent=pt,de=s(),I=i("p"),I.innerHTML=rt,he=s(),j=i("p"),j.textContent=ut,ye=s(),$=i("p"),$.textContent=mt,fe=s(),v=i("p"),v.innerHTML=gt,Je=s(),W=i("p"),W.textContent=ct,Ue=s(),Z=i("p"),Z.textContent=Mt,Ie=s(),h=i("div"),h.innerHTML=Tt,je=s(),r(C.$$.fragment),$e=s(),B=i("p"),B.innerHTML=bt,ve=s(),r(V.$$.fragment),We=s(),k=i("p"),k.textContent=wt,Ze=s(),r(G.$$.fragment),Ce=s(),S=i("p"),S.innerHTML=dt,Be=s(),r(x.$$.fragment),Ve=s(),_=i("p"),_.textContent=ht,ke=s(),r(Q.$$.fragment),Ge=s(),H=i("p"),H.innerHTML=yt,Se=s(),pe=i("img"),xe=s(),L=i("p"),L.textContent=Jt,_e=s(),r(F.$$.fragment),Qe=s(),E=i("p"),E.innerHTML=Ut,He=s(),N=i("blockquote"),N.innerHTML=It,Le=s(),r(R.$$.fragment),Fe=s(),r(A.$$.fragment),Ee=s(),r(z.$$.fragment),Ne=s(),Y=i("p"),Y.innerHTML=jt,Re=s(),q=i("p"),q.innerHTML=$t,Ae=s(),r(X.$$.fragment),ze=s(),P=i("p"),P.innerHTML=vt,Ye=s(),r(D.$$.fragment),qe=s(),r(O.$$.fragment),Xe=s(),K=i("p"),K.innerHTML=Wt,Pe=s(),r(ee.$$.fragment),De=s(),r(te.$$.fragment),Oe=s(),r(le.$$.fragment),Ke=s(),r(ne.$$.fragment),et=s(),se=i("p"),se.innerHTML=Zt,tt=s(),ae=i("p"),ae.innerHTML=Ct,lt=s(),ie=i("p"),ie.innerHTML=Bt,nt=s(),r(oe.$$.fragment),st=s(),ue=i("p"),this.h()},l(e){const t=Ht("svelte-u9bgzb",document.head);T=o(t,"META",{name:!0,content:!0}),t.forEach(l),ge=a(e),re=o(e,"P",{}),Vt(re).forEach(l),ce=a(e),u(y.$$.fragment,e),Me=a(e),u(f.$$.fragment,e),Te=a(e),d=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(d)!=="svelte-1eo9frz"&&(d.innerHTML=ot),be=a(e),u(J.$$.fragment,e),we=a(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-b60rwm"&&(U.textContent=pt),de=a(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1vbx0nq"&&(I.innerHTML=rt),he=a(e),j=o(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-6dts52"&&(j.textContent=ut),ye=a(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-be9uix"&&($.textContent=mt),fe=a(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-a44to5"&&(v.innerHTML=gt),Je=a(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1fuj4vi"&&(W.textContent=ct),Ue=a(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-18al2cw"&&(Z.textContent=Mt),Ie=a(e),h=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(h)!=="svelte-14dyk5w"&&(h.innerHTML=Tt),je=a(e),u(C.$$.fragment,e),$e=a(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-o5owj0"&&(B.innerHTML=bt),ve=a(e),u(V.$$.fragment,e),We=a(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1g5pcik"&&(k.textContent=wt),Ze=a(e),u(G.$$.fragment,e),Ce=a(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-y3xi4v"&&(S.innerHTML=dt),Be=a(e),u(x.$$.fragment,e),Ve=a(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1j1jswr"&&(_.textContent=ht),ke=a(e),u(Q.$$.fragment,e),Ge=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-jcl2lc"&&(H.innerHTML=yt),Se=a(e),pe=o(e,"IMG",{src:!0}),xe=a(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-11c8ug9"&&(L.textContent=Jt),_e=a(e),u(F.$$.fragment,e),Qe=a(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1klyknm"&&(E.innerHTML=Ut),He=a(e),N=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),p(N)!=="svelte-10vakt2"&&(N.innerHTML=It),Le=a(e),u(R.$$.fragment,e),Fe=a(e),u(A.$$.fragment,e),Ee=a(e),u(z.$$.fragment,e),Ne=a(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-e5j4hz"&&(Y.innerHTML=jt),Re=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-8df0ib"&&(q.innerHTML=$t),Ae=a(e),u(X.$$.fragment,e),ze=a(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-wfv4z0"&&(P.innerHTML=vt),Ye=a(e),u(D.$$.fragment,e),qe=a(e),u(O.$$.fragment,e),Xe=a(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-pz6aii"&&(K.innerHTML=Wt),Pe=a(e),u(ee.$$.fragment,e),De=a(e),u(te.$$.fragment,e),Oe=a(e),u(le.$$.fragment,e),Ke=a(e),u(ne.$$.fragment,e),et=a(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1207qpx"&&(se.innerHTML=Zt),tt=a(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-jw4wqs"&&(ae.innerHTML=Ct),lt=a(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-7h9ald"&&(ie.innerHTML=Bt),nt=a(e),u(oe.$$.fragment,e),st=a(e),ue=o(e,"P",{}),Vt(ue).forEach(l),this.h()},h(){me(T,"name","hf:doc:metadata"),me(T,"content",Rt),me(d,"class","tip"),me(h,"class","flex justify-center"),Gt(pe.src,ft="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/inspect_run_phoenix.png")||me(pe,"src",ft)},m(e,t){Lt(document.head,T),n(e,ge,t),n(e,re,t),n(e,ce,t),m(y,e,t),n(e,Me,t),m(f,e,t),n(e,Te,t),n(e,d,t),n(e,be,t),m(J,e,t),n(e,we,t),n(e,U,t),n(e,de,t),n(e,I,t),n(e,he,t),n(e,j,t),n(e,ye,t),n(e,$,t),n(e,fe,t),n(e,v,t),n(e,Je,t),n(e,W,t),n(e,Ue,t),n(e,Z,t),n(e,Ie,t),n(e,h,t),n(e,je,t),m(C,e,t),n(e,$e,t),n(e,B,t),n(e,ve,t),m(V,e,t),n(e,We,t),n(e,k,t),n(e,Ze,t),m(G,e,t),n(e,Ce,t),n(e,S,t),n(e,Be,t),m(x,e,t),n(e,Ve,t),n(e,_,t),n(e,ke,t),m(Q,e,t),n(e,Ge,t),n(e,H,t),n(e,Se,t),n(e,pe,t),n(e,xe,t),n(e,L,t),n(e,_e,t),m(F,e,t),n(e,Qe,t),n(e,E,t),n(e,He,t),n(e,N,t),n(e,Le,t),m(R,e,t),n(e,Fe,t),m(A,e,t),n(e,Ee,t),m(z,e,t),n(e,Ne,t),n(e,Y,t),n(e,Re,t),n(e,q,t),n(e,Ae,t),m(X,e,t),n(e,ze,t),n(e,P,t),n(e,Ye,t),m(D,e,t),n(e,qe,t),m(O,e,t),n(e,Xe,t),n(e,K,t),n(e,Pe,t),m(ee,e,t),n(e,De,t),m(te,e,t),n(e,Oe,t),m(le,e,t),n(e,Ke,t),m(ne,e,t),n(e,et,t),n(e,se,t),n(e,tt,t),n(e,ae,t),n(e,lt,t),n(e,ie,t),n(e,nt,t),m(oe,e,t),n(e,st,t),n(e,ue,t),at=!0},p:St,i(e){at||(g(y.$$.fragment,e),g(f.$$.fragment,e),g(J.$$.fragment,e),g(C.$$.fragment,e),g(V.$$.fragment,e),g(G.$$.fragment,e),g(x.$$.fragment,e),g(Q.$$.fragment,e),g(F.$$.fragment,e),g(R.$$.fragment,e),g(A.$$.fragment,e),g(z.$$.fragment,e),g(X.$$.fragment,e),g(D.$$.fragment,e),g(O.$$.fragment,e),g(ee.$$.fragment,e),g(te.$$.fragment,e),g(le.$$.fragment,e),g(ne.$$.fragment,e),g(oe.$$.fragment,e),at=!0)},o(e){c(y.$$.fragment,e),c(f.$$.fragment,e),c(J.$$.fragment,e),c(C.$$.fragment,e),c(V.$$.fragment,e),c(G.$$.fragment,e),c(x.$$.fragment,e),c(Q.$$.fragment,e),c(F.$$.fragment,e),c(R.$$.fragment,e),c(A.$$.fragment,e),c(z.$$.fragment,e),c(X.$$.fragment,e),c(D.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),c(le.$$.fragment,e),c(ne.$$.fragment,e),c(oe.$$.fragment,e),at=!1},d(e){e&&(l(ge),l(re),l(ce),l(Me),l(Te),l(d),l(be),l(we),l(U),l(de),l(I),l(he),l(j),l(ye),l($),l(fe),l(v),l(Je),l(W),l(Ue),l(Z),l(Ie),l(h),l(je),l($e),l(B),l(ve),l(We),l(k),l(Ze),l(Ce),l(S),l(Be),l(Ve),l(_),l(ke),l(Ge),l(H),l(Se),l(pe),l(xe),l(L),l(_e),l(Qe),l(E),l(He),l(N),l(Le),l(Fe),l(Ee),l(Ne),l(Y),l(Re),l(q),l(Ae),l(ze),l(P),l(Ye),l(qe),l(Xe),l(K),l(Pe),l(De),l(Oe),l(Ke),l(et),l(se),l(tt),l(ae),l(lt),l(ie),l(nt),l(st),l(ue)),l(T),M(y,e),M(f,e),M(J,e),M(C,e),M(V,e),M(G,e),M(x,e),M(Q,e),M(F,e),M(R,e),M(A,e),M(z,e),M(X,e),M(D,e),M(O,e),M(ee,e),M(te,e),M(le,e),M(ne,e),M(oe,e)}}}const Rt='{"title":"Inspecting runs with OpenTelemetry","local":"inspecting-runs-with-opentelemetry","sections":[{"title":"Why log your agent runs?","local":"why-log-your-agent-runs","sections":[],"depth":2},{"title":"Setting up telemetry with Arize AI Phoenix","local":"setting-up-telemetry-with-arize-ai-phoenix","sections":[],"depth":2},{"title":"Setting up telemetry with 🪢 Langfuse","local":"setting-up-telemetry-with--langfuse","sections":[{"title":"Step 1: Install Dependencies","local":"step-1-install-dependencies","sections":[],"depth":3},{"title":"Step 2: Set Up Environment Variables","local":"step-2-set-up-environment-variables","sections":[],"depth":3},{"title":"Step 3: Initialize the SmolagentsInstrumentor","local":"step-3-initialize-the-smolagentsinstrumentor","sections":[],"depth":3},{"title":"Step 4: Run your smolagent","local":"step-4-run-your-smolagent","sections":[],"depth":3},{"title":"Step 5: View Traces in Langfuse","local":"step-5-view-traces-in-langfuse","sections":[],"depth":3}],"depth":2}],"depth":1}';function At(it){return xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Dt extends _t{constructor(T){super(),Qt(this,T,At,Nt,kt,{})}}export{Dt as component};
