import{s as pl,f as al,n as Ml,o as ml}from"../chunks/scheduler.f6319a2a.js";import{S as ul,i as bl,g as a,s as n,r as M,A as dl,h as i,f as l,c as o,j as il,u as m,x as p,k as ye,y as rl,a as s,v as u,d as b,t as d,w as r}from"../chunks/index.85aa684c.js";import{C as c}from"../chunks/CodeBlock.3400fc53.js";import{D as cl}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as ce,E as hl}from"../chunks/getInferenceSnippets.0233181f.js";function fl(jt){let h,ge,Ue,we,U,Je,T,je,g,Ct="在这里，我们将学习高级工具的使用。",Ce,f,vt='<p>如果你是构建 agent 的新手，请确保先阅读 <a href="../conceptual_guides/intro_agents">agent 介绍</a> 和 <a href="../guided_tour">smolagents 导览</a>。</p>',ve,w,_t='<li><a href="#%E5%B7%A5%E5%85%B7">工具</a><ul><li><a href="#%E4%BB%80%E4%B9%88%E6%98%AF%E5%B7%A5%E5%85%B7%E5%A6%82%E4%BD%95%E6%9E%84%E5%BB%BA%E4%B8%80%E4%B8%AA%E5%B7%A5%E5%85%B7">什么是工具，如何构建一个工具？</a></li> <li><a href="#%E5%B0%86%E4%BD%A0%E7%9A%84%E5%B7%A5%E5%85%B7%E5%88%86%E4%BA%AB%E5%88%B0-hub">将你的工具分享到 Hub</a></li> <li><a href="#%E5%B0%86-space-%E5%AF%BC%E5%85%A5%E4%B8%BA%E5%B7%A5%E5%85%B7">将 Space 导入为工具</a></li> <li><a href="#%E4%BD%BF%E7%94%A8-langchain-%E5%B7%A5%E5%85%B7">使用 LangChain 工具</a></li> <li><a href="#%E7%AE%A1%E7%90%86%E4%BD%A0%E7%9A%84-agent-%E5%B7%A5%E5%85%B7%E7%AE%B1">管理你的 agent 工具箱</a></li> <li><a href="#%E4%BD%BF%E7%94%A8%E5%B7%A5%E5%85%B7%E9%9B%86%E5%90%88">使用工具集合</a></li></ul></li>',_e,J,Ie,j,It="工具主要是 LLM 可以在 agent 系统中使用的函数。",Be,C,Bt="但要使用它，LLM 需要被提供一个 API：名称、工具描述、输入类型和描述、输出类型。",$e,v,$t="所以它不能仅仅是一个函数。它应该是一个类。",Ze,_,Zt="因此，核心上，工具是一个类，它包装了一个函数，并带有帮助 LLM 理解如何使用它的元数据。",Ge,I,Gt="以下是它的结构：",He,B,Ee,$,Ht='自定义工具继承 <a href="/docs/smolagents/main/zh/reference/tools#smolagents.Tool">Tool</a> 以继承有用的方法。子类还定义了：',xe,Z,Et='<li>一个属性 <code>name</code>，对应于工具本身的名称。名称通常描述工具的功能。由于代码返回任务中下载量最多的模型，我们将其命名为 <code>model_download_counter</code>。</li> <li>一个属性 <code>description</code>，用于填充 agent 的系统提示。</li> <li>一个 <code>inputs</code> 属性，它是一个带有键 <code>&quot;type&quot;</code> 和 <code>&quot;description&quot;</code> 的字典。它包含帮助 Python 解释器对输入做出明智选择的信息。</li> <li>一个 <code>output_type</code> 属性，指定输出类型。<code>inputs</code> 和 <code>output_type</code> 的类型应为 <a href="https://docs.pydantic.dev/latest/concepts/json_schema/#generating-json-schema" rel="nofollow">Pydantic 格式</a>，它们可以是以下之一：<code>~AUTHORIZED_TYPES()</code>。</li> <li>一个 <code>forward</code> 方法，包含要执行的推理代码。</li>',We,G,xt="这就是它在 agent 中使用所需的全部内容！",ke,H,Wt='还有另一种构建工具的方法。在 <a href="../guided_tour">guided_tour</a> 中，我们使用 <code>@tool</code> 装饰器实现了一个工具。<a href="/docs/smolagents/main/zh/reference/tools#smolagents.tool">tool()</a> 装饰器是定义简单工具的推荐方式，但有时你需要更多：在类中使用多个方法以获得更清晰的代码，或使用额外的类属性。',Re,E,kt='在这种情况下，你可以通过如上所述继承 <a href="/docs/smolagents/main/zh/reference/tools#smolagents.Tool">Tool</a> 来构建你的工具。',Qe,x,Ae,W,Rt='你可以通过调用 <a href="/docs/smolagents/main/zh/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> 将你的自定义工具分享到 Hub。确保你已经在 Hub 上为其创建了一个仓库，并且使用的是具有读取权限的 token。',Ve,k,Se,R,Qt="为了使推送到 Hub 正常工作，你的工具需要遵守一些规则：",Le,Q,At='<li>所有方法都是自包含的，例如使用来自其参数中的变量。</li> <li>根据上述要点，<strong>所有导入应直接在工具的函数中定义</strong>，否则在尝试使用 <a href="/docs/smolagents/main/zh/reference/tools#smolagents.Tool.save">save()</a> 或 <a href="/docs/smolagents/main/zh/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> 调用你的自定义工具时会出现错误。</li> <li>如果你继承了 <code>__init__</code> 方法，除了 <code>self</code> 之外，你不能给它任何其他参数。这是因为在特定工具实例初始化期间设置的参数很难跟踪，这阻碍了将它们正确分享到 Hub。无论如何，创建特定类的想法是你已经可以为任何需要硬编码的内容设置类属性（只需在 <code>class YourTool(Tool):</code> 行下直接设置 <code>your_variable=(...)</code>）。当然，你仍然可以通过将内容分配给 <code>self.your_variable</code> 在代码中的任何地方创建类属性。</li>',ze,A,Vt='一旦你的工具被推送到 Hub，你就可以查看它。<a href="https://huggingface.co/spaces/m-ric/hf-model-downloads" rel="nofollow">这里</a> 是我推送的 <code>model_downloads_tool</code>。它有一个漂亮的 gradio 界面。',Ne,V,St='在深入工具文件时，你可以发现所有工具的逻辑都在 <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads/blob/main/tool.py" rel="nofollow">tool.py</a> 下。这是你可以检查其他人分享的工具的地方。',qe,S,Lt=`然后你可以使用 <a href="/docs/smolagents/main/zh/reference/tools#smolagents.load_tool">load_tool()</a> 加载工具或使用 <a href="/docs/smolagents/main/zh/reference/tools#smolagents.Tool.from_hub">from_hub()</a> 创建它，并将其传递给 agent 中的 <code>tools</code> 参数。
由于运行工具意味着运行自定义代码，你需要确保你信任该仓库，因此我们需要传递 <code>trust_remote_code=True</code> 来从 Hub 加载工具。`,Fe,L,Ye,z,Xe,N,zt='你可以使用 <a href="/docs/smolagents/main/zh/reference/tools#smolagents.Tool.from_space">Tool.from_space()</a> 方法直接从 Hub 导入一个 Space 作为工具！',Pe,q,Nt='你只需要提供 Hub 上 Space 的 id、它的名称和一个帮助你的 agent 理解工具功能的描述。在底层，这将使用 <a href="https://pypi.org/project/gradio-client/" rel="nofollow"><code>gradio-client</code></a> 库来调用 Space。',De,F,qt='例如，让我们从 Hub 导入 <a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev</a> Space 并使用它生成一张图片。',Ke,Y,Oe,X,Ft="瞧，这是你的图片！🏖️",et,he,Yt,tt,P,Xt="然后你可以像使用任何其他工具一样使用这个工具。例如，让我们改进提示 <code>A rabbit wearing a space suit</code> 并生成它的图片。",lt,D,st,K,nt,fe,Pt,ot,O,Dt="这得有多酷？🤩",at,ee,it,te,Kt=`我们喜欢 Langchain，并认为它有一套非常吸引人的工具。
要从 LangChain 导入工具，请使用 <code>from_langchain()</code> 方法。`,pt,le,Ot=`以下是如何使用它来重现介绍中的搜索结果，使用 LangChain 的 web 搜索工具。
这个工具需要 <code>pip install langchain google-search-results -q</code> 才能正常工作。`,Mt,se,mt,ne,ut,oe,el="你可以通过添加或替换工具来管理 agent 的工具箱。",bt,ae,tl="让我们将 <code>model_download_tool</code> 添加到一个仅使用默认工具箱初始化的现有 agent 中。",dt,ie,rt,pe,ll="现在我们可以利用新工具：",ct,Me,ht,y,sl="<p>注意不要向 agent 添加太多工具：这可能会让较弱的 LLM 引擎不堪重负。</p>",ft,me,yt,ue,nl=`你可以通过使用 ToolCollection 对象来利用工具集合，使用你想要使用的集合的 slug。
然后将它们作为列表传递给 agent 初始化，并开始使用它们！`,Ut,be,Tt,de,ol="为了加快启动速度，工具仅在 agent 调用时加载。",gt,re,wt,Te,Jt;return U=new ce({props:{title:"工具",local:"工具",headingTag:"h1"}}),T=new cl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/zh/tools.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/zh/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/zh/tensorflow/tools.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/zh/tools.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/zh/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/zh/tensorflow/tools.ipynb"}]}}),J=new ce({props:{title:"什么是工具，如何构建一个工具？",local:"什么是工具如何构建一个工具",headingTag:"h3"}}),B=new c({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sJTBBJTBBY2xhc3MlMjBIRk1vZGVsRG93bmxvYWRzVG9vbChUb29sKSUzQSUwQSUyMCUyMCUyMCUyMG5hbWUlMjAlM0QlMjAlMjJtb2RlbF9kb3dubG9hZF9jb3VudGVyJTIyJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lMjAlM0QlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBUaGlzJTIwaXMlMjBhJTIwdG9vbCUyMHRoYXQlMjByZXR1cm5zJTIwdGhlJTIwbW9zdCUyMGRvd25sb2FkZWQlMjBtb2RlbCUyMG9mJTIwYSUyMGdpdmVuJTIwdGFzayUyMG9uJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIuJTBBJTIwJTIwJTIwJTIwSXQlMjByZXR1cm5zJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwY2hlY2twb2ludC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0YXNrJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIydGhlJTIwdGFzayUyMGNhdGVnb3J5JTIwKHN1Y2glMjBhcyUyMHRleHQtY2xhc3NpZmljYXRpb24lMkMlMjBkZXB0aC1lc3RpbWF0aW9uJTJDJTIwZXRjKSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTIwJTNEJTIwJTIyc3RyaW5nJTIyJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGFzayUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbGlzdF9tb2RlbHMlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMG5leHQoaXRlcihsaXN0X21vZGVscyhmaWx0ZXIlM0R0YXNrJTJDJTIwc29ydCUzRCUyMmRvd25sb2FkcyUyMiUyQyUyMGRpcmVjdGlvbiUzRC0xKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbW9kZWwuaWQlMEElMEFtb2RlbF9kb3dubG9hZHNfdG9vbCUyMCUzRCUyMEhGTW9kZWxEb3dubG9hZHNUb29sKCk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">HFModelDownloadsTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;model_download_counter&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This is a tool that returns the most downloaded model of a given task on the Hugging Face Hub.
    It returns the name of the checkpoint.&quot;&quot;&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;task&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the task category (such as text-classification, depth-estimation, etc)&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, task: <span class="hljs-built_in">str</span></span>):
        <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models

        model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=task, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
        <span class="hljs-keyword">return</span> model.<span class="hljs-built_in">id</span>

model_downloads_tool = HFModelDownloadsTool()`,wrap:!1}}),x=new ce({props:{title:"将你的工具分享到 Hub",local:"将你的工具分享到-hub",headingTag:"h3"}}),k=new c({props:{code:"bW9kZWxfZG93bmxvYWRzX3Rvb2wucHVzaF90b19odWIoJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRmhmLW1vZGVsLWRvd25sb2FkcyUyMiUyQyUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIp",highlighted:'model_downloads_tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>, token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)',wrap:!1}}),L=new c({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMEElMEFtb2RlbF9kb3dubG9hZF90b29sJTIwJTNEJTIwbG9hZF90b29sKCUwQSUyMCUyMCUyMCUyMCUyMiU3QnlvdXJfdXNlcm5hbWUlN0QlMkZoZi1tb2RlbC1kb3dubG9hZHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent

model_download_tool = load_tool(
    <span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)`,wrap:!1}}),z=new ce({props:{title:"将 Space 导入为工具",local:"将-space-导入为工具",headingTag:"h3"}}),Y=new c({props:{code:"aW1hZ2VfZ2VuZXJhdGlvbl90b29sJTIwJTNEJTIwVG9vbC5mcm9tX3NwYWNlKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLXNjaG5lbGwlMjIlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyaW1hZ2VfZ2VuZXJhdG9yJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJHZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBmcm9tJTIwYSUyMHByb21wdCUyMiUwQSklMEElMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2woJTIyQSUyMHN1bm55JTIwYmVhY2glMjIp",highlighted:`image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    name=<span class="hljs-string">&quot;image_generator&quot;</span>,
    description=<span class="hljs-string">&quot;Generate an image from a prompt&quot;</span>
)

image_generation_tool(<span class="hljs-string">&quot;A sunny beach&quot;</span>)`,wrap:!1}}),D=new c({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUJpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjJJbXByb3ZlJTIwdGhpcyUyMHByb21wdCUyQyUyMHRoZW4lMjBnZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBvZiUyMGl0LiUyMiUyQyUyMGFkZGl0aW9uYWxfYXJncyUzRCU3Qid1c2VyX3Byb21wdCclM0ElMjAnQSUyMHJhYmJpdCUyMHdlYXJpbmclMjBhJTIwc3BhY2UlMjBzdWl0JyU3RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

model = InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)
agent = CodeAgent(tools=[image_generation_tool], model=model)

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>, additional_args={<span class="hljs-string">&#x27;user_prompt&#x27;</span>: <span class="hljs-string">&#x27;A rabbit wearing a space suit&#x27;</span>}
)`,wrap:!1}}),K=new c({props:{code:"JTBBQWdlbnQlMjBpcyUyMGV4ZWN1dGluZyUyMHRoZSUyMGNvZGUlMjBiZWxvdyUzQQ==",highlighted:`=== Agent thoughts:
improved_prompt could be &quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;

Now that I have improved the prompt, I can use the image generator tool to generate an image based on this prompt.
&gt;&gt;&gt; Agent is executing the code below:
image = image_generator(prompt=&quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;)
final_answer(image)`,wrap:!1}}),ee=new ce({props:{title:"使用 LangChain 工具",local:"使用-langchain-工具",headingTag:"h3"}}),se=new c({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fbGFuZ2NoYWluKGxvYWRfdG9vbHMoJTVCJTIyc2VycGFwaSUyMiU1RCklNUIwJTVEKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCc2VhcmNoX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMjJIb3clMjBtYW55JTIwbW9yZSUyMGJsb2NrcyUyMChhbHNvJTIwZGVub3RlZCUyMGFzJTIwbGF5ZXJzKSUyMGFyZSUyMGluJTIwQkVSVCUyMGJhc2UlMjBlbmNvZGVyJTIwY29tcGFyZWQlMjB0byUyMHRoZSUyMGVuY29kZXIlMjBmcm9tJTIwdGhlJTIwYXJjaGl0ZWN0dXJlJTIwcHJvcG9zZWQlMjBpbiUyMEF0dGVudGlvbiUyMGlzJTIwQWxsJTIwWW91JTIwTmVlZCUzRiUyMik=",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = CodeAgent(tools=[search_tool], model=model)

agent.run(<span class="hljs-string">&quot;How many more blocks (also denoted as layers) are in BERT base encoder compared to the encoder from the architecture proposed in Attention is All You Need?&quot;</span>)`,wrap:!1}}),ne=new ce({props:{title:"管理你的 agent 工具箱",local:"管理你的-agent-工具箱",headingTag:"h3"}}),ie=new c({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIlNUQlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlKSUwQWFnZW50LnRvb2xzJTVCbW9kZWxfZG93bmxvYWRfdG9vbC5uYW1lJTVEJTIwJTNEJTIwbW9kZWxfZG93bmxvYWRfdG9vbA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel

model = InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)
agent.tools[model_download_tool.name] = model_download_tool`,wrap:!1}}),Me=new c({props:{code:"YWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwdGhhdCUyMGhhcyUyMHRoZSUyMG1vc3QlMjBkb3dubG9hZHMlMjBpbiUyMHRoZSUyMCd0ZXh0LXRvLXZpZGVvJyUyMHRhc2slMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwYnV0JTIwcmV2ZXJzZSUyMHRoZSUyMGxldHRlcnMlM0YlMjIlMEEp",highlighted:`agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the model that has the most downloads in the &#x27;text-to-video&#x27; task on the Hugging Face Hub but reverse the letters?&quot;</span>
)`,wrap:!1}}),me=new ce({props:{title:"使用工具集合",local:"使用工具集合",headingTag:"h3"}}),be=new c({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQWltYWdlX3Rvb2xfY29sbGVjdGlvbiUyMCUzRCUyMFRvb2xDb2xsZWN0aW9uLmZyb21faHViKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fc2x1ZyUzRCUyMmh1Z2dpbmdmYWNlLXRvb2xzJTJGZGlmZnVzaW9uLXRvb2xzLTY2MzBiYjE5YTk0MmMyMzA2YTJjZGI2ZiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIlMEEpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqaW1hZ2VfdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMEFhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzLiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

image_tool_collection = ToolCollection.from_hub(
    collection_slug=<span class="hljs-string">&quot;huggingface-tools/diffusion-tools-6630bb19a942c2306a2cdb6f&quot;</span>,
    token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>
)
agent = CodeAgent(tools=[*image_tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)

agent.run(<span class="hljs-string">&quot;Please draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),re=new hl({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/zh/tutorials/tools.md"}}),{c(){h=a("meta"),ge=n(),Ue=a("p"),we=n(),M(U.$$.fragment),Je=n(),M(T.$$.fragment),je=n(),g=a("p"),g.textContent=Ct,Ce=n(),f=a("blockquote"),f.innerHTML=vt,ve=n(),w=a("ul"),w.innerHTML=_t,_e=n(),M(J.$$.fragment),Ie=n(),j=a("p"),j.textContent=It,Be=n(),C=a("p"),C.textContent=Bt,$e=n(),v=a("p"),v.textContent=$t,Ze=n(),_=a("p"),_.textContent=Zt,Ge=n(),I=a("p"),I.textContent=Gt,He=n(),M(B.$$.fragment),Ee=n(),$=a("p"),$.innerHTML=Ht,xe=n(),Z=a("ul"),Z.innerHTML=Et,We=n(),G=a("p"),G.textContent=xt,ke=n(),H=a("p"),H.innerHTML=Wt,Re=n(),E=a("p"),E.innerHTML=kt,Qe=n(),M(x.$$.fragment),Ae=n(),W=a("p"),W.innerHTML=Rt,Ve=n(),M(k.$$.fragment),Se=n(),R=a("p"),R.textContent=Qt,Le=n(),Q=a("ul"),Q.innerHTML=At,ze=n(),A=a("p"),A.innerHTML=Vt,Ne=n(),V=a("p"),V.innerHTML=St,qe=n(),S=a("p"),S.innerHTML=Lt,Fe=n(),M(L.$$.fragment),Ye=n(),M(z.$$.fragment),Xe=n(),N=a("p"),N.innerHTML=zt,Pe=n(),q=a("p"),q.innerHTML=Nt,De=n(),F=a("p"),F.innerHTML=qt,Ke=n(),M(Y.$$.fragment),Oe=n(),X=a("p"),X.textContent=Ft,et=n(),he=a("img"),tt=n(),P=a("p"),P.innerHTML=Xt,lt=n(),M(D.$$.fragment),st=n(),M(K.$$.fragment),nt=n(),fe=a("img"),ot=n(),O=a("p"),O.textContent=Dt,at=n(),M(ee.$$.fragment),it=n(),te=a("p"),te.innerHTML=Kt,pt=n(),le=a("p"),le.innerHTML=Ot,Mt=n(),M(se.$$.fragment),mt=n(),M(ne.$$.fragment),ut=n(),oe=a("p"),oe.textContent=el,bt=n(),ae=a("p"),ae.innerHTML=tl,dt=n(),M(ie.$$.fragment),rt=n(),pe=a("p"),pe.textContent=ll,ct=n(),M(Me.$$.fragment),ht=n(),y=a("blockquote"),y.innerHTML=sl,ft=n(),M(me.$$.fragment),yt=n(),ue=a("p"),ue.textContent=nl,Ut=n(),M(be.$$.fragment),Tt=n(),de=a("p"),de.textContent=ol,gt=n(),M(re.$$.fragment),wt=n(),Te=a("p"),this.h()},l(e){const t=dl("svelte-u9bgzb",document.head);h=i(t,"META",{name:!0,content:!0}),t.forEach(l),ge=o(e),Ue=i(e,"P",{}),il(Ue).forEach(l),we=o(e),m(U.$$.fragment,e),Je=o(e),m(T.$$.fragment,e),je=o(e),g=i(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-143y1x4"&&(g.textContent=Ct),Ce=o(e),f=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(f)!=="svelte-13sctmd"&&(f.innerHTML=vt),ve=o(e),w=i(e,"UL",{"data-svelte-h":!0}),p(w)!=="svelte-1ob3z02"&&(w.innerHTML=_t),_e=o(e),m(J.$$.fragment,e),Ie=o(e),j=i(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-tzzqok"&&(j.textContent=It),Be=o(e),C=i(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-mmees0"&&(C.textContent=Bt),$e=o(e),v=i(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-8tjsnw"&&(v.textContent=$t),Ze=o(e),_=i(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1marvpp"&&(_.textContent=Zt),Ge=o(e),I=i(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1ezxif7"&&(I.textContent=Gt),He=o(e),m(B.$$.fragment,e),Ee=o(e),$=i(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-mjq2a7"&&($.innerHTML=Ht),xe=o(e),Z=i(e,"UL",{"data-svelte-h":!0}),p(Z)!=="svelte-114q23d"&&(Z.innerHTML=Et),We=o(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-150sce8"&&(G.textContent=xt),ke=o(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-19qr9pn"&&(H.innerHTML=Wt),Re=o(e),E=i(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1u11zff"&&(E.innerHTML=kt),Qe=o(e),m(x.$$.fragment,e),Ae=o(e),W=i(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1t9emcf"&&(W.innerHTML=Rt),Ve=o(e),m(k.$$.fragment,e),Se=o(e),R=i(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-f7adnf"&&(R.textContent=Qt),Le=o(e),Q=i(e,"UL",{"data-svelte-h":!0}),p(Q)!=="svelte-zpe3on"&&(Q.innerHTML=At),ze=o(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-ek1m24"&&(A.innerHTML=Vt),Ne=o(e),V=i(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-15ghlir"&&(V.innerHTML=St),qe=o(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-r1pjtl"&&(S.innerHTML=Lt),Fe=o(e),m(L.$$.fragment,e),Ye=o(e),m(z.$$.fragment,e),Xe=o(e),N=i(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-rbz41a"&&(N.innerHTML=zt),Pe=o(e),q=i(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-4qew2a"&&(q.innerHTML=Nt),De=o(e),F=i(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1tvwij"&&(F.innerHTML=qt),Ke=o(e),m(Y.$$.fragment,e),Oe=o(e),X=i(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1ubl722"&&(X.textContent=Ft),et=o(e),he=i(e,"IMG",{src:!0}),tt=o(e),P=i(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-ecwb7g"&&(P.innerHTML=Xt),lt=o(e),m(D.$$.fragment,e),st=o(e),m(K.$$.fragment,e),nt=o(e),fe=i(e,"IMG",{src:!0}),ot=o(e),O=i(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-frli2c"&&(O.textContent=Dt),at=o(e),m(ee.$$.fragment,e),it=o(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-m1ii5p"&&(te.innerHTML=Kt),pt=o(e),le=i(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-17sjd0f"&&(le.innerHTML=Ot),Mt=o(e),m(se.$$.fragment,e),mt=o(e),m(ne.$$.fragment,e),ut=o(e),oe=i(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-p6yc33"&&(oe.textContent=el),bt=o(e),ae=i(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-u6gh5x"&&(ae.innerHTML=tl),dt=o(e),m(ie.$$.fragment,e),rt=o(e),pe=i(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1dm2bi"&&(pe.textContent=ll),ct=o(e),m(Me.$$.fragment,e),ht=o(e),y=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(y)!=="svelte-q94bc0"&&(y.innerHTML=sl),ft=o(e),m(me.$$.fragment,e),yt=o(e),ue=i(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-17n2ifn"&&(ue.textContent=nl),Ut=o(e),m(be.$$.fragment,e),Tt=o(e),de=i(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-nvusln"&&(de.textContent=ol),gt=o(e),m(re.$$.fragment,e),wt=o(e),Te=i(e,"P",{}),il(Te).forEach(l),this.h()},h(){ye(h,"name","hf:doc:metadata"),ye(h,"content",yl),ye(f,"class","tip"),al(he.src,Yt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/sunny_beach.webp")||ye(he,"src",Yt),al(fe.src,Pt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit_spacesuit_flux.webp")||ye(fe,"src",Pt),ye(y,"class","tip")},m(e,t){rl(document.head,h),s(e,ge,t),s(e,Ue,t),s(e,we,t),u(U,e,t),s(e,Je,t),u(T,e,t),s(e,je,t),s(e,g,t),s(e,Ce,t),s(e,f,t),s(e,ve,t),s(e,w,t),s(e,_e,t),u(J,e,t),s(e,Ie,t),s(e,j,t),s(e,Be,t),s(e,C,t),s(e,$e,t),s(e,v,t),s(e,Ze,t),s(e,_,t),s(e,Ge,t),s(e,I,t),s(e,He,t),u(B,e,t),s(e,Ee,t),s(e,$,t),s(e,xe,t),s(e,Z,t),s(e,We,t),s(e,G,t),s(e,ke,t),s(e,H,t),s(e,Re,t),s(e,E,t),s(e,Qe,t),u(x,e,t),s(e,Ae,t),s(e,W,t),s(e,Ve,t),u(k,e,t),s(e,Se,t),s(e,R,t),s(e,Le,t),s(e,Q,t),s(e,ze,t),s(e,A,t),s(e,Ne,t),s(e,V,t),s(e,qe,t),s(e,S,t),s(e,Fe,t),u(L,e,t),s(e,Ye,t),u(z,e,t),s(e,Xe,t),s(e,N,t),s(e,Pe,t),s(e,q,t),s(e,De,t),s(e,F,t),s(e,Ke,t),u(Y,e,t),s(e,Oe,t),s(e,X,t),s(e,et,t),s(e,he,t),s(e,tt,t),s(e,P,t),s(e,lt,t),u(D,e,t),s(e,st,t),u(K,e,t),s(e,nt,t),s(e,fe,t),s(e,ot,t),s(e,O,t),s(e,at,t),u(ee,e,t),s(e,it,t),s(e,te,t),s(e,pt,t),s(e,le,t),s(e,Mt,t),u(se,e,t),s(e,mt,t),u(ne,e,t),s(e,ut,t),s(e,oe,t),s(e,bt,t),s(e,ae,t),s(e,dt,t),u(ie,e,t),s(e,rt,t),s(e,pe,t),s(e,ct,t),u(Me,e,t),s(e,ht,t),s(e,y,t),s(e,ft,t),u(me,e,t),s(e,yt,t),s(e,ue,t),s(e,Ut,t),u(be,e,t),s(e,Tt,t),s(e,de,t),s(e,gt,t),u(re,e,t),s(e,wt,t),s(e,Te,t),Jt=!0},p:Ml,i(e){Jt||(b(U.$$.fragment,e),b(T.$$.fragment,e),b(J.$$.fragment,e),b(B.$$.fragment,e),b(x.$$.fragment,e),b(k.$$.fragment,e),b(L.$$.fragment,e),b(z.$$.fragment,e),b(Y.$$.fragment,e),b(D.$$.fragment,e),b(K.$$.fragment,e),b(ee.$$.fragment,e),b(se.$$.fragment,e),b(ne.$$.fragment,e),b(ie.$$.fragment,e),b(Me.$$.fragment,e),b(me.$$.fragment,e),b(be.$$.fragment,e),b(re.$$.fragment,e),Jt=!0)},o(e){d(U.$$.fragment,e),d(T.$$.fragment,e),d(J.$$.fragment,e),d(B.$$.fragment,e),d(x.$$.fragment,e),d(k.$$.fragment,e),d(L.$$.fragment,e),d(z.$$.fragment,e),d(Y.$$.fragment,e),d(D.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),d(se.$$.fragment,e),d(ne.$$.fragment,e),d(ie.$$.fragment,e),d(Me.$$.fragment,e),d(me.$$.fragment,e),d(be.$$.fragment,e),d(re.$$.fragment,e),Jt=!1},d(e){e&&(l(ge),l(Ue),l(we),l(Je),l(je),l(g),l(Ce),l(f),l(ve),l(w),l(_e),l(Ie),l(j),l(Be),l(C),l($e),l(v),l(Ze),l(_),l(Ge),l(I),l(He),l(Ee),l($),l(xe),l(Z),l(We),l(G),l(ke),l(H),l(Re),l(E),l(Qe),l(Ae),l(W),l(Ve),l(Se),l(R),l(Le),l(Q),l(ze),l(A),l(Ne),l(V),l(qe),l(S),l(Fe),l(Ye),l(Xe),l(N),l(Pe),l(q),l(De),l(F),l(Ke),l(Oe),l(X),l(et),l(he),l(tt),l(P),l(lt),l(st),l(nt),l(fe),l(ot),l(O),l(at),l(it),l(te),l(pt),l(le),l(Mt),l(mt),l(ut),l(oe),l(bt),l(ae),l(dt),l(rt),l(pe),l(ct),l(ht),l(y),l(ft),l(yt),l(ue),l(Ut),l(Tt),l(de),l(gt),l(wt),l(Te)),l(h),r(U,e),r(T,e),r(J,e),r(B,e),r(x,e),r(k,e),r(L,e),r(z,e),r(Y,e),r(D,e),r(K,e),r(ee,e),r(se,e),r(ne,e),r(ie,e),r(Me,e),r(me,e),r(be,e),r(re,e)}}}const yl='{"title":"工具","local":"工具","sections":[{"title":"什么是工具，如何构建一个工具？","local":"什么是工具如何构建一个工具","sections":[],"depth":3},{"title":"将你的工具分享到 Hub","local":"将你的工具分享到-hub","sections":[],"depth":3},{"title":"将 Space 导入为工具","local":"将-space-导入为工具","sections":[],"depth":3},{"title":"使用 LangChain 工具","local":"使用-langchain-工具","sections":[],"depth":3},{"title":"管理你的 agent 工具箱","local":"管理你的-agent-工具箱","sections":[],"depth":3},{"title":"使用工具集合","local":"使用工具集合","sections":[],"depth":3}],"depth":1}';function Ul(jt){return ml(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Cl extends ul{constructor(h){super(),bl(this,h,Ul,fl,pl,{})}}export{Cl as component};
