import{s as Ta,n as ja,o as xa}from"../chunks/scheduler.cd324960.js";import{S as va,i as Ua,e as i,s as l,c as r,h as Ja,a as o,d as s,b as n,f as wa,g as h,j as p,k as De,l as Ca,m as a,n as c,t as d,o as u,p as m}from"../chunks/index.d5c3adcc.js";import{C as $a,H as g,E as ka}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.5025912f.js";import{C as f}from"../chunks/CodeBlock.12aa859f.js";function Ia(js){let y,Fe,Ee,Be,j,Pe,x,Ve,v,xs=`The Hugging Face Hub is home to over 500 pre-trained models for audio classification. In this section, we’ll go through
some of the most common audio classification tasks and suggest appropriate pre-trained models for each. Using the <code>pipeline()</code>
class, switching between models and tasks is straightforward - once you know how to use <code>pipeline()</code> for one model, you’ll
be able to use it for any model on the Hub no code changes! This makes experimenting with the <code>pipeline()</code> class extremely
fast, allowing you to quickly select the best pre-trained model for your needs.`,Xe,U,vs=`Before we jump into the various audio classification problems, let’s quickly recap the transformer architectures typically
used. The standard audio classification architecture is motivated by the nature of the task; we want to transform a sequence
of audio inputs (i.e. our input audio array) into a single class label prediction. Encoder-only models first map the input
audio sequence into a sequence of hidden-state representations by passing the inputs through a transformer block. The
sequence of hidden-state representations is then mapped to a class label output by taking the mean over the hidden-states,
and passing the resulting vector through a linear classification layer. Hence, there is a preference for <em>encoder-only</em>
models for audio classification.`,Oe,J,Us=`Decoder-only models introduce unnecessary complexity to the task, since they assume that the outputs can also be a <em>sequence</em>
of predictions (rather than a single class label prediction), and so generate multiple outputs. Therefore, they have slower
inference speed and tend not to be used. Encoder-decoder models are largely omitted for the same reason. These architecture
choices are analogous to those in NLP, where encoder-only models such as <a href="https://huggingface.co/blog/bert-101" rel="nofollow">BERT</a>
are favoured for sequence classification tasks, and decoder-only models such as GPT reserved for sequence generation tasks.`,Ke,C,Js=`Now that we’ve recapped the standard transformer architecture for audio classification, let’s jump into the different
subsets of audio classification and cover the most popular models!`,et,$,tt,k,Cs=`At the time of writing, the latest updates required for audio classification pipeline are only on the <code>main</code> version of
the 🤗 Transformers repository, rather than the latest PyPi version. To make sure we have these updates locally, we’ll
install Transformers from the <code>main</code> branch with the following command:`,st,I,at,N,lt,W,$s=`Keyword spotting (KWS) is the task of identifying a keyword in a spoken utterance. The set of possible keywords forms the
set of predicted class labels. Hence, to use a pre-trained keyword spotting model, you should ensure that your keywords
match those that the model was pre-trained on. Below, we’ll introduce two datasets and models for keyword spotting.`,nt,L,it,H,ks=`Let’s go ahead and use the same <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MINDS-14</a> dataset that you have explored
in the previous unit. If you recall, MINDS-14 contains recordings of people asking an e-banking system questions in several
languages and dialects, and has the <code>intent_class</code> for each recording. We can classify the recordings by intent of the call.`,ot,_,pt,q,Is=`We’ll load the checkpoint <a href="https://huggingface.co/anton-l/xtreme_s_xlsr_300m_minds14" rel="nofollow"><code>&quot;anton-l/xtreme_s_xlsr_300m_minds14&quot;</code></a>,
which is an XLS-R model fine-tuned on MINDS-14 for approximately 50 epochs. It achieves 90% accuracy over all languages
from MINDS-14 on the evaluation set.`,rt,Z,ht,z,Ns="Finally, we can pass a sample to the classification pipeline to make a prediction:",ct,Q,dt,S,Ws="<strong>Output:</strong>",ut,Y,mt,A,Ls=`Great! We’ve identified that the intent of the call was paying a bill, with probability 96%. You can imagine this kind of
keyword spotting system being used as the first stage of an automated call centre, where we want to categorise incoming
customer calls based on their query and offer them contextualised support accordingly.`,ft,G,yt,D,Hs=`Speech Commands is a dataset of spoken words designed to evaluate audio classification models on simple command words.
The dataset consists of 15 classes of keywords, a class for silence, and an unknown class to include the false positive.
The 15 keywords are single words that would typically be used in on-device settings to control basic tasks or launch
other processes.`,gt,E,_s=`A similar model is running continuously on your mobile phone. Here, instead of having single command words, we have
‘wake words’ specific to your device, such as “Hey Google” or “Hey Siri”. When the audio classification model detects
these wake words, it triggers your phone to start listening to the microphone and transcribe your speech using a speech
recognition model.`,bt,R,qs=`The audio classification model is much smaller and lighter than the speech recognition model, often only several millions
of parameters compared to several hundred millions for speech recognition. Thus, it can be run continuously on your device
without draining your battery! Only when the wake word is detected is the larger speech recognition model launched, and
afterwards it is shut down again. We’ll cover transformer models for speech recognition in the next Unit, so by the end
of the course you should have the tools you need to build your own voice activated assistant!`,Mt,F,Zs=`As with any dataset on the Hugging Face Hub, we can get a feel for the kind of audio data it has present without downloading
or committing it memory. After heading to the <a href="https://huggingface.co/datasets/speech_commands" rel="nofollow">Speech Commands’ dataset card</a>
on the Hub, we can use the Dataset Viewer to scroll through the first 100 samples of the dataset, listening to the audio
files and checking any other metadata information:`,wt,b,zs='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/speech_commands.png" alt="Diagram of datasets viewer."/>',Tt,B,Qs=`The Dataset Preview is a brilliant way of experiencing audio datasets before committing to using them. You can pick any
dataset on the Hub, scroll through the samples and listen to the audio for the different subsets and splits, gauging whether
it’s the right dataset for your needs. Once you’ve selected a dataset, it’s trivial to load the data so that you can start
using it.`,jt,P,Ss="Let’s do exactly that and load a sample of the Speech Commands dataset using streaming mode:",xt,V,vt,X,Ys=`We’ll load an official <a href="https://huggingface.co/docs/transformers/model_doc/audio-spectrogram-transformer" rel="nofollow">Audio Spectrogram Transformer</a>
checkpoint fine-tuned on the Speech Commands dataset, under the namespace <a href="https://huggingface.co/MIT/ast-finetuned-speech-commands-v2" rel="nofollow"><code>&quot;MIT/ast-finetuned-speech-commands-v2&quot;</code></a>:`,Ut,O,Jt,K,As="<strong>Output:</strong>",Ct,ee,$t,te,Gs=`Cool! Looks like the example contains the word “backward” with high probability. We can take a listen to the sample
and verify this is correct:`,kt,se,It,ae,Ds=`Now, you might be wondering how we’ve selected these pre-trained models to show you in these audio classification examples.
The truth is, finding pre-trained models for your dataset and task is very straightforward! The first thing we need to do
is head to the Hugging Face Hub and click on the “Models” tab: <a href="https://huggingface.co/models" rel="nofollow">https://huggingface.co/models</a>`,Nt,le,Es="This is going to bring up all the models on the Hugging Face Hub, sorted by downloads in the past 30 days:",Wt,M,Rs='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/all_models.png"/>',Lt,ne,Fs=`You’ll notice on the left-hand side that we have a selection of tabs that we can select to filter models by task, library,
dataset, etc. Scroll down and select the task “Audio Classification” from the list of audio tasks:`,Ht,w,Bs='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/by_audio_classification.png"/>',_t,ie,Ps=`We’re now presented with the sub-set of 500+ audio classification models on the Hub. To further refine this selection, we
can filter models by dataset. Click on the tab “Datasets”, and in the search box type “speech_commands”. As you begin typing,
you’ll see the selection for <code>speech_commands</code> appear underneath the search tab. You can click this button to filter all
audio classification models to those fine-tuned on the Speech Commands dataset:`,qt,T,Vs='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/by_speech_commands.png"/>',Zt,oe,Xs=`Great! We see that we have 6 pre-trained models available to us for this specific dataset and task. You’ll recognise the
first of these models as the Audio Spectrogram Transformer checkpoint that we used in the previous example. This process
of filtering models on the Hub is exactly how we went about selecting the checkpoint to show you!`,zt,pe,Qt,re,Os=`Language identification (LID) is the task of identifying the language spoken in an audio sample from a list of candidate
languages. LID can form an important part in many speech pipelines. For example, given an audio sample in an unknown language,
an LID model can be used to categorise the language(s) spoken in the audio sample, and then select an appropriate speech
recognition model trained on that language to transcribe the audio.`,St,he,Yt,ce,Ks=`FLEURS (Few-shot Learning Evaluation of Universal Representations of Speech) is a dataset for evaluating speech recognition
systems in 102 languages, including many that are classified as ‘low-resource’. Take a look at the FLEURS dataset
card on the Hub and explore the different languages that are present: <a href="https://huggingface.co/datasets/google/fleurs" rel="nofollow">google/fleurs</a>.
Can you find your native tongue here? If not, what’s the most closely related language?`,At,de,ea="Let’s load up a sample from the validation split of the FLEURS dataset using streaming mode:",Gt,ue,Dt,me,ta=`Great! Now we can load our audio classification model. For this, we’ll use a version of <a href="https://arxiv.org/pdf/2212.04356.pdf" rel="nofollow">Whisper</a>
fine-tuned on the FLEURS dataset, which is currently the most performant LID model on the Hub:`,Et,fe,Rt,ye,sa="We can then pass the audio through our classifier and generate a prediction:",Ft,ge,Bt,be,aa="<strong>Output:</strong>",Pt,Me,Vt,we,la=`We can see that the model predicted the audio was in Afrikaans with extremely high probability (near 1). The FLEURS dataset
contains audio data from a wide range of languages - we can see that possible class labels include Northern-Sotho, Icelandic,
Danish and Cantonese Chinese amongst others. You can find the full list of languages on the dataset card here: <a href="https://huggingface.co/datasets/google/fleurs" rel="nofollow">google/fleurs</a>.`,Xt,Te,na="Over to you! What other checkpoints can you find for FLEURS LID on the Hub? What transformer models are they using under-the-hood?",Ot,je,Kt,xe,ia=`In the traditional paradigm for audio classification, the model predicts a class label from a <em>pre-defined</em> set of
possible classes. This poses a barrier to using pre-trained models for audio classification, since the label set of the
pre-trained model must match that of the downstream task. For the previous example of LID, the model must predict one of
the 102 langauge classes on which it was trained. If the downstream task actually requires 110 languages, the model would
not be able to predict 8 of the 110 languages, and so would require re-training to achieve full coverage. This limits the
effectiveness of transfer learning for audio classification tasks.`,es,ve,oa=`Zero-shot audio classification is a method for taking a pre-trained audio classification model trained on a set of labelled
examples and enabling it to be able to classify new examples from previously unseen classes. Let’s take a look at how we
can achieve this!`,ts,Ue,pa=`Currently, 🤗 Transformers supports one kind of model for zero-shot audio classification: the <a href="https://huggingface.co/docs/transformers/model_doc/clap" rel="nofollow">CLAP model</a>.
CLAP is a transformer-based model that takes both audio and text as inputs, and computes the <em>similarity</em> between the two.
If we pass a text input that strongly correlates with an audio input, we’ll get a high similarity score. Conversely, passing
a text input that is completely unrelated to the audio input will return a low similarity.`,ss,Je,ra=`We can use this similarity prediction for zero-shot audio classification by passing one audio input to the model and
multiple candidate labels. The model will return a similarity score for each of the candidate labels, and we can pick the
one that has the highest score as our prediction.`,as,Ce,ha=`Let’s take an example where we use one audio input from the <a href="https://huggingface.co/datasets/ashraq/esc50" rel="nofollow">Environmental Speech Challenge (ESC)</a>
dataset:`,ls,$e,ns,ke,ca=`We then define our candidate labels, which form the set of possible classification labels. The model will return a
classification probability for each of the labels we define. This means we need to know <em>a-priori</em> the set of possible
labels in our classification problem, such that the correct label is contained within the set and is thus assigned a
valid probability score. Note that we can either pass the full set of labels to the model, or a hand-selected subset
that we believe contains the correct label. Passing the full set of labels is going to be more exhaustive, but comes
at the expense of lower classification accuracy since the classification space is larger (provided the correct label is
our chosen subset of labels):`,is,Ie,os,Ne,da="We can run both through the model to find the candidate label that is <em>most similar</em> to the audio input:",ps,We,rs,Le,ua="<strong>Output:</strong>",hs,He,cs,_e,ma=`Alright! The model seems pretty confident we have the sound of a dog - it predicts it with 99.96% probability, so we’ll
take that as our prediction. Let’s confirm whether we were right by listening to the audio sample (don’t turn up your
volume too high or else you might get a jump!):`,ds,qe,us,Ze,fa=`Perfect! We have the sound of a dog barking 🐕, which aligns with the model’s prediction. Have a play with different audio
samples and different candidate labels - can you define a set of labels that give good generalisation across the ESC
dataset? Hint: think about where you could find information on the possible sounds in ESC and construct your labels accordingly!`,ms,ze,ya=`You might be wondering why we don’t use the zero-shot audio classification pipeline for <strong>all</strong> audio classification tasks?
It seems as though we can make predictions for any audio classification problem by defining appropriate class labels <em>a-priori</em>,
thus bypassing the constraint that our classification task needs to match the labels that the model was pre-trained on.
This comes down to the nature of the CLAP model used in the zero-shot pipeline: CLAP is pre-trained on <em>generic</em> audio
classification data, similar to the environmental sounds in the ESC dataset, rather than specifically speech data, like
we had in the LID task. If you gave it speech in English and speech in Spanish, CLAP would know that both examples were
speech data 🗣️ But it wouldn’t be able to differentiate between the languages in the same way a dedicated LID model is
able to.`,fs,Qe,ys,Se,ga=`We’ve covered a number of different audio classification tasks and presented the most relevant datasets and models that
you can download from the Hugging Face Hub and use in just several lines of code using the <code>pipeline()</code> class. These tasks
included keyword spotting, language identification and zero-shot audio classification.`,gs,Ye,ba=`But what if we want to do something <strong>new</strong>? We’ve worked extensively on speech processing tasks, but this is only one
aspect of audio classification. Another popular field of audio processing involves <strong>music</strong>. While music has inherently
different features to speech, many of the same principles that we’ve learnt about already can be applied to music.`,bs,Ae,Ma=`In the following section, we’ll go through a step-by-step guide on how you can fine-tune a transformer model with 🤗
Transformers on the task of music classification. By the end of it, you’ll have a fine-tuned checkpoint that you can plug
into the <code>pipeline()</code> class, enabling you to classify songs in exactly the same way that we’ve classified speech here!`,Ms,Ge,ws,Re,Ts;return j=new $a({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),x=new g({props:{title:"Pre-trained models and datasets for audio classification",local:"pre-trained-models-and-datasets-for-audio-classification",headingTag:"h1"}}),$=new g({props:{title:"🤗 Transformers Installation",local:"-transformers-installation",headingTag:"h2"}}),I=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJz",highlighted:'pip install git+https:<span class="hljs-regexp">//gi</span>thub.com<span class="hljs-regexp">/huggingface/</span>transformers',wrap:!1}}),N=new g({props:{title:"Keyword Spotting",local:"keyword-spotting",headingTag:"h2"}}),L=new g({props:{title:"Minds-14",local:"minds-14",headingTag:"h3"}}),_=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBbWluZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyUG9seUFJJTJGbWluZHMxNCUyMiUyQyUyMG5hbWUlM0QlMjJlbi1BVSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-AU&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),Z=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJhbnRvbi1sJTJGeHRyZW1lX3NfeGxzcl8zMDBtX21pbmRzMTQlMjIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(
    <span class="hljs-string">&quot;audio-classification&quot;</span>,
    model=<span class="hljs-string">&quot;anton-l/xtreme_s_xlsr_300m_minds14&quot;</span>,
)`,wrap:!1}}),Q=new f({props:{code:"Y2xhc3NpZmllcihtaW5kcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCk=",highlighted:'classifier(minds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>])',wrap:!1}}),Y=new f({props:{code:"JTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjk2MzE1MjUyNzgwOTE0MzElMkMlMjAlMjJsYWJlbCUyMiUzQSUyMCUyMnBheV9iaWxsJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjAyODE5Njk4MzAzOTM3OTEyJTJDJTIwJTIybGFiZWwlMjIlM0ElMjAlMjJmcmVlemUlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJzY29yZSUyMiUzQSUyMDAuMDAzMjc4NzQ5Mjk2NDQxNjc0MiUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwJTIyY2FyZF9pc3N1ZXMlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJzY29yZSUyMiUzQSUyMDAuMDAxOTQxNDQ0NTg1MDk5ODE2MyUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwJTIyYWJyb2FkJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjAwMDgzNzg2OTM2MDExMTY1MzglMkMlMjAlMjJsYWJlbCUyMiUzQSUyMCUyMmhpZ2hfdmFsdWVfcGF5bWVudCUyMiU3RCUyQyUwQSU1RA==",highlighted:`[
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.9631525278091431</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;pay_bill&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.02819698303937912</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;freeze&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0032787492964416742</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;card_issues&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0019414445850998163</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;abroad&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0008378693601116538</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;high_value_payment&quot;</span>},
]`,wrap:!1}}),G=new g({props:{title:"Speech Commands",local:"speech-commands",headingTag:"h3"}}),V=new f({props:{code:"c3BlZWNoX2NvbW1hbmRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUwQSUyMCUyMCUyMCUyMCUyMnNwZWVjaF9jb21tYW5kcyUyMiUyQyUyMCUyMnYwLjAyJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSUwQSklMEFzYW1wbGUlMjAlM0QlMjBuZXh0KGl0ZXIoc3BlZWNoX2NvbW1hbmRzKSk=",highlighted:`speech_commands = load_dataset(
    <span class="hljs-string">&quot;speech_commands&quot;</span>, <span class="hljs-string">&quot;v0.02&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>
)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(speech_commands))`,wrap:!1}}),O=new f({props:{code:"Y2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJNSVQlMkZhc3QtZmluZXR1bmVkLXNwZWVjaC1jb21tYW5kcy12MiUyMiUwQSklMEFjbGFzc2lmaWVyKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVELmNvcHkoKSk=",highlighted:`classifier = pipeline(
    <span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;MIT/ast-finetuned-speech-commands-v2&quot;</span>
)
classifier(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy())`,wrap:!1}}),ee=new f({props:{code:"JTVCJTdCJ3Njb3JlJyUzQSUyMDAuOTk5OTg5MjcxMTYzOTQwNCUyQyUyMCdsYWJlbCclM0ElMjAnYmFja3dhcmQnJTdEJTJDJTBBJTIwJTdCJ3Njb3JlJyUzQSUyMDEuNzUwNDg4ODc3NDA1NTg3MWUtMDYlMkMlMjAnbGFiZWwnJTNBJTIwJ2hhcHB5JyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjA2LjcwMzA0MDE4NTEyOTc5NGUtMDclMkMlMjAnbGFiZWwnJTNBJTIwJ2ZvbGxvdyclN0QlMkMlMEElMjAlN0Inc2NvcmUnJTNBJTIwNS44MDU4ODQ0ODQyODg5ODFlLTA3JTJDJTIwJ2xhYmVsJyUzQSUyMCdzdG9wJyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjA1LjYxNDU0NjY5NDIzMjU1OGUtMDclMkMlMjAnbGFiZWwnJTNBJTIwJ3VwJyU3RCU1RA==",highlighted:`[{<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">0.9999892711639404</span>, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;backward</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">1.7504888774055871</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;happy</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">6.703040185129794</span>e-07, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;follow</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">5.805884484288981</span>e-07, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;stop</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">5.614546694232558</span>e-07, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;up</span>&#x27;}]`,wrap:!1}}),se=new f({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8oc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJhdGUlM0RzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQp",highlighted:`from <span class="hljs-module-access"><span class="hljs-module"><span class="hljs-identifier">IPython</span>.</span></span>display import Audio

<span class="hljs-constructor">Audio(<span class="hljs-params">sample</span>[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], <span class="hljs-params">rate</span>=<span class="hljs-params">sample</span>[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])</span>`,wrap:!1}}),pe=new g({props:{title:"Language Identification",local:"language-identification",headingTag:"h2"}}),he=new g({props:{title:"FLEURS",local:"fleurs",headingTag:"h3"}}),ue=new f({props:{code:"ZmxldXJzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmdvb2dsZSUyRmZsZXVycyUyMiUyQyUyMCUyMmFsbCUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUpJTBBc2FtcGxlJTIwJTNEJTIwbmV4dChpdGVyKGZsZXVycykp",highlighted:`fleurs = load_dataset(<span class="hljs-string">&quot;google/fleurs&quot;</span>, <span class="hljs-string">&quot;all&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(fleurs))`,wrap:!1}}),fe=new f({props:{code:"Y2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJzYW5jaGl0LWdhbmRoaSUyRndoaXNwZXItbWVkaXVtLWZsZXVycy1sYW5nLWlkJTIyJTBBKQ==",highlighted:`classifier = pipeline(
    <span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;sanchit-gandhi/whisper-medium-fleurs-lang-id&quot;</span>
)`,wrap:!1}}),ge=new f({props:{code:"Y2xhc3NpZmllcihzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCk=",highlighted:'classifier(sample[<span class="hljs-string">&quot;audio&quot;</span>])',wrap:!1}}),Me=new f({props:{code:"JTVCJTdCJ3Njb3JlJyUzQSUyMDAuOTk5OTMzMDA0Mzc5MjcyNSUyQyUyMCdsYWJlbCclM0ElMjAnQWZyaWthYW5zJyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjA3LjA5MzAyMzY2ODg1ODIyM2UtMDYlMkMlMjAnbGFiZWwnJTNBJTIwJ05vcnRoZXJuLVNvdGhvJyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjA0LjI2OTE0OTQ4NTQ4MDczOWUtMDYlMkMlMjAnbGFiZWwnJTNBJTIwJ0ljZWxhbmRpYyclN0QlMkMlMEElMjAlN0Inc2NvcmUnJTNBJTIwMy4yNjYxMTQxNjMxMjUxNjY3ZS0wNiUyQyUyMCdsYWJlbCclM0ElMjAnRGFuaXNoJyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjAzLjI1ODA3MjQxMDk3MjA5MDRlLTA2JTJDJTIwJ2xhYmVsJyUzQSUyMCdDYW50b25lc2UlMjBDaGluZXNlJyU3RCU1RA==",highlighted:`[{<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">0.9999330043792725</span>, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Afrikaans</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">7.093023668858223</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Northern-Sotho</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">4.269149485480739</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Icelandic</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">3.2661141631251667</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Danish</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">3.2580724109720904</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Cantonese</span> Chinese&#x27;}]`,wrap:!1}}),je=new g({props:{title:"Zero-Shot Audio Classification",local:"zero-shot-audio-classification",headingTag:"h2"}}),$e=new f({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJhc2hyYXElMkZlc2M1MCUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlKSUwQWF1ZGlvX3NhbXBsZSUyMCUzRCUyMG5leHQoaXRlcihkYXRhc2V0KSklNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVE",highlighted:`dataset = load_dataset(<span class="hljs-string">&quot;ashraq/esc50&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
audio_sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]`,wrap:!1}}),Ie=new f({props:{code:"Y2FuZGlkYXRlX2xhYmVscyUyMCUzRCUyMCU1QiUyMlNvdW5kJTIwb2YlMjBhJTIwZG9nJTIyJTJDJTIwJTIyU291bmQlMjBvZiUyMHZhY3V1bSUyMGNsZWFuZXIlMjIlNUQ=",highlighted:'candidate_labels = [<span class="hljs-string">&quot;Sound of a dog&quot;</span>, <span class="hljs-string">&quot;Sound of vacuum cleaner&quot;</span>]',wrap:!1}}),We=new f({props:{code:"Y2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ6ZXJvLXNob3QtYXVkaW8tY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMmxhaW9uJTJGY2xhcC1odHNhdC11bmZ1c2VkJTIyJTBBKSUwQWNsYXNzaWZpZXIoYXVkaW9fc2FtcGxlJTJDJTIwY2FuZGlkYXRlX2xhYmVscyUzRGNhbmRpZGF0ZV9sYWJlbHMp",highlighted:`classifier = pipeline(
    task=<span class="hljs-string">&quot;zero-shot-audio-classification&quot;</span>, model=<span class="hljs-string">&quot;laion/clap-htsat-unfused&quot;</span>
)
classifier(audio_sample, candidate_labels=candidate_labels)`,wrap:!1}}),He=new f({props:{code:"JTVCJTdCJ3Njb3JlJyUzQSUyMDAuOTk5NzI0MjA5MzA4NjI0MyUyQyUyMCdsYWJlbCclM0ElMjAnU291bmQlMjBvZiUyMGElMjBkb2cnJTdEJTJDJTIwJTdCJ3Njb3JlJyUzQSUyMDAuMDAwMjc1ODMyMzk3MTY0Nzc2OSUyQyUyMCdsYWJlbCclM0ElMjAnU291bmQlMjBvZiUyMHZhY3V1bSUyMGNsZWFuZXInJTdEJTVE",highlighted:'[{<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">0.9997242093086243</span>, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Sound</span> of a dog&#x27;}, {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">0.0002758323971647769</span>, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Sound</span> of vacuum cleaner&#x27;}]',wrap:!1}}),qe=new f({props:{code:"QXVkaW8oYXVkaW9fc2FtcGxlJTJDJTIwcmF0ZSUzRDE2MDAwKQ==",highlighted:'Audio(audio_sample, rate=<span class="hljs-number">16000</span>)',wrap:!1}}),Qe=new g({props:{title:"What next?",local:"what-next",headingTag:"h2"}}),Ge=new ka({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/en/chapter4/classification_models.mdx"}}),{c(){y=i("meta"),Fe=l(),Ee=i("p"),Be=l(),r(j.$$.fragment),Pe=l(),r(x.$$.fragment),Ve=l(),v=i("p"),v.innerHTML=xs,Xe=l(),U=i("p"),U.innerHTML=vs,Oe=l(),J=i("p"),J.innerHTML=Us,Ke=l(),C=i("p"),C.textContent=Js,et=l(),r($.$$.fragment),tt=l(),k=i("p"),k.innerHTML=Cs,st=l(),r(I.$$.fragment),at=l(),r(N.$$.fragment),lt=l(),W=i("p"),W.textContent=$s,nt=l(),r(L.$$.fragment),it=l(),H=i("p"),H.innerHTML=ks,ot=l(),r(_.$$.fragment),pt=l(),q=i("p"),q.innerHTML=Is,rt=l(),r(Z.$$.fragment),ht=l(),z=i("p"),z.textContent=Ns,ct=l(),r(Q.$$.fragment),dt=l(),S=i("p"),S.innerHTML=Ws,ut=l(),r(Y.$$.fragment),mt=l(),A=i("p"),A.textContent=Ls,ft=l(),r(G.$$.fragment),yt=l(),D=i("p"),D.textContent=Hs,gt=l(),E=i("p"),E.textContent=_s,bt=l(),R=i("p"),R.textContent=qs,Mt=l(),F=i("p"),F.innerHTML=Zs,wt=l(),b=i("div"),b.innerHTML=zs,Tt=l(),B=i("p"),B.textContent=Qs,jt=l(),P=i("p"),P.textContent=Ss,xt=l(),r(V.$$.fragment),vt=l(),X=i("p"),X.innerHTML=Ys,Ut=l(),r(O.$$.fragment),Jt=l(),K=i("p"),K.innerHTML=As,Ct=l(),r(ee.$$.fragment),$t=l(),te=i("p"),te.textContent=Gs,kt=l(),r(se.$$.fragment),It=l(),ae=i("p"),ae.innerHTML=Ds,Nt=l(),le=i("p"),le.textContent=Es,Wt=l(),M=i("div"),M.innerHTML=Rs,Lt=l(),ne=i("p"),ne.textContent=Fs,Ht=l(),w=i("div"),w.innerHTML=Bs,_t=l(),ie=i("p"),ie.innerHTML=Ps,qt=l(),T=i("div"),T.innerHTML=Vs,Zt=l(),oe=i("p"),oe.textContent=Xs,zt=l(),r(pe.$$.fragment),Qt=l(),re=i("p"),re.textContent=Os,St=l(),r(he.$$.fragment),Yt=l(),ce=i("p"),ce.innerHTML=Ks,At=l(),de=i("p"),de.textContent=ea,Gt=l(),r(ue.$$.fragment),Dt=l(),me=i("p"),me.innerHTML=ta,Et=l(),r(fe.$$.fragment),Rt=l(),ye=i("p"),ye.textContent=sa,Ft=l(),r(ge.$$.fragment),Bt=l(),be=i("p"),be.innerHTML=aa,Pt=l(),r(Me.$$.fragment),Vt=l(),we=i("p"),we.innerHTML=la,Xt=l(),Te=i("p"),Te.textContent=na,Ot=l(),r(je.$$.fragment),Kt=l(),xe=i("p"),xe.innerHTML=ia,es=l(),ve=i("p"),ve.textContent=oa,ts=l(),Ue=i("p"),Ue.innerHTML=pa,ss=l(),Je=i("p"),Je.textContent=ra,as=l(),Ce=i("p"),Ce.innerHTML=ha,ls=l(),r($e.$$.fragment),ns=l(),ke=i("p"),ke.innerHTML=ca,is=l(),r(Ie.$$.fragment),os=l(),Ne=i("p"),Ne.innerHTML=da,ps=l(),r(We.$$.fragment),rs=l(),Le=i("p"),Le.innerHTML=ua,hs=l(),r(He.$$.fragment),cs=l(),_e=i("p"),_e.textContent=ma,ds=l(),r(qe.$$.fragment),us=l(),Ze=i("p"),Ze.textContent=fa,ms=l(),ze=i("p"),ze.innerHTML=ya,fs=l(),r(Qe.$$.fragment),ys=l(),Se=i("p"),Se.innerHTML=ga,gs=l(),Ye=i("p"),Ye.innerHTML=ba,bs=l(),Ae=i("p"),Ae.innerHTML=Ma,Ms=l(),r(Ge.$$.fragment),ws=l(),Re=i("p"),this.h()},l(e){const t=Ja("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(s),Fe=n(e),Ee=o(e,"P",{}),wa(Ee).forEach(s),Be=n(e),h(j.$$.fragment,e),Pe=n(e),h(x.$$.fragment,e),Ve=n(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1sx6iox"&&(v.innerHTML=xs),Xe=n(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1fbyaxi"&&(U.innerHTML=vs),Oe=n(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-1webo38"&&(J.innerHTML=Us),Ke=n(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-rwwaij"&&(C.textContent=Js),et=n(e),h($.$$.fragment,e),tt=n(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1tugr7p"&&(k.innerHTML=Cs),st=n(e),h(I.$$.fragment,e),at=n(e),h(N.$$.fragment,e),lt=n(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-18ejjqs"&&(W.textContent=$s),nt=n(e),h(L.$$.fragment,e),it=n(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1jsn8wa"&&(H.innerHTML=ks),ot=n(e),h(_.$$.fragment,e),pt=n(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1c1mr12"&&(q.innerHTML=Is),rt=n(e),h(Z.$$.fragment,e),ht=n(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1xz16k"&&(z.textContent=Ns),ct=n(e),h(Q.$$.fragment,e),dt=n(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1mvdyro"&&(S.innerHTML=Ws),ut=n(e),h(Y.$$.fragment,e),mt=n(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-k1rlzh"&&(A.textContent=Ls),ft=n(e),h(G.$$.fragment,e),yt=n(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-11rdezd"&&(D.textContent=Hs),gt=n(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1o56zbf"&&(E.textContent=_s),bt=n(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-ts3or1"&&(R.textContent=qs),Mt=n(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-fipl47"&&(F.innerHTML=Zs),wt=n(e),b=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(b)!=="svelte-sk0ezl"&&(b.innerHTML=zs),Tt=n(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-yyvm6u"&&(B.textContent=Qs),jt=n(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-p686we"&&(P.textContent=Ss),xt=n(e),h(V.$$.fragment,e),vt=n(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-hz24qn"&&(X.innerHTML=Ys),Ut=n(e),h(O.$$.fragment,e),Jt=n(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1mvdyro"&&(K.innerHTML=As),Ct=n(e),h(ee.$$.fragment,e),$t=n(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-kbnmt8"&&(te.textContent=Gs),kt=n(e),h(se.$$.fragment,e),It=n(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-7botfj"&&(ae.innerHTML=Ds),Nt=n(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-csh5dy"&&(le.textContent=Es),Wt=n(e),M=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(M)!=="svelte-bqfzrn"&&(M.innerHTML=Rs),Lt=n(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-6zblrj"&&(ne.textContent=Fs),Ht=n(e),w=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(w)!=="svelte-1t2za6k"&&(w.innerHTML=Bs),_t=n(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-7t6r33"&&(ie.innerHTML=Ps),qt=n(e),T=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(T)!=="svelte-1sstogo"&&(T.innerHTML=Vs),Zt=n(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1jgbk0j"&&(oe.textContent=Xs),zt=n(e),h(pe.$$.fragment,e),Qt=n(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-5rskgo"&&(re.textContent=Os),St=n(e),h(he.$$.fragment,e),Yt=n(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1n5euwf"&&(ce.innerHTML=Ks),At=n(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-a6zngd"&&(de.textContent=ea),Gt=n(e),h(ue.$$.fragment,e),Dt=n(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-1g1l39x"&&(me.innerHTML=ta),Et=n(e),h(fe.$$.fragment,e),Rt=n(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1fons3v"&&(ye.textContent=sa),Ft=n(e),h(ge.$$.fragment,e),Bt=n(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-1mvdyro"&&(be.innerHTML=aa),Pt=n(e),h(Me.$$.fragment,e),Vt=n(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1044ak6"&&(we.innerHTML=la),Xt=n(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-857vsk"&&(Te.textContent=na),Ot=n(e),h(je.$$.fragment,e),Kt=n(e),xe=o(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-1wf33gz"&&(xe.innerHTML=ia),es=n(e),ve=o(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-1bub4i"&&(ve.textContent=oa),ts=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-xv3v8"&&(Ue.innerHTML=pa),ss=n(e),Je=o(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-yr149b"&&(Je.textContent=ra),as=n(e),Ce=o(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1osll5p"&&(Ce.innerHTML=ha),ls=n(e),h($e.$$.fragment,e),ns=n(e),ke=o(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-18w9coi"&&(ke.innerHTML=ca),is=n(e),h(Ie.$$.fragment,e),os=n(e),Ne=o(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-163k6s1"&&(Ne.innerHTML=da),ps=n(e),h(We.$$.fragment,e),rs=n(e),Le=o(e,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-1mvdyro"&&(Le.innerHTML=ua),hs=n(e),h(He.$$.fragment,e),cs=n(e),_e=o(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-1slv1zu"&&(_e.textContent=ma),ds=n(e),h(qe.$$.fragment,e),us=n(e),Ze=o(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-125h3os"&&(Ze.textContent=fa),ms=n(e),ze=o(e,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-elwwua"&&(ze.innerHTML=ya),fs=n(e),h(Qe.$$.fragment,e),ys=n(e),Se=o(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-1b8ovtt"&&(Se.innerHTML=ga),gs=n(e),Ye=o(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-1dkp3zb"&&(Ye.innerHTML=ba),bs=n(e),Ae=o(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-nfuday"&&(Ae.innerHTML=Ma),Ms=n(e),h(Ge.$$.fragment,e),ws=n(e),Re=o(e,"P",{}),wa(Re).forEach(s),this.h()},h(){De(y,"name","hf:doc:metadata"),De(y,"content",Na),De(b,"class","flex justify-center"),De(M,"class","flex justify-center"),De(w,"class","flex justify-center"),De(T,"class","flex justify-center")},m(e,t){Ca(document.head,y),a(e,Fe,t),a(e,Ee,t),a(e,Be,t),c(j,e,t),a(e,Pe,t),c(x,e,t),a(e,Ve,t),a(e,v,t),a(e,Xe,t),a(e,U,t),a(e,Oe,t),a(e,J,t),a(e,Ke,t),a(e,C,t),a(e,et,t),c($,e,t),a(e,tt,t),a(e,k,t),a(e,st,t),c(I,e,t),a(e,at,t),c(N,e,t),a(e,lt,t),a(e,W,t),a(e,nt,t),c(L,e,t),a(e,it,t),a(e,H,t),a(e,ot,t),c(_,e,t),a(e,pt,t),a(e,q,t),a(e,rt,t),c(Z,e,t),a(e,ht,t),a(e,z,t),a(e,ct,t),c(Q,e,t),a(e,dt,t),a(e,S,t),a(e,ut,t),c(Y,e,t),a(e,mt,t),a(e,A,t),a(e,ft,t),c(G,e,t),a(e,yt,t),a(e,D,t),a(e,gt,t),a(e,E,t),a(e,bt,t),a(e,R,t),a(e,Mt,t),a(e,F,t),a(e,wt,t),a(e,b,t),a(e,Tt,t),a(e,B,t),a(e,jt,t),a(e,P,t),a(e,xt,t),c(V,e,t),a(e,vt,t),a(e,X,t),a(e,Ut,t),c(O,e,t),a(e,Jt,t),a(e,K,t),a(e,Ct,t),c(ee,e,t),a(e,$t,t),a(e,te,t),a(e,kt,t),c(se,e,t),a(e,It,t),a(e,ae,t),a(e,Nt,t),a(e,le,t),a(e,Wt,t),a(e,M,t),a(e,Lt,t),a(e,ne,t),a(e,Ht,t),a(e,w,t),a(e,_t,t),a(e,ie,t),a(e,qt,t),a(e,T,t),a(e,Zt,t),a(e,oe,t),a(e,zt,t),c(pe,e,t),a(e,Qt,t),a(e,re,t),a(e,St,t),c(he,e,t),a(e,Yt,t),a(e,ce,t),a(e,At,t),a(e,de,t),a(e,Gt,t),c(ue,e,t),a(e,Dt,t),a(e,me,t),a(e,Et,t),c(fe,e,t),a(e,Rt,t),a(e,ye,t),a(e,Ft,t),c(ge,e,t),a(e,Bt,t),a(e,be,t),a(e,Pt,t),c(Me,e,t),a(e,Vt,t),a(e,we,t),a(e,Xt,t),a(e,Te,t),a(e,Ot,t),c(je,e,t),a(e,Kt,t),a(e,xe,t),a(e,es,t),a(e,ve,t),a(e,ts,t),a(e,Ue,t),a(e,ss,t),a(e,Je,t),a(e,as,t),a(e,Ce,t),a(e,ls,t),c($e,e,t),a(e,ns,t),a(e,ke,t),a(e,is,t),c(Ie,e,t),a(e,os,t),a(e,Ne,t),a(e,ps,t),c(We,e,t),a(e,rs,t),a(e,Le,t),a(e,hs,t),c(He,e,t),a(e,cs,t),a(e,_e,t),a(e,ds,t),c(qe,e,t),a(e,us,t),a(e,Ze,t),a(e,ms,t),a(e,ze,t),a(e,fs,t),c(Qe,e,t),a(e,ys,t),a(e,Se,t),a(e,gs,t),a(e,Ye,t),a(e,bs,t),a(e,Ae,t),a(e,Ms,t),c(Ge,e,t),a(e,ws,t),a(e,Re,t),Ts=!0},p:ja,i(e){Ts||(d(j.$$.fragment,e),d(x.$$.fragment,e),d($.$$.fragment,e),d(I.$$.fragment,e),d(N.$$.fragment,e),d(L.$$.fragment,e),d(_.$$.fragment,e),d(Z.$$.fragment,e),d(Q.$$.fragment,e),d(Y.$$.fragment,e),d(G.$$.fragment,e),d(V.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(se.$$.fragment,e),d(pe.$$.fragment,e),d(he.$$.fragment,e),d(ue.$$.fragment,e),d(fe.$$.fragment,e),d(ge.$$.fragment,e),d(Me.$$.fragment,e),d(je.$$.fragment,e),d($e.$$.fragment,e),d(Ie.$$.fragment,e),d(We.$$.fragment,e),d(He.$$.fragment,e),d(qe.$$.fragment,e),d(Qe.$$.fragment,e),d(Ge.$$.fragment,e),Ts=!0)},o(e){u(j.$$.fragment,e),u(x.$$.fragment,e),u($.$$.fragment,e),u(I.$$.fragment,e),u(N.$$.fragment,e),u(L.$$.fragment,e),u(_.$$.fragment,e),u(Z.$$.fragment,e),u(Q.$$.fragment,e),u(Y.$$.fragment,e),u(G.$$.fragment,e),u(V.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(se.$$.fragment,e),u(pe.$$.fragment,e),u(he.$$.fragment,e),u(ue.$$.fragment,e),u(fe.$$.fragment,e),u(ge.$$.fragment,e),u(Me.$$.fragment,e),u(je.$$.fragment,e),u($e.$$.fragment,e),u(Ie.$$.fragment,e),u(We.$$.fragment,e),u(He.$$.fragment,e),u(qe.$$.fragment,e),u(Qe.$$.fragment,e),u(Ge.$$.fragment,e),Ts=!1},d(e){e&&(s(Fe),s(Ee),s(Be),s(Pe),s(Ve),s(v),s(Xe),s(U),s(Oe),s(J),s(Ke),s(C),s(et),s(tt),s(k),s(st),s(at),s(lt),s(W),s(nt),s(it),s(H),s(ot),s(pt),s(q),s(rt),s(ht),s(z),s(ct),s(dt),s(S),s(ut),s(mt),s(A),s(ft),s(yt),s(D),s(gt),s(E),s(bt),s(R),s(Mt),s(F),s(wt),s(b),s(Tt),s(B),s(jt),s(P),s(xt),s(vt),s(X),s(Ut),s(Jt),s(K),s(Ct),s($t),s(te),s(kt),s(It),s(ae),s(Nt),s(le),s(Wt),s(M),s(Lt),s(ne),s(Ht),s(w),s(_t),s(ie),s(qt),s(T),s(Zt),s(oe),s(zt),s(Qt),s(re),s(St),s(Yt),s(ce),s(At),s(de),s(Gt),s(Dt),s(me),s(Et),s(Rt),s(ye),s(Ft),s(Bt),s(be),s(Pt),s(Vt),s(we),s(Xt),s(Te),s(Ot),s(Kt),s(xe),s(es),s(ve),s(ts),s(Ue),s(ss),s(Je),s(as),s(Ce),s(ls),s(ns),s(ke),s(is),s(os),s(Ne),s(ps),s(rs),s(Le),s(hs),s(cs),s(_e),s(ds),s(us),s(Ze),s(ms),s(ze),s(fs),s(ys),s(Se),s(gs),s(Ye),s(bs),s(Ae),s(Ms),s(ws),s(Re)),s(y),m(j,e),m(x,e),m($,e),m(I,e),m(N,e),m(L,e),m(_,e),m(Z,e),m(Q,e),m(Y,e),m(G,e),m(V,e),m(O,e),m(ee,e),m(se,e),m(pe,e),m(he,e),m(ue,e),m(fe,e),m(ge,e),m(Me,e),m(je,e),m($e,e),m(Ie,e),m(We,e),m(He,e),m(qe,e),m(Qe,e),m(Ge,e)}}}const Na='{"title":"Pre-trained models and datasets for audio classification","local":"pre-trained-models-and-datasets-for-audio-classification","sections":[{"title":"🤗 Transformers Installation","local":"-transformers-installation","sections":[],"depth":2},{"title":"Keyword Spotting","local":"keyword-spotting","sections":[{"title":"Minds-14","local":"minds-14","sections":[],"depth":3},{"title":"Speech Commands","local":"speech-commands","sections":[],"depth":3}],"depth":2},{"title":"Language Identification","local":"language-identification","sections":[{"title":"FLEURS","local":"fleurs","sections":[],"depth":3}],"depth":2},{"title":"Zero-Shot Audio Classification","local":"zero-shot-audio-classification","sections":[],"depth":2},{"title":"What next?","local":"what-next","sections":[],"depth":2}],"depth":1}';function Wa(js){return xa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Za extends va{constructor(y){super(),Ua(this,y,Wa,Ia,Ta,{})}}export{Za as component};
