import{s as Rn,n as Vn,o as $n}from"../chunks/scheduler.a045fce0.js";import{S as Fn,i as Wn,e as o,s as l,c as p,q as J,H as It,h as Zn,a as i,d as t,b as a,f as Rt,g as u,j as r,r as j,u as St,k as _e,l as U,m as n,n as d,t as c,o as m,p as M}from"../chunks/index.5135b896.js";import{C as Hn,H as Ae,E as Nn}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.18f40ad6.js";import{C as y}from"../chunks/CodeBlock.655c066f.js";function Yn(Vt){let w,Pe,ze,Oe,v,De,I,Ke,S,$t=`Dans cette section, nous verrons comment utiliser le <code>pipeline()</code> pour tirer parti des modèles pré-entraînés pour la reconnaissance automatique de la parole. Dans l’[unité 2](.. /chapter2/asr_pipeline), nous avons introduit le <code>pipeline()</code> comme un moyen facile d’exécuter des tâches de reconnaissance de la parole, avec tout le prétraitement et le post-traitement gérés sous le capot et la flexibilité d’expérimenter rapidement avec n’importe quel <em>checkpoint</em> pré-entraîné disponible sur le <em>Hub</em>.
Dans cette unité, nous irons plus loin et explorerons les différents attributs des modèles de reconnaissance automatique de la parole et comment nous pouvons les utiliser pour aborder une gamme de tâches différentes.`,es,x,Ft="Comme détaillé dans l’unité 3, le modèle de reconnaissance automatique de la parole se divise généralement dans l’une des deux catégories suivantes :",ss,B,Wt="<li>Modèle avec Classification temporelle connexionniste (CTC) : modèles avec que l’encodeur du <em>transformer</em> avec une tête de classification linéaire sur le dessus</li> <li>Modèle de séquence à séquence (Seq2Seq) : modèles encodeur-décodeur, avec un mécanisme d’attention croisée entre l’encodeur et le décodeur</li>",ts,E,Zt=`Avant 2022, la variante avec CTC était la plus populaire des deux architectures, avec des modèles tels que Wav2Vec2, HuBERT et XLSR réalisant des percées dans le paradigme de pré-entraînement / <em>finetuning</em> de la parole.
De grandes entreprises, telles que Meta et Microsoft, ont pré-entraîné l’encodeur sur de grandes quantités de données audio non étiquetées pendant plusieurs jours ou semaines.
Les utilisateurs pouvent ensuite prendre un <em>checkpoint</em> pré-entraîné et le finetuner avec une tête CTC sur à peine <strong>10 minutes</strong> de données audio étiquetées pour obtenir de solides performances sur une tâche en aval de reconnaissance automatique de la parole.
Cependant, les modèles CTC ont des lacunes. L’ajout d’une simple couche linéaire à un encodeur donne un petit modèle global rapide, mais peut être sujet à des fautes d’orthographe phonétiques. Nous allons le démontrer ci-dessous pour le modèle Wav2Vec2.`,ns,C,ls,k,Ht='Chargeons un petit extrait du jeu de données <a href="hf-internal-testing/librispeech_asr_dummy">LibriSpeech ASR</a> pour démontrer les capacités de transcription de Wav2Vec2 :',as,G,os,q,Nt="<strong>Sortie :</strong>",is,R,rs,V,Yt="Nous pouvons choisir l’un des 73 échantillons audio et en inspecter l’audio ainsi que la transcription :",ps,$,us,F,Qt="<strong>Sortie :</strong>",ds,W,cs,Z,Lt=`Noël et rôti de bœuf, ça sonne bien! 🎄 Après avoir choisi un échantillon de données, nous chargeons maintenant un <em>checkpoint</em> <em>finetuné</em> dans le <code>pipeline()</code>.
Pour cela, nous utiliserons le <em>checkpoint</em> officiel [base Wav2Vec2] (facebook/wav2vec2-base-100h) <em>finetuné</em> sur 100 heures de données LibriSpeech :`,ms,H,Ms,N,_t=`Ensuite, nous allons prendre un exemple du jeu de données et transmettre ses données brutes au pipeline.
Puisque le pipeline <em>consomme</em> n’importe quel dictionnaire que nous lui passons (ce qui signifie qu’il ne peut pas être réutilisé), nous transmettrons une copie des données. De cette façon, nous pouvons réutiliser en toute sécurité le même échantillon audio dans les exemples suivants:`,hs,Y,ys,Q,zt=`Nous pouvons voir que le modèle Wav2Vec2 fait un assez bon travail pour transcrire cet échantillon. A première vue, il semble généralement correct.
Mettons la cible et la prédiction côte à côte et mettons en évidence les différences:`,Ts,L,Us,_,Xt="En comparant le texte cible à la transcription prévue, nous pouvons voir que tous les mots <em>sonnent</em> correctement mais que certains ne sont pas orthographiés avec précision. Par exemple :",Js,z,At=`<li><em>CHRISTMAUS</em> vs. <em>CHRISTMAS</em></li> <li><em>ROSE</em> vs. <em>ROAST</em></li> <li><em>SIMALYIS</em> vs. <em>SIMILES</em>
Cela met en évidence les lacunes d’un modèle CTC. Un modèle CTC est essentiellement uniquement un modèle « acoustique» : il se compose d’un encodeur qui forme des représentations d’états cachés à partir des entrées audio, et d’une couche linéaire qui associe les états cachés aux caractères :</li>`,js,b,Pt='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/wav2vec2-ctc.png" alt="Transformer encoder with a CTC head on top"/>',ws,X,Ot=`Cela signifie que le système base presque entièrement sa prédiction sur l’entrée acoustique qui lui a été donnée (les sons phonétiques de l’audio), et a donc tendance à transcrire l’audio de manière phonétique.
Il donne moins d’importance au contexte de modélisation linguistique des lettres précédentes et successives, et est donc sujet aux fautes d’orthographe phonétique.
Un modèle plus intelligent identifierait que <em>CHRISTMAUS</em> n’est pas un mot valide dans le vocabulaire anglais, et le corrigerait en <em>CHRISTMAS</em> lors de ses prédictions. Il nous manque également deux grandes fonctionnalités dans notre prédiction, la casse et la ponctuation, ce qui limite l’utilité des transcriptions du modèle aux applications réelles.`,bs,A,gs,P,Dt=`Comme indiqué dans l’unité 3, les modèles Seq2Seq sont formés d’un codeur et d’un décodeur reliés par un mécanisme d’attention croisée. L’encodeur joue le même rôle qu’auparavant, calculant des représentations d’états cachés des entrées audio, tandis que le décodeur joue le rôle d’un <strong>modèle de langage</strong>. Le décodeur traite toute la séquence de représentations d’états cachés de l’encodeur et génère les transcriptions de texte correspondantes. Avec le contexte global de l’entrée audio, le décodeur est capable d’utiliser le contexte du modèle de langage lorsqu’il fait ses prédictions, corrigeant les fautes d’orthographe à la volée et contournant ainsi le problème des prédictions phonétiques.
Les modèles Seq2Seq présentent deux inconvénients :`,fs,O,Kt="<li>Ils sont intrinsèquement plus lents lors du décodage puisqu’il se produit une étape à la fois, plutôt que tout à la fois 2. Ils nécessitent beaucoup plus de données d’entraînement pour converger</li>",vs,D,en=`Le besoin de grandes quantités de données d’apprentissage a été un goulot d’étranglement dans l’avancement des architectures Seq2Seq pour la parole. Les données audios étiquetées sont difficiles à obtenir, les plus grands jeux de données annotées à l’époque ne totalisant que 10 000 heures. Tout cela a changé en 2022 avec la sortie de <strong>Whisper</strong>. Whisper est un modèle pré-entraîné pour la reconnaissance automatique de la parole publié en <a href="https://openai.com/blog/whisper/" rel="nofollow">septembre 2022</a> par Alec Radford et al. d’OpenAI. Contrairement à ses prédécesseurs CTC, qui étaient entièrement pré-entraînés sur des données audio <strong>non étiquetées</strong>, Whisper est pré-entraîné sur une grande quantité de données de transcription audio <strong>étiquetées</strong>, 680 000 heures pour être précis.
Il s’agit d’un ordre de grandeur de données plus grand que les données audio non étiquetées utilisées pour entraîner Wav2Vec 2.0 (60 000 heures). De plus, 117 000 heures de ces données de pré-entraînement sont des données multilingues. Il en résulte des <em>checkpoints</em> qui peuvent être appliqués à plus de 96 langues, dont beaucoup sont considérées comme <em>à faible ressource</em>.
Lorsqu’ils sont passés à l’échelle, les modèles Whisper démontrent une forte capacité à généraliser sur de nombreux jeux de données et domaines. Obtenant des résultats compétitifs de pointe, avec un taux d’erreur de mots (WER) de près de 3% sur le sous-ensemble de test LibriSpeech et de 4,7% WER  sur le sous-ensemble de test TED-LIUM (<em>cf.</em> Tableau 8 du <a href="https://cdn.openai.com/papers/whisper.pdf" rel="nofollow">papier de Whisper</a>).
La capacité de Whisper à gérer de longs échantillons audio, sa robustesse au bruit et sa capacité à prédire les transcriptions en casse et ponctuées revêtent une importance particulière. Cela en fait un candidat viable pour les systèmes de reconnaissance automatique de la parole du monde réel.
Le reste de cette section vous montrera comment utiliser les modèles Whisper pré-entraînés pour la reconnaissance automatique de la parole à l’aide de 🤗 <em>Transformers</em>. Dans de nombreuses situations, les <em>checkpoints</em> pré-entraînés sont extrêmement performants et donnent d’excellents résultats, nous vous encourageons donc à essayer de les utiliser comme première étape pour résoudre tout problème de reconnaissance automatique de la parole.
Grâce à un <em>finetuning</em>, les <em>checkpoints</em> peuvent être adaptés à des jeux de données et à des langues spécifiques afin d’améliorer encore ces résultats. Nous montrerons comment faire cela dans la section sur <a href="fine-tuning">le <em>finetuning</em></a>.
Whisper est disponible en cinq tailles différentes de modèles. Les quatre plus petits sont entraînés soit sur des données en anglais soit sur des données multilingues. Le <em>checkpoint</em> le plus grand est uniquement multilingue. Les neuf <em>checkpoints</em> pré-entraînés sont disponibles sur le <a href="https://huggingface.co/models?search=openai/whisper" rel="nofollow"><em>Hub</em></a>. Ils sont résumés dans le tableau suivant. « VRAM » indique la mémoire GPU requise pour exécuter le modèle avec une taille de batch minimale de 1. « <em>Rel Speed</em> » est la vitesse relative d’un <em>checkpoint</em> par rapport au plus grand modèle.
Sur la base de ces informations, vous pouvez sélectionner le <em>checkpoint</em> le plus adapté à votre matériel.`,Is,K,sn='<thead><tr><th>Taille</th> <th>Paramètres</th> <th>VRAM / Go</th> <th><em>Rel Speed</em></th> <th>Anglais</th> <th>Multilingue</th></tr></thead> <tbody><tr><td>tiny</td> <td>39 M</td> <td>1.4</td> <td>32</td> <td><a href="https://huggingface.co/openai/whisper-tiny.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-tiny" rel="nofollow">✓</a></td></tr> <tr><td>base</td> <td>74 M</td> <td>1.5</td> <td>16</td> <td><a href="https://huggingface.co/openai/whisper-base.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-base" rel="nofollow">✓</a></td></tr> <tr><td>small</td> <td>244 M</td> <td>2.3</td> <td>6</td> <td><a href="https://huggingface.co/openai/whisper-small.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-small" rel="nofollow">✓</a></td></tr> <tr><td>medium</td> <td>769 M</td> <td>4.2</td> <td>2</td> <td><a href="https://huggingface.co/openai/whisper-medium.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-medium" rel="nofollow">✓</a></td></tr> <tr><td>large</td> <td>1550 M</td> <td>7.5</td> <td>1</td> <td>x</td> <td><a href="https://huggingface.co/openai/whisper-large-v2" rel="nofollow">✓</a></td></tr></tbody>',Ss,ee,tn='Chargeons le <a href="https://huggingface.co/openai/whisper-base" rel="nofollow">Whisper Base</a>, qui est de taille comparable au Wav2Vec2 que nous avons utilisé précédemment. Anticipant notre passage à la reconnaissance automatique de la parole multilingue, nous allons charger la variante multilingue du <em>checkpoint</em> de base. Nous chargons également le modèle sur le GPU s’il est disponible, ou sur le CPU dans le cas contraire. Le <code>pipeline()</code> se chargera ensuite de déplacer toutes les entrées / sorties du CPU vers le GPU selon les besoins:',xs,se,Bs,te,nn="Bien, maintenant, transcrivons l’audio comme avant. Le seul changement que nous apportons est de passer un argument supplémentaire, <code>max_new_tokens</code>, qui indique au modèle le nombre maximum de <em>tokens</em> à générer lors de sa prédiction :",Es,ne,Cs,le,ln="<strong>Sortie :</strong>",ks,ae,Gs,oe,an="La première chose que vous remarquerez est la présence de la casse et de la ponctuation. Cela rend immédiatement la transcription plus facile à lire par rapport à la transcription non casée et non ponctuée de Wav2Vec2. Mettons la transcription côte à côte avec la cible :",qs,ie,Rs,re,on=`Whisper a fait un excellent travail pour corriger les erreurs phonétiques que nous avons vues avec Wav2Vec2 : <em>Christmas</em> et <em>roast</em> sont orthographiés correctement. Nous voyons que le modèle a encore du mal avec <em>SIMILES</em>, étant incorrectement transcrit comme <em>similarly</em>, mais cette fois la prédiction est un mot valide du vocabulaire anglais. L’utilisation d’un Whisper plus grand peut aider à réduire davantage les erreurs de transcription, au détriment d’un calcul plus important et d’un temps de transcription plus long.
On nous a promis un modèle capable de gérer 96 langues, alors passons à de la reconnaissance automatique multilingue 🌎 !
Le jeu de données <a href="https://huggingface.co/datasets/facebook/multilingual_librispeech" rel="nofollow">Multilingual LibriSpeech</a> (MLS) est l’équivalent multilingue du jeu de données LibriSpeech, avec des données audio étiquetées en six langues. Nous allons charger un échantillon de l’échantillon espagnol de MLS, en utilisant le mode <em>streaming</em> afin de ne pas avoir à télécharger l’ensemble de données :`,Vs,pe,$s,ue,rn="Encore une fois, nous allons inspecter la transcription du texte et écouter le segment audio:",Fs,de,Ws,ce,pn="<strong>Sortie :</strong>",Zs,me,Hs,Me,un="C’est le texte cible que nous visons avec notre transcription Whisper. Bien que nous sachions maintenant que nous pouvons probablement faire mieux, puisque notre modèle va aussi prédire la ponctuation et la casse, qui ne sont pas présents dans la référence. Transmettons l’échantillon audio au pipeline pour obtenir notre prédiction de texte. Une chose à noter est que le pipeline <em>consomme</em> le dictionnaire des entrées audio que nous entrons, ce qui signifie que le dictionnaire ne peut pas être réutilisé. Pour contourner ce problème, nous allons passer une <em>copie</em> de l’échantillon audio, afin de pouvoir réutiliser le même échantillon audio dans les exemples de code suivants :",Ns,he,Ys,ye,dn="<strong>Sortie :</strong>",Qs,Te,Ls,Ue,cn="Super, cela ressemble énormément à notre texte de référence (sans doute mieux car il a une ponctuation et une casse !). Vous remarquerez que nous avons transféré <code>&quot;task&quot;</code> en tant que <em>generate kwarg</em>. Définir la <code>&quot;task&quot;</code> à <code>&quot;transcribe&quot;</code> oblige Whisper à effectuer la tâche de reconnaissance de la parole, où l’audio est transcrit dans la même langue que le discours a été prononcé. Whisper est également capable d’effectuer la tâche étroitement liée de traduction de la parole, où l’audio en espagnol peut être traduit en texte en anglais. Pour y parvenir, nous définissons la <code>&quot;task&quot;</code> sur <code>&quot;translate&quot;</code> :",_s,Je,zs,je,mn="<strong>Sortie :</strong>",Xs,we,As,be,Mn=`Maintenant que nous savons que nous pouvons basculer entre la reconnaissance automatique de la parole et la traduction de la parole, nous pouvons choisir notre tâche en fonction de nos besoins. Soit nous reconnaissons l’audio dans la langue X vers le texte dans la même langue X (par exemple, l’audio espagnol vers le texte espagnol), soit nous traduisons de l’audio dans n’importe quelle langue X vers du texte en anglais (par exemple, l’audio espagnol vers le texte anglais).
Pour en savoir plus sur la façon dont l’argument <code>&quot;task&quot;</code> est utilisé pour contrôler les propriétés du texte généré, reportez-vous à la <a href="https://huggingface.co/openai/whisper-base#usage" rel="nofollow">carte de modèle</a> pour le modèle Whisper base.`,Ps,ge,Os,fe,hn=`Jusqu’à présent, nous nous sommes concentrés sur la transcription de courts échantillons audio de moins de 30 secondes. Nous avons mentionné que l’un des attraits de Whisper était sa capacité à travailler sur de longs échantillons audio. Nous allons nous attaquer à cette tâche ici !
Créons un long fichier audio en concaténant des échantillons successifs à partir du jeu de données MLS. Étant donné que MLS est organisé en divisant de longs enregistrements de livres audio en segments plus courts, la concaténation d’échantillons est un moyen de reconstruire des passages de livres audio plus longs. Par conséquent, l’audio résultant doit être cohérent sur l’ensemble de l’échantillon. Nous allons définir notre durée audio cible sur 5 minutes et arrêter de concaténer des échantillons une fois que nous aurons atteint cette valeur :`,Ds,ve,Ks,Ie,yn="<strong>Sortie :</strong>",et,Se,st,xe,Tn="5 minutes et 17 secondes d’audio à transcrire. Le transfert de ce long échantillon audio directement vers le modèle pose deux problèmes :",tt,Be,Un=`<li>Whisper est intrinsèquement conçu pour fonctionner avec des échantillons de 30 secondes. Tout ce qui est inférieur à 30s est rembourré à 30s avec du silence, et tout ce qui dépasse 30s est tronqué à 30s en coupant l’audio excédentaire. Donc si nous passons notre audio directement, nous n’obtiendrons la transcription que pour les 30 premières secondes</li> <li>La mémoire dans un <em>transformer</em> évolue quadratiquement avec la longueur de séquence a : doubler la longueur d’entrée quadruple le besoin en mémoire, de sorte que le passage de fichiers audio très longs entraînera inévitablement une erreur de mémoire insuffisante (OOM : out-of-memory)
La transcription de longs audio fonctionne dans 🤗 <em>Transformers</em> en segmentant l’audio d’entrée en segments plus petits et plus faciles à gérer.
Chaque segment a un petit chevauchement avec le précédent. Cela nous permet de recoudre avec précision les segments aux bornes, car nous pouvons trouver le chevauchement entre les segments et fusionner les transcriptions en conséquence :</li>`,nt,g,Jn='<img src="https://huggingface.co/blog/assets/49_asr_chunking/Striding.png" alt="🤗 Transformers chunking algorithm. Source: https://huggingface.co/blog/asr-chunking."/>',lt,h,xt,at,Cn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',ot,it,kn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>+</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> i + 1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',rt,He,jn="sans états",Bt,pt,Gn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>+</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> i + 1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',ut,dt,qn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',ct,Ne,wn="batch",Et,Ye,bn="Transformers",Ct,f,gn="https://huggingface.co/blog/asr-chunking",kt,Qe,fn="chunk_length_s",Gt,Le,vn="batch_size",qt,mt,Ee,Mt,Ce,In="<strong>Sortie :</strong>",ht,ke,yt,Ge,Sn=`Nous n’affichons pas toute la sortie ici car elle est assez longue (312 mots au total). Sur un GPU V100 de 16 Go, vous pouvez vous attendre à ce que la ligne ci-dessus prenne environ 3,45 secondes à s’éxécuter, ce qui est assez bon pour un échantillon audio de 317 secondes. Sur un CPU, attendez-vous à plus de 30 secondes.
Whisper est également capable de prédire les <em>horodatages</em> au niveau du segment pour les données audio. Ces horodatages indiquent l’heure de début et de fin d’un court passage audio et sont particulièrement utiles pour aligner une transcription avec l’audio d’entrée. Supposons que nous voulions fournir des sous-titres pour une vidéo. Nous avons besoin de ces horodatages pour savoir quelle partie de la transcription correspond à un certain segment de vidéo, afin d’afficher la transcription correcte pour cette heure.
L’activation de la prédiction d’horodatage est simple, il suffit de définir l’argument <code>return_timestamps=True</code>. Les horodatages sont compatibles avec les méthodes de segmentation et de traitement par batchs que nous avons utilisées précédemment. Nous pouvons donc simplement ajouter l’argument timestamp à notre code précédent :`,Tt,qe,Ut,Re,xn="<strong>Sortie :</strong>",Jt,Ve,jt,$e,Bn="Et le tour est joué ! Nous avons notre texte prédit ainsi que les horodatages correspondants.",wt,Fe,bt,We,En=`Whisper est un modèle pré-entraîné solide pour la reconnaissance automatique de la parole et la traduction. Par rapport à Wav2Vec2, il a une plus grande précision de transcription, avec des sorties qui contiennent la ponctuation et la casse. Il peut être utilisé pour transcrire la parole en anglais ainsi que dans 96 autres langues, à la fois sur des segments audio courts et des segments plus longs par le biais de  la segmentation. Ces attributs en font un modèle viable pour de nombreuses tâches de reconnaissance automatique de la parole et de traduction sans avoir besoin d’être <em>finetuné</em>. La méthode <code>pipeline()</code> fournit un moyen facile d’inférer en une ligne de code avec un contrôle sur les prédictions générées.
Bien que le modèle Whisper fonctionne extrêmement bien sur de nombreuses langues à ressources élevées, il a une précision de transcription et de traduction plus faible sur les langues à faibles ressources, c’est-à-dire celles pour lesquelles les données d’apprentissage sont moins facilement disponibles. Les performances varient également selon les accents et dialectes de certaines langues, y compris une précision moindre pour les locuteurs de différents sexes, races, âges ou autres critères démographiques (<em>cf.</em> le papier de <a href="https://arxiv.org/pdf/2212.04356.pdf" rel="nofollow">Whisper</a>).
Pour améliorer les performances sur les langues, les accents ou les dialectes à faibles ressources, nous pouvons prendre le modèle Whisper pré-entraîné et l’entraîner sur un petit corpus de données sélectionnées de manière appropriée, dans un processus appelé <em><em>finetuning</em></em>. Nous montrerons qu’avec seulement dix heures de données supplémentaires, nous pouvons améliorer les performances du modèle Whisper de plus de 100% sur une langue à faibles ressources. Dans la section suivante, nous aborderons le processus de sélection d’un jeu de données à <em>finetuner</em>.`,gt,Ze,ft,Xe,vt;return v=new Hn({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),I=new Ae({props:{title:"Modèles pré-entraînés pour la reconnaissance automatique de la parole",local:"modèles-pré-entraînés-pour-la-reconnaissance-automatique-de-la-parole",headingTag:"h1"}}),C=new Ae({props:{title:"Sonder les modèles CTC",local:"sonder-les-modèles-ctc",headingTag:"h2"}}),G=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMEEpJTBBZGF0YXNldA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(
    <span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>
)
dataset`,wrap:!1}}),R=new y({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidmaWxlJyUyQyUyMCdhdWRpbyclMkMlMjAndGV4dCclMkMlMjAnc3BlYWtlcl9pZCclMkMlMjAnY2hhcHRlcl9pZCclMkMlMjAnaWQnJTVEJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA3MyUwQSU3RCk=",highlighted:`<span class="hljs-title function_ invoke__">Dataset</span>({
    <span class="hljs-attr">features</span>: [<span class="hljs-string">&#x27;file&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;speaker_id&#x27;</span>, <span class="hljs-string">&#x27;chapter_id&#x27;</span>, <span class="hljs-string">&#x27;id&#x27;</span>],
    <span class="hljs-attr">num_rows</span>: <span class="hljs-number">73</span>
})`,wrap:!1}}),$=new y({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBc2FtcGxlJTIwJTNEJTIwZGF0YXNldCU1QjIlNUQlMEElMEFwcmludChzYW1wbGUlNUIlMjJ0ZXh0JTIyJTVEKSUwQUF1ZGlvKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMkMlMjByYXRlJTNEc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

sample = dataset[<span class="hljs-number">2</span>]

<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;text&quot;</span>])
Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),W=new y({props:{code:"SEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5E",highlighted:'HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND',wrap:!1}}),H=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMmZhY2Vib29rJTJGd2F2MnZlYzItYmFzZS0xMDBoJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;facebook/wav2vec2-base-100h&quot;</span>)`,wrap:!1}}),Y=new y({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RC5jb3B5KCkpJTBBJTdCJTBBJTIwJTIwJTIwJTIwJTIydGV4dCUyMiUzQSUyMCUyMkhFJTIwVEVMTFMlMjBVUyUyMFRIQVQlMjBBVCUyMFRISVMlMjBGRVNUSVZFJTIwU0VBU09OJTIwT0YlMjBUSEUlMjBZRUFSJTIwV0lUSCUyMENIUklTVE1BVVMlMjBBTkQlMjBST1NFJTIwQkVFRiUyMExPT01JTkclMjBCRUZPUkUlMjBVUyUyMFNJTUFMWUlTJTIwRFJBV04lMjBGUk9NJTIwRUFUSU5HJTIwQU5EJTIwSVRTJTIwUkVTVUxUUyUyME9DQ1VSJTIwTU9TVCUyMFJFQURJTFklMjBUTyUyMFRIRSUyME1JTkQlMjIlMEElN0Q=",highlighted:`pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy())
{
    <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;HE TELLS US THAT AT THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAUS AND ROSE BEEF LOOMING BEFORE US SIMALYIS DRAWN FROM EATING AND ITS RESULTS OCCUR MOST READILY TO THE MIND&quot;</span>
}`,wrap:!1}}),L=new y({props:{code:"VGFyZ2V0JTNBJTIwJTIwJTIwJTIwJTIwJTIwSEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5EJTBBUHJlZGljdGlvbiUzQSUyMCUyMEhFJTIwVEVMTFMlMjBVUyUyMFRIQVQlMjBBVCUyMFRISVMlMjBGRVNUSVZFJTIwU0VBU09OJTIwT0YlMjBUSEUlMjBZRUFSJTIwV0lUSCUyMCoqQ0hSSVNUTUFVUyoqJTIwQU5EJTIwKipST1NFKiolMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwKipTSU1BTFlJUyoqJTIwRFJBV04lMjBGUk9NJTIwRUFUSU5HJTIwQU5EJTIwSVRTJTIwUkVTVUxUUyUyME9DQ1VSJTIwTU9TVCUyMFJFQURJTFklMjBUTyUyMFRIRSUyME1JTkQ=",highlighted:`<span class="hljs-symbol">Target:</span>      HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND
<span class="hljs-symbol">Prediction:</span>  HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH **CHRISTMAUS** <span class="hljs-keyword">AND </span>**ROSE** <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US **SIMALYIS** DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND`,wrap:!1}}),A=new Ae({props:{title:"Passage à Seq2Seq",local:"passage-à-seq2seq",headingTag:"h2"}}),se=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTNBMCUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyb3BlbmFpJTJGd2hpc3Blci1iYXNlJTIyJTJDJTIwZGV2aWNlJTNEZGV2aWNlJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

device = <span class="hljs-string">&quot;cuda:0&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
pipe = pipeline(
    <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;openai/whisper-base&quot;</span>, device=device
)`,wrap:!1}}),ne=new y({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2KQ==",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>], max_new_tokens=<span class="hljs-number">256</span>)',wrap:!1}}),ae=new y({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEhlJTIwdGVsbHMlMjB1cyUyMHRoYXQlMjBhdCUyMHRoaXMlMjBmZXN0aXZlJTIwc2Vhc29uJTIwb2YlMjB0aGUlMjB5ZWFyJTJDJTIwd2l0aCUyMENocmlzdG1hcyUyMGFuZCUyMHJvYXN0JTIwYmVlZiUyMGxvb21pbmclMjBiZWZvcmUlMjB1cyUyQyUyMHNpbWlsYXJseSUyMGlzJTIwZHJhd24lMjBmcm9tJTIwZWF0aW5nJTIwYW5kJTIwaXRzJTIwcmVzdWx0cyUyMG9jY3VyJTIwbW9zdCUyMHJlYWRpbHklMjB0byUyMHRoZSUyMG1pbmQuJyU3RA==",highlighted:'{&#x27;<span class="hljs-built_in">text</span>&#x27;: &#x27; He tells us <span class="hljs-keyword">that</span> <span class="hljs-keyword">at</span> this festive season <span class="hljs-keyword">of</span> <span class="hljs-keyword">the</span> <span class="hljs-built_in">year</span>, <span class="hljs-keyword">with</span> Christmas <span class="hljs-keyword">and</span> roast beef looming <span class="hljs-keyword">before</span> us, similarly <span class="hljs-keyword">is</span> drawn <span class="hljs-keyword">from</span> eating <span class="hljs-keyword">and</span> <span class="hljs-keyword">its</span> results occur most readily <span class="hljs-keyword">to</span> <span class="hljs-keyword">the</span> mind.&#x27;}',wrap:!1}}),ie=new y({props:{code:"VGFyZ2V0JTNBJTIwJTIwJTIwJTIwJTIwSEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5EJTBBUHJlZGljdGlvbiUzQSUyMEhlJTIwdGVsbHMlMjB1cyUyMHRoYXQlMjBhdCUyMHRoaXMlMjBmZXN0aXZlJTIwc2Vhc29uJTIwb2YlMjB0aGUlMjB5ZWFyJTJDJTIwd2l0aCUyMCoqQ2hyaXN0bWFzKiolMjBhbmQlMjAqKnJvYXN0KiolMjBiZWVmJTIwbG9vbWluZyUyMGJlZm9yZSUyMHVzJTJDJTIwKipzaW1pbGFybHkqKiUyMGlzJTIwZHJhd24lMjBmcm9tJTIwZWF0aW5nJTIwYW5kJTIwaXRzJTIwcmVzdWx0cyUyMG9jY3VyJTIwbW9zdCUyMHJlYWRpbHklMjB0byUyMHRoZSUyMG1pbmQu",highlighted:`<span class="hljs-symbol">Target:</span>     HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND
<span class="hljs-symbol">Prediction:</span> He tells us that <span class="hljs-built_in">at</span> this festive season of the year, with **Christmas** <span class="hljs-keyword">and </span>**roast** <span class="hljs-keyword">beef </span>looming <span class="hljs-keyword">before </span>us, **similarly** is drawn from eating <span class="hljs-keyword">and </span>its results occur most readily to the mind.`,wrap:!1}}),pe=new y({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm11bHRpbGluZ3VhbF9saWJyaXNwZWVjaCUyMiUyQyUyMCUyMnNwYW5pc2glMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlJTBBKSUwQXNhbXBsZSUyMCUzRCUyMG5leHQoaXRlcihkYXRhc2V0KSk=",highlighted:`dataset = load_dataset(
    <span class="hljs-string">&quot;facebook/multilingual_librispeech&quot;</span>, <span class="hljs-string">&quot;spanish&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>
)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))`,wrap:!1}}),de=new y({props:{code:"cHJpbnQoc2FtcGxlJTVCJTIydGV4dCUyMiU1RCklMEFBdWRpbyhzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmF0ZSUzRHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCk=",highlighted:`<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;text&quot;</span>])
Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),me=new y({props:{code:"ZW50b25jZXMlMjB0ZSUyMGRlbGVsaXRhciVDMyVBMXMlMjBlbiUyMGplaG92JUMzJUExJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMjB5JTIwdGUlMjBkYXIlQzMlQTklMjAlQzMlQTElMjBjb21lciUyMGxhJTIwaGVyZWRhZCUyMGRlJTIwamFjb2IlMjB0dSUyMHBhZHJlJTIwcG9ycXVlJTIwbGElMjBib2NhJTIwZGUlMjBqZWhvdiVDMyVBMSUyMGxvJTIwaGElMjBoYWJsYWRv",highlighted:'entonces <span class="hljs-keyword">te</span> delelitarás <span class="hljs-keyword">en</span> jehová y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra y <span class="hljs-keyword">te</span> daré á comer <span class="hljs-keyword">la</span> heredad <span class="hljs-keyword">de</span> jacob tu padre porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> jehová lo ha hablado',wrap:!1}}),he=new y({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RC5jb3B5KCklMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1NiUyQyUyMGdlbmVyYXRlX2t3YXJncyUzRCU3QiUyMnRhc2slMjIlM0ElMjAlMjJ0cmFuc2NyaWJlJTIyJTdEKQ==",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy(), max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>})',wrap:!1}}),Te=new y({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEVudG9uY2VzJTIwdGUlMjBkZWxlaXRhciVDMyVBMXMlMjBlbiUyMEplaG92JUMzJUExJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMjB5JTIwdGUlMjBkYXIlQzMlQTklMjBhJTIwY29tZXIlMjBsYSUyMGhlcmVkYWQlMjBkZSUyMEphY29iJTIwdHUlMjBwYWRyZSUyMHBvcnF1ZSUyMGxhJTIwYm9jYSUyMGRlJTIwSmVob3YlQzMlQTElMjBsbyUyMGhhJTIwaGFibGFkby4nJTdE",highlighted:'{&#x27;text&#x27;: &#x27; Entonces <span class="hljs-keyword">te</span> deleitarás <span class="hljs-keyword">en</span> Jehová y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra y <span class="hljs-keyword">te</span> daré a comer <span class="hljs-keyword">la</span> heredad <span class="hljs-keyword">de</span> Jacob tu padre porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> Jehová lo ha hablado.&#x27;}',wrap:!1}}),Je=new y({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2JTJDJTIwZ2VuZXJhdGVfa3dhcmdzJTNEJTdCJTIydGFzayUyMiUzQSUyMCUyMnRyYW5zbGF0ZSUyMiU3RCk=",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>], max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;translate&quot;</span>})',wrap:!1}}),we=new y({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMFNvJTIweW91JTIwd2lsbCUyMGNob29zZSUyMGluJTIwSmVob3ZhaCUyMGFuZCUyMEklMjB3aWxsJTIwcmFpc2UlMjB5b3UlMjBvbiUyMHRoZSUyMGhlaWdodHMlMjBvZiUyMHRoZSUyMGVhcnRoJTIwYW5kJTIwSSUyMHdpbGwlMjBnaXZlJTIweW91JTIwdGhlJTIwaG9ub3IlMjBvZiUyMEphY29iJTIwdG8lMjB5b3VyJTIwZmF0aGVyJTIwYmVjYXVzZSUyMHRoZSUyMHZvaWNlJTIwb2YlMjBKZWhvdmFoJTIwaGFzJTIwc3Bva2VuJTIwdG8lMjB5b3UuJyU3RA==",highlighted:'<span class="hljs-comment">{&#x27;text&#x27;: &#x27; So you will choose in Jehovah and I will raise you on the heights of the earth and I will give you the honor of Jacob to your father because the voice of Jehovah has spoken to you.&#x27;}</span>',wrap:!1}}),ge=new Ae({props:{title:"Longue transcription et horodatage",local:"longue-transcription-et-horodatage",headingTag:"h2"}}),ve=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBdGFyZ2V0X2xlbmd0aF9pbl9tJTIwJTNEJTIwNSUwQSUwQSUyMyUyMGNvbnZlcnRpciUyMGxlcyUyMG1pbnV0ZXMlMjBlbiUyMHNlY29uZGVzJTIwKColMjA2MCklMjBlbiUyMG5vbWJyZSUyMGQnJUMzJUE5Y2hhbnRpbGxvbnMlMjAoKiUyMHRhdXglMjBkJyVDMyVBOWNoYW50aWxsb25uYWdlKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBwaXBlLmZlYXR1cmVfZXh0cmFjdG9yLnNhbXBsaW5nX3JhdGUlMEF0YXJnZXRfbGVuZ3RoX2luX3NhbXBsZXMlMjAlM0QlMjB0YXJnZXRfbGVuZ3RoX2luX20lMjAqJTIwNjAlMjAqJTIwc2FtcGxpbmdfcmF0ZSUwQSUwQSUyMyUyMGl0JUMzJUE5cmVyJTIwc3VyJTIwbm90cmUlMjBqZXUlMjBkZSUyMGRvbm4lQzMlQTllcyUyMGVuJTIwc3RyZWFtaW5nJTJDJTIwZW4lMjBjb25jYXQlQzMlQTluYW50JTIwbGVzJTIwJUMzJUE5Y2hhbnRpbGxvbnMlMjBqdXNxdSclQzMlQTAlMjBjZSUyMHF1ZSUyMG5vdXMlMjBhdHRlaWduaW9ucyUyMG5vdHJlJTIwY2libGUlMEFsb25nX2F1ZGlvJTIwJTNEJTIwJTVCJTVEJTBBZm9yJTIwc2FtcGxlJTIwaW4lMjBkYXRhc2V0JTNBJTBBJTIwJTIwJTIwJTIwbG9uZ19hdWRpby5leHRlbmQoc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCklMEElMjAlMjAlMjAlMjBpZiUyMGxlbihsb25nX2F1ZGlvKSUyMCUzRSUyMHRhcmdldF9sZW5ndGhfaW5fc2FtcGxlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBbG9uZ19hdWRpbyUyMCUzRCUyMG5wLmFzYXJyYXkobG9uZ19hdWRpbyklMEElMEElMjMlMjBSJUMzJUE5c3VsdGF0JTBBc2Vjb25kcyUyMCUzRCUyMGxlbihsb25nX2F1ZGlvKSUyMCUyRiUyMDE2MDAwJTBBbWludXRlcyUyQyUyMHNlY29uZHMlMjAlM0QlMjBkaXZtb2Qoc2Vjb25kcyUyQyUyMDYwKSUwQXByaW50KGYlMjJMZW5ndGglMjBvZiUyMGF1ZGlvJTIwc2FtcGxlJTIwaXMlMjAlN0JtaW51dGVzJTdEJTIwbWludXRlcyUyMCU3QnNlY29uZHMlM0EuMmYlN0QlMjBzZWNvbmRzJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

target_length_in_m = <span class="hljs-number">5</span>

<span class="hljs-comment"># convertir les minutes en secondes (* 60) en nombre d&#x27;échantillons (* taux d&#x27;échantillonnage)</span>
sampling_rate = pipe.feature_extractor.sampling_rate
target_length_in_samples = target_length_in_m * <span class="hljs-number">60</span> * sampling_rate

<span class="hljs-comment"># itérer sur notre jeu de données en streaming, en concaténant les échantillons jusqu&#x27;à ce que nous atteignions notre cible</span>
long_audio = []
<span class="hljs-keyword">for</span> sample <span class="hljs-keyword">in</span> dataset:
    long_audio.extend(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(long_audio) &gt; target_length_in_samples:
        <span class="hljs-keyword">break</span>

long_audio = np.asarray(long_audio)

<span class="hljs-comment"># Résultat</span>
seconds = <span class="hljs-built_in">len</span>(long_audio) / <span class="hljs-number">16000</span>
minutes, seconds = <span class="hljs-built_in">divmod</span>(seconds, <span class="hljs-number">60</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Length of audio sample is <span class="hljs-subst">{minutes}</span> minutes <span class="hljs-subst">{seconds:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)`,wrap:!1}}),Se=new y({props:{code:"TGVuZ3RoJTIwb2YlMjBhdWRpbyUyMHNhbXBsZSUyMGlzJTIwNS4wJTIwbWludXRlcyUyMDE3LjIyJTIwc2Vjb25kcw==",highlighted:'<span class="hljs-attribute">Length</span> of audio sample is <span class="hljs-number">5</span>.<span class="hljs-number">0</span> minutes <span class="hljs-number">17</span>.<span class="hljs-number">22</span> seconds',wrap:!1}}),Ee=new y({props:{code:"cGlwZSglMEElMjAlMjAlMjAlMjBsb25nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNjcmliZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSk=",highlighted:`pipe(
    long_audio,
    max_new_tokens=<span class="hljs-number">256</span>,
    generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
    chunk_length_s=<span class="hljs-number">30</span>,
    batch_size=<span class="hljs-number">8</span>,
)`,wrap:!1}}),ke=new y({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEVudG9uY2VzJTIwdGUlMjBkZWxlaXRhciVDMyVBMXMlMjBlbiUyMEplaG92JUMzJUExJTJDJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMkMlMjB5JTIwdGUlMjBkYXIlQzMlQTklMjBhJTIwY29tZXIlMjBsYSUwQWhlcmVkYWQlMjBkZSUyMEphY29iJTIwdHUlMjBwYWRyZSUyQyUyMHBvcnF1ZSUyMGxhJTIwYm9jYSUyMGRlJTIwSmVob3YlQzMlQTElMjBsbyUyMGhhJTIwaGFibGFkby4lMjBub3NvdHJvcyUyMGN1cmFkb3MuJTIwVG9kb3MlMjBub3NvdHJvcyUyMG5vcyUyMGRlc2NhcnJpYW1vcyUwQWNvbW8lMjBiZWphcyUyQyUyMGNhZGElMjBjdWFsJTIwc2UlMjBhcGFydCVDMyVCMyUyMHBvciUyMHN1JTIwY2FtaW5vJTJDJTIwbWFzJTIwSmVob3YlQzMlQTElMjBjYXJnJUMzJUIzJTIwZW4lMjAlQzMlQTlsJTIwZWwlMjBwZWNhZG8lMjBkZSUyMHRvZG9zJTIwbm9zb3Ryb3MuLi4=",highlighted:`{&#x27;text&#x27;: &#x27; Entonces <span class="hljs-keyword">te</span> deleitarás <span class="hljs-keyword">en</span> Jehová, y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra, y <span class="hljs-keyword">te</span> daré a comer <span class="hljs-keyword">la</span>
heredad <span class="hljs-keyword">de</span> Jacob tu padre, porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> Jehová lo ha hablado. nosotros curados. Todos nosotros nos descarriamos
como bejas, cada cual <span class="hljs-keyword">se</span> apartó por <span class="hljs-keyword">su</span> camino, mas Jehová cargó <span class="hljs-keyword">en</span> é<span class="hljs-keyword">l</span> el pecado <span class="hljs-keyword">de</span> todos nosotros...`,wrap:!1}}),qe=new y({props:{code:"cGlwZSglMEElMjAlMjAlMjAlMjBsb25nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNjcmliZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl90aW1lc3RhbXBzJTNEVHJ1ZSUyQyUwQSklNUIlMjJjaHVua3MlMjIlNUQ=",highlighted:`pipe(
    long_audio,
    max_new_tokens=<span class="hljs-number">256</span>,
    generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
    chunk_length_s=<span class="hljs-number">30</span>,
    batch_size=<span class="hljs-number">8</span>,
    return_timestamps=<span class="hljs-literal">True</span>,
)[<span class="hljs-string">&quot;chunks&quot;</span>]`,wrap:!1}}),Ve=new y({props:{code:"JTVCJTdCJ3RpbWVzdGFtcCclM0ElMjAoMC4wJTJDJTIwMjYuNCklMkMlMEElMjAlMjAndGV4dCclM0ElMjAnJTIwRW50b25jZXMlMjB0ZSUyMGRlbGVpdGFyJUMzJUExcyUyMGVuJTIwSmVob3YlQzMlQTElMkMlMjB5JTIweW8lMjB0ZSUyMGhhciVDMyVBOSUyMHN1YmlyJTIwc29icmUlMjBsYXMlMjBhbHR1cmFzJTIwZGUlMjBsYSUyMHRpZXJyYSUyQyUyMHklMjB0ZSUyMGRhciVDMyVBOSUyMGElMjBjb21lciUyMGxhJTIwaGVyZWRhZCUyMGRlJTIwSmFjb2IlMjB0dSUyMHBhZHJlJTJDJTIwcG9ycXVlJTIwbGElMjBib2NhJTIwZGUlMjBKZWhvdiVDMyVBMSUyMGxvJTIwaGElMjBoYWJsYWRvLiUyMG5vc290cm9zJTIwY3VyYWRvcy4lMjBUb2RvcyUyMG5vc290cm9zJTIwbm9zJTIwZGVzY2FycmlhbW9zJTIwY29tbyUyMGJlamFzJTJDJTIwY2FkYSUyMGN1YWwlMjBzZSUyMGFwYXJ0JUMzJUIzJTIwcG9yJTIwc3UlMjBjYW1pbm8lMkMnJTdEJTJDJTBBJTIwJTdCJ3RpbWVzdGFtcCclM0ElMjAoMjYuNCUyQyUyMDMyLjQ4KSUyQyUwQSUyMCUyMCd0ZXh0JyUzQSUyMCclMjBtYXMlMjBKZWhvdiVDMyVBMSUyMGNhcmclQzMlQjMlMjBlbiUyMCVDMyVBOWwlMjBlbCUyMHBlY2FkbyUyMGRlJTIwdG9kb3MlMjBub3NvdHJvcy4lMjBObyUyMGVzJTIwcXVlJTIwcGFydGFzJTIwdHUlMjBwYW4lMjBjb24lMjBlbCclN0QlMkMlMEElMjAlN0IndGltZXN0YW1wJyUzQSUyMCgzMi40OCUyQyUyMDM4LjQpJTJDJTBBJTIwJTIwJ3RleHQnJTNBJTIwJyUyMGhhbWJyaWVudG8lMjB5JTIwYSUyMGxvcyUyMGhvbWJyZXMlMjBoZXJyYW50ZXMlMjBtZXRhcyUyMGVuJTIwY2FzYSUyQyUyMHF1ZSUyMGN1YW5kbyUyMHZpZXJlcyUyMGFsJTIwZGVzbnVkbyUyMGxvJTIwY3VicmFzJTIweSUyMG5vJyU3RCUyQyUwQSUyMC4uLg==",highlighted:`[{<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">0.0</span>, <span class="hljs-number">26.4</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; Entonces te deleitarás en Jehová, y yo te haré subir sobre las alturas de la tierra, y te daré a comer la heredad de Jacob tu padre, porque la boca de Jehová lo ha hablado. nosotros curados. Todos nosotros nos descarriamos como bejas, cada cual se apartó por su camino,&#x27;},
 {<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">26.4</span>, <span class="hljs-number">32.48</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; mas Jehová cargó en él el pecado de todos nosotros. No es que partas tu pan con el&#x27;},
 {<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">32.48</span>, <span class="hljs-number">38.4</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; hambriento y a los hombres herrantes metas en casa, que cuando vieres al desnudo lo cubras y no&#x27;},
 ...`,wrap:!1}}),Fe=new Ae({props:{title:"Résumé",local:"résumé",headingTag:"h2"}}),Ze=new Nn({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/fr/chapter5/asr_models.mdx"}}),{c(){w=o("meta"),Pe=l(),ze=o("p"),Oe=l(),p(v.$$.fragment),De=l(),p(I.$$.fragment),Ke=l(),S=o("p"),S.innerHTML=$t,es=l(),x=o("p"),x.textContent=Ft,ss=l(),B=o("ol"),B.innerHTML=Wt,ts=l(),E=o("p"),E.innerHTML=Zt,ns=l(),p(C.$$.fragment),ls=l(),k=o("p"),k.innerHTML=Ht,as=l(),p(G.$$.fragment),os=l(),q=o("p"),q.innerHTML=Nt,is=l(),p(R.$$.fragment),rs=l(),V=o("p"),V.textContent=Yt,ps=l(),p($.$$.fragment),us=l(),F=o("p"),F.innerHTML=Qt,ds=l(),p(W.$$.fragment),cs=l(),Z=o("p"),Z.innerHTML=Lt,ms=l(),p(H.$$.fragment),Ms=l(),N=o("p"),N.innerHTML=_t,hs=l(),p(Y.$$.fragment),ys=l(),Q=o("p"),Q.textContent=zt,Ts=l(),p(L.$$.fragment),Us=l(),_=o("p"),_.innerHTML=Xt,Js=l(),z=o("ul"),z.innerHTML=At,js=l(),b=o("div"),b.innerHTML=Pt,ws=l(),X=o("p"),X.innerHTML=Ot,bs=l(),p(A.$$.fragment),gs=l(),P=o("p"),P.innerHTML=Dt,fs=l(),O=o("ol"),O.innerHTML=Kt,vs=l(),D=o("p"),D.innerHTML=en,Is=l(),K=o("table"),K.innerHTML=sn,Ss=l(),ee=o("p"),ee.innerHTML=tn,xs=l(),p(se.$$.fragment),Bs=l(),te=o("p"),te.innerHTML=nn,Es=l(),p(ne.$$.fragment),Cs=l(),le=o("p"),le.innerHTML=ln,ks=l(),p(ae.$$.fragment),Gs=l(),oe=o("p"),oe.textContent=an,qs=l(),p(ie.$$.fragment),Rs=l(),re=o("p"),re.innerHTML=on,Vs=l(),p(pe.$$.fragment),$s=l(),ue=o("p"),ue.textContent=rn,Fs=l(),p(de.$$.fragment),Ws=l(),ce=o("p"),ce.innerHTML=pn,Zs=l(),p(me.$$.fragment),Hs=l(),Me=o("p"),Me.innerHTML=un,Ns=l(),p(he.$$.fragment),Ys=l(),ye=o("p"),ye.innerHTML=dn,Qs=l(),p(Te.$$.fragment),Ls=l(),Ue=o("p"),Ue.innerHTML=cn,_s=l(),p(Je.$$.fragment),zs=l(),je=o("p"),je.innerHTML=mn,Xs=l(),p(we.$$.fragment),As=l(),be=o("p"),be.innerHTML=Mn,Ps=l(),p(ge.$$.fragment),Os=l(),fe=o("p"),fe.textContent=hn,Ds=l(),p(ve.$$.fragment),Ks=l(),Ie=o("p"),Ie.innerHTML=yn,et=l(),p(Se.$$.fragment),st=l(),xe=o("p"),xe.textContent=Tn,tt=l(),Be=o("ol"),Be.innerHTML=Un,nt=l(),g=o("div"),g.innerHTML=Jn,lt=l(),h=o("p"),xt=J("L’avantage de segmenter les échantillons est que nous n’avons pas besoin du résultat du bloc"),at=new It(!1),ot=J(" pour transcrire le morceau suivant"),it=new It(!1),rt=J(". La couture est effectuée après que nous ayons transcrit tous les morceaux aux bornes des morceaux. Donc peu importe l’ordre dans lequel nous transcrivons les morceaux. L’algorithme est entièrement "),He=o("strong"),He.textContent=jn,Bt=J(", donc nous pouvons même faire du découpage sur"),pt=new It(!1),ut=J(" en même temps que du découpage sur"),dt=new It(!1),ct=J(" ! Cela nous permet de former des "),Ne=o("em"),Ne.textContent=wn,Et=J(" de morceaux et de les exécuter dans le modèle en parallèle, offrant une grande accélération de calcul par rapport à leur transcription séquentielle. Pour en savoir plus sur la segmentation d’audio dans 🤗 "),Ye=o("em"),Ye.textContent=bn,Ct=J(", vous pouvez vous référer à cet [article de blog] ("),f=o("a"),f.textContent=gn,kt=J(`) (en anglais).
Pour activer les longues transcriptions, nous devons ajouter un argument supplémentaire lorsque nous appelons le pipeline. Cet argument, `),Qe=o("code"),Qe.textContent=fn,Gt=J(`, contrôle la longueur des segments divisés en secondes. Pour Whisper, des morceaux de 30 secondes sont optimaux, car cela correspond à la longueur d’entrée attendue par Whisper.
Pour activer le traitement par batch, nous devons passer l’argument `),Le=o("code"),Le.textContent=vn,qt=J(" au pipeline. En mettant tout cela ensemble, nous pouvons transcrire le long échantillon audio comme suit:"),mt=l(),p(Ee.$$.fragment),Mt=l(),Ce=o("p"),Ce.innerHTML=In,ht=l(),p(ke.$$.fragment),yt=l(),Ge=o("p"),Ge.innerHTML=Sn,Tt=l(),p(qe.$$.fragment),Ut=l(),Re=o("p"),Re.innerHTML=xn,Jt=l(),p(Ve.$$.fragment),jt=l(),$e=o("p"),$e.textContent=Bn,wt=l(),p(Fe.$$.fragment),bt=l(),We=o("p"),We.innerHTML=En,gt=l(),p(Ze.$$.fragment),ft=l(),Xe=o("p"),this.h()},l(e){const s=Zn("svelte-u9bgzb",document.head);w=i(s,"META",{name:!0,content:!0}),s.forEach(t),Pe=a(e),ze=i(e,"P",{}),Rt(ze).forEach(t),Oe=a(e),u(v.$$.fragment,e),De=a(e),u(I.$$.fragment,e),Ke=a(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-3vbmup"&&(S.innerHTML=$t),es=a(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1hil8d"&&(x.textContent=Ft),ss=a(e),B=i(e,"OL",{"data-svelte-h":!0}),r(B)!=="svelte-1n4dhmh"&&(B.innerHTML=Wt),ts=a(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1u61o1g"&&(E.innerHTML=Zt),ns=a(e),u(C.$$.fragment,e),ls=a(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1gr743m"&&(k.innerHTML=Ht),as=a(e),u(G.$$.fragment,e),os=a(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-dbzevp"&&(q.innerHTML=Nt),is=a(e),u(R.$$.fragment,e),rs=a(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1a8dqyk"&&(V.textContent=Yt),ps=a(e),u($.$$.fragment,e),us=a(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-dbzevp"&&(F.innerHTML=Qt),ds=a(e),u(W.$$.fragment,e),cs=a(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-dkq6xg"&&(Z.innerHTML=Lt),ms=a(e),u(H.$$.fragment,e),Ms=a(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1anz7jf"&&(N.innerHTML=_t),hs=a(e),u(Y.$$.fragment,e),ys=a(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1qo7344"&&(Q.textContent=zt),Ts=a(e),u(L.$$.fragment,e),Us=a(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-rp0hzj"&&(_.innerHTML=Xt),Js=a(e),z=i(e,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-64w2eh"&&(z.innerHTML=At),js=a(e),b=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-koi3b6"&&(b.innerHTML=Pt),ws=a(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-13smvyy"&&(X.innerHTML=Ot),bs=a(e),u(A.$$.fragment,e),gs=a(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-ybukjk"&&(P.innerHTML=Dt),fs=a(e),O=i(e,"OL",{"data-svelte-h":!0}),r(O)!=="svelte-m4uc4o"&&(O.innerHTML=Kt),vs=a(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-19vk3ts"&&(D.innerHTML=en),Is=a(e),K=i(e,"TABLE",{"data-svelte-h":!0}),r(K)!=="svelte-1gqxr00"&&(K.innerHTML=sn),Ss=a(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1gihkbk"&&(ee.innerHTML=tn),xs=a(e),u(se.$$.fragment,e),Bs=a(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1ycfnts"&&(te.innerHTML=nn),Es=a(e),u(ne.$$.fragment,e),Cs=a(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-dbzevp"&&(le.innerHTML=ln),ks=a(e),u(ae.$$.fragment,e),Gs=a(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1lwymx8"&&(oe.textContent=an),qs=a(e),u(ie.$$.fragment,e),Rs=a(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-99semi"&&(re.innerHTML=on),Vs=a(e),u(pe.$$.fragment,e),$s=a(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1e3nkoe"&&(ue.textContent=rn),Fs=a(e),u(de.$$.fragment,e),Ws=a(e),ce=i(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-dbzevp"&&(ce.innerHTML=pn),Zs=a(e),u(me.$$.fragment,e),Hs=a(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1vlpheo"&&(Me.innerHTML=un),Ns=a(e),u(he.$$.fragment,e),Ys=a(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-dbzevp"&&(ye.innerHTML=dn),Qs=a(e),u(Te.$$.fragment,e),Ls=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1kcg18j"&&(Ue.innerHTML=cn),_s=a(e),u(Je.$$.fragment,e),zs=a(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-dbzevp"&&(je.innerHTML=mn),Xs=a(e),u(we.$$.fragment,e),As=a(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1yhnauy"&&(be.innerHTML=Mn),Ps=a(e),u(ge.$$.fragment,e),Os=a(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-vcnxm4"&&(fe.textContent=hn),Ds=a(e),u(ve.$$.fragment,e),Ks=a(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-dbzevp"&&(Ie.innerHTML=yn),et=a(e),u(Se.$$.fragment,e),st=a(e),xe=i(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1y5e1ug"&&(xe.textContent=Tn),tt=a(e),Be=i(e,"OL",{"data-svelte-h":!0}),r(Be)!=="svelte-1qi514d"&&(Be.innerHTML=Un),nt=a(e),g=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-dbmn5s"&&(g.innerHTML=Jn),lt=a(e),h=i(e,"P",{});var T=Rt(h);xt=j(T,"L’avantage de segmenter les échantillons est que nous n’avons pas besoin du résultat du bloc"),at=St(T,!1),ot=j(T," pour transcrire le morceau suivant"),it=St(T,!1),rt=j(T,". La couture est effectuée après que nous ayons transcrit tous les morceaux aux bornes des morceaux. Donc peu importe l’ordre dans lequel nous transcrivons les morceaux. L’algorithme est entièrement "),He=i(T,"STRONG",{"data-svelte-h":!0}),r(He)!=="svelte-1kau282"&&(He.textContent=jn),Bt=j(T,", donc nous pouvons même faire du découpage sur"),pt=St(T,!1),ut=j(T," en même temps que du découpage sur"),dt=St(T,!1),ct=j(T," ! Cela nous permet de former des "),Ne=i(T,"EM",{"data-svelte-h":!0}),r(Ne)!=="svelte-1swb9sm"&&(Ne.textContent=wn),Et=j(T," de morceaux et de les exécuter dans le modèle en parallèle, offrant une grande accélération de calcul par rapport à leur transcription séquentielle. Pour en savoir plus sur la segmentation d’audio dans 🤗 "),Ye=i(T,"EM",{"data-svelte-h":!0}),r(Ye)!=="svelte-1c497z6"&&(Ye.textContent=bn),Ct=j(T,", vous pouvez vous référer à cet [article de blog] ("),f=i(T,"A",{href:!0,rel:!0,"data-svelte-h":!0}),r(f)!=="svelte-wh64se"&&(f.textContent=gn),kt=j(T,`) (en anglais).
Pour activer les longues transcriptions, nous devons ajouter un argument supplémentaire lorsque nous appelons le pipeline. Cet argument, `),Qe=i(T,"CODE",{"data-svelte-h":!0}),r(Qe)!=="svelte-1ihfftk"&&(Qe.textContent=fn),Gt=j(T,`, contrôle la longueur des segments divisés en secondes. Pour Whisper, des morceaux de 30 secondes sont optimaux, car cela correspond à la longueur d’entrée attendue par Whisper.
Pour activer le traitement par batch, nous devons passer l’argument `),Le=i(T,"CODE",{"data-svelte-h":!0}),r(Le)!=="svelte-1grlmso"&&(Le.textContent=vn),qt=j(T," au pipeline. En mettant tout cela ensemble, nous pouvons transcrire le long échantillon audio comme suit:"),T.forEach(t),mt=a(e),u(Ee.$$.fragment,e),Mt=a(e),Ce=i(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-dbzevp"&&(Ce.innerHTML=In),ht=a(e),u(ke.$$.fragment,e),yt=a(e),Ge=i(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-zgfrlv"&&(Ge.innerHTML=Sn),Tt=a(e),u(qe.$$.fragment,e),Ut=a(e),Re=i(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-dbzevp"&&(Re.innerHTML=xn),Jt=a(e),u(Ve.$$.fragment,e),jt=a(e),$e=i(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1q3v7dp"&&($e.textContent=Bn),wt=a(e),u(Fe.$$.fragment,e),bt=a(e),We=i(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-2z7mlq"&&(We.innerHTML=En),gt=a(e),u(Ze.$$.fragment,e),ft=a(e),Xe=i(e,"P",{}),Rt(Xe).forEach(t),this.h()},h(){_e(w,"name","hf:doc:metadata"),_e(w,"content",Qn),_e(b,"class","flex justify-center"),_e(g,"class","flex justify-center"),at.a=ot,it.a=rt,pt.a=ut,dt.a=ct,_e(f,"href","https://huggingface.co/blog/asr-chunking"),_e(f,"rel","nofollow")},m(e,s){U(document.head,w),n(e,Pe,s),n(e,ze,s),n(e,Oe,s),d(v,e,s),n(e,De,s),d(I,e,s),n(e,Ke,s),n(e,S,s),n(e,es,s),n(e,x,s),n(e,ss,s),n(e,B,s),n(e,ts,s),n(e,E,s),n(e,ns,s),d(C,e,s),n(e,ls,s),n(e,k,s),n(e,as,s),d(G,e,s),n(e,os,s),n(e,q,s),n(e,is,s),d(R,e,s),n(e,rs,s),n(e,V,s),n(e,ps,s),d($,e,s),n(e,us,s),n(e,F,s),n(e,ds,s),d(W,e,s),n(e,cs,s),n(e,Z,s),n(e,ms,s),d(H,e,s),n(e,Ms,s),n(e,N,s),n(e,hs,s),d(Y,e,s),n(e,ys,s),n(e,Q,s),n(e,Ts,s),d(L,e,s),n(e,Us,s),n(e,_,s),n(e,Js,s),n(e,z,s),n(e,js,s),n(e,b,s),n(e,ws,s),n(e,X,s),n(e,bs,s),d(A,e,s),n(e,gs,s),n(e,P,s),n(e,fs,s),n(e,O,s),n(e,vs,s),n(e,D,s),n(e,Is,s),n(e,K,s),n(e,Ss,s),n(e,ee,s),n(e,xs,s),d(se,e,s),n(e,Bs,s),n(e,te,s),n(e,Es,s),d(ne,e,s),n(e,Cs,s),n(e,le,s),n(e,ks,s),d(ae,e,s),n(e,Gs,s),n(e,oe,s),n(e,qs,s),d(ie,e,s),n(e,Rs,s),n(e,re,s),n(e,Vs,s),d(pe,e,s),n(e,$s,s),n(e,ue,s),n(e,Fs,s),d(de,e,s),n(e,Ws,s),n(e,ce,s),n(e,Zs,s),d(me,e,s),n(e,Hs,s),n(e,Me,s),n(e,Ns,s),d(he,e,s),n(e,Ys,s),n(e,ye,s),n(e,Qs,s),d(Te,e,s),n(e,Ls,s),n(e,Ue,s),n(e,_s,s),d(Je,e,s),n(e,zs,s),n(e,je,s),n(e,Xs,s),d(we,e,s),n(e,As,s),n(e,be,s),n(e,Ps,s),d(ge,e,s),n(e,Os,s),n(e,fe,s),n(e,Ds,s),d(ve,e,s),n(e,Ks,s),n(e,Ie,s),n(e,et,s),d(Se,e,s),n(e,st,s),n(e,xe,s),n(e,tt,s),n(e,Be,s),n(e,nt,s),n(e,g,s),n(e,lt,s),n(e,h,s),U(h,xt),at.m(Cn,h),U(h,ot),it.m(kn,h),U(h,rt),U(h,He),U(h,Bt),pt.m(Gn,h),U(h,ut),dt.m(qn,h),U(h,ct),U(h,Ne),U(h,Et),U(h,Ye),U(h,Ct),U(h,f),U(h,kt),U(h,Qe),U(h,Gt),U(h,Le),U(h,qt),n(e,mt,s),d(Ee,e,s),n(e,Mt,s),n(e,Ce,s),n(e,ht,s),d(ke,e,s),n(e,yt,s),n(e,Ge,s),n(e,Tt,s),d(qe,e,s),n(e,Ut,s),n(e,Re,s),n(e,Jt,s),d(Ve,e,s),n(e,jt,s),n(e,$e,s),n(e,wt,s),d(Fe,e,s),n(e,bt,s),n(e,We,s),n(e,gt,s),d(Ze,e,s),n(e,ft,s),n(e,Xe,s),vt=!0},p:Vn,i(e){vt||(c(v.$$.fragment,e),c(I.$$.fragment,e),c(C.$$.fragment,e),c(G.$$.fragment,e),c(R.$$.fragment,e),c($.$$.fragment,e),c(W.$$.fragment,e),c(H.$$.fragment,e),c(Y.$$.fragment,e),c(L.$$.fragment,e),c(A.$$.fragment,e),c(se.$$.fragment,e),c(ne.$$.fragment,e),c(ae.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),c(de.$$.fragment,e),c(me.$$.fragment,e),c(he.$$.fragment,e),c(Te.$$.fragment,e),c(Je.$$.fragment,e),c(we.$$.fragment,e),c(ge.$$.fragment,e),c(ve.$$.fragment,e),c(Se.$$.fragment,e),c(Ee.$$.fragment,e),c(ke.$$.fragment,e),c(qe.$$.fragment,e),c(Ve.$$.fragment,e),c(Fe.$$.fragment,e),c(Ze.$$.fragment,e),vt=!0)},o(e){m(v.$$.fragment,e),m(I.$$.fragment,e),m(C.$$.fragment,e),m(G.$$.fragment,e),m(R.$$.fragment,e),m($.$$.fragment,e),m(W.$$.fragment,e),m(H.$$.fragment,e),m(Y.$$.fragment,e),m(L.$$.fragment,e),m(A.$$.fragment,e),m(se.$$.fragment,e),m(ne.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),m(pe.$$.fragment,e),m(de.$$.fragment,e),m(me.$$.fragment,e),m(he.$$.fragment,e),m(Te.$$.fragment,e),m(Je.$$.fragment,e),m(we.$$.fragment,e),m(ge.$$.fragment,e),m(ve.$$.fragment,e),m(Se.$$.fragment,e),m(Ee.$$.fragment,e),m(ke.$$.fragment,e),m(qe.$$.fragment,e),m(Ve.$$.fragment,e),m(Fe.$$.fragment,e),m(Ze.$$.fragment,e),vt=!1},d(e){e&&(t(Pe),t(ze),t(Oe),t(De),t(Ke),t(S),t(es),t(x),t(ss),t(B),t(ts),t(E),t(ns),t(ls),t(k),t(as),t(os),t(q),t(is),t(rs),t(V),t(ps),t(us),t(F),t(ds),t(cs),t(Z),t(ms),t(Ms),t(N),t(hs),t(ys),t(Q),t(Ts),t(Us),t(_),t(Js),t(z),t(js),t(b),t(ws),t(X),t(bs),t(gs),t(P),t(fs),t(O),t(vs),t(D),t(Is),t(K),t(Ss),t(ee),t(xs),t(Bs),t(te),t(Es),t(Cs),t(le),t(ks),t(Gs),t(oe),t(qs),t(Rs),t(re),t(Vs),t($s),t(ue),t(Fs),t(Ws),t(ce),t(Zs),t(Hs),t(Me),t(Ns),t(Ys),t(ye),t(Qs),t(Ls),t(Ue),t(_s),t(zs),t(je),t(Xs),t(As),t(be),t(Ps),t(Os),t(fe),t(Ds),t(Ks),t(Ie),t(et),t(st),t(xe),t(tt),t(Be),t(nt),t(g),t(lt),t(h),t(mt),t(Mt),t(Ce),t(ht),t(yt),t(Ge),t(Tt),t(Ut),t(Re),t(Jt),t(jt),t($e),t(wt),t(bt),t(We),t(gt),t(ft),t(Xe)),t(w),M(v,e),M(I,e),M(C,e),M(G,e),M(R,e),M($,e),M(W,e),M(H,e),M(Y,e),M(L,e),M(A,e),M(se,e),M(ne,e),M(ae,e),M(ie,e),M(pe,e),M(de,e),M(me,e),M(he,e),M(Te,e),M(Je,e),M(we,e),M(ge,e),M(ve,e),M(Se,e),M(Ee,e),M(ke,e),M(qe,e),M(Ve,e),M(Fe,e),M(Ze,e)}}}const Qn='{"title":"Modèles pré-entraînés pour la reconnaissance automatique de la parole","local":"modèles-pré-entraînés-pour-la-reconnaissance-automatique-de-la-parole","sections":[{"title":"Sonder les modèles CTC","local":"sonder-les-modèles-ctc","sections":[],"depth":2},{"title":"Passage à Seq2Seq","local":"passage-à-seq2seq","sections":[],"depth":2},{"title":"Longue transcription et horodatage","local":"longue-transcription-et-horodatage","sections":[],"depth":2},{"title":"Résumé","local":"résumé","sections":[],"depth":2}],"depth":1}';function Ln(Vt){return $n(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pn extends Fn{constructor(w){super(),Wn(this,w,Ln,Yn,Rn,{})}}export{Pn as component};
