# 코스에 대한 이해도를 체크해보세요[[check-your-understanding-of-the-course-material]]

### 1. 샘플링 속도는 어떤 단위를 사용합니까?

<Question
	choices={[
		{
			text: "dB",
			explain: "정답이 아닙니다.데시벨(dB)은 진폭의 측정에 사용됩니다."
		},
		{
			text: "Hz",
			explain: "샘플링 속도는 초당 샘플의 갯수로 헤르츠(Hz)를 사용합니다.",
			correct: true
		},
		{
			text: "bit",
			explain: "bit는 오디오 신호의 샘플에서 몇개의 비트로 정보를 나타내는지를 알려주는 비트뎁스에서 사용됩니다. ",
		}
	]}
/>

### 2. 큰 오디오 데이터셋을 스트리밍한다면 어느 시점부터 이를 사용할 수 있습니까?

<Question
	choices={[
		{
			text: "모든 데이터셋이 다운로드되는 순간.",
			explain: "데이터를 스트리밍하는 것의 목적은 데이터셋을 전부 다운로드하지 않고 처리하는 것에 있습니다."
		},
		{
			text: "처음 16개의 데이터가 다운로드되는 순간.",
			explain: "다시 풀어보세요!"
		},
		{
			text: "첫번째 데이터가 다운로드되는 순간.",
			explain: "",
			correct: true
		}
	]}
/>

### 3. 스펙트로그램이란 무엇인가요?

<Question
	choices={[
		{
			text: "마이크에서 캡처된 오디오를 디지털화하는데 사용하는 장치로, 음파를 전기 신호로 변환합니다.",
			explain: "전기 신호를 디지털화하는 장치는 아날로그-디지털 컨버터입니다. 다시 풀어보세요!"
		},
		{
			text: "오디오 신호의 진폭이 시간에 따라 변하는 것을 그린 것. 소리의 *시간 영역* 표현 이라고도 합니다.",
			explain: "이 설명은 스펙트로그램이 아닌 파형에 대한 설명입니다."
		},
		{
			text: "주파수 스펙트럼이 시간에 따라 변화하는 것을 시각적으로 나타낸 것.",
			explain: "",
			correct: true
		}
	]}
/>

### 4. 원시 오디오 데이터를 Whisper에 적합한 로그-멜 스펙트로그램으로 변환하는 가장 쉬운 방법은?

A.
```python
librosa.feature.melspectrogram(audio["array"])
```

B.
```python
feature_extractor = WhisperFeatureExtractor.from_pretrained("openai/whisper-small")
feature_extractor(audio["array"])
```

C.
```python
dataset.feature(audio["array"], model="whisper")
```

<Question
	choices={[
		{
			text: "A",
			explain: "`librosa.feature.melspectrogram()`는 파워 스펙트로그램을 만듭니다."
		},
		{
			text: "B",
			explain: "",
			correct: true
		},
		{
			text: "C",
			explain: "Dataset은 트랜스포머 모델의 feature를 준비하는데 사용하지 않습니다. 이는 모델의 preprocessor를 통해 이뤄집니다."
		}
	]}
/>

### 5. 🤗 허브에서 데이터셋을 불러오는 방법은?

A.
```python
from datasets import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

B.
```python
import librosa

dataset = librosa.load(PATH_TO_DATASET)
```

C.
```python
from transformers import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

<Question
	choices={[
		{
			text: "A",
			explain: "가장 좋은 방법은 🤗 Datasets 라이브러리를 사용하는 것입니다.",
			correct: true
		},
		{
			text: "B",
			explain: "`librosa.load`는 경로에 있는 단일 오디오 파일을 오디오 시계열과 샘플링 속도로 이뤄진 튜플로 불러올때 유용한 방법이지 여러 feature로 이뤄진 데이터들의 데이터셋 전체를 불러올 때 유용한 방법이 아닙니다."
		},
		{
			text: "C",
			explain: "`load_dataset` 메소드는 🤗 Transformers가 아닌 🤗 Datasets 라이브러에 포함되어 있습니다."
		}
	]}
/>

### 6. 32 kHz의 샘플링 속도를 가진 고품질 오디오 데이터셋으로 16 kHz 샘플링 속도를 요구하는 음성 인식 모델을 학습하고자 합니다. 그렇다면 무엇을 해야합니까?

<Question
	choices={[
		{
			text: "데이터를 그대로 사용한다. 모델은 고품질 데이터를 쉽게 일반화할 수 있을 것이므로.",
			explain: "attention 메커니즘에 의존하기 때문에 모델이 서로 다른 샘플링 속도간 일반화를 하기는 어렵습니다."
		},
		{
			text: "🤗 Datasets 라이브러리의 Audio 모듈을 이용하여 다운샘플링을 한다.",
			explain: "",
			correct: true
		},
		{
			text: "다른 모든 샘플들을 버려서 2배 다운샘플링이 되도록 한다.",
			explain: "이는 alias라는 신호의 왜곡을 만듭니다. 리샘플링을 하는 것은 까다로우므로 librosa나 🤗 Datasets같은 잘 테스트된 라이브러리에 맡기는게 납니다."
		}
	]}
/>

### 7. 머신러닝 모델에 의해 만들어진 스펙트로그램을 파형으로 바꾸는 방법으로 옳은 것은?

<Question
	choices={[
		{
			text: "vocoder라는 신경망을 이용해 스펙트로그램에서 파형을 재구성한다.",
			explain: "위상정보가 손실된 경우기 때문에 vocoder나 고전적인 Griffin-Lim 알고리즘을 이용해 파형을 재구성해야 합니다.",
			correct: true
		},
		{
			text: "역 STFT를 이용해 스펙트로그램을 파형으로 바꾼다.",
			explain: "머신러닝 모델에 의해 만들어진 스펙트로그램은 위상정보가 없어 역 STFT를 쓸 수 없습니다."
		},
		{
			text: "머신러닝 모델에 의해 만들어진 스펙트로그램은 다시 파형으로 되돌릴 수 없습니다.",
			explain: "다시 풀어보세요!"
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/audio-transformers-course/blob/main/chapters/ko/chapter1/quiz.mdx" />