import{s as ne,n as Me,o as oe}from"../chunks/scheduler.a045fce0.js";import{S as ie,i as pe,e as M,s as t,c as p,h as re,a as o,d as s,b as n,f as te,g as r,j as i,k as El,l as ue,m as a,n as u,t as m,o as d,p as c}from"../chunks/index.bc14ef44.js";import{C as me,H as de,E as ce}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.6660adf5.js";import{C as j}from"../chunks/CodeBlock.2a35eb1b.js";function je(_l){let y,K,P,ll,J,el,T,sl,w,Ql="Neste curso, utilizaremos a biblioteca 🤗 Datasets (Hugging Face Datasets) para trabalhar com datasets de áudio. 🤗 Datasets é uma biblioteca open source para baixar e preparar datasets de todas as modalidades, incluindo áudio. A biblioteca oferece fácil acesso a uma seleção única de datasets de machine learning disponíveis publicamente no Hugging Face Hub. Além disso, 🤗 Datasets inclui várias funcionalidades adaptadas para datasets de áudio que simplificam o trabalho tanto para pesquisadores quanto para praticantes.",al,h,Wl="Para começar a trabalhar com datasets de áudio certifique-se de ter a biblioteca 🤗 Datasets instalada:",tl,f,nl,b,Rl="Uma das principais características da 🤗 Datasets é a capacidade de baixar e preparar um dataset com apenas uma linha de código Python usando a função <code>load_dataset()</code>.",Ml,A,zl='Vamos carregar e explorar um dataset de áudio chamado <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MINDS-14</a>, que contém gravações de pessoas fazendo perguntas a um sistema de e-banking em vários idiomas e dialetos.',ol,C,Fl="Para carregar o dataset MINDS-14, precisamos copiar o identificador do dataset no Hub (<code>PolyAI/minds14</code>) e passá-lo para a função <code>load_dataset</code>. Também especificaremos que estamos interessados apenas no subconjunto Australiano dos dados, e limitá-lo ao traning split (a parte dos dados somente para treino):",il,g,pl,I,Sl="<strong>Saída:</strong>",rl,v,ul,$,Yl="O dataset contém 654 arquivos de áudio, cada um possui os seguintes campos (features): transcrição, uma tradução para o inglês e um rótulo indicando o motivo da pergunta da pessoa. A coluna audio contém os dados brutos do áudio (sem processamento). Vamos dar uma olhada mais de perto em um dos exemplos:",ml,G,dl,q,Hl="<strong>Saída:</strong>",cl,x,jl,k,Nl="Note que a coluna audio contém várias features (campos ou características). Aqui está uma descrição delas:",yl,Z,Xl="<li><code>path</code>: o caminho para o arquivo de áudio (<code>*.wav</code> neste caso).</li> <li><code>array</code>: Os dados de áudio decodificados, representados como um array unidimensional NumPy.</li> <li><code>sampling_rate</code>: A taxa de amostragem do arquivo de áudio (8.000 Hz neste exemplo).</li>",Ul,B,Vl="O <code>intent_class</code> é uma categoria para classificar a gravação de áudio. Para converter este número em algo mais significativo, podemos usar o método <code>int2str()</code>:",Jl,E,Tl,_,Ll="<strong>Saída:</strong>",wl,Q,hl,W,Dl="Se você olhar o campo transcription (em inglês), vai ver que o arquivo de áudio de fato gravou uma pessoa fazendo uma pergunta sobre o pagamento de uma conta.",fl,R,Pl="Se você planeja treinar um classificador de áudio com este subconjunto dos dados, você não vai precisar, necessariamente, de todos os campos. Por exemplo, o <code>lang_id</code> vai ter o mesmo valor para todos os exemplos, e não tem utilidade. A coluna <code>english_transcription</code> provavelmente será uma cópia de <code>transcription</code> neste subconjunto, então podemos removê-las tranquilamente.",bl,z,Ol="Você pode facilmente remover campos (features) irrelevantes usando o método <code>remove_columns</code> da 🤗 Datasets:",Al,F,Cl,S,Kl="<strong>Saída:</strong>",gl,Y,Il,H,le="Agora que carregamos e inspecionamos o conteúdo bruto do dataset, vamos ouvir alguns exemplos! Usaremos as propriedades <code>Blocks</code> e <code>Audio</code> do <code>Gradio</code> para decodificar algumas amostras aleatórias:",vl,N,$l,X,ee="Se você quiser, também pode visualizar alguns dos exemplos. Vamos plotar a forma de onda para o primeiro exemplo.",Gl,V,ql,U,se='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/waveform_unit1.png" alt="Plot da forma de onda"/>',xl,L,ae='Sua vez de tentar! Baixe outro dialeto ou idioma do dataset MINDS-14, ouça e visualize alguns exemplos para ter uma noção da variedade do dataset inteiro. Você pode encontrar a lista completa de idiomas disponíveis <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">aqui</a>.',kl,D,Zl,O,Bl;return J=new me({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new de({props:{title:"Carregue e explore um dataset de áudio",local:"carregue-e-explore-um-dataset-de-áudio",headingTag:"h1"}}),f=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRhdGFzZXRzJTVCYXVkaW8lNUQ=",highlighted:"pip install datasets[audio]",wrap:!1}}),g=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBbWluZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyUG9seUFJJTJGbWluZHMxNCUyMiUyQyUyMG5hbWUlM0QlMjJlbi1BVSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBbWluZHM=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-AU&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
minds`,wrap:!1}}),v=new j({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbmdsaXNoX3RyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYW5nX2lkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA2NTQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMEEp",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [
            <span class="hljs-string">&quot;path&quot;</span>,
            <span class="hljs-string">&quot;audio&quot;</span>,
            <span class="hljs-string">&quot;transcription&quot;</span>,
            <span class="hljs-string">&quot;english_transcription&quot;</span>,
            <span class="hljs-string">&quot;intent_class&quot;</span>,
            <span class="hljs-string">&quot;lang_id&quot;</span>,
        ],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">654</span>,
    <span class="hljs-punctuation">}</span>
)`,wrap:!1}}),G=new j({props:{code:"ZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWV4YW1wbGU=",highlighted:`example = minds[<span class="hljs-number">0</span>]
example`,wrap:!1}}),x=new j({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIwLjAlMkMlMjAwLjAwMDI0NDE0JTJDJTIwLTAuMDAwMjQ0MTQlMkMlMjAuLi4lMkMlMjAtMC4wMDAyNDQxNCUyQyUyMDAuMDAwMjQ0MTQlMkMlMjAwLjAwMTIyMDclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDgwMDAlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2NyaXB0aW9uJTIyJTNBJTIwJTIySSUyMHdvdWxkJTIwbGlrZSUyMHRvJTIwcGF5JTIwbXklMjBlbGVjdHJpY2l0eSUyMGJpbGwlMjB1c2luZyUyMG15JTIwY2FyZCUyMGNhbiUyMHlvdSUyMHBsZWFzZSUyMGFzc2lzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmVuZ2xpc2hfdHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhbmdfaWQlMjIlM0ElMjAyJTJDJTBBJTdE",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [<span class="hljs-number">0.0</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">-0.00024414</span>, ..., <span class="hljs-number">-0.00024414</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">0.0012207</span>],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">8000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;english_transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
    <span class="hljs-comment">&quot;lang_id&quot;</span>: <span class="hljs-number">2</span>,
}`,wrap:!1}}),E=new j({props:{code:"aWQybGFiZWwlMjAlM0QlMjBtaW5kcy5mZWF0dXJlcyU1QiUyMmludGVudF9jbGFzcyUyMiU1RC5pbnQyc3RyJTBBaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCk=",highlighted:`id2label = minds.features[<span class="hljs-string">&quot;intent_class&quot;</span>].int2str
id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])`,wrap:!1}}),Q=new j({props:{code:"JTIycGF5X2JpbGwlMjI=",highlighted:'<span class="hljs-string">&quot;pay_bill&quot;</span>',wrap:!1}}),F=new j({props:{code:"Y29sdW1uc190b19yZW1vdmUlMjAlM0QlMjAlNUIlMjJsYW5nX2lkJTIyJTJDJTIwJTIyZW5nbGlzaF90cmFuc2NyaXB0aW9uJTIyJTVEJTBBbWluZHMlMjAlM0QlMjBtaW5kcy5yZW1vdmVfY29sdW1ucyhjb2x1bW5zX3RvX3JlbW92ZSklMEFtaW5kcw==",highlighted:`columns_to_remove = [<span class="hljs-string">&quot;lang_id&quot;</span>, <span class="hljs-string">&quot;english_transcription&quot;</span>]
minds = minds.remove_columns(columns_to_remove)
minds`,wrap:!1}}),Y=new j({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDY1NCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 654})</span>',wrap:!1}}),N=new j({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGdlbmVyYXRlX2F1ZGlvKCklM0ElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwbWluZHMuc2h1ZmZsZSgpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjApJTJDJTIwaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCklMEElMEElMEF3aXRoJTIwZ3IuQmxvY2tzKCklMjBhcyUyMGRlbW8lM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwZ3IuQ29sdW1uKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBfJTIwaW4lMjByYW5nZSg0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTJDJTIwbGFiZWwlMjAlM0QlMjBnZW5lcmF0ZV9hdWRpbygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwZ3IuQXVkaW8oYXVkaW8lMkMlMjBsYWJlbCUzRGxhYmVsKSUwQSUwQWRlbW8ubGF1bmNoKGRlYnVnJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_audio</span>():
    example = minds.shuffle()[<span class="hljs-number">0</span>]
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    <span class="hljs-keyword">return</span> (
        audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        audio[<span class="hljs-string">&quot;array&quot;</span>],
    ), id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])


<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    <span class="hljs-keyword">with</span> gr.Column():
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>):
            audio, label = generate_audio()
            output = gr.Audio(audio, label=label)

demo.launch(debug=<span class="hljs-literal">True</span>)`,wrap:!1}}),V=new j({props:{code:"aW1wb3J0JTIwbGlicm9zYSUwQWltcG9ydCUyMG1hdHBsb3RsaWIucHlwbG90JTIwYXMlMjBwbHQlMEFpbXBvcnQlMjBsaWJyb3NhLmRpc3BsYXklMEElMEFhcnJheSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMEElMEFwbHQuZmlndXJlKCkuc2V0X2ZpZ3dpZHRoKDEyKSUwQWxpYnJvc2EuZGlzcGxheS53YXZlc2hvdyhhcnJheSUyQyUyMHNyJTNEc2FtcGxpbmdfcmF0ZSk=",highlighted:`<span class="hljs-keyword">import</span> librosa
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> librosa.display

array = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
sampling_rate = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.waveshow(array, sr=sampling_rate)`,wrap:!1}}),D=new ce({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/pt-BR/chapter1/load_and_explore.mdx"}}),{c(){y=M("meta"),K=t(),P=M("p"),ll=t(),p(J.$$.fragment),el=t(),p(T.$$.fragment),sl=t(),w=M("p"),w.textContent=Ql,al=t(),h=M("p"),h.textContent=Wl,tl=t(),p(f.$$.fragment),nl=t(),b=M("p"),b.innerHTML=Rl,Ml=t(),A=M("p"),A.innerHTML=zl,ol=t(),C=M("p"),C.innerHTML=Fl,il=t(),p(g.$$.fragment),pl=t(),I=M("p"),I.innerHTML=Sl,rl=t(),p(v.$$.fragment),ul=t(),$=M("p"),$.textContent=Yl,ml=t(),p(G.$$.fragment),dl=t(),q=M("p"),q.innerHTML=Hl,cl=t(),p(x.$$.fragment),jl=t(),k=M("p"),k.textContent=Nl,yl=t(),Z=M("ul"),Z.innerHTML=Xl,Ul=t(),B=M("p"),B.innerHTML=Vl,Jl=t(),p(E.$$.fragment),Tl=t(),_=M("p"),_.innerHTML=Ll,wl=t(),p(Q.$$.fragment),hl=t(),W=M("p"),W.textContent=Dl,fl=t(),R=M("p"),R.innerHTML=Pl,bl=t(),z=M("p"),z.innerHTML=Ol,Al=t(),p(F.$$.fragment),Cl=t(),S=M("p"),S.innerHTML=Kl,gl=t(),p(Y.$$.fragment),Il=t(),H=M("p"),H.innerHTML=le,vl=t(),p(N.$$.fragment),$l=t(),X=M("p"),X.textContent=ee,Gl=t(),p(V.$$.fragment),ql=t(),U=M("div"),U.innerHTML=se,xl=t(),L=M("p"),L.innerHTML=ae,kl=t(),p(D.$$.fragment),Zl=t(),O=M("p"),this.h()},l(l){const e=re("svelte-u9bgzb",document.head);y=o(e,"META",{name:!0,content:!0}),e.forEach(s),K=n(l),P=o(l,"P",{}),te(P).forEach(s),ll=n(l),r(J.$$.fragment,l),el=n(l),r(T.$$.fragment,l),sl=n(l),w=o(l,"P",{"data-svelte-h":!0}),i(w)!=="svelte-1ky7sxl"&&(w.textContent=Ql),al=n(l),h=o(l,"P",{"data-svelte-h":!0}),i(h)!=="svelte-m9beht"&&(h.textContent=Wl),tl=n(l),r(f.$$.fragment,l),nl=n(l),b=o(l,"P",{"data-svelte-h":!0}),i(b)!=="svelte-o4pqli"&&(b.innerHTML=Rl),Ml=n(l),A=o(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-1le1gjj"&&(A.innerHTML=zl),ol=n(l),C=o(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-psvjfq"&&(C.innerHTML=Fl),il=n(l),r(g.$$.fragment,l),pl=n(l),I=o(l,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1usoza3"&&(I.innerHTML=Sl),rl=n(l),r(v.$$.fragment,l),ul=n(l),$=o(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-iazcgz"&&($.textContent=Yl),ml=n(l),r(G.$$.fragment,l),dl=n(l),q=o(l,"P",{"data-svelte-h":!0}),i(q)!=="svelte-1usoza3"&&(q.innerHTML=Hl),cl=n(l),r(x.$$.fragment,l),jl=n(l),k=o(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1nrwzy4"&&(k.textContent=Nl),yl=n(l),Z=o(l,"UL",{"data-svelte-h":!0}),i(Z)!=="svelte-6fp0e4"&&(Z.innerHTML=Xl),Ul=n(l),B=o(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-qembgb"&&(B.innerHTML=Vl),Jl=n(l),r(E.$$.fragment,l),Tl=n(l),_=o(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-1usoza3"&&(_.innerHTML=Ll),wl=n(l),r(Q.$$.fragment,l),hl=n(l),W=o(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1vdn62s"&&(W.textContent=Dl),fl=n(l),R=o(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1l3vz3m"&&(R.innerHTML=Pl),bl=n(l),z=o(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1rehfyu"&&(z.innerHTML=Ol),Al=n(l),r(F.$$.fragment,l),Cl=n(l),S=o(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1usoza3"&&(S.innerHTML=Kl),gl=n(l),r(Y.$$.fragment,l),Il=n(l),H=o(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1adojnt"&&(H.innerHTML=le),vl=n(l),r(N.$$.fragment,l),$l=n(l),X=o(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1c6fg8j"&&(X.textContent=ee),Gl=n(l),r(V.$$.fragment,l),ql=n(l),U=o(l,"DIV",{class:!0,"data-svelte-h":!0}),i(U)!=="svelte-1i56ixc"&&(U.innerHTML=se),xl=n(l),L=o(l,"P",{"data-svelte-h":!0}),i(L)!=="svelte-lejzh7"&&(L.innerHTML=ae),kl=n(l),r(D.$$.fragment,l),Zl=n(l),O=o(l,"P",{}),te(O).forEach(s),this.h()},h(){El(y,"name","hf:doc:metadata"),El(y,"content",ye),El(U,"class","flex justify-center")},m(l,e){ue(document.head,y),a(l,K,e),a(l,P,e),a(l,ll,e),u(J,l,e),a(l,el,e),u(T,l,e),a(l,sl,e),a(l,w,e),a(l,al,e),a(l,h,e),a(l,tl,e),u(f,l,e),a(l,nl,e),a(l,b,e),a(l,Ml,e),a(l,A,e),a(l,ol,e),a(l,C,e),a(l,il,e),u(g,l,e),a(l,pl,e),a(l,I,e),a(l,rl,e),u(v,l,e),a(l,ul,e),a(l,$,e),a(l,ml,e),u(G,l,e),a(l,dl,e),a(l,q,e),a(l,cl,e),u(x,l,e),a(l,jl,e),a(l,k,e),a(l,yl,e),a(l,Z,e),a(l,Ul,e),a(l,B,e),a(l,Jl,e),u(E,l,e),a(l,Tl,e),a(l,_,e),a(l,wl,e),u(Q,l,e),a(l,hl,e),a(l,W,e),a(l,fl,e),a(l,R,e),a(l,bl,e),a(l,z,e),a(l,Al,e),u(F,l,e),a(l,Cl,e),a(l,S,e),a(l,gl,e),u(Y,l,e),a(l,Il,e),a(l,H,e),a(l,vl,e),u(N,l,e),a(l,$l,e),a(l,X,e),a(l,Gl,e),u(V,l,e),a(l,ql,e),a(l,U,e),a(l,xl,e),a(l,L,e),a(l,kl,e),u(D,l,e),a(l,Zl,e),a(l,O,e),Bl=!0},p:Me,i(l){Bl||(m(J.$$.fragment,l),m(T.$$.fragment,l),m(f.$$.fragment,l),m(g.$$.fragment,l),m(v.$$.fragment,l),m(G.$$.fragment,l),m(x.$$.fragment,l),m(E.$$.fragment,l),m(Q.$$.fragment,l),m(F.$$.fragment,l),m(Y.$$.fragment,l),m(N.$$.fragment,l),m(V.$$.fragment,l),m(D.$$.fragment,l),Bl=!0)},o(l){d(J.$$.fragment,l),d(T.$$.fragment,l),d(f.$$.fragment,l),d(g.$$.fragment,l),d(v.$$.fragment,l),d(G.$$.fragment,l),d(x.$$.fragment,l),d(E.$$.fragment,l),d(Q.$$.fragment,l),d(F.$$.fragment,l),d(Y.$$.fragment,l),d(N.$$.fragment,l),d(V.$$.fragment,l),d(D.$$.fragment,l),Bl=!1},d(l){l&&(s(K),s(P),s(ll),s(el),s(sl),s(w),s(al),s(h),s(tl),s(nl),s(b),s(Ml),s(A),s(ol),s(C),s(il),s(pl),s(I),s(rl),s(ul),s($),s(ml),s(dl),s(q),s(cl),s(jl),s(k),s(yl),s(Z),s(Ul),s(B),s(Jl),s(Tl),s(_),s(wl),s(hl),s(W),s(fl),s(R),s(bl),s(z),s(Al),s(Cl),s(S),s(gl),s(Il),s(H),s(vl),s($l),s(X),s(Gl),s(ql),s(U),s(xl),s(L),s(kl),s(Zl),s(O)),s(y),c(J,l),c(T,l),c(f,l),c(g,l),c(v,l),c(G,l),c(x,l),c(E,l),c(Q,l),c(F,l),c(Y,l),c(N,l),c(V,l),c(D,l)}}}const ye='{"title":"Carregue e explore um dataset de áudio","local":"carregue-e-explore-um-dataset-de-áudio","sections":[],"depth":1}';function Ue(_l){return oe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fe extends ie{constructor(y){super(),pe(this,y,Ue,je,ne,{})}}export{fe as component};
