# Avalie seus conhecimentos

### 1. Em que unidades a taxa de amostragem é medida?

<Question
	choices={[
		{
			text: "dB",
			explain: "Não, a amplite é que é medida em decibéis (dB)."
		},
		{
			text: "Hz",
			explain: "A taxa de amostragem é o número de amostras coletadas em um segundo e é medida em hertz (Hz).",
			correct: true
		},
		{
			text: "bit",
			explain: "Bits são usados para a profundidade de bits (bit depth), a qual se refere ao número de bits usados para representa cada amostra coletada de um sinal de áudio",
		}
	]}
/>

### 2. Ao usar o streaming de um grande dataset de áudio, em que momento ele se torna disponível para usá-lo?


<Question
	choices={[
		{
			text: "Assim que o download de todo o dataset for concluído",
			explain: "O objetivo do streaming é a capacidade de trabalhar com os dados sem precisar baixar todo o dataset"
		},
		{
			text: "Assim que os primeiros 16 exemplos forem baixados",
			explain: "Tente novamente!"
		},
		{
			text: "Assim que o primeiro exemplo for baixado.",
			explain: "",
			correct: true
		}
	]}
/>

### 3. O que é um espectrograma?

<Question
	choices={[
		{
			text: "Um dispositivo usado para digitalizar o áudio que foi capturado por um microfone, o qual converte ondas sonoras em sinal elétrico.",
			explain: "O dispositivo usado para digitalizar um sinal elétrico como esse é chamado conversor Analógico-Digital. Tente novamente!"
		},
		{
			text: "Um gráfico que mostra como a amplitude de um sinal de áudio varia ao longo do tempo. É conhecido também como *domínio do tempo* do som",
			explain: "A descrição acima se refere a forma de onda, e não o espectograma"
		},
		{
			text: "Uma representação visual de como o espectro de frequência de um sinal varia ao longo do tempo",
			explain: "",
			correct: true
		}
	]}
/>

### 4. Qual é a maneira mais fácil de converter dados de áudio brutos em espectrograma log-mel esperado pelo Whisper?

A.
```python
librosa.feature.melspectrogram(audio["array"])
```

B.
```python
feature_extractor = WhisperFeatureExtractor.from_pretrained("openai/whisper-small")
feature_extractor(audio["array"])
```

C.
```python
dataset.feature(audio["array"], model="whisper")
```

<Question
	choices={[
		{
			text: "A",
			explain: "`librosa.feature.melspectrogram()` cria um espectograma de potência"
		},
		{
			text: "B",
			explain: "",
			correct: true
		},
		{
			text: "C",
			explain: "A Dataset não prepara as características (features) para os modelos Transformer, isso é feito pelo pré-processador do modelo"
		}
	]}
/>

### 5. Como você carrega um conjunto de dados do 🤗 Hub?

A.
```python
from datasets import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

B.
```python
import librosa

dataset = librosa.load(PATH_TO_DATASET)
```

C.
```python
from transformers import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

<Question
	choices={[
		{
			text: "A",
			explain: "A melhor maneira é usar a biblioteca 🤗 Datasets.",
			correct: true
		},
		{
			text: "B",
			explain: "Librosa.load é útil para carregar um arquivo de áudio individual a partir do caminho em uma tupla com as amostras de áudio e a taxa de amostragem (sampling rate), mas não um dataset inteiro com muitos exemplos e características"
		},
		{
			text: "C",
			explain: "O método load_dataset vem da biblioteca 🤗 Datasets e não dá 🤗 Transformers."
		}
	]}
/>

### 6. Seu dataset personalizado contém áudios de alta qualidade com taxa de amostragem de 32 kHz. Você quer treinar um modelo de reconhecimento de fala que espera que os exemplos de áudio tenham uma taxa de amostragem de 16 kHz. O que você deve fazer?


<Question
	choices={[
		{
			text: "Use os exemplos como estão, o modelo generalizará facilmente para exemplos de áudio de maior qualidade.",
			explain: "Devido à dependência de mecanismos de atenção, é desafiador para os modelos generalizarem entre taxas de amostragem."
		},
		{
			text: "Use o módulo Áudio da biblioteca 🤗 Datasets para reduzir a amostragem dos exemplos no conjunto de dados personalizado",
			explain: "",
			correct: true
		},
		{
			text: "Reduza a amostragem (downsample) por um fator de 2x descartando cada uma das outras amostra.",
			explain: "Isso criará distorções no sinal chamadas de aliasing. Fazer a reamostragem (resampling) corretamente é complicado e é melhor deixar para bibliotecas bem testadas, como librosa ou 🤗 Datasets."
		}
	]}
/>

### 7. Como você pode converter um espectrograma gerado por um modelo de machine learning em uma forma de onda?


<Question
	choices={[
		{
			text: "Podemos usar uma rede neural chamada vocoder para reconstruir uma forma de onda a partir do espectrograma.",
			explain: "Como a informação de fase está ausente neste caso, precisamos usar um vocoder, ou o clássico algoritmo Griffin-Lim para reconstruir a forma de onda.",
			correct: true
		},
		{
			text: "Podemos usar a STFT inversa para converter o espectrograma gerado em uma forma de onda",
			explain: "Um espectrograma gerado está faltando informação de fase que é necessária para usar a STFT inversa."
		},
		{
			text: "Você não pode converter um espectrograma gerado por um modelo de machine learning em uma forma de onda.",
			explain: "Tente novamente!"
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/audio-transformers-course/blob/main/chapters/pt-BR/chapter1/quiz.mdx" />