# Check your understanding of the course material

### 1. 采样率使用的单位是？

<Question
	choices={[
		{
			text: "dB",
			explain: "错误，使用dB标度的是幅值。"
		},
		{
			text: "Hz",
			explain: "采样率是指每秒内采样点的个数，使用赫兹（Hz）为单位。",
			correct: true
		},
		{
			text: "bit",
			explain: "比特（bit）是描述位深度的单位，位深度指的是单个样本点需要用多少位的二进制数（即比特）来表示。",
		}
	]}
/>

### 2. 使用流式加载模式加载大规模数据集时，何时才能开始使用该数据集？

<Question
	choices={[
		{
			text: "在完整的数据集下载完毕时",
			explain: "使用流式加载的目的就是让我们不需要下载完整的数据集也可以开始使用数据集。"
		},
		{
			text: "在前16个样本下载完成时",
			explain: "再试一次！"
		},
		{
			text: "在第一个样本被下载完成是",
			explain: "",
			correct: true
		}
	]}
/>

### 3. 什么是时频谱？

<Question
	choices={[
		{
			text: "将麦克风的电信号转化为数字信号的设备",
			explain: "将麦克风的电信号转化为数字信号的设备称为模拟-数字转换器（模数转换器，Analog-to-Digital Converter，ADC）。再试一次！"
		},
		{
			text: "表示音频信号的幅值随时间变化的图像，也被称为声音信号的*时域*表示",
			explain: "这种图像称为波形图，而非时频谱图。"
		},
		{
			text: "表示音频信号的各个频率成分随时间变化的可视化表示",
			explain: "",
			correct: true
		}
	]}
/>

### 4. 下列方法中，最简单的可以将原始音频转化为Whisper模型接受的对数梅尔谱的方法是？

A.
```python
librosa.feature.melspectrogram(audio["array"])
```

B.
```python
feature_extractor = WhisperFeatureExtractor.from_pretrained("openai/whisper-small")
feature_extractor(audio["array"])
```

C.
```python
dataset.feature(audio["array"], model="whisper")
```

<Question
	choices={[
		{
			text: "A",
			explain: "`librosa.feature.melspectrogram()`生成的是能量频谱。"
		},
		{
			text: "B",
			explain: "",
			correct: true
		},
		{
			text: "C",
			explain: "Dataset并不会对数据进行预处理或转换。模型的特征提取器才会进行转换。"
		}
	]}
/>

### 5. 如何从🤗 Hub加载数据集？

A.
```python
from datasets import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

B.
```python
import librosa

dataset = librosa.load(PATH_TO_DATASET)
```

C.
```python
from transformers import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

<Question
	choices={[
		{
			text: "A",
			explain: "最佳方案是使用🤗 Datasets库。",
			correct: true
		},
		{
			text: "B",
			explain: "Librosa.load 在加载单个的音频文件时十分好用，但在加载多样本和多特征的数据库时并非最佳方案。"
		},
		{
			text: "C",
			explain: "load_dataset 方法属于🤗 Datasets库，而非🤗 Transformers。"
		}
	]}
/>

### 6. 你的自定义数据集包含了32千赫兹采样率的高清音频。你现在想要训练一个使用16千赫兹采样率的语音识别模型。你应该怎么做？

<Question
	choices={[
		{
			text: "直接使用这些数据，模型可以对不同采样率的数据有泛化能力",
			explain: "由于依靠注意力机制，模型很难对不同采样率的数据进行泛化。"
		},
		{
			text: "使用🤗 Datasets库的音频模组对自定义数据集进行降采样",
			explain: "",
			correct: true
		},
		{
			text: "使用每隔一个样本点丢弃一个样本点的方法进行降采样",
			explain: "这种方法会产生混叠失真。重采样操作往往十分棘手，因此我们推荐经过测试的工具库，例如librosa和🤗 Datasets。"
		}
	]}
/>

### 7. 如何将机器学习模型生成的时频谱转化为波形？

<Question
	choices={[
		{
			text: "我们可以使用一种叫做声码器（vocoder）的神经网络从时频谱重构波形",
			explain: "由于生成的时频谱缺乏相位信息，我们需要使用声码器或者经典的Griffin-Lim算法来重构波形。",
			correct: true
		},
		{
			text: "我们可以用逆短时傅里叶变换（inverse STFT）将生成的时频谱转化为波形",
			explain: "使用逆短时傅里叶变化需要时频谱的相位信息，但生成的时频谱一般仅具有幅值信息。"
		},
		{
			text: "无法将机器学习模型生成的时频谱转化为波形。",
			explain: "再试一次！"
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/audio-transformers-course/blob/main/chapters/zh-CN/chapter1/quiz.mdx" />