# 语音合成数据集

语音合成任务（也称为 _文本转语音_，Text-to-Speech）面临许多挑战。

首先，就像之前讨论的语音识别（ASR）一样，文本和语音之间的对齐可能很棘手。然而，与 ASR 不同的是，TTS 是一个**一对多**映射问题，
即同一文本可以以多种不同方式合成。想想您每天听到的语音中声音和说话风格的多样性——每个人说同一句话的方式都不同，但它们都是有效且正确的！
TTS 模型的不同输出，频谱图或音频波形，可能对应同一个真实结果（ground truth）。模型必须学会为每个音素、单词或句子生成正确的持续时间和时序，
这可能会很有挑战性，特别是对于长且复杂的句子。

其次，TTS 中存在长距离依赖问题：语言具有时间维度，理解句子的意义通常需要考虑包含了周围词汇的上下文。确保 TTS 模型能捕获并保留长序列中的上下文信息对于生成连贯自然的语音至关重要。

最后，训练 TTS 模型通常需要文本和相应的语音录音配对，且为保证模型能够为不同说话人和说话风格生成自然的语音，数据应包含来自多个说话人的多样、有代表性的语音样本。
收集此类数据既昂贵又耗时，并且对于某些语言来说并不可行。您可能会想，为什么不直接采用为 ASR 设计的数据集来训练 TTS 模型呢？不幸的是，
ASR 数据集并不是最佳选择。它们对于 ASR 有益的特性，如过多的背景噪音，在 TTS 中通常是不好的。能够在嘈杂街道的录音中辨别出语音是很棒的，
但如果您的语音助手回答您时背景有汽车喇叭声和建筑施工声就不那么理想了。尽管如此，有时可以用一些 ASR 数据集来微调，因为寻找高质量、多语言、多说话人的 TTS 数据集可能相当困难。

让我们来探索一些 🤗 Hub 上适用于 TTS 的数据集吧。

## LJSpeech

[LJSpeech](https://huggingface.co/datasets/lj_speech) 是一个包含 13,100 个英语音频片段及其对应转写的大型数据集，
内容为一位说话人朗读 7 本纪实类英语书籍的录音。由于其音质高，语言内容多样，LJSpeech 经常被用作评估 TTS 模型的基准。

## Multilingual LibriSpeech

[Multilingual LibriSpeech](https://huggingface.co/datasets/facebook/multilingual_librispeech) 是 LibriSpeech 数据集的多语言扩展版。
后者只包含英语有声读物，而 Multilingual LibriSpeech 还包括了额外的语言，如德语、荷兰语、西班牙语、法语、意大利语、葡萄牙语和波兰语。
它提供了每种语言的音频录音以及与之对齐的转写。这个数据集为开发多语言 TTS 系统和探索跨语言语音合成技术提供了宝贵的资源。

## VCTK (Voice Cloning Toolkit)

[VCTK](https://huggingface.co/datasets/vctk) 是专为语音合成研究和开发设计的数据集。它包含了 110 位不同口音的人说英语的录音，每位说话人读约 400 个句子，
这些句子选自报纸、the rainbow passage 和旨在识别说话者口音的引出段落（elicitation paragraph）。VCTK 为训练具有多样化声音和口音的 TTS 模型提供了宝贵资源，使语音合成更加自然和多样化。

## Libri-TTS / LibriTTS-R

[Libri-TTS / LibriTTS-R](https://huggingface.co/datasets/cdminix/libritts-r-aligned) 是一个由约 585 小时的英语朗读语音组成的多说话人英语语料库，
采样率 24kHz，由 Heiga Zen 在 Google Speech 和 Google Brain 团队成员的协助下搭建。LibriTTS 语料库专为 TTS 研究而设计，它源自 LibriSpeech 语料库的原始材料
（LibriVox 的 mp3 音频文件和 Project Gutenberg 的文本文件）。它与 LibriSpeech 语料库的主要区别如下：

* 音频文件是 24kHz 采样率。
* 每条语音数据在句子与句子间断开。
* 包括原始和规范化的文本。
* 可以提取上下文信息（例如相邻句子）。
* 排除了具有显著背景噪音的语音数据。

组建一个适用于 TTS 的优秀数据集并非易事，因为这样的数据集需要具备几个关键特性：

* 高质量和多样化的录音，涵盖广泛的语音模式、口音、语言和情感。录音应清晰、无背景噪音，并展现自然的语音特征。
* 转写：每个音频录音应有其相应的文本转写。
* 语言内容的多样性：数据集应包含语言多样化的内容，包括不同类型的句子、短语和单词。它应涵盖各种主题、体裁和领域，以确保模型能够处理不同的语言环境。

好消息是，您很可能不需要从头开始训练一个 TTS 模型。在下一节中，我们将探讨在 🤗 Hub 上可用的预训练模型。



<EditOnGithub source="https://github.com/huggingface/audio-transformers-course/blob/main/chapters/zh-CN/chapter6/tts_datasets.mdx" />