# Vortrainierte Modelle teilen

{#if fw === 'pt'}

<DocNotebookDropdown
  classNames="absolute z-10 right-0 top-0"
  options={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/chapter4/section3_pt.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/chapter4/section3_pt.ipynb"},
]} />

{:else}

<DocNotebookDropdown
  classNames="absolute z-10 right-0 top-0"
  options={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/chapter4/section3_tf.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/chapter4/section3_tf.ipynb"},
]} />

{/if}

Demnächst schauen wir uns an, wie man am einfachsten vortrainierte Modelle auf dem 🤗 Hub teilen kann.
Es gibt schon Tools und Hilfsmittel, die das Teilen und Updaten von Modellen auf dem Hub vereinfachen. Die werden wir gleich unten explorieren.

<Youtube id="9yY3RB_GSPM"/>

Wir empfehlen allen Nutzer:innen, die Modelle trainieren, dass sie der Communinity beitragen, indem sie Modelle teilen. Selbst die Modelle, die auf sehr spezifische Datensätze trainiert wurden, werden anderen Nutzer:innen helfen, weil man Zeit und Rechenressourcen spart und Zugang zu nützlichen Trainingsartifakten bekommt. Also eventuell kannst du auch von der Arbeit anderer Nutzer:innen auch profitieren!

Es gibt drei Wege, um Repositories zu neuen Modellen zu kreieren:

- Mittels der `push_to_hub` API
- Mittels der `huggingface_hub` Python Bibliothek
- Mittels der Web-Oberfläche

Nachdem du einen Repository erstellst hast, kannst du die Dateien über git und git-lfs hochladen. Demnächst zeigen wir dir die genauen Schritte, um Modell-Repositories zu erstellenund Dateien hochzuladen.


## Hochladen mit der `push_to_hub` API

{#if fw === 'pt'}

<Youtube id="Zh0FfmVrKX0"/>

{:else}

<Youtube id="pUh5cGmNV8Y"/>

{/if}

Die einfachste Variante, um Dateien auf den Hub hochzuladen, ist mittels der `push_to_hub` API. Bevor du weitermachst, must du einen Autentifizierungstoken generieren, damit die `huggingface_hub` API weißt, wer du bist und auf welche Namespaces du zugreifen darfst. Stell sicher, dass du in einer Umgebung mit `transformers` installiert bist (siehe [Setup](/course/chapter0)). Wenn du auf einem Notebook bist, kannst du diese Funktion benutzen, um dich einzuloggen:

```python
from huggingface_hub import notebook_login

notebook_login()
```

Im Terminal kannst folgendes ausführen:

```bash
huggingface-cli login
```

In beiden Fällen solltest du nach deinem Username und Passwort gefragt werden. Das sind die selben, mit denen du dich auf dem Hub einloggst. Solltest du noch kein Hub-Profil haben, musst du erstmal eins [hier](https://huggingface.co/join) erstellen.

Großartig! Nun hast du deinen Autentifizierungstoken in deinem Cache-Ordner gespeichert. Lass uns ein paar Repositories erstellen!

{#if fw === 'pt'}

Wenn du schon Modelle mit der `Trainer` API trainiert hast, dann ist der einfachste Weg, um Modelle hochzuladen, das Argument `push_to_hub=True` in `TrainingArguments` einzustellen.

```py
from transformers import TrainingArguments

training_args = TrainingArguments(
    "bert-finetuned-mrpc", save_strategy="epoch", push_to_hub=True
)
```

Wenn du `trainer.train()` aufrufst, lädt der `Trainer` das Modell auf den Hub zu dem Repository in deinem Namespace hoch. Das passiert jedes Mal, wenn das Modell gespeichert wird (in diesem Beispiel jede Epoche). Der Repository wird so benannt werden, wie der Output-Ordner, den du gewählt hast (hier `bert-finetuned-mrpc`). Natürlich kannst du dir aber einen anderen Namen ausdenken und mit `hub_model_id = "a_different_name"` setzen.

Um dein Modell zu einer Organisation, wovon du Mitglied bist, hochzuladen, kannst du einfach `hub_model_id = "my_organization/my_repo_name"` mit eingeben.

Wenn das Training durch ist, must du noch einmal `trainer.push_to_hub()` ausführen, um die letzte Version deines Modells hochzuladen. Das wird auch eine Modell-Karte generieren, auf der die relevanten Metadaten mit den benutzten Hyperparametern und Evaluierungsergebnissen! Hier ist ein Beispiel von dem Inhalt, den du auf so einer Modell-Karte finden kannst:

<div class="flex justify-center">
  <img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/model_card.png" alt="An example of an auto-generated model card." width="100%"/>
</div>

{:else}

Wenn du für das Modell-Training Keras benutzt, ist der einfachste Weg, um das Modell aud den Hub hochzuladen, den `PushToHubCallback` zu setzen, wenn du `model.fit()` aufrufst.

```py
from transformers import PushToHubCallback

callback = PushToHubCallback(
    "bert-finetuned-mrpc", save_strategy="epoch", tokenizer=tokenizer
)
```

Danach must du noch `callbacks=[callback]` beim `model.fit()` Aufruf setzen. 
Der Callback wird das Modell auf den Hub hochladen und zwar zu einem Repository in deinem Namespace. Das passiert jedes Mal, wenn das Modell gespeichert wird (in diesem Beispiel jede Epoche). Der Repository wird so benannt werden, wie der Output-Ordner, den du gewählt hast (hier `bert-finetuned-mrpc`). Natürlich kannst du dir aber einen anderen Namen ausdenken und mit `hub_model_id = "a_different_name"` setzen.

Um dein Modell zu einer Organisation, wovon du Mitglied bist, hochzuladen, kannst du einfach `hub_model_id = "my_organization/my_repo_name"` mit eingeben.


{/if}

Auf einer tieferen Ebene kann man auf Modelle, Tokenizers und Konfigurationen auf dem Model-Hub direkt zugreifen, indem man die Methode `push_to_hub()` benutzt. 
Diese Methode kümmert sich sowohl um das Erstellen vom Repository als auch das Pushen (Hochladen) von Modell- und Tokenizer-Dateien auf den Repository. Also da ist kein manueller Schritt notwendig (im Gegensatz zu den APIs, die wir demnächst sehen werden).

Um uns eine Vorstellung zu schaffen, wie es funktioniert, lass uns zuerst ein Modell und einen Tokenizer initialisieren:

{#if fw === 'pt'}
```py
from transformers import AutoModelForMaskedLM, AutoTokenizer

checkpoint = "camembert-base"

model = AutoModelForMaskedLM.from_pretrained(checkpoint)
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
```
{:else}
```py
from transformers import TFAutoModelForMaskedLM, AutoTokenizer

checkpoint = "camembert-base"

model = TFAutoModelForMaskedLM.from_pretrained(checkpoint)
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
```
{/if}

Dir steht frei, was du mit diesen machst, z.B. Tokens zum Tokenizer hinzuzufügen, das Modell zu trainineren oder zu finetunen. Wenn du mit dem Modell, Gewichten und Tokenizer zufrieden bist, kannst du die Methode `push_to_hub()` vom `model` Objekt benutzten:

```py
model.push_to_hub("dummy-model")
```
Das wird den neuen Repository `dummy-model` in deinem Profil erstellen und den mit deinen Model-Dateien befüllen. Mach das gliche mit dem Tokenizer, sodass jetzt alle Dateien in diesem Repository verfügbar sind.

```py
tokenizer.push_to_hub("dummy-model")
```
Wenn du Teil einer Organisation bist, kannst du einfach das Argument `organization` mit eingeben, um die Artifakte auf den Namespace dieser Organisation hochzuladen. 

```py
tokenizer.push_to_hub("dummy-model", organization="huggingface")
```

Wenn du einen bestimmten Hugging Face Token benutzten möchtest, kannst du ihn auch in der Methode `push_to_hub()` spezifizieren:

```py
tokenizer.push_to_hub("dummy-model", organization="huggingface", use_auth_token="<TOKEN>")
```

Nun geh auf den Model Hub, um dein hochgeladenes Modell zu finden: *https://huggingface.co/user-or-organization/dummy-model*.

Click auf den Tab "Files and versions" und da solltest du die Dateien finden, die auf diesem Screenshot zu sehen sind:

{#if fw === 'pt'}
<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/push_to_hub_dummy_model.png" alt="Dummy model containing both the tokenizer and model files." width="80%"/>
</div>
{:else}
<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/push_to_hub_dummy_model_tf.png" alt="Dummy model containing both the tokenizer and model files." width="80%"/>
</div>
{/if}

<Tip>

✏️ **Probier das selber aus!** Lade das Modell und den Tokenizer vom Checkpoint `bert-base-cased` mit der Methode `push_to_hub()` hoch. Überprüfe, dass der Repository auf deiner Seite richtig erscheint, bevor du den löschst.

</Tip>

Wie du schon gesehen hast, akzeptiert die Methode `push_to_hub()` mehrere Argumente. Dies erlaub das Hochladen auf den Namespace eines spezifischen Repositorys oder einer Organisation, sowie die Möglichkeit, einen anderen API Token zu benutzten. Wir empfehlen dir, die Dokumentation der Methode direkt auf [🤗 Transformers documentation](https://huggingface.co/transformers/model_sharing.html) zu lesen, um dir eine Vorstellung zu schaffen, was alles damit möglich ist.

Die `push_to_hub()` Methode funktioniert im Hintergrund mit der Python Bibliothek [`huggingface_hub`](https://github.com/huggingface/huggingface_hub), die eine direkte API zum Hugging Face Hub anbietet. Sie ist auch drin in der 🤗 Transformers Bibliothek und mehreren anderen Machine Learning Bibliotheken, z.B. [`allenlp`](https://github.com/allenai/allennlp). Obwohl wir in diesem Kapitel den Fokus auf die Integration mit 🤗 Transformers legen, kannst du es in deinen eigenen Code bzw. eigene Bibliothek relativ einfach integrieren. Spring auf den letzten Part, um zu erfahren, wie man Dateien auf einen frisch erstellten Repository hochladen kann!

## Verwendung der `huggingface_hub` Python Bibliothek
Die `huggingface_hub` Python Bibliothek ist ein Python Packet, das einige Werkzeuge für das Nutzen von Modell- und Datasethub anbietet.  Es bietet simple Methoden und Klassen für gängige Aufgaben, z.B. um Information zu Repositories auf dem Hub zu bekommen oder um sie zu Verwalten. Es bietet auch simple auf git basierende APIs, um die Inhalte von solchen Repositories zu verwalten sowie um den Hub in deine Projekte und Bibliotheken zu integrieren.

Ähnlich wie bei der Verwendung der`push_to_hub` API ist es bei diesen Aktionen erforderlich, dass dein API Token schon in deinem Cache gespeichert ist. Dafür musst du den `login` Befehl aus der CLI ausführen so wie in dem vorherigen Teil erklärt wurde (nochmal: Vergiss nicht, das `!` Zeichen vor die Befehle zu setzen, wenn du im Google Colab arbeitest).

```bash
huggingface-cli login
```

Die `huggingface_hub` Bibliothek bietet mehrere nützliche Methoden und Klassen an. Erstens gibt es einige Methoden, um das Erstellen, Löschen, usw. von Repositories durchzuführen:


```python no-format
from huggingface_hub import (
    # User-Management
    login,
    logout,
    whoami,

    # Repository erstellen und managen
    create_repo,
    delete_repo,
    update_repo_visibility,

    # Methoden, um inhaltliche Information abzufragen/abzuändern
    list_models,
    list_datasets,
    list_metrics,
    list_repo_files,
    upload_file,
    delete_file,
)
```

Außerdem gibt es die sehr mächtige `Repository` Klasse, um einen lokalen Repository zu managen. Demnächst werden wir uns mit diesen Methoden und dieser Klasse beschäftigen, um zu verstehen, wie man die am besten nutzt.

Mit der `create_repo` Methode kann ein neuer Repository auf dem Hub erstellt werden:

```py
from huggingface_hub import create_repo

create_repo("dummy-model")
```

Das erstellt den Repository `dummy-model` unter deinem Namespace. Wenn du möchtest, kannst du auch die Organisation spezifizieren, zu der der Repository gehören sollte, indem du das `organization` Argument setzt:

```py
from huggingface_hub import create_repo

create_repo("dummy-model", organization="huggingface")
```

Das erstellt den Repository `dummy-model` unter dem `huggingface` Namespace – angenommen du gehörst zu dieser Organisation.
Andere eventuell nützliche Argumente sind:

- `private`: um zu spezifizieren, ob der Repository für andere sichtbar sein sollte oder nicht.
- `token`: um den Token, der im Zwischenspeicher (Cache) liegt, mit einem neuen Token zu überscheiben.
- `repo_type`: zum Auswählen, ob du einen `dataset` oder einen `space` anstatt von einem Modell kreieren möchtest. Erlaubte Werte sind `"dataset"` und `"space"`.

Nachdem der Repository erstellt wurde, können wir Dateien hinzufügen! Spring zum nächsten Abschnitt, um drei Varianten dazu zu lernen, wie man das machen kann.

## Mit der Webinterface

Die Webinterface bietet Tools an, um Repositories direkt auf dem Hub zu managen. Damit kannst du ganz einfach Repositories erstellen, Dateien hinzufügen (sogar große Dateien), Modelle explorieren, Unterschiede ("diffs") visualisieren und viel mehr.

Um einen Repository zu erstellen, geh auf [huggingface.co/new](https://huggingface.co/new):

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/new_model.png" alt="Beispiel vom Modell, mit dem man einen Repository erstellen kann." width="80%"/>
</div>

Erstens muss man den Besitzer vom Repository eingeben: Das kannst entweder du selbst oder jede andere Person von der Organisation sein, zu der du gehörst. Wenn du eine Organisation auswählst, wird das Modell auf der Seite der Organisation präsentiert und jedes Mitglied der Organisation wird zu diesem Repository beitragen können.

Als nächstes gib den Namen deines Modells ein. So wird der Repository auch heißen. Zuletzt kannst du spezifizieren, ob das Modell öffentlich oder privat sein soll. Private Modelle sind von der Öffentlichkeit unsichtbar.

Nach der Erstellung des Repositorys solltest du so eine Seite sehen können:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/empty_model.png" alt="Leeres Modell nach der Erstellung des Repositorys." width="80%"/>
</div>

Hier wird dein Modell gehostet. Um mit dem Auffüllen zu beginnen, kannst du direkt über die Weboberfläche eine README-Datei hinzufügen.

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/dummy_model.png" alt="The README file showing the Markdown capabilities." width="80%"/>
</div>

Die README-Datei ist im Markdown Format — du kannst dich damit gerne austoben!
Der dritte Teil dieses Kapitels zielt darauf hin, eine "model card" (Steckbrief) zu bauen. Steckbriefe haben eine entscheidende Relevanz, um dein Modell wertvoll zu machen, denn du kannst dort anderen erzählen, was das Modell kann.

Wenn du dir den "Files and versions" Tab anschaust, wirst du sehen, dass noch nicht viele Dateien darauf sind – nämlich nur die von dir eben kreierte *README.md* und die *.gitattributes* (wo große Dateien geloggt werden).


<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/files.png" alt="The 'Files and versions' tab only shows the .gitattributes and README.md files." width="80%"/>
</div>

Gleich werden wir sehen, wie wir neue Dateien hinzufügen können.

## Hochladen von Modell-Dateien

Das System zum Managen der Dateien auf Hugging Face Hub basiert auf git für normale Dateien und auf git-lfs ([Git Large File Storage](https://git-lfs.github.com/)) für größere Dateien.

Im nächsten Teil schauen wir uns drei Möglichkeitein an, um Dateien mittels `huggingface_hub` und git-Befehle auf den Hub hochzuladen.

### Die `upload_file` Variante

Um `upload_file` zu verwenden, muss man nicht unbedingt git und git-lfs installiert haben. Die Funktion lädt Dateien auf den 🤗 Hub mittels HTTP POST Anfragen. Eine Einschränkunf dieser Variante ist, dass man nur mit Dateien unter 5GB groß arbeiten kann.
Wenn deine Dateien größer als 5GB sind, nutz eine von den folgenden zwei Methoden.

Die API kann folgendermaßen benutzt werden:

```py
from huggingface_hub import upload_file

upload_file(
    "<path_to_file>/config.json",
    path_in_repo="config.json",
    repo_id="<namespace>/dummy-model",
)
```
Das wird die `config.json` Datei in `<path_to_file>` auf das Root-Verzeichnis vom Repository als `config.json` vom `dummy-model` Repository.
Andere nützliche Argumente :

- `token`, um den Token zu überscheiben, der in deinem Cache gespeichert ist
- `repo_type`, wenn du anstatt von einem Modell Dateien auf einen `dataset` oder `space` hochladen möchtest. Valide Werte sind `"dataset"` und `"space"`.


### Die `Repository` Klasse

Die `Repository` Klasse verwaltet einen lokalen Repository so wie git. Sie abstrahiert aber die meisten schwierigen Punkte, auf die man stoßen würde, wenn man eine ähnliche Funktionalität mit git erreichen möchte.

Diese Klasse braucht git und git-lfs im System schon installiert. Also stell sicher, dass du git-lfs installiert hast (siehe [hier](https://git-lfs.github.com/) für Installationsanweisungen) und richte alles ein, bevor du loslegst.

Um mit dem Repository rumspielen zu starten, können wir den in einem lokalen Ordner initialisieren, in dem wir den Remote-Repository klonen:

```py
from huggingface_hub import Repository

repo = Repository("<path_to_dummy_folder>", clone_from="<namespace>/dummy-model")
```

Das hat den Ordner `<path_to_dummy_folder>` in unserem Arbeitsverzeichnis erstellt. Dieser Ordner enthält bisher nur die `.gitattributes` Datel, da diese die einzige Datei ist, die wir mit `create_repo` kreiert haben.

Ab jetzt können mehrere gängige Methoden benutzten:

```py
repo.git_pull()
repo.git_add()
repo.git_commit()
repo.git_push()
repo.git_tag()
```

Und andere Optionen auch! Wir empfehlen, dass du dir die Dokumentation zu `Repository`, die dir [hier](https://github.com/huggingface/huggingface_hub/tree/main/src/huggingface_hub#advanced-programmatic-repository-management) zur Verfügung steht, anschaust, um dir eine Übersicht aller verfügbaren Methoden zu verschaffen.

Bisher haben wir ein Modell und einen Tokenizer, die wir gerne auf den Hub pushen würden. Wir haben auch den Repository geklont, sodass wir die Dateien in dem Repository speichern können.

Zuerst stellen wir sicher, dass unser lokaler Repository einen aktuellen Stand hat, in dem wir die letzten Änderungen pullen:

```py
repo.git_pull()
```

Wenn das durch ist, speichern wir die Dateien vom Modell und Tokenizer:

```py
model.save_pretrained("<path_to_dummy_folder>")
tokenizer.save_pretrained("<path_to_dummy_folder>")
```

Der Pfad `<path_to_dummy_folder>` beinhaltet jetzt alle Modell- und Tokenizerdateien. Wir folgen dem gängigen Git-Workflow, indem wir die Dateien in die "staging area" bringen, wir committen und pushen sie auf den hub:

```py
repo.git_add()
repo.git_commit("Add model and tokenizer files")
repo.git_push()
```

Glückwunsch! Du hast gerade deine ersten Dateien auf den Hub hochgeladen.

### Die git-basierte Variante

Das ist der einfachste Weg zum Hochladen von Dateien: Wir werden es direkt mit git und git-lfs tun. Der Größtenteil der Schwierigkeit wird durch die früheren Ansätze abstrahiert, aber es gibt ein paar Vorbehalte bei der folgenden Methode, deswegen werden wir einem komplexeren Anwendungsfall folgen.

Um diese Klasse zu benutzten, mussen wir git und git-lfs installiert haben. Also stell sicher, dass du [git-lfs](https://git-lfs.github.com/) installiert und aufgesetzt hast, bevor du beginst.

Zuerst initialisiere git-lfs:

```bash
git lfs install
```

```bash
Updated git hooks.
Git LFS initialized.
```

Danach musst du den Modell-Repository klonen:

```bash
git clone https://huggingface.co/<namespace>/<your-model-id>
```

Mein Username ist `lysandre` und ich habe den Modellnamen `dummy` benutzt. Also bei bei sieht der Befehl so aus:

```
git clone https://huggingface.co/lysandre/dummy
```

Ich habe jetzt einen Ordner namens *dummy* in meinem Arbeitsverzeichnis. Ich kann jetzt `cd` in den Ordner und mir den Inhalt anschauen:

```bash
cd dummy && ls
```

```bash
README.md
```

Wenn du eben einen Repository mit der Hugging Face Hubs Methode `create_repo` erstellt hast, dann sollte dieser Ordner nur eine versteckte `.gitattributes` Datei enthalten. Wenn du es nach den Anweisungen in dem vorherigen Abschnitt mittels der Webinterface gemacht hast, dann sollte der Ordner eine einzige README.md Datei neben der `.gitattributes` enthalten – so wie hier angezeigt wird.

Das Hinzufügen einer Datei mit normaler Größe, z.B. Konfiguration- oder Vokabulardatei, wird so gemach wie in einem git-basierten System. Aber größere Dateien müssen mit git-lfs registriert werden, um sie zu *huggingface.co* zu pushen.

Lass uns kurz zurück zu Python, um ein Modell und einen Tokenizer zu generieren, die wir zu unserem dummy repository committen möchten:

{#if fw === 'pt'}
```py
from transformers import AutoModelForMaskedLM, AutoTokenizer

checkpoint = "camembert-base"

model = AutoModelForMaskedLM.from_pretrained(checkpoint)
tokenizer = AutoTokenizer.from_pretrained(checkpoint)

# Mach was du möchtest mit dem Modell, z.B. trainieren, fine-tunen.

model.save_pretrained("<path_to_dummy_folder>")
tokenizer.save_pretrained("<path_to_dummy_folder>")
```
{:else}
```py
from transformers import TFAutoModelForMaskedLM, AutoTokenizer

checkpoint = "camembert-base"

model = TFAutoModelForMaskedLM.from_pretrained(checkpoint)
tokenizer = AutoTokenizer.from_pretrained(checkpoint)

# Mach was du möchtest mit dem Modell, z.B. trainieren, fine-tunen.

model.save_pretrained("<path_to_dummy_folder>")
tokenizer.save_pretrained("<path_to_dummy_folder>")
```
{/if}

Jetzt haben wir die Modell- und Tokenizer-Artifakte gespeichert und können wir uns nochmal den *dummy* Ordner anschauen:

```bash
ls
```

{#if fw === 'pt'}
```bash
config.json  pytorch_model.bin  README.md  sentencepiece.bpe.model  special_tokens_map.json tokenizer_config.json  tokenizer.json
```

Wenn du dir die Dateigrößen anschaust (z.B. mit `ls -lh`), solltest du sehen, dass die Modell-Statedict Datei (*pytorch_model.bin*) der einzige Ausreißer ist mit über 400 MB.

{:else}
```bash
config.json  README.md  sentencepiece.bpe.model  special_tokens_map.json  tf_model.h5  tokenizer_config.json  tokenizer.json
```

Wenn du dir die Dateigrößen anschaust (z.B. mit `ls -lh`), solltest du sehen, dass die Modell-Statedict Datei (*t5_model.h5*) der einzige Ausreißer ist mit über 400 MB.

{/if}

<Tip>
✏️  Wenn ein Repository mittels der Webinterface kreiert wird, wird die *.gitattributes* Datei automatisch gesetzt, um bestimmte Dateiendungen wie *.bin* und *.h5* als große Dateien zu betrachten, sodass git-lfs sie tracken kann, ohne dass du weiteres konfigurieren musst.
</Tip> 

Nun können wir weitermachen und so arbeiten wie wir es mit normalen Git Repositories machen. Wir können die Dateien stagen mit dem Git-Befehl `git add`:

```bash
git add .
```

Jetzt schauen wir, welche Dateien gestaged wurden:

```bash
git status
```

{#if fw === 'pt'}
```bash
On branch main
Your branch is up to date with 'origin/main'.

Changes to be committed:
  (use "git restore --staged <file>..." to unstage)
  modified:   .gitattributes
	new file:   config.json
	new file:   pytorch_model.bin
	new file:   sentencepiece.bpe.model
	new file:   special_tokens_map.json
	new file:   tokenizer.json
	new file:   tokenizer_config.json
```
{:else}
```bash
On branch main
Your branch is up to date with 'origin/main'.

Changes to be committed:
  (use "git restore --staged <file>..." to unstage)
  modified:   .gitattributes
  	new file:   config.json
	new file:   sentencepiece.bpe.model
	new file:   special_tokens_map.json
	new file:   tf_model.h5
	new file:   tokenizer.json
	new file:   tokenizer_config.json
```
{/if}

Ähnlicherweise können wir sicherstellen, dass git-lfs die richtigen Dateien trackt mit dem `status` Befehl:

```bash
git lfs status
```

{#if fw === 'pt'}
```bash
On branch main
Objects to be pushed to origin/main:


Objects to be committed:

	config.json (Git: bc20ff2)
	pytorch_model.bin (LFS: 35686c2)
	sentencepiece.bpe.model (LFS: 988bc5a)
	special_tokens_map.json (Git: cb23931)
	tokenizer.json (Git: 851ff3e)
	tokenizer_config.json (Git: f0f7783)

Objects not staged for commit:


```

Da sehen wir, dass alle Dateien `Git` als Handler haben. Nur die *pytorch_model.bin* und *sentencepiece.bpe.model* Dateien haben `LFS`. Toll!

{:else}
```bash
On branch main
Objects to be pushed to origin/main:


Objects to be committed:

	config.json (Git: bc20ff2)
	sentencepiece.bpe.model (LFS: 988bc5a)
	special_tokens_map.json (Git: cb23931)
	tf_model.h5 (LFS: 86fce29)
	tokenizer.json (Git: 851ff3e)
	tokenizer_config.json (Git: f0f7783)

Objects not staged for commit:


```

Da sehen wir, dass alle Dateien `Git` als Handler haben. Nur die *t5_model.h5* hat `LFS`. Sehr gut!

{/if}

Lass uns mit den letzten Schritten weitermachen, indem wir die Änderungen commiten und zum *huggingface.co* Remote-Repository pushen:

```bash
git commit -m "First model version"
```

{#if fw === 'pt'}
```bash
[main b08aab1] First model version
 7 files changed, 29027 insertions(+)
  6 files changed, 36 insertions(+)
 create mode 100644 config.json
 create mode 100644 pytorch_model.bin
 create mode 100644 sentencepiece.bpe.model
 create mode 100644 special_tokens_map.json
 create mode 100644 tokenizer.json
 create mode 100644 tokenizer_config.json
```
{:else}
```bash
[main b08aab1] First model version
 6 files changed, 36 insertions(+)
 create mode 100644 config.json
 create mode 100644 sentencepiece.bpe.model
 create mode 100644 special_tokens_map.json
 create mode 100644 tf_model.h5
 create mode 100644 tokenizer.json
 create mode 100644 tokenizer_config.json
```
{/if}

Das Pushen kann ein bisschen dauern, je nach dem wie schnell deine Internetverbindung ist und wie groß deine Dateien sind:

```bash
git push
```

```bash
Uploading LFS objects: 100% (1/1), 433 MB | 1.3 MB/s, done.
Enumerating objects: 11, done.
Counting objects: 100% (11/11), done.
Delta compression using up to 12 threads
Compressing objects: 100% (9/9), done.
Writing objects: 100% (9/9), 288.27 KiB | 6.27 MiB/s, done.
Total 9 (delta 1), reused 0 (delta 0), pack-reused 0
To https://huggingface.co/lysandre/dummy
   891b41d..b08aab1  main -> main
```

{#if fw === 'pt'}
Wenn alles durch ist, können wir uns den Repository anschauen und die eben hinzugefügten Dateien finden:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/full_model.png" alt="The 'Files and versions' tab now contains all the recently uploaded files." width="80%"/>
</div>

Mit der UI kannst du die Modell-Dateien und die Commits explorieren, um die Differenz bei jedem Commit zu sehen:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/diffs.gif" alt="The diff introduced by the recent commit." width="80%"/>
</div>
{:else}

Wenn alles durch ist, können wir uns den Repository anschauen und die eben hinzugefügten Dateien finden:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/full_model_tf.png" alt="The 'Files and versions' tab now contains all the recently uploaded files." width="80%"/>
</div>

Mit der UI kannst du die Modell-Dateien und die Commits explorieren, um die Differenz bei jedem Commit zu sehen:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/diffstf.gif" alt="The diff introduced by the recent commit." width="80%"/>
</div>
{/if}


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/de/chapter4/3.mdx" />