# Fine-tuning, Check![[fine-tuning-check]]

<CourseFloatingBanner
    chapter={3}
    classNames="absolute z-10 right-0 top-0"
/>

That was comprehensive! In the first two chapters you learned about models and tokenizers, and now you know how to fine-tune them for your own data using modern best practices. To recap, in this chapter you:

* Learned about datasets on the [Hub](https://huggingface.co/datasets) and modern data processing techniques
* Learned how to load and preprocess datasets efficiently, including using dynamic padding and data collators
* Implemented fine-tuning and evaluation using the high-level `Trainer` API with the latest features
* Implemented a complete custom training loop from scratch with PyTorch
* Used 🤗 Accelerate to make your training code work seamlessly on multiple GPUs or TPUs
* Applied modern optimization techniques like mixed precision training and gradient accumulation

<Tip>

🎉 **Congratulations!** You've mastered the fundamentals of fine-tuning transformer models. You're now ready to tackle real-world ML projects!

📖 **Continue Learning**: Explore these resources to deepen your knowledge:
- [🤗 Transformers task guides](https://huggingface.co/docs/transformers/main/en/tasks/sequence_classification) for specific NLP tasks
- [🤗 Transformers examples](https://huggingface.co/docs/transformers/main/en/notebooks) for comprehensive notebooks

🚀 **Next Steps**: 
- Try fine-tuning on your own dataset using the techniques you've learned
- Experiment with different model architectures available on the [Hugging Face Hub](https://huggingface.co/models)
- Join the [Hugging Face community](https://discuss.huggingface.co/) to share your projects and get help

</Tip>

This is just the beginning of your journey with 🤗 Transformers. In the next chapter, we'll explore how to share your models and tokenizers with the community and contribute to the ever-growing ecosystem of pretrained models.

The skills you've developed here - data preprocessing, training configuration, evaluation, and optimization - are fundamental to any machine learning project. Whether you're working on text classification, named entity recognition, question answering, or any other NLP task, these techniques will serve you well.

<Tip>

💡 **Pro Tips for Success**:
- Always start with a strong baseline using the `Trainer` API before implementing custom training loops
- Use the 🤗 Hub to find pretrained models that are close to your task for better starting points
- Monitor your training with proper evaluation metrics and don't forget to save checkpoints
- Leverage the community - share your models and datasets to help others and get feedback on your work

</Tip>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/en/chapter3/6.mdx" />