# End-of-chapter quiz[[end-of-chapter-quiz]]

<CourseFloatingBanner
    chapter={4}
    classNames="absolute z-10 right-0 top-0"
/>

Let's test what you learned in this chapter!
  
### 1. What are models on the Hub limited to?

<Question
	choices={[
		{
			text: "Models from the 🤗 Transformers library.",
			explain: "While models from the 🤗 Transformers library are supported on the Hugging Face Hub, they're not the only ones!"
		},
		{
			text: "All models with a similar interface to 🤗 Transformers.",
			explain: "No interface requirement is set when uploading models to the Hugging Face Hub. "
		},
		{
			text: "There are no limits.",
			explain: "Right! There are no limits when uploading models to the Hub.",
            correct: true
		},
        {
			text: "Models that are in some way related to NLP.",
			explain: "No requirement is set regarding the field of application!"
		}
	]}
/>

### 2. How can you manage models on the Hub?

<Question
	choices={[
		{
			text: "Through a GCP account.",
			explain: "Incorrect!"
		},
		{
			text: "Through peer-to-peer distribution.",
			explain: "Incorrect!"
		},
		{
			text: "Through git and git-lfs.",
			explain: "Correct! Models on the Hub are simple Git repositories, leveraging <code>git-lfs</code> for large files.",
            correct: true
		}
	]}
/>

### 3. What can you do using the Hugging Face Hub web interface? 

<Question
	choices={[
		{
			text: "Fork an existing repository.",
			explain: "Forking a repository is not possible on the Hugging Face Hub."
		},
		{
			text: "Create a new model repository.",
			explain: "Correct! That's not all you can do, though.",
            correct: true
		},
		{
			text: "Manage and edit files.",
			explain: "Correct! That's not the only right answer, though.",
            correct: true
		},
        {
			text: "Upload files.",
			explain: "Right! But that's not all.",
            correct: true
		},
        {
			text: "See diffs across versions.",
			explain: "Correct! That's not all you can do, though.",
            correct: true
		}
	]}
/>

### 4. What is a model card?

<Question
	choices={[
		{
			text: "A rough description of the model, therefore less important than the model and tokenizer files.",
			explain: "It is indeed a description of the model, but it's an important piece: if it's incomplete or absent the model's utility is drastically reduced."
		},
		{
			text: "A way to ensure reproducibility, reusability, and fairness.",
			explain: "Correct! Sharing the right information in the model card will help users leverage your model and be aware of its limits and biases. ",
            correct: true
		},
		{
			text: "A Python file that can be run to retrieve information about the model.",
			explain: "Model cards are simple Markdown files."
		}
	]}
/>

### 5. Which of these objects of the 🤗 Transformers library can be directly shared on the Hub with `push_to_hub()`?

{#if fw === 'pt'}
<Question
	choices={[
		{
			text: "A tokenizer",
			explain: "Correct! All tokenizers have the <code>push_to_hub</code> method, and using it will push all the tokenizer files (vocabulary, architecture of the tokenizer, etc.) to a given repo. That's not the only right answer, though!",
            correct: true
		},
		{
			text: "A model configuration",
			explain: "Right! All model configurations have the <code>push_to_hub</code> method, and using it will push them to a given repo. What else can you share?",
            correct: true
		},
		{
			text: "A model",
			explain: "Correct! All models have the <code>push_to_hub</code> method, and using it will push them and their configuration files to a given repo. That's not all you can share, though.",
            correct: true
		},
        {
			text: "A Trainer",
			explain: "That's right — the <code>Trainer</code> also implements the <code>push_to_hub</code> method, and using it will upload the model, its configuration, the tokenizer, and a model card draft to a given repo. Try another answer!",
            correct: true
		}
	]}
/>
{:else}
<Question
	choices={[
		{
			text: "A tokenizer",
			explain: "Correct! All tokenizers have the <code>push_to_hub</code> method, and using it will push all the tokenizer files (vocabulary, architecture of the tokenizer, etc.) to a given repo. That's not the only right answer, though!",
            correct: true
		},
		{
			text: "A model configuration",
			explain: "Right! All model configurations have the <code>push_to_hub</code> method, and using it will push them to a given repo. What else can you share?",
            correct: true
		},
		{
			text: "A model",
			explain: "Correct! All models have the <code>push_to_hub</code> method, and using it will push them and their configuration files to a given repo. That's not all you can share, though.",
            correct: true
		},
		{
			text: "All of the above with a dedicated callback",
			explain: "That's right — the <code>PushToHubCallback</code> will regularly send all of those objects to a repo during training.",
            correct: true
		}
	]}
/>
{/if}

### 6. What is the first step when using the `push_to_hub()` method or the CLI tools?

<Question
	choices={[
		{
			text: "Log in on the website.",
			explain: "This won't help you on your local machine."
		},
		{
			text: "Run 'huggingface-cli login' in a terminal.",
			explain: "Correct — this will download and cache your personal token.",
            correct: true
		},
		{
			text: "Run 'notebook_login()' in a notebook.",
			explain: "Correct — this will display a widget to let you authenticate.",
            correct: true
		},
	]}
/>

### 7. You're using a model and a tokenizer — how can you upload them to the Hub?

<Question
	choices={[
		{
			text: "By calling the push_to_hub method directly on the model and the tokenizer.",
			explain: "Correct!",
            correct: true
		},
		{
			text: "Within the Python runtime, by wrapping them in a <code>huggingface_hub</code> utility.",
			explain: "Models and tokenizers already benefit from <code>huggingface_hub</code> utilities: no need for additional wrapping!"
		},
		{
			text: "By saving them to disk and calling <code>transformers-cli upload-model</code>",
			explain: "The command <code>upload-model</code> does not exist."
		}
	]}
/>

### 8. Which git operations can you do with the `Repository` class?

<Question
	choices={[
		{
			text: "A commit.",
			explain: "Correct, the <code>git_commit()</code> method is there for that.",
            correct: true
		},
		{
			text: "A pull",
			explain: "That is the purpose of the <code>git_pull()</code> method.",
            correct: true
		},
		{
			text: "A push",
			explain: "The method <code>git_push()</code> does this.",
            correct: true
		},
		{
			text: "A merge",
			explain: "No, that operation will never be possible with this API."
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/en/chapter4/6.mdx" />