# Introducción

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

## ¡Te damos la bienvenida al curso de 🤗!

<Youtube id="00GKzGyWFEs" />

Este curso te enseñará sobre procesamiento de lenguaje natural (PLN) usando librerías del ecosistema [Hugging Face](https://huggingface.co/) - [🤗 Transformers](https://github.com/huggingface/transformers), [🤗 Datasets](https://github.com/huggingface/datasets), [🤗 Tokenizers](https://github.com/huggingface/tokenizers) y [🤗 Accelerate](https://github.com/huggingface/accelerate) — así como el [Hub de Hugging Face](https://huggingface.co/models). El curso es completamente gratuito y sin anuncios.

## ¿Qué esperar?

Esta es una pequeña descripción del curso:

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/summary.svg" alt="Brief overview of the chapters of the course.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/summary-dark.svg" alt="Brief overview of the chapters of the course.">
</div>

- Los capítulos 1 a 4 ofrecen una introducción a los conceptos principales de la librería 🤗 Transformers. Al final de esta sección del curso, estarás familiarizado con la manera en que trabajan los Transformadores y sabrás cómo usar un modelo del [Hub de Hugging Face](https://huggingface.co/models), ajustarlo a tu conjunto de datos y compartir tus resultados en el Hub.
- Los capítulos 5 a 8 enseñan lo básico de 🤗 Datasets y 🤗 Tokenizers antes de entrar en tareas clásicas de PLN. Al final de esta sección, podrás abordar por ti mismo los problemas más comunes de PLN.
- Los capítulos 9 al 12 van más allá del PLN y exploran cómo los Transformadores pueden abordar tareas de procesamiento del habla y visión por computador. A lo largo del camino, aprenderás a construir y compartir demos de tus modelos, así como optimizarlos para entornos de producción. Al final de esta sección, estarás listo para aplicar 🤗 Transformers a (casi) cualquier problema de Machine Learning.

Este curso:

* Requiere amplio conocimiento de Python
* Debería ser tomado después de un curso de introducción a deep learning, como [Practical Deep Learning for Coders](https://course.fast.ai/) de [fast.ai's](https://www.fast.ai/) o alguno de los programas desarrollados por [DeepLearning.AI](https://www.deeplearning.ai/)
* No necesita conocimiento previo de [PyTorch](https://pytorch.org/) o [TensorFlow](https://www.tensorflow.org/), aunque un nivel de familiaridad con alguno de los dos podría ser útil

Después de que hayas completado este curso, te recomendamos revisar la [Especialización en Procesamiento de Lenguaje Natural](https://www.coursera.org/specializations/natural-language-processing?utm_source=deeplearning-ai&utm_medium=institutions&utm_campaign=20211011-PLN-2-hugging_face-page-PLN-refresh) de DeepLearning.AI, que cubre un gran número de modelos tradicionales de PLN como Naive Bayes y LSTMs.

## ¿Quiénes somos?

Acerca de los autores:

**Matthew Carrigan** es Ingeniero de Machine Learning en Hugging Face. Vive en Dublin, Irlanda y anteriormente trabajó como Ingeniero ML en Parse.ly y como investigador post-doctoral en Trinity College Dublin. No cree que vamos a alcanzar una Inteligencia Artificial General escalando arquitecturas existentes, pero en todo caso tiene grandes expectativas sobre la inmortalidad robótica.

**Lysandre Debut** es Ingeniero de Machine Learning en Hugging Face y ha trabajado en la librería 🤗 Transformers desde sus etapas de desarrollo más tempranas. Su objetivo es hacer que el PLN sea accesible para todos a través del desarrollo de herramientas con una API muy simple.

**Sylvain Gugger** es Ingeniero de Investigación en Hugging Face y uno de los principales mantenedores de la librería 🤗 Transformers. Anteriormente fue Científico de Investigación en fast.ai y escribió _[Deep Learning for Coders with fastai and PyTorch](https://learning.oreilly.com/library/view/deep-learning-for/9781492045519/)_ junto con Jeremy Howard. El foco principal de su investigación es hacer el deep learning más accesible, al diseñar y mejorar técnicas que permiten un entrenamiento rápido de modelos con recursos limitados.

**Merve Noyan** es Promotora de Desarrolladores en Hugging Face, trabaja en el desarrollo de herramientas y construcción de contenido relacionado, con el fín de democratizar el machine learning para todos.

**Lucile Saulnier** es Ingeniera de Machine Learning en Hugging Face, donde desarrolla y apoya el uso de herramientas de código abierto. Ella está activamente involucrada en varios proyectos de investigación en el campo del Procesamiento de Lenguaje Natural como entrenamiento colaborativo y BigScience.

**Lewis Tunstall**  es Ingeniero de Machine Learning en Hugging Face, enfocado en desarrollar herramientas de código abierto y hacerlas accesibles a la comunidad en general. También es coautor de un próximo [libro de O'Reilly sobre Transformadores](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/).

**Leandro von Werra**  es Ingeniero de Machine Learning en el equipo de código abierto en Hugging Face y coautor de un próximo [libro de O'Reilly sobre Transformadores](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/). Tiene varios años de experiencia en la industria llevando modelos de PLN a producción, trabajando a lo largo de todo el entorno de Machine Learning. 

¿Estás listo para comenzar? En este capítulo vas a aprender:
* Cómo usar la función `pipeline()` para resolver tareas de PLN como la generación y clasificación de texto
* Sobre la arquitectura de los Transformadores
* Cómo distinguir entre las arquitecturas de codificador, decodificador y codificador-decofidicador, además de sus casos de uso

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/es/chapter1/1.mdx" />