# Quiz de final de capítulo

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

¡Este capítulo cubrió una gran variedad de temas! No te preocupes si no entendiste todos los detalles; los siguientes capítulos te ayudarán a entender cómo funcionan las cosas detrás de cámaras.

Por ahora, ¡revisemos lo que aprendiste en este capítulo!

### 1. Explora el Hub y busca el punto de control `roberta-large-mnli`. ¿Qué tarea desarrolla?

<Question
	choices={[
		{
			text: "Resumen",
			explain: "Vuelve a mirar en la <a href=\"https://huggingface.co/roberta-large-mnli\">página de roberta-large-mnli</a>."
		},
		{
			text: "Clasificación de texto",
			explain: " Más precisamente, clasifica si dos oraciones están relacionadas lógicamente a través de tres etiquetas (contradiction, neutral, entailment) - una tarea que también se conoce como <em>inferencia de lenguaje natural</em>.", 
			correct: true
		},
		{
			text: "Generación de texto",
			explain: "Vuelve a mirar en la <a href=\"https://huggingface.co/roberta-large-mnli\">página de roberta-large-mnli</a>."
		}
	]}
/>

### 2. ¿Qué devuelve el siguiente código?

```py
from transformers import pipeline

ner = pipeline("ner", grouped_entities=True)
ner("My name is Sylvain and I work at Hugging Face in Brooklyn.")
```

<Question
	choices={[
		{
			text: "Devuelve los puntajes de clasificación de esta oración, con las etiquetas \"positive\" o \"negative\".",
			explain: "Incorrecto - esto sería un pipeline de <code>sentiment-analysis</code>."
		},
		{
			text: "Devuelve un texto generado que completa esta oración.",
			explain: "Incorrecto - esto sería un pipeline de <code>text-generation</code>."
		},
		{
			text: "Devuelve las palabras que representan personas, organizaciones o ubicaciones.",
			explain: "Adicionalmente, con <code>grouped_entities=True</code>, agrupará las palabras que pertenecen a la misma entidad, como \"Hugging Face\".",
			correct: true
		}
	]}
/>

### 3. ¿Qué debería reemplazar ... en este ejemplo de código?

```py
from transformers import pipeline

filler = pipeline("fill-mask", model="bert-base-cased")
result = filler("...")
```

<Question
	choices={[
		{
			text: "This &#60;mask> has been waiting for you.",
			explain: "Incorrecto. Revisa la ficha del modelo <code>bert-base-cased</code> e intenta identificar tu error."
		},
		{
			text: "This [MASK] has been waiting for you.",
			explain: "¡Correcto! El mask token de este modelo es [MASK].",
			correct: true
		},
		{
			text: "This man has been waiting for you.",
			explain: "Incorrecto. Este pipeline llena palabras ocultas, por lo que necesita un mask token en algún lugar."
		}
	]}
/>

### 4. ¿Por qué fallará este código?

```py
from transformers import pipeline

classifier = pipeline("zero-shot-classification")
result = classifier("This is a course about the Transformers library")
```

<Question
	choices={[
		{
			text: "Este pipeline necesita que se le indiquen etiquetas para clasificar el texto.",
			explain: "Correcto — el código necesita incluir <code>candidate_labels=[...]</code>.",
			correct: true
		},
		{
			text: "Este pipeline requiere varias oraciones, no sólo una.",
			explain: "Incorrecto, aunque cuando se usa adecuadamente, este pipeline puede tomar una lista de oraciones para procesar (como todos los otros pipelines)."
		},
		{
			text: "La librería 🤗 Transformers está dañada, como siempre.",
			explain: "¡No vamos a dignificar esta respuesta con un comentario!"
		},
		{
			text: "Este pipeline necesita entradas más largas; esta oración es muy corta.",
			explain: "Incorrecto. Un texto muy largo se va a truncar cuando se procesa por este pipeline."
		}
	]}
/>

### 5. ¿Qué significa "transferencia de aprendizaje"?

<Question
	choices={[
		{
			text: "Transferir el conocimiento de un modelo preentrenado a un nuevo modelo, al entrenarlo en el mismo conjunto de datos.",
			explain: "No, eso sería dos versiones del mismo modelo."
		},
		{
			text: "Transferir el conocimiento de un modelo preentrenado a un nuevo modelo al inicializar un segundo modelo con los pesos del primero.",
			explain: "Correcto: cuando el segundo modelo se entrena para una tarea nueva, éste *transfiere* el conocimiento del primero.",
			correct: true
		},
		{
			text: "Transferir el conocimiento de un modelo preentrenado al construir el segundo modelo con la misma arquitectura del primero.",
			explain: "La arquitectura sólo es la forma en que el modelo se construye; en este caso no hay conocimiento compartido o transferido."
		}
	]}
/>

### 6. ¿Verdadero o falso? Un modelo de lenguaje usualmente no necesita etiquetas para su preentrenamiento.

<Question
	choices={[
		{
			text: "Verdadero",
			explain: "El preentrenamiento suele ser <em>auto-supervisado</em>, lo que significa que las etiquetas se crean automáticamente a partir de la entrada (como predecir la siguiente palabra o llenar palabras ocultas).",
			correct: true
		},
		{
			text: "Falso",
			explain: "Esta no es la respuesta correcta."
		}
	]}
/>

### 7. Selecciona la oración que describe mejor los términos "modelo", "arquitectura" y "pesos".

<Question
	choices={[
		{
			text: "Si un modelo es un edificio, su arquitectura es el plano y los pesos son las personas que viven allí.",
			explain: "Siguiendo esta metáfora, los pesos serían los ladrillos y otros materiales usados para construir el edificio."
		},
		{
			text: "Una arquitectura es un mapa para construir un modelo y sus pesos son las ciudades representadas en el mapa.",
			explain: "El problema de esta metáfora es que un mapa suele representar una realidad existente (sólo hay una ciudad en Francia llamada Paris). Para una arquitectura dada son posibles múltiples pesos."
		},
		{
			text: "Una arquitectura es una sucesión de funciones matemáticas para construir un modelo y sus pesos son los parámetros de dichas funciones.",
			explain: "El mismo conjunto de funciones matemáticas (arquitectura) pueden usarse para construir diferentes modelos, usando diferentes parámetros (pesos).",
			correct: true
		}
	]}
/>


### 8. ¿Cuál de los siguientes tipos de modelos usarías para completar una indicación con texto generado?


<Question
	choices={[
		{
			text: "Un modelo de codificadores",
			explain: "Un modelo de codificadores genera una representación de la oración completa que es más adecuada para tareas como clasificación."
		},
		{
			text: "Un modelo de decodificadores",
			explain: "Los modelos de decodificadores son perfectamente adecuados para la generación de texto de una indicación.",
			correct: true
		},
		{
			text: "Un modelo secuencia a secuencia",
			explain: "Los modelos secuencia a secuencia son más adecuados para tareas en las que quieres generar oraciones en relación con las oraciones de entrada, no una indicación dada."
		}
	]}
/>

### 9. ¿Cuál de los siguientes tipos de modelos usarías para resumir textos?

<Question
	choices={[
		{
			text: "Un modelo de codificadores",
			explain: "Un modelo de codificadores genera una representación de la oración completa que es más adecuada para tareas como clasificación."
		},
		{
			text: "Un modelo de decodificadores",
			explain: "Los modelos de decodificadores son buenos para generar salidas de texto (como resúmenes), pero no tienen la habilidad de explotar un contexto como el texto completo para resumir."
		},
		{
			text: "Un modelo secuencia a secuencia",
			explain: "Los modelos secuencia a secuencia son perfectamente adecuados para una tarea de resumen.",
			correct: true
		}
	]}
/>

### 10. ¿Cuál de los siguientes tipos de modelos usarías para clasificar texto de acuerdo con ciertas etiquetas?

<Question
	choices={[
		{
			text: "Un modelo de codificadores",
			explain: "Un modelo de codificadores genera una representación de la oración completa que es perfectamente adecuado para una tarea como clasificación.",
			correct: true
		},
		{
			text: "Un modelo de decodificadores",
			explain: "Los modelos de decodificadores son buenos para generar textos de salida, no extraer una etiqueta de una oración."
		},
		{
			text: "Un modelo secuencia a secuencia",
			explain: "Los modelos secuencia a secuencia son más adecuados para tareas en las que quieres generar texto con base en una oración de entrada, no una etiqueta."
		}
	]}
/>

### 11. ¿Cuál puede ser una posible fuente del sesgo observado en un modelo?

<Question
	choices={[
		{
			text: "El modelo es una versión ajustada de un modelo preentrenado y tomó el sesgo a partir de allí.",
			explain: "Cuando se aplica la Transferencia de Aprendizaje, el sesgo en el modelo preentrenado se manifiesta en el modelo ajustado.",
			correct: true
		},
		{
			text: "Los datos con los que se entrenó el modelo están sesgados.",
			explain: "Esta es la fuente más obvia de sesgo, pero no la única.",
			correct: true
		},
		{
			text: "La métrica que el modelo estaba optimizando está sesgada.",
			explain: "Una fuente menos obvia de sesgo es la forma en que fue entrenado el modelo. El modelo va a optimizar ciegamente cualquier métrica que escojas, sin pensarlo dos veces.",
			correct: true
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/es/chapter1/10.mdx" />