# Quiz de final de capítulo

<CourseFloatingBanner chapter={3} classNames="absolute z-10 right-0 top-0" />

A ver qué has aprendido en este capítulo:

### 1. El dataset `emotion` contiene mensajes de Twitter etiquetados con emociones. Búscalo en el [Hub](https://huggingface.co/datasets), y lee la tarjeta del dataset. ¿Cuál de estas no es una de sus emociones básicas?

<Question
  choices={[
    {
      text: "Alegría",
      explain:
        "Inténtalo de nuevo: ¡esta emoción sí está presente en ese dataset!",
    },
    {
      text: "Amor",
      explain:
        "Inténtalo de nuevo: ¡esta emoción sí está presente en ese dataset!",
    },
    {
      text: "Confusión",
      explain:
        "¡Correcto! La confusión no es una de las seis emociones básicas.",
      correct: true,
    },
    {
      text: "Sorpresa",
      explain: "¡Sorpresa! Inténtalo de nuevo.",
    },
  ]}
/>

### 2. Busca el dataset `ar_sarcasm` en el [Hub](https://huggingface.co/datasets). ¿Con qué tarea es compatible?

<Question
  choices={[
    {
      text: "Clasificación de sentimientos",
      explain: "¡Correcto! Dale las gracias a las etiquetas.",
      correct: true,
    },
    {
      text: "Traducción automática",
      explain:
        "No es correcto, echa otro vistazo a la <a href='https://huggingface.co/datasets/ar_sarcasm'>tarjeta del dataset</a>.",
    },
    {
      text: "Reconocimiento de entidades nombradas",
      explain:
        "No es correcto, echa otro vistazo a la <a href='https://huggingface.co/datasets/ar_sarcasm'>tarjeta del dataset</a>.",
    },
    {
      text: "Responder preguntas",
      explain:
        "No es correcto, echa otro vistazo a la <a href='https://huggingface.co/datasets/ar_sarcasm'>tarjeta del dataset</a>.",
    },
  ]}
/>

### 3. ¿Cómo se procesan un par de frases según el modelo BERT?

<Question
  choices={[
    {
      text: "tokens_frase_1 [SEP] tokens_frase_2",
      explain:
        "Se necesita un token especial <code>[SEP]</code> para separar las dos frases, ¡pero falta algo más!",
    },
    {
      text: "[CLS] tokens_frase_1 tokens_frase_2",
      explain:
        "Se necesita un token especial <code>[CLS]</code> al principio, ¡pero falta algo más!",
    },
    {
      text: "[CLS] tokens_frase_1 [SEP] tokens_frase_2 [SEP]",
      explain: "¡Correcto!",
      correct: true,
    },
    {
      text: "[CLS] tokens_frase_1 [SEP] tokens_frase_2",
      explain:
        "Se necesita un token especial <code>[CLS]</code> al principio y un token especial <code>[SEP]</code> para separar las dos frases, ¡pero falta algo más!",
    },
  ]}
/>

{#if fw === 'pt'}

### 4. ¿Cuáles son las ventajas del método `Dataset.map()`?

<Question
  choices={[
    {
      text: "Los resultados de la función se almacenan en caché, por lo que no tardaremos nada en volver a ejecutar el código.",
      explain:
        "Esta es una de las grandes ventajas de este método. Aunque no es la única...",
      correct: true,
    },
    {
      text: "Puede aplicar multiprocesamiento para ir más rápido que si se aplicara la función a cada elemento del conjunto de datos.",
      explain:
        "Esta es una característica interesante de este método, ¡pero no es la única.",
      correct: true,
    },
    {
      text: "No carga todo el conjunto de datos en memoria, sino que guarda los resultados en cuanto se procesa un elemento.",
      explain: "Es una de las ventajas de este método, ¡pero hay más!",
      correct: true,
    },
  ]}
/>

### 5. ¿Qué significa padding dinámico?

<Question
  choices={[
    {
      text: "Es cuando se rellenan las entradas de cada lote con la longitud máxima de todo el conjunto de datos.",
      explain:
        "Sí que implica rellenar al crear el lote, pero no hasta la longitud máxima en todo el conjunto de datos.",
    },
    {
      text: "Es cuando rellenas tus entradas cuando se crea el lote, a la longitud máxima de las frases de ese lote.",
      explain:
        '¡Correcto! La parte "dinámica" proviene del hecho de que el tamaño de cada lote se determina en el momento de la creación, y como resultado todos sus lotes pueden tener diferentes formas.',
      correct: true,
    },
    {
      text: "Es cuando se rellenan las entradas para que cada frase tenga el mismo número de tokens que la anterior en el conjunto de datos.",
      explain:
        "Incorrecto, no tiene sentido mirar el orden de las muestras del conjunto de datos ya que lo barajamos durante el entrenamiento.",
    },
  ]}
/>

### 6. ¿Cuál es el objetivo de la función "collate"?

<Question
  choices={[
    {
      text: "Se asegura de que todas las secuencias del conjunto de datos tengan la misma longitud.",
      explain:
        'Una función "collate" está relacionada con el procesamiento de lotes individuales, no del conjunto de datos al completo. Además, estamos hablando de funciones "collate" genéricas, no <code>DataCollatorWithPadding</code> en especial.',
    },
    {
      text: "Combina todas las muestras del conjunto de datos en un lote.",
      explain:
        '¡Correcto! Puedes pasar una función "collate" como argumento a un <code>DataLoader</code>. Nosotros usamos la función <code>DataCollatorWithPadding</code>, que rellena todos los elementos de un lote para que tengan la misma longitud.',
      correct: true,
    },
    {
      text: "Preprocesa todo el conjunto de datos.",
      explain:
        'Eso sería una función de preprocesamiento, no una función "collate".',
    },
    {
      text: "Trunca las secuencias del conjunto de datos.",
      explain:
        'Una función "collate" está relacionada con el procesamiento de lotes individuales, no del conjunto de datos completo. Si quieres truncar, puedes utilizar el argumento <code>truncate</code> del <code>tokenizer</code>.',
    },
  ]}
/>

### 7. ¿Qué ocurre cuando instancias una de las clases `AutoModelForXxx` con un modelo del lenguaje preentrenado (como `bert-base-uncased`) que corresponde a una tarea distinta de aquella para la que fue entrenado?

<Question
  choices={[
    {
      text: "Nada, pero recibes una advertencia.",
      explain: "Recibes una advertencia, pero eso no es todo.",
    },
    {
      text: "La cabeza del modelo preentrenado se elimina y en su lugar se inserta una nueva cabeza adecuada para la tarea.",
      explain:
        "Correcto. Por ejemplo, cuando usamos <code>AutoModelForSequenceClassification</code> con <code>bert-base-uncased</code>, recibimos una advertencia al instanciar el modelo. La cabeza preentrenada no se puede utilizar para la tarea de clasificación de secuencias, por lo que es eliminada y se instancia una nueva cabeza con pesos aleatorios.",
      correct: true,
    },
    {
      text: "La cabeza del modelo preentrenado es eliminada.",
      explain: "Se necesita hacer algo más, inténtalo de nuevo.",
    },
    {
      text: "Nada, ya que el modelo se puede seguir ajustando para la otra tarea.",
      explain:
        "La cabeza del modelo preentrenado no fue entrenada para resolver esta tarea, ¡así que deberíamos eliminarla!",
    },
  ]}
/>

### 8. ¿Para qué sirve `TrainingArguments`?

<Question
  choices={[
    {
      text: "Contiene todos los hiperparámetros utilizados para el entrenamiento y la evaluación con <code>Trainer</code>.",
      explain: "¡Correcto!",
      correct: true,
    },
    {
      text: "Especifica el tamaño del modelo.",
      explain:
        "El tamaño del modelo viene definido por la configuración del modelo, no por la clase <code>TrainingArguments</code>.",
    },
    {
      text: "Solo contiene los hiperparámetros utilizados para la evaluación.",
      explain:
        "En el ejemplo especificamos dónde se guardarán el modelo y sus checkpoints. ¡Inténtalo de nuevo!",
    },
    {
      text: "Solo contiene los hiperparámetros utilizados para el entrenamiento.",
      explain:
        "En el ejemplo también utilizamos <code>evaluation_strategy</code>, que afecta a la evaluación. ¡Inténtalo de nuevo!",
    },
  ]}
/>

### 9. ¿Por qué deberías utilizar la librería 🤗 Accelerate?

<Question
  choices={[
    {
      text: "Facilita acceso a modelos más rápidos.",
      explain:
        "No, la librería 🤗 Accelerate library no proporciona modelos.",
    },
    {
      text: "Proporciona una API de alto nivel para que no tenga que implementar mi propio bucle de entrenamiento.",
      explain:
        "Eso es lo que hicimos con <code>Trainer</code>, no con la librería 🤗 Accelerate. ¡Vuelve a intentarlo!",
    },
    {
      text: "Hace que nuestros bucles de entrenamiento funcionen con estrategias distribuidas.",
      explain:
        "¡Correcto! Con 🤗 Accelerate, tus bucles de entrenamiento funcionarán para múltiples GPUs y TPUs.",
      correct: true,
    },
    {
      text: "Ofrece más funciones de optimización.",
      explain:
        "No, la librería 🤗 Accelerate no proporciona ninguna función de optimización.",
    },
  ]}
/>

{:else}

### 4. ¿Qué ocurre cuando instancias una de las clases `TFAutoModelForXxx` con un modelo del lenguaje preentrenado (como `bert-base-uncased`) que corresponde a una tarea distinta de aquella para la que fue entrenado?

<Question
  choices={[
    {
      text: "Nada, pero recibes una advertencia.",
      explain: "Recibes una advertencia, pero eso no es todo.",
    },
    {
      text: "La cabeza del modelo preentrenado se elimina y en su lugar se inserta una nueva cabeza adecuada para la tarea.",
      explain:
        "Correcto. Por ejemplo, cuando usamos <code>TFAutoModelForSequenceClassification</code> con <code>bert-base-uncased</code>, recibimos una advertencia al instanciar el modelo. La cabeza preentrenada no se puede utilizar para la tarea de clasificación de secuencias, por lo que es eliminada y se instancia una nueva cabeza con pesos aleatorios.",
      correct: true,
    },
    {
      text: "La cabeza del modelo preentrenado es eliminada",
      explain: "Se necesita hacer algo más, inténtalo de nuevo.",
    },
    {
      text: "Nada, ya que el modelo se puede seguir ajustando para la otra tarea.",
      explain:
        "La cabeza del modelo preentrenado no fue entrenada para resolver esta tarea, ¡así que deberíamos eliminarla!",
    },
  ]}
/>

### 5. Los modelos TensorFlow de `transformers` ya son modelos Keras. ¿Qué ventajas ofrece esto?

<Question
  choices={[
    {
      text: "Los modelos funcionan directamente en una TPU.",
      explain:
        "¡Casi! Se necesitan unos pequeños cambios adicionales. Por ejemplo, es necesario ejecutar todo en un entorno <code>TPUStrategy</code>, incluyendo la inicialización del modelo.",
    },
    {
      text: "Puede aprovechar los métodos existentes, como <code>compile()</code>, <code>fit()</code> y <code>predict()</code>.",
      explain:
        "¡Correcto! Una vez que tienes los datos, entrenar el modelo requiere muy poco esfuerzo.",
      correct: true,
    },
    {
      text: "Tienes la oportunidad de aprender Keras a la vez que transformadores.",
      explain: "Correcto, pero estamos buscando otra respuesta :)",
      correct: true,
    },
    {
      text: "Puede calcular fácilmente las métricas relacionadas con el dataset.",
      explain:
        "Keras nos ayuda con el entrenamiento y la evaluación del modelo, no con el cálculo de métricas relacionadas con el dataset.",
    },
  ]}
/>

### 6. ¿Cómo puedes definir tu propia métrica personalizada?

<Question
  choices={[
    {
      text: "Creando una subclase de <code>tf.keras.metrics.Metric</code>.",
      explain: "¡Genial!",
      correct: true,
    },
    {
      text: "Utilizando la API funcional de Keras.",
      explain: "¡Inténtalo de nuevo!",
    },
    {
      text: "Utilizando una función cuya firma sea <code>metric_fn(y_true, y_pred)</code>.",
      explain: "¡Correcto!",
      correct: true,
    },
    {
      text: "Buscándolo en Google.",
      explain:
        "Esta no es la respuesta que estamos buscando, pero te podría ayudar a encontrarla.",
      correct: true,
    },
  ]}
/>

{/if}


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/es/chapter3/6.mdx" />