# Quiz de final de capítulo

<CourseFloatingBanner
    chapter={5}
    classNames="absolute z-10 right-0 top-0"
/>

¡Vimos muchas cosas en este capítulo! No te preocupes si no te quedaron claros todos los detalles; los siguientes capítulos te ayudarán a entender cómo funcionan las cosas internamente.

Antes de seguir, probemos lo que aprendiste en este capítulo:

### 1. ¿Desde qué ubicaciones te permite cargar datasets la función `load_dataset()` en 🤗 Datasets?

<Question
	choices={[
		{
			text: "Localmente, e.g. en tu computador",
			explain: "¡Correcto! Puedes pasar las rutas de archivos locales al argumento <code>data_files</code> de <code>load_dataset()</code> para cargar datasets locales.",
			correct: true
		},
		{
			text: "El Hub de Hugging Face",
			explain: "¡Correcto! Puedes cargar datasets del Hub pasando el ID del dataset, e.g. <code>load_dataset('emotion')</code>.",
			correct: true
		},
		{
			text: "Un servidor remoto",
			explain: "¡Correcto! Puedes pasar URL al argumento <code>data_files</code> de la función <code>load_dataset()</code> para cargar archivos remotos.",
			correct: true
		},
	]}
/>

### 2. Supón que cargas una de las tareas de GLUE así:

```py
from datasets import load_dataset

dataset = load_dataset("glue", "mrpc", split="train")
```

¿Cuál de los siguientes comandos a a producir una muestra aleatoria de 50 elementos de `dataset`?

<Question
	choices={[
		{
			text: "<code>dataset.sample(50)</code>",
			explain: "Esto es incorrecto. No hay un método <code>Dataset.sample()</code>."
		},
		{
			text: "<code>dataset.shuffle().select(range(50))</code>",
			explain: "¡Correcto! Como viste en el capítulo, primero tienes que ordenar aleatoriamente el dataset y luego seleccionar las muestras.",
			correct: true
		},
		{
			text: "<code>dataset.select(range(50)).shuffle()</code>",
			explain: "Esto es incorrecto. Si bien el código se va a ejecutar, sólo va a ordenar aleatoriamente los primeros 50 elementos del dataset."
		}
	]}
/>

### 3. Supón que tienes un dataset sobre mascotas llamado `pets_dataset`, que tiene una columna `name` que contiene el nombre de cada mascota. ¿Cuál de los siguientes acercamientos te permitiría filtrar el dataset para todas las mascotas cuyos nombres comienzan con la letra "L"?

<Question
	choices={[
		{
			text: "<code>pets_dataset.filter(lambda x : x['name'].startswith('L'))</code>",
			explain: "¡Correcto! Usar una función lambda de Python para este tipo de filtros es una gran idea. ¿Se te ocurre otra solución?",
			correct: true
		},
		{
			text: "<code>pets_dataset.filter(lambda x['name'].startswith('L'))</code>",
			explain: "Esto es incorrecto. Una función lambda toma la forma general <code>lambda *arguments* : *expression*</code>, así que tienes que definir los argumentos en este caso."
		},
		{
			text: "Crear una función como <code>def filter_names(x): return x['name'].startswith('L')</code> y ejecutar <code>pets_dataset.filter(filter_names)</code>.",
			explain: "¡Correcto! Justo como con <code>Dataset.map()</code>, puedes pasar funciones explícitas a <code>Dataset.filter()</code>. Esto es útil cuando tienes una lógica compleja que no es adecuada para una función lambda. ¿Cuál de las otras soluciones podría funcionar?",
			correct: true
		}
	]}
/>

### 4. ¿Qué es la proyección en memoria (_memory mapping_)?

<Question
	choices={[
		{
			text: "Un mapeo entre la RAM de la CPU y la GPU",
			explain: "¡Incorrecto! intenta de nuevo.",
		},
		{
			text: "Un mapeo entre la RAM y el sistema de almacenamiento de archivos",
			explain: "¡Correcto! 🤗 Datasets trata cada dataset como un archivo proyectado en memoria. Esto le permite a la librería acceder y operar sobre los elementos del dataset sin necesidad de cargarlo por completo en memoria.",
			correct: true
		},
		{
			text: "Un mapeo entre dos archivos en el cache de 🤗 Datasets",
			explain: "¡Incorrecto! intenta de nuevo."
		}
	]}
/>

### 5. ¿Cuáles son los principales beneficios de la proyección en memoria?

<Question
	choices={[
		{
			text: "Acceder a los archivos proyectados en memoria es más rápido que leerlos de o guardarlos en el disco.",
			explain: "¡Correcto! Esto le permite a 🤗 Datasets ser muy rápido. Sin embargo, este no es el único beneficio.",
			correct: true
		},
		{
			text: "Las aplicaciones pueden acceder a segmentos de los datos en un archivo extremadamente grande sin necesidad de cargar el archivo completo en la RAM.",
			explain: "¡Correcto! Esto le permite a 🤗 Datasets cargar datasets de varios gigabytes en tu computador sin explotar tu CPU. ¿Qué otros beneficios ofrece la proyección en memoria?",
			correct: true
		},
		{
			text: "Consume menos energía, así que tu batería dura más.",
			explain: "¡Incorrecto! Intenta de nuevo."
		}
	]}
/>

### 6. ¿Por qué no funciona el siguiente código?

```py
from datasets import load_dataset

dataset = load_dataset("allocine", streaming=True, split="train")
dataset[0]
```

<Question
	choices={[
		{
			text: "Intenta hacer _streaming_ de un dataset que es muy grande para caber en la RAM.",
			explain: "Incorrecto. Los datasets _streamed_ se descomprimen sobre la marcha, por lo que puedes procesar datasets que pesen terabytes con muy poca RAM.",
		},
		{
			text: "Intenta acceder un <code>IterableDataset</code>.",
			explain: "¡Correcto! Un <code>IterableDataset</code> es un generador, no un contenedor, así que deberías acceder a sus elementos usando <code>next(iter(dataset))</code>.",
			correct: true
		},
		{
			text: "El dataset <code>allocine</code> no tiene un conjunto <code>train</code>.",
			explain: "Incorrecto. Revisa la [tarjeta del dataset <code>allocine</code>](https://huggingface.co/datasets/allocine) en el Hub para ver qué conjuntos contiene."
		}
	]}
/>

### 7. ¿Cuáles son los principales beneficios de crear una tarjeta para un dataset?

<Question
	choices={[
		{
			text: "Provee información sobre el uso esperado del dataset y las tareas soportadas, para que otros en la comunidad puedan tomar una decisión informada sobre usarlo.",
			explain: "¡Correcto! Los datasets sin documentación pueden ser usados para entrenar modelos que no reflejen las intensiones de sus creadores o pueden producir modelos cuyo estatus legal sea complejo si se entrenaron en datos que violen restricciones de privacidad o licenciamiento. ¡Pero este no es el único beneficio!",
			correct : true
		},
		{
			text: "Ayuda a llamar la atención a los sesgos que están presentes en un corpus.",
			explain: "¡Correcto! Casi todos los datasets tienen algún tipo de sesgo, lo que puede producir consecuencias negativas más adelante. Estar consciente de ellos ayuda a quienes construyen modelos a manejar estos sesgos. ¿Con qué otra cosa ayudan las tarjetas de los datasets?",
			correct : true
		},
		{
			text: "Aumenta las probabilidades de que otros en la comunidad usen mi dataset.",
			explain: "¡Correcto! Una tarjeta de un dataset bien escrita puede ayudar a que tu dataset tenga un mayor uso. ¿Qué otros beneficios ofrece?",
			correct: true
		},
	]}
/>


### 8. ¿Qué es la búsqueda semántica?

<Question
	choices={[
		{
			text: "Una forma de buscar coincidencias exactas entre las palabras de una pregunta y los documentos de un corpus",
			explain: "Esto es incorrecto. Este tipo de búsqueda se llama *búsqueda léxica* y es lo que ves típicamente en los motores tradicionales de búsqueda."
		},
		{
			text: "Una forma de emparejar documentos entendiendo el significado contextual de una pregunta",
			explain: "¡Correcto! La búsqueda semántica usa vectores de _embedding_ para representar preguntas y documentos, y usa una métrica de similaridad para medir la cantidad de coincidencia entre ellos. ¿Cómo más podrías describirlo?",
			correct: true
		},
		{
			text: "Una forma de mejorar la precisión de la búsqueda",
			explain: "¡Correcto! Los motores de búsqueda semántica pueden capturar la intención de una pregunta mucho mejor que la coincidencia de palabras clave y típicamente te permiten obtener documentos con mejor precisión. Pero esta no es la única respuesta correcta, ¿qué otra cosa puede hacer la búsqueda semántica?",
			correct: true
		}
	]}
/>

### 9. Para la búsqueda semántica asimétrica, usualmente tienes:

<Question
	choices={[
		{
			text: "Una pregunta corta y un párrafo largo que responde la pregunta",
			explain: "¡Correcto!",
			correct : true
		},
		{
			text: "Preguntas y párrafos de una longitud similar",
			explain: "¡Intenta de nuevo! De hecho, este es un ejemplo de búsqueda semántica simétrica."
		},
		{
			text: "Una pregunta larga y un párrafo más corto que responde la pregunta",
			explain: "¡Incorrecto! Intenta de nuevo."
		}
	]}
/>

### 10. ¿Puedo usar 🤗 Datasets para cargar datos y usarlos en otras áreas, como procesamiento de habla?

<Question
	choices={[
		{
			text: "No",
			explain: "Esto es incorrecto. 🤗 Datasets soporta datos tabulares, audio y visión artificial. Revisa el <a  href='https://huggingface.co/datasets/mnist'>dataset MNIST</a> en el Hub para un ejemplo de visión artificial."
		},
		{
			text: "Yes",
			explain: "¡Correcto! Revisa los desarrollos con habla y visión en la librería 🤗 Transformers para ver cómo se puede usar 🤗 Datasets en estas áreas.",
			correct : true
		},
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/es/chapter5/8.mdx" />