import{s as Ua,o as ma,n as Ps}from"../chunks/scheduler.cc52f4b9.js";import{S as Ta,i as ha,e as c,s as e,c as M,h as wa,a as j,d as n,b as t,f as ja,g as i,j as U,k as Ja,l as Ca,m as a,n as r,t as u,o as y,p as o}from"../chunks/index.9480bb2b.js";import{T as Ys}from"../chunks/Tip.f7b80743.js";import{C as da,H as fn,E as xa}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.04d617be.js";import{Y as ga}from"../chunks/Youtube.7b12d9e8.js";import{C as m}from"../chunks/CodeBlock.f4148b32.js";import{C as Ia}from"../chunks/CourseFloatingBanner.cdc38ef1.js";function fa(w){let p,T="💡 Cette section couvre le BPE en profondeur, allant jusqu’à montrer une implémentation complète. Vous pouvez passer directement à la fin si vous souhaitez simplement avoir un aperçu général de l’algorithme de tokenisation.";return{c(){p=c("p"),p.textContent=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-n0frxx"&&(p.textContent=T)},m(J,h){a(J,p,h)},p:Ps,d(J){J&&n(p)}}}function ba(w){let p,T="Les <em>tokenizers</em> du GPT-2 et de RoBERTa (qui sont assez similaires) ont une façon intelligente de gérer ce problème : ils ne considèrent pas les mots comme étant écrits avec des caractères Unicode mais avec des octets. De cette façon, le vocabulaire de base a une petite taille (256) et tous les caractères auxquels vous pouvez penser seront inclus dedans et ne finiront pas par être convertis en un <em>token</em> inconnu. Cette astuce est appelée <em>byte-level BPE</em>.";return{c(){p=c("p"),p.innerHTML=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-1ytsk3t"&&(p.innerHTML=T)},m(J,h){a(J,p,h)},p:Ps,d(J){J&&n(p)}}}function qa(w){let p,T="✏️ <strong>A votre tour !</strong> A votre avis, quelle sera la prochaine règle de fusion ?";return{c(){p=c("p"),p.innerHTML=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-1nzfw18"&&(p.innerHTML=T)},m(J,h){a(J,p,h)},p:Ps,d(J){J&&n(p)}}}function $a(w){let p,T="✏️ <strong>A votre tour !</strong> Comment pensez-vous que le mot « unhug » (détacher en français) sera tokenisé ?";return{c(){p=c("p"),p.innerHTML=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-g2m4o1"&&(p.innerHTML=T)},m(J,h){a(J,p,h)},p:Ps,d(J){J&&n(p)}}}function ka(w){let p,T="💡 Utiliser <code>train_new_from_iterator()</code> sur le même corpus ne donnera pas exactement le même vocabulaire. C’est parce que lorsqu’il y a un choix de la paire la plus fréquente, nous avons sélectionné la première rencontrée, alors que la bibliothèque 🤗 <em>Tokenizers</em> sélectionne la première en fonction de ses identifiants internes.";return{c(){p=c("p"),p.innerHTML=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-83jgtn"&&(p.innerHTML=T)},m(J,h){a(J,p,h)},p:Ps,d(J){J&&n(p)}}}function Qa(w){let p,T="⚠️ Notre implémentation lancera une erreur s’il y a un caractère inconnu puisque nous n’avons rien fait pour les gérer. GPT-2 n’a pas réellement de <i>token</i> inconnu (il est impossible d’obtenir un caractère inconnu en utilisant le BPE au niveau de l’octet) mais cela pourrait arriver ici car nous n’avons pas inclus tous les octets possibles dans le vocabulaire initial. Cet aspect du BPE dépasse le cadre de cette section, nous avons donc laissé ces détails de côté.";return{c(){p=c("p"),p.innerHTML=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-9fj1z7"&&(p.innerHTML=T)},m(J,h){a(J,p,h)},p:Ps,d(J){J&&n(p)}}}function Aa(w){let p,T,J,h,b,Fs,q,Ks,$,Os,k,bn="Le <em>Byte-Pair Encoding</em> (BPE) a été initialement développé en tant qu’algorithme de compression de textes puis utilisé par OpenAI pour la tokenisation du pré-entraînement du modèle GPT. Il est utilisé par de nombreux <em>transformers</em> dont GPT, GPT-2, RoBERTa, BART et DeBERTa.",sl,Q,ll,C,nl,A,al,B,qn="L’entraînement du BPE commence par le calcul de l’unique ensemble de mots utilisés dans le corpus (après les étapes de normalisation et de prétokénisation), puis la construction du vocabulaire en prenant tous les symboles utilisés pour écrire ces mots. A titre d’exemple, disons que notre corpus utilise ces cinq mots :",el,v,tl,V,$n="Le vocabulaire de base sera alors <code>[&quot;b&quot;, &quot;g&quot;, &quot;h&quot;, &quot;n&quot;, &quot;p&quot;, &quot;s&quot;, &quot;u&quot;]</code>. Dans le monde réel, le vocabulaire de base contient au moins tous les caractères ASCII et probablement aussi quelques caractères Unicode. Si un exemple que vous tokenisez utilise un caractère qui n’est pas dans le corpus d’entraînement, ce caractère est converti en <em>token</em> inconnu. C’est l’une des raisons pour lesquelles de nombreux modèles de NLP sont par exemple très mauvais dans l’analyse de contenus contenant des emojis.",pl,d,Ml,E,kn="Après avoir obtenu ce vocabulaire de base, nous ajoutons de nouveaux <em>tokens</em> jusqu’à ce que la taille souhaitée du vocabulaire soit atteinte en apprenant les fusions qui sont des règles permettant de fusionner deux éléments du vocabulaire existant pour en créer un nouveau. Ainsi, au début, ces fusions créeront des <em>tokens</em> de deux caractères, puis au fur et à mesure de l’entraînement, des sous-mots plus longs.",il,z,Qn="À chaque étape de l’entraînement du <em>tokenizer</em>, l’algorithme BPE recherche la paire la plus fréquente de <em>tokens</em> existants (par « paire », nous entendons ici deux <em>tokens</em> consécutifs dans un mot). Cette paire la plus fréquente est celle qui sera fusionnée. Nous rinçons et répétons pour l’étape suivante.",rl,Z,An="Pour revenir à notre exemple précédent, supposons que les mots ont les fréquences suivantes :",ul,G,yl,S,Bn="ce qui veut dire que <code>&quot;hug&quot;</code> était présent 10 fois dans le corpus, <code>&quot;pug&quot;</code> 5 fois, <code>&quot;pun&quot;</code> 12 fois, <code>&quot;bun&quot;</code> 4 fois et <code>&quot;hugs&quot;</code>” 5 fois. Nous commençons l’entraînement en divisant chaque mot en caractères (ceux qui forment notre vocabulaire initial) afin de voir chaque mot comme une liste de <em>tokens</em> :",ol,N,cl,_,vn="Ensuite, nous regardons les paires. La paire <code>(&quot;h&quot;, &quot;u&quot;)</code> est présente dans les mots <code>&quot;hug&quot;</code> et <code>&quot;hugs&quot;</code>, donc 15 fois au total dans le corpus. Ce n’est cependant pas la paire la plus fréquente. Cet honneur revient à <code>(&quot;u&quot;, &quot;g&quot;)</code> qui est présent dans <code>&quot;hug&quot;</code>, <code>&quot;pug&quot;</code>, et <code>&quot;hugs&quot;</code>, pour un total de 20 fois dans le vocabulaire.",jl,H,Vn="Ainsi, la première règle de fusion apprise par le <em>tokenizer</em> est <code>(&quot;u&quot;, &quot;g&quot;) -&gt; &quot;ug&quot;</code>, ce qui signifie que <code>&quot;ug&quot;</code> est ajouté au vocabulaire et que la paire doit être fusionnée dans tous les mots du corpus. A la fin de cette étape, le vocabulaire et le corpus ressemblent à ceci :",Jl,X,Ul,D,En="Nous avons maintenant quelques paires qui aboutissent à un <em>token</em> de plus de deux caractères. Par exemple la paire <code>(&quot;h&quot;, &quot;ug&quot;)</code> présente 15 fois dans le corpus. La paire la plus fréquente à ce stade est <code>(&quot;u&quot;, &quot;n&quot;)</code>, présente 16 fois dans le corpus, donc la deuxième règle de fusion apprise est <code>(&quot;u&quot;, &quot;n&quot;) -&gt; &quot;un&quot;</code>. En ajoutant cela au vocabulaire et en fusionnant toutes les occurrences existantes, nous obtenons :",ml,W,Tl,R,zn="Maintenant la paire la plus fréquente est <code>(&quot;h&quot;, &quot;ug&quot;)</code> donc nous apprenons la règle de fusion <code>(&quot;h&quot;, &quot;ug&quot;) -&gt; &quot;hug&quot;</code>. Cela nous donne donc notre premier <em>token</em> de trois lettres. Après la fusion, le corpus ressemble à ceci :",hl,Y,wl,P,Zn="Et nous continuons ainsi jusqu’à ce que nous atteignions la taille de vocabulaire souhaitée.",Cl,x,dl,L,xl,F,Gn="La tokenisation suit de près le processus d’entraînement, dans le sens où les nouvelles entrées sont tokenisées en appliquant les étapes suivantes :",gl,K,Sn="<li>Normalisation</li> <li>Prétokénisation</li> <li>Découpage des mots en caractères individuels</li> <li>Application des règles de fusion apprises dans l’ordre sur ces divisions.</li>",Il,O,Nn="Prenons l’exemple que nous avons utilisé pendant l’entraînement, avec les trois règles de fusion apprises :",fl,ss,bl,ls,_n="Le mot « bug »  sera traduit par « [“b”, “ug”] ». Par contre, le mot « mug » (tasse en français) sera traduit par « [”[UNK]”, “ug”] » puisque la lettre « m » ne fait pas partie du vocabulaire de base. De la même façon, le mot « thug » (voyou en français) sera tokenisé en « [”[UNK]”, “hug”] » car la lettre « t » n’est pas dans le vocabulaire de base et l’application des règles de fusion résulte d’abord en la fusion de « u » et « g » et ensuite en la fusion de « hu » et « g ».",ql,g,$l,ns,kl,as,Hn="Voyons maintenant une implémentation de l’algorithme BPE. Il ne s’agira pas d’une version optimisée que vous pourrez utiliser sur un grand corpus. Nous voulons simplement vous montrer le code afin que vous puissiez comprendre un peu mieux l’algorithme.",Ql,es,Xn="Tout d’abord, nous avons besoin d’un corpus, alors créons un corpus simple avec quelques phrases :",Al,ts,Bl,ps,Dn="Ensuite, nous devons prétokeniser ce corpus en mots. Puisque nous répliquons un <em>tokenizer</em> BPE (comme celui du GPT-2), nous utiliserons le <em>tokenizer</em> <code>gpt2</code> pour la prétokénisation :",vl,Ms,Vl,is,Wn="Ensuite, nous calculons les fréquences de chaque mot dans le corpus comme nous le faisons pour la prétokénisation :",El,rs,zl,us,Zl,ys,Rn="L’étape suivante consiste à calculer le vocabulaire de base, formé par tous les caractères utilisés dans le corpus :",Gl,os,Sl,cs,Nl,js,Yn="Nous ajoutons également les <em>tokens</em> spéciaux utilisés par le modèle au début de ce vocabulaire. Dans le cas du GPT-2, le seul <em>token</em> spécial est <code>&quot;&lt;|endoftext|&gt;&quot;</code> :",_l,Js,Hl,Us,Pn="Nous devons maintenant diviser chaque mot en caractères individuels pour pouvoir commencer l’entraînement :",Xl,ms,Dl,Ts,Ln="Maintenant que nous sommes prêts pour l’entraînement, écrivons une fonction qui calcule la fréquence de chaque paire. Nous devrons l’utiliser à chaque étape de l’entraînement :",Wl,hs,Rl,ws,Fn="Jetons un coup d’œil à une partie de ce dictionnaire après les premières divisions :",Yl,Cs,Pl,ds,Ll,xs,Kn="Maintenant, trouver la paire la plus fréquente ne demande qu’une rapide boucle :",Fl,gs,Kl,Is,Ol,fs,On="Donc la première fusion à apprendre est <code>(&#39;Ġ&#39;, &#39;t&#39;) -&gt; &#39;Ġt&#39;</code>, et on ajoute <code>&#39;Ġt&#39;</code> au vocabulaire :",sn,bs,ln,qs,sa="Pour continuer, nous devons appliquer cette fusion dans notre dictionnaire <code>splits</code>. Écrivons une autre fonction pour cela :",nn,$s,an,ks,la="Et nous pouvons regarder le résultat de la première fusion :",en,Qs,tn,As,pn,Bs,na="Maintenant, nous avons tout ce dont nous avons besoin pour boucler jusqu’à ce que nous ayons appris toutes les fusions que nous voulons. Visons une taille de vocabulaire de 50 :",Mn,vs,rn,Vs,aa="En conséquence, nous avons appris 19 règles de fusion (le vocabulaire initial avait une taille de 31 : 30 caractères dans l’alphabet plus le <em>token</em> spécial) :",un,Es,yn,zs,on,Zs,ea="Et le vocabulaire est composé du <em>token</em> spécial, de l’alphabet initial, et de tous les résultats des fusions :",cn,Gs,jn,Ss,Jn,I,Un,Ns,ta="Pour tokeniser un nouveau texte, on le prétokenise, on le divise, puis on applique toutes les règles de fusion apprises :",mn,_s,Tn,Hs,pa="Nous pouvons essayer cela sur n’importe quel texte composé de caractères de l’alphabet :",hn,Xs,wn,Ds,Cn,f,dn,Ws,Ma="C’est tout pour l’algorithme BPE ! Nous allons nous intéresser à WordPiece dans la suite.",xn,Rs,gn,Ls,In;return b=new da({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),q=new fn({props:{title:"Tokénisation <i> Byte-Pair Encoding </i>",local:"tokénisation-i-byte-pair-encoding-i",headingTag:"h1"}}),$=new Ia({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"English",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter6/section5.ipynb"},{label:"Français",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/fr/chapter6/section5.ipynb"},{label:"English",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter6/section5.ipynb"},{label:"Français",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/fr/chapter6/section5.ipynb"}]}}),Q=new ga({props:{id:"HEikzVL-lZU"}}),C=new Ys({props:{$$slots:{default:[fa]},$$scope:{ctx:w}}}),A=new fn({props:{title:"Algorithme d’entraînement",local:"algorithme-dentraînement",headingTag:"h2"}}),v=new m({props:{code:"JTIyaHVnJTIyJTJDJTIwJTIycHVnJTIyJTJDJTIwJTIycHVuJTIyJTJDJTIwJTIyYnVuJTIyJTJDJTIwJTIyaHVncyUyMiUyMCUyMyUyMCUyMmMlQzMlQTJsaW4lMjIlMkMlMjAlMjJjYXJsaW4lMjIlMkMlMjAlMjJqZXUlMjBkZSUyMG1vdHMlMjIlMkMlMjAlMjJicmlvY2hlJTIyJTJDJTIwJTIyYyVDMyVBMmxpbnMlMjI=",highlighted:'<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-string">&quot;pug&quot;</span>, <span class="hljs-string">&quot;pun&quot;</span>, <span class="hljs-string">&quot;bun&quot;</span>, <span class="hljs-string">&quot;hugs&quot;</span> <span class="hljs-meta"># <span class="hljs-string">&quot;câlin&quot;</span>, <span class="hljs-string">&quot;carlin&quot;</span>, <span class="hljs-string">&quot;jeu de mots&quot;</span>, <span class="hljs-string">&quot;brioche&quot;</span>, <span class="hljs-string">&quot;câlins&quot;</span></span>',wrap:!1}}),d=new Ys({props:{$$slots:{default:[ba]},$$scope:{ctx:w}}}),G=new m({props:{code:"KCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwdWclMjIlMkMlMjA1KSUyQyUyMCglMjJwdW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVncyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;bun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;hugs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),N=new m({props:{code:"KCUyMmglMjIlMjAlMjJ1JTIyJTIwJTIyZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMmclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMm4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnUlMjIlMjAlMjJnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span> <span class="hljs-string">&quot;s&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),X=new m({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiU1RCUwQUNvcnB1cyUzQSUyMCglMjJoJTIyJTIwJTIydWclMjIlMkMlMjAxMCklMkMlMjAoJTIycCUyMiUyMCUyMnVnJTIyJTJDJTIwNSklMkMlMjAoJTIycCUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwMTIpJTJDJTIwKCUyMmIlMjIlMjAlMjJ1JTIyJTIwJTIybiUyMiUyQyUyMDQpJTJDJTIwKCUyMmglMjIlMjAlMjJ1ZyUyMiUyMCUyMnMlMjIlMkMlMjA1KQ==",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),W=new m({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiUyQyUyMCUyMnVuJTIyJTVEJTBBQ29ycHVzJTNBJTIwKCUyMmglMjIlMjAlMjJ1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydWclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnVnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),Y=new m({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiUyQyUyMCUyMnVuJTIyJTJDJTIwJTIyaHVnJTIyJTVEJTBBQ29ycHVzJTNBJTIwKCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydWclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-string">&quot;hug&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;hug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),x=new Ys({props:{$$slots:{default:[qa]},$$scope:{ctx:w}}}),L=new fn({props:{title:"Algorithme de tokenisation",local:"algorithme-de-tokenisation",headingTag:"h2"}}),ss=new m({props:{code:"KCUyMnUlMjIlMkMlMjAlMjJnJTIyKSUyMC0lM0UlMjAlMjJ1ZyUyMiUwQSglMjJ1JTIyJTJDJTIwJTIybiUyMiklMjAtJTNFJTIwJTIydW4lMjIlMEEoJTIyaCUyMiUyQyUyMCUyMnVnJTIyKSUyMC0lM0UlMjAlMjJodWclMjI=",highlighted:`<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;ug&quot;</span>
<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;un&quot;</span>
<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;hug&quot;</span>`,wrap:!1}}),g=new Ys({props:{$$slots:{default:[$a]},$$scope:{ctx:w}}}),ns=new fn({props:{title:"Implémentation du BPE",local:"implémentation-du-bpe",headingTag:"h2"}}),ts=new m({props:{code:"Y29ycHVzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGlzJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBDb3Vyc2UuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwQydlc3QlMjBsZSUyMGNvdXJzJTIwZCdIdWdnaW5nJTIwRmFjZS4lMEElMjAlMjAlMjAlMjAlMjJUaGlzJTIwY2hhcHRlciUyMGlzJTIwYWJvdXQlMjB0b2tlbml6YXRpb24uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwQ2UlMjBjaGFwaXRyZSUyMHRyYWl0ZSUyMGRlJTIwbGElMjB0b2tlbmlzYXRpb24uJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMHNlY3Rpb24lMjBzaG93cyUyMHNldmVyYWwlMjB0b2tlbml6ZXIlMjBhbGdvcml0aG1zLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMyUyMENldHRlJTIwc2VjdGlvbiUyMHByJUMzJUE5c2VudGUlMjBwbHVzaWV1cnMlMjBhbGdvcml0aG1lcyUyMGRlJTIwdG9rZW5pemVyLiUwQSUyMCUyMCUyMCUyMCUyMkhvcGVmdWxseSUyQyUyMHlvdSUyMHdpbGwlMjBiZSUyMGFibGUlMjB0byUyMHVuZGVyc3RhbmQlMjBob3clMjB0aGV5JTIwYXJlJTIwdHJhaW5lZCUyMGFuZCUyMGdlbmVyYXRlJTIwdG9rZW5zLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMyUyMEF2ZWMlMjB1biUyMHBldSUyMGRlJTIwY2hhbmNlJTJDJTIwdm91cyUyMHNlcmV6JTIwZW4lMjBtZXN1cmUlMjBkZSUyMGNvbXByZW5kcmUlMjBjb21tZW50JTIwaWxzJTIwc29udCUyMGVudHJhJUMzJUFFbiVDMyVBOXMlMjBldCUyMGclQzMlQTluJUMzJUE4cmVudCUyMGRlcyUyMHRva2Vucy4lMEElNUQ=",highlighted:`corpus = [
    <span class="hljs-string">&quot;This is the Hugging Face Course.&quot;</span>,
    <span class="hljs-comment"># C&#x27;est le cours d&#x27;Hugging Face.</span>
    <span class="hljs-string">&quot;This chapter is about tokenization.&quot;</span>,
    <span class="hljs-comment"># Ce chapitre traite de la tokenisation.</span>
    <span class="hljs-string">&quot;This section shows several tokenizer algorithms.&quot;</span>,
    <span class="hljs-comment"># Cette section présente plusieurs algorithmes de tokenizer.</span>
    <span class="hljs-string">&quot;Hopefully, you will be able to understand how they are trained and generate tokens.&quot;</span>,
    <span class="hljs-comment"># Avec un peu de chance, vous serez en mesure de comprendre comment ils sont entraînés et génèrent des tokens.</span>
]`,wrap:!1}}),Ms=new m({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)`,wrap:!1}}),rs=new m({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEF3b3JkX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQSUwQWZvciUyMHRleHQlMjBpbiUyMGNvcnB1cyUzQSUwQSUyMCUyMCUyMCUyMHdvcmRzX3dpdGhfb2Zmc2V0cyUyMCUzRCUyMHRva2VuaXplci5iYWNrZW5kX3Rva2VuaXplci5wcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIodGV4dCklMEElMjAlMjAlMjAlMjBuZXdfd29yZHMlMjAlM0QlMjAlNUJ3b3JkJTIwZm9yJTIwd29yZCUyQyUyMG9mZnNldCUyMGluJTIwd29yZHNfd2l0aF9vZmZzZXRzJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwd29yZCUyMGluJTIwbmV3X3dvcmRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd29yZF9mcmVxcyU1QndvcmQlNUQlMjAlMkIlM0QlMjAxJTBBJTBBcHJpbnQod29yZF9mcmVxcyk=",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

word_freqs = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-keyword">for</span> text <span class="hljs-keyword">in</span> corpus:
    words_with_offsets = tokenizer.backend_tokenizer.pre_tokenizer.pre_tokenize_str(text)
    new_words = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> words_with_offsets]
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> new_words:
        word_freqs[word] += <span class="hljs-number">1</span>

<span class="hljs-built_in">print</span>(word_freqs)`,wrap:!1}}),us=new m({props:{code:"ZGVmYXVsdGRpY3QoaW50JTJDJTIwJTdCJ1RoaXMnJTNBJTIwMyUyQyUyMCclQzQlQTBpcyclM0ElMjAyJTJDJTIwJyVDNCVBMHRoZSclM0ElMjAxJTJDJTIwJyVDNCVBMEh1Z2dpbmcnJTNBJTIwMSUyQyUyMCclQzQlQTBGYWNlJyUzQSUyMDElMkMlMjAnJUM0JUEwQ291cnNlJyUzQSUyMDElMkMlMjAnLiclM0ElMjA0JTJDJTIwJyVDNCVBMGNoYXB0ZXInJTNBJTIwMSUyQyUwQSUyMCUyMCUyMCUyMCclQzQlQTBhYm91dCclM0ElMjAxJTJDJTIwJyVDNCVBMHRva2VuaXphdGlvbiclM0ElMjAxJTJDJTIwJyVDNCVBMHNlY3Rpb24nJTNBJTIwMSUyQyUyMCclQzQlQTBzaG93cyclM0ElMjAxJTJDJTIwJyVDNCVBMHNldmVyYWwnJTNBJTIwMSUyQyUyMCclQzQlQTB0b2tlbml6ZXInJTNBJTIwMSUyQyUyMCclQzQlQTBhbGdvcml0aG1zJyUzQSUyMDElMkMlMEElMjAlMjAlMjAlMjAnSG9wZWZ1bGx5JyUzQSUyMDElMkMlMjAnJTJDJyUzQSUyMDElMkMlMjAnJUM0JUEweW91JyUzQSUyMDElMkMlMjAnJUM0JUEwd2lsbCclM0ElMjAxJTJDJTIwJyVDNCVBMGJlJyUzQSUyMDElMkMlMjAnJUM0JUEwYWJsZSclM0ElMjAxJTJDJTIwJyVDNCVBMHRvJyUzQSUyMDElMkMlMjAnJUM0JUEwdW5kZXJzdGFuZCclM0ElMjAxJTJDJTIwJyVDNCVBMGhvdyclM0ElMjAxJTJDJTBBJTIwJTIwJTIwJTIwJyVDNCVBMHRoZXknJTNBJTIwMSUyQyUyMCclQzQlQTBhcmUnJTNBJTIwMSUyQyUyMCclQzQlQTB0cmFpbmVkJyUzQSUyMDElMkMlMjAnJUM0JUEwYW5kJyUzQSUyMDElMkMlMjAnJUM0JUEwZ2VuZXJhdGUnJTNBJTIwMSUyQyUyMCclQzQlQTB0b2tlbnMnJTNBJTIwMSU3RCk=",highlighted:`defaultdict(<span class="hljs-built_in">int</span>, {<span class="hljs-string">&#x27;This&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠHugging&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠFace&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠCourse&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;.&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;Ġchapter&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Ġabout&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokenization&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġsection&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġshows&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġseveral&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokenizer&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġalgorithms&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Hopefully&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;,&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġyou&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġwill&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġbe&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġable&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġunderstand&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġhow&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Ġthey&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġare&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtrained&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġand&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġgenerate&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokens&#x27;</span>: <span class="hljs-number">1</span>})`,wrap:!1}}),os=new m({props:{code:"YWxwaGFiZXQlMjAlM0QlMjAlNUIlNUQlMEElMEFmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzLmtleXMoKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGxldHRlciUyMGluJTIwd29yZCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGV0dGVyJTIwbm90JTIwaW4lMjBhbHBoYWJldCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFscGhhYmV0LmFwcGVuZChsZXR0ZXIpJTBBYWxwaGFiZXQuc29ydCgpJTBBJTBBcHJpbnQoYWxwaGFiZXQp",highlighted:`alphabet = []

<span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys():
    <span class="hljs-keyword">for</span> letter <span class="hljs-keyword">in</span> word:
        <span class="hljs-keyword">if</span> letter <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> alphabet:
            alphabet.append(letter)
alphabet.sort()

<span class="hljs-built_in">print</span>(alphabet)`,wrap:!1}}),cs=new m({props:{code:"JTVCJTIwJyUyQyclMkMlMjAnLiclMkMlMjAnQyclMkMlMjAnRiclMkMlMjAnSCclMkMlMjAnVCclMkMlMjAnYSclMkMlMjAnYiclMkMlMjAnYyclMkMlMjAnZCclMkMlMjAnZSclMkMlMjAnZiclMkMlMjAnZyclMkMlMjAnaCclMkMlMjAnaSclMkMlMjAnayclMkMlMjAnbCclMkMlMjAnbSclMkMlMjAnbiclMkMlMjAnbyclMkMlMjAncCclMkMlMjAnciclMkMlMjAncyclMkMlMEElMjAlMjAndCclMkMlMjAndSclMkMlMjAndiclMkMlMjAndyclMkMlMjAneSclMkMlMjAneiclMkMlMjAnJUM0JUEwJyU1RA==",highlighted:`[ <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;f&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>, <span class="hljs-string">&#x27;l&#x27;</span>, <span class="hljs-string">&#x27;m&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;p&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>,
  <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;v&#x27;</span>, <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>, <span class="hljs-string">&#x27;z&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>]`,wrap:!1}}),Js=new m({props:{code:"dm9jYWIlMjAlM0QlMjAlNUIlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlNUQlMjAlMkIlMjBhbHBoYWJldC5jb3B5KCk=",highlighted:'vocab = [<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>] + alphabet.copy()',wrap:!1}}),ms=new m({props:{code:"c3BsaXRzJTIwJTNEJTIwJTdCd29yZCUzQSUyMCU1QmMlMjBmb3IlMjBjJTIwaW4lMjB3b3JkJTVEJTIwZm9yJTIwd29yZCUyMGluJTIwd29yZF9mcmVxcy5rZXlzKCklN0Q=",highlighted:'splits = {word: [c <span class="hljs-keyword">for</span> c <span class="hljs-keyword">in</span> word] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys()}',wrap:!1}}),hs=new m({props:{code:"ZGVmJTIwY29tcHV0ZV9wYWlyX2ZyZXFzKHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjBwYWlyX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQSUyMCUyMCUyMCUyMGZvciUyMHdvcmQlMkMlMjBmcmVxJTIwaW4lMjB3b3JkX2ZyZXFzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGxpdCUyMCUzRCUyMHNwbGl0cyU1QndvcmQlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGxlbihzcGxpdCklMjAlM0QlM0QlMjAxJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29udGludWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oc3BsaXQpJTIwLSUyMDEpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFpciUyMCUzRCUyMChzcGxpdCU1QmklNUQlMkMlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhaXJfZnJlcXMlNUJwYWlyJTVEJTIwJTJCJTNEJTIwZnJlcSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHBhaXJfZnJlcXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_pair_freqs</span>(<span class="hljs-params">splits</span>):
    pair_freqs = defaultdict(<span class="hljs-built_in">int</span>)
    <span class="hljs-keyword">for</span> word, freq <span class="hljs-keyword">in</span> word_freqs.items():
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>):
            pair = (split[i], split[i + <span class="hljs-number">1</span>])
            pair_freqs[pair] += freq
    <span class="hljs-keyword">return</span> pair_freqs`,wrap:!1}}),Cs=new m({props:{code:"cGFpcl9mcmVxcyUyMCUzRCUyMGNvbXB1dGVfcGFpcl9mcmVxcyhzcGxpdHMpJTBBJTBBZm9yJTIwaSUyQyUyMGtleSUyMGluJTIwZW51bWVyYXRlKHBhaXJfZnJlcXMua2V5cygpKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlN0JrZXklN0QlM0ElMjAlN0JwYWlyX2ZyZXFzJTVCa2V5JTVEJTdEJTIyKSUwQSUyMCUyMCUyMCUyMGlmJTIwaSUyMCUzRSUzRCUyMDUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBicmVhaw==",highlighted:`pair_freqs = compute_pair_freqs(splits)

<span class="hljs-keyword">for</span> i, key <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(pair_freqs.keys()):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{key}</span>: <span class="hljs-subst">{pair_freqs[key]}</span>&quot;</span>)
    <span class="hljs-keyword">if</span> i &gt;= <span class="hljs-number">5</span>:
        <span class="hljs-keyword">break</span>`,wrap:!1}}),ds=new m({props:{code:"KCdUJyUyQyUyMCdoJyklM0ElMjAzJTBBKCdoJyUyQyUyMCdpJyklM0ElMjAzJTBBKCdpJyUyQyUyMCdzJyklM0ElMjA1JTBBKCclQzQlQTAnJTJDJTIwJ2knKSUzQSUyMDIlMEEoJyVDNCVBMCclMkMlMjAndCcpJTNBJTIwNyUwQSgndCclMkMlMjAnaCcpJTNBJTIwMw==",highlighted:`(<span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-number">3</span>
(<span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-number">3</span>
(<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>): <span class="hljs-number">5</span>
(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-number">2</span>
(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>): <span class="hljs-number">7</span>
(<span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-number">3</span>`,wrap:!1}}),gs=new m({props:{code:"YmVzdF9wYWlyJTIwJTNEJTIwJTIyJTIyJTBBbWF4X2ZyZXElMjAlM0QlMjBOb25lJTBBJTBBZm9yJTIwcGFpciUyQyUyMGZyZXElMjBpbiUyMHBhaXJfZnJlcXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWF4X2ZyZXElMjBpcyUyME5vbmUlMjBvciUyMG1heF9mcmVxJTIwJTNDJTIwZnJlcSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJlc3RfcGFpciUyMCUzRCUyMHBhaXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfZnJlcSUyMCUzRCUyMGZyZXElMEElMEFwcmludChiZXN0X3BhaXIlMkMlMjBtYXhfZnJlcSk=",highlighted:`best_pair = <span class="hljs-string">&quot;&quot;</span>
max_freq = <span class="hljs-literal">None</span>

<span class="hljs-keyword">for</span> pair, freq <span class="hljs-keyword">in</span> pair_freqs.items():
    <span class="hljs-keyword">if</span> max_freq <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_freq &lt; freq:
        best_pair = pair
        max_freq = freq

<span class="hljs-built_in">print</span>(best_pair, max_freq)`,wrap:!1}}),Is=new m({props:{code:"KCclQzQlQTAnJTJDJTIwJ3QnKSUyMDc=",highlighted:'(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>) <span class="hljs-number">7</span>',wrap:!1}}),bs=new m({props:{code:"bWVyZ2VzJTIwJTNEJTIwJTdCKCUyMiVDNCVBMCUyMiUyQyUyMCUyMnQlMjIpJTNBJTIwJTIyJUM0JUEwdCUyMiU3RCUwQXZvY2FiLmFwcGVuZCglMjIlQzQlQTB0JTIyKQ==",highlighted:`merges = {(<span class="hljs-string">&quot;Ġ&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>): <span class="hljs-string">&quot;Ġt&quot;</span>}
vocab.append(<span class="hljs-string">&quot;Ġt&quot;</span>)`,wrap:!1}}),$s=new m({props:{code:"ZGVmJTIwbWVyZ2VfcGFpcihhJTJDJTIwYiUyQyUyMHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXQlMjAlM0QlMjBzcGxpdHMlNUJ3b3JkJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsZW4oc3BsaXQpJTIwJTNEJTNEJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbnRpbnVlJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaSUyMCUzRCUyMDAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aGlsZSUyMGklMjAlM0MlMjBsZW4oc3BsaXQpJTIwLSUyMDElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHNwbGl0JTVCaSU1RCUyMCUzRCUzRCUyMGElMjBhbmQlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEJTIwJTNEJTNEJTIwYiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0JTIwJTNEJTIwc3BsaXQlNUIlM0FpJTVEJTIwJTJCJTIwJTVCYSUyMCUyQiUyMGIlNUQlMjAlMkIlMjBzcGxpdCU1QmklMjAlMkIlMjAyJTIwJTNBJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGklMjAlMkIlM0QlMjAxJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXRzJTVCd29yZCU1RCUyMCUzRCUyMHNwbGl0JTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3BsaXRz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">merge_pair</span>(<span class="hljs-params">a, b, splits</span>):
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs:
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>

        i = <span class="hljs-number">0</span>
        <span class="hljs-keyword">while</span> i &lt; <span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>:
            <span class="hljs-keyword">if</span> split[i] == a <span class="hljs-keyword">and</span> split[i + <span class="hljs-number">1</span>] == b:
                split = split[:i] + [a + b] + split[i + <span class="hljs-number">2</span> :]
            <span class="hljs-keyword">else</span>:
                i += <span class="hljs-number">1</span>
        splits[word] = split
    <span class="hljs-keyword">return</span> splits`,wrap:!1}}),Qs=new m({props:{code:"c3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpciglMjIlQzQlQTAlMjIlMkMlMjAlMjJ0JTIyJTJDJTIwc3BsaXRzKSUwQXByaW50KHNwbGl0cyU1QiUyMiVDNCVBMHRyYWluZWQlMjIlNUQp",highlighted:`splits = merge_pair(<span class="hljs-string">&quot;Ġ&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>, splits)
<span class="hljs-built_in">print</span>(splits[<span class="hljs-string">&quot;Ġtrained&quot;</span>])`,wrap:!1}}),As=new m({props:{code:"JTVCJyVDNCVBMHQnJTJDJTIwJ3InJTJDJTIwJ2EnJTJDJTIwJ2knJTJDJTIwJ24nJTJDJTIwJ2UnJTJDJTIwJ2QnJTVE",highlighted:'[<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>]',wrap:!1}}),vs=new m({props:{code:"dm9jYWJfc2l6ZSUyMCUzRCUyMDUwJTBBJTBBd2hpbGUlMjBsZW4odm9jYWIpJTIwJTNDJTIwdm9jYWJfc2l6ZSUzQSUwQSUyMCUyMCUyMCUyMHBhaXJfZnJlcXMlMjAlM0QlMjBjb21wdXRlX3BhaXJfZnJlcXMoc3BsaXRzKSUwQSUyMCUyMCUyMCUyMGJlc3RfcGFpciUyMCUzRCUyMCUyMiUyMiUwQSUyMCUyMCUyMCUyMG1heF9mcmVxJTIwJTNEJTIwTm9uZSUwQSUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMkMlMjBmcmVxJTIwaW4lMjBwYWlyX2ZyZXFzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMG1heF9mcmVxJTIwaXMlMjBOb25lJTIwb3IlMjBtYXhfZnJlcSUyMCUzQyUyMGZyZXElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiZXN0X3BhaXIlMjAlM0QlMjBwYWlyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X2ZyZXElMjAlM0QlMjBmcmVxJTBBJTIwJTIwJTIwJTIwc3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpcigqYmVzdF9wYWlyJTJDJTIwc3BsaXRzKSUwQSUyMCUyMCUyMCUyMG1lcmdlcyU1QmJlc3RfcGFpciU1RCUyMCUzRCUyMGJlc3RfcGFpciU1QjAlNUQlMjAlMkIlMjBiZXN0X3BhaXIlNUIxJTVEJTBBJTIwJTIwJTIwJTIwdm9jYWIuYXBwZW5kKGJlc3RfcGFpciU1QjAlNUQlMjAlMkIlMjBiZXN0X3BhaXIlNUIxJTVEKQ==",highlighted:`vocab_size = <span class="hljs-number">50</span>

<span class="hljs-keyword">while</span> <span class="hljs-built_in">len</span>(vocab) &lt; vocab_size:
    pair_freqs = compute_pair_freqs(splits)
    best_pair = <span class="hljs-string">&quot;&quot;</span>
    max_freq = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">for</span> pair, freq <span class="hljs-keyword">in</span> pair_freqs.items():
        <span class="hljs-keyword">if</span> max_freq <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_freq &lt; freq:
            best_pair = pair
            max_freq = freq
    splits = merge_pair(*best_pair, splits)
    merges[best_pair] = best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>]
    vocab.append(best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>])`,wrap:!1}}),Es=new m({props:{code:"cHJpbnQobWVyZ2VzKQ==",highlighted:'<span class="hljs-built_in">print</span>(merges)',wrap:!1}}),zs=new m({props:{code:"JTdCKCclQzQlQTAnJTJDJTIwJ3QnKSUzQSUyMCclQzQlQTB0JyUyQyUyMCgnaSclMkMlMjAncycpJTNBJTIwJ2lzJyUyQyUyMCgnZSclMkMlMjAncicpJTNBJTIwJ2VyJyUyQyUyMCgnJUM0JUEwJyUyQyUyMCdhJyklM0ElMjAnJUM0JUEwYSclMkMlMjAoJyVDNCVBMHQnJTJDJTIwJ28nKSUzQSUyMCclQzQlQTB0byclMkMlMjAoJ2UnJTJDJTIwJ24nKSUzQSUyMCdlbiclMkMlMEElMjAoJ1QnJTJDJTIwJ2gnKSUzQSUyMCdUaCclMkMlMjAoJ1RoJyUyQyUyMCdpcycpJTNBJTIwJ1RoaXMnJTJDJTIwKCdvJyUyQyUyMCd1JyklM0ElMjAnb3UnJTJDJTIwKCdzJyUyQyUyMCdlJyklM0ElMjAnc2UnJTJDJTIwKCclQzQlQTB0byclMkMlMjAnaycpJTNBJTIwJyVDNCVBMHRvayclMkMlMEElMjAoJyVDNCVBMHRvayclMkMlMjAnZW4nKSUzQSUyMCclQzQlQTB0b2tlbiclMkMlMjAoJ24nJTJDJTIwJ2QnKSUzQSUyMCduZCclMkMlMjAoJyVDNCVBMCclMkMlMjAnaXMnKSUzQSUyMCclQzQlQTBpcyclMkMlMjAoJyVDNCVBMHQnJTJDJTIwJ2gnKSUzQSUyMCclQzQlQTB0aCclMkMlMjAoJyVDNCVBMHRoJyUyQyUyMCdlJyklM0ElMjAnJUM0JUEwdGhlJyUyQyUwQSUyMCgnaSclMkMlMjAnbicpJTNBJTIwJ2luJyUyQyUyMCgnJUM0JUEwYSclMkMlMjAnYicpJTNBJTIwJyVDNCVBMGFiJyUyQyUyMCgnJUM0JUEwdG9rZW4nJTJDJTIwJ2knKSUzQSUyMCclQzQlQTB0b2tlbmknJTdE",highlighted:`{(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>): <span class="hljs-string">&#x27;Ġt&#x27;</span>, (<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>): <span class="hljs-string">&#x27;is&#x27;</span>, (<span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>): <span class="hljs-string">&#x27;er&#x27;</span>, (<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>): <span class="hljs-string">&#x27;Ġa&#x27;</span>, (<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>): <span class="hljs-string">&#x27;Ġto&#x27;</span>, (<span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>): <span class="hljs-string">&#x27;en&#x27;</span>,
 (<span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-string">&#x27;Th&#x27;</span>, (<span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>): <span class="hljs-string">&#x27;This&#x27;</span>, (<span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>): <span class="hljs-string">&#x27;ou&#x27;</span>, (<span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>): <span class="hljs-string">&#x27;se&#x27;</span>, (<span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>): <span class="hljs-string">&#x27;Ġtok&#x27;</span>,
 (<span class="hljs-string">&#x27;Ġtok&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>): <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, (<span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>): <span class="hljs-string">&#x27;nd&#x27;</span>, (<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>): <span class="hljs-string">&#x27;Ġis&#x27;</span>, (<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-string">&#x27;Ġth&#x27;</span>, (<span class="hljs-string">&#x27;Ġth&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>): <span class="hljs-string">&#x27;Ġthe&#x27;</span>,
 (<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>): <span class="hljs-string">&#x27;in&#x27;</span>, (<span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>): <span class="hljs-string">&#x27;Ġab&#x27;</span>, (<span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-string">&#x27;Ġtokeni&#x27;</span>}`,wrap:!1}}),Gs=new m({props:{code:"cHJpbnQodm9jYWIp",highlighted:'<span class="hljs-built_in">print</span>(vocab)',wrap:!1}}),Ss=new m({props:{code:"JTVCJyUzQyU3Q2VuZG9mdGV4dCU3QyUzRSclMkMlMjAnJTJDJyUyQyUyMCcuJyUyQyUyMCdDJyUyQyUyMCdGJyUyQyUyMCdIJyUyQyUyMCdUJyUyQyUyMCdhJyUyQyUyMCdiJyUyQyUyMCdjJyUyQyUyMCdkJyUyQyUyMCdlJyUyQyUyMCdmJyUyQyUyMCdnJyUyQyUyMCdoJyUyQyUyMCdpJyUyQyUyMCdrJyUyQyUyMCdsJyUyQyUyMCdtJyUyQyUyMCduJyUyQyUyMCdvJyUyQyUwQSUyMCdwJyUyQyUyMCdyJyUyQyUyMCdzJyUyQyUyMCd0JyUyQyUyMCd1JyUyQyUyMCd2JyUyQyUyMCd3JyUyQyUyMCd5JyUyQyUyMCd6JyUyQyUyMCclQzQlQTAnJTJDJTIwJyVDNCVBMHQnJTJDJTIwJ2lzJyUyQyUyMCdlciclMkMlMjAnJUM0JUEwYSclMkMlMjAnJUM0JUEwdG8nJTJDJTIwJ2VuJyUyQyUyMCdUaCclMkMlMjAnVGhpcyclMkMlMjAnb3UnJTJDJTIwJ3NlJyUyQyUwQSUyMCclQzQlQTB0b2snJTJDJTIwJyVDNCVBMHRva2VuJyUyQyUyMCduZCclMkMlMjAnJUM0JUEwaXMnJTJDJTIwJyVDNCVBMHRoJyUyQyUyMCclQzQlQTB0aGUnJTJDJTIwJ2luJyUyQyUyMCclQzQlQTBhYiclMkMlMjAnJUM0JUEwdG9rZW5pJyU1RA==",highlighted:`[<span class="hljs-string">&#x27;&lt;|endoftext|&gt;&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;f&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>, <span class="hljs-string">&#x27;l&#x27;</span>, <span class="hljs-string">&#x27;m&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>,
 <span class="hljs-string">&#x27;p&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;v&#x27;</span>, <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>, <span class="hljs-string">&#x27;z&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;er&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;This&#x27;</span>, <span class="hljs-string">&#x27;ou&#x27;</span>, <span class="hljs-string">&#x27;se&#x27;</span>,
 <span class="hljs-string">&#x27;Ġtok&#x27;</span>, <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;nd&#x27;</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>, <span class="hljs-string">&#x27;Ġth&#x27;</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>, <span class="hljs-string">&#x27;in&#x27;</span>, <span class="hljs-string">&#x27;Ġab&#x27;</span>, <span class="hljs-string">&#x27;Ġtokeni&#x27;</span>]`,wrap:!1}}),I=new Ys({props:{$$slots:{default:[ka]},$$scope:{ctx:w}}}),_s=new m({props:{code:"ZGVmJTIwdG9rZW5pemUodGV4dCklM0ElMEElMjAlMjAlMjAlMjBwcmVfdG9rZW5pemVfcmVzdWx0JTIwJTNEJTIwdG9rZW5pemVyLl90b2tlbml6ZXIucHJlX3Rva2VuaXplci5wcmVfdG9rZW5pemVfc3RyKHRleHQpJTBBJTIwJTIwJTIwJTIwcHJlX3Rva2VuaXplZF90ZXh0JTIwJTNEJTIwJTVCd29yZCUyMGZvciUyMHdvcmQlMkMlMjBvZmZzZXQlMjBpbiUyMHByZV90b2tlbml6ZV9yZXN1bHQlNUQlMEElMjAlMjAlMjAlMjBzcGxpdHMlMjAlM0QlMjAlNUIlNUJsJTIwZm9yJTIwbCUyMGluJTIwd29yZCU1RCUyMGZvciUyMHdvcmQlMjBpbiUyMHByZV90b2tlbml6ZWRfdGV4dCU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMkMlMjBtZXJnZSUyMGluJTIwbWVyZ2VzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpZHglMkMlMjBzcGxpdCUyMGluJTIwZW51bWVyYXRlKHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpJTIwJTNEJTIwMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdoaWxlJTIwaSUyMCUzQyUyMGxlbihzcGxpdCklMjAtJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwc3BsaXQlNUJpJTVEJTIwJTNEJTNEJTIwcGFpciU1QjAlNUQlMjBhbmQlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEJTIwJTNEJTNEJTIwcGFpciU1QjElNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGxpdCUyMCUzRCUyMHNwbGl0JTVCJTNBaSU1RCUyMCUyQiUyMCU1Qm1lcmdlJTVEJTIwJTJCJTIwc3BsaXQlNUJpJTIwJTJCJTIwMiUyMCUzQSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpJTIwJTJCJTNEJTIwMSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0cyU1QmlkeCU1RCUyMCUzRCUyMHNwbGl0JTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3VtKHNwbGl0cyUyQyUyMCU1QiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">text</span>):
    pre_tokenize_result = tokenizer._tokenizer.pre_tokenizer.pre_tokenize_str(text)
    pre_tokenized_text = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> pre_tokenize_result]
    splits = [[l <span class="hljs-keyword">for</span> l <span class="hljs-keyword">in</span> word] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> pre_tokenized_text]
    <span class="hljs-keyword">for</span> pair, merge <span class="hljs-keyword">in</span> merges.items():
        <span class="hljs-keyword">for</span> idx, split <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(splits):
            i = <span class="hljs-number">0</span>
            <span class="hljs-keyword">while</span> i &lt; <span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>:
                <span class="hljs-keyword">if</span> split[i] == pair[<span class="hljs-number">0</span>] <span class="hljs-keyword">and</span> split[i + <span class="hljs-number">1</span>] == pair[<span class="hljs-number">1</span>]:
                    split = split[:i] + [merge] + split[i + <span class="hljs-number">2</span> :]
                <span class="hljs-keyword">else</span>:
                    i += <span class="hljs-number">1</span>
            splits[idx] = split

    <span class="hljs-keyword">return</span> <span class="hljs-built_in">sum</span>(splits, [])`,wrap:!1}}),Xs=new m({props:{code:"dG9rZW5pemUoJTIyVGhpcyUyMGlzJTIwbm90JTIwYSUyMHRva2VuLiUyMik=",highlighted:'tokenize(<span class="hljs-string">&quot;This is not a token.&quot;</span>)',wrap:!1}}),Ds=new m({props:{code:"JTVCJ1RoaXMnJTJDJTIwJyVDNCVBMGlzJyUyQyUyMCclQzQlQTAnJTJDJTIwJ24nJTJDJTIwJ28nJTJDJTIwJ3QnJTJDJTIwJyVDNCVBMGEnJTJDJTIwJyVDNCVBMHRva2VuJyUyQyUyMCcuJyU1RA==",highlighted:'[<span class="hljs-string">&#x27;This&#x27;</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),f=new Ys({props:{warning:!0,$$slots:{default:[Qa]},$$scope:{ctx:w}}}),Rs=new xa({props:{source:"https://github.com/huggingface/course/blob/main/chapters/fr/chapter6/5.mdx"}}),{c(){p=c("meta"),T=e(),J=c("p"),h=e(),M(b.$$.fragment),Fs=e(),M(q.$$.fragment),Ks=e(),M($.$$.fragment),Os=e(),k=c("p"),k.innerHTML=bn,sl=e(),M(Q.$$.fragment),ll=e(),M(C.$$.fragment),nl=e(),M(A.$$.fragment),al=e(),B=c("p"),B.textContent=qn,el=e(),M(v.$$.fragment),tl=e(),V=c("p"),V.innerHTML=$n,pl=e(),M(d.$$.fragment),Ml=e(),E=c("p"),E.innerHTML=kn,il=e(),z=c("p"),z.innerHTML=Qn,rl=e(),Z=c("p"),Z.textContent=An,ul=e(),M(G.$$.fragment),yl=e(),S=c("p"),S.innerHTML=Bn,ol=e(),M(N.$$.fragment),cl=e(),_=c("p"),_.innerHTML=vn,jl=e(),H=c("p"),H.innerHTML=Vn,Jl=e(),M(X.$$.fragment),Ul=e(),D=c("p"),D.innerHTML=En,ml=e(),M(W.$$.fragment),Tl=e(),R=c("p"),R.innerHTML=zn,hl=e(),M(Y.$$.fragment),wl=e(),P=c("p"),P.textContent=Zn,Cl=e(),M(x.$$.fragment),dl=e(),M(L.$$.fragment),xl=e(),F=c("p"),F.textContent=Gn,gl=e(),K=c("ol"),K.innerHTML=Sn,Il=e(),O=c("p"),O.textContent=Nn,fl=e(),M(ss.$$.fragment),bl=e(),ls=c("p"),ls.textContent=_n,ql=e(),M(g.$$.fragment),$l=e(),M(ns.$$.fragment),kl=e(),as=c("p"),as.textContent=Hn,Ql=e(),es=c("p"),es.textContent=Xn,Al=e(),M(ts.$$.fragment),Bl=e(),ps=c("p"),ps.innerHTML=Dn,vl=e(),M(Ms.$$.fragment),Vl=e(),is=c("p"),is.textContent=Wn,El=e(),M(rs.$$.fragment),zl=e(),M(us.$$.fragment),Zl=e(),ys=c("p"),ys.textContent=Rn,Gl=e(),M(os.$$.fragment),Sl=e(),M(cs.$$.fragment),Nl=e(),js=c("p"),js.innerHTML=Yn,_l=e(),M(Js.$$.fragment),Hl=e(),Us=c("p"),Us.textContent=Pn,Xl=e(),M(ms.$$.fragment),Dl=e(),Ts=c("p"),Ts.textContent=Ln,Wl=e(),M(hs.$$.fragment),Rl=e(),ws=c("p"),ws.textContent=Fn,Yl=e(),M(Cs.$$.fragment),Pl=e(),M(ds.$$.fragment),Ll=e(),xs=c("p"),xs.textContent=Kn,Fl=e(),M(gs.$$.fragment),Kl=e(),M(Is.$$.fragment),Ol=e(),fs=c("p"),fs.innerHTML=On,sn=e(),M(bs.$$.fragment),ln=e(),qs=c("p"),qs.innerHTML=sa,nn=e(),M($s.$$.fragment),an=e(),ks=c("p"),ks.textContent=la,en=e(),M(Qs.$$.fragment),tn=e(),M(As.$$.fragment),pn=e(),Bs=c("p"),Bs.textContent=na,Mn=e(),M(vs.$$.fragment),rn=e(),Vs=c("p"),Vs.innerHTML=aa,un=e(),M(Es.$$.fragment),yn=e(),M(zs.$$.fragment),on=e(),Zs=c("p"),Zs.innerHTML=ea,cn=e(),M(Gs.$$.fragment),jn=e(),M(Ss.$$.fragment),Jn=e(),M(I.$$.fragment),Un=e(),Ns=c("p"),Ns.textContent=ta,mn=e(),M(_s.$$.fragment),Tn=e(),Hs=c("p"),Hs.textContent=pa,hn=e(),M(Xs.$$.fragment),wn=e(),M(Ds.$$.fragment),Cn=e(),M(f.$$.fragment),dn=e(),Ws=c("p"),Ws.textContent=Ma,xn=e(),M(Rs.$$.fragment),gn=e(),Ls=c("p"),this.h()},l(s){const l=wa("svelte-u9bgzb",document.head);p=j(l,"META",{name:!0,content:!0}),l.forEach(n),T=t(s),J=j(s,"P",{}),ja(J).forEach(n),h=t(s),i(b.$$.fragment,s),Fs=t(s),i(q.$$.fragment,s),Ks=t(s),i($.$$.fragment,s),Os=t(s),k=j(s,"P",{"data-svelte-h":!0}),U(k)!=="svelte-dc4rw6"&&(k.innerHTML=bn),sl=t(s),i(Q.$$.fragment,s),ll=t(s),i(C.$$.fragment,s),nl=t(s),i(A.$$.fragment,s),al=t(s),B=j(s,"P",{"data-svelte-h":!0}),U(B)!=="svelte-1h87em1"&&(B.textContent=qn),el=t(s),i(v.$$.fragment,s),tl=t(s),V=j(s,"P",{"data-svelte-h":!0}),U(V)!=="svelte-1uj0emc"&&(V.innerHTML=$n),pl=t(s),i(d.$$.fragment,s),Ml=t(s),E=j(s,"P",{"data-svelte-h":!0}),U(E)!=="svelte-1qcfng4"&&(E.innerHTML=kn),il=t(s),z=j(s,"P",{"data-svelte-h":!0}),U(z)!=="svelte-34wkn5"&&(z.innerHTML=Qn),rl=t(s),Z=j(s,"P",{"data-svelte-h":!0}),U(Z)!=="svelte-1xtdwct"&&(Z.textContent=An),ul=t(s),i(G.$$.fragment,s),yl=t(s),S=j(s,"P",{"data-svelte-h":!0}),U(S)!=="svelte-8gs7d7"&&(S.innerHTML=Bn),ol=t(s),i(N.$$.fragment,s),cl=t(s),_=j(s,"P",{"data-svelte-h":!0}),U(_)!=="svelte-1eoh852"&&(_.innerHTML=vn),jl=t(s),H=j(s,"P",{"data-svelte-h":!0}),U(H)!=="svelte-30qtcv"&&(H.innerHTML=Vn),Jl=t(s),i(X.$$.fragment,s),Ul=t(s),D=j(s,"P",{"data-svelte-h":!0}),U(D)!=="svelte-cosm6m"&&(D.innerHTML=En),ml=t(s),i(W.$$.fragment,s),Tl=t(s),R=j(s,"P",{"data-svelte-h":!0}),U(R)!=="svelte-1hj74ey"&&(R.innerHTML=zn),hl=t(s),i(Y.$$.fragment,s),wl=t(s),P=j(s,"P",{"data-svelte-h":!0}),U(P)!=="svelte-1phz38r"&&(P.textContent=Zn),Cl=t(s),i(x.$$.fragment,s),dl=t(s),i(L.$$.fragment,s),xl=t(s),F=j(s,"P",{"data-svelte-h":!0}),U(F)!=="svelte-h50xo1"&&(F.textContent=Gn),gl=t(s),K=j(s,"OL",{"data-svelte-h":!0}),U(K)!=="svelte-19lg3ll"&&(K.innerHTML=Sn),Il=t(s),O=j(s,"P",{"data-svelte-h":!0}),U(O)!=="svelte-11oyli9"&&(O.textContent=Nn),fl=t(s),i(ss.$$.fragment,s),bl=t(s),ls=j(s,"P",{"data-svelte-h":!0}),U(ls)!=="svelte-ciih5f"&&(ls.textContent=_n),ql=t(s),i(g.$$.fragment,s),$l=t(s),i(ns.$$.fragment,s),kl=t(s),as=j(s,"P",{"data-svelte-h":!0}),U(as)!=="svelte-hkuo77"&&(as.textContent=Hn),Ql=t(s),es=j(s,"P",{"data-svelte-h":!0}),U(es)!=="svelte-1gfdk4v"&&(es.textContent=Xn),Al=t(s),i(ts.$$.fragment,s),Bl=t(s),ps=j(s,"P",{"data-svelte-h":!0}),U(ps)!=="svelte-1vs4829"&&(ps.innerHTML=Dn),vl=t(s),i(Ms.$$.fragment,s),Vl=t(s),is=j(s,"P",{"data-svelte-h":!0}),U(is)!=="svelte-1nr0ogy"&&(is.textContent=Wn),El=t(s),i(rs.$$.fragment,s),zl=t(s),i(us.$$.fragment,s),Zl=t(s),ys=j(s,"P",{"data-svelte-h":!0}),U(ys)!=="svelte-6zl3q0"&&(ys.textContent=Rn),Gl=t(s),i(os.$$.fragment,s),Sl=t(s),i(cs.$$.fragment,s),Nl=t(s),js=j(s,"P",{"data-svelte-h":!0}),U(js)!=="svelte-zf5wvt"&&(js.innerHTML=Yn),_l=t(s),i(Js.$$.fragment,s),Hl=t(s),Us=j(s,"P",{"data-svelte-h":!0}),U(Us)!=="svelte-189wuny"&&(Us.textContent=Pn),Xl=t(s),i(ms.$$.fragment,s),Dl=t(s),Ts=j(s,"P",{"data-svelte-h":!0}),U(Ts)!=="svelte-1k3lfsg"&&(Ts.textContent=Ln),Wl=t(s),i(hs.$$.fragment,s),Rl=t(s),ws=j(s,"P",{"data-svelte-h":!0}),U(ws)!=="svelte-jx1j1k"&&(ws.textContent=Fn),Yl=t(s),i(Cs.$$.fragment,s),Pl=t(s),i(ds.$$.fragment,s),Ll=t(s),xs=j(s,"P",{"data-svelte-h":!0}),U(xs)!=="svelte-1fn9ojv"&&(xs.textContent=Kn),Fl=t(s),i(gs.$$.fragment,s),Kl=t(s),i(Is.$$.fragment,s),Ol=t(s),fs=j(s,"P",{"data-svelte-h":!0}),U(fs)!=="svelte-ctr4pf"&&(fs.innerHTML=On),sn=t(s),i(bs.$$.fragment,s),ln=t(s),qs=j(s,"P",{"data-svelte-h":!0}),U(qs)!=="svelte-1he3dod"&&(qs.innerHTML=sa),nn=t(s),i($s.$$.fragment,s),an=t(s),ks=j(s,"P",{"data-svelte-h":!0}),U(ks)!=="svelte-1nfafzn"&&(ks.textContent=la),en=t(s),i(Qs.$$.fragment,s),tn=t(s),i(As.$$.fragment,s),pn=t(s),Bs=j(s,"P",{"data-svelte-h":!0}),U(Bs)!=="svelte-wy0zl0"&&(Bs.textContent=na),Mn=t(s),i(vs.$$.fragment,s),rn=t(s),Vs=j(s,"P",{"data-svelte-h":!0}),U(Vs)!=="svelte-1wab3fs"&&(Vs.innerHTML=aa),un=t(s),i(Es.$$.fragment,s),yn=t(s),i(zs.$$.fragment,s),on=t(s),Zs=j(s,"P",{"data-svelte-h":!0}),U(Zs)!=="svelte-kmb1d9"&&(Zs.innerHTML=ea),cn=t(s),i(Gs.$$.fragment,s),jn=t(s),i(Ss.$$.fragment,s),Jn=t(s),i(I.$$.fragment,s),Un=t(s),Ns=j(s,"P",{"data-svelte-h":!0}),U(Ns)!=="svelte-1dqmvm3"&&(Ns.textContent=ta),mn=t(s),i(_s.$$.fragment,s),Tn=t(s),Hs=j(s,"P",{"data-svelte-h":!0}),U(Hs)!=="svelte-15d4qki"&&(Hs.textContent=pa),hn=t(s),i(Xs.$$.fragment,s),wn=t(s),i(Ds.$$.fragment,s),Cn=t(s),i(f.$$.fragment,s),dn=t(s),Ws=j(s,"P",{"data-svelte-h":!0}),U(Ws)!=="svelte-e7tmzh"&&(Ws.textContent=Ma),xn=t(s),i(Rs.$$.fragment,s),gn=t(s),Ls=j(s,"P",{}),ja(Ls).forEach(n),this.h()},h(){Ja(p,"name","hf:doc:metadata"),Ja(p,"content",Ba)},m(s,l){Ca(document.head,p),a(s,T,l),a(s,J,l),a(s,h,l),r(b,s,l),a(s,Fs,l),r(q,s,l),a(s,Ks,l),r($,s,l),a(s,Os,l),a(s,k,l),a(s,sl,l),r(Q,s,l),a(s,ll,l),r(C,s,l),a(s,nl,l),r(A,s,l),a(s,al,l),a(s,B,l),a(s,el,l),r(v,s,l),a(s,tl,l),a(s,V,l),a(s,pl,l),r(d,s,l),a(s,Ml,l),a(s,E,l),a(s,il,l),a(s,z,l),a(s,rl,l),a(s,Z,l),a(s,ul,l),r(G,s,l),a(s,yl,l),a(s,S,l),a(s,ol,l),r(N,s,l),a(s,cl,l),a(s,_,l),a(s,jl,l),a(s,H,l),a(s,Jl,l),r(X,s,l),a(s,Ul,l),a(s,D,l),a(s,ml,l),r(W,s,l),a(s,Tl,l),a(s,R,l),a(s,hl,l),r(Y,s,l),a(s,wl,l),a(s,P,l),a(s,Cl,l),r(x,s,l),a(s,dl,l),r(L,s,l),a(s,xl,l),a(s,F,l),a(s,gl,l),a(s,K,l),a(s,Il,l),a(s,O,l),a(s,fl,l),r(ss,s,l),a(s,bl,l),a(s,ls,l),a(s,ql,l),r(g,s,l),a(s,$l,l),r(ns,s,l),a(s,kl,l),a(s,as,l),a(s,Ql,l),a(s,es,l),a(s,Al,l),r(ts,s,l),a(s,Bl,l),a(s,ps,l),a(s,vl,l),r(Ms,s,l),a(s,Vl,l),a(s,is,l),a(s,El,l),r(rs,s,l),a(s,zl,l),r(us,s,l),a(s,Zl,l),a(s,ys,l),a(s,Gl,l),r(os,s,l),a(s,Sl,l),r(cs,s,l),a(s,Nl,l),a(s,js,l),a(s,_l,l),r(Js,s,l),a(s,Hl,l),a(s,Us,l),a(s,Xl,l),r(ms,s,l),a(s,Dl,l),a(s,Ts,l),a(s,Wl,l),r(hs,s,l),a(s,Rl,l),a(s,ws,l),a(s,Yl,l),r(Cs,s,l),a(s,Pl,l),r(ds,s,l),a(s,Ll,l),a(s,xs,l),a(s,Fl,l),r(gs,s,l),a(s,Kl,l),r(Is,s,l),a(s,Ol,l),a(s,fs,l),a(s,sn,l),r(bs,s,l),a(s,ln,l),a(s,qs,l),a(s,nn,l),r($s,s,l),a(s,an,l),a(s,ks,l),a(s,en,l),r(Qs,s,l),a(s,tn,l),r(As,s,l),a(s,pn,l),a(s,Bs,l),a(s,Mn,l),r(vs,s,l),a(s,rn,l),a(s,Vs,l),a(s,un,l),r(Es,s,l),a(s,yn,l),r(zs,s,l),a(s,on,l),a(s,Zs,l),a(s,cn,l),r(Gs,s,l),a(s,jn,l),r(Ss,s,l),a(s,Jn,l),r(I,s,l),a(s,Un,l),a(s,Ns,l),a(s,mn,l),r(_s,s,l),a(s,Tn,l),a(s,Hs,l),a(s,hn,l),r(Xs,s,l),a(s,wn,l),r(Ds,s,l),a(s,Cn,l),r(f,s,l),a(s,dn,l),a(s,Ws,l),a(s,xn,l),r(Rs,s,l),a(s,gn,l),a(s,Ls,l),In=!0},p(s,[l]){const ia={};l&2&&(ia.$$scope={dirty:l,ctx:s}),C.$set(ia);const ra={};l&2&&(ra.$$scope={dirty:l,ctx:s}),d.$set(ra);const ua={};l&2&&(ua.$$scope={dirty:l,ctx:s}),x.$set(ua);const ya={};l&2&&(ya.$$scope={dirty:l,ctx:s}),g.$set(ya);const oa={};l&2&&(oa.$$scope={dirty:l,ctx:s}),I.$set(oa);const ca={};l&2&&(ca.$$scope={dirty:l,ctx:s}),f.$set(ca)},i(s){In||(u(b.$$.fragment,s),u(q.$$.fragment,s),u($.$$.fragment,s),u(Q.$$.fragment,s),u(C.$$.fragment,s),u(A.$$.fragment,s),u(v.$$.fragment,s),u(d.$$.fragment,s),u(G.$$.fragment,s),u(N.$$.fragment,s),u(X.$$.fragment,s),u(W.$$.fragment,s),u(Y.$$.fragment,s),u(x.$$.fragment,s),u(L.$$.fragment,s),u(ss.$$.fragment,s),u(g.$$.fragment,s),u(ns.$$.fragment,s),u(ts.$$.fragment,s),u(Ms.$$.fragment,s),u(rs.$$.fragment,s),u(us.$$.fragment,s),u(os.$$.fragment,s),u(cs.$$.fragment,s),u(Js.$$.fragment,s),u(ms.$$.fragment,s),u(hs.$$.fragment,s),u(Cs.$$.fragment,s),u(ds.$$.fragment,s),u(gs.$$.fragment,s),u(Is.$$.fragment,s),u(bs.$$.fragment,s),u($s.$$.fragment,s),u(Qs.$$.fragment,s),u(As.$$.fragment,s),u(vs.$$.fragment,s),u(Es.$$.fragment,s),u(zs.$$.fragment,s),u(Gs.$$.fragment,s),u(Ss.$$.fragment,s),u(I.$$.fragment,s),u(_s.$$.fragment,s),u(Xs.$$.fragment,s),u(Ds.$$.fragment,s),u(f.$$.fragment,s),u(Rs.$$.fragment,s),In=!0)},o(s){y(b.$$.fragment,s),y(q.$$.fragment,s),y($.$$.fragment,s),y(Q.$$.fragment,s),y(C.$$.fragment,s),y(A.$$.fragment,s),y(v.$$.fragment,s),y(d.$$.fragment,s),y(G.$$.fragment,s),y(N.$$.fragment,s),y(X.$$.fragment,s),y(W.$$.fragment,s),y(Y.$$.fragment,s),y(x.$$.fragment,s),y(L.$$.fragment,s),y(ss.$$.fragment,s),y(g.$$.fragment,s),y(ns.$$.fragment,s),y(ts.$$.fragment,s),y(Ms.$$.fragment,s),y(rs.$$.fragment,s),y(us.$$.fragment,s),y(os.$$.fragment,s),y(cs.$$.fragment,s),y(Js.$$.fragment,s),y(ms.$$.fragment,s),y(hs.$$.fragment,s),y(Cs.$$.fragment,s),y(ds.$$.fragment,s),y(gs.$$.fragment,s),y(Is.$$.fragment,s),y(bs.$$.fragment,s),y($s.$$.fragment,s),y(Qs.$$.fragment,s),y(As.$$.fragment,s),y(vs.$$.fragment,s),y(Es.$$.fragment,s),y(zs.$$.fragment,s),y(Gs.$$.fragment,s),y(Ss.$$.fragment,s),y(I.$$.fragment,s),y(_s.$$.fragment,s),y(Xs.$$.fragment,s),y(Ds.$$.fragment,s),y(f.$$.fragment,s),y(Rs.$$.fragment,s),In=!1},d(s){s&&(n(T),n(J),n(h),n(Fs),n(Ks),n(Os),n(k),n(sl),n(ll),n(nl),n(al),n(B),n(el),n(tl),n(V),n(pl),n(Ml),n(E),n(il),n(z),n(rl),n(Z),n(ul),n(yl),n(S),n(ol),n(cl),n(_),n(jl),n(H),n(Jl),n(Ul),n(D),n(ml),n(Tl),n(R),n(hl),n(wl),n(P),n(Cl),n(dl),n(xl),n(F),n(gl),n(K),n(Il),n(O),n(fl),n(bl),n(ls),n(ql),n($l),n(kl),n(as),n(Ql),n(es),n(Al),n(Bl),n(ps),n(vl),n(Vl),n(is),n(El),n(zl),n(Zl),n(ys),n(Gl),n(Sl),n(Nl),n(js),n(_l),n(Hl),n(Us),n(Xl),n(Dl),n(Ts),n(Wl),n(Rl),n(ws),n(Yl),n(Pl),n(Ll),n(xs),n(Fl),n(Kl),n(Ol),n(fs),n(sn),n(ln),n(qs),n(nn),n(an),n(ks),n(en),n(tn),n(pn),n(Bs),n(Mn),n(rn),n(Vs),n(un),n(yn),n(on),n(Zs),n(cn),n(jn),n(Jn),n(Un),n(Ns),n(mn),n(Tn),n(Hs),n(hn),n(wn),n(Cn),n(dn),n(Ws),n(xn),n(gn),n(Ls)),n(p),o(b,s),o(q,s),o($,s),o(Q,s),o(C,s),o(A,s),o(v,s),o(d,s),o(G,s),o(N,s),o(X,s),o(W,s),o(Y,s),o(x,s),o(L,s),o(ss,s),o(g,s),o(ns,s),o(ts,s),o(Ms,s),o(rs,s),o(us,s),o(os,s),o(cs,s),o(Js,s),o(ms,s),o(hs,s),o(Cs,s),o(ds,s),o(gs,s),o(Is,s),o(bs,s),o($s,s),o(Qs,s),o(As,s),o(vs,s),o(Es,s),o(zs,s),o(Gs,s),o(Ss,s),o(I,s),o(_s,s),o(Xs,s),o(Ds,s),o(f,s),o(Rs,s)}}}const Ba='{"title":"Tokénisation <i> Byte-Pair Encoding </i>","local":"tokénisation-i-byte-pair-encoding-i","sections":[{"title":"Algorithme d’entraînement","local":"algorithme-dentraînement","sections":[],"depth":2},{"title":"Algorithme de tokenisation","local":"algorithme-de-tokenisation","sections":[],"depth":2},{"title":"Implémentation du BPE","local":"implémentation-du-bpe","sections":[],"depth":2}],"depth":1}';function va(w){return ma(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _a extends Ta{constructor(p){super(),ha(this,p,va,Aa,Ua,{})}}export{_a as component};
