# પરિચય 

હગિંગ ફેસ પર આપનું સ્વાગત છે! આ પરિચય તમને કામનું વાતાવરણ ગોઠવવામાં માર્ગદર્શન આપશે. જો તમે હમણાં જ અભ્યાસક્રમ સાથે પ્રારંભ કરી રહ્યાં છો, તો અમે ભલામણ કરીએ છીએ કે તમે પહેલા [પ્રકરણ 1](https://github.com/huggingface/course/blob/main/course/chapter1) પર એક નજર નાખો, પછી પાછા આવો અને તમારું Environment સેટ કરો જેથી તમે ‘કોડ’ જાતે અજમાવી શકો.

આ કોર્સમાં આપણે  જે લાઈબ્રેરીનો ઉપયોગ કરીશું તે Python Package તરીકે ઉપલબ્ધ છે, તેથી અહીં અમે તમને બતાવીશું કે Python  Environment  કેવી રીતે સેટ કરવું અને તમને જોઈતી વિશિષ્ટ લાઈબ્રેરીઓ કેવી રીતે ઇન્સ્ટોલ કરવી.

Colab Notebook અથવા Python Virtual  એન્વાયર્નમેન્ટનો ઉપયોગ કરીને અમે તમારા કામનું વાતાવરણ સેટ કરવાની બે રીતે આવરી લઈશું. તમને  જે સૌથી વધુ પસંદ હોય તે ઉપયોગ કરો. નવા નિશાળિયા માટે, અમે ભલામણ કરીએ છીએ કે તમે Colab નોટબુકથી શરૂઆત કરો.

નોંધ કરો કે અમે Windows System ને  આવરી શું નહીં. જો તમે Windows ચલાવી રહ્યાં હોવ, તો અમે તેને અનુસરવા માટે Colab Notebook નો ઉપયોગ કરવાનો સુઝાવ આપીએ છીએ. જો તમે Linux વિતરણ અથવા MacOS નો ઉપયોગ કરી રહ્યાં છો, તો તમે અહીં વર્ણવેલ કોઈપણ અભિગમનો ઉપયોગ કરી શકો છો.

અલબત્ત મોટાભાગનો આધાર તમારા હગિંગ ફેસ એકાઉન્ટ પર છે. અમે હમણાં એક ખાતું બનાવવાની ભલામણ કરીએ છીએ: [ખાતું અહીં બનાવો](https://huggingface.co/join)

## Google Colab Notebook(ગૂગલ કોલાબ નોટબુક) ની મદદ થી

હુગિંગફેસ(huggingface) નું સૌથી આસાન સેટઅપ Google Colab નોટબુક થી કરી શકાય. તમારા વેબ બ્રાઉઝર માં colab ઓપન કરો. 

જો તમે પેહલા colab થી પરિચિત ના હોવ, તો [પરિચય](https://colab.research.google.com/notebooks/intro.ipynb). થી શરૂઆત કરવી. Colab તમને advanced hardware જેમકે GPU અથવા TPU આપશે, જે નાના prototype માટે વિના મૂલ્યે વાપરી શકાય.

જો તમને એક વાર colab ફાવી જાય તો નવી નોટબુક open કરી જરૂરી પેકેજ install કરી શકાય જે setup કરવા માટે અત્યંત જરૂરી છે.:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/new_colab.png" alt="An empty colab notebook" width="80%"/>
</div>

હવે આપણે libraries install કરીશું જે આખા course ma વપરાશે.  આપણે વાપરીશું installation માટે, જે python ma પેકેજ મેનેજર છે. Notebook ના cells માં તમે કમાંડ run કરી શકો જો તમે એને થી શરૂ કરો. તમે ને આ રીતે કરી શકો:

```
!pip install transformers
```

જો આપને ચકાસવું હોય કે પેકેજ બરાબર install થયું છે કે નહિ તો આ રીતે કરી શકાય:

```
import transformers
```

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/install.gif" alt="A gif showing the result of the two commands above: installation and import" width="80%"/>
</div>

આ આગળ નો command અમુક જ પેકેજ install કરશે. એ મશીનલનિંગ ના ફ્રેમવર્ક જેમકે (Tensorflow અને Pytorch) ઇન્સ્ટોલ નઈ કરે. આ course માં આપણે ઘણાં ફિચર્સ જોઈશું એટલે હું development વર્સન install કરવાની સલાહ આપીશ, કે જેમાં બધા પેકેજ અને જરૂરી લાઇબ્રેરી install એક સાથે આવશે:

```
!pip install transformers[sentencepiece]
```

આ સ્ટેપ run થતાં થોડો ટાઈમ લાગશે, પણ એનાથી આગળ ના પ્રકરણ માં સારું પડશે!

## Python Virtual Environment ની મદદ થી

જો તમને python virtual environment અનુકૂળ આવતું હોય તો પેહલું તબકું એ તમારા system માં python install છે. અમે આ [guide](https://realpython.com/installing-python/) અનુસરવાનું કહીશું.

એકવાર python install થઈ જાય એટલે તમારા system ના terminal માં python command run કરી શકવા જોઈએ. જો તને  તપાસવા માંગતા હોવ તો આ રન કરી શકો. આ command python નું version આપશે.

જ્યારે તમે python command run કરો, જેમકે `python --version`, ત્યારે એ તમારી કમ્પ્યુટર સિસ્ટમ ના મુખ્ય python environment માં run થશે. અમે મુખ્ય python environment માં કઈ પણ install ન કરવાનો સુજાવ કરીએ છીએ. દરેક application માટે, અલગ environment વાપરવું, એમ કરવાથી દરેક application ને પેકેજ અને dependency અલગ અલગ રહેશે. આમ કરવાથી બીજી application સાથે compatibility ની સમસ્યા નઈ આવે.

Python માં આ બધું [*virtual environments*](https://docs.python.org/3/tutorial/venv.html) થી થાય છે, આ virtual environment તમને અલગ ફોલ્ડર બનાઈ આપશે જેવા જરૂરી python version સાથે packages હશે જે તમને application માટે જરૂરી હશે. આ રીતનું virtual environment ઘણી રીતે બનાવી શકાય. આપણે python નું official tool [`venv`](https://docs.python.org/3/library/venv.html#module-venv) વાપરીશું.

સૌથી પેહલા એક ફોલ્ડર બનાવો કે જેમાં તમારી application નો code રેહશે.દાખલા તરીકે, તમે તમરી હોમ ફોલ્ડર માં *transformers-course* નામનું ફોલ્ડર બનાવો છો:

```
mkdir ~/transformers-course
cd ~/transformers-course
```

એ ફોલ્ડર માં, python ના `venv` મોડ્યુલ ની મદદ થી virtual environment બનાવો:

```
python -m venv .env
```

તમને પેહલા ના ખાલી ફોલ્ડર માં *.env* નામનું ફોલ્ડર દેખાશે:

```
ls -a
```

```out
.      ..    .env
```

તમેં તમારા virtual environment ને ઉસ કરવા `activate` અને `deactivate` ના વાપરવું હોય તો સ્ક્રિપ્ટ વાપરી શકો:

```
# Activate the virtual environment
source .env/bin/activate

# Deactivate the virtual environment
deactivate
```

જો તમે verify કરવા માંગતા હોવ તો `which python` command run કરો. એ તમરા virtual environment ના ફોલ્ડર ને આઉટપુટ માં આપશે. આ એવું સાબિત કરે છે કે virtual environment સફળાપૂર્વક active છે.!

```
which python
```

```out
/home/<user>/transformers-course/.env/bin/python
```

### Installing dependencies

જેમ આપણે પેહલા ના colab વાળા સેકશન માં કરેલું એમ, આપણે પેકેજ ઇન્સ્ટોલ કરીશું. આપણે `pip` પેકેજ મેનેજર ની મદદ થી 🤗 `transformers` નું ડેવલપમેન્ટ વર્સન ઇન્સ્ટોલ કરીશું:

```
pip install "transformers[sentencepiece]"
```

હવે તમારું સિસ્ટમ સેટઅપ થઈ ગયું છે અને તમે આગળ વધવા માટે સક્ષમ છો!

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/gj/chapter0/1.mdx" />