# ट्रांसफॉर्मर कैसे काम करते हैं?

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

इस खंड में, हम ट्रांसफॉर्मर मॉडल की वास्तुकला पर एक उच्च-स्तरीय नज़र डालेंगे।

## ट्रांसफार्मर का थोड़ा सा इतिहास

ट्रांसफॉर्मर मॉडल के (संक्षिप्त) इतिहास में कुछ संदर्भ बिंदु यहां दिए गए हैं:

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers_chrono.svg" alt="A brief chronology of Transformers models.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers_chrono-dark.svg" alt="A brief chronology of Transformers models.">
</div>

[ट्रांसफॉर्मर आर्किटेक्चर](https://arxiv.org/abs/1706.03762) को जून 2017 में पेश किया गया था। मूल शोध का फोकस अनुवाद कार्यों पर था। इसके बाद कई प्रभावशाली मॉडल पेश किए गए, जिनमें शामिल हैं:

- **जून 2018**: [GPT](https://cdn.openai.com/research-covers/language-unsupervised/language_understanding_paper.pdf), पहला पूर्व प्रशिक्षित ट्रांसफॉर्मर मॉडल, जिसका उपयोग विभिन्न प्राकृतिक भाषा प्रसंस्करण कार्यों पर फाइन-ट्यूनिंग के लिए किया जाता है और राज्य का प्राप्त किया जाता है- कला परिणाम।
- **अक्टूबर 2018**: [BERT](https://arxiv.org/abs/1810.04805), एक और बड़ा पूर्व-प्रशिक्षित मॉडल, इसे वाक्यों के बेहतर सारांश तैयार करने के लिए डिज़ाइन किया गया है (इस पर अगले अध्याय में अधिक!)
-  **फरवरी 2019**: [GPT-2](https://cdn.openai.com/better-language-models/language_models_are_unsupervised_multitask_learners.pdf), GPT का एक बेहतर (और बड़ा) संस्करण जिसे नैतिक चिंताओं के कारण तुरंत सार्वजनिक रूप से जारी नहीं किया गया था।
-  **अक्टूबर 2019**: [DistilBERT](https://arxiv.org/abs/1910.01108), BERT का एक डिस्टिल्ड संस्करण जो 60% तेज, मेमोरी में 40% हल्का है, और अभी भी BERT के प्रदर्शन का 97% बरकरार रखता है।
-  **अक्टूबर 2019**: [BART](https://arxiv.org/abs/1910.13461) और [T5](https://arxiv.org/abs/1910.10683), दो बड़े पूर्व-प्रशिक्षित मॉडल जो मूल ट्रांसफॉर्मर मॉडल के समान आर्किटेक्चर का उपयोग करते हैं ( ऐसा करने वाले पहले संस्करण)।
-  **मई 2020**: [GPT-3](https://arxiv.org/abs/2005.14165), GPT-2 का और भी बड़ा संस्करण जो फाइन-ट्यूनिंग की आवश्यकता के बिना विभिन्न कार्यों पर अच्छा प्रदर्शन करने में सक्षम है (जिसे _जीरो शॉट लर्निंग_ कहा जाता है)।

यह सूची व्यापक से बहुत दूर है और केवल कुछ विभिन्न प्रकार के ट्रांसफार्मर मॉडल को उजागर करने के लिए है। मोटे तौर पर उन्हें तीन श्रेणियों में बांटा जा सकता है:

- GPT- जैसा (जिसे _auto-regressive_ Transformer मॉडल भी कहा जाता है)
- BERT- जैसा (जिसे _auto-encoding_ Transformer मॉडल भी कहा जाता है)
- BART/T5- जैस (जिसे _अनुक्रम-से-अनुक्रम_ट्रांसफॉर्मर मॉडल भी कहा जाता है)

हम इन परिवारों के बारे में बाद में और गहराई से जानेंगे।

## ट्रांसफॉर्मर भाषा मॉडल हैं

ऊपर वर्णित सभी ट्रांसफार्मर मॉडल (जीपीटी, बीईआरटी, बार्ट, टी5, आदि) को *भाषा मॉडल* के रूप में प्रशिक्षित किया गया है। इसका मतलब है कि उन्हें स्व-निगरानी फैशन में बड़ी मात्रा में कच्चे पाठ पर प्रशिक्षित किया गया है। स्व-पर्यवेक्षित शिक्षण एक प्रकार का प्रशिक्षण है जिसमें मॉडल के इनपुट से उद्देश्य की स्वचालित रूप से गणना की जाती है। इसका मतलब है कि मनुष्यों को डेटा लेबल करने की आवश्यकता नहीं है!

इस प्रकार का मॉडल उस भाषा की सांख्यिकीय समझ विकसित करता है जिस पर इसे प्रशिक्षित किया गया है, लेकिन यह विशिष्ट व्यावहारिक कार्यों के लिए बहुत उपयोगी नहीं है। इस वजह से, सामान्य पूर्व-प्रशिक्षित मॉडल तब *ट्रांसफर लर्निंग* नामक प्रक्रिया से गुजरता है। इस प्रक्रिया के दौरान, मॉडल को पर्यवेक्षित तरीके से ठीक-ठीक ट्यून किया जाता है - अर्थात, मानव-एनोटेटेड लेबल का उपयोग करके - किसी दिए गए कार्य पर।

कार्य का एक उदाहरण *n* पिछले शब्दों को पढ़कर वाक्य में अगले शब्द की भविष्यवाणी करना है। इसे *कारण भाषा मॉडलिंग* कहा जाता है क्योंकि आउटपुट अतीत और वर्तमान इनपुट पर निर्भर करता है, लेकिन भविष्य के इनपुट पर नहीं।

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/causal_modeling.svg" alt="Example of causal language modeling in which the next word from a sentence is predicted.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/causal_modeling-dark.svg" alt="Example of causal language modeling in which the next word from a sentence is predicted.">
</div>

एक अन्य उदाहरण *मुखौटा भाषा मॉडलिंग* है, जिसमें मॉडल वाक्य में एक नकाबपोश शब्द की भविष्यवाणी करता है।

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/masked_modeling.svg" alt="Example of masked language modeling in which a masked word from a sentence is predicted.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/masked_modeling-dark.svg" alt="Example of masked language modeling in which a masked word from a sentence is predicted.">
</div>

## ट्रांसफॉर्मर हैं बड़े मॉडल

कुछ आउटलेयर (जैसे डिस्टिलबर्ट) के अलावा, बेहतर प्रदर्शन प्राप्त करने की सामान्य रणनीति मॉडल के आकार के साथ-साथ उन डेटा की मात्रा को बढ़ाकर है जिन पर वे पूर्व-प्रशिक्षित हैं।

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/model_parameters.png" alt="Number of parameters of recent Transformers models" width="90%">
</div>

दुर्भाग्य से, एक मॉडल को प्रशिक्षित करने के लिए, विशेष रूप से एक बड़े मॉडल के लिए बड़ी मात्रा में डेटा की आवश्यकता होती है। यह समय के लिहाज से बहुत महंगा हो जाता है और संसाधनों की गणना करता है। यह पर्यावरणीय प्रभाव का भी अनुवाद करता है, जैसा कि निम्नलिखित ग्राफ में देखा जा सकता है।

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/carbon_footprint.svg" alt="The carbon footprint of a large language model.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/carbon_footprint-dark.svg" alt="The carbon footprint of a large language model.">
</div>

<Youtube id="ftWlj4FBHTg"/>

और यह पूर्व-प्रशिक्षण के पर्यावरणीय प्रभाव को कम करने की कोशिश कर रही एक टीम द्वारा तैयार किए गए (बहुत बड़े के लिए) एक परियोजना दिखा रहा है। सर्वोत्तम हाइपरपैरामीटर प्राप्त करने के लिए बहुत सारे परीक्षण चलाने का पदचिह्न और भी अधिक होगा।

कल्पना कीजिए कि अगर हर बार एक शोध दल, एक छात्र संगठन, या कोई कंपनी किसी मॉडल को प्रशिक्षित करना चाहती है, तो उसने ऐसा शुरू से ही किया। इससे भारी, अनावश्यक वैश्विक लागत आएगी!

यही कारण है कि भाषा मॉडल साझा करना सर्वोपरि है: पहले से प्रशिक्षित वजन के ऊपर प्रशिक्षित वजन और निर्माण को साझा करना समग्र गणना लागत और समुदाय के कार्बन पदचिह्न को कम करता है।


## स्थानांतरण सीखना

<Youtube id="BqqfQnyjmgg" />

*पूर्व-प्रशिक्षण* एक मॉडल को खरोंच से प्रशिक्षित करने का कार्य है: वज़न को बेतरतीब ढंग से आरंभ किया जाता है, और प्रशिक्षण बिना किसी पूर्व ज्ञान के शुरू होता है।

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/pretraining.svg" alt="The pretraining of a language model is costly in both time and money.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/pretraining-dark.svg" alt="The pretraining of a language model is costly in both time and money.">
</div>

यह पूर्व-प्रशिक्षण आमतौर पर बहुत बड़ी मात्रा में डेटा पर किया जाता है। इसलिए, इसके लिए बहुत अधिक डेटा की आवश्यकता होती है, और प्रशिक्षण में कई सप्ताह तक लग सकते हैं।

दूसरी ओर, *फाइन-ट्यूनिंग*, किसी मॉडल के पूर्व-प्रशिक्षित **होने के बाद** किया जाने वाला प्रशिक्षण है। फ़ाइन-ट्यूनिंग करने के लिए, आप पहले एक पूर्व-प्रशिक्षित भाषा मॉडल प्राप्त करते हैं, फिर अपने कार्य के लिए विशिष्ट डेटासेट के साथ अतिरिक्त प्रशिक्षण करते हैं। रुको - क्यों न केवल अंतिम कार्य के लिए सीधे प्रशिक्षण दिया जाए? वहाँ के लिए बहुत कारण है:

* पूर्व-प्रशिक्षित मॉडल को पहले से ही एक डेटासेट पर प्रशिक्षित किया गया था जिसमें फ़ाइन-ट्यूनिंग डेटासेट के साथ कुछ समानताएँ हैं। इस प्रकार फाइन-ट्यूनिंग प्रक्रिया प्रारंभिक मॉडल द्वारा पूर्व-प्रशिक्षण के दौरान प्राप्त ज्ञान का लाभ उठाने में सक्षम है (उदाहरण के लिए, प्राकृतिक भाषा प्रसंस्करण समस्याओं के साथ, पूर्व-प्रशिक्षित मॉडल को उस भाषा की किसी प्रकार की सांख्यिकीय समझ होगी जिसका आप उपयोग कर रहे हैं। आपका कार्य)।
* चूंकि पूर्व-प्रशिक्षित मॉडल पहले से ही बहुत सारे डेटा पर प्रशिक्षित था, इसलिए फाइन-ट्यूनिंग को अच्छे परिणाम प्राप्त करने के लिए बहुत कम डेटा की आवश्यकता होती है।
* उसी कारण से, अच्छे परिणाम प्राप्त करने के लिए आवश्यक समय और संसाधनों की मात्रा बहुत कम है।

उदाहरण के लिए, कोई व्यक्ति अंग्रेजी भाषा में प्रशिक्षित एक पूर्व-प्रशिक्षित मॉडल का लाभ उठा सकता है और फिर उसे एक आर्क्सिव कॉर्पस पर ठीक कर सकता है, जिसके परिणामस्वरूप विज्ञान/अनुसंधान-आधारित मॉडल बन सकता है। फाइन-ट्यूनिंग के लिए केवल सीमित मात्रा में डेटा की आवश्यकता होगी: पूर्व-प्रशिक्षित मॉडल ने जो ज्ञान हासिल किया है वह "स्थानांतरित" है, इसलिए शब्द *ट्रांसफर लर्निंग*।

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/finetuning.svg" alt="The fine-tuning of a language model is cheaper than pretraining in both time and money.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/finetuning-dark.svg" alt="The fine-tuning of a language model is cheaper than pretraining in both time and money.">
</div>

एक मॉडल को फाइन-ट्यूनिंग, इसलिए कम समय, डेटा, वित्तीय और पर्यावरणीय लागत है। विभिन्न फाइन-ट्यूनिंग योजनाओं पर पुनरावृति करना भी तेज और आसान है, क्योंकि प्रशिक्षण पूर्ण पूर्व-प्रशिक्षण की तुलना में कम विवश है।

यह प्रक्रिया खरोंच से प्रशिक्षण की तुलना में बेहतर परिणाम प्राप्त करेगी (जब तक कि आपके पास बहुत अधिक डेटा न हो), यही कारण है कि आपको हमेशा पूर्व-प्रशिक्षित मॉडल का लाभ उठाने का प्रयास करना चाहिए - जो आपके हाथ में काम के जितना करीब हो सके - और इसे फाइन-ट्यून करें।

## सामान्य वास्तुकला

इस खंड में, हम ट्रान्सफ़ॉर्मर मॉडल की सामान्य संरचना के बारे में जानेंगे। यदि आप कुछ अवधारणाओं को नहीं समझते हैं, तो चिंता न करें; बाद में प्रत्येक घटक को कवर करने वाले विस्तृत खंड हैं।

<Youtube id="H39Z_720T5s" />

## परिचय

मॉडल मुख्य रूप से दो ब्लॉकों से बना है:

* **एनकोडर (बाएं)**: एन्कोडर इनपुट प्राप्त करता है और इसका प्रतिनिधित्व करता है (इसकी विशेषताएं)। इसका मतलब है कि इनपुट से समझ हासिल करने के लिए मॉडल को अनुकूलित किया गया है।
* **डिकोडर (दाएं)**: लक्ष्य अनुक्रम उत्पन्न करने के लिए डिकोडर अन्य इनपुट के साथ एन्कोडर के प्रतिनिधित्व (सुविधाओं) का उपयोग करता है। इसका मतलब है कि मॉडल आउटपुट उत्पन्न करने के लिए अनुकूलित है।

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers_blocks.svg" alt="Architecture of a Transformers models">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers_blocks-dark.svg" alt="Architecture of a Transformers models">
</div>

इनमें से प्रत्येक भाग का उपयोग कार्य के आधार पर स्वतंत्र रूप से किया जा सकता है:

* **केवल-एनकोडर मॉडल**: उन कार्यों के लिए अच्छा है जिनके लिए इनपुट की समझ की आवश्यकता होती है, जैसे वाक्य वर्गीकरण और नामित इकाई पहचान।
* **केवल डिकोडर मॉडल**: पाठ निर्माण जैसे जनरेटिव कार्यों के लिए अच्छा है।
* **एनकोडर-डिकोडर मॉडल** or **अनुक्रम-से-अनुक्रम मॉडल**: Good for generative tasks that require an input, such as translation or summarization.

हम बाद के खंडों में स्वतंत्र रूप से उन वास्तुकलाओं में गोता लगाएँगे।

## ध्यान परतें

ट्रांसफार्मर मॉडल की एक प्रमुख विशेषता यह है कि वे विशेष परतों के साथ निर्मित होते हैं जिन्हें *ध्यान परत* कहा जाता है। वास्तव में, ट्रांसफॉर्मर आर्किटेक्चर को पेश करने वाले पेपर का शीर्षक था ["अटेंशन इज़ ऑल यू नीड"](https://arxiv.org/abs/1706.03762)! हम पाठ्यक्रम में बाद में ध्यान परतों के विवरण का पता लगाएंगे; अभी के लिए, आपको केवल यह जानने की जरूरत है कि यह परत मॉडल को आपके द्वारा पारित वाक्य में कुछ शब्दों पर विशेष ध्यान देने के लिए कहेगी (और कमोबेश दूसरों की उपेक्षा करें) प्रत्येक शब्द के प्रतिनिधित्व के साथ व्यवहार करते समय।

इसे संदर्भ में रखने के लिए, अंग्रेजी से फ्रेंच में पाठ का अनुवाद करने के कार्य पर विचार करें। इनपुट "आप इस पाठ्यक्रम को पसंद करते हैं" को देखते हुए, एक अनुवाद मॉडल को "पसंद" शब्द के लिए उचित अनुवाद प्राप्त करने के लिए आसन्न शब्द "यू" में भी भाग लेने की आवश्यकता होगी, क्योंकि फ्रेंच में क्रिया "पसंद" अलग-अलग संयुग्मित होती है पर निर्भर करता है विषय। हालाँकि, शेष वाक्य उस शब्द के अनुवाद के लिए उपयोगी नहीं है। उसी तरह, "इस" का अनुवाद करते समय मॉडल को "कोर्स" शब्द पर भी ध्यान देने की आवश्यकता होगी, क्योंकि "यह" अलग-अलग अनुवाद करता है जो इस बात पर निर्भर करता है कि संबंधित संज्ञा पुल्लिंग है या स्त्रीलिंग। फिर, वाक्य के दूसरे शब्द "इस" के अनुवाद के लिए कोई मायने नहीं रखेंगे। अधिक जटिल वाक्यों (और अधिक जटिल व्याकरण नियमों) के साथ, मॉडल को उन शब्दों पर विशेष ध्यान देने की आवश्यकता होगी जो प्रत्येक शब्द का ठीक से अनुवाद करने के लिए वाक्य में दूर दिखाई दे सकते हैं। 

प्राकृतिक भाषा से जुड़े किसी भी कार्य पर भी यही अवधारणा लागू होती है: एक शब्द का अपने आप में एक अर्थ होता है, लेकिन वह अर्थ संदर्भ से गहराई से प्रभावित होता है, जो शब्द के अध्ययन से पहले या बाद में कोई अन्य शब्द (या शब्द) हो सकता है।

अब जब आपको पता चल गया है कि ध्यान की परतें क्या हैं, तो आइए ट्रांसफॉर्मर आर्किटेक्चर पर करीब से नज़र डालें।

## मूल वास्तुकला

ट्रांसफॉर्मर आर्किटेक्चर मूल रूप से अनुवाद के लिए डिज़ाइन किया गया था। प्रशिक्षण के दौरान, एनकोडर एक निश्चित भाषा में इनपुट (वाक्य) प्राप्त करता है, जबकि डिकोडर वांछित लक्ष्य भाषा में समान वाक्य प्राप्त करता है। एनकोडर में, ध्यान की परतें एक वाक्य में सभी शब्दों का उपयोग कर सकती हैं (चूंकि, जैसा कि हमने अभी देखा, किसी दिए गए शब्द का अनुवाद इस बात पर निर्भर हो सकता है कि वाक्य में क्या है और इसके पहले क्या है)। हालाँकि, डिकोडर क्रमिक रूप से काम करता है और केवल उस वाक्य में शब्दों पर ध्यान दे सकता है जिसका उसने पहले ही अनुवाद किया है (इसलिए, वर्तमान में उत्पन्न होने वाले शब्द से पहले के शब्द)। उदाहरण के लिए, जब हमने अनुवादित लक्ष्य के पहले तीन शब्दों की भविष्यवाणी की है, तो हम उन्हें डिकोडर को देते हैं जो चौथे शब्द की भविष्यवाणी करने के लिए एन्कोडर के सभी इनपुट का उपयोग करता है।

प्रशिक्षण के दौरान चीजों को गति देने के लिए (जब मॉडल के पास लक्ष्य वाक्यों तक पहुंच होती है), डिकोडर को पूरे लक्ष्य को खिलाया जाता है, लेकिन भविष्य के शब्दों का उपयोग करने की अनुमति नहीं है (यदि भविष्यवाणी करने की कोशिश करते समय स्थिति 2 पर शब्द तक पहुंच थी) स्थिति 2 पर शब्द, समस्या बहुत कठिन नहीं होगी!)। उदाहरण के लिए, जब चौथे शब्द की भविष्यवाणी करने की कोशिश की जाती है, तो ध्यान परत के पास केवल 1 से 3 की स्थिति वाले शब्दों तक ही पहुंच होगी।

मूल ट्रांसफॉर्मर आर्किटेक्चर इस तरह दिखता था, बाईं ओर एन्कोडर और दाईं ओर डिकोडर:

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers.svg" alt="Architecture of a Transformers models">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers-dark.svg" alt="Architecture of a Transformers models">
</div>

ध्यान दें कि डिकोडर ब्लॉक में पहली ध्यान परत डिकोडर के सभी (अतीत) इनपुट पर ध्यान देती है, लेकिन दूसरी ध्यान परत एन्कोडर के आउटपुट का उपयोग करती है। इस प्रकार यह वर्तमान शब्द का सर्वोत्तम अनुमान लगाने के लिए संपूर्ण इनपुट वाक्य तक पहुंच सकता है। यह बहुत उपयोगी है क्योंकि विभिन्न भाषाओं में व्याकरण संबंधी नियम हो सकते हैं जो शब्दों को अलग-अलग क्रम में रखते हैं, या वाक्य में बाद में दिए गए कुछ संदर्भ किसी दिए गए शब्द का सर्वोत्तम अनुवाद निर्धारित करने में सहायक हो सकते हैं।

मॉडल को कुछ विशेष शब्दों पर ध्यान देने से रोकने के लिए *ध्यान मास्क* का उपयोग एन्कोडर/डिकोडर में भी किया जा सकता है - उदाहरण के लिए, विशेष पैडिंग शब्द जिसका उपयोग वाक्यों को एक साथ बैच करते समय सभी इनपुट को समान लंबाई बनाने के लिए किया जाता है।

## आर्किटेक्चर बनाम चेकपॉइंट

जैसे ही हम इस पाठ्यक्रम में ट्रांसफॉर्मर मॉडल में गोता लगाते हैं, आप *आर्किटेक्चर* और *चेकपॉइंट्स* के साथ-साथ *मॉडल* का उल्लेख देखेंगे। इन सभी शब्दों के थोड़े अलग अर्थ हैं:

* **आर्किटेक्चर**: यह मॉडल का कंकाल है - प्रत्येक परत की परिभाषा और मॉडल के भीतर होने वाले प्रत्येक ऑपरेशन।
* **जांच की चौकी**: ये वे वज़न हैं जिन्हें किसी दिए गए आर्किटेक्चर में लोड किया जाएगा।
* **मॉडल**: यह एक छत्र शब्द है जो "आर्किटेक्चर" या "चेकपॉइंट" जितना सटीक नहीं है: इसका मतलब दोनों हो सकता है। अस्पष्टता को कम करने के लिए यह पाठ्यक्रम *वास्तुकला* या *चेकपॉइंट* निर्दिष्ट करेगा।

उदाहरण के लिए, BERT एक आर्किटेक्चर है, जबकि `बर्ट-बेस-केस्ड`, BERT की पहली रिलीज़ के लिए Google टीम द्वारा प्रशिक्षित वज़न का एक सेट एक चेकपॉइंट है। हालांकि, कोई "बीईआरटी मॉडल" और "`बर्ट-बेस-केसेड` मॉडल" कह सकता है।


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/hi/chapter1/4.mdx" />