# Pemrosesan Bahasa Natural (Natural Language Processing)

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

Sebelum mempelajari mengenai model-model Transformer, mari menyamakan persepsi mengenai _natural language processing_ (NLP) terlebih dahulu.

## NLP itu apa?

NLP merupakan cabang ilmu linguistik dan pembelajaran mesin (_machine learning_) yang bertujuan untuk memahami bahasa manusia sehari-hari. Tujuan dari penerapan NLP tidak terbatas pada pemahaman kata per kata saja, tapi juga mengenai konteks yang terkandung dalam setiap ucapan/kata.

Beberapa penerapan NLP yang umum diterapkan beserta contohnya dapat dilihat dibawah:

- **Klasifikasi kalimat secara utuh**: Mengetahui sentimen dari sebuah review, mendeteksi email spam, menentukan ketepatan tata bahasa sebuah kalimat atau mencari tahu keterkaitan antar 2 kalimat
- **Classifying each word in a sentence**: Identifying the grammatical components of a sentence (noun, verb, adjective), or the named entities (person, location, organization)
- **Klasifikasi setiap kata dalam sebuah kalimat**: Pengelompokkan unsur kalimat (kata benda, kata kerja, kata sifat), atau pengelompokkan subjek kalimat (orang, lokasi, organisasi)
- **Menciptakan/menambahkan/memperkaya kalimat**: Menyelesaikan kalimat dengan teks yang diciptakan secara otomatis, mengisi titik-titik pada sebuah kuis
- **Menjawab pertanyaan**: Dengan memberi model daftar pertanyaan beserta konteks, menjawab pertanyaan berdasar informasi yang tersedia
- **Menciptakan kalimat baru dari teks**: Menerjemahkan suatu bahasa ke bahasa lain, menyimpulkan kalimat

Penerapan NLP tidak hanya terbatas pada teks. NLP juga dapat diterapkan untuk menangani kasus pengelan suara (_speech recognition_) dan penglihatan komputer (_computer vision_) seperti menciptakan transkrip dari sampel suara (audio) atau deskripsi gambar.

## Tantangan-tantangan dalam penerapan NLP

Komputer tidak dapat memahami informasi secara langsung maupun secara harfiah seperti manusia. Sebagai contoh, ketika membaca kalimat "Saya lapar", manusia dapat dengan mudah memahami maknanya. Begitu juga jika ketika membaca kalimat "Saya lapar" dan "Saya sedih", manusia dapat dengan memudah menentukan apakah kedua kalimat memiliki kemiripan atau tidak. Tapi hal-hal tersebut sulit dipahami oleh model pembelajaran mesin (_machine learning_ (ML)). Kalimat-kalimat tersebut perlu direkayasa (diolah) sedimikian rupa sehingga dapat dipelajari oleh model ML. Ditambah dengan keunikan setiap bahasa/teks, kompleksitas rekayasa yang perlu dilakukan menjadi tantangan tersendiri. Sudah ada banyak riset yang meneliti mengenai bagaiman merekayasa teks untuk penerapan ML dan anda akan mempelajarinya di bab-bab berikutnya.


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/id/chapter1/2.mdx" />