# Introduzione

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

## Benvenuto/a al corso di 🤗!

<Youtube id="00GKzGyWFEs" />

Questo corso ti insegnerà a eseguire compiti di Natural Language Processing (NLP, *elaborazione del linguaggio naturale*) utilizzando le librerie dell'ecosistema di [Hugging Face](https://huggingface.co/): [🤗 Transformers](https://github.com/huggingface/transformers), [🤗 Datasets](https://github.com/huggingface/datasets), [🤗 Tokenizers](https://github.com/huggingface/tokenizers), e [🤗 Accelerate](https://github.com/huggingface/accelerate). Ti insegneremo anche ad usare il nostro [Hugging Face Hub](https://huggingface.co/models), che è completamente gratuito e senza pubblicità.


## Contenuti

Eccoti un breve riassunto dei contenuti del corso:

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/summary.svg" alt="Brief overview of the chapters of the course.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/summary-dark.svg" alt="Brief overview of the chapters of the course.">
</div>

- I capitoli da 1 a 4 forniscono un'introduzione ai concetti principali della libreria 🤗 Transformers. Alla fine di questa parte del corso, conoscerai come funzionano i modelli Transformers e saprai come utilizzare un modello dell'[Hugging Face Hub](https://huggingface.co/models), affinarlo in un dataset, e condividere i tuoi risultati nell'Hub!
- I capitoli da 5 a 8 insegnano le basi degli 🤗 Dataset e degli 🤗 Tokenizer, per poi esplorare alcuni compiti classici di NLP. Alla fine di questa parte, saprai far fronte ai problemi di NLP più comuni in maniera autonoma.
- I capitoli da 9 a 12 vanno oltre il Natural Language Processing, ed esplorano come i modelli Transformer possano essere utilizzati per affrontare compiti di elaborazione vocale o visione artificiale. Strada facendo, imparerai a costruire e condividere demo (*dimostrazioni*) dei tuoi modelli, e ad ottimizzarli per la produzione. Alla fine di questa parte, sarai pronto ad utilizzare gli 🤗 Transformer per qualsiasi problema di machine learning (*apprendimento automatico*), o quasi!

Questo corso:

* Richiede una buona conoscenza di Python
* Andrebbe seguito di preferenza a seguito di un corso introduttivo di deep learning (*apprendimento profondo*), come ad esempio il [Practical Deep Learning for Coders](https://course.fast.ai/) di [fast.ai](https://www.fast.ai/), oppure uno dei programmi sviluppati da [DeepLearning.AI](https://www.deeplearning.ai/)
* Non richiede conoscenze pregresse di [PyTorch](https://pytorch.org/) o [TensorFlow](https://www.tensorflow.org/), nonostante sia gradita una conoscenza anche superficiale dell'uno o dell'altro

Quando avrai completato questo corso, ti raccomandiamo di passare al [Natural Language Processing Specialization](https://www.coursera.org/specializations/natural-language-processing?utm_source=deeplearning-ai&utm_medium=institutions&utm_campaign=20211011-nlp-2-hugging_face-page-nlp-refresh) di DeepLearning.AI, un corso che copre un ampio spettro di modelli tradizionali di NLP che vale davvero la pena di conoscere, come Naive Bayes e LSTM (*Memoria a breve termine a lungo termine*)!

## Chi siamo?

A proposito degli autori:

**Matthew Carrigan** è Machine Learning Engineer da Hugging Face. Vive a Dublino, in Irlanda, ed in passato è stato ML engineer da Parse.ly, e prima ancora ricercatore postdottorale al Trinity College di Dublin. Nonostante non creda che otterremo l'Intelligenza artificiale forte semplicemente ingrandendo le architetture a nostra disposizione, spera comunque nell'immortalità cibernetica.

**Lysandre Debut** è Machine Learning Engineer da Hugging Face e ha lavorato agli 🤗 Transformer fin dalle primissime tappe del loro sviluppo. Il suo obiettivo è di rendere il NLP accessibile a tutti sviluppando strumenti con un semplice API.

**Sylvain Gugger** è Research Engineer da Hugging Face e uno dei principali manutentori della libreria 🤗 Transformers. In passato, è stato Research Scientist da fast.ai, e ha scritto [Deep Learning for Coders with fastai and PyTorch](https://learning.oreilly.com/library/view/deep-learning-for/9781492045519/) con Jeremy Howard. Il centro principale della sua ricerca consiste nel rendere il deep learning (*apprendimento profondo*) più accessibile, concependo e migliorando tecniche che permettano di allenare modelli velocemente con risorse limitate.

**Merve Noyan** è developer advocate da Hugging Face, e lavora allo sviluppo di strumenti e alla creazione di contenuti ad essi legati per democratizzare l'accesso al deep learning.

**Lucile Saulnier** è machine learning engineer da Hugging Face, e sviluppa e supporta l'utilizzo di strumenti open source. È anche attivamente coinvolta in numerosi progetti di ricerca nell'ambito del NLP, come ad esempio collaborative training e BigScience.

**Lewis Tunstall** è machine learning engineer da Hugging Face che si specializza nello sviluppo di strumenti open-source e la loro distribuzione alla comunità più ampia. È anche co-autore dell'imminente [O’Reilly book on Transformers](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/).

**Leandro von Werra** è machine learning engineer nel team open-source di Hugging Face, nonché co-autore dell'imminente [O’Reilly book on Transformers](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/). Ha tanti anni di esperienza nel portare progetti di NLP in produzione, lavorando a tutti i livelli di esecuzione di compiti di machine learning.

Sei pronto/a a iniziare? In questo capitolo, imparerai:
* Ad utilizzare la funzione `pipeline()` per eseguire compiti di NLP come la generazione e classificazione di testi
* L'architettura dei Transformer
* Come fare la distinzione tra architetture encoder, decoder, encoder-decoder, e casi d'uso


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/it/chapter1/1.mdx" />