# Natural Language Processing

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

Prima di tuffarci nei modelli Transformer, diamo un'occhiata rapida alla natura del natural language processing (*elaborazione del linguaggio naturale*) e alle ragioni per cui quest'ultimo ci interessa.

## Cosa intendiamo per NLP?

NLP è un campo di linguistica e machine learning (*apprendimento automatico*) che si focalizza sulla comprensione di tutto ciò che è legato al linguaggio umano. L'obiettivo dei compiti di NLP non è semplicemente di capire singole parole individualmente, ma anche di capirne il contesto.

La seguente è una lista dei più comuni compiti di NLP, ognuno accompagnato da esempi:

- **Classificazione di frasi intere**: Capire il tono di una recensione, comprendere se una mail si tratta di spam (*spazzatura*), determinare se una frase è grammaticalmente corretta oppure se due frasi hanno un legame logico
- **Classificazione di parole singole all'interno di una frase**: Identificazione dei componenti grammaticali di una frase (nome, verbo, aggettivo), o di entità denominate (persona, località, organizzazione)
- **Generazione di contenuto testuale**: Completare un prompt a mezzo di testo auto-generato, colmare spazi vuoti in un testo con parole mascherate
- **Estrazione di risposte a partire da un testo**: Dati una domanda e un contesto, estrarre la risposta alla domanda sulla base del contesto fornito
- **Generazione di frasi nuove a partire da un testo input**: Traduzione di un testo in un'altra lingua, riassunto di un testo

NLP non si limita però ai soli testi scritti, e tratta anche sfide complesse in riconoscimento vocale e computer vision (*elaborazione di dati visuali*), quali la generazione di trascrizioni di campioni audio o la descrizione di immagini.

## Perché costituisce una sfida?

I computer non elaborano le informazioni allo stesso modo degli umani. Ad esempio, quando leggiamo la frase "Ho fame," ne capiamo senza difficoltà il senso. Allo stesso modo, date due frasi quali "Ho fame" e "Sono triste," riusciamo facilmente a determinarne il livello di similarità. Per i modelli di machine learning (ML), tali compiti sono più difficili. Il testo deve essere elaborato in un modo che permetta al modello di imparare da esso. E siccome il linguaggio è complesso, il modo in cui l'elaborazione va svolta dev'essere studiato con cura. Molta ricerca è stata fatta su come rappresentare i testi, e nel prossimo capitolo vedremo alcuni di questi metodi.


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/it/chapter1/2.mdx" />