# Quiz di fine capitolo

<CourseFloatingBanner
    chapter={5}
    classNames="absolute z-10 right-0 top-0"
/>

In questo capitolo abbiamo fatto un bel po' di strada! Non preoccuparti se non hai colto tutti i dettagli; i capitoli successivi ti aiuteranno a capire come funzionano le cose dietro le quinte!

Prima di andare oltre, mettiamo alla prova ciò che hai imparato in questo capitolo.

### 1. Usando la funzione `load_dataset()` in 🤗 Datasets, da dove puoi caricare un dataset?

<Question
	choices={[
		{
			text: "In locale, ad esempio dal tuo portatile.",
			explain: "Corretto! Puoi passare i path dei file nell'argomento <code>data_files</code> di <code>load_dataset()</code> per caricare dataset locali.",
			correct: true
		},
		{
			text: "L'Hub Hugging Face.",
			explain: "Corretto! Puoi caricare i dataset presenti sull'Hub fornendo l'ID del dataset, ad esempio <code>load_dataset('emotion')</code>.",
			correct: true
		},
		{
			text: "Un server remoto",
			explain: "Corretto! Puoi passare un URL nell'argomento <code>data_files</code> di <code>load_dataset()</code> per caricare file in remoto.",
			correct: true
		},
	]}
/>

### 2. Immagina di caricare uno dei task GLUE come segue:

```py
from datasets import load_dataset

dataset = load_dataset("glue", "mrpc", split="train")
```

Quale dei comandi seguenti produce un campione di 50 elementi casuali da `dataset`?

<Question
	choices={[
		{
			text: "<code>dataset.sample(50)</code>",
			explain: "Questa risposta è sbagliata -- non esiste nessun metodo <code>Dataset.sample()</code>."
		},
		{
			text: "<code>dataset.shuffle().select(range(50))</code>",
			explain: "Corretto! Come hai visto in questo capitolo, puoi mescolare il dataset e selezionarne i campioni.",
			correct: true
		},
		{
			text: "<code>dataset.select(range(50)).shuffle()</code>",
			explain: "Questa risposta è sbagliata -- anche se il codice verrebbe eseguito, mescolerebbe solo i primi 50 elementi del dataset"
		}
	]}
/>

### 3. Immagina di avere un dataset sugli animali domestici, chiamto `pets_dataset`, che ha una colonna `name` che denota il nome di ogni animale. Quale degli approcci ci permetterebbe di filtrare il dataset e lasciare solo gli animali il cui nome inizia con la lettera "L"?
<Question
	choices={[
		{
			text: "<code>pets_dataset.filter(lambda x : x['name'].startswith('L'))</code>",
			explain: "Corretto! Usare una funzione lambda di Python per questi filtri veloci è un'ottima idea. Riesci a pensare a un'altra soluzione?",
			correct: true
		},
		{
			text: "<code>pets_dataset.filter(lambda x['name'].startswith('L'))</code>",
			explain: "Questa risposta è sbagliata: una funzione lambda ha la forma generica <code>lambda *argomenti* : *espressione*</code>, per cui devi esplicitare gli argomenti in questo caso."
		},
		{
			text: "Creare una funzione come <code>def filter_names(x): return x['name'].startswith('L')</code> ed eseguire <code>pets_dataset.filter(filter_names)</code>.",
			explain: "Corretto! Proprio come <code>Dataset.map()</code>, puoi passare delle funzioni esplicite a <code>Dataset.filter()</code>. Quest'opzione è utile quando hai un'espressione complessa che non è adatta a una funzione lambda. Quale altra soluzione potrebbe funzionare?",
			correct: true
		}
	]}
/>

### 4. Cos'è il memory mapping?

<Question
	choices={[
		{
			text: "Una mappatura tra la RAM CPU e quella GPU",
			explain: "Sbagliato, ritenta!",
		},
		{
			text: "Una mappatura tra la RAM e un archivio in memoria.",
			explain: "Corretto! 🤗 Datasets tratta ogni dataset con un file mappato in memoria. Questo permette alla libreria di accedere  e operare sugli elementi del dataset senza alcun bisogno di caricarlo in memoria.",
			correct: true
		},
		{
			text: "Una mappatura tra due file nella cache 🤗 Datasets" ,
			explain: "Sbagliato, ritenta!"
		}
	]}
/>

### 5. Quali dei seguenti sono i principali vantaggi del memory mapping?

<Question
	choices={[
		{
			text: "Accere ai file mappati in memoria è più veloce che leggere o scrivere da disco.",
			explain: "Corretto! Questo permette a 🤗 Datasets di essere incredibilmente veloce. Ma non è l'unico vantaggio!",
			correct: true
		},
		{
			text: "Le applicazioni possono accedere a segmenti di dati in un file estremamente grando senza dover prima leggere l'intero file in RAM.",
			explain: "Corretto! Questo permette a 🤗 Datasets di caricare dataset grandi molti gigabyte sul tuo portatile senza far scoppiare la tua CPU. Quali altri vantaggi offre il memory mapping?",
			correct: true
		},
		{
			text: "Consuma meno energia, così la tua batteria dura più a lungo.",
			explain: "Sbagliato, ritenta!"
		}
	]}
/>

### 6. Cosa causa un errore nel codice seguente?

```py
from datasets import load_dataset

dataset = load_dataset("allocine", streaming=True, split="train")
dataset[0]
```

<Question
	choices={[
		{
			text: "Cerca di creare uno streaming con un dataset che è troppo grande per la RAM.",
			explain: "Questa risposta è sbagliata -- i dataset in streaming sono decompressi al momenti, e puoi processare dataset grandi terabyte anche con poca RAM!",
		},
		{
			text: "Cerca di accedere a un <code>IterableDataset</code>.",
			explain: "Corretto! Un <code>IterableDataset</code> è un generatore e non un contenitore, per cui puoi accedere ai suoi elementi solo usando <code>next(iter(dataset))</code>.",
			correct: true
		},
		{
			text: "Il dataset <code>allocine</code> non ha una sezione <code>train</code>.",
			explain: "Questa risposta è sbagliata -- controlla le [informazioni sul dataset <code>allocine</code>](https://huggingface.co/datasets/allocine) sull'Hub per vedere quali sezioni contiente."
		}
	]}
/>

### 7. Quali dei seguenti sono i vantaggi principali di creare una dataset card?

<Question
	choices={[
		{
			text: "Offre informazioni sull'uso previsto e i task supportati dal dataset, così altri utenti della community possano prendere una decisione informata su come utilizzarlo.",
			explain: "Corretto! I dataset senza documentazione possono essere usati per addestrare modelli che potrebbero non riflettere le intenzioni dei creatori del dataset, oppure produrre modelli dal dubbio status legale se sono addestrati su dati che violano la privacy o restrizioni di autorizzazioni. Ma questo non è l'unico vantaggio!",
			correct : true
		},
		{
			text: "Aiuta ad attirare l'attenzione ai bias presenti in un corpus.",
			explain: "Corretto! Quasi tutti i dataset hanno qualche forma di bias, che può avere conseguenze negative in corso d'opera. Prestarci attenzione aiuta i creatori di modelli a capire come superare i bias impliciti. A cos'altro possono servire?",
			correct : true
		},
		{
			text: "Aumenta le possibilità che gli altri utenti della community useranno il dataset.",
			explain: "Corretto! Una dataset card ben scritta porterà a un uso maggiore del tuo caro dataset. Quali altri benefici può offrire?",
			correct: true
		},
	]}
/>


### 8. Cos'è la ricerca semantica?

<Question
	choices={[
		{
			text: "Un metodo per ricercare la corrispondenza esatta delle parole in una richiesta e i documenti di un corpus",
			explain: "Questa risposta è sbagliata -- questo tipo di ricerca è chiamata *ricerca lessicale*, ed è quella che tipicamente viene utilizzata nei motori di ricerca tradizionali."
		},
		{
			text: "Un metodo per cercare documenti corrispondenti attraverso la comprensione del signifcato contestuale di una richiesta",
			explain: "Corretto! La ricerca semantica utilizza i vettori di parole per rappresentare le richieste e i documenti, e usa una metrica di similarità per calcolare la sovrapposizione tra queste. Puoi pensare a un altro modo di descrivere la ricerca semantica?",
			correct: true
		},
		{
			text: "Un metodo per migliorare l'acucratezza della ricerca",
			explain: "Corretto! I motori di ricerca semantici riescono a catturare l'intento di una richiesta molto meglio di un sistema a parole chiave, e tipicamente recupera documenti con una precisione maggiore. Ma questa non è l'unica risposta corretta: cos'altro offre la ricerca semantica?",
			correct: true
		}
	]}
/>

### 9. Nelle ricerche semantiche asimmetriche, solitamente si hanno:

<Question
	choices={[
		{
			text: "Una richiesta breve e un paragrafo più lungo che risponde alla richiesta",
			explain: "Corretto!",
			correct : true
		},
		{
			text: "Le richieste e i paragrafi sono più o meno della stessa lunghezza.",
			explain: "Questo è in realtà un esempio di ricerca semantica simmetrica: ritenta!"
		},
		{
			text: "Una richiesta lunga e un paragrafo più breve che risponde alla richiesta",
			explain: "Questa risposta è sbagliata -- ritenta!"
		}
	]}
/>

### 10. Posso usare 🤗 Datasets per caricare dati utilizzabili in altri domini, come processamento del parlato?

<Question
	choices={[
		{
			text: "No",
			explain: "Questa risposta è sbagliata -- al momento 🤗 Datasets supporta dati tabulari, audio e per visione artificale. controlla il <a  href='https://huggingface.co/datasets/mnist'>dataset MNIST</a> sull'Hub per un esempio di dati per visione artificiale."
		},
		{
			text: "Sì",
			explain: "Questa risposta è corretta! Controlla gli eccitanti sviluppi per il parlato e la visione artificiale nella libreria 🤗 Transformers per vedere come è utilizzato 🤗 Datasets in questi domini.",
			correct : true
		},
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/it/chapter5/8.mdx" />