# Introdução

<CourseFloatingBanner
    chapter={2}
    classNames="absolute z-10 right-0 top-0"
/>

Como você viu no [Capitulo 1](/course/pt/chapter1), normalmente modelos Transformers são muito grandes. Com milhões a dezenas de *bilhões* de parâmetros, o treinamento e o deploy destes modelos é uma tarefa complicado. Além disso, com novos modelos sendo lançados quase diariamente e cada um tendo sua própria implementação, experimentá-los a todos não é tarefa fácil.

A biblioteca 🤗 Transformers foi criado para resolver este problema. Seu objetivo é fornecer uma API única através do qual qualquer modelo Transformer possa ser carregado, treinado e salvo. As principais características da biblioteca são:

- **Fácil de usar**: Baixar, carregar e usar um modelo de processamento natural de linguagem (PNL) de última geração para inferência pode ser feito em apenas duas linhas de código
- **Flexibilidade**: Em sua essência, todos os modelos são uma simples classe PyTorch `nn.Module` ou TensorFlow `tf.keras.Model` e podem ser tratadas como qualquer outro modelo em seus respectivos frameworks de machine learning (ML).
- **Simplicidade**: Quase nenhuma abstração é feita em toda a biblioteca. O "Tudo em um arquivo" é um conceito principal: o "passe para frente" de um modelo é inteiramente definido em um único arquivo, de modo que o código em si seja compreensível e hackeável.

Esta última característica torna 🤗 Transformers bem diferente de outras bibliotecas ML que modelos e/ou configurações são compartilhados entre arquivos; em vez disso, cada modelo tem suas próprias camadas. Além de tornar os modelos mais acessíveis e compreensíveis, isto permite que você experimente facilmente um modelo sem afetar outros.

Este capítulo começará com um exemplo de ponta a ponta onde usamos um modelo e um tokenizer juntos para replicar a função `pipeline()` introduzida no [Capitulo 1](/course/pt/chapter1). A seguir, discutiremos o modelo da API: onde veremos profundamente as classes de modelo e configuração, além de mostrar como carregar um modelo e como ele processa as entradas numéricas para as previsões de saída. 

Depois veremos a API do tokenizer, que é o outro componente principal da função `pipeline()`. Os Tokenizers cuidam da primeira e da última etapa do processamento, cuidando da conversão de texto para entradas numéricas para a rede neural, e da conversão de volta ao texto quando for necessário. Por fim, mostraremos a você como lidar com o envio de várias frases através de um modelo em um batch preparado, depois olharemos tudo mais atentamente a função de alto nível `tokenizer()`.


<Tip>
⚠️ Para beneficiar-se de todos os recursos disponíveis com o Model Hub e 🤗 Transformers, recomendamos  <a href="https://huggingface.co/join"> criar uma conta</a>.
</Tip>

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/pt/chapter2/1.mdx" />