# Folosiți setul de date adnotat[[folosiți-setul-de-date-adnotat]]

<CourseFloatingBanner chapter={10}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter10/section5.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter10/section5.ipynb"},
]} />

Vom învăța acum cum să exportăm și să folosim datele adnotate pe care le avem în Argilla.

## Încărcați setul de date

Mai întâi, va trebui să ne asigurăm că suntem conectați la instanța noastră Argilla ca în pașii anteriori:

```python
import argilla as rg

HF_TOKEN = "..."  # doar pentru space-uri private

client = rg.Argilla(
    api_url="...",
    api_key="...",
    headers={"Authorization": f"Bearer {HF_TOKEN}"},  # doar pentru space-uri private
)
```

Și acum, vom încărca setul de date cu care vom lucra:

```python
dataset = client.datasets(name="ag_news")
```

Încărcarea setului de date și apelarea înregistrărilor sale cu `dataset.records` este suficient pentru a începe să folosiți setul de date și înregistrările pentru propriile scopuri și pipeline-uri. Cu toate acestea, vom învăța de asemenea cum să facem câteva operații opționale, precum filtrarea înregistrărilor și exportarea setului de date către Hugging Face Hub.

## Filtrați setul de date

Uneori doriți să folosiți doar înregistrările care au fost completate, așa că vom filtra mai întâi înregistrările din setul nostru de date pe baza statutului lor:

```python
status_filter = rg.Query(filter=rg.Filter([("status", "==", "completed")]))

filtered_records = dataset.records(status_filter)
```

>[!TIP]
>⚠️ Rețineți că înregistrările cu statutul `completed` (adică înregistrările care îndeplinesc răspunsurile minime trimise configurate în setările de distribuire a sarcinii) ar putea avea mai mult de un răspuns și că fiecare răspuns poate avea orice statut dintre `submitted`, `draft` sau `discarded`.

Aflați mai multe despre interogarea și filtrarea înregistrărilor în [documentația Argilla](https://docs.argilla.io/latest/how_to_guides/query/).

## Exportați către Hub

Acum putem exporta adnotările noastre către Hugging Face Hub, astfel încât să le putem împărtăși cu alții. Pentru a face asta, va trebui să convertim înregistrările într-un 🤗 Dataset și apoi să îl împingem către Hub:

```python
filtered_records.to_datasets().push_to_hub("argilla/ag_news_annotated")
```

Alternativ, putem exporta direct setul de date Argilla complet (inclusiv înregistrările în așteptare) astfel:

```python
dataset.to_hub(repo_id="argilla/ag_news_annotated")
```

Aceasta este o alegere interesantă în cazul în care alții vor să deschidă setul de date în instanțele lor Argilla, deoarece setările sunt salvate automat și ei pot pur și simplu să importe setul de date complet folosind o singură linie de cod:

```python
dataset = rg.Dataset.from_hub(repo_id="argilla/ag_news_annotated")
``` 

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter10/5.mdx" />