# Evaluarea

Cu un model ajustat fin prin SFT sau LoRA SFT, ar trebui să îl evaluăm pe criterii de referință standard. Ca ingineri de machine learning, ar trebui să mențineți o suită de evaluări relevante pentru domeniul dumneavoastră țintă de interes. În această pagină, vom privi la unele dintre criteriile de referință cele mai comune și cum să le folosiți pentru a evalua modelul dumneavoastră. De asemenea, vom vedea cum să creați criterii de referință personalizate pentru cazul specific de utilizare.

## Criterii de referință automate

Criteriile de referință automate servesc ca instrumente standardizate pentru evaluarea modelelor de limbaj pe diferite sarcini și capacități. În timp ce acestea oferă un punct de plecare util pentru înțelegerea performanței modelului, este important să recunoaștem că reprezintă doar o piesă dintr-o strategie de evaluare cuprinzătoare.

## Înțelegerea criteriilor de referință automate

Criteriile de referință automate constau de obicei din seturi de date curate cu sarcini și metrici de evaluare predefinite. Aceste criterii de referință au ca scop să evalueze diverse aspecte ale capacității modelului, de la înțelegerea de bază a limbajului la raționament complex. Avantajul cheie al folosirii criteriilor de referință automate este standardizarea lor - permit compararea consistentă între modele diferite și oferă rezultate reproductibile.

Cu toate acestea, este crucial să înțelegem că performanța la criterii de referință nu se traduce întotdeauna direct în eficacitate din lumea reală. Un model care excelează la criterii de referință academice poate totuși să se confrunte cu aplicații de domeniu specifice sau cazuri de utilizare practice.

## Criterii de referință pentru cunoștințe generale

[MMLU](https://huggingface.co/datasets/cais/mmlu) (Massive Multitask Language Understanding) testează cunoștințele pe 57 de subiecte, de la știință la științe umane. Deși cuprinzător, poate să nu reflecte profunzimea expertizei necesare pentru domenii specifice. TruthfulQA evaluează tendința unui model de a reproduce concepții greșite comune, deși nu poate captura toate formele de dezinformare.

## Criterii de referință pentru raționament

[BBH](https://huggingface.co/datasets/lukaemon/bbh) (Big Bench Hard) și [GSM8K](https://huggingface.co/datasets/openai/gsm8k) se concentrează pe sarcini de raționament complex. BBH testează gândirea logică și planificarea, în timp ce GSM8K vizează specific rezolvarea problemelor matematice. Aceste criterii de referință ajută la evaluarea capacităților analitice dar pot să nu captureze raționamentul nuanțat necesar în scenarii din lumea reală.

## Înțelegerea limbajului

[HELM](https://github.com/stanford-crfm/helm) oferă un cadru de evaluare holistic. Criterii de referință precum HELM oferă perspective asupra capacităților de procesare a limbajului pe aspecte precum bunul simț, cunoștințele despre lume și raționamentul. Dar pot să nu reprezinte complet complexitatea conversației naturale sau terminologia specifică domeniului.

## Criterii de referință specifice domeniului

Să ne uităm la câteva criterii de referință care se concentrează pe domenii specifice precum matematica, codarea și chatul.

[Criteriul de referință MATH](https://huggingface.co/papers/2103.03874) este un alt instrument important de evaluare pentru raționamentul matematic. Constă din 12.500 de probleme din competiții de matematică, acoperind algebra, geometria, teoria numerelor, numărarea, probabilitatea și altele. Ceea ce face MATH deosebit de provocator este că necesită raționament în mai mulți pași, înțelegerea notației matematice formale și capacitatea de a genera soluții pas cu pas. Spre deosebire de sarcinile aritmetice mai simple, problemele MATH necesită adesea strategii sofisticate de rezolvare a problemelor și aplicații de concepte matematice.

[Criteriul de referință HumanEval](https://github.com/openai/human-eval) este un set de date de evaluare axat pe codare format din 164 de probleme de programare. Criteriul de referință testează capacitatea unui model de a genera cod Python funcțional corect care rezolvă sarcinile de programare date. Ceea ce face HumanEval deosebit de valoros este că evaluează atât capacitățile de generare de cod, cât și corectitudinea funcțională prin executarea efectivă a cazurilor de test, mai degrabă decât doar similaritatea superficială cu soluțiile de referință. Problemele variază de la manipularea de bază a șirurilor la algoritmi și structuri de date mai complexe.

[Alpaca Eval](https://tatsu-lab.github.io/alpaca_eval/) este un cadru de evaluare automatizat conceput pentru a evalua calitatea modelelor de limbaj care urmează instrucțiuni. Folosește GPT-4 ca judecător pentru a evalua ieșirile modelului pe diverse dimensiuni, inclusiv utilitatea, onestitatea și inofensivitatea. Cadrul include un set de date cu 805 de prompturi atent curate și poate evalua răspunsurile față de modele multiple de referință precum Claude, GPT-4 și altele. Ceea ce face Alpaca Eval deosebit de util este capacitatea sa de a oferi evaluări consistente, scalabile fără a necesita adnotatori umani, în timp ce încă capturează aspecte nuanțate ale performanței modelului pe care metricile tradiționale le-ar putea rata.

## Abordări alternative de evaluare

Multe organizații au dezvoltat metode alternative de evaluare pentru a aborda limitările criteriilor de referință standard:

### LLM-ca-judecător

Folosirea unui model de limbaj pentru a evalua ieșirile altuia a devenit din ce în ce mai populară. Această abordare poate oferi feedback mai nuanțat decât metricile tradiționale, deși vine cu propriile sale prejudecăți și limitări.

### Arene de evaluare

Arenele de evaluare precum [Chatbot Arena](https://lmarena.ai/) oferă o abordare unică pentru evaluarea LLM prin feedback crowdsourced. În aceste platforme, utilizatorii se angajează în "bătălii" anonime între două LLM-uri, punând întrebări și votând care model oferă răspunsuri mai bune. Această abordare capturează modelele de utilizare și preferințele din lumea reală prin întrebări diverse, provocatoare, cu studii care arată acord puternic între voturile crowdsourced și evaluările experților. Deși puternice, aceste platforme au limitări, inclusiv prejudecăți potențiale ale bazei de utilizatori, distribuții distorsionate ale prompturilor și o concentrare principală pe utilitate mai degrabă decât pe considerațiile de siguranță.

### Suite de criterii de referință personalizate

Organizațiile dezvoltă adesea suite interne de criterii de referință adaptate nevoilor și cazurilor lor specifice de utilizare. Acestea ar putea include teste de cunoștințe specifice domeniului sau scenarii de evaluare care reflectă condițiile reale de implementare.

## Evaluare personalizată

În timp ce criteriile de referință standard oferă o linie de bază utilă, nu ar trebui să fie singura metodă de evaluare. Iată cum să dezvoltați o abordare mai cuprinzătoare:

1. Începeți cu criterii de referință standard relevante pentru a stabili o linie de bază și a permite comparația cu alte modele.

2. Identificați cerințele și provocările specifice ale cazului dumneavoastră de utilizare. Ce sarcini va îndeplini efectiv modelul? Ce tipuri de erori ar fi cele mai problematice?

3. Dezvoltați seturi de date de evaluare personalizate care reflectă cazul real de utilizare. Aceasta ar putea include:
   - Întrebări reale ale utilizatorilor din domeniul dumneavoastră
   - Cazuri comune de margine pe care le-ați întâlnit
   - Exemple de scenarii deosebit de provocatoare

4. Considerați implementarea unei strategii de evaluare pe mai multe niveluri:
   - Metrici automate pentru feedback rapid
   - Evaluare umană pentru înțelegere nuanțată
   - Revizuire de experți de domeniu pentru aplicații specializate
   - Testare A/B în medii controlate

## Implementarea evaluărilor personalizate

În această secțiune, vom implementa evaluarea pentru modelul nostru ajustat fin. Putem folosi [`lighteval`](https://github.com/huggingface/lighteval) pentru a evalua modelul nostru ajustat fin pe criterii de referință standard, care conține o gamă largă de sarcini încorporate în bibliotecă. Trebuie doar să definim sarcinile pe care dorim să le evaluăm și parametrii pentru evaluare.

Sarcinile LightEval sunt definite folosind un format specific:

```
{suite}|{task}|{num_few_shot}|{auto_reduce}
```

| Parametru | Descriere |
|-----------|-----------|
| `suite` | Suita de criterii de referință (de ex., 'mmlu', 'truthfulqa') |
| `task` | Sarcina specifică din suită (de ex., 'abstract_algebra') |
| `num_few_shot` | Numărul de exemple de inclus în prompt (0 pentru zero-shot) |
| `auto_reduce` | Dacă să reducă automat exemplele few-shot dacă promptul este prea lung (0 sau 1) |

Exemplu: `"mmlu|abstract_algebra|0|0"` evaluează pe sarcina de algebră abstractă MMLU cu inferență zero-shot.

## Exemplu de pipeline de evaluare

Să configurăm un pipeline de evaluare pentru modelul nostru ajustat fin. Vom evalua modelul pe un set de sub-sarcini care se raportează la domeniul medicinei.

Iată un exemplu complet de evaluare pe criterii de referință automate relevante pentru un domeniu specific folosind Lighteval cu backend-ul VLLM:

```bash
lighteval accelerate \
    "pretrained=your-model-name" \
    "mmlu|anatomy|0|0" \
    "mmlu|high_school_biology|0|0" \
    "mmlu|high_school_chemistry|0|0" \
    "mmlu|professional_medicine|0|0" \
    --max_samples 40 \
    --batch_size 1 \
    --output_path "./results" \
    --save_generations true
```

Rezultatele sunt afișate în format tabular arătând:

```
|                  Task                  |Version|Metric|Value |   |Stderr|
|----------------------------------------|------:|------|-----:|---|-----:|
|all                                     |       |acc   |0.3333|±  |0.1169|
|leaderboard:mmlu:_average:5             |       |acc   |0.3400|±  |0.1121|
|leaderboard:mmlu:anatomy:5              |      0|acc   |0.4500|±  |0.1141|
|leaderboard:mmlu:high_school_biology:5  |      0|acc   |0.1500|±  |0.0819|
```

Lighteval include, de asemenea, un API Python pentru sarcini de evaluare mai detaliate, care este util pentru manipularea rezultatelor într-un mod mai flexibil. Consultați [documentația Lighteval](https://huggingface.co/docs/lighteval/using-the-python-api) pentru mai multe informații.

<Tip>

✏️ **Încercați!** Evaluați modelul dumneavoastră ajustat fin pe o sarcină specifică în lighteval.

</Tip>

# Chestionar de sfârșit de capitol[[end-of-chapter-quiz]]

<CourseFloatingBanner
    chapter={11}
    classNames="absolute z-10 right-0 top-0"
/>

### 1. Care sunt principalele avantaje ale folosirii criteriilor de referință automate pentru evaluarea modelului?

<Question
	choices={[
		{
			text: "Ele oferă metrici perfecte de performanță din lumea reală",
			explain: "Incorect! Deși criteriile de referință automate sunt utile, nu se traduc întotdeauna direct în performanța din lumea reală."
		},
		{
			text: "Ele permit compararea standardizată între modele și oferă rezultate reproductibile",
			explain: "Corect! Aceasta este unul dintre beneficiile cheie ale criteriilor de referință automate.",
			correct: true
		},
		{
			text: "Ele elimină nevoia pentru orice altă formă de evaluare",
			explain: "Incorect! Criteriile de referință automate ar trebui să facă parte dintr-o strategie de evaluare cuprinzătoare, nu singura metodă."
		}
	]}
/>

### 2. Care criteriu de referință testează specific cunoștințele pe 57 de subiecte diferite?

<Question
	choices={[
		{
			text: "BBH (Big Bench Hard)",
			explain: "Incorect! BBH se concentrează pe sarcini de raționament complex, nu pe cunoștințe ample de subiecte."
		},
		{
			text: "GSM8K",
			explain: "Incorect! GSM8K vizează specific rezolvarea problemelor matematice."
		},
		{
			text: "MMLU",
			explain: "Corect! MMLU (Massive Multitask Language Understanding) testează cunoștințele pe 57 de subiecte, de la știință la științe umane.",
			correct: true
		}
	]}
/>

### 3. Ce este LLM-ca-judecător?

<Question
	choices={[
		{
			text: "Folosirea unui model de limbaj pentru a evalua ieșirile altuia",
			explain: "Corect! Aceasta este o abordare alternativă de evaluare care poate oferi feedback mai nuanțat.",
			correct: true
		},
		{
			text: "Un criteriu de referință care testează raționamentul judiciar",
			explain: "Incorect! LLM-ca-judecător se referă la folosirea unui model pentru a evalua pe altul, nu la testarea raționamentului judiciar."
		},
		{
			text: "O metodă pentru antrenarea modelelor pe seturi de date juridice",
			explain: "Incorect! Aceasta nu este legată de antrenarea pe date juridice, ci de folosirea unui model pentru a evalua ieșirile altuia."
		}
	]}
/>

### 4. Ce ar trebui inclus într-o strategie de evaluare cuprinzătoare?

<Question
	choices={[
		{
			text: "Doar criterii de referință automate",
			explain: "Incorect! O strategie cuprinzătoare ar trebui să includă mai multe tipuri de evaluare."
		},
		{
			text: "Metrici automate, evaluare umană, revizuire de experți și testare A/B",
			explain: "Corect! O abordare cuprinzătoare include mai multe tipuri de evaluare pentru o înțelegere completă a performanței.",
			correct: true
		},
		{
			text: "Doar evaluare umană",
			explain: "Incorect! Deși evaluarea umană este importantă, o strategie cuprinzătoare necesită mai multe abordări."
		}
	]}
/>

### 5. Care este o limitare a criteriilor de referință automate?

<Question
	choices={[
		{
			text: "Sunt prea scumpe de rulat",
			explain: "Incorect! Costul nu este de obicei principala limitare a criteriilor de referință automate."
		},
		{
			text: "Performanța la criterii de referință nu se traduce întotdeauna direct în eficacitate din lumea reală",
			explain: "Corect! Aceasta este o limitare cheie de ținut minte când folosiți criterii de referință automate.",
			correct: true
		},
		{
			text: "Pot evalua doar modele mici",
			explain: "Incorect! Criteriile de referință automate pot fi folosite pentru a evalua modele de diverse dimensiuni."
		}
	]}
/>

### 6. Care este scopul creării seturilor de date de evaluare personalizate?

<Question
	choices={[
		{
			text: "Pentru a reflecta cazul dumneavoastră specific de utilizare și a include întrebări reale ale utilizatorilor din domeniul dumneavoastră",
			explain: "Corect! Seturile de date personalizate ajută să asigure că evaluarea este relevantă pentru nevoile dumneavoastră specifice.",
			correct: true
		},
		{
			text: "Pentru a înlocui complet criteriile de referință standard",
			explain: "Incorect! Seturile de date personalizate ar trebui să completeze, nu să înlocuiască, criteriile de referință standard."
		},
		{
			text: "Pentru a face evaluarea mai ușoară",
			explain: "Incorect! Crearea seturilor de date personalizate necesită efort suplimentar dar oferă evaluare mai relevantă."
		}
	]}
/> 

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter11/5.mdx" />