# End-of-chapter quiz[[end-of-chapter-quiz]]

<CourseFloatingBanner
    chapter={3}
    classNames="absolute z-10 right-0 top-0"
/>

Testați-vă cunoștințele din acest capitol!

### 1. Dataset-ul `emotion` conține mesaje de pe Twitter etichetate cu emoții. Căutați-l în [Hub](https://huggingface.co/datasets) și citiți descrierea dataset-ului. Care dintre acestea nu este una dintre emoțiile sale de bază?

<Question
	choices={[
		{
			text: "Bucurie",
			explain: "Încercați din nou - această emoție este prezentă în acel set de date!"
		},
		{
			text: "Iubire",
			explain: "Încercați din nou - această emoție este prezentă în acel set de date!"
		},
		{
			text: "Confuzie",
			explain: "Corect! Confuzia nu este una dintre cele șase emoții de bază.",
            correct: true
		},
        {
			text: "Surpriză",
			explain: "Surpriză! Încercați din nou!"
		}
	]}
/>

### 2. Căutați dataset-ul `ar_sarcasm` în [Hub](https://huggingface.co/datasets). Ce tip de sarcină suportă?

<Question
	choices={[
		{
			text: "Clasificarea sentimentelor",
			explain: "Corect! Puteți verifica etichetele (tags) din descrierea dataset-ului.",
            correct: true
		},
		{
			text: "Traducere automată (Machine translation)",
			explain: "Nu este corect — aruncați din nou o privire la <a href='https://huggingface.co/datasets/ar_sarcasm'>descrierea dataset-ului</a>!"
		},
		{
			text: "Named entity recognition",
			explain: "Nu este corect — aruncați din nou o privire la <a href='https://huggingface.co/datasets/ar_sarcasm'>descrierea dataset-ului</a>!"
		},
        {
			text: "Răspuns la întrebări (Question answering)",
			explain: "Din păcate, nu ați răspuns corect. Încercați din nou!"
		}
	]}
/>

### 3. Cum se așteaptă modelul BERT ca o pereche de propoziții să fie procesată?

<Question
	choices={[
		{
			text: "Tokens_of_sentence_1 [SEP] Tokens_of_sentence_2",
			explain: "Este nevoie de un token special <code>[SEP]</code> pentru a separa cele două propoziții, dar nu este singurul lucru necesar!"
		},
		{
			text: "[CLS] Tokens_of_sentence_1 Tokens_of_sentence_2",
			explain: "Este nevoie de un token special <code>[CLS]</code> la început, dar nu este singurul lucru necesar!"
		},
		{
			text: "[CLS] Tokens_of_sentence_1 [SEP] Tokens_of_sentence_2 [SEP]",
			explain: "Corect!",
            correct: true
		},
        {
			text: "[CLS] Tokens_of_sentence_1 [SEP] Tokens_of_sentence_2",
			explain: "Este nevoie atât de un token special <code>[CLS]</code> la început, cât și de un token special <code>[SEP]</code> pentru a separa cele două propoziții, dar mai lipsește ceva!"
		}
	]}
/>

{#if fw === 'pt'}
### 4. Care sunt avantajele metodei `Dataset.map()`?

<Question
	choices={[
		{
			text: "Rezultatele funcției sunt memorate în cache, astfel încât nu va dura nimic dacă reexecutăm codul.",
			explain: "Acesta este într-adevăr unul dintre avantajele acestei metode! Totuși, nu este singurul...",
            correct: true
		},
		{
			text: "Poate aplica multiprocessing pentru a rula mai rapid decât aplicând funcția pe fiecare element din dataset.",
			explain: "Aceasta este o caracteristică interesantă, dar nu este unica!",
            correct: true
		},
		{
			text: "Nu încarcă întregul set de date în memorie, salvând rezultatele de îndată ce este procesat un element.",
			explain: "Acesta este un avantaj al acestei metode. Există însă și altele!",
            correct: true
		},
	]}
/>

### 5. Ce înseamnă umplerea dinamică (dynamic padding)?

<Question
	choices={[
		{
			text: "E atunci când împachetezi intrările pentru fiecare batch la lungimea maximă din întregul dataset.",
			explain: "Este adevărat că împachetăm când creăm batch-ul, dar nu până la lungimea maximă din întregul set de date."
		},
		{
			text: "E atunci când împachetezi intrările în momentul creării batch-ului, la lungimea maximă a propozițiilor din acel batch.",
			explain: "Corect! Partea \"dinamică\" vine din faptul că mărimea fiecărui batch este stabilită în momentul creării, iar ca urmare, toate batch-urile ar putea avea forme diferite.",
            correct: true
		},
		{
			text: "E atunci când împachetezi intrările astfel încât fiecare propoziție să aibă același număr de tokeni ca precedenta în dataset.",
			explain: "Nu este corect, și nici nu are sens să ne uităm la ordinea din dataset, din moment ce îl amestecăm în timpul antrenamentului."
		},
	]}
/>

### 6. Care este scopul unei funcții de „collate"?

<Question
	choices={[
		{
			text: "Asigură că toate secvențele din setul de date au aceeași lungime.",
			explain: "O funcție de collate se ocupă de manipularea batch-urilor individuale, nu a întregului set de date. În plus, vorbim despre funcțiile de collate în general, nu despre <code>DataCollatorWithPadding</code> în mod specific."
		},
		{
			text: "Reunește toate eșantioanele într-un batch.",
			explain: "Corect! Poți transmite funcția de collate ca argument al unui <code>DataLoader</code>. Am folosit funcția <code>DataCollatorWithPadding</code>, care împachetează toate elementele dintr-un batch astfel încât să aibă aceeași lungime.",
            correct: true
		},
		{
			text: "Preprocesează întregul set de date.",
			explain: "Aceasta ar fi o funcție de preprocessing, nu o funcție de collate."
		},
        {
			text: "Trunchiază secvențele din setul de date.",
			explain: "O funcție de collate se ocupă de manipularea batch-urilor individuale, nu a întregului set de date. Dacă sunteți interesați de trunchiere, puteți folosi argumentul <code>truncate</code> al <code>tokenizer</code>."
		}
	]}
/>

### 7. Ce se întâmplă când instanțiați una dintre clasele `AutoModelForXxx` cu un model de limbaj preantrenat (cum ar fi `bert-base-uncased`), care corespunde unei alte sarcini decât cea pentru care a fost antrenat?

<Question
	choices={[
		{
			text: "Nimic, dar primești un avertisment.",
			explain: "Primiți un avertisment, dar asta nu e tot!"
		},
		{
			text: "Head-ul modelului preantrenat este eliminat, iar în locul lui este inserat un head nou, potrivit pentru sarcină.",
			explain: "Corect. De exemplu, când am folosit <code>AutoModelForSequenceClassification</code> cu <code>bert-base-uncased</code>, am primit avertismente la instanțierea modelului. Head-ul preantrenat nu este folosit pentru sarcina de clasificare secvențială, așa că este eliminat și un nou head este instanțiat cu greutăți inițializate aleator.",
            correct: true
		},
		{
			text: "Head-ul modelului preantrenat este eliminat.",
			explain: "Mai trebuie să se întâmple și altceva. Încercați din nou!"
		},
        {
			text: "Nimic, pentru că modelul poate fi ajustat fin (fine-tuned) chiar și pentru o altă sarcină.",
			explain: "Head-ul preantrenat al modelului nu a fost antrenat pentru această sarcină, deci trebuie eliminat!"
		}
	]}
/>

### 8. Care este scopul folosirii `TrainingArguments`?

<Question
	choices={[
		{
			text: "Conține toți hiperparametrii folosiți pentru antrenare și evaluare cu <code>Trainer</code>.",
			explain: "Corect!",
            correct: true
		},
		{
			text: "Specifică dimensiunea modelului.",
			explain: "Dimensiunea modelului este definită de configurația modelului, nu de clasa <code>TrainingArguments</code>."
		},
		{
			text: "Conține doar hiperparametrii folosiți pentru evaluare.",
			explain: "În exemplu, am specificat și unde va fi salvat modelul și checkpoint-urile. Încercați din nou!"
		},
        {
			text: "Conține doar hiperparametrii folosiți pentru antrenare.",
			explain: "În exemplu, am folosit și un <code>evaluation_strategy</code>, așadar acest lucru afectează evaluarea. Încercați din nou!"
		}
	]}
/>

### 9. De ce ar trebui să folosiți biblioteca 🤗 Accelerate?

<Question
	choices={[
		{
			text: "Oferă acces la modele mai rapide.",
			explain: "Nu, biblioteca 🤗 Accelerate nu oferă niciun model."
		},
		{
			text: "Oferă o API la nivel înalt, astfel încât să nu fie nevoie să implementați propria buclă de antrenament.",
			explain: "Asta am făcut cu <code>Trainer</code>, nu cu biblioteca 🤗 Accelerate. Încercați din nou!"
		},
		{
			text: "Face ca buclele noastre de antrenament să funcționeze pe strategii distribuite.",
			explain: "Corect! Cu 🤗 Accelerate, buclele voastre de antrenament vor funcționa pentru mai multe GPU-uri și TPU-uri.",
            correct: true
		},
        {
			text: "Oferă mai multe funcții de optimizare.",
			explain: "Nu, biblioteca 🤗 Accelerate nu oferă nicio funcție de optimizare."
		}
	]}
/>

{:else}
### 4. Ce se întâmplă când instanțiați una dintre clasele `TFAutoModelForXxx` cu un model de limbaj preantrenat (cum ar fi `bert-base-uncased`), care corespunde unei alte sarcini decât cea pentru care a fost antrenat?

<Question
	choices={[
		{
			text: "Nimic, dar primești un avertisment.",
			explain: "Primiți un avertisment, dar asta nu e tot!"
		},
		{
			text: "Head-ul modelului preantrenat este eliminat, iar în locul lui este inserat un head nou, potrivit pentru sarcină.",
			explain: "Corect. De exemplu, când am folosit <code>TFAutoModelForSequenceClassification</code> cu <code>bert-base-uncased</code>, am primit avertismente la instanțierea modelului. Head-ul preantrenat nu este folosit pentru sarcina de clasificare secvențială, așa că este eliminat și un nou head este instanțiat cu greutăți inițializate aleator.",
            correct: true
		},
		{
			text: "Head-ul modelului preantrenat este eliminat.",
			explain: "Mai trebuie să se întâmple și altceva. Încercați din nou!"
		},
        {
			text: "Nimic, pentru că modelul poate fi ajustat fin (fine-tuned) chiar și pentru o altă sarcină.",
			explain: "Head-ul preantrenat al modelului nu a fost antrenat pentru această sarcină, deci trebuie eliminat!"
		}
	]}
/>

### 5. Modelele TensorFlow din `transformers` sunt deja modele Keras. Ce avantaj oferă acest lucru?

<Question
	choices={[
		{
			text: "Modelele funcționează pe un TPU din start.",
			explain: "Ești pe aproape! Totuși, sunt necesare câteva modificări suplimentare. De exemplu, trebuie să rulați totul într-un context <code>TPUStrategy</code>, inclusiv inițializarea modelului."
		},
		{
			text: "Puteți valorifica metodele existente precum <code>compile()</code>, <code>fit()</code> și <code>predict()</code>.",
			explain: "Corect! Odată ce aveți datele, antrenarea necesită foarte puțin efort.",
            correct: true
		},
		{
			text: "Învățați atât Keras, cât și transformers.",
			explain: "Corect, dar căutăm altceva :)",
			correct: true
		},
        {
			text: "Puteți calcula cu ușurință metrici legate de dataset.",
			explain: "Keras ne ajută la antrenarea și evaluarea modelului, nu la calcularea metricilor legate de dataset."
		}
	]}
/>

### 6. Cum vă puteți defini propria metrică personalizată?

<Question
	choices={[
		{
			text: "Prin moștenirea <code>tf.keras.metrics.Metric</code>.",
			explain: "Perfect!",
			correct: true
		},
		{
			text: "Folosind API-ul funcțional Keras.",
			explain: "Mai încearcă!"
		},
		{
			text: "Folosind o funcție apelabilă cu semnătura <code>metric_fn(y_true, y_pred)</code>.",
			explain: "Corect!",
			correct: true
		},
        {
			text: "Căutând pe Google.",
			explain: "Nu este răspunsul pe care îl căutăm, dar probabil v-ar putea ajuta să-l găsiți.",
			correct: true
		}
	]}
/>

{/if}

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter3/6.mdx" />