# Quiz de final de capitol[[end-of-chapter-quiz]]

<CourseFloatingBanner
    chapter={5}
    classNames="absolute z-10 right-0 top-0"
/>

Acest capitol a acoperit o mulțime de subiecte! Nu vă faceți griji dacă nu ați înțeles toate detaliile; capitolele următoare vă vor ajuta să înțelegeți cum funcționează lucrurile mai aprofundat.

Înainte de a trece mai departe, totuși trebuie să testăm ce ați învățat în acest capitol.

### 1. Funcția `load_dataset()` din 🤗 Datasets vă permite să încărcați un dataset din care dintre următoarele locații?

<Question
    choices={[
        {
            text: "Local, de exemplu pe laptop",
            explain: "Corect! Puteți trece path-urile fișierelor locale ca argument al `data_files` al `load_dataset()` pentru a încărca dataseturi locale.",
            correct: true
        },
        {
            text: "Hugging Face Hub",
            explain: "Corect! Puteți încărca dataseturi de pe Hub furnizând ID-ul datasetului, de exemplu <code>load_dataset('emotion')</code>.",
            correct: true
        },
        {
            text: "Un server remote",
            explain: "Corect! Puteți trece URL-uri ca argument al `data_files` al `load_dataset()` pentru a încărca fișiere remote.",
            correct: true
        },
    ]}
/>

### 2. Presupunem că încărcați una dintre sarcinile GLUE astfel:

```py
from datasets import load_dataset

dataset = load_dataset("glue", "mrpc", split="train")
```

Care dintre următoarele comenzi va produce un exemplu aleatoriu de 50 de elemente din `dataset`?

<Question
    choices={[
        {
            text: "<code>dataset.sample(50)</code>",
            explain: "Acest lucru este incorect -- nu există o metodă `Dataset.sample()`."
        },
        {
            text: "<code>dataset.shuffle().select(range(50))</code>",
            explain: "Corect! Așa cum ați văzut în acest capitol, mai întâi faceți shuffle datasetului și apoi selectați exemplele din el.",
            correct: true
        },
        {
            text: "<code>dataset.select(range(50)).shuffle()</code>",
            explain: "Acest lucru este incorect -- deși codul va rula, va amesteca doar primele 50 de elemente din setul de date."
        }
    ]}
/>

### 3. Presupunem că aveți un set de date despre animale de companie numit `pets_dataset`, care are o coloană `name` care denotă numele fiecărui animal de companie. Care dintre următoarele abordări v-ar permite să filtrați setul de date pentru toate animalele de companie ale căror nume încep cu litera "L"?

<Question
    choices={[
        {
            text: "<code>pets_dataset.filter(lambda x : x['name'].startswith('L'))</code>",
            explain: "Corect! Utilizarea unei funcții lambda python pentru aceste filtre rapide este o idee grozavă. Vă puteți gândi și la o altă soluție?",
            correct: true
        },
        {
            text: "<code>pets_dataset.filter(lambda x['name'].startswith('L'))</code>",
            explain: "Acest lucru este incorect -- o funcție lambda are forma generală <code>lambda *arguments* : *expression*</code>, deci trebuie să furnizați argumente în acest caz."
        },
        {
            text: "Creați o funcție ca <code>def filter_names(x): return x['name'].startswith('L')</code> și rulați <code>pets_dataset.filter(filter_names)</code>.",
            explain: "Corect! La fel ca și cu <code>Dataset.map()</code>, puteți trece funcții explicite la <code>Dataset.filter()</code>. Acest lucru este util atunci când aveți o logică complexă care nu este potrivită pentru o funcție lambda. Care dintre celelalte soluții ar mai funcționa?",
            correct: true
        }
    ]}
/>

### 4. Ce este memory mapping?

<Question
    choices={[
        {
            text: "Mappingul între CPU și GPU RAM",
            explain: "Acest lucru nu este corect -- încearcă din nou!",
        },
        {
            text: "Mapping între RAM și stocarea sistemului de fișiere",
            explain: "Corect! 🤗 Datasets tratează fiecare dataset ca pe un fișier memory-mapped. Acest lucru permite bibliotecii să acceseze și să opereze pe elemente ale datasetului fără să fie nevoie să îl încarce complet în memorie.",
            correct: true
        },
        {
            text: "Mapping între două fișiere din cache-ul 🤗 Datasets",
            explain: "Acest lucru nu este corect -- încearcă din nou!"
        }
    ]}
/>

### 5. Care sunt principalele beneficii ale memory-mapping?

<Question
    choices={[
        {
            text: "Accesarea fișierelor memory-mapped este mai rapid decât citirea de pe disc sau scrierea pe disc.",
            explain: "Corect! Acest lucru permite 🤗 Datasets să fie extrem de rapid. Acesta însă nu este singurul beneficiu.",
            correct: true
        },
        {
            text: "Aplicațiile pot accesa segmente de date dintr-un fișier extrem de mare fără a fi necesar să citească întregul fișier în RAM mai întâi.",
            explain: "Corect! Acest lucru permite 🤗 Datasets să încarce dataseturi de câțiva gigabytes pe laptopul tău fără a fi nevoie să supraîncărcați CPU-ul. Ce alt avantaj oferă memory-mapping?",
            correct: true
        },
        {
            text: "Acesta consumă mai puțină energie, astfel încât bateria ta ține mai mult.",
            explain: "Acest lucru nu este corect -- încearcă din nou!"
        }
    ]}
/>

### 6. De ce codul următor eșuează?

```py
from datasets import load_dataset

dataset = load_dataset("allocine", streaming=True, split="train")
dataset[0]
```

<Question
    choices={[
        {
            text: "Încearcă să facă streaming unui dataset prea mare pentru a încăpea în RAM.",
            explain: "Acest lucru nu este corect -- streaming datasets sunt decomprimate pe loc, și puteți prelucra dataseturi de terabytes cu foarte puțin RAM!",
        },
        {
            text: "Încearcă să acceseze un <code>IterableDataset</code>.",
            explain: "Corect! Un <code>IterableDataset</code> este un generator, nu un container, deci ar trebui să accesați elementele sale utilizând <code>next(iter(dataset))</code>.",
            correct: true
        },
        {
            text: "Datasetul <code>allocine</code> nu are o un split <code>train</code>.",
            explain: "Acest lucru este incorect -- consultați cardul datasetului <code>allocine</code> de pe Hub pentru a vedea ce splituri conține."
        }
    ]}
/>

### 7. Care sunt principalele beneficii ale creării unui dataset card?

<Question
    choices={[
        {
            text: "Oferă informații despre utilizarea intenționată și sarcinile susținute ale datasetului, astfel încât ceilalți din comunitate să poată lua o decizie cu privire la utilizarea acestuia.",
            explain: "Corect! Dataseturile nedocumentate pot fi utilizate pentru a antrena modele care pot să nu reflecte intențiile creatorilor sau pot produce modele a căror statut juridic este incert dacă sunt antrenate pe date care încalcă confidențialitatea sau restricțiile de licențiere. Acesta nu este singurul beneficiu, totuși!",
            correct: true
        },
        {
            text: "Ajută la sublinierea biasurilor prezente într-un corpus.",
            explain: "Corect! Aproape toate dataseturile au o formă de bias, ceea ce poate produce consecințe negative. A fi conștient de ele ajută creatorii de modele să înțeleagă cum să abordeze biasurile indispensabile. Cu ce altceva vă pot ajuta dataset cardurile?",
            correct: true
        },
        {
            text: "Îmbunătățește șansele ca ceilalți din comunitate să utilizeze datasetul meu.",
            explain: "Corect! Un dataset card bine scris va avea tendința de a duce la o utilizare mai mare a prețiosului tău dataset. Ce beneficiu mai oferă?",
            correct: true
        },
    ]}
/>

### 8. Ce este căutarea semantică?

<Question
    choices={[
        {
            text: "Un mod de a căuta pentru a găsi potriviri exacte între cuvintele dintr-un query și documentele dintr-un corpus",
            explain: "Acest lucru este incorect -- acest tip de căutare se numește *căutare lexicală*, și este ceea ce vedeți de obicei cu motoarele de căutare tradiționale."
        },
        {
            text: "Un mod de a căuta documente care se potrivesc prin înțelegerea sensului contextual al unui query",
            explain: "Corect! Căutarea semantică utilizează embedding vectors pentru a reprezenta queries și documente și utilizează o metrică de similaritate pentru a măsura cantitatea de suprapunere între ele. Cum altfel ați putea descrie-o?",
            correct: true
        },
        {
            text: "Un mod de a îmbunătăți acuratețea căutării",
            explain: "Corect! Motoarele de căutare semantice pot captura intenția unui query mult mai bine decât potrivirea de cuvinte cheie și de obicei preia documente cu o precizie mai mare. Dar acesta nu este singurul răspuns corect -- ce alt beneficiu oferă căutarea semantică?",
            correct: true
        }
    ]}
/>

### 9. Pentru căutarea semantică asimetrică, de obicei aveți:

<Question
    choices={[
        {
            text: "Un query scurt și un paragraf mai lung care răspunde la query",
            explain: "Corect!",
            correct: true
        },
        {
            text: "Queries și paragrafe care sunt de aproximativ aceeași lungime",
            explain: "Acest lucru este de fapt un exemplu de căutare semantică simetrică -- încercați din nou!"
        },
        {
            text: "Un query lung și un paragraf mai scurt care răspunde la query",
            explain: "Acest lucru este incorect -- încercați din nou!"
        }
    ]}
/>

### 10. Pot utiliza 🤗 Datasets pentru a încărca date pentru utilizare în alte domenii, cum ar fi speech processing?

<Question
    choices={[
        {
            text: "Nu",
            explain: "Acest lucru este incorect -- 🤗 Datasets acceptă în prezent date tabulare, audio și imagini. Consultați datasetul <a href='https://huggingface.co/datasets/mnist'>MNIST</a> de pe Hub pentru a vedea un exemplu de computer vision."
        },
        {
            text: "Da",
            explain: "Corect! Consultați dezvoltările interesante cu privire la speech și vision în biblioteca 🤗 Transformers pentru a vedea cum 🤗 Datasets este utilizat în aceste domenii.",
            correct: true
        },
    ]}
/>

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter5/8.mdx" />