# Quiz de sfârșit de capitol[[quiz-de-sfarsit-de-capitol]]

<CourseFloatingBanner
    chapter={8}
    classNames="absolute z-10 right-0 top-0"
/>

Să testăm ce ați învățat în acest capitol!

### 1. În ce ordine ar trebui să citiți un traceback Python?

<Question
	choices={[
		{
			text: "De sus în jos",
			explain: "Încercați din nou -- deși majoritatea celorlalte limbaje de programare afișează excepția în partea de sus, Python este special în această privință."
		},
		{
			text: "De jos în sus",
			explain: "Corect! Un avantaj al traceback-urilor Python care arată excepția în partea de jos este că este mai ușor de depanat când lucrați în terminal și aceasta este ultima linie pe care o vedeți.",
			correct: true
		}
	]}
/>

### 2. Ce este un exemplu minimal reproductibil?

<Question
	choices={[
		{
			text: "O implementare simplă a unei arhitecturi Transformer dintr-un articol de cercetare",
			explain: "Deși este foarte educativ să implementați propriile modele Transformer de la zero, nu despre asta vorbim aici."
		},
		{
			text: "Un bloc de cod compact și autonom care poate fi rulat fără nicio dependență externă de fișiere sau date private",
			explain: "Corect! Exemplele minimale reproductibile îi ajută pe întreținătorii bibliotecii să reproducă problema pe care o aveți, astfel încât să poată găsi soluții mai rapid.",
			correct: true
		},
		{
			text: "O captură de ecran a traceback-ului Python",
			explain: "Încercați din nou -- deși este tentant să includeți o captură de ecran a erorii cu care vă confruntați când depuneți o problemă, aceasta face foarte dificil pentru alții să reproducă eroarea."
		},
		{
			text: "Un notebook care conține întreaga analiză, inclusiv părți care nu sunt legate de eroare",
			explain: "Nu chiar -- deși poate fi util să partajați un notebook Google Colab care arată eroarea, asigurați-vă că este scurt și conține doar codul relevant."
		}
	]}
/>

### 3. Să presupunem că încercați să rulați următorul cod, care aruncă o eroare:

```py
from transformers import GPT3ForSequenceClassification

# ImportError: cannot import name 'GPT3ForSequenceClassification' from 'transformers' (/Users/lewtun/miniconda3/envs/huggingface/lib/python3.8/site-packages/transformers/__init__.py)
# ---------------------------------------------------------------------------
# ImportError                               Traceback (most recent call last)
# /var/folders/28/k4cy5q7s2hs92xq7_h89_vgm0000gn/T/ipykernel_30848/333858878.py in <module>
# ----> 1 from transformers import GPT3ForSequenceClassification

# ImportError: cannot import name 'GPT3ForSequenceClassification' from 'transformers' (/Users/lewtun/miniconda3/envs/huggingface/lib/python3.8/site-packages/transformers/__init__.py)
```

Care dintre următoarele ar putea fi o alegere bună pentru titlul unui subiect pe forum pentru a cere ajutor?

<Question
	choices={[
		{
			text: "<code>ImportError: cannot import name 'GPT3ForSequenceClassification' from 'transformers' (/Users/lewtun/miniconda3/envs/huggingface/lib/python3.8/site-packages/transformers/__init__.py)</code>",
			explain: "Includerea ultimei linii a traceback-ului poate fi descriptivă, dar aceasta este mai bine rezervată pentru corpul principal al subiectului. Încercați din nou!"
		},
		{
			text: "Problemă cu <code>from transformers import GPT3ForSequenceClassification</code>",
			explain: "Încercați din nou -- deși aceasta oferă informații utile, probabil este cel mai bine rezervată pentru corpul principal al textului.",
		},
		{
			text: "De ce nu pot importa <code>GPT3ForSequenceClassification</code>?",
			explain: "Alegere bună! Acest titlu este concis și îi dă cititorului un indiciu despre ce ar putea fi greșit (adică că GPT-3 nu este suportat în 🤗 Transformers).",
			correct: true
		},
		{
			text: "Este GPT-3 suportat în 🤗 Transformers?",
			explain: "Bună alegere! Folosirea întrebărilor ca titluri de subiecte este o modalitate excelentă de a comunica problema comunității.",
			correct: true
		}
	]}
/>

### 4. Să presupunem că ați încercat să rulați `trainer.train()` și vă confruntați cu o eroare criptică care nu vă spune exact de unde vine eroarea. Care dintre următoarele este primul loc unde ar trebui să căutați erori în pipeline-ul vostru de antrenament?

<Question
	choices={[
		{
			text: "Pasul de optimizare unde calculăm gradienții și efectuăm backpropagation",
			explain: "Deși pot exista bug-uri în optimizatorul vostru, acesta este de obicei la mai mulți pași în pipeline-ul de antrenament, așa că există alte lucruri de verificat mai întâi. Încercați din nou!"
		},
		{
			text: "Pasul de evaluare unde calculăm metricile",
			explain: "Evaluarea este de obicei ceea ce faceți după antrenament pentru o epocă completă, așa că ar trebui să verificați mai întâi undeva mai devreme în pipeline-ul de antrenament."
		},
		{
			text: "Seturile de date",
			explain: "Corect! Privirea la datele voastre este aproape întotdeauna primul lucru pe care ar trebui să îl faceți, pentru a vă asigura că textul este codificat corespunzător, are caracteristicile așteptate, și așa mai departe.",
			correct: true
		},
		{
			text: "Dataloader-ele",
			explain: "Încercați din nou -- aceasta este foarte aproape de primul lucru pe care ar trebui să îl verificați. Vă amintiți ce obiect transmitem la dataloader-e?"
		}
	]}
/>

### 5. Care este cea mai bună modalitate de a depana o eroare CUDA?

<Question
	choices={[
		{
			text: "Postați mesajul de eroare pe forumuri sau GitHub.",
			explain: "Asta nu va ajuta pe nimeni deoarece mesajele de eroare CUDA sunt de obicei foarte neinformative."
		},
		{
			text: "Executați același cod pe CPU.",
			explain: "Exact, asta ar trebui să vă dea un mesaj de eroare mai bun!",
			correct: true
		},
		{
			text: "Citiți traceback-ul pentru a afla ce a cauzat eroarea.",
			explain: "Asta este ceea ce ați face pentru orice altă eroare, dar erorile CUDA nu sunt de obicei ridicate unde s-au întâmplat deoarece majoritatea operațiilor CUDA sunt asincrone."
		},
		{
			text: "Reduceți dimensiunea batch-ului.",
			explain: "Reducerea dimensiunii batch-ului este de obicei o strategie bună pentru gestionarea erorilor CUDA out-of-memory, dar nu pentru această problemă particulară. Încercați din nou!"
		},
		{
			text: "Reporniți kernel-ul Jupyter.",
			explain: "Încercați din nou -- repornirea kernel-ului nu va face eroarea să dispară prin magie!",
		}
	]}
/>

### 6. Care este cea mai bună modalitate de a face ca o problemă pe GitHub să fie reparată?

<Question
	choices={[
		{
			text: "Postați un exemplu complet reproductibil al bug-ului.",
			explain: "Da, aceasta este cea mai bună modalitate de a îi ajuta pe întreținători să găsească bug-ul vostru. Ce altceva ar trebui să faceți?",
			correct: true
		},
		{
			text: "Cereți în fiecare zi o actualizare.",
			explain: "Este puțin probabil să vă aducă ajutor; oamenii probabil vă vor ignora mai mult.",
		},
		{
			text: "Inspectați codul sursă din jurul bug-ului și încercați să găsiți motivul pentru care se întâmplă. Postați rezultatele în problemă.",
			explain: "Asta îi va ajuta cu siguranță pe întreținători! Și dacă găsiți sursa bug-ului și o reparație, puteți chiar deschide un pull request. Ce altceva ar trebui să faceți?",
			correct: true
		}
	]}
/>

### 7. De ce este supraajustarea pe un batch de obicei o tehnică bună de depanare?

<Question
	choices={[
		{
			text: "Nu este; supraajustarea este întotdeauna rea și ar trebui evitată.",
			explain: "Când antrenați pe întregul set de date, supraajustarea poate într-adevăr fi un semn că modelul vostru nu se va generaliza bine la exemple noi. Pentru depanare, totuși, nu antrenăm de obicei pe întregul set de date. Încercați din nou!"
		},
		{
			text: "Ne permite să verificăm că modelul este capabil să reducă loss-ul la zero.",
			explain: "Corect! Cu un batch mic cu doar două exemple, putem verifica rapid dacă modelul este capabil să învețe.",
			correct: true
		},
		{
			text: "Ne permite să verificăm că formele tensorilor intrărilor și etichetelor noastre sunt corecte.",
			explain: "Încercați din nou -- dacă formele tensorilor voștri sunt dezalinate, atunci cu siguranță nu veți putea antrena, nici măcar pe un singur batch.",
		}
	]}
/>

### 8. De ce este o idee bună să includeți detalii despre mediul vostru de calcul cu `transformers-cli env` când creați o problemă nouă în repository-ul 🤗 Transformers?

<Question
	choices={[
		{
			text: "Le permite întreținătorilor să înțeleagă ce versiune a bibliotecii folosiți.",
			explain: "Corect! Deoarece fiecare versiune majoră a bibliotecii poate avea modificări în API, știind ce versiune specifică folosiți poate ajuta la restrângerea problemei. Care sunt celelalte beneficii?",
			correct: true
		},
		{
			text: "Le permite întreținătorilor să știe dacă rulați cod pe Windows, macOS sau Linux.",
			explain: "Corect! Erorile pot fi uneori cauzate de sistemul de operare specific pe care îl folosiți, și știind acest lucru îi ajută pe întreținători să le reproducă local. Dar aceasta nu este singura cauză.",
			correct: true
		},
		{
			text: "Le permite întreținătorilor să știe dacă rulați cod pe un GPU sau CPU.",
			explain: "Corect! Așa cum am văzut în acest capitol, codul rulat pe GPU-uri sau CPU-uri poate produce rezultate sau erori diferite, și știind ce hardware folosiți poate ajuta la concentrarea atenției întreținătorilor. Dar aceasta nu este singurul beneficiu...",
			correct: true
		}
	]}
/> 

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter8/7.mdx" />