# Тест в конце главы[[end-of-chapter-quiz]]

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

В этой главе было много материала! Если вы чувствуете, что все еще всецело не познали все премудрости трансформеров - не переживайте! В следующих главах мы детально расскажем, как все устроено "под капотом".

Сперва, однако, давайте проверим, что вы узнали в этой главе!


### 1. Зайдите на Hub и найдите чекпоинт модели `roberta-large-mnli`. Какую задачу она решает?


<Question
	choices={[
		{
			text: "Автоматическое реферирование (саммаризация)",
			explain: "Посмотрите получше на <a href=\"https://huggingface.co/roberta-large-mnli\">странице roberta-large-mnli</a>."
		},
		{
			text: "Классификация текстов",
			explain: "В частности, модель определяет, являются ли два предложения логически связанными и присваивает одну из трех меток: противопоставление, нейтральная связь, импликация (англ. contradiction, neutral, entailment). Эта задача называется <em>автоматическое определение логической связи между текстами (англ. natural language inference)</em>.",
			correct: true
		},
		{
			text: "Генерация текста",
			explain: "Посмотрите получше на <a href=\"https://huggingface.co/roberta-large-mnli\">странице roberta-large-mnli</a>."
		}
	]}
/>

### 2. Какой будет результат выполнения данного кода?

```py
from transformers import pipeline

ner = pipeline("ner", grouped_entities=True)
ner("My name is Sylvain and I work at Hugging Face in Brooklyn.")
```

<Question
	choices={[
		{
			text: "Пайплайн вернет следующие метки классов для этого предложения: \"positive\" или \"negative\".",
			explain: "Неверно — для этого используется пайплайн <code>sentiment-analysis</code>."
		},
		{
			text: "Пайплайн вернет текст, сгенерированный на основе данного предложения.",
			explain: "Неверно — для этого используется пайплайн <code>text-generation</code>.",
		},
		{
			text: "Пайплайн вернет слова, обозначающие персон, организаций или географических локаций.",
			explain: "Кроме того, с аргументом <code>grouped_entities=True</code>, пайплайн сгруппирует слова, принадлежащие одной и той же сущности, например, \"Hugging Face\".",
			correct: true
		}
	]}
/>

### 3. Чем нужно заменить ... в данном коде?

```py
from transformers import pipeline

filler = pipeline("fill-mask", model="bert-base-cased")
result = filler("...")
```

<Question
	choices={[
		{
			text: "This &#60;mask> has been waiting for you.",
			explain: "Неверно. Прочитайте карточку модели <code>bert-base-cased</code> и попробуйте найти, где вы ошиблись."
		},
		{
			text: "This [MASK] has been waiting for you.",
			explain: "Верно! Токен-маска для этой модели - [MASK].",
			correct: true
		},
		{
			text: "This man has been waiting for you.",
			explain: "Неверно. Этот пайплайн предсказывает замаскированный токен, а для этого нужно предоставить токен-маску."
		}
	]}
/>

### 4. Почему этот код выдаст ошибку?

```py
from transformers import pipeline

classifier = pipeline("zero-shot-classification")
result = classifier("This is a course about the Transformers library")
```

<Question
	choices={[
		{
			text: "Этому пайплайну требуются метки классов.",
			explain: "Верно — правильный код должен содержать аргумент <code>candidate_labels=[...]</code>.",
			correct: true
		},
		{
			text: "Этому пайплайну требуются несколько предложений, а не одно.",
			explain: "Неверно. Хотя, если использовать этот пайплайн правильно, он может принимать на вход массив предложений (как и все остальные пайплайны)."
		},
		{
			text: "Опять библиотека 🤗 Transformers не работает как положено.",
			explain: "Мы даже не будем комментировать этот ответ!"
		},
		{
			text: "Этому пайплайну требуются более длинные предложения - это слишком короткое.",
			explain: "Неверно. Однако, стоит отметить, что этот пайплайн обрежет очень длинный текст, для того, чтобы его корректно обработать."
		}
	]}
/>

### 5. Что такое «трансферное обучение»?

<Question
	choices={[
		{
			text: "Передача знаний от предобученной модели к новой модели путем ее обучения на тех же данных.",
			explain: "Нет - результатом этого будут две версии той же самой модели."
		},
		{
			text: "Передача знаний от предобученной модели к новой модели путем инициализирования новой модели с весами предобученной.",
			explain: "Верно - когда новая модель будет обучена на новой задаче, она <em>получит</em> знания предобученной модели. Другими словами, предобученная модель <em>передаст</em> свои знания новой.",
			correct: true
		},
		{
			text: "Передача знаний от предобученной модели к новой модели путем проектирования новой модели с той же самой архитектурой, что и у предобученной.",
			explain: "Архитектура - это лишь «скелет» модели; в этом случае никой передачи знаний не происходит."
		}
	]}
/>

### 6. Правда или ложь? Для предобучения языковой модели обычно не требуются метки классов.

<Question
	choices={[
		{
			text: "Правда",
			explain: "Предобучение обычно <em>самостоятельно (англ. self-supervised)</em>. Это означает, что метки классов создаются автоматически на основе входных данных (например, предсказание следующего или замаскированного слова).",
			correct: true
		},
		{
			text: "Ложь",
			explain: "Это неверный ответ."
		}
	]}
/>

### 7. Выберите предложение, которое наилучшим способом описывает следующие термины: «модель», «архитектура» и «веса».

<Question
	choices={[
		{
			text: "Модель - это здание, ее архитектура - чертеж, а веса - люди, которые там живут.",
			explain: "Чтобы это сравнение было верным, веса должны быть кирпичами и другими материалами из которых построено здание."
		},
		{
			text: "Архитектура - это карта, по которой можно построить модель, а веса - это города на этой карте.",
			explain: "Проблема этого сравнения в том, что карта обычно отображает одну существующую реальность (во Франции только один город под названием Париж). В то время как одна и та же архитектура может быть заполнена разными наборами весов."
		},
		{
			text: "Архитектура - это последовательность математических функций для создания модели, а веса - параметры этих функций.",
			explain: "Один и тот же набор математических функций (архитектура) можно использовать для построения разных моделей, используя разные параметры (веса).",
			correct: true
		}
	]}
/>


### 8. Какую из этих моделей вы выберете для дополнения текста по введенной его части?

<Question
	choices={[
		{
			text: "Кодировщик",
			explain: "Кодировщик генерирует векторное представление всего предложения, что больше подходит для таких задач как классификация."
		},
		{
			text: "Декодировщик",
			explain: "Декодировщик идеально подходит для дополнения текста по введенной его части.",
			correct: true
		},
		{
			text: "Кодировщик-декодировщик",
			explain: "Модели sequence-to-sequence больше подходят для задач, в которых вам нужно сгенерировать предложения, основываясь на входных предложениях целиком, а не на части текста, которую нужно продолжить."
		}
	]}
/>

### 9. Какую из этих моделей вы выберете для автоматического реферирования?

<Question
	choices={[
		{
			text: "Кодировщик",
			explain: "Кодировщик генерирует векторное представление всего предложения, что больше подходит для таких задач как классификация."
		},
		{
			text: "Декодировщик",
			explain: "Декодировщих хорошо продходит для генерации текста (например, рефератов), но он не способен брать во внимание контекст (например, документ целиком) для реферирования."
		},
		{
			text: "Кодировщик-декодировщик",
			explain: "Кодировщик-декодировщик идеально подходит для задачи автоматического реферирования.",
			correct: true
		}
	]}
/>

### 10. Какую из этих моделей вы выберете для классификации текстов путем присвоения им определенных меток?

<Question
	choices={[
		{
			text: "Кодировщик",
			explain: "Кодировщик генерирует векторное представление всего предложения, что идеально подходит для такой задачи, как классификация.",
			correct: true
		},
		{
			text: "Декодировщик",
			explain: "Декодировщих хорошо подходит для генерации текста, а не для присвоения метки документу."
		},
		{
			text: "Кодировщик-декодировщик",
			explain: "Модели sequence-to-sequence больше подходят для задач, в которых вам нужно сгенерировать предложения, основываясь на входных предложениях целиком, а не для присвоения метки документу.",
		}
	]}
/>

### 11. Что может быть одной из причин предвзятости модели?

<Question
	choices={[
		{
			text: "Модель была дообучена на основе предобученной модели, которая содержала в себе предвзятость.",
			explain: "Используя трансферное обучение, предвзятость предобученной модели также передастся новой модели.",
			correct: true
		},
		{
			text: "В обучающей выборке были тексты предвзятого содержания.",
			explain: "Это самый очевидный источник предвзятости, но далеко не единственный.",
			correct: true
		},
		{
			text: "Метрика, выбранная для оптимизации модели, была склонна к предвзятости.",
			explain: "Менее очевидный источник предвзятости кроется в организации ее обучения. Модель будет слепо следовать выбранной метрике, так как она неспособна «задуматься» о ее корректности.",
			correct: true
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ru/chapter1/10.mdx" />