# Тест в конце главы[[end-of-chapter-quiz]]

<CourseFloatingBanner
    chapter={6}
    classNames="absolute z-10 right-0 top-0"
/>

Давайте проверим, чему вы научились в этой главе!

### 1. Когда следует обучать новый токенизатор?

<Question
	choices={[
		{
			text: "Если ваш набор данных похож на тот, который используется существующей предварительно обученной моделью, и вы хотите провести предварительное обучение новой модели.",
			explain: "В этом случае, чтобы сэкономить время и вычислительные ресурсы, лучше использовать тот же токенизатор, что и в предварительно обученной модели, и дообучить эту модель."
		},
		{
			text: "Когда ваш набор данных похож на тот, который используется существующей предварительно обученной моделью, и вы хотите дообучить новую модель, используя эту предварительно обученную модель.",
			explain: "Чтобы дообучить модель на основе предварительно обученной модели, всегда следует использовать один и тот же токенизатор."
		},
		{
			text: "Когда ваш набор данных отличается от того, который используется существующей предварительно обученной моделью, и вы хотите провести предварительное обучение новой модели.",
			explain: "Правильно! В этом случае нет никакого преимущества в использовании одного и того же токенизатора.",
            correct: true
		},
        {
			text: "Когда ваш набор данных отличается от того, который используется существующей предварительно обученной моделью, но вы хотите дообучить новую модель с помощью имеющейся предварительно обученной модели.",
			explain: "Чтобы дообучить модель на основе предварительно обученной модели, всегда следует использовать один и тот же токенизатор."
		}
	]}
/>

### 2. В чем преимущество использования генератора списков текстов по сравнению со списком списков текстов при использовании `train_new_from_iterator()`?

<Question
	choices={[
		{
			text: "Это единственный тип, который принимает метод <code>train_new_from_iterator()</code>.",
			explain: "Список списков текстов - это особый вид генератора списков текстов, поэтому метод примет и его. Попробуйте еще раз!"
		},
		{
			text: "Это позволит избежать загрузки в память сразу всего набора данных.",
			explain: "Точно! Каждый батч текстов будет освобождаться из памяти при итерации, и выигрыш будет особенно заметен, если вы используете библиотеку 🤗 Datasets для хранения текстов.",
			correct: true
		},
		{
			text: "Это позволит библиотеке 🤗 Tokenizers использовать многопроцессорность (multiprocessing).",
			explain: "Нет, она будет использовать многопроцессорность в любом случае."
		},
        {
			text: "Обученный вами токенизатор будет генерировать более качественные тексты.",
			explain: "Токенизатор не генерирует текст - вы не путаете его с языковой моделью?"
		}
	]}
/>

### 3. Каковы преимущества использования "быстрого" токенизатора?

<Question
	choices={[
		{
			text: "Он может обрабатывать входные данные быстрее, чем медленный токенизатор, когда вы обьединяете в батч много входных данных.",
			explain: "Правильно! Благодаря параллелизму, реализованному в Rust, он будет быстрее работать с батчами входных данных. Какие еще преимущества вы можете назвать?",
			correct: true
		},
		{
			text: "Быстрые токенизаторы всегда выполняют токенизацию быстрее, чем их медленные аналоги.",
			explain: "Быстрый токенизатор может работать медленнее, если вы передаете ему только один или очень мало текстов, поскольку он не может использовать параллелизм."
		},
		{
			text: "Он может применять дополнение (padding) и усечение (truncation).",
			explain: "Верно, но медленные токенизаторы тоже могут это делать."
		},
        	{
			text: "Он обладает некоторыми дополнительными функциями, позволяющими сопоставлять токены с фрагментами текста, которые их сформировали.",
			explain: "Действительно, это так называемые смещенные отображения (offset mappings). Однако это не единственное преимущество.",
			correct: true
		}
	]}
/>

### 4. Как конвейер `token-classification` обрабатывает сущности, которые охватывают несколько токенов?

<Question
	choices={[
		{
			text: "Сущности с одинаковыми метками объединяются в одну сущность.",
			explain: "Это слишком простое объяснение. Попробуйте еще раз!"
		},
		{
			text: "Есть метка начала сущности и метка продолжения сущности.",
			explain: "Правильно!",
			correct: true
		},
		{
			text: "Если в заданном слове первый токен имеет метку сущности, то все слово считается помеченным этой сущностью.",
			explain: "Это одна из стратегий работы с сущностями. Какие еще ответы здесь применимы?",
			correct: true
		},
        	{
			text: "Когда токен имеет метку данной сущности, любой другой следующий токен с такой же меткой считается частью той же сущности, если только он не помечен как начало новой сущности.",
			explain: "Это самый распространенный способ группировки сущностей - однако это не единственный правильный ответ.",
			correct: true
		}
	]}
/>

### 5. Как конвейер `question-answering` обрабатывает длинные контексты?

<Question
	choices={[
		{
			text: "На самом деле это не так, поскольку он обрезает длинный контекст по максимальной длине, принятой моделью.",
			explain: "Есть один прием, который можно использовать для работы с длинными контекстами. Вы помните, в чем он заключается?"
		},
		{
			text: "Он разбивает контекст на несколько частей и усредняет полученные результаты.",
			explain: "Нет, усреднять результаты не имеет смысла, поскольку некоторые части контекста не будут содержать ответ."
		},
		{
			text: "Он разбивает контекст на несколько частей (с перекрытием) и находит максимальную оценку для ответа в каждой части.",
			explain: "Это правильный ответ!",
			correct: true
		},
        	{
			text: "Он разбивает контекст на несколько частей (без перекрытия, для эффективности) и находит максимальную оценку для ответа в каждой части.",
			explain: "Нет, он включает в себя некоторое перекрытие частей, чтобы избежать ситуации, когда ответ будет разбит на две части."
		}
	]}
/>

### 6. Что такое нормализация?

<Question
	choices={[
		{
			text: "Это любая очистка текста, которую выполняет токенизатор на начальных этапах работы с текстами.",
			explain: "Верно - например, это может быть удаление подчеркиваний или пробелов, или перевод в нижний регистр входных данных.",
			correct: true
		},
		{
			text: "Это техника дополнения данных, которая позволяет сделать текст более нормальным за счет удаления редких слов.",
			explain: "Это неправильно! Попробуйте еще раз."
		},
		{
			text: "Это последний этап постобработки, на котором токенизатор добавляет специальные токены.",
			explain: "Этот этап называется просто постобработкой."
		},
        	{
			text: "Это когда эмбеддинги создаются со среднеквадратичным отклонением 0 и стандартным отклонением 1, путем вычитания среднеквадратичного и деления на стандартное отклонение.",
			explain: "Этот процесс обычно называется нормализацией, когда применяется к значениям пикселей в компьютерном зрении, но это не то, что означает нормализация в NLP."
		}
	]}
/>

### 7. Что такое предварительная токенизация для токенизатора по подсловам?

<Question
	choices={[
		{
			text: "Это шаг перед токенизацией, на котором применяется аугментация данных (например, случайное маскирование).",
			explain: "Нет, этот шаг является частью предварительной обработки."
		},
		{
			text: "Это этап перед токенизацией, на котором к тексту применяются необходимые операции по очистке.",
			explain: "Нет, это этап нормализации."
		},
		{
			text: "Это шаг, предшествующий применению модели токенизатора для разбиения входных данных на слова.",
			explain: "Это правильный ответ!",
			correct: true
		},
        	{
			text: "Это шаг, предшествующий применению модели токенизатора для разделения входных данных на токены.",
			explain: "Нет, разбиение на части - это задача модели токенизатора."
		}
	]}
/>

### 8. Выберите предложения, которые относятся к модели токенизации BPE.

<Question
	choices={[
		{
			text: "BPE - это алгоритм токенизации подслов, который начинает работу с небольшим словарем и изучает правила слияния.",
			explain: "Это действительно так!",
			correct: true
		},
		{
			text: "BPE - это алгоритм токенизации подслов, который начинает с большого словаря и постепенно удаляет из него токены.",
			explain: "Нет, такой подход используется другим алгоритмом токенизации."
		},
		{
			text: "Токенизаторы BPE изучают правила слияния, объединяя пары токенов, которые встречаются чаще всего.",
			explain: "Правильно!",
			correct: true
		},
		{
			text: "Токенизатор BPE изучает правило слияния, объединяя пары токенов, которые максимизируют оценку, которая отдает предпочтение частым парам с менее частыми отдельными частями.",
			explain: "Нет, это стратегия, применяемая другим алгоритмом токенизации."
		},
		{
			text: "BPE токенизирует слова на подслова, разбивая их на символы, после чего применяет правила слияния.",
			explain: "Правильно!",
			correct: true
		},
		{
			text: "BPE токенизирует слова в подслова, находя самое длинное подслово, которое есть в словаре, начиная с начала, а затем повторяя процесс для остальной части текста.",
			explain: "Нет, это способ работы другого алгоритма токенизации."
		}
	]}
/>

### 9. Выберите предложения, которые относятся к модели токенизации WordPiece.

<Question
	choices={[
		{
			text: "WordPiece - это алгоритм токенизации по подсловам, который начинает работу с небольшим словарным запасом и учит правила слияния.",
			explain: "Это действительно так!",
			correct: true
		},
		{
			text: "WordPiece - это алгоритм токенизации по подсловам, который начинает с большого словаря и постепенно удаляет из него токены.",
			explain: "Нет, такой подход используется другим алгоритмом токенизации."
		},
		{
			text: "Токенизаторы WordPiece учат правила слияния, объединяя пары токенов, которые встречаются чаще всего.",
			explain: "Нет, это стратегия, применяемая другим алгоритмом токенизации."
		},
		{
			text: "Токенизатор WordPiece изучает правило слияния, объединяя пары токенов, которые максимизируют оценку, отдающую предпочтение частым парам с менее частыми отдельными частями.",
			explain: "Правильно!",
			correct: true
		},
		{
			text: "WordPiece выполняет токенизацию слов на подслова, находя наиболее вероятную сегментацию на токены в соответствии с моделью.",
			explain: "Нет, так работает другой алгоритм токенизации."
		},
		{
			text: "WordPiece токенизирует слова на подслова, находя самое длинное подслово, которое есть в словаре, начиная с начала, а затем повторяя процесс для остальной части текста.",
			explain: "Да, именно так работает WordPiece в процессе кодирования.",
			correct: true
		}
	]}
/>

### 10. Выберите предложения, которые относятся к модели токенизации Unigram.

<Question
	choices={[
		{
			text: "Unigram - это алгоритм токенизации на подслова, который начинает с небольшого словаря и учится правилам слияния.",
			explain: "Нет, это подход, используемый другим алгоритмом токенизации."
		},
		{
			text: "Unigram - это алгоритм токенизации подслова, который начинает с большого словарного запаса и постепенно удаляет из него токены.",
			explain: "Правильно!",
			correct: true
		},
		{
			text: "Unigram адаптирует свой словарь, минимизируя потери, вычисляемые по всему корпусу текста.",
			explain: "Верно!",
			correct: true
		},
		{
			text: "Unigram адаптирует свой словарь, сохраняя наиболее часто встречающиеся подслова.",
			explain: "Нет, это неверно."
		},
		{
			text: "Unigram осуществляет токенизацию слов на подслова, находя наиболее вероятную сегментацию на токены в соответствии с моделью.",
			explain: "Правильно!",
			correct: true
		},
		{
			text: "Unigram токенизирует слова на подслова, разбивая их на символы, а затем применяя правила слияния.",
			explain: "Нет, так работает другой алгоритм токенизации."
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ru/chapter6/10.mdx" />