# పరిచయం [[introduction]]  

హగ్గింగ్ ఫేస్  కోర్సుకు స్వాగతం! ఈ అధ్యాయం మీ వర్కింగ్ ఎన్విరాన్‌మెంట్‌ను సెట్ చేయడంలో సహాయపడుతుంది. మీరు కోర్సును ఇప్పుడే ప్రారంభిస్తుంటే, ముందుగా [అధ్యాయం 1](/course/chapter1) చూడాలని సూచిస్తున్నాం, తర్వాత మీ ఎన్విరాన్‌మెంట్‌ను సెట్ చేసుకుని కోడ్‌ను ప్రయత్నించండి.  

ఈ కోర్సులో ఉపయోగించే లైబ్రరీలు Python ప్యాకేజీలుగా అందుబాటులో ఉన్నాయి. అందువల్ల Python ఎన్విరాన్‌మెంట్ సెట్ చేసుకోవడం మరియు అవసరమైన లైబ్రరీలను ఇన్‌స్టాల్ చేసుకోవడం ఎలా అనేది ఇక్కడ చూడబోతున్నాం.  

మీరు **Google Colab నోట్‌బుక్** లేదా **Python వర్చువల్ ఎన్విరాన్‌మెంట్** ద్వారా సెటప్ చేసుకోవచ్చు. కొత్తవారికి Colab నోట్‌బుక్ ఉపయోగించడం సులభం, అందుకే మేము దానిని సిఫార్సు చేస్తున్నాం.  

**Windows వినియోగదారులకు గమనిక:** ఈ కోర్సులో Windows సెటప్‌ను వివరించం. కాబట్టి మీరు Windows ఉపయోగిస్తుంటే, Colab నోట్‌బుక్‌ను ఉపయోగించడం ఉత్తమ ఎంపిక అవుతుంది. **Linux లేదా macOS** వాడుతున్నవారు ఇక్కడ చెప్పిన రెండు పద్ధతులలో ఏదైనా ఎంచుకోవచ్చు.  

ఈ కోర్సును పూర్తిగా అనుభవించాలంటే **Hugging Face అకౌంట్** అవసరం. కాబట్టి ఇప్పుడే ఓ ఖాతా తెరిచేయండి: [అకౌంట్ క్రియేట్ చేయండి](https://huggingface.co/join).  


## Google Colab నోట్‌బుక్ ఉపయోగించడం [[using-a-google-colab-notebook]]  

Google Colab నోట్‌బుక్ ఉపయోగించడం చాలా సులభం – వెబ్ బ్రౌజర్‌లో ఓపెన్ చేసి నేరుగా కోడింగ్ ప్రారంభించేయొచ్చు!  

మీరు **Colab గురించి కొత్తగా నేర్చుకుంటున్నట్లయితే**, ఈ [పరిచయం](https://colab.research.google.com/notebooks/intro.ipynb) చదవండి. Colab ద్వారా మీరు **GPU లేదా TPU** వంటి వేగవంతమైన హార్డ్వేర్‌ను ఉపయోగించుకోవచ్చు.  

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/new_colab.png" alt="An empty colab notebook" width="80%"/>
</div>
కొత్త నోట్‌బుక్ క్రియేట్ చేసి, ఈ క్రింది ఆదేశాలతో లైబ్రరీలను ఇన్‌స్టాల్ చేయండి:  

```
!pip install transformers
```

సరైనగా ఇన్‌స్టాల్ అయిందో లేదో పరీక్షించేందుకు:  

```
import transformers
```
<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/install.gif" alt="A gif showing the result of the two commands above: installation and import" width="80%"/>
</div>
ఇది ప్రాథమిక వెర్షన్ మాత్రమే. మేము అన్ని ఫీచర్లు ఉపయోగించేందుకు డెవలప్‌మెంట్ వెర్షన్ ఇన్‌స్టాల్ చేయాలని సూచిస్తున్నాం:  

```
!pip install transformers[sentencepiece]
```

ఇప్పుడు మీరు కోర్సును కొనసాగించడానికి సిద్ధంగా ఉన్నారు! 🤗  

 

## Python వర్చువల్ ఎన్విరాన్‌మెంట్ ఉపయోగించడం [[using-a-python-virtual-environment]]  

మీరు Python వర్చువల్ ఎన్విరాన్‌మెంట్ ఉపయోగించాలనుకుంటే, ముందుగా Python మీ సిస్టమ్‌లో ఇన్‌స్టాల్ అయిందా లేదో `python --version` నడిపి పరీక్షించండి.  



 

టెర్మినల్‌లో `python --version` వంటి పైనథాన్ కమాండ్‌ని అమలు చేస్తున్నప్పుడు, మీ వ్యవస్థలో "ప్రధాన" పైనథాన్‌గా పనిచేస్తున్న ప్రోగ్రామ్‌ని మీరు పరిగణించాలి. ఈ ప్రధాన సంస్థాపనను ఎలాంటి ప్యాకేజీల నుండి ఖాళీగా ఉంచి, ప్రతి అప్లికేషన్‌కు ప్రత్యేకమైన వాతావరణాలను (environments) సృష్టించడం మేము సిఫారసు చేస్తాము. ఇలా చేయడం వల్ల, ప్రతి అప్లికేషన్‌కు అవసరమైన డిపెండెన్సీలు మరియు ప్యాకేజీలు స్వతంత్రంగా ఉంటాయి, మరియు ఇతర అప్లికేషన్లతో సంభవించగల గందరగోళాలను నివారించవచ్చు.

పైనథాన్‌లో దీన్ని **వర్చువల్ ఎన్వైరన్‌మెంట్‌** [*virtual environments*](https://docs.python.org/3/tutorial/venv.html) అనే విధానంతో చేస్తారు. ఇవి ప్రత్యేకమైన డైరెక్టరీలుగా ఉంటాయి, ఇవి ఒక నిర్దిష్ట పైనథాన్ వెర్షన్‌తో పాటు ఆ అప్లికేషన్‌కు అవసరమైన అన్ని ప్యాకేజీలను కలిగి ఉంటాయి. ఇలాంటి వర్చువల్ ఎన్వైరన్‌మెంట్‌ని సృష్టించడానికి అనేక సాధనాలు (tools) అందుబాటులో ఉన్నాయి, కానీ మేము దీనికి అధికారికమైన పైనథాన్ ప్యాకేజీ అయిన [`venv`](https://docs.python.org/3/library/venv.html#module-venv) ను ఉపయోగిస్తాము.

మొదట, మీ అప్లికేషన్ కోసం ఒక కొత్త ఫోల్డర్ సృష్టించాలి. ఉదాహరణకు, మీ హోం డైరెక్టరీలో *transformers-course* అనే ఫోల్డర్‌ను క్రింద చూపిన విధంగా సృష్టించవచ్చు:

```
mkdir ~/transformers-course
cd ~/transformers-course
```

ఈ డైరెక్టరీలో ఉన్నప్పుడు, క్రింది కమాండ్ ఉపయోగించి వర్చువల్ ఎన్వైరన్‌మెంట్‌ను సృష్టించండి:

```
python -m venv .env
```

ఇప్పుడు, మీ ఫోల్డర్‌లో `.env` అనే డైరెక్టరీ కనిపించాలి:

```
ls -a
```

```out
.      ..    .env
```

మీరు వర్చువల్ ఎన్వైరన్‌మెంట్‌లోకి ప్రవేశించడానికి లేదా బయటకు వెళ్లడానికి క్రింది కమాండ్లను ఉపయోగించవచ్చు:

```
# వర్చువల్ ఎన్వైరన్‌మెంట్‌ను సక్రియం చేయడానికి
source .env/bin/activate

# వర్చువల్ ఎన్వైరన్‌మెంట్‌ను డిసేబుల్ చేయడానికి
deactivate
```

మీరు వర్చువల్ ఎన్వైరన్‌మెంట్ సక్రియం అయినదని నిర్ధారించుకోవడానికి, `which python` అనే కమాండ్‌ని అమలు చేయండి. ఇది మీ వర్చువల్ ఎన్వైరన్‌మెంట్‌లోని పైనథాన్‌కు పాయింట్ చేస్తే, మీరు విజయవంతంగా దానిని సక్రియం చేసినట్టే!

```
which python
```

```out
/home/<user>/transformers-course/.env/bin/python
```

### డిపెండెన్సీలను ఇన్‌స్టాల్ చేయడం

గూగుల్ కోలాబ్ ఉపయోగించే పాఠంలో చెప్పిన విధంగానే, ఇప్పుడు మీరు అవసరమైన ప్యాకేజీలను ఇన్‌స్టాల్ చేయాలి. `pip` ప్యాకేజ్ మేనేజర్ ఉపయోగించి, 🤗 Transformers యొక్క డెవలప్‌మెంట్ వెర్షన్‌ను ఇన్‌స్టాల్ చేయవచ్చు:

```
pip install "transformers[sentencepiece]"
```

 

తెలుగు అభిమానం కలిగిన డేటా సైన్స్ & AI విద్యార్థుల కోసం ఈ కోర్సు మరింత సహాయపడుతుందని మేము ఆశిస్తున్నాం. **మన భాషలో నేర్చుకుని, ప్రపంచ స్థాయిలో వెలుగొందండి!** ✨


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/te/chapter0/1.mdx" />