# บทนำ

ยินดีต้อนรับเข้าสู่คอร์ส Hugging Face! ในส่วนเริ่มต้นนี้จะพาคุณติดตั้งโปรแกรมหรือสิ่งแวดล้อมในการทำงาน(หรือเรียกว่า working environment) หากคุณเพิ่งเริ่มคอร์สนี้ เราแนะนำให้คุณไปดู [บทที่ 1](/course/chapter1) ก่อน จากนั้นค่อยกลับมาติดตั้ง environtment เพื่อทดลองโค้ดด้วยตัวเอง

คลังชุดคำสั่ง (หรือเรียกว่า library) ต่าง ๆ ที่ใช้ในคอร์สนี้สามารถใช้เป็นชุดคำสั่งสำเร็จในภาษา Python (หรือเรียกว่า Python package) ได้ทั้งหมด ดังนั้น ในส่วนนี้เราจะแสดงวิธีการติดตั้ง Python environment และลง library ที่จำเป็นทั้งหมด

ในส่วนนี้เราจะแสดงวิธีการติดตั้ง working environment อยู่ทั้งหมดสองวิธี ได้แก่ การใช้ Colab notebook และ การใช้สิ่งแวดล้อมจำลองใน Python (หรือเรียกว่า Python virtual environment) คุณสามารถใช้วิธีใดก็ได้ที่ถนัด สำหรับผู้เริ่มต้นแล้ว เราแนะนำให้ใช้ Colab notebook

อย่างไรก็ตาม ในที่นี้จะไม่ได้แสดงวิธีการติดตั้งสำหรับระบบปฏิบัติการ Windows หากคุณใช้ Windows แนะนำให้ทำตามวิธีการลงด้วย Colab notebook หากคุณใช้ Linux หรือ macOS คุณสามารถทำตามวิธีใดก็ได้

หากคุณจะทำตามตัวอย่างในคอร์สนี้ คุณจำเป็นต้องมีบัญชี Hugging Face หากยังไม่มีบัญชี คุณสามารถ [สร้างบัญชีใหม่ที่นี่](https://huggingface.co/join)


## การใช้งาน Colab notebook (หรือเรียกว่า Google Colab)

การติดตั้งโดยใช้ Colab notebook เป็นวิธีการติดตั้งที่ง่ายที่สุด เพียงแค่คุณเปิดเว็บบราวเซอร์ เช่น Google Chrome, Microsoft Edge, Mozilla Firefox, Brave, หรือ Safari ก็สามารถใช้งานได้เลย

หากคุณยังไม่เคยใช้ Colab เราแนะนำให้คุณเริ่มต้นจาก [แนะนำการใช้งาน Colab](https://colab.research.google.com/notebooks/intro.ipynb) โดย Colab อนุญาตให้คุณใช้ฮาร์ดแวร์เพิ่มความเร็ว เช่น GPU หรือ TPU ได้ฟรีสำหรับงานเล็ก ๆ

เมื่อคุณคุ้นเคยกับการใช้งาน Colab แล้ว มาสร้าง notebook ใหม่กัน ผลจะออกมาหน้าตาเหมือนด้านล่าง:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/new_colab.png" alt="An empty colab notebook" width="80%"/>
</div>

ขั้นตอนต่อไป คือ การติดตั้ง library ที่ต้องใช้งานในคอร์สนี้ โดยเราจะใช้คำสั่ง `pip` ซึ่งเป็นตัวจัดการ package ใน Python เพื่อใช้ในการติดตั้ง โดยใน notebook นั้น คุณสามารถใช้งานคำสั่งระบบได้ด้วยการใส่ตัวอักษร `!` ด้านหน้าคำสั่ง ดังนั้นคุณสามารถติดตั้ง library 🤗 Transformers ด้วยคำสั่งดังต่อไปนี้:

```
!pip install transformers
```

คุณสามารถตรวจสอบว่า คุณติดตั้ง package เรียบร้อยแล้วหรือไม่ด้วยการ import เข้าไปใน Python ด้วยคำสั่งดังต่อไปนี้:

```
import transformers
```

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/install.gif" alt="A gif showing the result of the two commands above: installation and import" width="80%"/>
</div>

ขั้นตอนนี้เป็นการติดตั้ง 🤗 Transformers แบบเวอร์ชั่นเล็กไปก่อน แต่ยังไม่ได้ติดตั้ง framework ใด ๆ ที่เกี่ยวข้องกับ machine learning เช่น PyTorch หรือ TensorFlow เนื่องจากเราต้องใช้ feature ต่าง ๆ ของ library เราจึงแนะนำให้ติดตั้งเวอร์ชันพัฒนาซึ่งมาพร้อมกับ library อื่น ๆ ที่จำเป็น(หรือเรียกว่า dependency) เพื่อให้ครอบคลุมการใช้งานทั้งหมด ด้วยคำสั่งดังต่อไปนี้

```
!pip install transformers[sentencepiece]
```

ขั้นตอนนี้จะใช้เวลานานนิดหน่อย แต่เมื่อจบแล้วก็ถือเป็นอันเสร็จสิ้น คุณพร้อมจะเริ่มใช้งานโค้ดต่าง ๆ ในคอร์สนี้ได้แล้ว!


## การใช้งานสิ่งแวดล้อมจำลองใน Python (หรือเรียกว่า Python virtual environment)

หากคุณถนัดการใช้งาน Python virtual environment มากกว่า ขั้นตอนแรกที่ต้องทำคือการติดตั้ง Python ลงบนเครื่องของคุณ เราแนะนำให้ทำตาม [ขั้นตอนนี้](https://realpython.com/installing-python/)

เมื่อคุณติดตั้ง Python เสร็จเรียบร้อย คุณสามารถรันคำสั่ง Python ที่ terminal ของคุณได้ โดยใช้คำสั่งดังต่อไปนี้: `python --version` หากคำสั่งนี้แสดงผลออกมาเป็น version ของ Python แสดงว่าระบบได้ติดตั้ง Python ลงบนเครื่องของคุณเรียบร้อยแล้วจริง ๆ

เมื่อคุณใช้คำสั่ง Python ที่ terminal เช่น `python --version` ตัวโปรแกรมจะไปเรียก Python "ชุดหลัก"จากระบบของคุณ เราไม่แนะนำให้คุณติดตั้ง package ใด ๆ ลงบน Python "ชุดหลัก" ดังกล่าว แต่ให้ใช้ในการสร้าง environment แยกออกมาในแต่ละการใช้งาน ดังนั้น แต่ละงานจะมี package และ dependency ของตนเอง ทำให้คุณไม่ต้องกังวลกับปัญหาใช้งานไม่ได้เพราะเวอร์ชันไม่ตรงเนื่องจากเวอร์ชันของ library ที่งานหนึ่งไปขัดกับ library เดียวกันที่อีกงานหนึ่ง

สำหรับ Python แล้ว กระบวนการนี้สามารถทำได้โดยใช้ [*virtual environment*](https://docs.python.org/3/tutorial/venv.html) ซึ่งเป็นการเก็บ directory ทั้งหมดในการติดตั้ง package ที่ต้องการในเวอร์ชันที่เราใช้งาน การสร้าง virtual environment สามารถทำได้หลายวิธี แต่เราจะใช้ package อย่างเป็นทางการจาก Python ชื่อว่า [`venv`](https://docs.python.org/3/library/venv.html#module-venv).

ขั้นแรกให้สร้าง directory สำหรับการใช้งาน เช่น หากคุณต้องการสร้าง directory ใหม่ ชื่อว่า *transformer-course* ที่ root ของ home directory สามารถใช้คำสั่งดังต่อไปนี้:

```
mkdir ~/transformers-course
cd ~/transformers-course
```

ภายใน directory นี้ ให้สร้าง virtual environment โดยใช้โมดูล `venv` ด้วยคำสั่งดังต่อไปนี้:

```
python -m venv .env
```

คุณจะพบ directory ชื่อ *.env* ใน directory ที่เคยว่างเปล่าของคุณ ด้วยคำสั่งดังต่อไปนี้:

```
ls -a
```

```out
.      ..    .env
```

คุณสามารถเข้าและออก virtual environment ได้ด้วยคำสั่ง `activate` และ `deactivate` ดังต่อไปนี้:

```
# Activate the virtual environment
source .env/bin/activate

# Deactivate the virtual environment
deactivate
```

คุณสามารถตรวจสอบได้ว่า คุณอยู่ใน environment ใดได้ด้วยคำสั่ง `which python` ระบบจะแสดงผล environment ที่คุณกำลังใช้งานอยู่

```
which python
```

```out
/home/<user>/transformers-course/.env/bin/python
```

### การติดตั้ง dependency

ดังที่แสดงไว้ข้างต้นในส่วนของการใช้งาน Google Colab คุณจำเป็นต้องติดตั้ง package ต่าง ๆ เพื่อให้ใช้งานได้ โดยคุณสามารถติดตั้งเวอร์ชันพัฒนาของ 🤗 Transformers โดยใช้คำสั่ง `pip` ดังต่อไปนี้:

```
pip install "transformers[sentencepiece]"
```

จากนี้ก็เป็นอันเสร็จสิ้น คุณพร้อมสำหรับการเริ่มต้นแล้ว!


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/th/chapter0/1.mdx" />