# คำถามท้ายบท

<CourseFloatingBanner
    chapter={3}
    classNames="absolute z-10 right-0 top-0"
/>

ทดสอบความรู้ที่คุณได้เรียนมาจากบทนี้กัน!

### 1. ใน `emotion` dataset ซึ่งได้รวบรวมข้อความ Twitter ที่มีการ labeled ว่าแต่ละข้อความนั้นเป็นข้อความที่มีอารมณ์แบบใด ลองค้นข้อมูลดูจาก [Hub](https://huggingface.co/datasets)และอ่าน dataset card ดูแล้วตอบว่า ข้อใดไม่ใช่หนึ่งในอารมณ์พื้นฐานของ dataset นี้?

<Question
	choices={[
		{
			text: "Joy",
			explain: "ลองอีกครั้ง — อารมณ์นี้มีอยู่ใน dataset นะ!"
		},
		{
			text: "Love",
			explain: "ลองอีกครั้ง — อารมณ์นี้มีอยู่ใน dataset นะ!"
		},
		{
			text: "Confusion",
			explain: "ถูกต้อง! Confusion ไม่ได้เป็นหนึ่งในหกอารมณ์พื้นฐาน",
            correct: true
		},
        {
			text: "Surprise",
			explain: "Surprise! ยังไม่ถูกนะ ลองใหม่อีกครั้ง!"
		}
	]}
/>

### 2. ลองหาข้อมูล `ar_sarcasm` dataset ใน [Hub](https://huggingface.co/datasets) ดูว่ามันสามารถทำ Task อะไรได้บ้าง?

<Question
	choices={[
		{
			text: "Sentiment classification (การจำแนกอารมณ์ของข้อความ)",
			explain: "ถูกต้องเลย! ดีนะที่อ่าน tags.",
            correct: true
		},
		{
			text: "Machine translation (การแปลภาษา)",
			explain: "ยังไม่ถูกนะ — ลองดูข้อมูลใหม่อีกครั้งที่ <a href='https://huggingface.co/datasets/ar_sarcasm'>dataset card</a>!"
		},
		{
			text: "Named entity recognition (การจำแนกหน่วยย่อยของประโยค)",
			explain: "ยังไม่ถูกนะ — ลองดูข้อมูลใหม่อีกครั้งที่ <a href='https://huggingface.co/datasets/ar_sarcasm'>dataset card</a>!"
		},
        {
			text: "Question answering (การตอบคำถาม)",
			explain: "ตอบคำถามได้ดีแต่ยังไม่ถูกนะ ลองใหม่อีกครั้ง!"
		}
	]}
/>

### 3. โมเดล BERT ต้องการข้อมูลนำเข้า เป็นคู่ประโยคในลักษณะใด?

<Question
	choices={[
		{
			text: "Tokens_of_sentence_1 [SEP] Tokens_of_sentence_2",
			explain: "คุณต้องใส่ Token พิเศษชื่อ <code>[SEP]</code> เพื่อแยกระหว่างคู่ประโยคด้วย แต่แค่นี้ยังไม่ครบถ้วนนะ!"
		},
		{
			text: "[CLS] Tokens_of_sentence_1 Tokens_of_sentence_2",
			explain: "คุณต้องใส่ Token พิเศษชื่อ  <code>[CLS]</code> ไว้ที่ต้นประโยคแรกด้วย แต่แค่นี้ยังไม่ครบถ้วนนะ!"
		},
		{
			text: "[CLS] Tokens_of_sentence_1 [SEP] Tokens_of_sentence_2 [SEP]",
			explain: "ถูกต้อง!",
            correct: true
		},
        {
			text: "[CLS] Tokens_of_sentence_1 [SEP] Tokens_of_sentence_2",
			explain: "คุณต้องใส่ Token พิเศษชื่อ  <code>[CLS]</code> ไว้ที่ต้นประโยคแรก รวมถึง Token พิเศษชื่อ <code>[SEP]</code> เพื่อแยกระหว่างคู่ประโยค แต่แค่นี้ยังไม่ครบถ้วนนะ!"
		}
	]}
/>

{#if fw === 'pt'}
### 4. ข้อใดเป็นประโยชน์ที่ได้จากการใช้เมธอด `Dataset.map()`?

<Question
	choices={[
		{
			text: "มีการเก็บผลลัพธ์ของฟังก์ชั่นไว้ใน cache ทำให้คุณไม่ต้องเสียเวลาเพิ่มเติมหากมีการรันโค้ดใหม่",
			explain: "นั่นเป็นหนึ่งในประโยชน์ของเมธอดนี้จริง ๆ ด้วย! แต่มันไม่ได้มีประโยชน์แค่ข้อนี้ข้อเดียวนะ...",
            correct: true
		},
		{
			text: "มันสามารถใช้ multiprocessing ทำให้ประมวลผลได้เร็วกว่าการใช้ฟังก์ชั่นกับ element แต่ละตัวใน dataset",
			explain: "นั่นก็เป็นหนึ่งในประโยชน์ของเมธอดนี้ แต่มันไม่ได้มีประโยชน์แค่ข้อนี้ข้อเดียวนะ..",
            correct: true
		},
		{
			text: "มันไม่ได้โหลดเอา dataset ทั้งหมดเข้าไปใน memory แต่จะบันทึกผลลัพธ์เมื่อประมวลผล element แต่ละตัวเสร็จ",
			explain: "นั่นก็เป็นหนึ่งในประโยชน์ของเมธอดนี้ แต่มันยังมีประโยชน์ด้านอื่นด้วยนะ!",
            correct: true
		},
	]}
/>

### 5. dynamic padding หมายถึงอะไร?

<Question
	choices={[
		{
			text: "หมายถึงการเติมข้อมูลในแต่ละ batch ให้เท่ากับข้อมูลที่ยาวที่สุดใน dataset",
			explain: "มันมีการเติมข้อมูลในแต่ละ batch นะ แต่ไม่ได้เติมให้เท่ากับข้อมูลที่ยาวที่สุดใน dataset"
		},
		{
			text: "หมายถึงการเติมข้อมูลในแต่ละ batch ให้เท่ากับข้อมูลที่ยาวที่สุดใน batch นั้น",
			explain: "ถูกต้อง! คำว่า \"dynamic\" มีที่มาจากการที่ขนาดของแต่ละ batch นั้นมีความแตกต่างกันและถูกกำหนดเมื่อสร้างแต่ละ batch",
            correct: true
		},
		{
			text: "หมายถึงการเติมข้อมูลเพื่อให้แต่ละประโยคมีจำนวน token เท่ากับประโยคก่อนหน้าใน dataset.",
			explain: "นั่นไม่ถูกต้องนะ และมันก็ไม่สมเหตุสมผลที่จะไปดูข้อมูลของประโยคก่อนหน้า เพราะเราจะมีการ shuffle ข้อมูลระหว่างการเทรนโมเดลด้วย"
		},
	]}
/>

### 6. ข้อใดคือหน้าที่ของฟังก์ชั่น collate?

<Question
	choices={[
		{
			text: "เพื่อทำให้มั่นใจว่าทุก sequences ใน dataset มีความยาวเท่ากัน",
			explain: "ฟังก์ชั่น collate นั้นมีการจัดการเพียงในแต่ละ batch ไม่ได้จัดการทั้ง dataset นอกจากนี้เรากำลังพูดถึงฟังก์ชั่น collate ทั่ว ๆ ไป ไม่ได้เจาะจงถึง <code>DataCollatorWithPadding</code>"
		},
		{
			text: "เพื่อเก็บข้อมูลเข้ามาทำเป็น batch อย่างเหมาะสม",
			explain: "ถูกต้อง! คุณสามารถใส่ฟังก์ชั่น collate เป็นอากิวเมนต์ของ <code>DataLoader</code> เราได้ใช้ฟังก์ชั่น <code>DataCollatorWithPadding</code> ในการเติมข้อมูลทุกตัวใน batch ให้มีความยาวเท่ากัน",
            correct: true
		},
		{
			text: "เพื่อประมวลผลข้อมูลทั้ง dataset.",
			explain: "นั่นเป็นหน้าที่ของฟังก์ชั่นประมวลผล (preprocessing) ไม่ใช่หน้าที่ของฟังก์ชั่น collate"
		},
        {
			text: "เพื่อตัด sequences ทุกตัวใน dataset.",
			explain: "ฟังก์ชั่น collate นั้นมีการจัดการเพียงในแต่ละ batch ไม่ได้จัดการทั้ง dataset และถ้าคุณต้องการตัด (truncating) คุณสามารถใช้อากิวเมนต์ <code>truncate</code> ของ <code>tokenizer</code>."
		}
	]}
/>

### 7. จะเกิดอะไรขึ้นถ้าคุณสร้างออพเจ็กต์ของคลาส `AutoModelForXxx` ตัวหนึ่งซึ่งมี pretrained language model (เช่น `bert-base-uncased`) เพื่อนำไปทำ task ที่แตกต่างไปจาก task ที่เคยเทรนไว้?

<Question
	choices={[
		{
			text: "ไม่มีอะไรเกิดขึ้น แต่คุณจะได้รับข้อความ warning",
			explain: "คุณจะได้ข้อความ warning แต่มันไม่ใช่แค่นั้นนะ!"
		},
		{
			text: "head ของ pretrained model จะถูกตัดทิ้งไป และจะมีการสร้าง head ใหม่ให้เหมาะสมกับ task นั้นขึ้นมาแทนที่",
			explain: "ถูกต้อง ยกตัวอย่างเช่น เมื่อเราใช้ <code>AutoModelForSequenceClassification</code> กับ <code>bert-base-uncased</code> เราจะได้ข้อความ warnings เพราะ pretrained head นั้นไม่ใช้ในการทำ sequence classification มันจึงถูกตัดทิ้งและมีการสร้าง head ใหม่ขึ้นมาแทน โดยกำหนดค่า weights ขึ้นแบบสุ่ม",
            correct: true
		},
		{
			text: "head ของ pretrained model จะถูกตัดทิ้งไป",
			explain: "ยังมีอีกสิ่งหนึ่งที่จะต้องเกิดขึ้นด้วย ลองใหม่อีกครั้งนะ!"
		},
        {
			text: "ไม่มีอะไรเกิดขึ้น เนื่องจากเราสามารถ fine tune โมเดลให้ทำ task ที่ต่างออกไปได้",
			explain: "head ของ pretrained model ไม่ได้ถูกเทรนมาให้ทำ task นี้ เราจึงต้องตัดมันทิ้งไป!"
		}
	]}
/>

### 8. ข้อใดคือหน้าที่ของ `TrainingArguments`?

<Question
	choices={[
		{
			text: "เพื่อเก็บ hyperparameters ทุกตัวที่ใช้ในการเทรนและประเมินผลโมเดลด้วย <code>Trainer</code>",
			explain: "ถูกต้อง!",
            correct: true
		},
		{
			text: "เพื่อกำหนดขนาดของโมเดล",
			explain: "ขนาดของโมเดลนั้นจะถูกกำหนดโดย model configuration ไม่ใช่ <code>TrainingArguments</code>"
		},
		{
			text: "เพื่อเก็บ hyperparameters ที่ใช้ในการประเมินผลโมเดล",
			explain: "ในตัวอย่างเราได้กำหนดว่าจะเก็บโมเดลและ checkpoints ไว้ที่ไหนด้วย ลองใหม่อีกครั้ง!"
		},
        {
			text: "เพื่อเก็บ hyperparameters ที่ใช้ในการเทรนโมเดล",
			explain: "ในตัวอย่างเราได้ใช้ <code>evaluation_strategy</code> ด้วย มันจึงส่งผลต่อการประเมินผลโมเดลด้วย ลองใหม่อีกครั้ง!"
		}
	]}
/>

### 9. ทำไมคุณจึงควรใช้ไลบรารี่ 🤗 Accelerate?

<Question
	choices={[
		{
			text: "เพื่อเรียกใช้โมเดลที่ทำงานได้เร็วกว่า",
			explain: "ไม่ใช่นะ ไลบรารี่ 🤗 Accelerate ไม่มีข้อมูลเกี่ยวกับโมเดลเลย"
		},
		{
			text: "มันมี high-level API ให้ใช้ ฉันจึงไม่ต้องเขียนลูปในการเทรนเอง",
			explain: "ขั้นตอนนั้นเป็นการเรียกใช้ <code>Trainer</code> ไม่ใช่ไลบรารี่ 🤗 Accelerate ลองใหม่อีกครั้ง!"
		},
		{
			text: "ช่วยให้ลูปในการเทรนของคุณใช้การได้กับ distributed setup",
			explain: "ถูกต้อง! การใช้ 🤗 Accelerate จะช่วยให้ลูปในการเทรนของคุณใช้การได้เมื่อต้องเทรนด้วย GPUs หรือ TPUs หลาย ๆ ตัว",
            correct: true
		},
        {
			text: "มันมีฟังก์ชั่น optimization ให้เลือกใช้มากกว่า",
			explain: "ไม่ใช่นะ ไลบรารี่ 🤗 Accelerate ไม่มีฟังก์ชั่น optimization เลย"
		}
	]}
/>

{:else}
### 4. จะเกิดอะไรขึ้นถ้าคุณสร้างออพเจ็กต์ของคลาส `AutoModelForXxx` ตัวหนึ่งซึ่งมี pretrained language model (เช่น `bert-base-uncased`) เพื่อนำไปทำ task ที่แตกต่างไปจาก task ที่เคยเทรนไว้?

<Question
	choices={[
		{
			text: "ไม่มีอะไรเกิดขึ้น แต่คุณจะได้รับข้อความ warning",
			explain: "คุณจะได้ข้อความ warning แต่มันไม่ใช่แค่นั้นนะ!"
		},
		{
			text: "head ของ pretrained model จะถูกตัดทิ้งไป และจะมีการสร้าง head ใหม่ให้เหมาะสมกับ task นั้นขึ้นมาแทนที่",
			explain: "ถูกต้อง ยกตัวอย่างเช่น เมื่อเราใช้ <code>AutoModelForSequenceClassification</code> กับ <code>bert-base-uncased</code> เราจะได้ข้อความ warnings เพราะ pretrained head นั้นไม่ใช้ในการทำ sequence classification มันจึงถูกตัดทิ้งและมีการสร้าง head ใหม่ขึ้นมาแทน โดยกำหนดค่า weights ขึ้นแบบสุ่ม",
            correct: true
		},
		{
			text: "head ของ pretrained model จะถูกตัดทิ้งไป",
			explain: "ยังมีอีกสิ่งหนึ่งที่จะต้องเกิดขึ้นด้วย ลองใหม่อีกครั้งนะ!"
		},
        {
			text: "ไม่มีอะไรเกิดขึ้น เนื่องจากเราสามารถ fine tune โมเดลให้ทำ task ที่ต่างออกไปได้",
			explain: "head ของ pretrained model ไม่ได้ถูกเทรนมาให้ทำ task นี้ เราจึงต้องตัดมันทิ้งไป!"
		}
	]}
/>

### 5. โมเดล TensorFlow จาก `transformers` นั้นเป็นโมเดล Keras อยู่แล้ว การที่เป็นแบบนี้นั้นมีประโยชน์อะไรบ้าง?

<Question
	choices={[
		{
			text: "โมเดลจะทำงานกับ TPU ได้เลยทันที",
			explain: "เกือบแล้ว! มันยังต้องปรับแก้อีกเล็กน้อย ยกตัวอย่างเช่น คุณจะต้องรันทุกอย่างใน <code>TPUStrategy</code> scope รวมถึงการ initialize โมเดลด้วย"
		},
		{
			text: "คุณสามารถใช้ประโยชน์จากเมธอดที่มีอยู่แล้วอย่างเช่น <code>compile()</code>, <code>fit()</code> และ <code>predict()</code>",
			explain: "ถูกต้อง! เมื่อคุณมีข้อมูล การเทรนก็ไม่ยาก แค่ต้องทำงานเพิ่มอีกนิดเดียวเท่านั้น",
            correct: true
		},
		{
			text: "คุณจะได้เรียนวิธีใช้ Keras และ transformers.",
			explain: "ก็ถูกนะ แต่เราอยากได้คำตอบอื่น :)",
			correct: true
		},
        {
			text: "คุณจะสามารถคำนวณ metrics ที่เกี่ยวข้องกับ dataset ได้โดยง่าย",
			explain: "Keras นั้นช่วยในการเทรนและประเมินผลโมเดล แต่ไม่ได้ช่วยคำนวณ metrics ที่เกี่ยวข้องกับ dataset"
		}
	]}
/>

### 6. คุณสามารถสร้าง metric ของคุณเองได้อย่างไร?

<Question
	choices={[
		{
			text: "โดยการสร้างคลาสย่อยของ <code>tf.keras.metrics.Metric</code>.",
			explain: "เยี่ยมเลย!",
			correct: true
		},
		{
			text: "ใช้ Keras functional API.",
			explain: "ลองใหม่อีกครั้ง!"
		},
		{
			text: "โดยการใช้ callable ด้วย signature <code>metric_fn(y_true, y_pred)</code>.",
			explain: "ถูกต้อง!",
			correct: true
		},
        {
			text: "ใช้ google ค้นหาวิธี",
			explain: "นั่นไม่ใช่คำตอบที่เราต้องการนะ แต่มันก็น่าจะช่วยคุณหาวิธีได้จริง ๆ",
			correct: true
		}
	]}
/>

{/if}

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/th/chapter3/6.mdx" />