# Giriş

<CourseFloatingBanner
    chapter={2}
    classNames="absolute z-10 right-0 top-0"
/>

[Birinci bölümde](/course/chapter1) gördüğünüz gibi, Transformer modelleri genellikle oldukça büyüktür. Milyonlarca, hatta milyarlarca, parametreleri olan bu modellerin eğitimi ve üretime geçirilmesi oldukça karmaşık bir girişimdir. Bunun yanısıra, hemen hemen her gün, herbirinin kendine özgü uygulaması olan yeni modellerin yayınlaması, bu yeni modellerinin hepsini birden denemeyi daha da zor bir hale getirmektedir.

🤗 Transformers kütüphanesi bu sorunu çözmek için oluşturuldu. Bu kütüphanenin amacı, herhangi bir Transformer modelini tek bir API (uygulama programı arabirimi) aracılığı ile yükleme, eğitme, ve kaydetmeyi sağlamaktır. Kütüphanenin başlıca özellikleri şunlardır:

- **Kullanım kolaylığı**: En son geliştirilen NLP modellerini indirme, yükleme ve kullanma yalnızca iki satır kod ile yapılabilir.
- **Esneklik**: Bütün modeller temelinde sadece ya PyTorch `nn.Module` ya da TensorFlow `tf.keras.Model` sınıfıdır ve her bir model, ait olduğu kütüphanesindeki diğer herhangi bir model gibi işlenebilir.
- **Sadelik**: Kütüphane içerisinde neredeyse hiç bir soyutlama yapılmamaktadır. “Hersey tek bir dosya içerisinde” ifadesi, kütüphanenin ana kavramını oluşturuyor. Bir modelin “forward pass” aşaması, kodun anlaşılır olması ve kolayca modifiye edilebilmesini sağlamak amacı ile tamamiyle tek bir dosya içerisinde tanımlanır. 

Bu son özellik 🤗 Transformers kütüphanesini diğer makine öğrenmesi kütüphanelerinden oldukça farklı kılmaktadır. Modeller dosyalar arasında paylaşılan modüller üzerinde kurulmamıştır. Bunun yerine, her bir model kendine ait katmanlara sahiptir. Bu özellik, modelleri ulaşılabilir ve anlaşılır hale getirmenin yanısıra, diğer modelleri etkilemeden, tek bir model üzerinde kolayca deneyler yapabilmenize olanak sağlamaktadır.

Bu bölüm, bir model ve simgeleleştirici (tokenizer) kullanarak, birinci bölümde tanıtılan `pipeline()` fonksiyonunun bir kopyasını yapmak için baştan sona (end-to-end) uygulayacağımız bir örnekle başlamaktadır. 
Bunun ardından, kütüphanenin model API’ından bahsedeceğiz: Model ve konfigürasyon sınıflarına detaylıca bakıp, bir modeli nasıl yükleyebileceğinizi ve bir modelin sayısal giriş verilerini nasıl çıkış öngörüleri olarak işlediğini göreceğiz. 

Daha sonra, `pipeline()` fonksiyonunun diğer ana parçası olan simgeleştirici API’ına göz atacağız. Simgeleştiriciler, sinir ağının metni sayısal giriş verilerine ve gerektiğinde bu sayısal verileri tekrar metne dönüştüren ilk ve son işlem aşamalarından sorumludur. Son olarak, birden fazla cümleyi hazır bir grup halinde bir modele nasıl gönderebileceğinizi gösterip, `tokenizer()` fonksiyonuna yakından bakarak bu bölümü tamamlayacağız. 

<Tip>
⚠️ Model Hub ve 🤗 Transformers kütüphanesinde yeralan bütün özelliklerden yararlanabilmeniz icin, <a href="https://huggingface.co/join">bir hesap oluşturmanızı</a> tavsiye ediyoruz.
</Tip>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/tr/chapter2/1.mdx" />