# Chia sẻ các bản demo với người khác

<DocNotebookDropdown
  classNames="absolute z-10 right-0 top-0"
  options={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/vi/chapter9/section4.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/vi/chapter9/section4.ipynb"},
]} />

Bây giờ bạn đã xây dựng một bản demo, có thể bạn sẽ muốn chia sẻ nó với những người khác. Các bản demo Gradio có thể được chia sẻ theo hai cách: sử dụng một ***đường dẫn chia sẻ tạm thời*** hoặc ***lưu trữ vĩnh viễn trên Spaces***.

Chúng tôi sẽ đề cập đến cả hai cách tiếp cận này ngay sau đây. Nhưng trước khi chia sẻ bản demo của mình, bạn có thể muốn đánh bóng nó 💅.

### Đánh bóng Gradio demo của bạn:

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter9/gradio-demo-overview.png" alt="Overview of a gradio interface">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter9/gradio-demo-overview-dark.png" alt="Overview of a gradio interface">
</div>

Để thêm nội dung bổ sung vào bản demo của bạn, lớp `Interface` hỗ trợ một số tham số tùy chọn:
    - `title`: bạn có thể đặt tiêu đề cho bản demo của mình, xuất hiện _phía trên_ các thành phần đầu vào và đầu ra.
    - `description`: bạn có thể đưa ra mô tả (bằng văn bản, Markdown hoặc HTML) cho giao diện, xuất hiện phía trên các thành phần đầu vào và đầu ra và bên dưới tiêu đề.
    - `article`: bạn cũng có thể viết một bài báo mở rộng (bằng văn bản, Markdown hoặc HTML) giải thích về giao diện. Nếu được cung cấp, nó sẽ xuất hiện _bên dưới_ các thành phần đầu vào và đầu ra.
    - `theme`: bạn không thích màu mặc định? Đặt chủ đề để sử dụng một trong các `default`, `huggingface`, `grass`, `peach`. Bạn cũng có thể thêm tiền tố `dark-`, ví dụ: `dark-peach` cho chủ đề tối (hoặc chỉ `dark` cho chủ đề tối mặc định).
    - `examples`: để làm cho bản demo của bạn *dễ sử dụng hơn*, bạn có thể cung cấp một số đầu vào ví dụ cho hàm. Chúng xuất hiện bên dưới các thành phần giao diện người dùng và có thể được sử dụng để điền vào giao diện. Chúng phải được cung cấp dưới dạng danh sách lồng nhau, trong đó danh sách bên ngoài bao gồm các mẫu và mỗi danh sách bên trong bao gồm một đầu vào tương ứng với mỗi thành phần đầu vào.
    - `live`: nếu bạn muốn làm cho bản demo của mình "sống động", nghĩa là mô hình của bạn chạy lại mỗi khi đầu vào thay đổi, bạn có thể đặt `live=True`. Điều này hợp lý khi sử dụng với các mô hình nhanh (chúng ta sẽ xem một ví dụ ở cuối phần này)
Sử dụng các tùy chọn ở trên, chúng ta kết thúc với một giao diện hoàn chỉnh hơn. Chạy đoạn mã dưới đây để bạn có thể trò chuyện với Rick và Morty:

```py
title = "Ask Rick a Question"
description = """
The bot was trained to answer questions based on Rick and Morty dialogues. Ask Rick anything!
<img src="https://huggingface.co/spaces/course-demos/Rick_and_Morty_QA/resolve/main/rick.png" width=200px>
"""

article = "Check out [the original Rick and Morty Bot](https://huggingface.co/spaces/kingabzpro/Rick_and_Morty_Bot) that this demo is based off of."

gr.Interface(
    fn=predict,
    inputs="textbox",
    outputs="text",
    title=title,
    description=description,
    article=article,
    examples=[["What are you doing?"], ["Where should we time travel to?"]],
).launch()
```

Sử dụng các tùy chọn ở trên, chúng ta kết thúc với một giao diện hoàn chỉnh hơn. Hãy thử giao diện bên dưới:

<iframe src="https://course-demos-Rick-and-Morty-QA.hf.space" frameBorder="0" height="800" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

### Chia sẻ bản demo của bạn với các liên kết tạm thời

Bây giờ chúng ta đã có bản demo hoạt động của mô hình học máy của mình, hãy tìm hiểu cách dễ dàng chia sẻ liên kết đến giao diện của chúng ta.
Các giao diện có thể dễ dàng được chia sẻ công khai bằng cách đặt `share=True` trong phương thức `launch()`:

```python
gr.Interface(classify_image, "image", "label").launch(share=True)
```

Điều này tạo ra một liên kết công khai, có thể chia sẻ mà bạn có thể gửi cho bất kỳ ai! Khi bạn gửi liên kết này, người dùng ở phía bên kia có thể dùng thử mô hình trong trình duyệt của họ trong tối đa 72 giờ. Vì quá trình xử lý diễn ra trên thiết bị của bạn (miễn là thiết bị của bạn vẫn bật!), Bạn không phải lo lắng về việc đóng gói bất kỳ thư viện phụ thuộc nào. Nếu bạn đang làm việc với notebook Google Colab, liên kết chia sẻ luôn được tạo tự động. Nó thường trông giống như sau: **XXXXX.gradio.app**. Mặc dù liên kết được cung cấp thông qua liên kết Gradio, ta chỉ là một proxy cho máy chủ cục bộ của mình và không lưu trữ bất kỳ dữ liệu nào được gửi qua các giao diện.

Tuy nhiên, hãy nhớ rằng các liên kết này có thể truy cập công khai, có nghĩa là bất kỳ ai cũng có thể sử dụng mô hình của bạn để dự đoán! Do đó, hãy đảm bảo không để lộ bất kỳ thông tin nhạy cảm nào thông qua các hàm bạn viết hoặc cho phép bất kỳ thay đổi quan trọng nào xảy ra trên thiết bị của bạn. Nếu bạn đặt `share=False` (mặc định), chỉ một liên kết cục bộ được tạo.

### Lưu trữ bản demo của bạn trên Hugging Face Spaces

Một đường dẫn liên kết mà bạn có thể chia sẻ cho các đồng nghiệp thật tuyệt, nhưng làm thế nào bạn có thể lưu trữ vĩnh viễn bản demo của mình và để bản demo tồn tại trong "không gian" riêng của nó trên internet?

Hugging Face Space cung cấp cơ sở hạ tầng để lưu trữ vĩnh viễn mô hình Gradio của bạn trên internet, **miễn phí**! Spaces cho phép bạn tạo và đẩy lên kho (công khai hoặc riêng tư), nơi giao diện Gradio của bạn sẽ tồn tại trong tệp `app.py`. [Đọc hướng dẫn từng bước](https://huggingface.co/blog/gradio-spaces) để bắt đầu hoặc xem video ví dụ bên dưới.

<Youtube id="LS9Y2wDVI0k" />

## ✏️ Cùng áp dụng nhé!

Sử dụng những gì chúng ta vừa học được trong các phần cho đến nay, hãy tạo bản demo nhận dạng phác thảo mà ta đã thấy trong [phần một của chương này](/course/chapter9/1). Hãy thêm một số tùy chỉnh vào giao diện và đặt `share=True` để tạo một liên kết công khai mà ta có thể chia sẻ.

Chúng ra có thể tải các nhãn từ [class_names.txt](https://huggingface.co/spaces/dawood/Sketch-Recognition/blob/main/class_names.txt) và tải mô hình pytorch được huấn luyện trước từ [pytorch_model.bin] (https://huggingface.co/spaces/dawood/Sketch-Recognition/blob/main/pytorch_model.bin). Tải xuống các tệp này bằng cách nhấp vào liên kết và nhấp vào tải xuống ở góc trên cùng bên trái của bản xem trước tệp. Hãy xem đoạn mã bên dưới để biết cách chúng ta sử dụng các tệp này để tải mô hình của mình và tạo hàm `predict()`:

```py
from pathlib import Path
import torch
import gradio as gr
from torch import nn

LABELS = Path("class_names.txt").read_text().splitlines()

model = nn.Sequential(
    nn.Conv2d(1, 32, 3, padding="same"),
    nn.ReLU(),
    nn.MaxPool2d(2),
    nn.Conv2d(32, 64, 3, padding="same"),
    nn.ReLU(),
    nn.MaxPool2d(2),
    nn.Conv2d(64, 128, 3, padding="same"),
    nn.ReLU(),
    nn.MaxPool2d(2),
    nn.Flatten(),
    nn.Linear(1152, 256),
    nn.ReLU(),
    nn.Linear(256, len(LABELS)),
)
state_dict = torch.load("pytorch_model.bin", map_location="cpu")
model.load_state_dict(state_dict, strict=False)
model.eval()


def predict(im):
    x = torch.tensor(im, dtype=torch.float32).unsqueeze(0).unsqueeze(0) / 255.0
    with torch.no_grad():
        out = model(x)
    probabilities = torch.nn.functional.softmax(out[0], dim=0)
    values, indices = torch.topk(probabilities, 5)
    return {LABELS[i]: v.item() for i, v in zip(indices, values)}
```

Giờ ta đã có hàm `predict()`. Bước tiếp theo là định nghỉa và khởi chạy giao diện gradio:

```py
interface = gr.Interface(
    predict,
    inputs="sketchpad",
    outputs="label",
    theme="huggingface",
    title="Sketch Recognition",
    description="Who wants to play Pictionary? Draw a common object like a shovel or a laptop, and the algorithm will guess in real time!",
    article="<p style='text-align: center'>Sketch Recognition | Demo Model</p>",
    live=True,
)
interface.launch(share=True)
```

<iframe src="https://course-demos-Sketch-Recognition.hf.space" frameBorder="0" height="650" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

Lưu ý tham số `live=True` trong `Interface`, có nghĩa là bản demo phác thảo tạo ra dự đoán mỗi khi ai đó vẽ trên sketchpad (không có nút gửi!).

Hơn nữa, chúng ta cũng đặt tham số `share=True` trong phương thức `launch()`.
Điều này sẽ tạo ra một liên kết công khai mà bạn có thể
gửi cho bất cứ ai! Khi bạn gửi liên kết này, người dùng ở phía bên kia có thể thử mô hình nhận dạng phác thảo. Để nhắc lại, bạn cũng có thể tổ chức mô hình trên Hugging Face Spaces, đó là cách chúng ta có thể nhúng bản demo ở trên.

Tiếp theo, chúng tôi sẽ đề cập đến các cách khác mà Gradio có thể được sử dụng với hệ sinh thái Hugging Face!


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/vi/chapter9/4.mdx" />