# 自然语言处理 [[自然语言处理]]

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

在深入了解 Transformer 模型之前，让我们快速回顾一下自然语言处理是什么以及它为什么如此重要。

## 什么是自然语言处理？[[什么是自然语言处理？]] 

NLP 是语言学和机器学习交叉领域，专注于理解与人类语言相关的一切。NLP 任务的目标不仅是单独理解单个单词，而且是能够理解这些单词的上下文。

以下是常见 NLP 任务的列表，每个任务都有一些示例：

- **对整个句子进行分类**：获取评论的情感，检测电子邮件是否为垃圾邮件，确定句子在语法上是否正确或两个句子在逻辑上是否相关。
- **对句子中的每个词进行分类**：识别句子的语法成分（名词、动词、形容词）或命名实体（人、地点、组织）。
- **生成文本内容**：用自动生成的文本完成提示，用掩码词填充文本中的空白。
- **从文本中提取答案**：给定问题和上下文，根据上下文中提供的信息提取问题的答案。
- **从输入文本生成新句子**：将文本翻译成另一种语言，对文本进行总结。

NLP 不仅限于书面文本。它还解决了语音识别和计算机视觉中的复杂挑战，例如生成音频样本的转录或图像的描述。
## 为什么具有挑战性？[[为什么具有挑战性？]]

计算机处理信息的方式与人类不同。例如，当我们读到“我饿了”这句话时，我们很容易理解它的意思。同样，给定两个句子，例如“我很饿”和“我很伤心”，我们可以轻松确定它们的相似程度。对于机器学习 （ML） 模型，此类任务更加困难。文本需要以一种使模型能够从中学习的方式进行处理。而且由于语言的复杂性，我们很难直接设计算法来处理此类问题。已经有很多关于如何表示文本的研究，我们将在下一章中介绍一些方法。

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-CN/chapter1/2.mdx" />