# 如何写一个好问题 [[如何写一个好问题]]

<DocNotebookDropdown
  classNames="absolute z-10 right-0 top-0"
  options={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/chapter8/section5.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/chapter8/section5.ipynb"},
]} />

当你在使用 Hugging Face 库时遇到了不正常的情况，你应该及时告诉我们，这样我们才能修复它（对于任何开源库都是一样）。如果你不确定 bug 是在你自己的代码中还是在我们的库中，首先可以在 [论坛](https://discuss.huggingface.co) 进行搜索。论坛中的帖子有可能会帮助你找出问题所在，同时Hugging Face 团队也会密切关注那里的讨论。

<Youtube id="_PAli-V4wj0"/>

当你确定手头上有一个 bug 时，第一步是构建一个最小可复现的示例。

## 创建一个最小的可重现示例 [[创建一个最小的可重现示例]]

创建一个最小可复现的示例非常重要，因为 Hugging Face 团队中没有人是魔术师（至少目前还没有），他们不能修复他们看不到的问题。一个最小可复现的示例应该是可复现的，这意味着它不应依赖于你可能有的任何外部文件或数据。尝试用一些看起来像真实数据的虚拟值替换你正在使用的数据，并且仍然产生相同的错误。

<Tip>

🚨🤗 Transformers 仓库中有很多未解决的问题，因为无法访问复现这些问题的数据。

</Tip>

在创建了一个包含所遇见的问题示例后，你可以尝试将其进一步简化，构建我们所说的“最小可复现示例”。虽然这需要你多做一些工作，但如果你提供了一个简洁明了的 bug 复现，那么几乎可以肯定会得到帮助和修复。

如果你感觉足够自信，可以检查一下你的 bug 发生的源代码。你可能会找到解决问题的方法（在这种情况下，你甚至可以发起一个修复它的 pull request 请求），但更一般地说，这可以帮助维护人员在阅读你的报告时更好地理解源代码。

## 填写问题模板 [[填写问题模板]]

当你提交问题时，需要填写一个模板。我们将在这里遵循 [🤗 Transformers issues](https://github.com/huggingface/transformers/issues/new/choose) 的模板，但如果你在其他仓库中报告问题，也需要提供相同类型的信息。请不要将模板留空，花时间填写模板将最大程度地增加你得到答案和解决问题的机会。

一般来说，当提交问题时，要保持礼貌。这是一个开源项目，所以你使用的是免费软件，没有人有义务帮助你。你可以在你的问题中包含你认为合理的批评，但维护者可能会对此感到不满，从而拒绝立即提供帮助。确保你阅读了该项目的 [行为准则](https://github.com/huggingface/transformers/blob/main/CODE_OF_CONDUCT.md) 。

### 提供环境信息 [[提供环境信息]]

🤗 Transformers 提供了一个实用程序来获取有关于你环境的所有信息。只需在终端中输入以下内容：

```
transformers-cli env
```

将得到以下输出：

```out
Copy-and-paste the text below in your GitHub issue and FILL OUT the two last points.

- `transformers` version: 4.12.0.dev0
- Platform: Linux-5.10.61-1-MANJARO-x86_64-with-arch-Manjaro-Linux
- Python version: 3.7.9
- PyTorch version (GPU?): 1.8.1+cu111 (True)
- Tensorflow version (GPU?): 2.5.0 (True)
- Flax version (CPU?/GPU?/TPU?): 0.3.4 (cpu)
- Jax version: 0.2.13
- JaxLib version: 0.1.65
- Using GPU in script?: <fill in>
- Using distributed or parallel set-up in script?: <fill in>
```

如果你在 notebook 单元执行它，你还需要在 `transformers-cli env` 命令开始前添加一个 `!` ，然后把结果复制到你问题帖子的开头。

### 标记相关人员 [[标记相关人员]]

使用 `@` 后跟上 GitHub 用户名来标记他人，可以向他们发送通知，这样他们就会看到你的问题来尽可能更快地回复你。如果你标记的人与你的问题没有直接联系请谨慎使用，因为他们可能不喜欢收到通知。如果你查看了与你的错误相关的源文件，就应该标记上一次对你认为造成问题的行进行修改的人（可以在 GitHub 上查看该行，选择它然后点击 “View git blame”来找到这些信息）。

如果没有进行标记，那么我们的模板会自动提供要标记的人的建议。一般不要标记超过三个人。

### 包含一个可重复的示例 [[包含一个可重复的示例]]

如果你已经创建了一个产生错误的独立示例，请键入一行包含三个反引号，后跟 `python` ，像这样：

```
```python  
```

然后粘贴你的最小可复现示例，并在新的一行上输入三个反引号。这将就会将代码格式化并且高亮以提高代码的可读性。

如果你没有成功创建一个可复现的示例，清楚地描述你遇到问题的步骤。如果可以的话，包括一个你遇到错误的 Google Colab 笔记本的链接。你分享的信息越多，维护者就更有可能回复你。

解决问题的线索可能在错误信息的不同位置，因此在任何情况下都应该复制并粘贴收到的整个错误消息。如果在 Google Colab 中工作，则要记住堆栈跟踪可能会自动折叠，因此请确保在复制之前将其展开。与代码示例一样，将该错误消息放在带有三个反引号的两行之间。

### 描述预期行为 [[描述预期行为]]

用几句话描述代码正确运行时预期的效果，有助于维护者完全理解问题。预期的效果在解决错误问题的帖子中通常会很明显，可以用一句话来概括，但在某些情况下可能需要描述很多内容。

## 提交？[[提交？]]

在提交问题后，请快速检查一遍提交的帖子是否是正确的。如果出现错误，你可以重新编辑问题，如果发现问题与最初的想法不同，甚至可以更改标题。

即使没有很快得到答案，也不要很急切地去提醒别人。如果几天内没有人提供帮助，那么很可能没有人能理解我们的问题，不要犹豫，回到可复现的示例。修改一下，让它更加简洁明了。如果在一周内没有得到答复，那么可以温和地留言寻求帮助，特别是你已经修改过，添加了更多有效信息的问题。

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-CN/chapter8/5.mdx" />