# Gradio 简介 [[Gradio 简介]]

在本章中，我们将学习如何为你的机器学习模型构建**交互式的演示**。

首先，为什么要为你的机器学习模型构建演示？

- **机器学习开发人员**可以轻松地向包括非技术团队或客户在内的广大受众展示他们的工作
- **研究人员**更轻松地重现机器学习模型和效果
- **质量测试人员**或**最终用户**更容易发现和调试模型的故障点
- **不同的用户**发现模型中的算法偏差

我们将使用 Gradio 库为我们的模型构建演示。通过 Gradio 你完全使用 Python 为任何机器学习模型构建、自定义和共享基于 Web 的演示。

以下是一些使用 Gradio 构建的机器学习演示的示例：

* 一个**草图识别**模型，可以使用鼠标或者触控输入草图，它会输出正在绘制草图
的类别：

<iframe src="https://course-demos-draw2.hf.space" frameBorder="0" height="450" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

* 一个**抽取式问答**模型，它可以输入一段材料和一个问题，输出从这段话中找到的问题的答案和一个概率分数（我们在 [第七章](/course/chapter7/7) 中讨论过这种模型）：

<iframe src="https://course-demos-question-answering-simple.hf.space" frameBorder="0" height="640" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

* 一个**背景去除**模型，它可以输入一张图像，并返回去除背景的图像：

<iframe src="https://course-demos-remove-bg-original.hf.space" frameBorder="0" height="640" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

本章分为两个部分，包括 `基础概念` 和 `应用示例` 。在了解每个部分的概念后，你可以使用它来构建不同类型的演示，从图像分类到语言模型再到到语音识别。当你读完本章时，你就能够仅用几行 Python 代码构建这些演示并且可以根据需要定制和修改Web演示。

👀 点击 [Hugging Face Spaces](https://huggingface.co/spaces) 就可以查看机器学习社区构建最新的许多机器学习演示示例！


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-CN/chapter9/1.mdx" />