# 本章簡介

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

## 歡迎來到🤗教學

<Youtube id="00GKzGyWFEs" />

本教學將使用 Hugging Face 生態系統中的庫——🤗 Transformers、🤗 Datasets、🤗 Tokenizers 和 🤗 Accelerate——以及 Hugging Face Hub 教你自然語言處理 (NLP)。它是完全免費的，並且沒有廣告。


## 有什麼是值得期待的？

以下是課程的簡要概述：

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/summary.svg" alt="Brief overview of the chapters of the course."/>
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/summary-dark.svg" alt="Brief overview of the chapters of the course."/>
</div>

- 第 1 章到第 4 章介紹了 🤗 Transformers 庫的主要概念。在本課程的這一部分結束時，您將熟悉 Transformer 模型的工作原理，並將瞭解如何使用 [Hugging Face Hub](https://huggingface.co/models) 中的模型，在數據集上對其進行微調，並在 Hub 上分享您的結果。
- 第 5 章到第 8 章在深入研究經典 NLP 任務之前，教授 🤗 Datasets和 🤗 Tokenizers的基礎知識。在本部分結束時，您將能夠自己解決最常見的 NLP 問題。
- 第 9 章到第 12 章更加深入，探討瞭如何使用 Transformer 模型處理語音處理和計算機視覺中的任務。在此過程中，您將學習如何構建和分享模型，並針對生產環境對其進行優化。在這部分結束時，您將準備好將🤗 Transformers 應用於（幾乎）任何機器學習問題！

這個課程：

* 需要良好的 Python 知識 
* 最好先學習深度學習入門課程，例如[DeepLearning.AI](https://www.deeplearning.ai/) 提供的 [fast.ai實用深度學習教程](https://course.fast.ai/) 
* 不需要事先具備 [PyTorch](https://pytorch.org/) 或 [TensorFlow](https://www.tensorflow.org/) 知識，雖然熟悉其中任何一個都會對huggingface的學習有所幫助

完成本課程後，我們建議您查看 [DeepLearning.AI的自然語言處理系列課程](https://www.coursera.org/specializations/natural-language-processing?utm_source=deeplearning-ai&utm_medium=institutions&utm_campaign=20211011-nlp-2-hugging_face-page-nlp-refresh)，其中涵蓋了廣泛的傳統 NLP 模型，如樸素貝葉斯和 LSTM，這些模型非常值得瞭解！

## 我們是誰？

關於作者：

**Matthew Carrigan** 是 Hugging Face 的機器學習工程師。他住在愛爾蘭都柏林，之前在 Parse.ly 擔任機器學習工程師，在此之前，他在Trinity College Dublin擔任博士後研究員。他不相信我們會通過擴展現有架構來實現 AGI，但無論如何都對機器人充滿希望。

**Lysandre Debut** 是 Hugging Face 的機器學習工程師，從早期的開發階段就一直致力於 🤗 Transformers 庫。他的目標是通過使用非常簡單的 API 開發工具，讓每個人都可以使用 NLP。

**Sylvain Gugger** 是 Hugging Face 的一名研究工程師，也是 🤗Transformers庫的核心維護者之一。此前，他是 fast.ai 的一名研究科學家，他與Jeremy Howard 共同編寫了[Deep Learning for Coders with fastai and Py Torch](https://learning.oreilly.com/library/view/deep-learning-for/9781492045519/)。他的主要研究重點是通過設計和改進允許模型在有限資源上快速訓練的技術，使深度學習更容易普及。

**Merve Noyan** 是 Hugging Face 的開發者倡導者，致力於開發工具並圍繞它們構建內容，以使每個人的機器學習平民化。

**Lucile Saulnier** 是 Hugging Face 的機器學習工程師，負責開發和支持開源工具的使用。她還積極參與了自然語言處理領域的許多研究項目，例如協作訓練和 BigScience。

**Lewis Tunstall**  是 Hugging Face 的機器學習工程師，專注於開發開源工具並使更廣泛的社區可以使用它們。他也是即將出版的一本書[O’Reilly book on Transformers](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/)的作者之一。

**Leandro von Werra**  是 Hugging Face 開源團隊的機器學習工程師，也是即將出版的一本書[O’Reilly book on Transformers](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/)的作者之一。他擁有多年的行業經驗，通過在整個機器學習堆棧中工作，將 NLP 項目投入生產。

你準備好了嗎？在本章中，您將學習：
* 如何使用 `pipeline()` 函數解決文本生成、分類等NLP任務
* 關於 Transformer 架構
* 如何區分編碼器、解碼器和編碼器-解碼器架構和用例 


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-TW/chapter1/1.mdx" />